/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.gui.awt;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.MicsElement;

public class MemoryLoader
implements ActionListener {
    private Frame frame = new Frame();
    private TextField offsetField;
    private TextField fileField;
    private Button btnOK;
    private Button btnCancel;
    private Button btnFile;
    private DataBuffer memory;
    private static MemoryLoader instance = new MemoryLoader();

    public static MemoryLoader getInstance() {
        return instance;
    }

    private MemoryLoader() {
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MemoryLoader.this.frame.setVisible(false);
            }
        });
        Panel panel = new Panel(new BorderLayout());
        TextField textField = new TextField("offset");
        this.offsetField = new TextField("0", 10);
        textField.setEditable(false);
        panel.add((Component)textField, "West");
        panel.add((Component)this.offsetField, "Center");
        this.frame.add((Component)panel, "North");
        panel = new Panel(new BorderLayout());
        this.fileField = new TextField(30);
        this.fileField.setEditable(false);
        this.btnFile = new Button("File");
        this.btnFile.addActionListener(this);
        panel.add((Component)this.fileField, "Center");
        panel.add((Component)this.btnFile, "East");
        this.frame.add((Component)panel, "Center");
        panel = new Panel();
        this.btnOK = new Button("OK");
        this.btnOK.addActionListener(this);
        panel.add((Component)this.btnOK, "West");
        this.btnCancel = new Button("Cancel");
        this.btnCancel.addActionListener(this);
        panel.add((Component)this.btnCancel, "West");
        this.frame.add((Component)panel, "South");
        this.frame.pack();
        this.frame.setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != null) {
            if (object == this.btnFile) {
                FileDialog fileDialog = new FileDialog(this.frame, "Open", 0);
                fileDialog.setVisible(true);
                if (fileDialog.getFile() != null) {
                    File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
                    this.fileField.setText(file.getAbsolutePath());
                }
            } else if (object == this.btnOK) {
                if (this.fileField.getText().equals("")) {
                    System.out.println("File is not selected.");
                    return;
                }
                int n = 0;
                try {
                    n = Integer.parseInt(this.offsetField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Illegal offset.");
                    return;
                }
                try {
                    if (this.memory != null) {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(this.fileField.getText())));
                        this.memory.write(n, bufferedInputStream);
                    }
                }
                catch (DataBufferException dataBufferException) {
                    System.out.println(dataBufferException.getMessage());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println(fileNotFoundException.getMessage());
                }
                this.discard();
                System.out.println("write succeeded. src=" + this.fileField.getText() + "," + " offset=" + n);
            } else if (object == this.btnCancel) {
                this.discard();
            }
        }
    }

    public void discard() {
        this.memory = null;
        this.frame.setVisible(false);
    }

    public void show(DataBuffer dataBuffer) {
        this.memory = dataBuffer;
        this.frame.setTitle("RandomAccessMemory (ID=" + ((MicsElement)((Object)dataBuffer)).id() + ")");
        this.frame.setVisible(true);
    }
}

