/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.gui.awt;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import net.wasamon.mics.Mics;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsPrompt;
import net.wasamon.mics.MicsShell;
import net.wasamon.mics.gui.MicsArchitectureViewer;
import net.wasamon.mics.gui.awt.AWTArchitectureViewer;
import net.wasamon.mics.tools.AsciiToBinary;
import net.wasamon.mjlib.ui.AWTOptionPane;
import net.wasamon.mjlib.ui.TextAreaOutputStream;

public class MicsAWTWindow
implements MicsShell,
ActionListener {
    private static MicsAWTWindow instance = new MicsAWTWindow();
    private Frame frame = new Frame("Mics " + Mics.printVersion());
    private TextArea log;
    private TextField input;
    private Button btnStep;
    private Button btnRun;
    private Button btnStop;
    private Button btnReset;
    private Button btnLoad;
    private TextField stepNumber;
    private MenuItem openMenuItem;
    private MenuItem viewMenuItem;
    private MenuItem exitMenuItem;
    private MenuItem a2bMenuItem;

    public static MicsAWTWindow getInstance() {
        return instance;
    }

    private void exit(int n) {
        Mics.getInstance().shutdown(n);
    }

    private MicsAWTWindow() {
        this.frame.setSize(640, 540);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MicsAWTWindow.this.exit(0);
            }
        });
        this.frame.setMenuBar(this.getMenuBar());
        this.frame.add((Component)this.getToolBar(), "North");
        this.log = new TextArea();
        this.log.setFont(new Font("MonoSpaced", 0, 12));
        this.log.setEditable(false);
        this.log.setBackground(Color.WHITE);
        this.frame.add((Component)this.log, "Center");
        PrintStream printStream = new PrintStream(new TextAreaOutputStream(this.log), true);
        System.setOut(printStream);
        System.setErr(printStream);
        TextField textField = new TextField("[command]");
        textField.setEditable(false);
        this.input = new TextField();
        this.input.addActionListener(this);
        Panel panel = new Panel(new BorderLayout());
        panel.add((Component)textField, "West");
        panel.add(this.input);
        this.frame.add((Component)panel, "South");
        this.frame.setVisible(false);
    }

    private Panel getToolBar() {
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 5));
        this.btnReset = new Button("Reset");
        this.btnReset.addActionListener(this);
        this.btnStep = new Button("Step");
        this.btnStep.addActionListener(this);
        this.stepNumber = new TextField("1", 3);
        this.stepNumber.addActionListener(this);
        this.btnRun = new Button("Run");
        this.btnRun.addActionListener(this);
        this.btnStop = new Button("Stop");
        this.btnStop.addActionListener(this);
        panel2.add(this.btnReset);
        panel2.add(this.btnRun);
        panel2.add(this.btnStop);
        panel2.add(this.btnStep);
        panel2.add(this.stepNumber);
        this.setMicsEngineEnableState(true);
        panel.add(panel2);
        return panel;
    }

    public void setLogField(TextArea textArea) {
        this.log = textArea;
    }

    private MenuBar getMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        this.exitMenuItem = new MenuItem("Exit", new MenuShortcut(88));
        this.exitMenuItem.addActionListener(this);
        menu.add(this.exitMenuItem);
        menuBar.add(menu);
        menu = new Menu("Architecture");
        this.openMenuItem = new MenuItem("Load");
        this.openMenuItem.addActionListener(this);
        menu.add(this.openMenuItem);
        this.viewMenuItem = new MenuItem("View");
        this.viewMenuItem.addActionListener(this);
        menu.add(this.viewMenuItem);
        menuBar.add(menu);
        menu = new Menu("Tools");
        this.a2bMenuItem = new MenuItem("Ascii to Binary");
        this.a2bMenuItem.addActionListener(this);
        menu.add(this.a2bMenuItem);
        menuBar.add(menu);
        return menuBar;
    }

    public void exec() {
        this.frame.setVisible(true);
    }

    public void exec(File file) {
        this.exec();
    }

    public void setMicsEngineEnableState(boolean bl) {
        if (bl) {
            this.btnStep.setEnabled(true);
            this.btnReset.setEnabled(true);
            this.btnRun.setEnabled(true);
            this.btnStop.setEnabled(false);
        } else {
            this.btnStep.setEnabled(false);
            this.btnReset.setEnabled(false);
            this.btnRun.setEnabled(false);
            this.btnStop.setEnabled(true);
        }
    }

    public File openFile(String string, FilenameFilter filenameFilter) {
        File file = null;
        FileDialog fileDialog = new FileDialog(this.frame, string, 0);
        fileDialog.setFilenameFilter(filenameFilter);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            file = new File(fileDialog.getDirectory(), fileDialog.getFile());
        }
        return file;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.input) {
            try {
                MicsPrompt.execLine(((TextField)object).getText());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ((TextField)object).setText("");
        } else if (object == this.openMenuItem || object == this.btnLoad) {
            File file = this.openFile("Open Config File", new MicsConfigFileFilter());
            if (file != null) {
                try {
                    Mics.getInstance().configTargetArchitecture(file);
                }
                catch (Exception exception) {
                    AWTOptionPane.showErrorDialog(this.frame, "configuration error", exception + ":" + exception.getMessage());
                    exception.printStackTrace();
                }
                Mics.getInstance().engine().show();
            }
        } else if (object == this.exitMenuItem) {
            this.exit(0);
        } else if (object == this.a2bMenuItem) {
            File file = this.openFile("Open", null);
            if (file != null) {
                try {
                    AsciiToBinary asciiToBinary = new AsciiToBinary();
                    File file2 = asciiToBinary.parser(file);
                    System.out.println("compile succeeded: " + file2.getAbsolutePath());
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println(numberFormatException.getMessage());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("no such file: " + file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    System.out.println("File I/O error");
                }
            }
        } else if (object == this.btnRun) {
            this.setMicsEngineEnableState(false);
            Mics.getInstance().execEngine();
        } else if (object == this.btnStop) {
            Mics.getInstance().stopEngine();
            this.setMicsEngineEnableState(true);
        } else if (object == this.btnStep) {
            try {
                int n = 1;
                try {
                    n = Integer.parseInt(this.stepNumber.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    n = 1;
                    this.stepNumber.setText("1");
                }
                if (n < 1) {
                    n = 1;
                    this.stepNumber.setText("1");
                }
                Mics.getInstance().execStepByStep(n);
            }
            catch (MicsException micsException) {
                System.out.println(micsException);
            }
        } else if (object == this.btnReset) {
            try {
                Mics.getInstance().reset();
            }
            catch (MicsException micsException) {
                System.out.println(micsException);
            }
        } else if (object == this.viewMenuItem) {
            if (Mics.getInstance().engine() != null) {
                Mics.getInstance().engine().show();
            }
        } else {
            System.out.println("Uninitialized as architecture config.");
        }
    }

    public MicsArchitectureViewer getMicsArchitectureViewerData(MicsCompositeElement micsCompositeElement) {
        return new AWTArchitectureViewer(micsCompositeElement);
    }

    class ConfigDataSourceFilter
    implements FilenameFilter {
        ConfigDataSourceFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".context");
        }
    }

    class CoinsInputFilter
    implements FilenameFilter {
        CoinsInputFilter() {
        }

        public boolean accept(File file, String string) {
            if (string.endsWith(".c")) {
                return true;
            }
            if (string.endsWith(".i")) {
                return true;
            }
            return string.endsWith(".lir");
        }
    }

    class SimpleProcessorAssemblerFilter
    implements FilenameFilter {
        SimpleProcessorAssemblerFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".s");
        }
    }

    class MicsConfigFileFilter
    implements FilenameFilter {
        MicsConfigFileFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".xml");
        }
    }
}

