/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.gui.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.Mics;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.gui.awt.MemoryLoader;

public class ArchitectureList
implements TreeSelectionListener,
ActionListener {
    private static ArchitectureList instance = new ArchitectureList();
    private JFrame frame = new JFrame("Architecture Viewer");
    private JTree tree;
    private JButton btnLoad;
    private JButton btnView;

    public static ArchitectureList getInstance() {
        return instance;
    }

    private ArchitectureList() {
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ArchitectureList.this.frame.setVisible(false);
            }
        });
        this.frame.setBounds(10, 10, 640, 240);
        this.frame.getContentPane().add((Component)this.getToolBar(), "North");
        JScrollPane jScrollPane = new JScrollPane();
        this.tree = new JTree(this.makeArchitectureTree());
        this.tree.addTreeSelectionListener(this);
        jScrollPane.getViewport().setView(this.tree);
        this.frame.getContentPane().add((Component)jScrollPane, "Center");
    }

    private TreeModel makeArchitectureTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Mics");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("ExecutableElement");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("DataBuffer");
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Channel");
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("ChannelConnectable");
        MicsElement[] micsElementArray = Mics.getInstance().getMicsElementArray();
        for (int i = 0; i < micsElementArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode6;
            MicsElement micsElement = micsElementArray[i];
            String string = micsElement.getClass().getName();
            if (micsElement instanceof DataBuffer) {
                defaultMutableTreeNode6 = new DefaultMutableTreeNode(micsElement.id() + ":" + string);
                defaultMutableTreeNode3.add(defaultMutableTreeNode6);
            }
            if (micsElement instanceof Channel) {
                defaultMutableTreeNode6 = new DefaultMutableTreeNode(micsElement.id() + ":" + string);
                defaultMutableTreeNode4.add(defaultMutableTreeNode6);
            }
            if (micsElement instanceof ExecutableElement) {
                defaultMutableTreeNode6 = new DefaultMutableTreeNode(micsElement.id() + ":" + string);
                defaultMutableTreeNode2.add(defaultMutableTreeNode6);
            }
            if (!(micsElement instanceof ChannelConnectable)) continue;
            defaultMutableTreeNode6 = new DefaultMutableTreeNode(micsElement.id() + ":" + string);
            defaultMutableTreeNode5.add(defaultMutableTreeNode6);
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    private MicsElement getSelectedElement() {
        TreePath treePath = this.tree.getSelectionPath();
        MicsElement micsElement = null;
        if (treePath == null) {
            return null;
        }
        if (treePath.getPath().length < 3) {
            return null;
        }
        String string = treePath.getLastPathComponent().toString();
        String[] stringArray = string.split(":");
        if (stringArray.length < 2) {
            return null;
        }
        try {
            micsElement = Mics.getInstance().engine().getMicsElement(stringArray[0]);
        }
        catch (MicsException micsException) {
            return null;
        }
        return micsElement;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        MicsElement micsElement = this.getSelectedElement();
        if (micsElement != null) {
            System.out.println(micsElement.getInfo());
            if (micsElement instanceof DataBuffer) {
                this.btnLoad.setEnabled(true);
            } else {
                this.btnLoad.setEnabled(false);
            }
            if (micsElement instanceof MicsViewable) {
                this.btnView.setEnabled(true);
            } else {
                this.btnView.setEnabled(false);
            }
        } else {
            this.btnView.setEnabled(false);
            this.btnLoad.setEnabled(false);
        }
    }

    private JToolBar getToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.btnLoad = new JButton("Load");
        this.btnLoad.addActionListener(this);
        jToolBar.add(this.btnLoad);
        this.btnView = new JButton("View");
        this.btnView.addActionListener(this);
        jToolBar.add(this.btnView);
        return jToolBar;
    }

    public void update() {
        this.tree.setModel(this.makeArchitectureTree());
    }

    public void show() {
        this.update();
        this.frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != null) {
            MicsElement micsElement;
            if (object == this.btnView) {
                MicsElement micsElement2 = this.getSelectedElement();
                if (micsElement2 != null && micsElement2 instanceof MicsViewable) {
                    ((MicsViewable)((Object)micsElement2)).show();
                }
            } else if (object == this.btnLoad && (micsElement = this.getSelectedElement()) != null && micsElement instanceof DataBuffer) {
                MemoryLoader.getInstance().show((DataBuffer)((Object)micsElement));
            }
        }
    }
}

