/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.wasamon.mjlib.util.GetOpt;
import net.wasamon.mjlib.util.GetOptException;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class MakeInitialize {
    private String src;
    private static final int OUTPUT_JAVA = 0;
    private static final int OUTPUT_HTML = 1;
    private InitElement root;
    private String className;

    public MakeInitialize(String string) throws Exception {
        this.src = string;
        File file = new File(string);
        if (!file.exists()) {
            throw new Exception("no such file: " + string);
        }
        try {
            this.root = new InitElement();
            Node node = XMLParser.getTopNode(file);
            this.className = XMLParser.getAttribute(node, "name").getNodeValue();
            this.makeInitElement(node, this.root);
        }
        catch (XMLParserException xMLParserException) {
            throw new Exception("syntax error: " + xMLParserException.getMessage());
        }
    }

    private void makeInitElement(Node node, InitElement initElement) throws XMLParserException {
        this.makeAttribute(XMLParser.getNamedNodeArray(node, "attribute"), initElement);
        this.makeChild(XMLParser.getNamedNodeArray(node, "child"), initElement);
        this.makeExecStmt(XMLParser.getNamedNode(node, "exec"), initElement);
    }

    private void makeExecStmt(Node node, InitElement initElement) throws XMLParserException {
        initElement.addExecStmt(XMLParser.getNodeText(node));
    }

    private void makeChild(Node[] nodeArray, InitElement initElement) throws XMLParserException {
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            String string = XMLParser.getAttribute(node, "name").getNodeValue();
            String string2 = XMLParser.getAttribute(node, "repeatable").getNodeValue();
            boolean bl = false;
            if ("true".equals(string2)) {
                bl = true;
            }
            InitElement initElement2 = new InitElement(string, bl);
            this.makeInitElement(node, initElement2);
            initElement.addChild(initElement2);
        }
    }

    private void makeAttribute(Node[] nodeArray, InitElement initElement) throws XMLParserException {
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            String string = XMLParser.getAttribute(node, "name").getNodeValue();
            String string2 = XMLParser.getAttribute(node, "type").getNodeValue();
            initElement.addAttr(new InitElementAttr(string, string2));
        }
    }

    public String toString() {
        String string = "";
        string = string + "class = " + this.className + "\n";
        string = string + this.root.toString(0);
        return string;
    }

    public String toJavaSource() {
        String string = "";
        string = string + "/* generated automatically by MakeInitialize from " + this.src + " */\n";
        string = string + "public void initialize(String id, Node n) throws MicsException{\n";
        string = string + "super.initialize(id, n);\n";
        string = string + " try{\n";
        string = string + this.root.toJavaSource(0);
        string = string + "}catch(NumberFormatException e){\n";
        string = string + "throw new MicsException(\"configuration syntax error: " + this.className + "\");\n";
        string = string + "}catch(XMLParserException e){\n";
        string = string + "throw new MicsException(\"configuration syntax error: " + this.className + "\");\n";
        string = string + "}\n";
        string = string + "}\n";
        return string;
    }

    public String toHTMLTable() {
        String string = "";
        string = string + "<!-- generated automatically by MakeInitialize from " + this.src + " -->\n";
        string = string + "<table border=\"1\">";
        string = string + "<tr><td>" + this.className + "</td></tr>";
        string = string + "<tr><td>" + this.root.toHTMLTable() + "</td></tr>";
        string = string + "</table>";
        return string;
    }

    public String getText(int n) {
        if (n == 1) {
            return this.toHTMLTable();
        }
        return this.toJavaSource();
    }

    private static void usage() {
        System.out.println("usage: MakeInitialize [-o java/html] source");
        System.exit(0);
    }

    public static void main(String[] stringArray) throws GetOptException {
        GetOpt getOpt = new GetOpt("o:", "", stringArray);
        if (getOpt.getArgs().length < 1) {
            MakeInitialize.usage();
        }
        int n = 0;
        if (getOpt.flag("o")) {
            String string = getOpt.getValue("o");
            if ("java".equals(string)) {
                n = 0;
            } else if ("html".equals(string)) {
                n = 1;
            } else {
                MakeInitialize.usage();
            }
        }
        for (int i = 0; i < getOpt.getArgs().length; ++i) {
            try {
                MakeInitialize makeInitialize = new MakeInitialize(getOpt.getArgs()[i]);
                PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(new File(getOpt.getArgs()[i] + ".output")), true);
                printWriter.println(makeInitialize.getText(n));
                printWriter.flush();
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    private class InitElement {
        ArrayList initElementAttrArray;
        ArrayList initElementChildArray;
        String name = "root";
        String execStmt;
        boolean repeatableFlag = false;
        Pattern pattern = Pattern.compile("(\\$[0-9a-zA-Z]+)");

        public InitElement() {
            this.initElementAttrArray = new ArrayList();
            this.initElementChildArray = new ArrayList();
        }

        public InitElement(String string, boolean bl) {
            this();
            this.repeatableFlag = bl;
            this.name = string;
        }

        public void addAttr(InitElementAttr initElementAttr) {
            this.initElementAttrArray.add(initElementAttr);
        }

        public void addChild(InitElement initElement) {
            this.initElementChildArray.add(initElement);
        }

        public void addExecStmt(String string) {
            this.execStmt = string;
        }

        public String toString(int n) {
            String string = "";
            String string2 = "";
            for (int i = 0; i < n; ++i) {
                string2 = string2 + " ";
            }
            string = string + string2 + "name = " + this.name + "\n";
            string = string + string2 + "exec = {" + this.execStmt + "}" + "\n";
            for (Object object : this.initElementAttrArray) {
                string = string + string2 + "attr: " + ((InitElementAttr)object).name + "/" + ((InitElementAttr)object).type + "\n";
            }
            for (Object object : this.initElementChildArray) {
                string = string + ((InitElement)object).toString(n + 1);
            }
            string = string + "\n";
            return string;
        }

        public String toJavaSource(int n) {
            int n2;
            Object object2;
            String string = "";
            String string2 = "";
            for (int i = 0; i < n; ++i) {
                string2 = string2 + "_";
            }
            string = string + "{\n";
            String string3 = "init_var_";
            if (!"root".equals(this.name)) {
                string3 = string3 + string2 + this.name + "_";
            }
            if (!"root".equals(this.name)) {
                if (this.repeatableFlag) {
                    string = string + "ArrayList<Node> " + string3 + "obj = ";
                    string = string + "XMLParser.getNamedNodeArrayList(n, \"" + this.name + "\");\n";
                    string = string + "Iterator<Node> it = " + string3 + "obj.iterator();\n";
                    string = string + "while(it.hasNext()){\n";
                    string = string + "Node " + string3 + "node = it.next();\n";
                } else {
                    string = string + "Node " + string3 + "node = ";
                    string = string + "XMLParser.getNamedNode(n, \"" + this.name + "\");\n";
                }
            } else {
                string = string + "Node " + string3 + "node = n;\n";
            }
            for (Object object2 : this.initElementAttrArray) {
                string = string + ((InitElementAttr)object2).type + " " + string3 + ((InitElementAttr)object2).name + ";\n";
                string = string + string3 + ((InitElementAttr)object2).name + " = ";
                n2 = "int".equals(((InitElementAttr)object2).type) ? 1 : 0;
                if (n2 != 0) {
                    string = string + "DataUtil.parseInt(";
                }
                string = string + "XMLParser.getAttribute(" + string3 + "node, \"" + ((InitElementAttr)object2).name + "\").getNodeValue()";
                if (n2 != 0) {
                    string = string + ")";
                }
                string = string + ";\n";
            }
            Matcher matcher = this.pattern.matcher(this.execStmt);
            object2 = new StringBuffer();
            n2 = 1;
            while (matcher.find()) {
                matcher.appendReplacement((StringBuffer)object2, string3 + matcher.group(n2).substring(1));
            }
            matcher.appendTail((StringBuffer)object2);
            string = string + ((StringBuffer)object2).toString() + "\n";
            if (this.repeatableFlag) {
                string = string + "}\n";
            }
            for (InitElement initElement : this.initElementChildArray) {
                string = string + initElement.toJavaSource(n + 1);
            }
            string = string + "}\n";
            return string;
        }

        public String toHTMLTable() {
            String string = "";
            string = string + "<table border=\"1\" width=\"100%\">\n";
            if (!"root".equals(this.name)) {
                string = string + "<tr><th>Name</th><td>" + this.name + "</td></tr>\n";
            }
            for (Object object : this.initElementAttrArray) {
                string = string + "<tr>";
                string = string + "<th>Attribute</th><td>";
                string = string + "<table border=\"1\" width=\"100%\"><tr>";
                string = string + "<th>name</th><td>" + ((InitElementAttr)object).name + "</td>";
                string = string + "<th>type</th><td>" + ((InitElementAttr)object).type + "</td>";
                string = string + "</tr></table>";
                string = string + "</td>";
                string = string + "</tr>";
            }
            for (Object object : this.initElementChildArray) {
                string = string + "<tr>";
                string = string + "<th>child</th>";
                string = string + "<td>\n";
                string = string + ((InitElement)object).toHTMLTable();
                string = string + "</td></tr>";
            }
            string = string + "</table>\n";
            return string;
        }
    }

    private class InitElementAttr {
        String name;
        String type;

        public InitElementAttr(String string, String string2) {
            this.name = string;
            this.type = string2;
        }
    }
}

