/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.util;

import java.util.ArrayList;
import java.util.Iterator;
import net.wasamon.mics.Channel;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsException;

public class ChannelManager {
    private ArrayList channels;
    private MicsCompositeElement composite;

    public ChannelManager(MicsCompositeElement micsCompositeElement) {
        this.composite = micsCompositeElement;
        this.channels = new ArrayList();
    }

    public void add(String string, int n) {
        this.channels.add(new Element(this.composite, string, n));
    }

    public Element[] array() {
        return this.channels.toArray(new Element[this.channels.size()]);
    }

    public Element search(int n) throws IndexOutOfBoundsException {
        Iterator iterator = this.channels.iterator();
        Element element = null;
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (element2.offset > n || element != null && element2.offset < element.offset) continue;
            element = element2;
        }
        if (element == null) {
            throw new IndexOutOfBoundsException();
        }
        return element;
    }

    public int search(Channel channel) {
        for (Element element : this.channels) {
            try {
                if (element.getChannel() != channel) continue;
                return element.offset;
            }
            catch (MicsException micsException) {
            }
        }
        return 0;
    }

    public String[] getConnectedElements() {
        String[] stringArray = new String[this.channels.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((Element)this.channels.get((int)i)).id;
        }
        return stringArray;
    }

    public class Element {
        public String id;
        public int offset;
        public MicsCompositeElement composite;
        private Channel channelInstance;

        public Element(MicsCompositeElement micsCompositeElement, String string, int n) {
            this.composite = micsCompositeElement;
            this.id = string;
            this.offset = n;
        }

        public Channel getChannel() throws MicsException {
            if (this.channelInstance == null) {
                this.channelInstance = this.composite.getChannel(this.id);
            }
            return this.channelInstance;
        }
    }
}

