/*
Midbar
Distributed under the MIT License
© Copyright Maxim Bortnikov 2023
For more information please visit
https://sourceforge.net/projects/midbar/
https://osdn.net/projects/midbar/
https://github.com/Northstrix/Midbar
Required libraries:
https://github.com/zhouyangchao/AES
https://github.com/peterferrie/serpent
https://github.com/ddokkaebi/Blowfish
https://github.com/Northstrix/DES_and_3DES_Library_for_MCUs
https://github.com/ulwanski/sha512
https://github.com/Bodmer/TFT_eSPI
https://github.com/intrbiz/arduino-crypto
https://github.com/GyverLibs/EncButton
https://github.com/techpaul/PS2KeyAdvanced
https://github.com/techpaul/PS2KeyMap
https://github.com/miguelbalboa/rfid
*/
#include <TFT_eSPI.h> // Hardware-specific library
#include <SPI.h>

TFT_eSPI tft = TFT_eSPI();       // Invoke custom library

const uint16_t Dallas PROGMEM [320][241] = {
{46649,46649,46617,46649,46649,46681,46649,46649,46649,46649,46649,46649,46649,46649,48697,46648,48697,48729,50809,52889,52857,52889,54937,54937,52889,52889,52857,50841,50809,50809,50809,50809,52857,52889,52857,50777,50809,50809,50777,50777,50777,50777,50777,48729,48696,48696,48697,48729,48729,48696,48729,48696,48696,48729,48729,48696,48696,48696,48664,48696,48696,48696,48696,46616,40343,36150,34037,31957,31956,31956,29843,29810,29810,29778,29778,29778,27665,29777,29777,27697,27632,25552,25552,21327,21326,40178,42258,19050,17002,16969,19082,21163,21195,21195,23276,23276,21195,25388,27436,29581,29548,29581,25356,27436,27468,21227,19115,23276,23276,19115,19115,16970,19115,19115,17002,19083,23308,23308,19115,19082,19115,17002,12809,12809,14954,12841,14922,17002,12841,19148,31694,50612,48498,50579,44271,42158,35885,23240,37966,27469,17002,37998,50578,21160,6501,4389,8582,19081,8582,14919,23337,19079,21225,14919,10694,8582,12775,14856,8517,27466,44304,37901,18984,23275,27468,27466,31689,42156,52723,54903,42224,23271,23238,40143,35886,19014,21159,19079,8580,12774,14854,14854,19048,21128,27435,19081,16969,21162,29581,31694,25356,23308,19115,23276,25389,27501,31662,35887,37967,42192,42225,44273,44273,42225,40112,37999,37967,33774,33806,35919,38000,33806,33807,33807,25421,23243,27501,25356,25356,21163,12808,10630,23275,27469,27469,27468,27501,27469,25388,25356,19049,21097,25356,27468,29484,27403,29549,27468,25388,23275,94},
{46649,46617,46649,46649,46648,46649,46649,46649,46681,46649,46649,46649,46649,46649,46649,46649,46681,48729,48761,54970,54970,54937,54937,52889,52889,52889,52890,50841,50809,50809,50809,52857,52857,52857,50777,50777,50777,50809,50777,48728,50809,50777,48729,48729,48696,48696,48697,48696,48696,48696,48696,48697,48729,48729,50777,48697,48696,48664,48697,48696,48696,48696,48697,46616,40342,36182,31957,31956,31956,31923,29811,29811,29810,29778,27697,27698,27697,27697,29777,29777,27632,27633,23472,21327,21326,42259,38033,17002,17002,14890,17002,19050,19082,21163,19082,19082,21195,21163,19082,21163,21163,23275,23243,19082,17002,14889,19115,23308,23276,17002,17002,14857,17035,17002,14921,17002,14889,14857,17035,14889,16970,16970,12777,12809,12809,10696,14954,14921,12809,21196,33807,50612,48531,50644,44305,42190,42190,40078,44207,27500,17002,37966,44239,31627,27467,19049,12775,6469,8615,21193,25386,10629,10629,14951,14886,8581,10662,16936,8517,27466,31659,29547,21096,23242,27468,27499,33738,40076,52724,54904,31725,16932,21126,46483,33772,25352,21159,14853,10725,10693,8580,10628,19015,19047,19047,19048,23242,21162,19082,21162,19082,21260,23341,27502,31727,29614,31694,35887,37967,40079,42192,42192,44273,42192,42193,42192,40112,35919,35887,35854,35887,33774,31694,29582,14889,16969,27501,29581,27502,23308,12776,8550,19017,21162,25388,27469,27469,25388,27469,25356,19081,23307,27468,27404,27436,25355,29549,27468,25355,25355,94},
{46649,46617,46617,46649,46616,46616,46649,46649,46681,46681,46649,46649,46617,46648,46616,46648,46649,48729,48729,52857,54937,54969,54969,54970,52889,52857,50809,50809,50809,50809,50809,52857,52889,52889,50809,50777,50777,50777,50777,48696,50777,50777,48729,48696,48696,48697,48729,48696,48696,48696,48729,48729,48729,48729,48697,48696,48729,48696,48729,48696,48696,48696,48696,46616,38262,36150,31957,31956,31924,31923,29810,29810,29810,29810,27730,27665,27697,27665,29745,29745,27665,27632,23407,23407,23374,40179,31695,16937,14921,14889,16970,17002,17002,19115,19050,19082,21163,21130,21163,23243,21163,23276,23243,16970,21195,19050,21163,23243,19050,16970,17002,14889,19083,17002,14889,17002,14922,17003,19083,14889,17002,16970,12809,12841,12809,10729,12841,10696,12809,19116,35920,48531,46418,48531,48498,44303,44303,46384,46352,29548,14889,31660,40014,31563,33806,21161,17000,6501,6437,14855,17000,10598,6405,10630,10694,6469,12808,14888,10662,16999,8516,10630,19016,23274,25388,27500,35885,40076,52757,54936,42224,21159,19046,52790,48498,42256,25383,23239,14917,10692,10692,12805,16967,10661,8580,14822,21095,21161,10629,6469,14889,19147,21228,25421,31727,33840,35952,38032,40080,38031,35919,35919,40112,40079,40047,40080,37999,37999,38000,38000,38000,33774,31662,25388,12744,14856,25388,27469,27469,25421,25356,23243,23275,21162,19050,23243,25356,25356,29581,27469,21162,27501,29581,25323,27404,27436,27501,27468,27436,23275,92},
{46617,46649,46649,46649,46649,46649,46681,46649,46649,46649,46649,46649,46649,48697,46649,46649,48697,48729,48729,50809,54970,55002,54937,52889,54938,52857,52857,50809,50777,50809,50777,52857,52889,52889,52857,50777,50777,50809,50777,50745,48697,48696,48697,48696,48696,48696,48696,48696,48696,48696,48696,48696,48697,48696,48697,48697,48729,48696,48697,48697,48696,48696,48696,46584,38230,36150,34037,31956,31956,31923,31923,29843,27698,27698,27698,27665,27697,27665,27665,27664,29745,29745,23439,38099,27501,21163,25389,19050,16970,14889,19082,21163,19082,21163,21163,21163,23243,23243,23243,23276,21195,21195,21195,21163,23243,19082,21195,21195,19082,19050,19083,17002,19083,17002,16970,17034,17002,17002,17035,16970,17002,17002,14889,14889,12809,10761,10761,8648,12809,19083,35920,50644,40014,35821,44272,44271,42191,44304,50611,29516,21196,33773,50611,31627,23273,12710,19048,8550,8583,6469,12808,8550,6405,8550,8582,8581,10694,16968,19047,16934,8549,10630,19016,25355,25355,25355,37998,42157,50677,54904,50611,40078,33739,52790,50611,42257,16965,16965,19077,19142,16997,14917,14886,14886,12806,16935,16902,10759,4453,10629,17001,12841,12841,23340,31727,31760,33807,35920,38032,33904,8874,15083,38032,40079,40080,37967,35887,35887,35919,37968,38000,33839,33807,31662,23308,23275,25388,23308,23308,25389,27469,25421,25421,27469,23308,21162,19050,21195,25388,25356,19049,21195,27469,23242,27403,27403,27468,27468,27436,23275,90},
{46649,46649,46681,46649,46649,46649,46649,46649,46649,46681,46649,46649,46649,46649,48697,46649,46649,46649,48729,50777,50777,52889,54970,54938,52889,52889,52857,52857,52857,52857,52857,52857,52857,52857,52857,50777,50809,50809,50777,50777,50777,48696,48696,48696,46584,48696,48696,48696,48696,48696,48729,48729,48729,48696,48696,48696,48697,48729,48696,48696,48696,48696,48696,46584,40311,36117,34037,31957,31956,31924,29811,29843,29810,27698,27697,27697,27697,29745,29745,31825,29745,29745,29712,38066,27437,19050,21163,19050,19050,16970,19083,21163,17002,21163,21195,21131,21163,21163,23243,23243,23243,23276,21195,21163,21163,21163,21163,21163,16970,16970,19050,14857,19051,19083,16937,19050,16970,16969,17034,14889,14889,14889,12777,12809,10729,8648,6535,8648,10761,19115,38000,48531,37934,40014,42159,40078,40078,44304,46385,29581,21196,33774,44239,33707,27434,12774,23274,14856,14920,10663,12776,10630,10662,14918,12806,10758,8549,16968,21160,16966,14886,12774,19016,25355,23275,23210,40111,40078,48596,54903,50578,50545,50643,54870,44337,29546,16997,14917,16965,19077,19109,19109,14885,10660,8580,16934,14854,10889,8874,19014,14823,10663,8615,23308,27566,25454,23341,23341,23341,21293,4746,8874,38064,40079,40047,37967,35854,33774,33806,33774,33806,33807,33775,31662,29614,31694,27501,25421,25388,25356,23275,23308,25388,25421,25421,25421,23308,17001,19049,23275,19049,19082,21194,12710,25323,27403,27468,27468,27436,25323,89},
{46649,46649,46649,46617,46648,46649,46649,46649,46681,46649,46649,46649,46649,46649,48697,48729,46649,48697,48697,48729,48729,52890,52857,52857,52889,52857,52889,50809,52890,52890,52890,52857,52889,52889,52857,52857,50809,50777,50777,50777,50777,48696,48696,48697,48696,48696,48696,48696,48697,48696,48696,48697,48729,48729,48696,48696,48729,48696,48696,48697,48664,48696,48696,46616,40310,36117,34037,31957,34037,31956,29843,29810,31923,29778,27697,27697,29778,27697,27632,42357,40244,35986,40179,42259,23243,19083,23276,19050,19050,14857,19083,19115,16970,19083,21163,21163,21163,23243,23276,23243,21195,23243,23243,23243,21163,17002,16970,17002,14889,16970,19083,16970,19083,19050,16969,19082,19050,19050,19083,16970,14890,14922,14889,14922,8616,6503,6503,8648,10729,19083,38032,48531,46418,50677,44272,40014,40078,44272,46353,29613,16970,27468,35788,35788,37901,19049,12775,10694,14919,10662,23274,16904,8582,14951,17031,10726,10694,16936,19079,19078,21191,14854,16968,27435,23274,19016,40047,42159,50645,54903,50578,48432,52757,52757,52823,46451,25416,21190,19142,19109,21190,19109,16997,14852,12772,21127,19015,14920,6533,12742,21195,14889,14921,23308,21260,21196,21196,19115,19115,19180,6762,4649,27533,37967,37967,35919,35854,33774,33774,33774,33774,31726,31662,27501,29582,29581,27501,29582,27534,27501,25356,23275,23275,23276,23308,25421,25421,23276,19082,19049,19049,19049,21162,14790,25322,27403,27469,27468,27436,25323,89},
{46649,46617,46649,46649,46649,46616,46649,46681,46649,46649,46649,46649,46648,46648,46649,46649,48697,48729,48697,48729,50777,52890,52889,52889,52889,52889,52889,52890,52890,52857,52857,52857,52857,52857,50809,50809,50777,50777,48729,48697,48729,48696,48696,48696,48664,48696,48696,48696,48696,48664,48664,48697,48729,48696,48697,48729,48729,48697,48696,48696,48696,48696,48696,46584,40310,36150,31956,31956,31956,31956,31891,27730,29843,29778,27697,27729,29778,27665,27632,31857,38098,38066,38001,35920,23276,21163,27470,21163,21163,19082,23276,21227,19082,21195,21195,21163,23276,23244,23276,23276,23243,23275,23276,21163,21163,19082,19050,19083,16970,19050,21163,19050,21163,21130,19050,21163,21130,19050,19082,16970,14922,14922,14889,14890,8648,6535,4422,6535,10696,19115,40145,48531,48499,52790,48466,40014,37965,42191,50645,33775,23308,33741,42094,40013,46385,23242,12743,16968,17031,10694,31661,16936,6437,8582,17033,17000,12807,14920,10661,25352,23239,14854,19016,27436,19049,16903,31660,35854,50710,54903,50578,48432,54870,50644,54936,54936,29546,21191,23271,27432,31690,25352,21158,25352,31626,33739,35821,37934,19049,14889,12841,12809,14889,17002,14922,14921,14922,14922,14922,17067,12971,12939,17034,23308,33806,38000,35887,33806,33806,33806,33774,31726,29614,27501,27469,27469,25388,27469,27469,27469,27502,25389,25356,23275,21195,23276,23308,23308,25421,21227,19049,19049,23275,27403,27403,27403,27468,27469,25388,23275,87},
{46649,46617,46649,46649,46649,46649,46649,46649,46681,48729,48697,46649,46649,46649,46649,48697,48697,46649,48697,48729,50809,52889,52889,52889,52889,52857,52889,52890,52857,52858,52857,52857,52857,50777,50777,50777,50777,50777,48696,48696,48696,48696,48696,48697,48696,48696,48696,48696,48696,48696,48696,48697,48697,48696,48696,48696,48696,48696,48696,48696,48696,48696,48664,46584,42423,38230,31957,31956,31956,31923,29811,27730,29778,29778,27730,29810,29778,29810,29778,27664,38131,35986,25389,19083,19083,21163,23308,21163,21163,16969,21195,21195,19082,23243,21195,23244,23243,23211,23244,23276,23243,23276,23275,19050,19083,16970,16970,16970,14857,17002,19082,16969,19050,19050,19050,21130,19018,16970,16970,16970,14889,14889,12809,12841,8615,6503,6502,6535,8648,21163,40113,48466,48531,46451,35853,35885,35918,44304,52823,33807,23276,33708,52658,46418,35855,23275,19081,19113,21225,21160,31660,25290,12679,10662,10662,12743,12808,16969,8517,23272,19079,12773,21128,27467,19016,16903,31692,31629,52790,52823,48465,48432,54903,50644,57049,50646,29515,14823,27434,42158,46416,44271,42158,44239,46352,44239,33741,27403,19082,17002,12809,10728,12809,14921,12841,14922,14922,14889,14889,17002,19050,14954,17067,17034,21227,33807,33807,31661,33807,35887,33839,33807,31694,29581,27501,27469,25388,23308,23308,25388,25421,25389,27469,27501,23276,21195,19115,21195,23308,23275,19082,19017,25388,29582,27436,27403,27468,27501,25388,23275,89},
{44569,44569,46617,46649,46649,46649,46649,46649,46649,48697,48697,46649,46649,48729,46649,46649,48697,48729,48729,48729,50809,52890,52889,52889,52889,52857,52857,52890,52889,50809,52857,50809,52857,50777,48696,50777,50777,50809,48729,48696,48696,48697,48696,48697,48697,48696,48696,48696,48664,48696,48696,48696,48696,48729,48697,48697,48696,48696,48697,48697,48696,48696,48696,46584,42423,36150,31957,31957,31956,31923,34004,29843,29778,29778,29778,27729,29778,29778,29777,27665,29777,31824,25389,21195,21163,25389,23276,21163,21163,21195,23243,21163,21163,21163,19050,23244,23276,23244,23276,23243,23276,25356,23276,19018,19082,16970,19083,19083,16970,19083,19082,19050,21131,21130,21131,21163,21163,21163,21163,19050,16970,14922,14890,14890,8583,6535,6535,8615,8648,19050,42226,46451,29579,21161,14855,25354,35886,42160,57050,35953,23308,33773,48465,44337,31695,23275,14921,17002,17033,25322,46451,40080,23210,19081,14855,6469,6469,16969,10598,25353,16966,16998,21161,25322,21129,23177,31660,29515,50677,52790,48464,48464,54903,50644,57049,44339,25289,12710,29482,44272,46385,42159,44240,44304,44304,42192,31629,21163,19082,14954,12809,10728,12809,14922,12809,14889,14922,14954,14921,16969,16969,14921,14921,17034,17002,17002,19082,16969,21194,23275,25388,25420,27501,27501,29582,29581,25420,23308,23308,23308,25388,23275,25388,25356,23340,25389,21195,19050,19115,21163,16936,19049,25388,27436,27403,27435,27468,27469,27468,25355,89},
{46617,46649,44569,46616,46649,46649,46649,46649,46681,46649,46649,46649,46648,46648,48697,46649,46616,48697,48729,48729,52890,52857,52889,52857,52857,52890,52890,52889,52857,52857,52857,50809,52857,52857,50777,50777,52857,50809,50777,48697,48697,48729,48696,48696,48696,48697,48696,48696,48696,48696,48697,48729,48697,48697,48696,48696,48696,48697,48696,48696,48696,48696,48696,46616,42423,36149,34037,31957,31956,31891,31891,29843,29810,29810,29778,29778,29778,29745,29777,27632,29745,33905,33840,31759,29581,35888,29581,21163,21163,23275,23243,23275,23275,23276,21195,23276,23276,25324,23276,23276,25324,25356,23276,21195,23243,19082,21163,21163,19050,21163,21163,21131,21163,21130,21163,21163,21130,21163,21163,19050,17002,16970,14922,14922,8583,8615,8583,8615,12809,23308,42226,42225,19080,19080,16968,21161,33774,37903,57050,38033,29581,33773,44272,46386,33775,19082,10728,12841,12841,19049,50645,44339,27500,19080,12742,6469,6437,14889,10630,29579,23239,21191,19048,29548,23210,25354,29548,35886,52822,50676,48432,48498,52822,52757,57017,35854,23177,14791,33676,42126,46353,40046,44240,44240,44272,42159,31629,23243,17002,14921,12809,12809,12841,17002,17002,14921,12841,14889,12841,16969,16936,14889,14921,16969,14921,17001,19082,14888,17001,14889,14889,16969,17001,21162,23308,25388,27469,25388,25421,25388,23308,23275,23308,23308,23275,25388,23276,21195,19083,19083,16969,19049,25356,23243,25323,27403,25388,27468,27468,25355,88},
{46649,46649,46617,46649,46649,46649,46649,46649,46649,46649,46649,46649,46616,46648,48697,46649,46649,48697,48697,48729,50809,52890,52857,52857,52889,52889,52889,52857,52857,52857,50809,50809,52857,52857,50777,50777,50809,50777,50777,48696,48696,48696,48697,48729,48729,48697,48696,48696,48696,48696,48697,48729,48697,48696,48696,48697,48729,48696,48696,48696,48696,48664,48696,46584,42391,36150,34037,31956,31924,31924,29811,29810,29810,29778,27698,27697,31890,29778,29777,27697,29745,27599,25388,31694,35920,33774,33742,19082,21131,21131,23243,21195,21163,21195,21163,21195,23276,23276,23276,23243,23243,23276,23243,23243,23243,21163,21163,21195,21131,21195,21195,21163,23244,23243,21195,21195,23243,21195,21195,21163,21163,19115,17002,14922,8583,6503,6503,8583,17002,29614,42258,44273,33772,33805,31692,33773,35854,37902,57082,38065,23243,31628,44239,46451,29614,16969,6469,6502,12808,27532,44306,48565,27499,16999,12774,12774,10662,23276,12743,29580,29545,23239,21128,31661,25322,12742,25321,35886,52822,50676,46351,50643,52790,52855,54870,29547,12742,16871,40046,40045,42159,40047,44272,44272,46353,44240,33774,25388,12808,12809,12809,10760,12809,14889,14889,16937,16936,14856,12744,12678,12678,10630,12743,10630,10597,12742,19081,16935,16968,16968,16937,16969,14889,14856,14889,17001,19082,21195,23308,25388,25388,25356,23308,21227,21195,21195,21163,21195,23341,19148,19082,19049,25388,19081,21130,25355,27436,27468,25388,25355,86},
{46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46648,46649,46649,48697,48697,46649,46649,48729,48729,48729,50841,52857,52857,54937,54937,54937,52889,52889,52857,50777,50809,50809,52857,48728,50809,52857,50777,48697,48696,48696,48696,48696,48696,48697,48697,48696,48696,48696,48696,48696,48697,48696,48697,48729,48729,48697,48696,48696,48697,48664,48664,48696,46584,42391,36150,34037,31957,31956,31956,31891,29811,29778,29778,27698,29746,31890,29745,29745,29745,29745,33905,40113,38033,33840,31662,35887,23275,23244,19050,27436,25388,19082,19050,14857,16969,17002,14889,16970,14889,14856,17002,14889,14889,16970,14889,14889,16970,14857,16969,14889,12744,16970,16937,14857,17002,12776,14889,14889,12808,14922,10728,8616,10696,8615,6535,6503,8583,12776,21195,44339,46418,50611,48498,40079,42160,37902,35821,57050,42259,31662,31563,42127,46419,27469,16970,8615,8615,16969,42225,44338,48597,29580,21160,14887,8613,12742,31726,12743,23242,29611,23272,23208,31661,19049,10597,23241,29580,52790,50644,40013,52757,50677,54903,50544,25352,8549,16903,42159,42159,37901,37934,44304,44304,42159,40080,23274,10695,2243,6437,10696,8582,12710,23241,33773,42126,44207,44239,37934,35821,27403,16936,12710,8485,4324,6436,8517,12775,16936,14855,12743,12743,14823,14823,12776,14889,14921,14921,19082,21195,25389,25389,25421,23276,19082,19115,19082,19082,19083,19148,19082,16969,23275,10662,14856,25323,25355,27468,25355,25388,82},
{46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,48697,48729,46649,48697,48729,48729,48729,48729,50809,52889,52889,52889,54937,52889,52890,52857,50809,50809,50809,50809,50777,50777,50777,50809,50777,48696,48696,48696,48696,48696,48696,48696,48696,48697,48697,48696,48696,48696,48696,48697,48696,48696,48697,48696,48664,48696,48696,48664,48664,46583,40342,38263,34037,34037,34036,31924,31891,29811,29778,29778,29778,29746,29778,27697,27665,29745,27632,31727,42194,31726,33808,29549,35855,25356,21163,19082,25324,23275,21130,19083,17002,19082,19083,17002,19083,17002,17002,19115,17002,16970,17002,16970,19050,19083,16970,19082,16970,14889,19083,19050,14889,17002,14857,14889,14922,12809,14889,12809,14922,14954,10729,6535,8616,10696,12809,19114,44338,48499,48531,46385,44305,42160,37902,37934,57050,42227,29549,33708,46352,48532,29582,17002,10728,12841,21163,42225,46419,48597,31661,21160,16999,10726,14854,16967,14855,16967,10629,25353,25321,31661,14855,6436,19016,25355,50678,48565,37966,52822,50644,54936,48531,21128,6436,21128,42158,44239,37869,33709,37966,29547,14854,10597,4355,4323,4291,2243,6372,21064,35821,40046,44271,44239,42159,44272,35853,37966,31628,27403,33741,31628,23242,19016,12678,10662,12775,14855,12775,12711,12743,10630,8549,10662,12776,14856,14824,16969,19082,21195,25389,23308,21195,19115,14922,14922,17002,17035,19082,16968,21227,14855,10662,23242,25355,27468,25388,27469,77},
{46649,46649,46649,46617,46648,46649,46649,46649,46681,46649,46649,46649,46649,46649,46648,48697,48729,48697,48729,48729,48729,48729,48729,50809,52889,52889,54937,52889,52857,52857,50809,50809,52858,52857,50777,48696,50777,50809,50777,48696,48696,48696,48697,48697,48697,48697,48729,48696,48697,48696,48696,48697,48729,48729,48696,48696,48697,48696,48697,48696,48696,48696,48696,44535,40342,40311,34037,34037,34036,34004,31923,29810,27730,27730,27698,27698,29778,29777,25552,27665,29745,33905,46485,38033,33872,31662,33742,16937,19050,16937,19050,16970,16937,16970,14889,16970,17002,14889,16970,16970,16970,19082,16969,14889,17002,14889,16970,19082,16969,16970,16970,16969,17002,16969,14889,16970,14889,14889,17002,14889,19083,17035,17034,17035,10729,8615,8583,10696,10696,19114,42258,48499,48499,31465,35821,40079,35789,37934,57049,42260,29614,31627,48466,54870,35920,14889,12809,12809,21195,40112,44338,44371,27467,21193,21160,16967,14918,19047,19080,16999,12741,25386,25289,29581,14920,8549,8516,27468,52791,57083,50548,52790,52725,54969,44338,16934,6436,31626,37965,46352,35821,19048,12774,8613,6468,4323,6436,6436,2243,10630,29580,37999,35854,27435,40080,35886,35854,40080,31629,29549,16936,19049,29548,29581,29548,29581,31629,23210,19081,16936,14791,12710,12710,10630,10597,8549,8517,14726,25031,14856,12808,17002,19147,21195,21227,21228,19083,17002,14921,17002,17001,16969,23308,21161,12710,23274,25356,27501,25388,25421,77},
{46649,46649,46649,46649,46649,46649,46649,46681,46681,46649,46649,46649,48697,48697,48697,48697,48729,48697,48729,48729,48729,48729,48729,48729,50809,52889,52889,52889,52857,52889,52889,50809,52857,50809,50777,48697,50777,52857,50777,48664,48696,48696,48697,48697,48729,48696,48696,48696,48697,48697,48729,48729,48697,48696,48696,48696,48696,48696,48696,48664,48696,48696,48696,46584,40343,38262,34037,34037,34037,31955,31891,29842,29778,27730,27698,27697,27730,29778,25552,27632,31858,33937,50711,42226,35920,33742,42225,25355,27437,21163,27437,21195,16969,17002,14857,16970,16970,12776,14889,14922,14857,17002,14889,14857,16970,14857,14889,14921,12776,16970,14890,12776,14889,12776,12776,14889,12776,12809,14889,10664,12809,12809,17002,14922,8648,8583,8583,19083,14889,21195,42225,46418,50579,42062,42191,44239,35757,39982,54969,46454,40179,40013,46352,52756,42160,14856,10696,6502,25355,48564,50678,42193,29581,27499,23240,21191,21191,21128,16935,21192,14886,16967,23241,29581,14855,14854,10693,29581,54904,59229,54806,52790,52758,54936,46353,18982,10596,35852,35852,27434,14822,8613,8613,8613,8581,6468,6436,4323,14856,33774,33774,31694,21162,16936,35887,33774,33742,35887,27468,25356,12711,21129,23242,23275,23275,25355,27469,16969,25323,31629,25323,19017,16936,14790,10630,8549,8582,10630,22916,16805,14888,12776,14889,21195,19115,19115,19083,19115,17002,14921,19050,14856,23275,25355,23242,25323,25355,27501,25420,23341,70},
{44569,46649,46617,46649,46649,46649,44568,46649,46649,46649,46649,46616,46649,48729,48729,48697,48697,46649,48697,48696,48729,48729,48729,48729,50777,52889,52889,52889,52857,52857,52857,52857,52889,50809,48729,50777,50777,50777,50777,48696,48696,48696,48697,48729,48697,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48697,48696,48696,46584,42391,38230,34037,34069,34037,31923,31891,31891,29811,29810,29778,31858,31858,31858,27665,29745,31825,31824,42259,44404,38065,33742,37967,21162,19082,19050,21163,19082,17002,19083,17002,17002,19083,17002,17002,19083,19082,19083,19082,19050,21163,19050,19082,19082,19050,19083,19083,16970,17002,17002,16970,17034,14922,14889,14922,12809,14890,12841,17002,10728,8615,6535,6535,12776,10696,21228,44338,48498,50643,48466,35821,29418,31564,40080,50743,48533,33742,35788,48497,54837,42160,10663,6502,10663,29581,48597,48597,42193,31661,25354,27466,29578,21191,16935,14823,25354,25385,14853,23209,27500,19047,19078,10661,33775,52824,54936,48531,52790,52790,54904,40047,21096,16902,37932,27465,8579,8612,10725,10693,10725,8613,6500,4355,19113,35952,25355,29549,27501,21163,21130,35887,35854,35855,35887,25388,23243,21163,27501,23275,21195,19050,21163,31793,23309,19049,27436,21162,16937,23275,25323,23210,14856,8712,4682,14951,18916,14823,10662,12743,19082,19115,19115,19115,19115,19115,19082,17001,14856,23275,27469,25323,25323,25355,27468,25356,23341,67},
{46617,46649,46649,46617,46616,46649,46649,46649,46616,46649,46649,46649,48729,48697,48729,46649,48697,46648,48729,48697,48696,48729,48729,50809,50777,52857,52889,52890,52889,52857,52857,52857,52857,52857,48697,48729,50777,50777,50777,48697,48696,48696,48696,48729,48696,48697,48729,48696,48697,48729,48696,48697,48697,48697,48696,48696,48696,48696,48696,48696,48696,48696,48696,46616,42423,38230,34037,34037,34036,31923,29810,29778,29810,31891,29777,38131,42325,31858,27665,31858,31825,31792,23308,38033,35920,33741,35822,19049,19082,14857,19082,14857,14857,16970,14889,14857,17002,16969,16970,16970,14857,14889,14889,14857,16970,14889,14889,16970,14857,14889,14889,14857,16970,14921,14889,14922,14889,14889,14922,12777,17002,17002,17002,8648,6503,6535,6503,8583,8615,19082,46451,48498,50611,44207,29353,25225,29484,33806,46452,48468,29484,29484,42127,48498,35854,14856,10728,14889,38000,50710,50678,48564,37967,29548,23242,25354,23272,19080,14823,27466,33803,19047,25290,27468,21192,19046,10693,33807,52790,48432,50611,52757,52823,54871,35789,14822,27401,35851,27432,16965,12772,8644,10693,8612,8613,6468,21226,35920,29581,19082,25356,29581,33775,25356,27469,31694,33742,29581,17001,19115,21162,27436,23275,23275,16937,21163,31760,29614,21130,25356,17035,10696,16969,21163,23243,14888,10793,12905,17032,23209,21162,19082,21162,19082,19083,19115,19115,19083,17002,19083,19082,16936,23275,27436,23210,25323,25355,27468,25388,23308,81},
{46617,46649,46649,46616,46649,46681,46649,46649,46649,46649,46649,46649,48729,46649,46649,46649,48729,48697,48729,48729,48697,48729,48729,48729,48729,50809,52857,52889,52857,52857,52857,52889,52857,50809,48697,50777,50809,50809,50777,48697,48697,48696,48664,48729,48696,48697,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48664,46616,48696,48696,48696,44535,40343,38230,34005,34037,34036,31956,29810,29843,29811,29843,29810,29777,36051,29777,27632,27665,25552,31825,29680,35953,33742,33742,44273,25356,25356,21130,25356,14889,14857,17002,14889,14857,19050,14889,16937,17002,14857,14889,16970,14857,16970,14889,14889,17002,14857,14889,14921,12776,14889,14889,12776,14889,12808,12809,14889,10696,14922,19148,19083,10696,6503,6503,6535,6535,6535,19082,46419,48564,46451,44240,42095,42128,27402,40080,46517,48468,33613,29516,44239,48498,33742,16937,12808,14921,33839,50677,50710,50710,37967,29549,25323,21161,21192,19047,12743,27498,31723,21159,23241,29548,23272,19078,16966,27500,52758,48399,50644,52725,54904,50645,35853,19016,31659,37898,31624,29577,19046,10725,12774,14855,16968,21162,33807,27533,35986,25453,15083,23405,33807,27501,19082,29549,27501,19017,6437,12809,16969,23275,21195,19115,10663,17002,23307,27468,25356,25389,23276,14857,14889,14922,25454,21196,10663,14889,16969,17001,19082,21163,21196,21196,17035,17034,19115,19115,17035,17034,17002,16936,23275,19082,16904,23242,25355,27436,25356,23275,113},
{46649,46649,46649,46648,46616,46649,46616,46649,46649,46649,46649,46649,46649,48697,46649,46649,48697,48729,48729,48696,46648,48697,48729,48729,48729,48729,50809,52857,52857,52857,52857,52857,52857,50809,50777,48697,50777,50777,50777,50777,48697,48697,48664,48729,48697,48696,48696,48697,48696,48664,48696,48697,48729,48697,48697,48696,48696,48696,48664,48696,48696,48696,48696,44535,40343,38230,34037,34037,34036,31955,31923,29843,29843,29810,29810,29745,27697,29745,27632,29745,31826,29745,27600,38033,33742,33807,35887,16970,16970,16937,19050,17002,16970,19050,17002,17002,19083,16970,17002,19082,17002,19050,19083,17002,19083,16970,17002,19115,19083,17034,19115,16970,17002,17002,14922,17002,14921,14889,14922,12809,16970,19115,16970,14922,10696,6535,6502,6503,8615,19082,46419,50645,40145,42192,40112,38031,25321,46418,54936,50613,35758,33709,46352,48498,25323,8583,6502,12809,33839,48597,52823,44371,29548,25323,25356,19017,23242,16968,14823,27434,25385,19015,25322,29548,23239,19077,19078,29613,52790,46351,52789,52725,54936,46420,35853,21129,33740,40109,31624,29545,21159,12774,19081,27435,31662,31727,19082,21195,29582,29679,11019,13035,33807,40146,21130,25388,25388,16937,8518,12808,16969,21163,19082,17035,8615,10695,17001,21163,19082,17002,19082,19082,17002,17002,23374,21228,10663,10728,12809,14889,14889,14889,12809,17002,17035,19115,19147,19115,19115,17035,17002,16969,23275,12743,10630,21097,25356,25388,25323,23275,91},
{46649,46649,46649,46616,46616,46649,46616,46649,46649,46649,46649,46649,46648,46649,48697,46649,46616,48697,48729,48729,48729,48697,48697,48697,48729,48729,50809,52857,52857,52890,52857,52857,52857,50809,50777,48697,48729,48728,50777,50777,48697,48729,48729,48696,48696,48697,48696,48696,48729,48696,48664,48696,48696,48729,48696,48664,48696,48696,48664,48696,48696,48664,48664,44503,40343,36150,34037,34037,34037,31955,31923,29811,29843,29842,29810,29810,29778,27665,27665,31858,38164,35985,25421,38033,33775,31727,33775,19017,21163,14856,14889,14889,12776,14889,16970,14857,16970,12776,14857,16970,12744,14889,14922,12776,16970,14889,12776,14890,12809,14889,17002,12776,14857,14889,10696,14889,12809,12744,12809,10696,23341,23308,12809,12841,8583,6503,6535,6503,6535,19082,46419,48532,42291,29612,14887,17000,23241,44273,52855,54905,52791,44338,46351,50611,25356,8615,10728,12809,31726,48596,52823,40048,29516,27403,35855,29548,27436,16969,12743,27498,25353,16903,25322,29548,25385,19110,19079,33774,52757,44270,52790,52725,54936,42194,35822,19016,33772,40077,35851,27432,21127,10661,21162,31629,38033,19082,8518,21195,25388,25453,6859,13035,25388,29581,21195,21162,16969,16969,12808,14921,14889,21163,19082,14922,8583,6502,10728,12841,12809,10631,12776,14922,14889,14954,14954,12841,12776,12808,12809,12809,12809,12842,8615,10696,14922,14922,17035,17034,17002,17035,17034,19049,23275,16936,10597,19016,27436,25388,23275,25356,112},
{46649,46649,46649,46617,46649,46616,46616,46649,46681,46649,46649,48697,46649,48697,48697,48697,48697,48729,48697,48697,48729,48697,48729,48729,48729,48729,48729,50809,52857,52857,52857,52857,52857,50777,48697,48697,48729,50777,48696,48697,48697,50777,50777,48696,48696,48696,48696,48696,48696,48729,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,44503,38230,36150,34037,34069,34069,31955,31923,29843,29811,29842,29810,29810,29810,29778,27665,29745,33938,40243,38066,42291,33774,29549,42160,33741,37934,27436,23275,19050,16969,21163,21163,16970,19083,19050,19050,21163,16969,19050,19082,14889,17002,16970,14889,19083,16937,16970,17002,14857,14889,16969,12776,14889,14889,12776,14890,12777,23308,21196,12809,12841,10696,6503,6503,6502,6535,19082,44339,38000,33774,23305,16967,16936,21096,42193,52855,57082,55002,40079,46319,40080,16905,12809,12809,14890,31694,50677,50710,50644,50579,52692,54804,35853,12742,21194,14823,23274,19047,19047,25290,29548,25352,16997,14886,33839,52724,46319,52822,52757,54936,35823,31628,14855,19047,23240,35917,27432,21159,10661,16968,35952,33807,19050,14824,25421,25356,21227,10954,15051,19115,14921,14921,12808,10695,10695,10663,10695,10663,12744,12744,10663,8583,10663,12809,12809,10696,4324,8583,12809,12809,12841,12841,12809,10728,12809,12841,14889,14922,14954,6502,8550,10728,12776,12809,12809,8550,10663,17002,19049,23275,23275,14823,21129,25355,25388,25356,23307,100},
{46649,46617,46617,46617,46616,46649,46681,46649,46649,46649,46649,48697,48697,46649,46649,46649,48697,48696,48729,48729,48729,48697,48729,48729,48729,48729,48729,50809,50809,50809,50809,52857,52857,50809,50777,50777,48729,48729,48729,48696,48696,50777,50777,48696,48696,48696,48697,48696,48696,48697,48696,48664,48697,48696,48696,48696,48697,48696,48696,46583,44470,44503,44503,42390,34036,31891,31923,31923,33971,31891,29810,29778,29778,29810,29778,27697,27697,27665,27664,29777,27664,29712,27632,38033,35823,33677,46352,44240,46320,42095,35854,25356,21196,23308,23308,23276,23308,25356,23308,25389,23308,23308,25356,23244,23276,23276,21196,23276,23244,23276,23276,23276,21195,21163,19115,19115,17035,14922,17002,19148,14889,12776,12809,14922,10729,6503,8583,12809,12744,25388,44338,31726,29547,27466,25355,19017,25355,38033,44436,48663,44405,35854,44240,35887,10663,12809,12776,12808,29581,50710,50677,42192,50643,52756,48530,27401,16902,31661,16904,17001,12774,21160,23242,27500,21191,16997,12774,38033,50643,46352,52790,52790,54936,27435,16967,10693,8580,8580,14854,27401,23207,12741,27468,35920,25388,23275,21195,23276,19082,21162,14823,14856,14888,12808,14888,19049,19048,16936,14855,14856,12776,10695,10663,8582,8583,10663,10696,10728,10728,6470,8615,10728,10728,10696,12777,8615,6470,10728,10728,12809,12809,14889,10696,10728,12809,12776,10696,10728,4292,6405,14856,21129,23243,25388,23210,25323,25355,25355,25388,23275,78},
{46617,46617,46617,46616,46616,46649,46649,46649,46649,46681,46649,46649,46649,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,50809,52857,52857,52889,50809,50809,50809,50777,48729,48696,48729,48729,48696,50777,50777,50777,50777,48696,48696,48729,48696,48696,48696,48697,48696,48696,48697,48696,48696,48696,48696,48696,38132,17003,17035,17035,12842,17068,21293,23341,23374,27567,25486,23406,25487,25454,23374,25454,25454,23373,23406,23341,23374,23406,23374,23309,42259,54871,44273,48433,42095,44272,42094,44273,35855,23211,21163,19115,17002,21163,19083,19082,21195,19082,21163,21195,17002,19115,19115,17002,19083,17002,16969,19083,16970,16970,17002,14889,14889,14857,10664,12809,19116,19148,21261,14889,14890,10696,6535,8583,10663,8615,21162,44306,31662,25386,27532,33840,27534,25453,27599,27534,27534,27567,29647,23275,16969,8582,10695,10728,6470,21194,50710,48597,50580,54837,54869,50643,37900,37900,42193,25290,19081,10661,16967,25354,27499,19078,19110,19048,33807,46417,48497,52790,52790,52790,23240,14853,12804,10692,6500,6435,19014,21126,23241,33871,27468,25388,25421,12743,16937,23308,21163,18951,12710,6469,6469,8581,10662,8548,12709,19015,19048,19016,16935,14824,12776,8614,8615,8583,8583,8583,8583,8615,10663,10696,10696,12776,8583,4357,10663,10696,10728,10696,10663,12809,14922,14922,14889,12809,12776,8550,8550,14856,21130,23243,27468,23242,23210,25355,25323,25356,21195,78},
{46617,46617,46649,46649,46616,46648,46649,46649,46649,46649,46649,48697,48697,48697,48697,48697,48729,48697,48729,48729,48729,48729,48729,48729,48697,48697,48729,50809,52857,52857,52857,50809,50809,50777,50777,48729,48696,48697,48729,48729,50777,50777,50777,48729,48697,48696,48729,48729,48696,48696,48697,48697,48696,48696,48696,48696,48664,48664,44503,31826,14922,12874,10729,10729,19148,25487,23374,25454,27599,25454,25454,25487,25486,23374,25454,25454,23341,25454,23374,23341,25454,29647,27566,44339,50643,48465,50545,40046,44240,40014,42095,44241,33709,29581,23275,23211,23243,23243,19082,21195,19050,19050,21195,19082,19083,21195,17002,19083,19083,16970,19083,17002,16970,17002,14889,14889,12841,10696,12809,10728,21261,27567,14857,16970,10696,6502,6502,6502,8583,19082,46419,27404,29547,29645,36018,29680,27534,27535,25389,25454,25421,23374,12808,8583,6502,8615,8614,6469,21162,50742,50710,50677,52756,52724,54837,50578,25320,14854,16935,14854,10725,16935,27435,29547,21159,19078,35854,37968,46352,50611,52757,52823,48532,27401,16998,16997,12805,8612,6500,14821,21127,38000,27436,19017,27533,23308,10631,19082,17033,10629,14790,8516,4355,4355,6436,4323,2243,6468,14853,16902,19014,27302,21063,12743,10663,12776,12776,10695,8582,8518,6470,6470,8583,8583,10696,8550,6470,10663,10696,12776,4357,4292,8583,10696,10728,12841,12809,12809,12776,12809,16969,21129,21162,27468,21096,23242,25355,23275,25356,19082,75},
{46617,46617,46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46648,48729,48729,48729,48729,48729,48697,48729,48729,48729,48729,48697,48696,48729,50809,52890,50809,50809,50809,50809,50809,50777,48696,48697,48696,48697,48697,48729,50777,50777,50777,48696,48696,48696,48729,48696,48697,48729,48696,48696,48664,48664,48664,46616,46583,33906,21228,14922,16938,14858,14890,19148,25519,25487,25454,23406,23373,23373,25486,23341,21261,23373,23341,21260,23341,23341,21260,23341,25454,25421,46419,48465,48465,50578,42127,46320,42159,44240,46353,42127,42127,40079,35821,40015,40048,29581,23243,21163,21130,23276,19082,19050,21195,19050,19082,21163,19050,19082,19050,16969,17002,14889,12809,12809,10696,10729,8616,12809,19115,19083,19115,17002,10663,6535,10696,10696,21163,46419,21065,25354,29646,33873,31728,35953,31695,25421,35986,27534,25422,19115,21195,14889,10696,10695,6469,19081,50678,50710,52790,54870,54837,54869,42190,19046,23273,16903,19079,19046,19015,27435,29580,23272,19045,46451,40114,44272,50644,52757,52855,48499,27401,19047,23304,16997,12772,6500,14853,29579,38000,16807,16969,27501,23340,17034,10694,6500,14885,16998,10660,8580,6500,4420,4323,4355,4355,4355,4323,6435,14789,18982,14822,16936,16936,12743,10663,12743,12775,10695,8582,8550,8582,8583,6470,6470,8615,8615,12809,4292,2211,6502,8615,8615,10663,10696,8615,10728,12808,16969,21097,21130,21162,12710,21161,27403,25355,25356,16969,72},
{46617,46617,46616,46649,46649,46649,46649,46649,46649,46649,46649,46649,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,50809,52889,52857,50809,50809,50809,50809,48729,48697,48729,48697,48697,48729,50777,50809,50809,50777,48697,48696,48696,48697,48697,48696,48697,48696,48696,48696,48696,48696,48664,48697,36019,21229,17003,21035,23083,16906,19180,25487,25486,23374,25454,23405,25454,25486,23406,23373,25454,23374,23341,25454,23373,23309,25454,25454,25421,42225,48465,50578,50611,42127,44272,44240,44240,46385,42127,42159,46385,42159,44240,46353,42128,40047,40015,35854,40048,37902,35822,37967,35822,35789,35887,33741,35822,35822,31661,33742,33774,27436,12777,12809,19083,17002,14889,17002,16970,14889,16969,12809,10696,12777,12776,23243,46451,31596,33773,33839,35986,25421,40146,29614,29647,38066,27501,27534,27502,23341,19147,19147,17002,12808,23275,48597,48597,52757,54869,54837,52691,33706,19047,25354,16903,23272,19111,19015,27403,31661,31658,19046,46451,40049,42160,52725,52790,54904,44273,23144,16903,27466,12773,14918,14885,12773,38032,33775,25227,25324,25388,25421,10726,8580,10725,14917,17029,19110,17029,10692,6467,8580,8580,4355,2243,4323,2211,4291,10629,14822,12741,14854,14822,16968,12743,10663,12743,12808,12776,12744,8582,8550,8550,8550,8550,6470,6469,6469,8615,10695,8647,8615,8583,8583,8615,10663,16937,16937,16937,19017,12678,16904,25323,25323,23307,19049,76},
{46649,46649,46616,46649,46649,46616,46649,46649,46649,46649,46649,46649,46649,48729,46649,46649,48729,48729,48729,48696,48729,48729,48697,48729,48697,48697,48729,50777,50809,50809,50777,50809,50777,50777,48696,48697,48696,48696,48696,48697,48696,50744,50777,50777,48696,48696,50777,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48697,35987,21229,16971,25163,25131,16905,19148,25487,25487,25454,25454,25454,23406,25486,25454,23341,25454,23373,23341,25454,25486,25421,25421,25421,25421,40145,42160,44305,52724,40046,44240,44240,42159,46353,42127,42160,44272,40046,42159,44273,46385,44240,44240,40014,46321,44240,42127,46353,42159,42127,44273,40047,42127,44272,40014,42160,31661,27436,19082,19082,16970,19050,19050,16970,14889,14889,14889,14857,12809,23341,10696,23243,46386,42160,44305,35886,33840,19115,38098,31759,23308,40179,25421,23341,17035,10760,8615,8615,8615,10728,21162,48597,48564,52789,52756,50610,42125,46384,31627,33774,16936,25387,19079,19048,25355,33773,29546,21127,50612,44307,48564,54870,52758,54903,42160,27337,14822,23273,6467,12741,21159,25386,38000,27468,27469,25389,25356,21162,8581,6500,10725,10724,10724,14885,14917,12836,12772,12805,10660,10693,6500,6436,4355,4323,6436,6436,10661,16869,18916,12742,12775,19049,14856,10630,10630,10663,12743,10695,10663,10663,8582,6470,6437,6437,6502,8583,8615,8615,8583,6502,6502,10663,16970,14857,12711,23242,16936,12710,19049,25355,23275,21130,72},
{44568,46616,46649,46649,46649,46649,46649,46649,46649,46649,48697,46649,46649,46649,46649,48729,48729,48729,48729,48697,48729,48729,48697,48729,48697,48729,48697,48729,50777,50777,50777,50777,50777,48697,48696,48696,48696,48696,48729,48729,48696,50777,50745,48729,48697,48697,48729,48696,48696,48697,48697,48696,48696,48664,48664,48696,48664,48697,33906,19148,14923,21035,25131,16906,19148,25519,23406,25487,25454,23405,23374,25487,23341,23341,25454,23341,21261,23341,23373,21260,23341,23341,21260,23308,23341,27468,50612,42094,44240,42159,40046,44272,42160,40047,44240,40046,42127,44305,40046,42160,44273,40046,44240,44240,42127,44272,44240,42127,44272,42160,40079,44240,42095,40047,25355,19082,19050,19050,14889,14857,16937,14921,14921,14889,14857,14889,12841,14955,8583,21163,48564,48499,46419,42226,19050,8550,25421,29647,17002,27534,17002,21261,12809,14954,6535,8615,8615,14922,19082,48629,48564,54870,56951,54837,40012,50577,46352,44339,16936,23274,21192,21096,27435,35854,29545,25320,52757,57017,52758,52790,52790,50677,42160,40080,27467,19046,12773,8580,16998,38032,29548,27469,27533,25389,23276,33872,23339,6500,6467,10692,10692,8612,12772,10724,12804,14885,10724,8612,8580,6500,6436,4355,12742,14823,16903,19048,16935,14856,14856,16969,23243,16969,14888,12775,10630,10631,10663,10663,10663,10663,8550,6469,6470,6470,6502,6502,8550,8583,8551,12776,21196,14889,12711,29549,21129,12710,14823,25355,23243,21162,69},
{44568,44569,46649,46616,46649,46616,46681,46649,46649,46648,46649,48697,46649,48697,46649,48697,48697,48729,48729,48729,48696,48697,48729,48729,48729,48729,48729,48729,48729,50777,50777,48729,48729,48696,48696,48696,48696,48696,48697,48697,48729,48697,48697,48696,48697,48696,48696,48696,48696,48696,48697,48696,48697,48696,48664,48664,46616,48696,33906,21228,14987,19051,23115,16873,19148,27600,25486,23406,25487,25486,25487,25486,25454,25454,25486,25486,23373,25454,23373,23373,25454,25486,23341,23341,25486,27501,50612,42127,44240,44272,44240,46353,44272,42095,44273,44207,42127,46353,42159,42159,46353,42127,44240,44272,42127,44240,44272,42094,44272,44240,40046,44240,44207,37935,25356,19082,17002,19018,16970,16970,19050,19050,16969,16970,16970,16937,17003,12842,8583,21163,48531,48531,50644,54872,29582,14889,19115,25454,19115,23341,17002,19148,10728,17034,10728,12809,8615,10695,19049,48629,52757,54902,54870,56983,56950,56917,48498,42193,16904,21194,19079,21096,27468,35886,37932,29578,52757,56984,52790,52790,52823,52758,42192,14854,6436,12805,16965,10724,27532,38000,19049,29581,27469,25356,31792,44404,19146,8645,10692,12837,14885,10724,14885,14949,14917,12837,10692,16966,16966,12740,12773,21128,29548,29516,23275,23307,19082,17034,17002,17001,25356,19114,17001,19082,23243,16936,12711,10630,6405,6437,6437,8550,8582,8550,8550,6469,8550,8550,8550,10696,17035,19083,14856,27468,25322,14790,19016,25323,23243,19050,39},
{46649,44568,46649,46649,46649,46649,46649,46649,46681,46681,46649,46649,48697,46649,46649,46649,48697,48729,48729,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,50777,50809,48729,48729,48697,48696,48696,48697,48729,48729,48729,50777,48729,48697,48696,48697,48696,48696,48696,48696,48664,48696,48696,48697,48696,48664,48696,48696,48697,33906,21228,12842,16938,23083,16906,19148,21261,25454,25454,23406,23373,25454,25454,25421,23341,25422,23374,21261,23373,23341,23309,23341,25486,23341,23341,25422,25421,42226,37999,38000,40080,40112,40112,40112,40080,42160,40112,40080,42192,40079,42128,42160,40047,42160,42192,40047,42160,42160,40079,44240,44272,42127,42160,40080,27435,23243,21163,21131,21163,21163,21163,21163,21163,19082,19083,19083,19082,19083,17002,16970,25356,48499,48531,50645,59228,46485,25421,23308,29680,27534,29647,23341,21261,19115,19116,10696,10696,6470,6470,16969,48565,50645,54870,54902,54902,52756,37966,42225,48531,19048,19114,19111,25353,27467,35853,40012,37965,48531,44273,50611,52790,54904,44338,19014,8548,2275,6403,12773,19047,40145,23308,16969,27501,25388,31695,42291,19015,10694,10726,14886,16997,16997,16997,14916,14884,14917,16933,21126,27433,27401,31595,33773,33774,31661,23275,16969,16969,14889,12809,12809,14889,19082,14921,14889,16937,23275,25355,21195,16937,10630,8550,4324,6437,8549,8550,10663,10663,10631,8517,6437,12775,21195,16970,14856,27468,23242,21129,25323,25322,23242,14889,17},
{46649,46649,46649,46649,46649,46649,46649,46649,46649,46648,46649,46648,48697,46649,46649,46649,48697,46649,48697,48729,48729,48729,48729,48729,48697,48729,48729,48729,50809,50777,50809,50777,48729,48696,48696,48696,48697,48696,48729,50777,48729,48729,48729,48696,48697,48697,48696,48697,48729,48697,48696,48696,48696,48696,48696,48664,48664,48697,35986,21228,14923,19019,23083,16938,19148,19180,25487,25486,27599,25453,25454,27567,25486,25421,25486,25454,23341,25454,23373,23309,23373,25454,23373,25454,23373,23341,23308,23341,21228,23308,25389,23308,25389,29614,25420,25388,29582,27468,25388,29581,23308,23308,25421,23308,23275,25421,25388,29548,31627,48498,42225,27435,23243,19050,23243,21162,21130,21130,19082,19050,19082,19050,19050,16970,16970,17002,21163,19050,10664,23276,48531,48498,52790,59196,35921,25389,25454,31760,27567,29679,25422,25422,21261,21228,10696,8551,6470,8582,16937,42193,46451,56950,56950,44272,16902,8549,10662,19081,14855,19081,19046,25353,27467,35853,37931,40078,46418,39980,50546,54871,50678,19046,14853,6436,4356,4356,4291,23274,42258,27501,25356,27469,27501,44437,29581,12709,10662,10662,10694,12806,14918,19079,19079,19079,25353,31627,33739,35852,35853,33773,31661,27468,25356,17001,12809,12809,12777,10728,12809,12809,14889,12776,12776,12776,19017,21130,16969,12776,10663,10663,10663,8582,8517,6437,8550,8550,8550,12743,8550,16968,27501,14856,16936,25323,16903,25323,25290,25323,23243,14857,15},
{46649,46617,44568,46616,46616,46649,46616,46649,46649,46649,48697,46648,46649,48697,48729,48729,48729,48697,48697,48696,48729,48729,48729,48729,48729,48697,48697,48729,50809,48729,48729,48729,48729,48697,48696,48696,48729,48696,48729,48729,48729,48729,48729,48696,48696,48697,48729,48729,48697,48697,48697,48696,48696,48696,48696,48664,48696,48729,33906,21228,14955,16938,23083,16938,21229,25519,25487,25454,25486,25486,25454,27599,25454,23373,27599,25422,23341,25486,25454,23341,25454,25454,25421,25486,23373,23308,23309,25454,23309,25389,29614,25389,27501,29614,27501,27501,29647,27501,25421,27534,23340,23308,23341,21228,21195,23308,23340,25388,27403,44370,42225,23275,19083,19050,21163,23275,23276,23275,25324,23243,23243,23243,23243,21131,21163,21163,19050,25357,23308,23308,48499,48498,50645,50711,25357,25422,25421,29680,29680,29680,25454,23374,21261,23341,14922,12809,4357,8583,14888,33741,46418,52691,48562,21160,6468,6469,4389,6469,10695,16936,16934,23241,29516,35886,31625,40079,44273,40045,50643,54871,40177,19078,14917,10661,6436,6436,6404,38000,37999,27501,27501,27501,38098,36017,25354,25420,14888,8549,8549,10662,12808,17001,21162,23274,27468,33709,33741,33741,31629,29516,29516,27436,23275,17002,14889,14889,12777,10728,10728,12809,16970,12744,10695,12776,16969,19082,16969,12776,10663,10663,10663,10663,12776,10662,10630,8582,6437,8517,10630,23242,29581,21195,21195,27469,23242,25323,23242,25323,23243,14889,13},
{46617,46617,46616,46649,46649,46616,46616,46649,46649,48697,48729,46649,46649,48729,48697,48729,48729,48697,46648,46648,48697,48697,48697,48697,48729,48696,48729,50777,48729,48729,48729,48729,50777,48697,48696,48696,48697,48729,48729,48729,48697,48729,48729,48696,48696,48696,48697,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48697,35986,21228,14922,16938,23083,16938,21261,27632,25487,27567,25486,25421,25421,25454,23373,23341,25454,23341,21261,25454,23341,21228,23373,25421,21260,23373,23341,21228,23308,23308,21228,23308,27501,23308,27501,27534,23308,25388,27534,23308,25388,25421,23276,21195,23308,21195,19115,23373,23308,25388,25323,38032,35919,23243,19082,19115,23243,23276,23276,23275,23275,23275,23275,23243,21163,21163,21163,21163,19050,21195,14857,25355,46418,48466,48532,44372,29648,29647,27567,29647,29647,27567,23373,25454,21261,21261,12841,10761,4389,6502,14856,42225,52723,48464,33738,14885,10694,6469,6436,10631,12808,6469,6500,23241,27467,31628,35852,42192,37934,40014,50644,54871,35885,21190,19110,12806,4323,4323,19048,46418,33742,31694,29549,31695,36017,14855,21096,14855,10694,6469,6436,6469,12808,14921,21195,25388,27403,29581,31629,31629,27468,27436,29548,27468,25355,19082,14857,12809,12809,12776,10728,14889,17002,12776,10696,12776,14889,14889,14856,12744,8615,10663,8583,8550,10663,10695,12808,12743,8550,8550,12743,25387,25323,23275,23372,25420,27436,27371,23210,25322,23242,19050,21},
{44568,46617,46649,46616,46649,46649,46649,46649,46649,46649,46649,48697,48729,46649,46649,48697,48729,48729,48697,48729,48729,48697,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48697,48697,48696,48697,48729,48729,48729,48697,50777,48696,48696,48696,48696,48697,48697,48697,48697,48664,48696,48696,48664,48696,48664,48729,38099,21196,14955,18987,23050,16938,21229,29680,25487,27567,29647,25454,25486,27567,25486,25454,27567,25454,23373,27567,25454,23373,25486,25486,23341,25454,25454,23341,25453,29581,29581,29581,31662,29581,31662,31694,29582,29582,29614,29549,29581,29614,27501,19115,19115,17035,17002,21228,19115,25356,27403,42225,38033,21195,17034,19115,25389,23276,23243,23276,25324,23275,23275,23243,23243,21163,21163,21163,23276,19082,19082,27468,48531,48531,50612,46484,25421,29648,27567,29647,29647,27567,25454,25454,21228,17035,8583,6502,4389,6470,16969,42193,52724,52658,33803,16998,12806,6469,6437,10695,17001,10661,12806,21128,27467,31627,35820,44338,33741,35789,52789,52822,33772,21158,17030,8548,4355,10628,35951,42193,33774,31662,29646,40211,23307,8548,14855,10661,10694,6436,4388,6468,10727,14921,21194,27500,29580,31629,31629,31661,27468,27436,29581,27468,25324,17002,12809,12809,12808,12809,12776,14889,19050,14856,12744,14857,16969,14889,14889,10695,8583,8583,8583,8550,8550,8550,8582,10663,12743,14823,21162,25355,23275,21195,23340,16968,27404,25323,14823,23210,23210,21194,43},
{46649,46649,46616,46649,46649,46649,46681,46681,46649,46649,48729,46649,46648,48697,48697,48697,48697,48697,48729,48729,48729,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48697,48697,48697,48697,48729,48697,48696,48696,48697,48729,48729,50777,48697,48697,50777,48697,48697,48696,48729,48696,48696,48664,48696,48696,48664,48696,48729,33906,21228,12874,16938,23083,16906,21261,27599,25487,25486,25454,23373,23373,25486,23373,23341,25454,23373,23341,23373,23341,23308,23373,23373,21261,23341,23341,21260,29646,33807,33741,31694,33774,33774,33742,33774,31694,33742,31694,31694,31694,31694,31662,14889,8615,10696,8648,8616,8616,21130,27403,44339,35952,21163,17035,19083,23308,23243,23243,23243,23243,23243,23243,21163,21163,21130,21163,21130,25356,21163,12776,23242,48531,50644,50613,44274,23276,29680,27567,27567,27567,27567,25422,25454,19116,19148,10728,10761,4389,4422,19049,40112,50610,52690,33771,16998,12806,6469,4356,8581,14951,14918,10661,21129,31628,37965,42125,54870,44243,50612,54838,54903,31691,19077,14917,6468,4356,19080,48499,37966,33807,29614,25452,19178,8516,6436,4323,4388,8581,4356,4388,6468,8581,12808,21194,27468,31629,33774,33774,33742,25355,25388,29581,27436,25356,17002,14889,14889,12809,12809,10728,14857,17002,12809,10696,14889,17002,14921,14857,10696,8550,8583,8550,6502,6470,8583,8550,8550,10630,16969,23242,25323,23275,21195,23243,25323,27402,23176,12710,14823,14824,14823,51},
{46649,46649,46616,46649,46649,46649,46649,48729,48697,46649,46649,46616,46649,48697,48729,48729,48697,48697,48729,46648,48729,48729,48697,48697,48729,48729,48729,48729,48729,48729,48729,48697,48696,48729,50777,48729,48696,48696,48697,48729,48729,50777,50777,50777,48697,48697,48697,48696,48696,48696,48696,48664,48664,48696,48696,48696,48664,48664,31760,21228,14955,18986,23083,16906,21261,27632,25454,25486,25486,27566,25486,27567,27534,23373,25486,23406,23341,25454,25421,21292,23373,25453,23341,23373,21260,21260,31759,25388,23275,25355,25388,27436,25356,23308,23307,25356,25356,27468,25388,27468,25388,14889,10696,12809,12776,10728,8616,19049,25355,35952,25388,19082,19115,19082,23308,25356,25324,25356,25356,25323,25324,23276,23275,23243,23243,23243,21163,23244,19050,27436,48498,50645,57082,54904,40146,31792,19115,19115,19115,19115,17067,17035,14922,21261,14889,12841,6501,8614,14887,40144,52756,54804,42158,16966,8581,10662,6436,8549,19079,17030,8581,23242,31661,35917,40077,52725,56920,54871,52823,54903,33804,21190,16997,8580,4323,27467,48498,37934,33807,29613,14888,6436,6468,6468,4324,2243,6436,6436,6468,6468,8581,10694,23242,29548,29581,31693,33742,31694,23243,23275,29549,29549,25388,17002,14889,12809,12841,12776,10728,12808,17001,12776,12776,14889,19050,16969,12808,10695,8583,8583,8583,6502,6470,6470,6437,8550,8582,12743,19081,23243,21162,21130,16904,25323,29449,23143,21096,21097,19017,16936,56},
{46649,46616,46649,46649,46649,46649,46649,46649,48697,46649,46649,48697,48729,48729,48697,48697,48729,48697,48697,48729,48729,48729,48729,48696,48729,48729,48697,48729,48729,48696,48696,48697,48696,48729,48697,48729,48697,48729,48729,48697,48729,50777,48697,48697,48729,48696,48696,48696,48696,48696,48696,48664,48696,48696,48696,46616,48664,48664,31761,21164,12874,14858,16906,14858,21261,27632,27567,27535,27534,27566,27566,27567,25486,23341,25454,25454,23341,25454,25454,23341,23373,25486,23373,25454,23341,23308,29647,12808,12841,14857,14889,16969,12808,10696,10728,14857,16937,16970,14857,14857,12776,12809,12808,21162,21130,23275,10663,21162,23210,21162,21163,21163,19115,19083,23276,25356,25356,25356,25356,25356,25388,25356,23275,23275,23275,23276,21163,19082,12744,23275,48499,52758,59196,54936,40211,31824,17002,12777,12809,12777,10729,10696,10728,14890,12808,14919,10694,16966,21127,38031,54804,54869,42159,12773,8549,8549,10694,10694,16999,19078,12741,25322,31661,35885,40044,52725,48499,50611,54871,52823,31723,21158,14853,8613,8516,40112,42192,37935,33774,40178,35985,10693,8581,6468,4388,4323,4323,4356,6468,6500,8613,10694,21128,25322,29580,33774,33774,31661,21162,23275,29581,29581,23276,14889,12841,12809,10728,10728,10728,12809,17002,12776,10696,12776,19050,16937,12808,10695,8615,8583,8582,6470,6470,6502,6470,6437,6470,10695,16937,21195,21162,23243,18887,14693,16903,23177,23209,23177,21097,21162,64},
{46649,46649,46649,46649,46649,46649,46649,46649,48697,46649,46649,46649,48697,48729,48729,48697,48729,48729,48696,48696,48729,48729,48729,48729,48697,48729,48697,48697,50777,48729,48697,48729,50777,48729,48697,48729,48696,48697,50777,48697,48729,48729,48729,48729,48696,48696,48696,48696,48696,48696,48696,48696,48664,48697,48696,48664,48696,50777,35986,25389,14922,12874,10761,12875,21229,27600,27535,25486,27566,25486,25454,27534,25421,25454,25486,23374,23374,23341,23373,23341,23341,25422,23341,25454,23309,21228,29615,17002,14889,14889,12808,17002,14889,14889,17002,16969,14889,17002,14889,16970,16969,14889,17002,23275,23242,25356,10631,21162,21130,19050,21163,21195,21195,19082,23243,25324,25324,25323,25324,25324,25356,25324,23275,23275,23243,21195,21163,21195,16970,25356,48499,52791,57082,52790,38065,33905,27534,27534,25454,25422,21228,21228,17003,14889,19080,16966,12774,12774,21127,42160,56949,56982,33771,14854,12774,8581,8581,10662,16967,21191,19046,27434,31661,35884,40077,54935,35854,44272,54935,46483,25352,21158,14917,6500,16903,48530,37934,33742,35920,48663,40211,8580,14886,12773,6532,6532,4388,4323,6436,6500,8581,10693,19079,23208,23274,25388,27468,23274,14856,19082,27501,27501,23275,14921,12776,10696,10696,10696,10728,12809,14889,10663,8615,8582,10695,6437,4324,6469,6502,8550,8550,6470,6502,6502,6470,8518,8550,10630,12743,14856,19049,31727,16904,8484,12710,16871,16871,12710,19016,19081,58},
{46616,46616,46649,46616,46649,46649,46649,46681,48697,46649,46649,46649,48697,48729,48697,48697,48729,48697,48729,48697,48729,48729,48729,48729,48729,48696,48729,48697,48729,48729,48729,48729,50777,48729,50777,48729,50777,48697,48729,48697,48696,48696,48697,48696,48696,48696,48696,48696,48696,48696,48696,48696,48697,48696,48664,48696,48696,48729,38099,27502,17003,12842,10730,12810,21261,29680,27535,27534,31760,27566,27566,29647,25453,31793,31825,31826,33874,31794,31793,31793,29713,31793,31761,29713,31793,31729,38034,25356,14857,14889,14889,16969,14921,16969,19115,16969,14889,17002,16970,16969,16969,16937,19082,23275,23242,25356,10663,23243,21130,16969,21195,21195,21196,19115,21163,21130,21130,21130,21131,21098,21130,21163,19082,19082,19050,16969,21163,21195,12744,23275,48531,50677,48597,46419,33839,31760,29647,29680,29680,29647,25454,25486,25389,25290,21159,19046,14918,19079,23272,29546,33773,35885,27466,14854,12806,8614,4356,6469,16967,21191,19078,25354,29580,35885,42190,54903,33708,46418,54870,46450,31691,21158,14917,8579,27467,46418,29483,25323,44371,50776,25420,12709,23207,21127,10693,8645,4420,4356,4355,6468,8581,10725,16998,19047,21161,19081,23241,19015,14823,21162,27468,27501,23276,12776,10728,12809,10696,8615,8615,6469,6469,6469,6436,4323,4291,2178,2146,4324,8550,8550,6470,6437,6470,6470,6437,6405,10631,10631,12776,16936,16969,16969,21162,21129,25290,23177,23177,23209,23242,19049,57},
{46616,46649,46649,46649,46649,46617,46649,46649,46649,46649,46648,46649,46649,48697,48697,48697,46648,48697,48729,48729,48729,48697,48697,50777,48729,48697,48729,48729,48696,48697,50777,50777,48729,48729,48697,48729,48729,48729,48696,48697,48729,48729,48696,48696,48697,48729,48696,48664,48729,48696,48664,48696,48696,48696,48696,48696,48696,48697,42292,33808,29550,27502,27503,25389,40114,46452,46420,44372,40114,33840,33808,33808,31695,33873,31793,31826,27568,31793,31826,29745,31793,31793,31826,31826,31761,27340,31630,21195,14890,14889,16970,17002,14889,17002,19082,16969,16969,19082,16969,19050,19050,16937,19050,23275,21162,23275,10663,23275,21130,19050,21163,23244,21196,21196,19083,25356,23243,23243,23243,23276,23243,23243,23243,21195,19115,17002,19115,19083,17002,27469,46418,37999,52823,48564,31727,29680,27567,27567,27566,27567,23341,23373,21130,31433,25320,19078,19079,21160,27498,19047,12678,19015,25321,21159,14886,8581,4324,6469,16935,16966,10628,27435,31661,35884,44304,52790,31595,48531,52823,54903,37998,21190,14885,12741,42192,42192,29516,31661,50743,46517,14855,19048,23240,21127,10693,10725,4420,4324,2275,4355,6500,12806,19047,16998,16967,19048,23240,16935,14888,19082,27501,29581,19082,12809,10728,10696,8583,8583,6469,4323,4356,6404,2211,2210,2211,2210,4291,6437,8550,6469,8518,6437,6470,6437,4324,2179,6437,10663,14824,16937,14856,12744,14889,16904,27435,25290,23177,23210,25290,16969,60},
{46649,46649,46649,46616,46649,46649,46649,46649,48729,46649,46648,46649,48697,48697,48729,48697,48697,48729,48729,48729,48761,48729,48697,48729,48729,48697,48729,48729,48696,48729,50777,50777,50777,48729,48696,48697,48697,48697,48729,50777,48729,48729,48697,50777,50809,50809,48696,48696,48729,48696,48696,48696,48696,48696,48697,48697,48696,48696,50776,52823,57050,57082,57050,57050,57018,57017,54969,54969,54969,54969,54969,54937,57018,40179,31761,31794,27567,29713,29745,31826,31794,27600,25487,29681,25390,23179,19018,12776,17002,12809,14889,12809,12776,14889,17002,16969,16969,19082,16937,17002,19082,16937,16969,16969,16937,19050,10663,23243,21130,19082,23276,29647,29647,27535,21195,21130,19050,19018,19050,19050,19018,19050,19050,19050,14921,17100,17101,17068,14857,27468,35854,35854,52823,46419,27500,27567,19115,17002,19115,17034,19115,17002,27273,35528,18983,12774,10630,12774,19048,12775,8517,10630,19048,23305,12805,8646,4356,6437,16967,12741,8516,29515,31661,33771,46417,48564,31595,52757,54871,54903,35854,21126,12804,16966,48498,40047,35854,44339,54969,38000,23210,23242,21096,14854,10693,10725,4388,2275,4356,6436,6500,12806,19079,19046,14821,18983,27401,25355,16969,19082,21195,21195,19115,12776,8550,6470,6501,6502,4356,4323,6436,4291,2211,2211,2210,2178,2178,6404,6469,8582,8517,6436,8549,8550,6404,4291,6404,10663,14856,14889,14856,14889,21228,12743,21097,25355,25290,23209,23210,16937,66},
{46649,46649,46649,46649,46649,46649,46617,46649,46649,46616,46649,48697,48729,48729,48729,48697,48697,48729,48696,48729,48729,48729,48729,48697,48697,48697,48729,48729,48729,48729,50777,50777,50777,48697,48729,48697,48697,48729,48729,48729,48697,48696,48696,48728,50777,50777,48729,48696,48696,48696,48696,48696,48696,48696,48697,48696,48696,48696,52824,50742,57082,57082,57050,57050,57082,57082,57083,57082,57082,57050,57082,57082,57082,42259,31793,31794,27568,29681,31794,31794,31826,23342,12843,17004,25454,23244,19083,12809,14921,12809,12809,10728,12776,12809,14889,14889,14889,17002,14889,14889,16969,12776,14857,14889,14889,16969,12776,29581,21130,19082,21195,29680,29680,27599,23275,25323,23275,23211,21163,16937,19017,19017,19018,19017,19050,23309,21228,19148,10664,21162,27434,50678,50645,48499,29614,27567,25389,19082,23308,19115,23308,19017,31368,39656,14790,8550,8550,12710,12807,8549,6469,8517,14854,16998,10725,8581,4388,8549,16935,14854,10629,27467,31628,35884,48563,46451,33675,54870,52823,52790,27434,16965,14852,31660,46418,40047,40080,52823,50743,31726,40113,42193,23273,12773,8613,8612,8581,6436,4388,8581,8613,14918,19079,19014,16935,21095,31660,23242,6437,6404,2210,6469,12743,8550,2243,2243,6436,4356,4323,6404,4323,4291,4291,2210,2210,2210,4291,4324,4324,8550,8517,6404,8549,6469,6469,6437,8550,10663,14856,14889,12776,21228,25486,14889,12775,19081,23242,25323,21097,12776,58},
{46616,46649,46649,46649,46649,46617,46649,46649,46616,46648,48729,46649,46649,48729,48697,48729,48729,48729,48697,48729,48729,48729,48729,48697,48697,48729,48729,48697,48729,48697,50777,50809,50777,48729,48729,48696,48729,48697,48729,48696,48696,48696,48696,48729,50777,50777,48729,48664,48696,48696,48696,48696,48697,48697,48697,48697,48696,48697,52856,50710,57050,55002,57050,57050,57050,57082,57050,57050,57050,57082,57050,57115,57082,42324,31793,31794,27600,29713,29745,29713,29713,25455,19181,23342,31760,21195,21195,14889,14921,12809,12809,12809,10728,12776,12809,12777,12809,14921,14889,14889,14889,12776,12809,12809,12776,12776,12744,33775,21162,19050,23275,33873,33938,31792,25420,27468,25356,21130,27436,23243,23243,23243,21163,16969,19050,23309,23276,19148,10664,16968,27467,57115,52791,50677,42259,27534,25421,23340,29614,23276,25421,21098,37641,39688,16871,10630,10630,10662,10662,8549,8550,16967,25353,21191,12773,4388,6436,8549,14855,19079,19112,33742,31661,37965,50643,48564,39981,54903,52855,50677,21160,16965,14885,42224,44272,40079,44339,55001,38065,4355,8548,14854,21127,12805,10693,6532,8581,6501,6500,8645,10725,19079,23240,23208,16967,25354,27500,6436,2211,2210,4323,4291,2243,2211,2210,2243,6436,4291,4291,6404,4356,4291,4291,2211,4291,4323,4323,2243,4291,4324,4356,6436,8517,6437,6437,6469,10662,12711,14856,14856,12776,14856,21228,16937,12743,14856,16937,21130,19050,14856,65},
{46616,46649,46649,46649,46616,46649,46649,46649,46616,46648,48729,46649,46649,48729,48729,48697,48729,48729,48729,48729,48729,48697,48697,48697,48729,48729,48729,48696,48729,48729,50809,50809,48697,48729,48697,48696,48729,50777,50777,48729,48697,50777,50777,48697,50777,50777,48696,48696,48697,48696,48696,48696,48696,48729,48696,48664,48696,48696,50808,52791,57050,57050,57050,57082,57050,57050,57050,57050,57050,57082,52824,50711,48631,35953,31793,31793,27600,29713,29713,27632,31794,31858,33907,31826,33905,21195,21227,14889,17002,12809,12809,10728,10696,10728,12777,12777,12776,14921,12808,12776,12809,10728,10728,10728,10696,10696,8616,19114,19082,19082,23308,35986,35986,33905,27469,23275,21162,19049,31661,33742,33742,31596,29483,25258,27371,29516,29484,27436,19016,25322,37966,59228,52823,50710,44340,25421,23341,21228,23341,21195,23276,21130,39721,39656,18919,12711,10630,14823,12774,12742,8549,12742,21159,25319,19078,10693,6436,8581,14855,21193,25419,38033,29580,35820,50709,54903,44239,54871,54903,50677,23271,17029,23272,48530,40047,40079,48630,54936,25419,8548,10661,12741,19078,12805,10693,10693,6500,4355,6500,8645,12805,21127,25321,25321,14854,14855,10629,2243,2210,4323,4356,2243,2243,2211,2211,4323,4355,4291,6404,6436,4356,4323,4291,2210,4291,6404,4323,4291,4291,4291,4291,2211,6404,6436,6437,6437,10630,16969,16937,14856,12743,10630,14824,16937,14856,12743,10663,12776,16969,14856,72},
{46649,46681,46649,46649,46649,46649,46649,46616,46649,48697,48729,46649,46649,46649,48697,48729,48729,48697,48697,48697,48729,48696,48729,48729,48729,48729,48729,48729,48729,48697,48729,50777,48729,50777,48729,48729,48729,50777,50777,50777,50777,50809,50777,48696,48728,48729,48729,48696,48696,48696,48696,48664,48664,48664,48664,48664,48696,48696,50776,50710,57050,57050,57050,57050,54970,57050,57050,57050,55002,57082,50678,38099,36018,29647,31826,31794,27600,29713,31794,31826,31793,25487,21261,17035,29647,23275,21195,14889,17002,12809,10728,10728,10696,10728,12776,12776,12809,16970,12776,12776,12809,10696,10696,10696,10664,8583,8583,14857,17002,19082,25388,35986,31792,31792,25356,23243,19082,19049,29549,31629,31597,35757,44110,46125,48204,48237,50351,52561,42062,37901,42192,54937,54936,54936,40114,27502,27567,27534,27534,25422,25390,25356,37641,31368,16839,12678,14790,21160,23240,21160,8581,12742,21127,37998,23271,14885,10693,14822,16935,21194,21226,33807,29580,27434,52758,52790,46352,54903,54904,48532,19046,19078,31691,48530,40014,42192,52888,52823,25355,10596,19047,16967,16934,12774,6500,10693,6468,4387,6500,10693,14854,21127,29514,23209,10662,4388,4356,4291,4291,4291,6404,2210,2243,4291,2210,6404,4323,4291,6436,6436,6436,4323,4323,2243,4323,6436,4291,2211,2211,4291,4291,4291,4291,4324,6404,6437,10630,19049,16969,14888,12775,8550,12743,14888,14856,14889,14889,10631,14856,14889,70},
{46649,46649,46649,48729,46649,46616,46649,46649,46649,48697,48697,46649,46649,48729,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,50777,50777,50809,48729,50777,48729,48729,48729,48697,50777,50809,50777,50809,50777,50777,50777,48696,48729,48696,48696,48697,48696,48696,48696,48696,48696,48664,48696,48696,48696,50711,57050,57050,57050,57050,57082,57050,57050,57082,57082,57082,48598,42325,36018,31728,31761,29713,31761,31761,29616,23277,17002,12809,10697,12777,29582,23275,21163,12809,12841,12809,10728,10761,10728,10728,10728,12809,12809,16970,12776,12776,14889,12777,12809,10696,10664,16938,8583,14889,19050,19082,23341,33905,33873,31792,25389,25356,25356,23243,25324,29484,31565,31564,31532,31532,29419,31499,35660,37902,35758,33677,42257,48565,48564,57017,38000,29615,29679,29647,27534,25422,23341,27404,37641,33480,29319,29352,21063,23240,25385,21160,6468,14822,27433,44305,29580,8613,10725,21128,19016,21194,16968,33774,31628,35853,52790,50644,46385,56984,54904,44306,19014,19110,40143,44272,37966,46452,57082,33807,4226,18982,29513,23241,12773,8613,6532,8613,8581,6500,8613,12838,14886,19047,25321,23209,8581,4388,4291,4291,6404,4355,4323,2211,4291,2210,4355,6436,2243,2243,4291,6468,6468,4323,4356,4291,6404,4323,4291,4323,4291,4291,4291,4291,4291,2243,4291,6404,8549,16936,14888,14888,12776,10663,12776,14856,14856,21260,25422,10631,12776,14888,62},
{46616,46649,46649,46649,46649,46649,46649,46649,46616,46649,46649,48729,48729,48697,48697,48697,48697,48697,48697,48697,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,50777,48729,48729,48696,48729,48729,48697,50777,52857,50777,50777,50777,50777,48696,48696,48696,48696,48696,48696,48664,48696,48696,48696,48696,48664,48696,48696,48664,48664,52889,54969,54937,52889,52889,54969,52889,54970,52857,52856,54969,59163,42129,40113,42291,44340,42259,42226,40113,38001,38000,38033,38000,38001,38001,19050,19115,10728,10728,10761,10729,10696,10696,10728,10728,12808,12777,12809,12776,12809,12809,10696,10696,10696,8615,29517,25356,21195,19082,21195,21196,21195,19115,19147,21228,21131,25324,27437,29485,27436,33710,33710,31630,31565,27372,29453,29517,25388,21162,33741,44305,54871,46418,57017,38097,27567,29647,27567,25454,21260,21228,27403,45895,45993,41963,27304,12678,16903,21127,16935,6436,14822,21127,42192,35919,10661,8613,12774,16936,21194,16935,31660,31692,40110,52789,42127,40047,54935,52823,37999,16966,23303,46450,42159,40079,52791,54969,16968,4291,12773,12773,21193,21160,10693,8613,8581,8645,8613,8613,14886,16966,21160,19015,23306,8581,4356,4323,2211,4323,6468,4356,2211,2211,2178,6436,6500,2243,4356,6468,8580,6435,4323,2243,4356,6436,4355,4323,4291,4291,2211,4291,2211,2211,2210,4291,4323,6372,10630,12807,14856,12743,12743,14824,16839,14791,19115,25421,12743,12776,12743,46},
{46616,46649,46649,46649,46649,46616,46649,48697,48697,48697,48729,48697,46649,46649,48697,48729,48697,48729,48729,48729,48729,48696,48729,48761,48697,48696,48697,48729,48729,48729,48729,50777,50809,50809,48696,48729,48697,48696,50777,50809,50777,50776,50777,50777,50777,48696,48697,48696,48696,48696,48664,48696,48696,48696,48696,48696,48664,48664,48696,48729,48696,48664,48664,44503,40277,38230,36117,36084,33971,38132,54970,59196,48499,52790,48564,50644,50612,48564,50645,48596,50644,50677,48564,50645,44306,21130,19115,12777,10729,10728,10729,10696,10728,10728,10728,12809,12809,12809,12809,12777,12809,10696,10696,10696,10663,31597,35888,27534,19082,21228,21228,21196,19115,17035,19083,29550,40016,40049,37936,29517,31630,33710,31630,31598,27437,25292,23276,12776,16969,33709,48532,48532,44306,57049,35985,25389,23308,23309,19115,17035,16970,21065,41637,45992,39981,12678,12711,16904,21095,19079,12741,16934,27400,38031,31725,12773,12837,10693,16936,21194,21128,31660,31692,40143,52757,37933,42128,54936,52790,29578,12740,29546,48530,42126,44273,57050,48598,10629,10693,12773,8548,8581,16967,10694,6469,4356,6468,8581,10693,14886,19080,16967,8548,10661,8549,4323,4291,2210,4323,4356,4356,4323,2211,2178,2243,6500,2243,4355,8548,6500,4355,4291,4291,6436,6468,4355,4323,4291,4259,4291,4291,4291,4291,2210,4259,4323,6372,4323,8549,12743,12743,12743,14823,14758,14856,10663,12743,12743,12776,12744,43},
{46616,46649,46649,46649,46649,46649,46649,46648,48697,48729,48729,48697,46648,48697,48697,48729,48729,48697,48697,48729,48729,48729,48761,48761,48729,48696,48697,48697,48729,48729,48729,50777,50777,48729,48697,48729,50777,50777,50777,50809,50809,50777,48728,48696,48696,48697,50777,48696,48696,48696,48664,48696,48696,48664,48697,48664,48696,48696,48696,48696,48664,48696,48729,44503,38197,36117,31957,31956,34004,38164,54969,59196,50579,52725,46451,48531,46451,46451,48564,46451,48531,48564,46419,48532,42194,21130,21163,10728,10728,10729,10728,10696,10696,10728,10729,14921,14889,12777,12776,12776,14889,12776,12776,10696,10663,31661,35888,31727,21162,23276,21228,21228,19115,17035,27502,42130,42161,40048,40016,40081,35823,37904,35823,31630,25356,19116,12842,10696,16937,33709,57017,54936,48532,48565,29581,27502,27502,23341,21228,19115,19083,18985,31270,46025,44239,14791,16904,19016,18983,21127,21160,21160,35851,44304,40143,27497,19110,12806,16936,19081,21128,31628,31659,44304,52724,37901,44273,54936,46515,25352,14820,33805,46385,40046,48532,57115,35887,4291,8548,14885,8612,8613,10693,10694,4388,4356,6468,8581,10661,12806,10661,2210,4291,8549,6501,4323,4291,4291,6468,4356,4323,4323,2210,2178,2211,8581,4355,6435,8613,8613,4355,2243,4356,6468,6468,6404,4291,4291,2210,4291,6372,6404,4323,4291,4291,4291,6372,4323,4323,6436,10630,12743,14888,14823,16937,10663,10663,10695,12744,12776,46},
{46649,46616,46649,46649,46649,46649,46649,46649,48697,46649,48729,48729,48697,48697,48729,48697,46648,48697,48697,48696,48697,48697,48729,48697,50777,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,48697,48729,50777,50777,50777,50777,50777,50777,48729,50777,48696,48697,48729,48697,48697,48696,48664,48696,48696,48697,48696,48696,48696,48696,48696,48696,48696,48696,42423,36149,34037,34004,34004,36052,40244,54969,59196,59195,54904,48531,50644,48531,46451,48564,46483,46451,48564,46483,48500,46419,40080,35920,14889,10729,10729,10696,10696,10696,10696,10696,14889,14889,12841,12776,10696,14889,12776,12776,10696,10664,31661,35888,42193,25323,21163,21195,21195,19115,17035,27502,27502,27534,27502,27469,29614,29582,29550,27502,29550,25357,19116,17003,21163,21130,35854,59163,54904,48564,29581,25389,27567,27502,23309,21228,19115,19083,19017,22982,41931,40047,14791,19017,27468,21064,14758,14822,21095,40045,46385,46450,40111,21159,12806,14823,21193,27433,31660,29612,44337,52757,29483,46419,57016,52757,27465,14853,40144,44272,42127,52823,57082,21129,130,10596,16934,8548,10693,10693,8581,6468,4355,6468,8613,10693,10693,6436,4323,4323,8581,6501,6436,4356,4291,6436,4356,4356,4291,2211,2211,2210,6436,6436,4323,8548,8548,6468,4355,4323,6403,6404,4291,2211,4259,2210,4259,4291,4259,4291,4291,4324,4323,4291,6404,6404,6468,8549,10630,14888,14888,16936,12776,10663,10631,10696,10663,48},
{46649,46649,46649,46649,46648,46649,46649,48697,48697,46649,48697,48697,48729,48697,48697,48697,48697,48697,48729,48729,48729,48729,48697,48697,48697,48729,48729,48696,48729,48729,48729,50777,50777,48729,48729,48697,48729,50777,48728,50777,50809,48729,48664,48696,50777,50777,50777,48729,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48697,44503,38230,34037,31956,31956,34004,40245,40244,50744,57116,52823,46451,48563,48531,46451,48531,46451,46450,48532,46450,46419,48531,46451,48532,19050,10696,12776,10696,10696,10728,10728,10696,12809,12809,12776,10728,10728,12809,12776,10728,10664,10696,33742,35887,40112,23210,21163,21228,21196,19115,19115,19148,16970,12777,12777,12777,12809,14922,19148,17035,21196,19148,23341,27502,27502,25356,37967,57082,52823,48564,33775,25389,25421,25389,21228,19115,17002,17002,18985,18887,29418,46451,18984,14791,19017,18951,14758,16903,23241,29547,38031,42225,37966,21191,16967,12743,25417,29546,31692,27434,42224,46387,25258,48565,54936,52790,16936,12677,46386,42126,44273,54969,50711,8517,2211,18983,21063,4355,12774,16967,8580,6533,6500,8613,10725,12805,19080,8516,6371,6468,8613,4355,4323,4356,4356,6436,6436,4323,2210,4291,4291,2210,4323,6436,4323,6468,6468,6468,4355,4355,4355,4356,4291,2211,2211,4259,4291,4291,4259,2242,4323,4291,2242,4291,6468,6436,8581,10661,10661,14855,16968,14888,10663,12776,12743,8550,10663,46},
{46616,46616,46649,46649,46649,48697,48729,48697,46649,46648,46649,48697,48697,48729,48729,48729,48697,48697,48729,48729,48729,48729,48729,48729,48697,48729,48697,48729,48729,48729,48729,48729,48697,48696,50777,50777,48729,48729,48729,50777,50777,48697,48697,48728,50777,50777,48728,48697,48697,48696,48696,48729,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,44503,38230,34069,34005,34004,34004,38132,36051,50744,59196,54904,48499,48564,48564,46451,48564,48531,46450,48531,48531,46418,48531,46451,46420,17002,10696,12777,10728,10728,10728,10728,12841,12776,12776,12809,10728,10728,12809,10728,10696,10696,12744,35854,31661,25324,16969,21163,23308,23341,19083,19115,23309,21196,21196,21163,19083,21163,21163,23309,23309,23309,17002,17035,23341,23276,21130,35855,48598,48565,48532,33774,23309,23308,23276,21195,21196,21195,19050,16839,20935,27371,38032,18985,16904,29385,37639,31398,23143,23176,35853,37998,42257,31692,19111,21193,16968,23273,29546,33741,29547,44370,44306,27435,50678,54936,50710,12645,19016,46418,40046,48531,57082,38001,4259,4356,10629,8549,4323,14854,23273,6468,4387,8581,10726,10693,8581,10662,8516,4291,8581,8581,6404,4323,4323,4356,4323,6436,4356,2211,4291,4291,2211,4291,4355,6435,6500,6468,6468,4355,4355,6436,6468,4355,2210,2210,4259,4291,4291,2242,4323,4323,4323,2210,2242,4323,4291,6436,10661,12742,14790,23047,16936,10662,12743,12776,10663,8582,44},
{46649,46649,46649,46649,46648,46649,48697,46648,46649,46649,46649,46649,48697,48729,48697,48729,48729,48729,48697,48697,48729,48729,48697,48697,48729,48729,48729,48729,48729,48729,48729,48697,48697,48729,48696,48697,48729,48697,48729,48729,48697,48696,48696,48696,48728,48728,48696,48664,48696,48696,48697,48696,48696,48697,48696,48696,48728,48696,48696,48696,48729,48696,48696,44503,38230,34069,31956,34004,34004,42325,38164,48598,57050,52823,48499,48563,48532,46418,48564,48532,46418,48531,48531,44370,48531,46451,42227,16970,10728,12809,10728,10696,10728,10696,12841,12809,10728,12777,10696,10696,10728,10696,10696,10728,12743,35854,29516,14857,17002,21228,23308,21228,19115,19115,33808,38001,35888,37969,38001,33808,33776,29550,29550,27502,17035,12842,12874,12777,12776,33741,54871,44370,46451,31694,23341,23341,25389,25421,27502,27534,25356,18887,18887,25323,38033,27272,25127,39752,58632,52361,33610,25257,40079,37998,42192,23273,16998,19047,16903,25353,29546,33741,31660,50644,42160,27403,52790,52823,31726,10596,31692,46353,40047,52758,57082,27467,10661,10661,8580,6436,4355,12774,16999,6436,4355,8581,10758,8581,4356,2243,4323,4324,8581,6468,6469,4356,4323,4356,4356,4356,4356,2243,4323,4324,2211,4291,6436,6468,6468,4323,6436,4355,6403,4323,6436,6468,8516,4291,2210,2211,4291,4323,4355,4323,4323,4290,4323,4355,4323,6468,10661,12742,12742,14725,14855,12710,12743,12775,12744,8550,38},
{46649,46649,46649,46649,46649,48697,48697,46649,46649,46649,48697,48697,48697,48697,48697,48729,48696,48729,48729,48697,48729,48696,48696,48729,48729,48729,48729,48729,48697,48729,48697,48697,48697,48696,48696,48729,48697,48696,48696,48696,48696,48696,48696,48696,48696,50777,48728,48696,48696,48697,48729,48697,48696,48729,48696,48696,50777,50777,48728,48696,48696,48696,48696,44503,38230,34069,34037,34004,36084,42325,38164,40211,54969,52791,46418,48531,48532,48499,46483,48531,46418,46451,48499,44338,46451,48531,35921,12777,10696,12809,10728,8648,10696,10696,12809,12809,10728,10696,10663,10696,10696,10696,10696,10696,12776,37934,29483,19017,17002,19115,21195,21196,19115,17035,23276,33775,31662,33743,35823,33775,31695,31663,27437,23244,14890,10729,12777,19050,14857,31596,52725,52757,52758,38000,25389,23308,23276,25421,27534,25453,27501,21065,18887,18952,37935,48269,46123,48203,46220,35756,31597,31597,40047,37966,40112,29579,21127,23241,16936,23272,27465,33773,29580,50677,44274,33676,52822,40112,10691,10691,40079,42159,42160,54937,52791,23273,17030,12805,10693,6500,6500,8548,10693,6468,4388,8613,10725,8581,4355,4291,4291,4356,8581,8549,8549,4356,6436,4324,4388,4388,4356,2243,4323,4324,4291,2211,4355,4355,8548,6403,6403,4323,4291,4290,6435,8581,8549,4323,2243,4291,4291,6404,4355,4322,2242,4323,4291,4291,4323,8549,10629,12742,14856,10629,10661,10629,12711,14824,14824,12711,40},
{46649,46681,46649,46649,46648,48697,46649,46649,46649,46649,46649,48729,48697,48697,48697,48729,48696,48729,48729,48697,48729,48729,48697,48729,48729,48729,48729,48697,48729,48729,48729,48697,48697,48696,48697,48696,48696,48696,48697,48697,48696,48697,48696,50777,50809,50777,48696,48696,48696,48696,48696,48696,48696,48729,48696,48696,48696,48696,48728,50777,48696,48696,48696,44503,38230,34069,34037,34004,33972,36084,38197,40211,59195,52791,46418,48531,48564,48498,46451,48531,46450,46451,48532,46450,46483,48596,38033,14824,14857,12809,12744,10696,10663,10695,12809,12776,10696,10664,10663,10664,10663,10663,10663,10664,12743,40015,31596,21130,16970,21163,21228,21196,21196,17035,16970,27437,29517,31565,29517,29550,27502,23308,17002,14889,10729,12777,23211,29517,19018,33741,52757,48532,50677,42193,23275,19082,21163,25421,27502,27502,25389,14759,16807,16904,35789,48301,46220,46221,46452,54970,57083,52791,37933,35854,40112,40080,35886,33741,16935,21192,27401,35886,35854,54871,50645,35821,54903,46483,29577,21191,46418,40046,46386,57082,42226,14821,19110,12773,8580,8644,8580,8548,14919,10726,6500,10693,12806,12806,4323,4324,4356,4356,6468,6468,8549,6469,6468,4356,4323,6436,4355,4323,4356,4323,4291,4291,4323,4291,4355,6436,4355,4323,4323,4291,4355,4355,6468,4355,4291,4355,4323,4355,4323,4290,4290,4290,2210,2242,6436,6436,6436,8517,10662,10629,10694,8516,8549,12743,12743,12711,49},
{46649,46649,46649,46649,46649,46649,46649,46649,48729,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48696,48696,48729,48697,48729,48729,48729,48729,48697,48729,48729,48729,48729,48697,48729,48729,48697,48696,48729,48729,48696,48696,50777,50777,48728,50777,50777,50777,48696,48697,48729,48696,48696,48696,48729,48729,48696,48696,48696,48728,48696,48696,48696,48696,44503,38230,34069,34037,34037,34004,34003,40245,38131,52856,52791,46451,48531,48564,48499,46451,48596,46418,42290,44371,42258,44338,44371,40177,35887,38001,33839,33807,35888,33807,33774,35887,31726,31694,33775,31694,31694,31726,31661,31661,33742,31661,42160,31596,19082,16969,19115,21195,21195,21196,19115,14922,17002,19018,23179,27437,25292,23211,23211,16938,14857,14858,23146,33645,29484,21097,46452,52758,50677,50677,33742,25356,23276,23308,25421,27502,27502,25421,19017,16904,23211,35691,50414,46253,44239,42357,55035,59163,46418,40046,35854,40080,40079,40079,33774,16935,16967,25353,35919,35854,48531,42192,35821,54935,52823,35885,25319,48498,40014,50677,54936,33806,16933,12837,8580,4420,6500,8645,8581,6500,8581,10661,8613,14919,14887,8581,4356,4356,4356,6501,6468,4356,6436,6436,4291,4291,6404,6436,6436,4356,4291,2211,4323,4355,4291,2210,4323,6404,4356,4355,6436,6436,4322,6468,4355,4323,4355,8516,4355,4323,4290,4323,4323,4291,4291,6436,4291,4259,4259,6404,8549,10694,6468,8549,10662,12743,12743,50},
{46649,46649,46649,46649,46649,48697,46649,46616,46649,48697,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48729,48697,48729,48729,48697,48729,48729,48729,48729,48728,48729,48729,48729,50777,48697,48729,48697,50809,50809,50777,50777,50777,50777,48696,48728,50777,48696,48697,50777,48696,48697,48729,48696,48696,48696,48696,50777,48728,48696,48696,48696,48729,44503,40310,36149,34037,34037,34036,36084,38164,31890,38131,50710,46418,48531,48564,46451,46451,40145,27501,23341,23340,23308,23308,23340,23276,23340,25421,23340,23340,25389,25389,25388,27501,25388,25388,27501,25420,25421,27469,25421,25421,27469,33774,44305,29515,14889,17002,19114,19083,19115,19115,17035,14890,14922,14890,14857,16938,16937,18985,21066,23114,23114,23146,27339,29484,27436,23177,52791,54872,48564,44306,31694,27469,25389,25389,23341,27502,27502,25421,25421,25389,23308,39850,50414,48367,42061,40112,31726,33806,42224,40079,35886,40080,42225,37999,33774,16935,14886,29515,35853,35690,37933,35789,35854,54903,44338,21159,31691,46385,40046,52855,54936,35918,19110,14885,10693,6500,4355,6468,8581,6500,8613,10693,10693,14919,21193,10662,4323,4356,4323,6501,8549,6436,6404,4356,2243,2178,2211,6436,6436,4356,2211,2210,4355,4323,4323,4259,4324,2243,6404,4355,6468,6436,4355,4355,4355,4356,4323,8516,4355,4355,4323,4323,4323,4291,4355,6404,4323,4291,4291,6404,10630,10694,6436,8549,6468,8549,12710,48},
{46616,46649,46649,46649,46648,46649,46648,46648,46649,48697,48697,48729,48729,48697,48729,48729,48697,48696,48696,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,48729,48696,48729,50777,48696,50777,50809,50777,48696,48696,48696,50744,50777,48696,48697,48697,48696,48696,50777,48696,48696,48696,48696,48696,48728,48696,48696,48696,48696,48696,42455,38230,36149,34037,34004,34004,34004,36084,31890,38164,52758,46450,48531,48564,44339,33807,23276,19148,19148,19148,19116,19115,19115,19115,19115,19115,17035,17035,19115,17035,17003,17035,17034,19083,19115,19115,19083,17034,19083,17002,14922,27501,44305,23242,10696,19082,19082,19115,19115,19115,19115,17002,14922,14889,12776,12776,12744,10696,10663,12744,12712,12712,10631,12776,14856,19081,46485,46419,46451,48531,33774,23276,25356,21228,23309,27502,27502,25421,25421,23308,21162,41898,48333,46254,42028,29481,16902,10661,35853,37933,33773,37967,40079,40047,31661,16934,12773,29515,40047,48400,54804,37934,25289,50710,31724,14852,37998,44304,42224,54969,42291,8516,19078,16997,10692,6468,4355,4355,4388,12774,12806,12773,14887,10726,12775,6436,4356,4291,2210,6436,8581,6468,6436,4323,2211,4291,2210,6436,4355,4291,4291,4291,6436,4323,4291,4323,4355,2211,4323,6435,6436,8516,6436,4355,4323,4323,4355,6500,6435,4355,4355,4322,4323,4323,4355,4355,4323,4323,4291,6437,12711,14726,6436,6436,8548,8516,8516,45},
{46649,46649,46649,46649,46649,48697,48697,46649,46649,48697,48697,48729,48729,46649,46648,46648,48696,48697,48697,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,50777,48728,50777,50809,50777,50777,50777,50744,48696,48696,48696,48696,48696,48696,48697,48697,48697,48696,48728,50777,50777,48696,48728,48728,48696,48728,50777,48729,50777,50777,44535,38262,36182,34069,34036,34004,33971,34003,31891,40244,50709,46451,48531,42258,25421,21195,21228,19148,19115,19148,19115,17035,19115,19115,19115,19116,17035,17035,17035,17035,17035,17035,23341,25421,25389,25356,23276,23308,23308,23308,25388,27501,31694,25356,21227,23308,23308,23308,23308,25388,23308,25389,23308,23308,23276,23276,23308,23276,21195,19147,19115,19115,19050,19050,19082,23275,40114,40113,35952,40145,31694,27469,29549,19114,21228,27502,27502,25421,25389,23308,25323,44044,46254,42127,48498,48530,25320,16934,40013,40078,33773,40080,44241,35853,25353,16999,16966,31660,35853,48563,52724,33740,25289,50677,31723,21190,44337,44239,46451,57082,33839,6403,16965,19110,12805,6500,6436,4355,6468,25322,16999,12774,10694,4323,6468,6436,6404,4324,4291,4323,8581,8581,6468,4355,2211,2211,2243,6468,6436,4355,4323,4323,6403,4291,2211,4323,4323,2178,2210,6404,6403,4291,4291,6468,6468,6436,4355,6468,6467,4355,2242,2242,4323,4355,4355,6436,4323,4291,4258,10598,14791,10468,6372,6404,8516,6468,6403,40},
{46649,46649,46616,46649,48697,46649,48697,48697,46649,46649,48697,48729,48697,48729,48697,48697,48696,48729,48729,48697,48729,48729,48729,48729,48729,48697,48697,48729,48729,48729,48729,50777,50777,50809,50777,50809,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,42358,33873,27534,29647,29647,29647,29647,29680,31728,29680,29680,29680,27567,27567,25487,25487,25487,25487,25487,25454,35920,52790,44370,33839,21227,19115,19115,19115,17035,17034,17035,17034,17035,17067,17035,17035,17003,17003,17035,14954,17003,14954,17002,29615,27469,21162,23243,14856,19082,19082,19082,21195,21162,21195,14856,21227,17001,19050,17001,17001,21195,14856,23308,14856,23308,21130,21195,25388,23243,25356,14856,23308,21195,29582,25355,29581,29581,29581,27501,25355,25388,31694,27500,44339,27501,19148,25454,25453,25421,23308,23276,27436,37804,29385,25224,27402,33708,23208,19047,42126,42191,33741,42160,42224,29579,19047,14886,12773,31660,33773,48531,48498,29547,25354,46483,25384,25384,46450,42127,50710,54936,25418,19077,12836,10724,10757,6500,6500,6468,8580,25353,19047,8581,4355,2243,6436,6468,6404,6404,6404,6436,6436,6468,6468,6436,4291,2210,2243,6468,6468,6468,4355,4323,4355,2210,4291,4323,4291,2210,4291,6436,6436,2242,4323,4323,4291,4323,4355,8549,10661,6467,4322,4322,4355,4322,4355,6436,4323,4291,2210,6371,4291,4291,6403,8549,8549,8484,6403,37},
{46649,46649,46649,46649,48697,46649,46649,48697,48697,48697,48697,48697,48697,48729,48729,48697,48697,48729,48729,48697,48729,48697,48729,48729,48697,48697,48729,48729,48729,48729,48729,48697,50777,52889,50777,52857,50777,50809,46551,40244,40212,38131,38099,36051,36051,36019,36019,38099,38099,38099,38132,33906,23341,23341,21196,21228,21228,21228,23277,25390,23341,23373,23342,23374,23342,23341,21261,21228,21229,21229,21196,21196,33775,46484,27501,19115,19148,17067,17035,17067,17035,17002,17035,17035,17035,17035,17002,17002,17002,17002,17002,17035,17002,14922,16970,31728,27469,23243,25356,21162,23275,23275,23243,23308,21195,23275,19114,23308,21195,21228,21195,21195,23308,23275,27501,21195,27469,25389,25356,27469,23275,27501,21195,25421,23340,27501,27501,27501,29549,29516,27469,25356,25388,29581,25388,42194,27469,19115,25454,27502,25421,23341,23308,21195,16872,18951,20999,20999,18951,14822,16902,42158,37998,33773,40112,44305,33805,23241,16999,16998,33740,33806,35854,44273,27403,23274,33836,21190,31691,40079,40046,52758,35950,21158,21189,16997,14949,12837,10692,8580,8580,10692,27466,16967,4355,4323,4323,6436,6468,4323,4324,4291,4356,6468,4355,6436,4323,4323,4323,4291,8548,6468,6468,6468,6436,6436,2210,2211,4323,2211,2178,2210,6436,6436,2242,2210,2210,2211,4291,4323,10662,10629,6403,8549,6435,6436,4356,6436,6469,6404,4291,4291,6371,6436,8549,6436,8549,6468,4323,6371,32},
{46649,46681,46649,46616,46648,46648,48697,46649,46649,48697,48697,48697,48697,48697,48729,48729,48729,48696,48729,48729,48697,48697,48729,48729,48697,48697,48729,48729,48729,48729,48696,48729,50809,52857,52857,52857,52889,40147,19115,21196,19116,21228,27632,27632,27632,27600,27600,27632,27632,27632,27600,27600,27632,29680,25454,25454,25454,25422,23342,23342,25422,23374,23374,23341,23341,23341,19180,21229,21229,21228,19148,19148,23308,23308,19148,21196,21196,19148,21196,21196,19115,19115,19083,17035,23276,25421,25420,25388,21195,21195,19083,17002,31727,42292,40179,44340,27468,21162,25323,19049,21163,23243,19049,23275,16969,21195,12776,21227,19050,19082,19082,16937,21195,14856,23340,16936,25388,21195,19050,25356,19050,25420,14856,23340,17001,25388,25388,25388,29549,27403,27468,19049,25388,23308,21130,44339,23243,19148,25422,27502,25453,23341,21228,19148,14889,12742,14757,18950,21095,16934,19047,40078,37998,35854,40079,44305,35886,27468,16999,19078,33740,33774,38033,42160,23209,25355,38063,23238,27433,25289,42192,54936,44370,21190,19077,14916,14917,14917,12804,8580,10660,14918,12805,4355,4355,4323,2243,8517,8549,4323,2243,2211,2211,6436,6468,8548,4323,2211,4323,2243,2243,6468,6500,6468,4355,4355,4291,2242,4355,2210,2210,2211,4324,4355,4323,2211,4291,4291,4291,4323,6436,4291,6404,12743,6469,12775,10695,8582,8550,8550,6469,6468,8516,6371,8484,6436,6468,4323,4291,4258,23},
{46649,46649,46649,48697,46649,46649,46648,46649,48697,48729,48729,46649,48697,48697,48697,46648,48729,48729,48697,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50809,52825,52857,52857,52889,44372,31663,27502,23309,25422,31793,31825,29745,29745,29745,29745,29745,29745,29712,27567,29680,29680,25454,23374,25454,25422,23342,25422,25422,23374,23341,23342,23342,23341,21229,21261,21261,21196,21228,21196,21196,19116,19116,21196,21196,21196,21196,21196,21196,19115,19115,21196,23276,29517,33710,31662,23276,25389,21228,17002,23276,31695,29582,40179,27501,25388,25356,21163,23275,25388,23307,25388,23275,25388,21195,25388,23275,23308,25388,23275,25388,21195,27501,23308,27501,25420,23308,27501,25389,27501,23307,25453,25356,27501,27501,29581,29581,27468,27501,23243,27469,25388,25356,35953,23276,19148,25421,27502,25453,23341,23308,19115,14921,8582,4356,8549,14887,14854,21128,40046,37966,35854,37999,44273,35886,31630,19112,19078,33708,35887,44339,42128,31660,27468,42256,21158,23208,29483,46451,57050,35885,16996,21222,19110,12804,8579,8612,8580,21128,21159,8579,4323,4356,4323,4323,4356,6436,4323,4323,4291,4323,6436,12773,10693,8548,4323,4323,4323,2243,4355,6500,6436,4355,4291,4323,6436,4355,2210,2211,2211,2210,4323,4323,4291,4323,4323,4291,6436,4356,4291,6436,8550,8518,14889,10662,10630,8582,8550,8549,8516,6436,6403,6371,4323,4323,4290,4258,4258,21},
{46681,46649,46649,48729,48729,46649,48729,48697,46649,48697,48697,48697,48697,48697,48697,48697,46648,48729,48729,48729,48729,48697,48729,48729,48729,48729,50809,48729,50809,48696,48729,48696,50777,52857,50777,52856,52857,46485,42161,42226,31727,23341,23373,23373,23341,23374,23341,23374,23374,27535,29680,23341,23374,23374,25455,25455,25454,25454,25454,25454,25422,25422,25422,23374,23342,23342,23309,23309,23309,21229,21196,21228,21196,21228,21196,21196,21196,21196,21196,21196,21196,19115,19115,19115,23276,29549,33742,31629,25356,25356,23276,19115,19050,21163,19050,38066,27533,23308,23276,16937,21163,25356,21162,25388,19050,23275,14889,21195,19049,19082,23275,19049,23308,14888,25388,14888,21227,19082,16969,25388,21130,27469,19049,23308,21130,25356,23243,27468,27468,19082,23308,21162,25388,29646,27469,23276,17002,17067,23341,27534,25421,25389,23308,19115,21228,12776,8583,10695,14887,6468,19048,37966,35886,35854,37967,42160,33774,35855,21192,23271,33772,40048,54871,54806,35820,23272,21191,19078,31628,33708,50677,57050,29580,19109,21222,19110,12772,6499,6435,6467,16934,19078,8612,6436,4355,4355,4356,4323,6468,6436,6404,4323,4291,4323,12806,12806,12774,8581,4387,4355,4323,4355,8548,4355,4323,4323,4356,4323,4323,4291,4291,2210,4291,4291,4323,4323,4323,4291,4291,6436,4323,4356,8517,6469,8550,14856,12743,8550,8517,8517,10662,8549,4323,6371,4291,4291,4290,4258,4258,4258,23},
{46649,48697,46649,46649,46616,46649,46649,48729,46649,46648,46648,48729,48697,46649,48697,48729,48697,48729,48729,48729,48729,48697,48729,50777,50777,48697,48696,48729,48696,48729,48729,48729,48697,48729,50777,50809,52857,46550,35920,29614,14922,17035,19083,19083,17035,17003,17003,17035,17003,19083,35920,35921,33840,33840,31663,31663,29614,29582,29614,31662,29582,29582,29614,29582,27502,27502,29582,27469,27437,27437,25356,25357,25356,23276,25324,25324,25324,25356,25356,25356,25356,23243,23276,23243,27436,29549,33710,31629,25355,27436,27436,23242,23243,25323,27403,40178,27500,23275,25356,19082,21195,25356,23243,27501,23275,23276,19082,23276,19082,21195,25389,23275,25421,21195,25421,21227,25388,23308,21227,27469,25356,27533,23308,25421,25388,27501,27501,29549,29582,27468,27501,27469,29581,29581,27501,21195,17035,19115,23341,27534,25421,25389,23276,21228,27534,23276,12808,14888,16967,14887,21129,35885,35886,33774,35854,42160,35822,27435,14886,19047,35821,40080,54870,48466,35787,23239,19110,23271,42159,40014,52823,54904,23240,19109,21190,17029,14917,14917,12772,10692,19111,19110,10692,6499,4387,6468,6468,4355,6436,6468,4356,4324,4323,2243,10660,10725,8580,6468,6468,6403,6436,6468,8548,4355,4355,6404,6404,6436,4323,4323,4291,2210,4291,4291,2210,4291,4323,4291,4323,8516,4323,4355,8517,8550,8582,14856,17001,4291,6372,6404,8516,6436,4323,4291,4291,4291,4291,4291,2210,4258,24},
{46649,46649,46649,46649,46649,46649,46649,46649,48729,48697,46649,48729,48697,48697,48729,48697,48729,46648,46648,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,48697,48729,48697,48729,50777,50777,46550,35953,19115,12874,17035,17003,17003,17003,17003,14923,14923,14922,14890,37968,50645,48564,50613,44306,42226,42226,42226,42194,42194,40146,40146,42194,40113,40081,40081,40049,42161,37968,37903,37968,37968,37968,37967,35855,35822,35822,37935,35854,35790,35790,33741,33741,35789,35790,35790,35790,35789,33741,33741,35789,33709,35789,33708,35789,42258,29613,27469,25388,21162,21195,27501,23243,31694,27436,25356,19050,23275,21195,21163,23275,17001,25388,16969,25388,16969,21194,19082,16937,23308,16937,25389,16969,23275,21194,25356,29581,29548,29581,27436,29549,27436,29581,27501,25388,25356,19115,19116,23341,27534,25453,25389,23308,21228,25421,21228,14922,14888,16967,12774,21161,37966,35853,33773,37967,42192,35854,27435,12773,16902,35821,40112,52789,46384,33740,23239,14884,29578,48464,44272,54937,50677,23238,19077,21190,16965,14884,14884,16965,14885,21223,14917,8645,8612,8580,8613,8580,6500,4388,6501,4356,6436,6404,8548,12773,8612,6467,4355,6403,6404,6436,8581,6468,4355,4323,4356,4323,4323,4323,4291,4291,4291,4291,4291,2210,4291,4355,6436,8580,8516,4323,6436,12743,10630,10630,12711,12743,10598,10598,10597,6468,6403,6371,4323,4291,4290,4291,4291,4258,4258,19},
{46649,46649,46649,46649,48697,46649,46648,48697,48697,48729,48729,48729,48697,48697,48729,48729,48729,48696,48729,48729,48729,48729,48729,48729,48697,48729,48729,50809,48729,48729,48729,48729,48696,48696,48697,50777,50809,44470,25422,10762,14923,17035,17035,19083,19116,17035,17035,17035,17035,16970,37968,50677,48564,48531,44306,42259,42226,42226,42194,40145,42226,40178,40113,40113,40113,40081,40081,40145,38000,37968,40049,38000,37968,40048,37935,35854,37935,35854,37902,35822,35822,35821,35789,35789,33741,35757,35789,35789,33709,33709,33709,35789,37870,35789,33773,40145,25388,19082,23275,19082,23275,21195,21162,23275,21162,25388,19114,25388,23276,23308,25388,21195,27501,21195,27501,21227,25388,25388,21227,25453,21162,27501,23275,25420,27501,27469,31694,31661,29581,29516,29581,27501,29581,29581,27468,25421,21228,19148,25389,27502,27502,25389,25389,23276,23308,19082,14954,10695,14886,10694,16968,33772,35886,35854,37967,40080,35822,29515,14918,21127,35853,42192,52756,46320,31659,19110,14852,33739,46384,46385,57050,44370,19077,21189,23302,19109,14917,14884,14852,21158,23303,12772,6500,8613,6500,8612,6500,8580,6467,6500,8549,10661,12773,16999,14886,8580,4387,6436,4355,6403,6435,8580,6435,4323,4323,4323,4291,2243,4291,4291,4291,4291,6371,6404,4291,4291,6403,10661,12741,6468,4291,12742,21129,10598,8485,10630,10662,12711,10598,8485,8549,8517,6404,4323,4291,4291,4291,4258,4258,4258,19},
{46649,46649,46649,46649,46649,46648,48697,48697,48729,48729,48729,48697,48729,48729,48729,48729,48729,48697,48729,48696,48729,48729,48729,48729,48729,48729,48728,48729,48729,48729,48729,48729,48729,48729,48729,50777,50809,40245,12874,10762,16970,21196,23244,23244,21196,21163,21164,21164,21164,21163,40016,50644,48532,48532,42226,40178,40146,42226,42226,42194,40146,42226,40113,40081,40081,38000,38000,40113,37968,35855,38000,38000,35855,37935,35854,35822,35854,35854,33709,33709,33709,35789,35789,35789,33676,33709,33709,33709,33709,33709,35789,35822,35789,46419,46484,42291,25388,16969,23276,19017,21195,19050,17002,21195,16969,23308,14889,21227,19049,21195,25388,19114,25421,14888,25420,19082,23308,23275,19049,23308,14824,25388,21130,25356,29614,27469,31662,31629,31662,23210,25323,27436,29581,29614,27468,23275,10663,14954,23341,27534,27502,27501,23308,23276,23308,21195,17002,12808,10694,8581,14888,29580,35886,35854,37967,40080,33773,29515,16966,25353,35821,44306,50643,44271,27432,16997,19077,40045,44206,48564,57050,31692,16965,19109,21221,21189,19109,19077,14852,23303,25415,16998,8580,6500,6500,8613,8580,8612,8580,8580,8580,16967,16999,19079,14886,12773,8612,6500,4419,4387,8580,10660,6468,4356,4323,2211,4291,2211,2178,2210,8484,12709,10661,6404,2210,2211,2211,8516,10660,6468,4291,19017,23210,16903,14823,12711,10630,10630,8517,8517,8517,8485,6436,6403,4291,2210,4291,2210,2178,4290,16},
{46649,46617,46616,46649,48697,46649,46649,46649,46649,48697,48697,48697,48697,48697,48729,48696,48697,48696,48729,48729,48729,48729,50777,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,52889,38099,16970,27502,35855,42193,42226,42259,42259,42227,42227,40146,40146,40146,46419,50612,50579,50612,44274,42226,42194,40146,42226,42194,42226,42226,38033,38033,40113,40081,38000,40113,37968,35887,37968,37968,35887,37968,37935,35790,37902,35822,35822,35822,35789,35789,35789,35789,35789,35789,35789,35822,35789,35854,35854,35854,35821,44370,46484,44371,27469,21130,23275,19082,23275,25389,21163,25421,21227,25388,21195,23275,19114,21195,25388,21194,25420,19082,25420,23275,25388,25420,23308,25421,19082,25388,23275,27469,27469,25356,29581,29581,29614,27501,27469,27468,27533,29614,27501,23308,12776,14954,23341,27534,27502,25454,25389,23308,23340,21228,17035,10727,12774,10694,10662,29548,37934,35886,35886,37967,33773,27434,16965,27433,35853,44338,50611,44238,29577,23303,25383,40078,37901,52791,52791,23240,16964,16965,21189,19109,19077,16997,19046,25415,27463,23271,12773,8612,8580,6468,6467,8580,6499,6500,8613,16967,14886,19079,14886,10693,10725,6500,4387,8580,14886,12773,8613,4388,4291,4291,2211,2210,2211,2210,6435,6403,4291,2210,2178,2210,2178,6435,10661,6404,6372,14856,25257,25257,19016,10630,12743,12775,4323,4291,4291,8549,6404,4323,4291,4291,4291,4291,2210,4291,16},
{48697,46648,46616,46649,46649,46649,46649,48697,46649,46649,48729,48697,48697,48697,48729,48696,48696,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,48696,48729,48729,48729,48729,48728,50777,52857,42260,40114,42258,42225,46419,44371,44372,44404,44404,44404,42324,44404,44404,46484,48531,48466,48531,44274,42226,40146,40178,42226,42226,42226,42226,40113,40113,40146,40113,40146,40113,37968,37968,38000,37968,37935,38000,37935,35822,37903,35822,35822,35822,35822,35822,35822,35821,35822,35821,35789,35789,33741,35789,33741,33741,33741,42225,46484,40178,27501,23276,25356,21195,23308,25420,21195,25421,23308,25421,21195,23275,19115,19082,23308,21162,25388,16969,25388,21162,23276,25356,21162,25421,16969,23308,19082,25355,25388,23243,29581,27468,29549,27468,27501,25355,29581,31694,27533,23276,10631,14954,23373,27534,14889,12808,12776,12776,14921,12776,10696,4357,10662,12807,14887,33741,35854,37966,33773,35886,33773,27467,21159,29513,35821,44338,50611,44239,33739,19109,25352,31465,31596,54936,50678,23304,16997,19110,19109,21222,19109,12740,16934,25415,27496,23273,6403,6467,8581,4355,4355,6500,8580,10693,10693,14918,12806,19111,12805,6499,6500,4387,4355,8580,14853,12805,10693,6435,2243,2243,2210,2211,2211,4291,6436,4291,2210,2211,2211,2210,2210,6403,10693,6403,8549,16936,27371,23145,12710,6372,14823,14856,4324,2211,4323,6436,4323,4291,4291,4291,4290,4258,2210,4291,17},
{46649,46649,48697,46649,46649,46649,48729,48729,48729,48729,48729,48697,48729,48729,48729,48697,48697,48729,48729,48729,48697,48729,48696,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,50809,52857,46485,35952,40146,42193,46419,44404,42323,42324,42323,42356,42324,42324,42324,44371,48531,46353,46385,42193,42226,40113,40113,40145,42193,42193,42193,40080,40081,40080,40080,42226,40081,37935,37967,38000,37936,35855,37968,37935,35822,35822,35822,35790,35821,33709,33741,35789,33741,33741,33709,33709,33709,33676,31596,31628,33676,33708,38032,42291,40146,27469,21163,23275,19082,21130,27468,21130,23308,19082,23308,16969,21195,19082,19082,25356,19082,25421,17001,25356,23243,23307,27469,27501,27501,19082,25388,21195,27501,29581,31759,27468,27435,29581,29549,25388,27468,29549,29614,27501,23308,8550,14922,23341,27534,8615,6503,4422,8615,8583,6469,6502,6470,6469,8550,16936,33773,35822,40080,33773,35854,33741,23241,23207,31626,35821,44338,50578,42126,29513,21158,27465,46257,29419,52757,48564,23271,23270,21222,16997,21157,19110,8548,4323,12805,14886,10629,130,4355,8548,4355,4355,6468,6500,10661,8580,10725,10725,17031,12805,8612,4387,6435,4355,8580,14853,12837,10693,6436,4323,2243,2211,2210,2210,4291,6468,4291,2211,2210,4291,2211,2210,4323,10661,8516,8581,19017,21065,8484,4291,4259,12711,14856,6372,2178,2178,6404,4323,4291,4258,4291,4291,4291,4258,4258,17},
{48729,48697,48729,46649,46649,46649,48729,48697,48729,48697,48697,48729,48729,48697,46648,48696,48729,48729,48729,48729,48697,48696,48697,48729,48729,48729,48729,48729,48696,48729,48729,48729,48729,48729,48697,50777,52857,42226,33807,40179,40080,44338,44404,42324,42324,42324,42356,42324,42323,42323,44371,48466,46320,46320,42160,40081,33677,33741,33709,33709,33709,33677,33709,33709,33677,35789,33709,33709,33709,33709,33741,33709,33709,33709,33709,33709,33677,33709,33709,33709,33676,33708,33709,33709,33709,33709,33709,33676,33676,33676,33676,33676,33676,38032,40178,38065,29582,25388,25388,23276,23275,29614,25356,27469,23308,23308,21163,25389,21195,21163,23276,19082,25421,16969,23308,23275,25356,29581,29581,27501,19050,25388,19049,25388,31727,33872,25355,25355,29581,27501,25388,23275,27436,27501,23275,23276,10630,14922,23373,27534,10696,6535,6470,10728,6470,6470,8583,8550,4324,6437,19081,35886,33741,40112,33741,35886,31661,25322,23208,31659,35885,46450,46384,42126,29546,21190,33804,50645,37902,52691,35885,23238,21222,21222,21222,21189,12772,4291,2211,4356,4323,2243,4356,4323,6468,6436,4323,6468,8580,8580,8548,10693,10725,14918,12806,10693,6499,6467,6499,12773,14918,14918,8548,6468,8581,4323,2211,2178,4291,6436,4291,4291,2211,2178,2211,4259,4291,6435,8580,6436,10630,19017,12710,10598,10565,8517,10630,10598,6404,6404,6404,6404,6404,4291,4258,4291,4291,4258,4258,2178,19},
{46649,46648,48697,46649,46649,46649,48729,48729,48697,46648,48729,48729,48729,48697,46648,48697,48729,48729,48729,48729,48729,48729,50777,48729,48729,48729,48729,48729,48729,48729,48729,48729,48697,48697,48729,48728,50809,42227,31727,40179,40113,44306,44404,42324,42323,42324,42324,42324,42356,44404,44371,48433,46320,48401,42160,40048,35757,35757,35789,35790,35790,35790,35790,35822,35822,35790,35822,35822,35789,33741,35789,35789,35789,35789,35790,35790,35789,33709,35789,35789,35789,33709,35757,35757,33709,35757,35757,33709,33676,33708,33708,33708,33676,38033,42259,40179,27469,14856,19082,14856,21130,19050,16969,21195,14856,21195,14856,21163,21162,19114,23308,17001,25421,17001,25388,25388,25355,27501,27468,27501,19114,23340,21195,23308,23308,23243,27501,29549,29581,29581,27501,29581,29581,27469,25388,23308,17002,17035,23341,27566,14889,10696,8615,10695,8583,8583,8647,8550,2244,6437,21162,37935,35854,40080,33773,35886,31661,23209,21128,35820,35854,44337,46385,42126,27498,21189,44303,42193,40014,52757,29515,21158,21190,23302,23302,16997,6467,4323,4324,4356,4323,6436,6469,4323,4323,6436,4355,4355,6467,12773,10693,12773,12805,17031,12805,12773,12805,10725,12773,14885,14885,16998,12741,6468,6436,2243,2211,2211,6404,4323,4291,2210,2211,2211,2178,2210,6403,10660,8580,8516,21194,23243,27469,14824,10565,8517,10630,10630,10598,8485,8485,8517,6404,4323,4258,4291,4290,4258,2210,4290,23},
{46616,46648,46649,46649,48697,48697,46649,48729,48729,48697,48697,48697,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48696,48729,48729,48696,48697,48697,48729,48729,50777,46550,29581,35921,40080,44339,44404,42356,42356,44404,42356,42324,42324,42324,44372,48498,46352,46352,46386,46386,44241,44241,35822,31629,33677,31629,31629,33709,33677,33709,33709,33709,33677,33677,33677,33709,33709,33677,33677,33677,33677,31629,31628,31628,31628,31628,31629,33677,31596,33677,33677,33677,31629,33677,31628,31596,31629,38033,38065,38098,27501,17002,21228,19082,21195,21162,19082,23276,19050,23308,16969,23243,23275,21195,25421,21162,27501,21162,25389,27501,27468,27501,25388,29581,21162,25420,21162,23275,23308,21195,29581,29549,29549,29581,27501,27501,29549,27501,25388,23276,8583,19115,25453,27566,14954,10728,17001,19082,10695,8615,12808,8582,8517,8550,21130,37935,35854,37999,35822,37966,35854,27403,23209,40046,31660,42160,46384,31626,19078,23270,48464,48400,48464,52757,23208,19110,16965,19109,21189,14852,6436,2275,2275,4355,8549,4356,4356,2210,2210,6468,6403,4323,8548,14886,12773,14918,14886,19111,12773,12805,12805,12805,12837,14885,14885,16998,19111,12805,6435,4356,2211,4323,8549,4291,4291,2178,4291,4291,2178,4291,10629,10628,8548,14888,23274,25355,27436,14791,12710,12710,10630,10630,10630,10630,10630,8517,6437,6404,6371,4323,4291,4323,4355,6435,29},
{48697,46648,46649,48697,46649,46649,46649,48697,48697,48697,48697,48697,48697,48697,48729,48729,48729,48729,48729,48729,50777,48696,48696,48729,48729,48729,48729,48696,48729,50809,48729,48729,48697,48696,48696,48729,50777,46518,42161,35823,37935,42193,42258,42259,42291,42291,42291,42291,42291,40211,42259,48498,46321,46320,48466,50644,50612,50645,37903,31564,31596,31629,31629,31597,31597,31596,31564,31597,31564,31596,31564,31564,31596,31564,29516,31564,29516,29484,29484,27435,27435,29483,29516,29483,27403,29451,29484,27435,27403,29451,29483,27403,31596,38065,35920,35985,29582,23308,23275,25388,23275,27501,23307,25388,21162,23276,19082,23275,25356,19050,25388,16969,25421,21130,25356,25356,27468,27469,23275,25421,14889,23308,25388,27533,29614,21163,27533,29581,29581,29614,29614,29614,27501,27501,29549,23308,10728,14922,23341,29647,14921,6502,19114,19114,8615,14889,14920,14855,10662,8550,19048,42160,40079,37966,35822,35886,35886,25289,23241,40078,33675,37902,46384,35853,23240,23239,48497,46351,50578,48532,18982,21158,12772,19045,25319,25351,16933,10629,2243,4323,6469,4323,4356,2211,2243,8548,8548,4355,10661,12838,12773,14918,12805,16998,12805,12805,12805,12837,14885,12805,14885,16998,21190,19111,8548,6500,2243,4355,8548,4291,2210,2210,4291,4291,4291,4291,8516,10661,6468,8549,19017,12743,21162,16936,10597,10597,12710,12711,10598,8485,8517,10598,6437,6404,4323,4291,4323,4291,6435,6435,23},
{48729,48697,48697,48697,46649,48697,48697,48697,48697,48729,48697,48729,48697,48697,48729,48729,48729,48729,48729,48729,50777,48729,48697,48697,48729,48729,48729,48729,48729,48696,48696,48729,48697,48729,48729,48729,48697,50776,48630,46452,46419,48532,46419,46419,46451,46419,46419,46419,46419,44338,44371,48498,44240,46320,48498,50612,50612,50612,37935,33676,35757,35789,35790,35790,35789,35790,35790,35790,35789,35789,35789,35789,35757,35789,35789,35789,33741,35789,35790,35789,35789,33709,33709,33709,33709,33709,33677,33677,33709,33709,33709,33708,35789,44307,27501,21195,23275,23307,23308,23307,25388,25388,25388,25388,25388,25356,23307,25421,27469,23275,27469,21195,27533,23275,25421,25388,25388,27501,25355,27501,19082,23340,29582,31727,27501,21194,29581,27501,29549,31694,31694,29581,29581,27533,27501,25388,10728,14890,23309,31727,23308,10663,6502,6502,6502,14889,12807,10661,10662,4356,12742,40079,42128,37934,37966,35854,37999,29548,23176,42126,35853,27402,27434,31660,21159,29545,50578,46319,52723,40113,14853,25415,23303,25351,31593,33737,29576,14853,6436,4323,6469,4323,4356,4323,2243,6436,8581,4355,6468,10661,12773,14886,14918,14918,14885,14885,14918,14885,14918,14853,14885,16998,21158,14886,6468,6468,4323,4291,6468,4323,4323,4323,4291,4323,4291,2211,4290,8548,6468,10597,23210,12710,25388,21129,16871,12743,12711,12711,12711,6404,6404,6436,6436,4323,4291,4291,2210,2210,4258,4290,30},
{48729,48729,48729,48697,48729,48697,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,48729,48697,48696,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48697,48696,48729,48728,50809,50809,50744,50744,50744,50744,50776,50776,50776,50776,52856,50776,52792,48499,46320,46320,44272,50580,50611,50611,40015,35789,37869,35822,35822,35822,35822,35790,35790,35822,35822,35822,37869,35789,35789,35821,35789,33709,33741,33709,33709,35789,33741,33709,33709,33709,35757,33709,33676,33676,33676,33676,31596,33644,37869,54871,23243,10663,17002,10728,16969,21195,19081,23242,21162,21162,14889,17001,12743,17001,23275,17001,25421,14888,25421,16937,21195,21195,19050,25388,21162,27469,14921,23308,21194,25388,29614,25388,31694,33840,29614,27468,23307,27468,31662,27469,27436,25388,14922,17035,23308,31695,23275,14856,10696,10728,10663,12807,17032,14887,12775,4356,10630,40079,42160,35854,40079,37934,40047,29547,27434,40078,40078,35853,33740,23272,19110,35852,50578,48399,54836,29581,6435,21190,23271,25351,35818,31689,31688,27496,12773,2275,6469,4388,4356,4291,2211,4323,6468,4291,4323,4355,10693,12805,14918,14918,16998,16998,14918,14917,14917,14885,14885,16966,19046,10660,6500,4355,4323,6436,4323,2211,4323,4291,2211,2243,2211,2211,2211,2210,6436,10629,23210,12710,19017,29516,21097,12710,8549,14856,14824,4291,4291,4323,6436,4323,4323,4291,4258,4259,2210,4258,21},
{48729,48697,48729,48729,48697,48697,46649,48697,48697,48697,48697,48697,48697,48697,48697,48697,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48729,50809,48729,48729,48729,48729,48729,48697,48697,48697,48729,48728,50777,50777,48697,48729,48696,48696,48729,50777,50777,50777,50745,50777,50744,48531,46320,44175,42095,46385,48465,48466,37902,33708,33709,35789,33677,19050,23243,23275,19050,25355,19082,23242,40014,40046,33741,27403,27402,25355,23210,19017,14889,16937,16937,16937,16937,16937,16969,16969,19017,29548,33709,31629,31628,31629,33709,44371,23275,8550,17002,10663,19082,16936,14888,16969,14856,21162,10695,17002,10663,17001,25388,23275,27501,21227,27533,21195,25388,25389,23308,25421,23275,27534,19114,25420,23307,25420,29614,27501,31727,33840,29614,23307,21162,27501,29581,27501,27468,27501,10696,12809,25422,31694,25388,16936,12775,12776,12776,12776,12807,12807,8549,2276,10598,37999,40047,35853,37966,35854,42160,27435,19015,37965,46418,48498,42126,33804,14852,37997,48465,46351,54837,21129,4355,14886,16998,27432,37931,33802,33801,25351,16934,19048,14822,6468,4323,4291,2243,6469,6436,2243,4291,6436,10725,12838,14918,16998,19079,19079,16998,16998,14917,14917,14885,16933,21158,16966,8580,4356,4323,8549,4323,2243,4323,4323,4291,4291,2243,2210,2178,4259,6404,6436,8550,8550,16936,29484,12677,6404,6405,16937,14824,4324,4291,2211,10630,4291,4259,4259,2178,4291,2210,4291,17},
{50777,48729,48729,48729,48697,48729,46649,48697,48729,48729,48697,48729,48697,48696,48729,48729,48697,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,48729,48729,48729,48729,50777,50777,50777,50809,50777,48696,48729,48729,48729,48696,50777,50777,50777,48696,50777,50744,48499,46288,42095,42095,46352,48433,46353,37901,33708,35757,35789,31629,16970,21195,23275,14921,23275,16969,23274,40046,40110,31627,23209,25322,25322,21129,21162,12744,10664,10664,8615,8616,8615,8583,8583,8583,27468,33774,31693,31661,29613,31694,40178,25356,12808,19082,8550,16969,10663,12776,14856,10663,19082,8517,17002,10630,17001,21130,14888,25421,14824,25388,16969,21195,21195,19049,25453,14888,25389,12808,23275,27501,29614,27468,23242,27501,21195,23275,25388,19082,27501,27469,29581,27468,25421,10696,10664,23309,31695,29549,21129,19017,19049,21194,14856,14887,12775,4356,6437,12743,37967,40079,33741,35854,37934,40079,21160,12709,37965,48531,48497,44206,48563,21158,46384,46384,48464,52757,12678,4323,6436,10660,25384,37963,40076,35882,40077,35853,25321,29580,8516,4356,4323,2243,8549,6500,4323,4323,6468,12773,12773,14886,16966,16998,17030,16998,16998,17030,16998,16965,16965,23239,27432,16966,6468,4356,8581,6436,4323,4323,4323,4323,4323,4291,2211,2210,4291,4324,6404,19115,12743,19049,23177,8484,4291,4291,14824,12743,4324,4323,2211,10630,4324,2178,4259,4259,6404,6403,6403,26},
{50777,48729,48729,48729,48729,48729,48697,48729,48697,48729,46649,48729,48729,48729,48729,48729,48697,48729,48729,48729,48697,48697,48697,48729,48729,48729,48729,48696,48729,48729,48697,48729,48696,50777,48697,50777,50809,50777,50777,48728,48729,48697,48696,50777,48728,48696,48696,50777,48728,48729,50744,46419,44305,42128,42127,46353,48433,48433,48466,48499,50580,46386,31597,14922,21195,23307,14922,25420,17034,23275,42191,42223,33708,25322,25290,25322,23242,23209,23242,19017,14856,14888,12776,14856,14856,14856,12743,31629,33742,31694,31661,31694,33774,42291,25388,14856,21162,14888,21162,16969,17001,19082,14889,21162,14856,19082,14856,19082,25388,21227,29582,21227,27533,23275,25421,25421,23308,29614,21195,27533,21227,25421,27501,29582,27501,25356,29582,23275,25420,29614,23275,27501,27469,29614,27468,25420,12809,12809,21261,31695,29581,23209,19016,19049,23274,16936,16936,12775,6437,4357,10598,37999,40047,33741,37999,37966,40079,19079,14821,40013,46386,46352,44239,50644,27464,48497,46319,50577,48532,8452,4323,2243,10661,27464,37964,42190,37964,44271,27434,14790,25322,10662,4323,6468,4323,6436,6500,6468,8548,6468,6468,4355,12805,14886,16965,17030,14950,14917,19110,17030,16998,19078,25319,27431,21159,6467,4355,8581,6436,4388,4355,4355,4291,2243,4291,4291,4258,4323,4324,8517,21227,10630,19016,16904,21129,18984,14823,14856,8549,8517,6437,6436,6437,8517,8485,6404,4355,4323,4323,6435,26},
{48729,48729,48697,48696,48697,48729,48729,48729,46648,48697,48697,48729,48697,48729,48729,48696,48696,48729,48729,48729,48729,48697,48729,48729,48729,48729,48729,48696,48729,48729,50777,48697,48696,48729,48729,50809,50809,50777,50809,50809,50809,48696,48728,48728,48696,50777,48728,50777,48728,50777,50777,50744,50776,50744,46386,46288,48401,46353,50546,50612,50644,48499,35823,16970,21195,23307,14921,23275,19082,25323,44271,44303,33740,25290,23242,25322,23210,23209,23242,23242,23210,23210,21162,21129,21162,23242,21129,29548,21162,21162,19114,21195,23243,42259,23308,8550,19082,14889,19082,16969,14889,19082,12808,19082,10695,17001,12743,16969,21195,14856,25421,12775,25388,16969,21194,21195,16969,25420,14824,25388,14888,21162,21195,21130,25420,23242,27501,16969,23275,29614,21194,29581,27501,29614,27500,27501,14922,17002,23309,29646,27468,23242,21130,21162,21195,16936,16936,10661,6437,4324,8517,35854,37966,33741,37967,37999,37998,21159,19015,37933,44305,46319,46320,50676,33771,50578,46351,52691,42193,18918,21063,21064,21095,23239,35883,46384,42190,44271,19015,8484,23242,21096,6404,6468,4323,4356,4323,10693,12806,6468,4355,8548,14885,16966,16998,17030,19110,17029,16997,17030,16997,21190,25351,27431,27431,23239,10660,8548,4356,4388,4355,4323,4291,4323,2242,4323,4291,4291,4324,6437,16969,25388,16871,29548,33741,25355,14855,12775,14824,8549,4291,4291,6436,10630,6404,4323,8517,4323,4291,4290,18},
{48729,48729,46648,48696,48729,48697,48697,48729,48729,48697,48729,48697,48697,48729,48697,48697,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,48696,48697,48729,48729,48697,48697,50777,50777,50777,50809,52857,50777,50777,50777,48696,48728,50777,50777,50777,50777,50777,50777,48696,50777,50809,50777,48499,44240,46320,46321,48498,48531,50579,48466,35855,17002,21228,23275,14921,23307,17002,25323,42192,37965,31628,23241,25322,23242,23242,23242,23242,25322,23274,23242,23242,23242,21162,23210,21129,25355,6470,6503,4423,6503,8583,40146,23307,8550,19082,8550,16969,12743,12776,16969,10663,19082,8550,17002,10663,12776,25388,21227,27534,23308,27534,23340,25453,27501,23340,29614,23275,27533,23275,25420,27469,25356,29646,29582,27501,21195,25388,25388,25355,31694,31694,29614,29549,29582,12809,10696,25454,29614,29614,29614,27534,27501,25389,25421,21194,14887,6469,4357,8550,33774,35854,35789,37934,40080,37933,25352,25322,35853,44337,44239,46385,46483,35851,48497,48432,54837,35821,33740,46353,46386,48531,40110,35883,46416,46383,42159,14790,4323,19016,18984,6468,8549,4356,4323,4356,8581,12773,10661,10661,10693,16998,21225,14886,12837,17030,17030,17029,19110,16997,23270,25351,25383,29576,29576,27432,19046,10661,4387,4387,4323,4291,4291,4291,4291,4291,4291,6404,8517,19082,23243,16871,33774,27468,16936,6436,10662,16937,10598,2211,2210,6404,10630,4291,4323,6404,4291,2210,2210,18},
{50777,48697,48696,46648,48729,48729,50777,48729,48729,48729,48697,48729,48729,48729,48729,48697,48729,48729,48729,48696,50809,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,48696,48729,50777,50777,52857,52857,50776,50776,50777,48696,50777,48728,48696,50777,50777,50777,50777,50777,50777,50776,50777,50744,50743,50711,50678,48466,46320,48401,46320,37968,16970,21195,23308,17002,19114,17034,19082,27468,27402,27435,25290,25354,25322,25322,23242,25322,25322,23242,23242,21161,23242,21162,23210,21129,21162,6503,6535,6536,6535,10663,42259,27501,14889,21195,14889,19114,14856,16937,21195,16969,19082,12744,19050,12776,14889,21195,12775,25421,12775,25388,16969,19114,23307,16969,25421,14823,25388,19049,23275,27468,23242,29581,25356,27468,16969,21162,21194,21162,29614,29614,31694,29549,31727,14857,8583,21260,29646,29646,29614,29582,27501,27469,25421,23307,14887,4356,4356,8550,35854,35821,35854,35854,40079,37966,25352,33805,40046,44305,44238,48530,44369,37964,48465,48432,54837,21128,6404,6436,10596,27497,33801,35883,48464,46384,35853,8484,4324,10630,10597,6468,8581,6468,4356,4356,8581,12806,14886,12806,12773,14885,12806,8548,10692,16998,16998,17030,19110,19109,23302,25351,25350,29576,29576,27463,25383,16998,4387,6435,4323,2243,2211,2211,2211,2243,4324,8550,10630,8549,19049,21162,27468,12678,6404,4323,8517,14856,8517,2178,2211,6404,10630,2178,4291,2210,4291,2242,2210,24},
{50777,48729,48729,48696,48697,50809,50809,48729,48729,48697,48697,48729,48697,48729,48729,48729,48696,48697,48729,48697,48729,48697,48697,48729,48729,48729,48729,48729,48729,48697,48729,48729,48729,48729,50777,50809,50809,50809,50777,50777,50776,50777,50777,50777,48696,48696,50777,50777,50809,50777,50777,50777,50777,50777,48729,50809,50809,50777,48597,48532,48564,48500,38001,17002,21195,23308,19082,21195,19082,17002,19082,23242,29516,25290,25355,25355,25322,23242,25290,23242,23242,25322,23242,21130,23210,23242,21162,14857,6503,6535,8616,6535,14888,44371,27469,14856,21195,16969,21163,16969,16937,21162,16936,21162,14856,19049,14889,16969,25420,23275,29614,23308,29614,25388,27501,27533,23307,27534,23275,27533,25388,27501,29581,27501,29614,25388,27501,23307,25356,27501,27468,31694,31726,31694,31661,31694,17002,12841,19148,29646,31694,29646,29582,27502,27469,25421,19081,14854,6469,4357,8550,35854,35821,37999,35821,40112,33772,23239,33772,40079,44273,42126,50643,40142,42158,48432,48464,52724,25354,2211,2211,6468,25447,31720,35915,46351,46351,35821,6404,4323,16871,10597,6436,8614,8613,8548,4355,4355,12774,19079,16967,19079,12805,10693,8580,8612,19111,23272,19110,16997,19077,25383,27463,27463,27463,29576,27463,23271,8547,8548,6468,2243,2243,2243,2211,2178,2210,4324,8517,8550,10630,25323,29581,16936,10597,10598,10630,12711,12711,8517,6437,6404,8485,8517,6404,6372,4323,4324,6436,4355,21},
{50777,48729,48696,48696,48729,50842,50809,48697,48697,48729,48729,48729,48729,48729,48697,48697,48697,48697,48697,48697,48729,48729,48697,48729,48729,48696,48729,48729,48729,48697,48729,50777,48729,48729,48729,50777,50809,52857,50777,50809,50777,50809,50777,50776,50777,50777,50809,50777,50777,50744,50777,50809,50809,50777,50777,50809,50809,50777,50809,50777,50809,50744,35921,17002,21228,25388,19082,23308,17002,14922,19082,21194,27435,23242,25323,25323,25323,23210,23242,25290,23242,21161,23242,21129,21129,19049,17002,8616,6503,6503,8616,6503,23340,42291,25388,6470,21163,16969,19050,19082,14921,23307,21162,21162,16936,19050,12776,12809,23275,12743,25420,14856,23307,21162,23275,25388,14855,25420,14823,23307,19081,23275,25355,19049,29581,27436,29581,29581,33775,33742,31694,29613,31726,29614,29581,31727,19115,14921,21195,27534,31727,31695,29614,29582,25421,21228,14855,14886,8614,4356,8550,33774,33773,37967,35854,37967,33741,27466,35885,40046,44272,42158,52725,37965,44271,46319,48497,50612,12710,4323,2243,10628,29576,29608,35851,44238,42126,29547,6403,8516,29548,10597,4388,6501,12774,10661,4355,4356,10661,16967,16934,19079,21192,25354,23241,21160,29580,25353,21191,19077,19110,27496,27463,27496,27463,29544,27496,16965,4354,8548,4355,2243,2243,2211,2178,2178,4323,6404,8517,8550,12743,25355,29548,21162,14824,10597,8517,12710,12711,10630,8517,8485,8550,8517,8485,6372,6372,6404,6404,4323,26},
{50777,48697,48696,48729,48697,48729,50777,48697,48697,48729,48729,48729,48729,48729,48729,48729,48696,48697,48729,48729,48729,48729,48697,48697,48729,48729,48729,48729,50777,48696,48729,50777,48729,50777,50777,50777,50777,50809,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,52825,50777,50776,50777,50777,42292,17002,23276,25356,17002,23275,14954,12809,17034,21162,27435,23274,25322,25322,25322,23242,23242,23242,23210,21129,23210,21162,21162,12776,8615,8583,6535,6535,6535,6502,25420,44404,27501,8550,19050,10663,16969,14856,12776,17001,10630,19050,12711,16969,10663,12776,27468,23275,31694,25420,27533,27501,27533,27533,23307,29613,23308,27501,25388,27501,29582,27468,29646,33807,31727,33807,31727,33807,33807,31694,31726,31694,31694,31695,19083,10663,21260,29614,31694,29646,29614,27534,25453,19115,8581,16967,10694,6436,8550,35855,33773,35886,35887,29548,42259,35887,40013,40013,44272,42126,52790,40078,46352,42093,52659,37967,2210,4323,2243,10660,29608,31689,40076,46351,44240,29548,8516,10596,27402,8484,6436,4356,6468,8581,6468,6436,12774,14886,14886,14853,25354,33806,33774,33807,31628,23240,21190,19077,19110,27496,27463,27463,27463,27463,27463,23238,8579,8580,6435,2243,2243,2210,2178,2211,4323,6436,10630,8550,6436,21130,23210,21162,12743,10598,10662,10630,12711,10662,10630,10630,10598,8517,8517,6404,6437,6404,4291,4291,16},
{50777,48729,48729,48729,48729,48696,48696,48729,48729,48697,46648,48729,48729,48729,48729,48729,48697,48729,48729,48729,48697,48697,48696,48729,48729,48729,48729,48729,48729,48696,48697,48729,48729,50777,50809,50777,50777,50777,50776,50776,50744,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,48696,48728,50777,50777,50777,50777,50777,50777,50776,50777,50809,42325,17002,21227,25420,17002,21227,17002,12841,19050,21162,27435,25323,25355,25322,25355,23274,23242,23242,23242,21129,23242,25323,21162,14889,8616,8583,6503,8616,8616,6535,25421,42258,38000,31661,33742,23275,25388,23275,23275,25356,21162,25388,21162,23307,21162,21195,25356,14791,27501,16969,23275,19082,19049,23307,16936,25420,12775,23275,16969,19081,27468,21162,29581,27436,29581,31726,31726,33839,33807,29614,31726,31694,29613,29582,19083,8583,19115,29646,31727,29646,29614,27534,27501,21195,6469,12742,12807,10694,8517,33806,35854,31692,29580,27467,48565,33741,40046,40046,46385,44206,48530,35852,42094,37836,54804,29483,4291,2243,4291,14853,29607,33801,40108,46319,39982,33708,14822,14822,29548,8516,4356,4355,6468,6436,8548,10661,12805,14886,12805,16999,31726,27499,23306,27500,31693,25386,19110,19110,21190,27463,27495,27496,27431,27463,27463,27431,19077,10627,6467,2275,4291,2243,2210,4323,4355,6436,8550,6437,6404,29549,19017,21130,16904,8517,8517,10598,10630,10630,8550,6404,8549,8517,8485,4324,4323,4324,4323,4291,14},
{48729,48697,48729,48697,48696,48697,48697,48697,48697,48697,46648,48697,48729,48729,48729,48697,48697,48697,48729,48697,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48696,50777,50777,50777,50809,50809,50777,50777,50744,50744,50744,50777,50809,50777,50777,50776,50777,48728,50777,50777,50809,50809,50777,50777,50809,50777,48696,50744,42292,17002,21227,23340,17002,23308,17034,14922,21163,21162,25355,21162,23242,23274,25355,27403,25322,25355,23275,21162,21162,21130,23275,14889,8616,8583,6535,6535,8615,6503,33807,50645,57049,59162,46419,27468,27469,27501,27469,29549,29581,27468,25388,25388,25420,25388,25388,25356,29581,25356,27501,25388,25388,29581,25388,29581,23308,25453,25388,25388,29614,29581,31694,33775,31726,31726,31726,33807,33807,29613,31726,31694,29581,31662,21195,14922,19115,29614,31694,29614,29582,27501,25421,23308,10695,10694,6436,6469,8549,31693,37934,31627,25322,21096,37967,29450,37933,40046,46385,44239,52756,42158,46418,44207,54804,19016,4323,4323,4323,21158,29608,31688,42189,42093,23176,33805,10661,10597,14854,8548,6436,4323,8548,8549,8581,12805,16966,16966,12773,27499,27467,16966,14918,16998,23273,29580,19078,21222,23270,27463,29576,27496,27463,27464,27431,27431,23238,16965,6467,4291,4291,2243,4291,4323,4355,8549,8517,8517,12710,38000,23243,23243,21130,16871,14823,12711,10598,12711,6437,6404,6404,10630,8517,6404,4324,4323,2243,2210,11},
{48697,48697,48696,48729,48696,48696,48729,48729,48696,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,48729,48729,48729,48729,48729,48696,48729,50777,48729,48729,48696,48729,48729,50777,50777,50777,50777,50777,50776,50777,50777,50777,50744,50777,48728,50777,50777,50777,48696,48728,50777,50777,50809,50777,50777,50777,50776,50777,50711,50678,46387,21130,21228,23340,17002,21163,17002,16970,19115,19115,19082,19082,19082,25323,27435,25355,25355,25323,21162,21130,19049,19017,25388,14889,8616,8616,8583,6535,8583,6503,33807,54904,54936,54937,35920,16937,19114,23275,19049,27501,27501,21195,12776,16969,19082,16969,19114,14888,23308,14856,21195,17001,16969,25388,19081,25420,14856,19114,19049,21130,25388,29614,31694,31727,31759,31727,33871,33839,31726,31694,31694,29614,31661,33839,19050,12776,19147,29614,31727,31694,29582,27501,27501,21195,12775,14919,8581,8549,8549,27499,37966,35854,31693,27467,29514,27369,40045,42159,46384,44271,54870,46351,42159,44239,50644,12677,4323,2243,8516,23303,29608,31656,42157,35788,14790,12742,4355,4323,8516,10629,4356,4356,8549,8613,8612,14918,21192,21192,16966,29548,19079,19078,19078,16933,10692,16934,14885,21190,25383,27495,29608,27495,27431,25351,23270,25351,23238,14885,6468,4323,2243,2243,6436,4355,6404,17001,12743,10630,12743,21162,12743,16937,29484,21065,10597,6404,12743,14856,4324,4324,2211,12711,6404,2210,4291,4291,2243,2210,10},
{48696,48697,48697,48729,48697,46616,48696,50777,48729,48729,48696,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,48729,50777,48729,48729,48696,50777,50809,48728,50777,50776,50777,50809,50777,50777,50777,50777,50777,50809,50777,50777,50777,50777,48728,50777,50809,50809,50777,50777,50777,50777,50777,50776,50776,52857,48598,25356,23308,23308,19083,21195,21163,19082,21195,21163,21163,21163,23243,23242,23274,23243,23242,23243,23275,23210,21162,23243,25388,14889,10696,10696,8583,6535,8583,8583,25420,52823,52823,48662,35920,21195,25388,23275,23308,27469,25356,25421,19082,23308,23308,25356,25421,21227,25420,21227,25420,25388,25356,27469,25388,27533,23275,25388,25388,27469,29614,27501,29582,27533,29646,31727,33839,31694,29581,31694,31694,29614,31662,33839,16969,6469,21228,27501,31727,31694,29582,27534,27502,19115,8582,16967,16967,14887,6436,25387,40047,33773,31694,29580,35853,27369,42126,42192,44239,46352,52757,46383,46351,50545,46386,6371,2243,2243,10629,25415,27527,33770,46318,27369,6436,4323,4323,4323,6404,10662,4323,4323,10629,10661,12774,16966,19047,23240,23273,23273,19111,19111,16998,14852,10659,10659,14885,21159,25351,29576,29608,27463,25382,25350,23270,25318,23270,10692,4355,4323,4291,4291,6468,4356,8517,23341,16936,10598,6437,10630,12743,19016,29483,10597,4291,4291,14824,14889,6404,2275,2211,10630,6404,65,2178,2210,4291,2210,12},
{48696,48697,48696,50777,48729,48696,48664,48696,48729,48697,48697,48729,48729,48729,48729,48697,48729,48729,48729,48729,48696,48729,48729,48729,48729,48729,48729,48729,48697,48696,48729,48729,48696,48697,50777,48696,48696,50777,50777,50809,50777,50777,50777,50777,48728,50777,50809,50777,50777,50777,50777,50809,50809,50809,50809,50809,50809,50744,50777,50809,50777,50809,48663,25388,23276,23276,19082,21195,21163,19082,19082,21131,21162,21130,19050,19082,19049,19049,19049,21130,21130,19050,21130,19050,21130,16937,14857,14857,8583,8583,8615,6535,25388,52856,48597,48598,35920,16872,23210,23210,23210,27469,27436,23243,12711,19049,21195,19050,21195,14889,23308,16936,21194,21130,19049,25356,19049,25420,14888,21195,21194,23243,29614,21129,27436,23242,27468,33807,31726,29581,31661,31694,33807,31694,29516,27468,17001,8583,19148,27501,31727,31694,29614,27501,25421,23308,10663,4388,6436,10630,10630,29516,40079,33741,27468,29548,37966,29450,40045,44304,42126,48498,52757,48432,46319,52658,40048,4259,4323,4291,12709,25415,29640,35915,46351,27434,6436,4355,4323,4323,4324,10629,4355,4355,8549,10661,14854,14885,21193,29580,25354,21192,21191,19078,12772,12772,12805,12804,23272,27466,27464,29575,31688,27495,25382,25383,25383,23238,12772,4355,2242,4291,4323,4323,6436,6404,8550,17001,10598,10598,2243,14889,14888,21097,18984,4291,2178,2178,10663,12776,6436,4291,2211,8549,8485,2178,2211,2178,4356,2210,14},
{48697,48696,48697,48729,48729,48696,48696,50777,48729,48697,48729,48729,48697,48729,48729,48729,48697,48697,48697,48729,48697,48697,48729,48729,48729,48729,50809,50777,48729,50777,50777,48696,48696,50777,50777,48729,48696,50777,50809,50777,50777,50777,50809,50777,50777,48728,50777,48728,48728,50777,50777,50777,50777,50777,50777,50777,50776,50777,50777,50777,50777,50809,46518,23243,23243,23243,19050,21163,19114,19050,19082,21163,21163,21131,21130,19050,19050,19050,19050,21130,19049,19017,19082,19050,19017,19017,29549,23276,6503,6535,8616,6535,21162,52855,46419,46387,50645,48500,48500,48532,48532,48500,48500,46419,46387,46354,46451,46419,33774,25421,27501,25421,25420,27469,27469,27501,27469,27533,25388,27469,27469,27501,29581,27468,29581,29581,29581,27533,27469,27501,29581,29614,31694,29614,29581,27436,23308,19147,21196,27501,31727,31726,29614,27533,27501,23340,14921,6469,6437,6404,27435,42160,40079,35822,27469,29549,37934,29450,40014,46385,44206,48498,54837,48432,46319,52724,29547,4291,4356,4291,19047,31722,31688,40108,33740,12709,6468,4356,4323,4323,4291,8548,8548,6436,6435,6500,8613,12806,23275,29548,27435,19079,21159,21159,16966,14885,12804,14885,23273,35919,31658,27495,29608,29608,27495,27463,25383,23238,10692,4355,2210,2210,2210,4291,4356,6437,6469,4356,6404,10630,8550,16969,12743,21097,16904,21097,18984,14823,12743,8550,6469,6404,6404,6469,10598,10630,8550,6469,6436,2210,17},
{48729,48697,48697,48697,50777,48697,48697,48729,50777,48729,48729,48729,48697,48729,48729,48697,48696,48697,48697,48729,48729,48697,48729,48729,48729,48729,48761,48729,48729,50777,48696,48729,48696,50809,50777,50777,50777,50809,50809,50776,50809,50777,50777,50777,50777,50777,50777,50777,50777,50809,50777,50777,50777,50777,50776,50776,50776,50777,50777,50776,50809,50809,48598,23275,23243,23244,19082,19082,19083,19050,21130,21130,21130,21098,19050,19050,19050,19049,19050,19050,19050,19017,19050,19050,19050,19050,25355,23243,6535,6535,6535,6535,21194,52791,48564,48597,57017,40080,50645,46451,46419,52823,44306,54903,40047,50644,40145,33806,27500,12743,17002,19082,17001,19050,17002,17001,19082,17002,17001,17001,19050,17002,17001,19050,19082,19115,19114,19082,21195,19082,19082,19082,19082,19082,19114,19114,16969,14889,19147,25421,33807,31726,29646,29582,25421,23341,17034,14887,10661,6436,19016,35756,35822,29516,31662,33742,35821,37967,46417,46418,31595,35886,48466,48432,46351,52757,19048,4323,4356,4291,23272,29641,31721,42157,14789,4355,6468,4356,4324,4291,4291,10629,10661,8548,10661,10661,8613,14887,25388,21129,25354,19079,21192,23272,23272,23272,16965,19078,21192,31660,31690,29575,29575,29608,29575,27495,27431,25351,14884,4387,2242,2210,2210,2243,6437,6437,4357,6405,4324,6405,6437,10663,23308,19016,29548,33741,25355,14855,10663,14856,6437,2211,2211,6469,12743,6437,8517,8516,4355,2210,18},
{50777,48696,48729,48729,48697,48697,48696,48697,48729,48729,48729,48729,48729,48697,48729,48697,48696,48697,48729,48697,48697,48729,48729,48729,48729,48696,48696,48729,48729,48729,48729,50777,50809,50809,50809,50777,50777,50777,50777,50776,50777,50809,50777,48696,48696,50777,50777,50777,50809,50777,50777,50809,50777,50777,50809,50776,50776,50777,50777,50776,50776,50809,46550,23243,23243,21163,19083,21163,19082,19050,19050,21130,21130,21130,19050,19050,19050,19050,19049,19050,19050,16937,19049,19050,19049,19050,25291,25323,6535,8616,8616,6535,21130,54904,40145,46516,54936,44306,52791,48564,48564,52823,48499,54903,40080,35887,19049,14889,16970,8615,8582,6502,6502,8582,8550,8582,8550,6469,6470,8550,14824,10663,6437,6470,10663,10631,6470,8583,6502,8517,10630,10630,10631,8550,8550,6470,10663,6437,19148,25389,33807,31694,29614,29582,27501,25421,17001,19080,16966,16999,18919,35594,29483,29484,23274,40112,37966,44273,46450,48531,27337,33740,48433,46352,46319,50644,14790,6436,6436,8516,21192,25415,35882,35852,10596,6468,4323,4323,6436,4323,2243,10629,6436,4323,10661,10693,10693,16967,21194,19048,23240,19079,23272,23272,23304,23271,21191,23304,23272,27466,31658,29576,31688,31688,29576,27495,27463,25351,16997,10692,8547,2242,2211,4323,6437,6437,6437,4357,8550,21097,18984,16969,23275,19016,31694,25387,14823,6437,10630,16937,8517,2178,2210,6404,12743,2146,2210,4323,2210,2242,22},
{50777,48697,48697,48697,48696,48729,48697,48697,48697,48697,48697,48729,48729,48697,48729,48729,48697,48697,48729,48697,48729,48729,48729,48729,48696,48697,50777,50809,50777,50777,50809,50809,52857,50777,50777,50777,50809,50777,50777,50809,50777,50777,50777,48696,50777,48728,50777,50777,50777,50777,50777,50809,50809,50777,50777,50777,50777,50777,50809,50809,50777,50809,46518,23243,23243,21163,19082,21130,19050,19050,21130,21163,21130,21130,19082,19082,19050,19050,19050,19050,19049,17001,17001,19050,19050,19050,25290,25323,8583,8583,8615,8583,19081,52855,46418,50677,54936,46354,52791,48532,50645,52758,48564,48564,19016,16969,10663,10663,12776,12808,10695,10663,10695,14888,16936,19081,16936,8582,8582,25388,44339,27500,10663,10695,25388,23340,10695,10663,8550,25355,27435,29516,31661,27468,14823,6405,12776,6437,17035,25389,33807,31726,29646,29614,27501,25421,12808,12807,10693,12806,25160,29256,33677,37902,35918,42223,37999,42192,44272,42159,42126,48498,50611,39981,48432,48499,25289,31628,31660,33741,29580,27497,40076,23208,6436,6468,4323,4356,4356,4291,2243,4356,4323,4323,10661,12773,10693,17000,14823,21128,19079,21159,23272,21223,19110,19110,21191,23304,23336,25353,33771,29543,29608,31688,29575,27463,27463,25350,23270,21190,12772,4355,2242,6436,6437,6405,6437,4357,12711,31596,19016,10565,23210,25323,27468,8484,4259,2211,8485,14856,8517,2178,2211,6372,12711,2146,4291,4355,4322,6435,28},
{50777,48697,46616,48697,48696,48697,48696,48697,48729,48729,48697,48729,48729,48729,48697,48729,48696,48729,48697,48729,48729,48729,48729,48729,48729,50777,52890,50777,52857,50809,50809,52857,50777,52857,50777,50809,50809,50809,52857,50777,50777,48728,50777,48728,50777,50777,50777,50777,50777,50777,50777,50777,50777,50809,50809,50777,50809,52889,52889,52889,52889,52922,48631,23243,23276,23276,21163,23244,21163,21130,21130,21163,21162,21163,21162,21130,19050,19050,21130,19082,19082,19082,19050,19082,16969,17002,23243,23242,8583,6535,8615,8583,21162,52823,46386,50677,54871,44241,52791,46386,50644,50677,50645,27436,16969,25356,8582,12743,14889,10630,10695,10694,10694,16968,21162,16968,10695,6501,8549,21161,44371,31693,14855,12743,12808,14889,12776,8583,8550,27468,29515,29548,33742,29548,16936,6437,16969,6405,21228,29581,33775,31726,31694,29614,27501,25421,19114,6469,4324,10630,33644,35659,31629,33773,37964,40109,35853,37933,48432,52692,46417,50643,50644,35756,50578,42160,21096,35886,35886,40144,46483,35883,42157,18983,4388,6468,6436,4356,4323,4291,4291,6404,4323,4291,8581,12774,12742,10629,8516,21193,19079,21192,21191,17030,16997,17029,19110,23303,25384,25352,33804,29576,29608,31688,31656,29543,27430,27430,25350,25318,21191,12773,6468,6437,6437,4357,6437,6404,21129,27435,6404,12743,29516,31694,16936,10630,10630,8517,10598,10662,8517,6437,6436,6404,8485,6404,6436,6435,6435,6435,37},
{50777,48696,48697,48664,48697,48664,48696,48696,48729,50777,48729,48729,48729,48729,48729,48729,48697,48697,48697,48729,48729,48729,48729,48729,48697,48729,50809,52857,52889,52857,52857,50777,50776,50777,52857,52857,50777,50777,50809,50777,50777,50777,48728,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,44470,36051,33938,36019,38099,38131,38132,40147,23244,25388,25389,21163,25388,23243,23243,25388,25324,23276,23243,21162,23275,23275,21162,21162,21162,19082,19082,19082,19114,19082,19050,23210,21130,10696,8616,8616,8615,21130,54903,35854,48597,57050,59162,57082,57082,57082,57082,50645,25355,12743,25388,12776,17002,16969,14856,16937,14888,16936,21162,25355,27436,16936,12743,10662,23307,35887,25355,19049,12776,12743,12775,14889,10663,12743,29516,31628,33741,31693,27435,14823,12743,19050,10631,23276,40146,31694,31726,31726,29646,29582,27501,21226,10661,8517,8517,19015,35821,35855,33772,35914,40108,35788,37933,46320,52724,46319,48530,48564,39981,50578,35821,4323,4356,4291,14853,27495,33802,40077,10596,4355,6500,6468,4356,4323,2243,4291,4356,4323,4323,6468,10694,10662,8484,10565,23241,19079,21191,21159,19110,19110,17030,17030,21223,25417,25384,31659,31657,29608,33768,31656,29608,27463,29544,27495,21158,12740,6403,2242,4324,6437,6437,6437,12743,27468,21097,4324,10630,23210,27500,23275,14855,10598,6404,10630,10630,10630,8517,6404,8517,8517,8485,4324,4291,4291,4291,31},
{48729,48696,46616,48696,48697,48696,48696,48697,48729,48729,48729,48729,48697,48697,48729,48729,48729,48697,48696,48697,48697,48697,48729,48729,50777,52857,52857,52857,52857,52857,52857,50809,50809,52857,52857,52857,52857,50809,50777,52857,50777,50777,48696,50777,50809,50777,50777,50777,50777,50777,50777,50777,50777,50777,50809,38099,21293,17068,19149,19148,19148,19116,29615,27469,31662,29582,23276,27501,25388,25356,27501,25388,25356,25356,25388,25356,25356,23275,23275,23275,21195,21195,21163,19114,21163,19082,21163,16937,12776,10696,8648,8616,19082,52791,35854,50742,52791,50579,54936,50612,54871,52726,46419,29581,19049,23275,25388,23243,25388,21195,25356,27501,29613,27501,25388,27501,25355,25388,25388,27501,29581,27501,27469,21195,25420,23308,23308,25388,29549,31694,31661,33774,31694,31662,25388,25356,25421,25388,29614,46452,31694,31727,31727,31694,29614,27533,19080,12805,14854,8549,19016,33709,44273,33804,35913,40109,35820,42126,46320,50611,48432,50611,44272,44206,52724,40079,4323,4324,4323,19078,29608,37963,31626,6468,4355,6500,8581,4355,4356,4356,4323,4323,6436,6404,8549,10693,12774,16968,14822,19112,19079,21191,21159,19143,19110,17030,17030,19110,23303,25384,31659,33770,31656,31720,31688,31688,29576,29576,19078,4355,2210,2210,2210,4356,6437,6437,8582,14888,12775,10662,8517,6372,21129,23242,21162,14823,10630,10630,10662,10630,10662,10630,10598,10598,8517,8517,8517,6404,6404,6404,43},
{48697,46616,46616,48664,46616,48697,48696,48664,50777,50777,48729,48729,48729,48729,48729,48729,48729,48729,48697,48696,48697,48729,48729,48729,50777,52889,52889,52857,50809,52857,52824,52824,50776,50776,52857,52889,50809,50777,50809,52857,50777,50777,48728,50777,50777,50777,50777,50777,50777,50777,50777,50809,50777,50809,48696,33938,21326,17101,19181,21229,19148,21229,31696,27437,27501,27469,23276,25388,23276,23243,25356,23276,23308,23275,23308,23275,25388,23308,21195,21195,21195,21163,21163,21163,19082,21163,19082,12776,14889,8615,8615,10696,21129,54871,50645,52790,57049,57049,57082,57050,57050,59130,50645,35886,38066,25356,23275,19049,23276,14856,21162,31726,33839,27500,23242,29582,21129,23275,21162,21162,25388,23275,27501,12743,23308,16969,16969,25388,31694,31661,33774,38000,33774,31694,27501,16904,25388,16969,31727,50677,37935,37935,35887,35854,33806,33742,27434,23208,19014,12741,25321,33675,40079,35916,33834,37932,35820,44305,46352,50578,48497,44273,35756,50480,52724,16870,4323,4323,4323,21158,29640,40076,29481,10661,4387,6500,8645,6436,6436,6468,6468,16968,12709,6404,6436,10693,12773,19080,14822,19080,19078,21191,21191,19078,17030,17030,17030,19142,23303,27497,29546,35884,29576,31688,31689,31656,31656,29576,12740,2242,2243,2210,4291,4324,6437,6437,8582,12841,8550,6469,8485,6404,29613,21162,19049,16904,10598,10598,10630,10598,10630,10598,8517,8517,10598,8517,6372,4324,6404,6372,21},
{48697,48697,46616,46616,46616,46616,46616,48696,50777,48697,48697,48729,48697,48729,48697,48697,48697,48696,48697,48697,48729,48729,48729,48729,48729,50809,52889,52857,52857,52889,52857,52857,52824,52824,52857,50776,50777,50809,50777,50777,50809,50777,50777,50777,52857,50777,50777,50777,50777,50777,50777,50809,50777,50809,40211,29680,23406,17133,19181,21229,21229,21229,29582,25356,23211,21163,21130,21163,21130,19050,21130,21130,21163,19082,21162,21130,19082,19082,19050,19050,17002,19050,19050,19050,17001,16969,12808,8615,8615,6535,8583,6503,19049,57016,59162,54903,48564,44306,54871,46419,52824,52823,42193,35919,50711,27436,25388,23276,25356,17002,21195,29614,27533,27501,25388,29614,27468,27533,25388,23275,29614,29613,29614,23308,27501,25420,23340,29581,29581,31662,35887,35919,35887,33774,29581,25421,27501,8517,25388,52824,54936,54903,54903,54903,54871,54871,54903,52790,46352,31627,46352,35820,42159,40076,25351,29481,39982,54871,46352,48530,46417,23177,35756,50544,48499,8452,4356,6469,6436,23303,29640,42189,42126,19047,8548,6436,8581,8549,6500,6501,6436,19081,16903,8516,4356,6468,10693,21160,16935,19079,19078,21191,21191,19110,19078,17030,17030,19111,21223,27529,29513,37964,33769,33769,31688,31656,31655,29576,19078,8548,4323,4323,4291,4324,6405,6437,6437,8550,12776,8550,4324,10630,38000,23242,21162,18984,14790,16904,14823,12710,10630,8485,8517,8485,8549,8517,6437,6436,6404,6372,20},
{48697,48697,46648,46616,48697,48696,48664,48697,48729,48696,48697,48729,48696,48729,48729,48729,48697,48696,48696,48697,48729,48697,48729,48729,48729,48729,50777,52857,52857,52857,52857,52856,52856,52856,52824,50776,50777,50809,50809,50777,50777,50777,50777,50777,50809,50777,50777,50777,50777,50777,50777,50777,50777,50776,54969,40180,23406,17100,19181,21261,21229,21228,38034,46485,25388,21163,21130,21131,19082,19050,21130,21163,21130,19082,21130,19082,19050,19050,19050,17002,17001,17001,19050,17002,19082,16969,10728,8616,8583,8583,8615,8583,12776,25356,27435,48532,48531,46418,52790,44306,54904,50677,35821,40112,48566,25356,27469,21195,21227,12808,19114,27501,25355,27501,21162,29549,23275,25388,23275,21162,31694,25388,27501,19049,23275,19049,19017,27468,27436,29581,35887,35919,35919,33774,27500,21162,29581,10630,23243,50743,46484,35952,35919,35887,35887,35919,35919,37999,33773,10596,29482,37933,42159,38028,14820,31627,37869,50644,44272,48530,40047,31629,42094,50545,42193,4259,4324,8549,8516,27528,33769,42190,42126,25288,8549,6468,6468,6501,8549,4355,4323,8549,12710,8516,4355,4355,10693,16967,14855,16999,19111,23271,21191,19110,19110,17030,16998,12772,12772,16997,27432,35884,33802,33769,31721,31688,29607,19077,8515,4323,2243,4291,2243,2243,6437,6437,6437,4324,16969,10663,6437,8549,14855,10630,14823,29516,25290,16903,16936,16936,19050,8485,6436,8485,12743,8517,4291,6372,4324,8485,21},
{48697,48697,48664,48664,48664,48696,46616,48664,48697,48729,48729,48729,48729,48729,48729,48697,48696,48697,48697,48696,48696,48729,48729,48729,48696,48729,48729,50809,52857,52857,50744,52824,50776,52856,52824,52857,50777,50777,50809,50777,50777,50777,50777,50777,50777,50777,50777,50776,50777,50777,50777,50777,50809,50809,52857,36051,23374,17133,19213,21261,21229,21196,40179,52856,27469,21162,21131,21163,21130,21130,19082,21130,21130,19050,19050,19050,19050,16969,16969,16969,17002,19050,16969,16969,19050,17002,10696,8616,8616,8616,8583,8648,8616,8615,12711,46453,48499,46450,50678,42192,54871,46452,40080,50677,48565,25324,25388,21227,25388,21195,25388,25420,25356,27469,25388,29614,25388,27501,29614,29582,29646,29581,31694,27468,29581,27469,27469,31727,29613,31726,35887,35887,33807,31693,33807,31694,31726,29549,27501,44404,25355,16969,16936,16968,16936,16968,16969,21161,19047,10661,25321,35885,42224,33771,12708,33740,37836,44239,46353,46352,44305,35854,44174,52658,33742,2211,4291,6436,12709,27528,35882,44238,42126,35852,8580,6468,4323,4356,6436,4291,6404,8517,6468,8549,6468,6468,10725,19048,19016,16966,21191,23271,21191,19110,19078,19078,14885,10659,10659,12772,23271,35852,33802,33801,31688,33768,29576,6467,2243,2210,2210,4291,4323,2243,6437,4357,4356,10630,19082,16936,23242,16936,12743,12743,16936,33709,21064,8484,6404,14823,16936,21130,21162,21130,19082,8517,2178,2210,2178,6437,17},
{48696,48729,48729,48696,48696,48696,48696,48696,48697,48729,48697,48697,48729,48729,48729,48697,48696,48697,48729,48729,48697,48729,50809,48696,48729,50809,48729,48696,50809,52857,52824,52857,52857,52857,52856,50776,50777,50777,50777,50777,48728,50777,50777,50777,50777,50777,50777,50777,50809,50777,50777,50777,50809,50809,52889,36019,23407,17133,19181,21229,21229,21229,40147,52824,27468,21130,21130,21131,19082,21130,21130,21130,21130,21130,19050,19050,19082,19050,16969,16969,19050,17002,16969,19050,19050,19050,12776,8616,8616,8615,8615,8615,8616,8616,12744,50646,46386,48499,50645,44273,54903,44273,46419,54903,50677,25356,21195,14856,23275,16969,23275,23243,25355,25388,19049,29582,19049,23275,29614,29581,31694,25388,29581,21129,25388,21162,19017,27533,19049,29581,35887,38000,33774,29581,33774,25355,31726,25387,21130,37967,29548,27435,25322,27403,27370,25290,25290,27402,21128,16934,27434,35853,44336,27465,16901,35820,35755,44271,46384,50611,52756,48465,46286,52723,25290,2179,10597,12742,21128,29576,37963,42060,40078,25385,6468,6468,4323,4355,6468,4323,6468,6436,6468,8549,6468,8548,14854,27435,21128,16934,19078,21158,21191,19110,16998,16997,19110,16997,16997,19110,29576,33771,33770,31688,29576,29608,21158,6435,4323,2243,2211,4291,2211,2211,6404,6405,8517,14824,12743,23274,25322,12677,16937,14856,21162,29548,16904,10630,10597,21161,33774,33741,33741,33709,31661,16903,4291,2210,4259,8517,35},
{48696,50777,48729,48696,48664,48696,48664,48697,48697,48697,48697,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48697,50777,52857,52857,52856,52856,52856,52824,50776,50776,50777,50809,50777,48696,50777,50777,50777,50777,50809,50777,50777,52857,52857,52857,50841,48696,48696,48696,33938,25455,19148,19148,21228,21228,21228,35921,44405,25388,21163,21130,21130,19082,19082,21131,21130,21163,21163,21130,19082,21130,19082,19050,19082,19082,19050,19050,19114,19082,16969,12776,8616,8615,8615,8615,8615,8616,8616,12744,35855,44274,44306,44306,44306,44306,44306,48467,33741,25387,23275,31727,31727,31727,29679,31727,29646,31727,31727,29646,31727,29646,31727,31759,31727,31727,27501,29646,27468,29581,29581,25388,29614,27468,31694,35952,38000,33807,31726,35887,33774,35952,25356,21096,50677,56984,56951,56983,56951,56951,54903,56951,54837,29547,19015,27434,44306,29579,16901,18982,37901,33707,46319,46385,48530,46319,48432,46319,52724,16871,4291,8517,10597,21127,29609,40045,48204,29448,10660,8581,6500,4323,4356,6468,4388,6468,8517,8517,10629,6404,12742,23242,23210,21129,14886,19078,21158,21191,19111,17030,16998,19078,19078,21190,27464,31689,35851,35851,31656,27463,29576,19045,8580,4323,2243,2243,2243,2242,2243,6405,4357,8517,19049,12743,25323,8485,2178,14856,12776,25323,14823,4324,2211,4259,25355,37967,37935,35854,35854,35822,14823,6371,6371,4291,10630,45},
{48697,50809,48697,48696,48696,46616,46616,48697,48697,48697,48729,48697,48696,48729,48729,48696,48696,48729,48729,48729,48696,48729,48696,48729,48729,48729,48729,48729,50777,52857,52856,52857,52824,52856,52857,50777,50777,50777,50777,50777,50777,50809,50809,50809,50777,50809,52890,38099,31728,33841,33873,33873,27534,25389,25389,23276,23276,21228,21196,23276,23276,23276,23243,23243,21163,21163,21163,21163,21163,21163,21195,21163,21163,21163,21163,21163,21163,21163,21163,21163,21130,21163,21163,21163,21163,21130,19082,19050,19050,16970,19050,16970,16970,16969,19050,19017,19017,19049,19017,18985,16904,18984,40145,25322,21162,19050,14856,12776,14921,12808,16969,10631,10630,14856,8582,16969,10631,14888,10695,12776,29614,23210,27436,18984,27436,23210,14823,25388,18985,31662,38000,37967,33774,29516,33774,29548,38000,27436,33708,56984,57049,57017,57049,57049,57017,57017,57049,52823,40079,42225,37999,44338,33806,31725,35886,44305,42127,44271,46385,42126,40012,48400,48399,50611,10597,4324,4324,6404,21159,29609,31658,27304,14822,8548,6436,6501,4356,4291,4291,4324,2243,8517,21162,10597,4291,12742,29516,16903,23242,16966,23272,23271,21158,19111,16998,16998,19078,19110,21190,27464,31721,33738,37964,29544,25350,29608,29608,19077,8515,10660,8548,2242,4291,2211,4356,6405,8550,21162,12711,23242,10630,10565,10695,23308,23210,8550,6437,2178,8452,31629,37967,35886,35854,35821,33709,25322,23210,19016,12775,12743,34},
{48697,50777,48729,48696,48696,46616,46616,48697,48696,48729,48729,48729,48729,48697,48729,48729,48729,48697,48729,48697,48729,48729,48729,48729,48729,50777,50777,48729,50777,52857,52857,52824,52824,52856,50777,50777,52857,50776,50777,50777,50809,46583,33873,27534,27566,29615,27567,25389,21163,23243,21163,21195,23244,21196,21163,21196,21195,23243,21195,23244,23244,23243,23276,23244,21195,21195,21131,21195,19082,21163,19083,19082,19083,16970,19083,19050,17002,19083,19050,19082,19083,17002,19082,16969,19082,21163,19082,21163,19050,21130,21163,19082,21163,21130,21163,23243,25356,25324,23243,23211,23211,21097,35887,23242,19082,12808,14889,14889,10695,14921,19017,21195,19049,8582,10663,12776,19114,16969,16936,23243,48532,48532,46420,48500,46419,48468,46387,46419,46387,46387,48467,48499,46419,44273,44306,46387,46419,42193,46386,57082,57082,57050,57082,59163,57082,57082,57115,48564,37966,46385,37933,42225,16966,19111,21127,40046,37900,46287,48465,46384,42093,46319,48464,44306,6339,4324,4324,6436,25383,27527,14821,4259,4355,10694,6468,6468,4356,4291,4323,2243,2178,4291,14823,10597,4356,8517,25322,16936,21129,21127,23272,23271,21191,19111,16998,16998,16998,19110,21223,27464,33770,33770,37964,29576,25318,27463,33736,31656,21158,16965,8612,6468,4291,2243,4356,6405,6437,16936,16936,21129,31661,27500,19049,27436,16936,10630,12710,6404,18984,35886,37999,35886,35886,35821,27434,19015,14822,10629,10629,6404,20},
{48696,50777,48697,48696,48697,48664,46584,46616,48696,48697,48697,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50809,50777,48696,48729,50777,50809,50776,52856,52889,50776,52857,52857,50776,50777,50777,33938,14922,14890,19083,19083,19083,19083,21164,23276,23276,23244,23276,23276,21195,23244,23244,23244,21195,21195,23244,23244,23244,23244,21195,21163,21163,21163,21163,21163,21163,19082,19082,19083,16970,19082,19082,17002,19082,17002,19082,19050,16970,19082,19050,19082,19082,19050,19082,19050,19082,21130,19017,19082,19050,19050,21162,25323,25356,23243,23210,23243,21097,37967,25355,19082,16969,19050,21162,12808,19081,29581,33806,29646,14856,17001,21195,29613,31694,27468,33709,44274,44305,54936,44273,52757,48564,48467,54870,44273,56984,44274,52759,50612,48500,54903,44273,57017,59228,59163,57082,57050,57050,57050,57050,57050,57082,57082,46385,37965,37966,40046,33804,16965,16966,23208,42094,39948,46319,50578,44238,44238,46351,50610,37935,4259,6436,6436,10596,25384,25415,8548,6404,12775,10629,8549,8581,6436,2243,4324,2243,2211,4324,12742,10661,6436,6435,12742,14822,19047,19046,23272,23271,21191,19078,19078,17030,14917,19110,21223,27464,33802,33770,35884,31657,25351,23303,23271,14885,6467,2242,2242,4323,2210,2243,4356,6437,6437,25355,25323,25322,29580,12710,8517,27435,14791,16969,16936,6371,25354,42193,33773,37999,40112,29514,12676,6403,6403,6435,6403,4290,38},
{48696,48697,48697,48697,48697,48697,46616,46584,48696,48697,48697,48729,48729,48729,48697,48697,48697,48729,48729,48697,50809,48729,48729,48729,48729,48729,48697,48729,48729,50809,50777,50777,52825,52857,52857,52857,52857,52857,48663,25486,8616,8616,14922,21196,19115,19116,19115,21196,23276,23276,23276,23276,23276,21196,23244,21196,23276,21195,23244,23276,23244,21196,21195,21195,21163,21163,21163,21163,19083,19083,17002,19083,19115,16970,19082,19050,16970,19050,17002,19050,19050,16970,19082,19082,19082,21163,21130,21130,19050,21130,21130,19050,21130,19050,19050,21163,25323,23275,21130,23243,23210,21129,38032,25388,27599,21260,23340,31760,21227,29646,27501,21162,21195,19082,17002,14889,14857,17034,16969,23275,35854,48499,54936,46386,54871,48531,50677,52758,48466,56984,46353,54871,48499,50645,52758,46354,57016,50710,54936,57050,57050,57050,57050,57050,57082,57082,59163,44272,42159,40047,37966,23272,19079,16966,25289,40045,42126,46351,46418,29417,37933,46319,52691,33741,25257,31563,31563,29515,23240,12773,4323,8549,12808,8517,8549,8581,6436,2243,2243,2211,4291,6469,14822,10629,6436,6436,6436,10629,21128,21126,25352,23239,21158,19078,19110,17030,16997,21158,23271,27496,33802,33802,35884,35850,25319,10627,4322,4323,2243,2211,2243,2210,2210,2211,4324,6437,6469,16936,29516,31661,16936,98,12710,31661,19048,21195,10598,10629,33773,37967,18951,40080,40111,25321,8482,6402,4322,4290,4290,2210,12},
{48664,48696,48697,48697,48697,48664,46616,46616,46616,48696,48697,48697,48729,48729,48696,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,50777,50777,50777,50809,52857,52857,52857,50744,27534,14890,10729,8649,14922,21228,19148,19116,19083,21196,21195,23276,21195,21195,21195,21195,21195,23244,23276,21195,21195,21195,21196,21163,21163,21163,21131,21163,19082,19082,19082,17002,17002,17002,19083,16970,17002,19083,16970,19083,17002,17002,17002,16969,19082,16970,21163,21163,21195,19082,19050,19050,19082,16969,19050,19050,19050,21130,25356,25356,21130,25323,23243,23210,40178,23275,31760,21195,25421,33872,23308,33873,23308,16969,17002,19115,19115,10696,10663,10664,14889,21195,37967,48532,54903,46386,54904,46451,52758,50646,46418,54871,46321,54871,46354,50677,48564,48434,52725,29449,50644,57082,57082,57050,57082,57050,57050,57082,52790,29482,27435,40079,33804,16997,14885,12806,25321,42125,44238,46352,50579,31563,27370,42126,52724,25290,29547,40079,37967,42224,29611,8580,2243,16968,16969,6469,6469,8549,4356,4324,2243,2211,2211,6404,14822,12709,6468,6436,8549,12742,21160,19078,23271,23239,21191,19110,19078,17030,16998,19110,23303,29577,35882,33770,35916,35850,29544,16933,6435,4323,2243,4291,4291,2243,2243,2210,4324,6437,6437,23242,31629,31661,12710,6404,12678,18984,16968,19114,4259,16903,40112,33741,31595,42160,35886,19047,8547,8515,6467,6402,4290,4290,18},
{48697,48696,48696,48697,48697,46616,46616,46616,48696,48697,48729,48729,48729,48697,48697,48729,48697,48697,48729,48697,48729,48729,48729,48696,48696,48729,50777,50777,50777,48729,48728,50809,50777,50809,50777,50777,50809,38034,21196,17003,10729,8649,14922,21196,21196,19115,19083,21196,23276,23276,23276,23276,23276,23276,23244,23276,23276,23244,23244,23244,23276,21196,21196,21163,19082,19050,17002,17002,17002,14889,16970,16970,14921,14889,14889,14889,14889,14889,14889,14889,14889,12808,14889,14857,14921,14889,14889,14889,16937,16937,16937,16969,14889,14857,14889,14857,16937,19017,19050,21130,19082,19050,40147,23275,31760,19114,27566,31792,23340,33905,21227,19082,19082,12808,12776,12776,12841,12776,19082,23275,40079,48533,52790,44273,54903,44241,52790,48467,48499,52725,44207,54871,42127,52790,46451,48499,50645,39981,54871,57115,59163,57082,57082,57082,57049,40144,31692,18983,23209,35821,33803,23271,19079,14821,29514,40045,46384,46384,52725,42225,16870,40013,50611,14790,10597,23177,6371,21094,21190,10692,12741,19081,16936,6469,6469,6469,8549,4356,4323,4324,2243,4291,19016,21096,8516,8517,10662,12774,19080,16998,25351,23239,21158,19078,19078,17030,19078,21191,25383,25416,21159,14789,23240,37963,35818,31657,19046,4355,2178,2210,2210,2210,2210,2210,4324,6437,6437,16969,29548,27436,10630,10598,8517,6372,8549,12711,6372,21161,42193,37967,42160,40079,35821,23240,16933,12740,10627,6467,6402,6435,28},
{48696,48696,48697,48697,48664,48697,48697,46616,48696,48729,48729,48729,48697,48697,48696,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,50777,50777,50777,48696,48729,50777,48728,48696,48696,46551,29615,21196,14923,10729,10729,14954,19148,19148,19083,19083,21196,23276,23276,23276,23276,23276,23243,23276,23244,23244,23276,23244,23276,23276,23276,23243,23244,21163,21163,19083,19115,19083,19083,17002,19082,19083,17002,19083,19050,17002,17002,16970,17002,17002,16969,19050,21130,21130,21163,19050,19082,17002,19050,17002,16969,16969,16969,19050,19050,23243,21163,19082,21130,21098,23243,40146,21162,25485,16969,23308,25420,21195,25453,17002,16969,17001,14921,12808,12808,17002,14889,21195,23274,40047,52693,50645,48466,54903,46321,54903,46386,52725,50677,46418,54838,44208,54871,46386,50677,48532,44273,57049,57082,57050,57082,57050,57083,48564,27433,27466,21128,37967,31660,35883,23271,21191,19014,31660,37933,48464,48497,54870,42225,29548,44238,48497,16903,6372,23275,16968,23239,19077,16965,29579,10630,10630,6469,6469,8549,8581,4323,4291,2243,2211,2211,12742,16871,6404,8485,10662,12774,19080,14885,25351,23239,21191,21159,19078,16998,14789,16934,16902,12709,8516,8484,12677,25320,23207,21127,16902,6403,4291,6404,6404,4291,4259,2211,4324,6437,6437,6404,25387,23275,8517,10598,8517,8485,8484,6404,8516,31693,42192,33740,40079,42160,31627,29514,29514,19046,14820,12740,10627,10659,48},
{48696,48664,48696,48696,48664,48697,48697,48696,48729,48697,48697,48729,48729,48697,48697,48729,48729,48729,48697,48729,48729,48729,48729,50809,48729,48729,50777,50777,48729,50777,50777,48697,50777,50777,48696,50777,46518,27534,21196,14922,10729,10729,14954,19116,19148,19116,17035,21196,23276,23276,23244,23276,23276,23244,23276,23276,23276,23276,23276,23276,23244,23244,23276,21195,21163,21195,19115,21163,21163,19083,19050,19082,19083,17002,19083,19050,16970,19083,16970,19050,19050,17002,21163,27404,27371,27404,25291,23211,19050,21130,19050,19018,21130,19050,21130,21163,25324,25324,21130,21162,21130,27403,40146,16969,25486,14921,19082,17034,17001,19114,14889,12776,12776,14922,10728,10696,10696,14889,23308,25322,48532,54904,52790,52758,57016,52693,57017,50645,54903,52791,52758,54903,48532,56985,50644,54904,27370,29449,59162,57082,57050,57082,57050,57082,46451,31627,25354,16935,31628,33772,35915,29575,29576,27432,44338,48498,48464,46384,52724,37933,35853,50545,42193,6339,4291,4324,6404,25319,16964,12708,29611,12710,10662,8517,8549,10694,8549,4323,2243,2243,2210,2211,10629,16936,6404,4324,8517,14822,21128,14885,25352,23271,21191,19110,19078,16967,10533,12678,8484,8484,8484,8484,8484,10630,8485,8485,8517,8517,10597,10598,8484,6372,6371,4291,4356,4357,4356,10630,33806,25388,12743,10630,8517,8485,8452,6404,12710,38032,42225,42225,42224,37966,29514,21095,25321,10628,8547,10660,8515,6402,27},
{48697,48696,48664,48696,48697,48697,48664,46616,48729,50809,48697,48697,48729,48697,48697,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,50809,50809,48729,48728,50777,48728,50777,50777,48696,50809,46518,29583,21163,14922,10729,8649,16970,21196,19115,19115,19115,21196,23276,23276,23244,23244,23276,23276,23276,23276,23276,23276,23244,23276,23276,23276,23276,21195,21196,21163,21163,21163,21163,19083,19082,19082,21163,17002,19050,19050,17002,19082,16970,19050,19050,16970,21130,27404,25356,25323,25324,23211,19050,19082,19050,19017,19082,19017,19050,23211,25323,25291,21130,21162,21130,27403,35952,17001,21195,14889,21195,16969,17001,19147,14856,14889,14856,17002,12776,19147,17034,14921,17034,29548,42193,52791,46451,48532,50678,44273,54871,42160,52790,46353,50611,50612,46385,54871,44208,54903,39982,44240,59162,57082,57082,57050,57050,57050,48499,25321,21128,27435,31628,33707,38027,35914,37994,29544,46451,50611,50545,48465,50611,46319,46384,50610,31661,4259,4324,4291,8484,27463,19077,19015,31660,33805,25355,6469,6437,6469,6436,4323,4323,4323,2210,4356,10630,8549,4323,4291,8517,14822,21128,16965,25351,23271,23239,21159,19111,12742,8484,12710,10630,8484,6404,6372,6372,10662,17002,14889,10695,10696,8550,8517,4291,2178,2146,2210,4356,6405,4324,19049,35919,25388,12743,10598,10597,8485,8485,8485,10565,14823,14823,16871,16967,12709,8515,6435,6435,6435,2242,4258,2210,2178,16},
{48697,48696,48696,48696,48696,48696,48696,48697,50777,48729,48697,48729,50777,48697,48729,48729,48729,48729,48729,48729,50809,48729,48729,48729,48729,50777,50777,50777,50777,50777,50809,50777,48728,50777,50777,50809,44438,27502,21164,12842,10729,8649,17002,21196,19148,19116,19083,23243,23243,23244,23244,23243,23243,23244,23244,23211,23211,23243,23243,23243,23243,23243,21163,23243,21163,21131,19050,21131,19050,19082,19050,19050,19050,16937,16970,16970,16937,17002,16937,16970,16970,16969,19050,21098,25323,25291,25291,23211,19018,19050,19018,19018,19050,19018,21098,23179,29517,27403,23210,19017,19050,21162,27469,21194,23340,16969,23308,17034,19147,19147,14889,17002,12808,14921,14857,19147,17034,14889,14888,31628,44305,54903,46386,52757,50580,48499,54838,44240,54903,46385,54838,48499,48531,52758,46353,54871,44272,52725,57082,57050,57082,57050,57082,57082,46418,23208,12774,33773,46385,46417,38027,35946,35914,31657,40078,50578,48465,48498,50579,46351,46351,52723,23210,2211,4291,10565,16902,29545,23239,29611,19016,21096,33774,8517,8517,8517,6436,4324,4356,4323,4355,6468,6436,6436,6404,6437,8549,14822,19048,16966,25383,25319,23271,21159,19111,6436,8452,12678,8517,6372,8485,8517,8517,10662,10695,10663,10630,8550,8517,8549,4324,4291,4291,4259,4291,6437,4356,10662,16968,16969,21130,27403,27403,23210,18984,14823,14791,12743,12711,12710,10628,8515,4322,6435,6435,4355,4323,4291,2210,2178,26},
{48696,48697,48697,48697,48697,48696,48696,48697,50777,50777,48729,48729,48729,48697,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,50809,50777,50777,50777,50777,50777,50777,50777,50777,50777,52857,44438,27502,19116,12842,8649,10696,16970,21163,19115,19083,21130,40048,42096,42161,40080,40048,40080,35855,35855,35887,35855,35854,35855,35855,35822,35854,35855,35855,35855,35822,33774,33742,31661,33741,31661,33742,31629,29548,31629,29549,29516,31596,29516,29548,29516,29516,29516,29483,33677,33709,31596,29516,29484,29516,29516,27436,27436,27403,29484,29484,31628,31596,29483,27371,25323,27403,23308,25453,27599,17001,27599,19115,25453,23373,12776,12776,12808,12776,12776,23308,17002,12776,16969,33709,48498,54936,46386,54871,50580,50645,52758,46385,54903,48466,54903,48499,50645,50677,48531,50612,23014,46420,57115,57050,57050,57082,57082,54937,46451,27466,16934,35788,46386,42223,44269,35915,31689,31658,42125,50578,48432,48530,50579,37901,44206,52756,16871,4291,8451,33774,29581,27467,23240,27498,27402,23176,35886,29547,29515,23242,6436,4324,4291,6436,8644,6499,6468,8580,6468,6436,8517,14854,21096,16965,27432,25351,23239,21159,16967,4323,8484,12677,10597,8484,10533,14824,14824,10598,14856,10597,10565,8484,8452,10597,4291,6404,6404,4259,2211,6405,6437,4356,8518,16969,27435,29483,18984,14758,12710,19049,19017,16936,16904,16903,10661,8547,6467,6435,6435,6467,4354,6435,4354,4354,39},
{48696,48696,48697,48697,48696,48697,48697,48696,48729,50777,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,48729,50777,50777,50777,48729,50777,50809,50777,52857,52857,44438,27502,19115,14890,14922,23276,33776,33808,33808,33775,31694,44338,46451,46451,44338,44338,38032,21130,23210,21162,23242,23243,23210,23243,23243,23243,25323,23243,25324,23243,23243,25323,25323,25355,25290,25355,27403,25323,27404,27403,25355,27436,27436,27468,27468,27436,29516,27436,27468,29516,27436,29548,29516,29548,31661,31596,31629,31629,31661,31629,31629,31629,31628,31629,33709,33773,25420,27566,27566,17002,29647,19114,31792,25453,12776,12808,12808,12841,12809,25421,14921,12809,14888,35886,48499,54903,46353,54871,48467,52726,50644,48466,54903,46354,54904,46353,52758,48531,48499,52758,40014,54871,57115,57082,57050,57082,57115,52823,44305,29514,35852,54870,44305,44238,46415,35883,27465,25321,44206,52724,46351,50611,50612,31531,42125,48531,10533,8517,23143,44306,29580,25386,27466,29547,33741,35886,40111,37965,37933,23241,6436,4291,2210,6436,10692,6499,6499,8613,6436,6436,8516,14854,23208,19078,25351,25351,23272,23271,14854,4356,8485,12677,12678,10532,10565,10565,8484,8485,10597,10565,10565,10565,8484,10565,8485,8485,8452,4291,4291,6404,6405,8517,21162,16904,29548,19049,4324,2178,4291,16936,18984,16937,16904,16904,10630,4290,6435,6435,6435,6467,8547,10724,8579,6435,33},
{48729,48696,48696,48697,48697,48697,48696,48696,48697,48697,48697,48697,48697,48729,48729,48697,48729,48729,48729,48696,48729,48729,48729,48729,48729,48729,50777,50777,50809,50809,50777,50777,50777,50777,50776,52889,44438,27470,19115,25389,33840,42226,44339,42258,44371,42259,40146,38065,38033,33840,29581,29582,27371,23210,23211,23179,23210,23178,23178,21130,21130,21131,21098,21098,21098,19050,19017,21098,21098,19017,18985,19017,19017,16905,18985,16937,16937,16937,16937,16937,16905,16904,18985,16904,18985,16905,16872,16904,16904,16937,16904,16872,16904,14824,14824,16872,16872,16872,14824,14792,14791,16904,25355,29581,25388,19082,27534,19082,31760,23308,19082,17002,19050,21195,16937,25389,14856,17002,27435,46386,48499,54871,44240,54903,46353,54871,48467,48531,52757,44273,54903,44207,54871,46353,50644,59163,59130,57049,57082,57082,57082,57114,59163,52790,40047,29514,44272,54838,35820,46350,37931,16933,10628,14725,44239,52724,46319,50644,44305,37902,46351,44305,6339,6372,25257,50677,29580,25419,27466,23242,10532,29515,37998,35820,33740,14854,4356,4323,2243,4323,8580,8580,6500,6468,6436,8581,6436,12774,25321,19078,27432,25352,23239,21192,10694,6437,10565,12677,14791,10598,8452,6372,6372,4259,6404,8517,6404,8485,6404,4259,6372,6404,6372,4291,6404,6437,6405,8582,16937,12710,31662,23307,6372,4323,6404,19016,21097,23177,23145,21096,18983,16838,14790,12677,10661,8548,8547,12741,14886,8548,32},
{50777,48729,48696,48696,48664,48697,48664,48696,48729,48729,48729,48729,48697,48697,50809,48697,48697,48697,48696,48729,48729,48729,48729,48729,48729,50777,50777,50777,50809,50777,50777,50777,50777,50777,50809,52889,42324,29550,31727,42258,44371,44339,44339,42258,44371,42258,40146,38065,35953,33840,29582,31662,44273,37934,42160,40047,37935,40048,37935,42128,39983,37934,40048,37902,40015,37934,37902,40048,35854,37935,35854,35854,37935,33742,37903,35854,35822,37935,35822,37902,35822,35789,37902,33741,35822,35822,33709,35822,33709,35790,35790,33676,33709,33644,33677,33677,33644,33677,31596,31596,31596,31564,33677,31564,29516,31629,31596,31596,29516,29483,29516,29483,29516,29515,29483,29483,29451,25258,35789,46386,44274,44306,46354,46419,46451,46451,46419,46419,50645,50677,50710,50677,46484,46451,48532,48565,50677,57049,57082,57082,57050,57082,57114,50677,50579,46385,52724,52725,39981,42156,21094,16966,10661,16902,48465,52756,46319,52757,44207,37901,50578,37968,4291,2211,31597,50710,29580,25387,29547,37966,33675,35853,40111,35885,21128,10629,6436,6436,4324,4291,4323,6435,8548,4355,8548,8581,4355,12741,23208,16933,27432,27432,25352,21160,6469,6437,10630,10597,17001,19179,6404,4291,4291,2211,8582,12841,4324,6502,6534,4291,4324,2178,2179,4291,4323,6437,4357,6469,19049,23177,31661,25420,8549,10597,21129,42192,44273,44240,44240,44240,44240,44272,42127,35821,23209,16936,14856,8517,4291,4291,32},
{50809,48729,48697,48697,48696,48696,48696,50777,48696,48729,48729,48729,48697,48729,48697,48696,48696,48729,48729,48729,48729,48729,48729,50777,50777,50809,50809,50777,52890,50777,50777,50777,50777,50777,50777,52857,42259,33808,35888,33840,33840,42259,42258,42258,44339,42226,38033,33807,33742,38001,35920,37935,48466,37934,44273,40079,40047,44241,39982,44240,42127,40047,44273,40015,44273,40047,40015,44273,37966,42160,40079,37934,42192,37935,42160,40079,37966,44273,40014,42160,44208,37934,44240,39982,42127,44208,37901,44240,37933,42127,44208,37934,44240,40014,42095,44208,37901,44208,39982,40047,44208,35821,42127,39982,40014,42160,37901,42127,40014,39982,42127,37869,42127,40014,39949,42127,37869,37967,35822,31596,25323,25290,23210,23210,25322,25290,23242,25354,35854,35854,38065,38098,27468,27403,27403,29548,31661,35822,50612,57016,48563,54903,57017,54936,54969,57082,57082,54904,44271,42156,19046,19046,10628,23176,50611,52691,46319,52724,48432,46351,50643,27467,2211,4291,40112,52823,29580,29580,31660,21064,33741,40079,27434,16934,8516,8516,8549,4323,4324,4324,2243,2210,2243,4291,12742,10661,6436,16935,25355,14854,25353,27466,25385,21225,8550,8518,10597,10565,14889,19179,6437,4324,4291,2211,6469,12808,4324,6534,8615,4292,4292,98,2211,4323,4291,6437,4389,8550,25355,33774,31694,21194,8516,10597,31660,44241,35853,44240,44272,44272,44272,37934,31660,27435,16968,12742,10630,4291,2178,2178,24},
{52857,50809,50777,50777,48697,48696,48697,48697,48697,48729,48729,48729,48697,48729,48697,48697,48697,48697,48696,48729,48729,48729,48729,48729,48729,50777,50777,50809,52857,50777,50777,50809,50777,50777,50776,50809,42227,33841,15281,13299,13168,25486,44339,42258,44339,40146,33807,27468,33807,40178,38033,40080,44306,38000,42193,40112,40080,44306,37966,44240,42127,40047,44273,40015,44241,42127,37934,42192,37934,42127,42127,37901,42192,37934,42127,40047,37933,44240,40014,42095,42160,37902,44208,39982,42095,42159,37901,44240,40014,40047,42192,37902,42160,37966,40047,44273,37901,42160,40014,37934,44208,37901,42127,40014,39949,44207,37869,42094,40013,37869,42159,37901,42095,42095,37901,44240,40048,44404,42259,33840,33873,33840,33840,33840,33840,31760,31727,31760,31727,25421,31727,40178,27469,25323,27403,29516,29548,27370,48564,54870,44272,54903,48597,44403,52856,52888,48630,33773,42190,44301,31690,21159,14854,27401,52691,50578,46320,52724,46351,46351,52691,25289,10629,10596,42225,52823,29581,27468,33773,21063,27370,40046,27433,21128,10629,12742,8549,6404,6436,4324,2243,2210,2211,4323,16903,14854,14888,27567,27567,25486,27567,27567,27567,25486,23374,19115,10630,10565,16969,19114,8517,6404,6404,4291,8550,12808,6404,8582,10663,6404,6404,2211,4291,4291,4324,6437,6437,6437,21129,37999,27468,14823,6404,14823,37999,44305,40047,44272,44272,44272,35821,21097,12743,10629,10662,6436,4291,2178,2178,2210,12},
{50809,50809,50809,50777,50777,50777,48729,48696,48729,48729,48697,48729,48729,48697,48729,48697,48729,48697,48729,48729,48729,48729,48729,48729,48729,50777,50777,50809,50809,50809,50809,50809,50809,50809,50777,52857,44372,34036,15575,11088,15477,29909,44306,42258,44339,40146,29581,25388,19050,14889,16969,16970,19082,21162,23243,21162,25323,46418,37934,44240,42127,40014,44240,39982,42160,42095,37902,44240,39982,42128,42127,37902,44240,40014,40047,42159,37901,42191,37934,40047,42160,37901,42160,40015,40015,42160,37901,44240,40015,40014,44208,35821,42127,40046,40014,44240,37868,42127,40046,37901,42159,37869,42095,42127,37901,44208,39982,40014,42095,37869,44208,37934,40014,42127,37901,44240,42258,44404,40178,33840,33873,33872,33872,33840,33840,33872,31792,31760,29647,27502,25388,35985,31694,35854,31660,35854,35886,37901,52789,44240,37901,54936,46516,48629,52856,42226,33840,29515,44270,46349,44269,25320,16934,33707,50610,48497,46352,48497,46384,46351,50643,23176,21161,14789,37999,54872,31629,33774,35886,37934,33708,44239,37933,23241,8549,8517,10629,6468,6436,4324,4291,2211,2211,2243,10597,10661,23307,27599,25519,27600,27567,25519,25519,25455,25455,14922,8549,12645,14791,8485,10565,10597,10565,6404,8517,8517,10565,10598,12646,8485,8485,8485,6436,4291,4324,6469,6405,6469,27468,31661,21096,16968,12710,25290,44305,29580,37966,44272,46320,33773,14822,6436,4323,6403,8516,4323,2210,2210,2210,2211,13},
{52857,50809,50777,50809,50809,50777,48697,50777,50809,48729,48729,48729,48697,48697,48697,48697,48729,48697,48729,48729,48729,48729,48729,50777,50777,48729,48729,50809,50809,50809,50809,50776,52857,52857,52857,52857,44405,38131,32021,23733,27862,40244,42227,42259,42259,35952,27533,25420,14889,10664,12744,14824,14857,16937,16937,16905,19017,42160,40015,42160,40015,40047,44273,37934,42160,42128,40015,44241,39982,42128,42160,37934,44241,39982,40047,42160,37901,44240,40014,40015,44240,37901,42160,42096,40014,44240,37901,44208,42095,39982,44208,39981,42127,42127,37901,44207,37901,40047,42127,37901,42160,37901,40014,42160,37901,42127,37934,40014,42159,37901,44208,39982,39949,44207,37869,44272,42258,35985,33840,33872,33872,33840,33872,33872,33840,33872,31759,35985,40179,38066,35953,33840,40146,37967,25257,25322,23241,31660,52822,37934,37933,57049,52758,52823,57050,54904,48565,33740,44302,46381,44301,27465,16966,35852,50610,46383,48465,44239,46318,48432,48499,16772,18917,18917,37999,52856,31661,35887,23177,18951,42160,37965,21096,8517,8550,14889,10694,8581,6469,4324,4292,2211,2211,4291,8517,10597,29647,25454,25487,25519,25519,25519,25487,25487,25487,12809,8485,12645,12743,8485,8484,6404,6372,4259,4324,8517,8517,8485,6404,4291,4292,6372,4324,4291,4323,6404,6437,6437,19049,21130,12710,12742,16903,31628,42192,25321,42192,46352,42159,16935,6403,4356,2243,4323,4291,2210,2210,2210,2211,2211,14},
{52857,52857,50809,50809,50809,50809,50777,50777,50809,48729,48729,48697,48697,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,50777,48729,50777,50809,52857,50809,50777,52857,52857,52857,52857,54970,35954,16905,19018,19018,19018,19017,19017,19017,19049,21163,23275,25356,25389,27437,27437,27469,27437,27437,27437,27437,27436,31597,33710,42162,35854,44273,46386,37870,42095,42095,39982,44241,39982,42095,42160,37901,44240,40014,40015,42160,37901,44208,40014,40014,44208,37869,42127,42095,40014,44272,37934,42127,42127,37902,44240,37934,40047,42128,37901,42160,39982,40015,42160,37869,42127,40014,39982,44240,37869,42095,42094,39981,42159,37901,42062,42127,37901,44239,37868,44272,42226,35952,33872,33840,33872,33872,33872,33873,33840,33840,29679,38033,42292,40211,38098,33840,42259,37967,31628,29516,25354,25321,48596,37966,37934,54968,54936,52790,50677,44338,50677,40079,44270,44269,44301,27432,16901,37965,48466,44239,50578,39949,39915,48464,50545,37704,43911,46187,46450,52823,33741,37999,42160,35853,42192,40046,27435,19017,10598,12711,10630,10694,6469,2243,2243,2211,2243,2211,4323,8517,27599,25454,25422,25487,25487,25487,25519,25455,25487,19148,10630,10565,10662,8582,6437,2276,2211,2211,4356,10728,8615,6437,2211,2211,2211,6404,4291,2211,2211,4356,6437,6437,8582,14889,6469,6437,16936,40047,44272,40079,46352,46352,37901,12709,8516,6436,4291,2210,2210,2210,4291,2211,2178,2178,14},
{52857,52857,52890,52857,50809,50777,50777,50777,50777,50777,48697,48729,48729,48729,48729,48729,48729,48729,50809,50809,48729,48729,48729,50777,48729,48729,50809,50809,50809,52857,52857,52857,52857,52857,52857,52857,46518,38001,38033,40114,40081,38033,38001,33807,33775,29549,23308,23308,38001,42226,42194,42194,42194,42193,42194,40113,40113,38033,31727,31630,31693,40015,46321,37902,42128,42128,39983,44241,40015,42095,42160,39982,44241,42095,42095,44208,40014,44241,42127,40047,44273,37934,42192,40112,37966,44273,37966,40112,42193,37934,42193,40015,40047,44241,37902,44240,40046,40047,44240,39982,44207,42094,39982,44240,37868,42095,40014,37934,42160,40014,40014,42160,37901,42127,37934,44273,42259,33840,33840,33872,33872,35953,33905,33873,33872,33872,31727,35953,42292,40211,40179,31759,25388,40113,40080,25322,23274,25321,44338,37966,25289,23209,27434,27434,19015,21096,40112,40046,42125,46349,44269,31689,21127,37901,50612,48498,50578,46126,44076,50578,44306,16837,23110,35722,42225,54904,35919,33806,23209,37999,44304,40078,18984,14824,14823,8485,8484,8581,6436,2211,2243,2243,4291,2211,4324,8549,27599,29647,25422,25486,25487,25487,25487,25487,25487,21294,10663,10565,12711,8582,4389,2276,4292,2211,4324,10696,8615,8583,2244,2179,2211,4356,4324,2211,2210,4356,4357,6437,6469,10631,6469,8549,23241,44272,46385,46352,46352,44272,29514,10661,6435,4323,4323,4323,4291,4291,6469,6404,4323,4323,26},
{52857,52857,52857,50809,50777,50777,50809,48696,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48729,48729,50809,48729,48729,50777,50777,50809,52857,52857,52857,52857,52857,50777,52857,52857,52857,50744,44307,44307,46387,42226,44307,44306,42194,40114,33775,27469,23243,35855,44274,40113,40113,42193,40113,40145,40113,40145,27469,14824,12712,19081,40112,37967,27403,29484,29516,29483,29516,27403,27403,27403,25290,29516,29483,29451,31596,29484,29484,29484,27403,29516,27436,27436,27435,27371,29484,27371,27403,29516,29515,31596,27403,29451,29516,27370,29516,27403,27403,29516,27403,29516,29516,29483,35789,42127,40048,31694,21130,23210,23243,23210,23243,23210,23242,23242,42194,40114,33840,31760,27533,29614,29614,29646,29614,29614,29614,27502,25421,29614,27534,23308,19147,21195,40146,31661,16904,19016,21128,42257,40080,29515,14822,10629,23273,25353,25354,25322,35853,42157,48462,44269,29609,29514,48531,52790,52724,52756,48367,46221,50611,31595,16902,16902,12676,31661,54969,35887,33774,18950,31660,44304,33772,8517,4324,8517,8485,6436,8581,6436,2243,2243,2243,4324,4324,8517,10661,27567,27534,19115,25454,25487,25487,25487,25455,25455,21261,8582,10565,12743,10598,8485,6436,6404,4291,6437,10662,8582,8582,6404,4259,4324,6404,6404,4291,4291,4356,4356,4357,4389,6437,6469,10630,27500,44273,44273,44272,44272,44240,29514,8515,2274,4323,4355,4323,4356,6469,6502,12743,19114,21162,51},
{52890,52857,52857,52890,52857,52857,50809,48729,48729,48729,48729,48697,48697,48729,48729,48729,48729,48729,48729,48696,48729,48729,50777,50809,50777,50777,50777,52857,52857,52857,52857,52857,50809,50809,52857,52857,52857,48598,42258,44339,42226,44307,42226,42258,42226,33839,27501,23243,29549,38001,35855,37968,38000,31694,27501,27501,29581,23210,16905,14889,14856,25322,44306,35822,40047,40048,37902,42128,37902,40015,40047,35789,40048,40015,37902,42128,37902,40016,37935,35789,40015,35789,37870,37902,33709,37935,35789,33709,37934,33708,37870,33709,33676,35822,33644,33709,33709,29515,33709,31596,31629,33741,29515,35821,44176,35821,31628,25258,25290,25258,25225,25258,25225,25225,25257,44339,35920,27469,27501,25356,27501,25420,27501,25388,25388,25389,23308,23308,23308,21228,17002,17002,23276,42259,25388,19016,19080,21160,42225,40112,31628,14855,8549,12774,16967,27435,33774,35789,40044,48495,33771,10627,35886,56951,50610,48465,52757,50545,48399,52659,21096,6436,14854,12677,31694,54904,44339,35821,35852,44272,44271,35821,10598,4292,12678,12677,12645,10597,4323,4291,4291,2243,4323,6437,12742,14854,31825,25454,19114,21259,23373,25486,25486,25487,25487,23374,12776,10532,14790,10565,10532,10533,10565,10533,12710,10597,10565,10565,10532,8484,10597,8484,8484,6372,4291,4356,4389,4357,4356,10663,14856,6437,8517,10597,14758,16870,14758,14757,12740,8547,6468,4355,4355,6468,8550,6502,6470,8550,14888,16968,49},
{52890,50809,50777,52857,52857,52857,50809,48729,48697,48696,48729,48729,48697,48729,48697,48697,48729,48729,48729,48729,48729,48729,48729,50777,50777,50809,50777,50809,50809,50809,50777,50809,50809,50809,52857,52857,52889,52857,46453,42258,42226,44339,42258,44307,44339,38065,29581,21163,21131,23243,21195,23243,21163,16938,12777,12744,14856,33709,29516,29549,29516,31596,44305,37934,42095,42160,39982,44208,40047,40015,42160,37901,44208,42095,37902,42127,39950,42128,42159,37933,44208,39981,42094,44207,39982,44208,40015,40014,42192,37934,42127,42127,37934,44273,39982,40015,44208,39982,44208,40015,40014,44240,39949,44207,42095,37869,44208,39981,42062,42127,37869,44207,39981,39981,44207,48532,33839,16936,16937,19082,21162,21162,19114,23308,31792,29614,19082,21163,21163,19082,14921,14953,27469,44339,23274,21194,23273,23208,40145,40112,29515,14855,14855,21161,16935,29548,37966,52758,42157,40044,19014,14853,37966,52724,50578,48432,52789,48497,46351,50611,12710,4356,16935,14822,27469,52856,54936,21064,14757,42192,42126,31628,18951,29385,41963,35592,33544,10596,2243,2243,4323,2243,4323,4356,8516,19080,40244,29647,14855,12743,23372,19178,17034,25454,10695,8550,6437,8484,12710,10565,10532,10532,10565,10565,12710,10597,10565,10565,10565,10533,10597,8485,8484,6404,4291,4291,4389,4389,8517,16969,16969,8485,4324,14790,25321,21031,6339,4291,8547,8579,6499,4322,6437,8550,8550,8550,8550,8549,12743,14888,50},
{52890,50777,50809,52857,52857,52857,50809,48729,48729,48696,48729,48729,48729,48697,48697,48729,48729,48729,50809,48729,48729,48729,48729,50809,50777,50777,50777,50777,50777,50809,50809,50841,50809,50809,52857,52857,52857,52857,52857,46518,42226,44338,44306,42258,44339,42226,33839,27501,25421,27502,25389,27534,19082,14857,14857,14857,19017,46354,37934,42160,42127,40014,42160,39982,42095,42160,39982,44208,40014,40014,44240,37934,42127,40047,37934,42159,37934,40047,42127,37934,42160,37934,40014,42160,37902,42128,42128,37902,44240,37934,40047,42160,37902,44208,39982,40014,44208,37901,42127,40014,39981,44207,37901,42062,44207,37901,44207,40014,40014,42127,37901,42127,40014,37933,42159,52759,48598,31694,25388,27469,27533,25388,29614,33840,23243,21195,25356,25388,25388,23308,21195,19082,29582,42258,21161,25354,25386,25321,40080,40144,25353,14854,12742,25386,21128,33741,42159,52757,42190,31625,12773,14886,29481,48432,48465,48464,52789,48464,48463,46418,8484,6404,14854,14822,27436,52824,50677,37966,35788,42159,40013,29515,35853,46188,43977,41896,35624,8516,4356,2243,4323,4323,6500,8581,4323,23274,42325,27567,19114,21227,25486,23373,21260,21292,6469,130,4291,8485,12710,12645,10532,10565,10565,10532,12678,12646,10565,10565,10565,10565,10597,8517,6404,4323,2211,2243,6437,6405,8518,16937,19017,21097,31563,35755,27337,8484,4291,4291,6403,6435,8580,12806,17001,12743,10663,10630,8550,8582,16969,19050,45},
{52889,52857,50777,50809,52857,50809,50809,50777,50809,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,50777,50809,50777,50777,50809,50777,50777,50809,50809,52890,50809,50809,52889,52857,52857,52857,52857,52889,50711,46452,42226,42226,42258,40145,38000,33808,29550,29582,27469,31695,31629,27404,27404,27404,29451,46354,37934,42160,42127,37934,44240,39982,42095,42127,37934,42160,40014,40014,42192,37934,42160,40047,37934,42160,40015,40047,42160,37934,42192,40014,37934,42160,37934,42127,42128,37934,44240,39981,40014,42159,37901,42127,39982,39981,44207,37901,42127,40046,37869,44207,39982,40014,40047,35821,42127,40047,40014,44240,37902,40047,42127,37901,42160,44307,46485,33840,31759,33839,33872,31759,31727,38066,21130,23243,25421,25421,25421,25421,23308,21227,33807,40145,16936,19081,19049,23209,38032,40080,23208,14854,10693,16935,19016,31629,33741,48498,42190,21159,14853,14853,31626,48464,48464,48432,52789,48400,50544,42192,16902,27401,14854,10629,27435,52856,42226,19015,35886,42191,37900,29515,29548,35821,41930,43977,35591,8483,6436,4324,4323,4356,8581,8581,8484,29614,40212,29647,21227,27534,27567,25487,25487,25454,10759,6533,8549,10597,12710,10597,8485,10598,10630,8517,10630,12710,10598,8517,8517,8485,10598,6437,4356,4291,2211,2243,6437,6469,6437,8550,16969,25355,35788,31529,19016,6436,4291,6436,4355,4355,4355,12774,31693,29581,29548,27467,19049,8517,10598,10630,37},
{52890,52857,50777,50777,52890,52857,50809,50809,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,50809,50777,50777,50777,50777,50777,50777,50809,50777,50809,50809,50809,50809,50809,52857,52857,52857,52889,52857,50777,52889,54937,50711,44372,44372,44372,44340,44307,37968,37968,35855,39983,48434,37934,42160,40014,40014,42160,37902,42159,40047,37902,42160,37966,40079,42160,37934,42192,37967,37966,44273,37934,42128,42160,37934,42160,40048,40079,44240,37902,42160,40046,37901,42159,39982,42094,42127,39981,42159,40014,40014,44207,37901,42127,42095,37901,42127,37902,40014,42127,37869,42127,40014,40079,50677,40047,40047,42095,37901,42159,40014,40014,44207,37901,42127,37967,40178,35953,33905,33905,35953,33873,31760,38066,21162,21162,25388,25388,25388,25388,23275,21195,35920,33807,14823,14888,19049,23242,35918,42224,31627,27401,23209,19016,23210,35822,31563,48498,44271,31658,19078,19046,33739,48432,48496,48497,52757,48399,50578,35822,14789,27434,10596,8516,25354,54969,46452,25289,31628,42158,33708,29548,27370,31595,46122,48136,31462,8516,6468,4356,4356,6436,6436,6436,14855,38066,36018,29712,21227,25486,27567,27567,27567,25454,17066,10792,14920,10597,12678,10630,6437,6469,6437,6404,10630,10695,8550,6404,6437,6404,10598,6437,4356,4291,2210,2210,6437,6470,6437,6405,12711,16936,21161,25322,8484,4323,4355,6499,6499,8547,6402,19048,31693,31661,31661,29548,19016,6437,10629,12742,41},
{52889,52857,50777,50809,52857,50809,50809,50809,50777,48729,50809,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,50777,50777,48729,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,52857,52857,52857,52857,52857,52857,52857,52889,52889,52857,52857,52890,52856,50678,52758,50678,50645,48532,37934,40112,37934,37967,42193,37934,40080,40112,37967,42193,37967,40080,42193,37935,42193,40048,40047,44273,37967,42160,42192,37966,42160,42128,40079,44272,40014,42159,42127,37901,44208,40014,42095,44240,40014,44240,42127,40014,44240,40014,42127,44208,40014,44208,40015,40015,44240,37902,42127,40047,42127,52790,42095,42062,42159,37901,42127,40014,37933,44207,37933,40047,40113,46452,35953,33905,33905,33905,33873,31760,33840,25420,29581,29614,29614,29614,29614,29614,29549,42291,33774,23177,25258,25322,25290,35886,52823,57049,50644,29515,29580,35854,37967,37998,46418,40013,37932,31658,21159,33740,42158,48496,50611,52723,48367,52658,29515,8580,4356,4323,12773,23273,52757,52790,48497,44272,42126,35789,29548,35821,46188,44008,50216,35623,6436,6436,4323,4323,6436,6404,6404,14856,40211,38164,29712,21195,27534,27567,27567,27567,23405,14953,12840,12808,10597,12678,10630,6437,4356,4291,4324,12678,6469,2211,4291,4291,4291,8517,6404,2211,2243,2210,2210,4356,6437,6437,6405,6437,16969,16968,8548,4322,4323,8548,10692,8579,8580,8579,27499,31693,31661,25419,19048,8550,8550,14823,16968,51},
{52889,52857,52857,50809,50777,50777,50809,50809,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48696,48697,50777,50777,50809,50777,50809,50777,50777,50809,50841,50809,50809,50809,52890,50809,50809,52857,52857,52857,52889,52857,52857,52857,52889,52857,50777,50776,52857,50809,50809,52889,52890,48663,42324,42324,38098,31695,42324,42324,42291,42324,35985,25388,27501,27469,27501,27501,25389,27501,27501,27469,27501,27468,27469,27501,27468,29549,25355,25387,29548,27435,29515,29548,27436,27468,27436,29516,29548,27436,29516,29516,27436,31597,29548,29581,31629,29516,31629,31628,29548,31629,29548,31661,31628,35821,46419,33741,33676,35789,33676,33740,33773,31628,40047,38032,33808,35920,44404,35921,33872,33840,33872,35921,33840,31727,31727,31727,29646,31727,31727,31694,31727,31694,44339,42192,40047,40047,42160,44272,42159,54936,50678,37966,31627,33773,38031,40079,46353,46385,37933,37932,35883,21094,42193,46353,48465,50611,50610,46318,50610,29482,12773,4356,4323,16966,14821,25190,46287,42191,37966,40078,31660,31629,31628,48300,46089,44009,35819,8580,8548,8548,8549,6469,4323,6436,23340,40244,40277,31793,21195,27534,27567,25453,23405,23405,10663,2178,4291,10565,12678,10630,8485,10598,10598,8517,10630,8550,6404,6372,6404,8485,10598,8485,4291,4323,2211,2211,6404,6437,6405,6404,12711,14823,14855,8548,6467,8516,6403,8580,8579,8612,8547,25386,33773,31661,16936,10662,8517,8582,10663,10630,48},
{52857,52857,50809,50809,50809,50809,50809,50809,50777,50809,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,50777,48729,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,52889,50809,52857,50809,50809,52857,52857,52889,52889,52857,50809,50809,50809,50809,50809,52857,52889,48631,40243,42324,38098,29647,42325,42324,42292,42357,31793,23341,23373,23341,23341,23341,21261,21228,21228,21196,21196,21196,19148,19148,19115,19115,10696,12776,16937,16969,19017,16969,16969,19017,14889,12776,12776,14857,12776,12744,12776,10663,12776,14824,12743,12743,12744,10663,12744,12711,10663,12743,10663,12776,12775,12743,16904,16936,16904,16937,14824,14758,35887,38131,31761,35921,46484,46517,46517,46485,46485,46485,46453,46453,44404,44404,44372,44372,44404,44372,44372,44371,35887,19016,23241,44273,33740,29547,40046,54935,40145,31726,27499,37999,46451,44272,46385,48499,44271,48463,44270,27400,48596,50546,48465,50611,50545,48464,50610,21095,14854,4356,4356,12806,14885,25222,39914,42192,40079,42192,31661,31661,37933,37803,20966,12677,14854,10693,8581,8581,8581,4356,4356,6436,31760,40244,40277,31825,21195,19179,23340,23373,21228,25487,12809,2146,4259,10565,12678,12742,10565,10565,10565,10597,10597,12711,10597,10597,10565,10565,10565,10598,8485,4323,2211,4291,6437,6437,6405,12743,12678,10532,10628,8580,10660,8516,4290,4355,4355,8580,8579,10628,27467,33774,16903,10630,10662,8582,10663,14856,44},
{52857,52889,50809,50809,50809,48696,50777,50809,50777,48729,48729,48729,48697,48729,50809,50809,48729,48729,48729,50777,50777,48729,50777,50809,50777,50809,50809,50777,50777,50809,50841,50809,50841,50809,50777,50809,50809,50809,52857,52889,52889,52857,52857,50809,50777,50777,50809,50809,52857,50809,52857,48663,40243,42324,36018,27534,42357,42324,40244,40244,40244,40211,38131,36019,36018,33906,31826,29713,29713,29680,27567,27600,25487,27567,25422,23341,10728,12809,16969,16969,19082,17001,19050,21162,16937,14857,14856,14889,12776,14856,14857,12776,14857,14857,12744,12776,12776,10695,12776,12744,12744,12776,10695,12776,10663,12743,16937,14856,16904,19017,14824,18952,42193,36019,29712,33840,50710,57082,57082,55002,57050,52856,54969,52823,50775,54937,55002,54970,54970,54970,54970,52856,29580,8517,10662,42257,29515,14821,40047,52790,33773,16935,10629,25322,40079,44239,46418,48498,44238,48497,44237,31561,48530,50545,48432,50610,48432,44206,27370,10597,8549,8581,10661,12741,19046,25255,39916,42160,44305,40014,31628,33709,35789,8452,4357,6469,6436,8581,6500,8581,6468,4323,4356,10695,33937,40244,42358,33906,17034,12840,23373,25454,14889,25454,19115,8582,10630,12646,12646,12710,8484,6404,6404,6404,10597,12743,10630,8517,8517,8517,8517,10630,8517,4291,2211,4323,6437,6437,14824,12646,10532,10596,10692,8580,8547,6467,6403,4323,4323,4322,6435,8515,8548,27499,27435,25355,19049,8517,6469,14856,36},
{52890,52889,50809,48696,50777,50777,50777,50777,50777,48729,48697,48697,48697,48729,48729,48729,48729,48729,48696,48729,50777,50777,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,52889,52857,50809,50809,52857,50809,50809,52857,52857,52857,52857,52857,52857,50809,50809,50809,50809,50777,50809,50744,48631,48663,46550,42357,48631,48631,46551,46583,48663,48631,44470,40309,36116,33972,33972,31923,31859,29778,29778,31825,33905,35920,33807,31727,12841,12776,16969,19050,19050,16969,16937,19049,14889,14856,12776,14889,12776,14856,14857,12776,14857,14857,12776,14857,12776,12776,14856,12776,12776,12776,12744,12776,12776,12743,14856,14856,14856,16937,12775,16936,44339,40179,35986,38065,50710,55002,54970,54937,54937,50743,52856,50711,50743,52856,54937,54969,54969,52824,44371,35952,19048,10630,8549,31757,23240,16901,42193,59162,54903,31628,14822,35886,48465,46254,48466,48531,42159,48464,42157,33641,48433,50545,48464,46385,27433,27337,12677,6437,8517,10662,8548,10693,14821,23143,35788,46419,48531,33708,33741,31628,35756,8484,10631,10630,6436,8549,8581,6468,6436,4324,4323,12775,33873,38164,36051,33906,21227,27534,27567,25487,27567,29648,27567,27600,21260,12678,12645,10597,4324,4324,4324,4291,10598,14888,12840,8582,6501,6437,8517,10695,8615,4291,4291,4323,4356,8582,19049,14758,10532,10564,12773,8547,6435,6467,8580,4323,4355,4323,4323,4355,6403,14822,31693,31661,21129,8550,8517,12743,40},
{52890,52890,52857,50777,50777,50777,50777,50777,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,50809,50777,50809,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,52889,50809,50809,50809,50777,50809,50809,52857,52857,52857,50776,52857,50809,50777,50809,52857,52857,50809,50809,52857,52889,52857,52857,52889,50809,50809,50809,50809,50809,50809,48696,44503,40310,36182,36149,36149,34036,23374,17035,21228,25355,25355,25355,23275,12776,12809,16969,19017,19017,16969,19050,21130,16937,14856,14889,14889,12776,14857,14857,12776,14857,12776,12776,14857,12776,12744,14856,12776,12744,12808,12744,10696,12776,10695,12776,14856,12776,14856,12776,16903,46452,57082,54969,48597,50743,55002,54970,54970,54970,50711,52856,48598,48630,54937,54969,54969,54969,52823,52856,42226,23209,12775,8549,25418,16967,19080,33773,42192,42192,33805,19015,27467,37966,48432,46385,52758,50579,46383,40077,31594,48497,50545,46351,40046,19014,27402,14758,8517,8549,12742,12773,8549,4291,16870,31530,48532,48532,33709,31661,42127,42061,14790,10630,10662,6469,4323,2275,6468,6436,4323,4291,14856,25388,38099,31792,33938,23276,21162,25421,29648,27599,29648,25487,19148,16904,14757,12645,10597,4324,4292,4323,4291,10565,12808,10727,8615,8582,6404,8517,10630,4389,2243,4291,4291,4356,12743,17001,19081,16871,10564,12741,10660,8547,6467,8548,8548,4355,4355,4355,4323,6435,6435,16967,19081,10630,8550,8582,8582,55},
{52890,52889,52889,50809,50777,50777,48697,50809,50777,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50809,50777,50809,48729,50777,50809,50809,50841,50841,50809,50841,50809,50809,52890,52857,52857,50809,50777,50809,52857,50809,52889,52857,52857,52857,50809,50776,50809,50777,50777,50809,50809,50809,50809,52857,50809,50777,50809,50809,50809,50777,50777,50776,48696,44503,38262,36150,25487,21260,21261,12809,12809,16970,17002,19050,16970,14921,10696,14857,16969,19049,19082,21130,21162,23243,16969,14857,14856,14889,14824,14857,14889,12776,14857,12776,12776,14857,12776,12776,14857,12776,12776,12776,12744,12776,12744,12744,12776,12744,10663,12776,10695,14856,48597,59196,50710,44338,52823,54970,54970,54970,54937,50711,54937,52824,52824,54969,54937,52889,52889,54937,57083,42226,25322,10662,12743,35951,14886,12806,23241,16934,16967,21160,19047,25321,40046,44271,46418,50612,48497,44270,29513,31594,50577,48464,48432,46353,33739,29417,12678,10630,10630,10630,8581,4324,2211,16838,29385,37967,42226,33773,31628,35756,37868,23242,14823,8581,6436,2243,2243,8548,6468,4356,4356,14856,19050,38131,40212,33938,25388,16937,23308,29680,29680,29680,25422,10663,12645,14758,12645,12678,8452,6404,6404,6372,10565,12775,12743,10662,10630,10598,10597,10695,8582,4323,2210,2210,6404,16969,16969,19017,21097,23177,14822,10660,12772,10660,10628,10660,6435,4355,6467,12740,8515,4322,6468,14888,8550,8550,8550,8582,53},
{52890,52857,52857,50809,50777,48729,50777,50777,50777,48729,48729,48729,48729,50777,50809,48729,48729,48729,50777,48729,48729,48729,48729,50777,50809,50809,50809,50809,50809,50841,50809,50809,50809,52857,50809,52857,52857,50809,50809,52857,52857,52889,52889,52857,52857,52857,50809,50777,50776,50809,50777,50777,50777,50809,50809,50777,50809,50777,50777,50777,50777,50809,48696,42422,38229,36117,19115,14857,16970,12809,12809,16969,17002,19050,16969,14889,10728,16969,16969,19050,21130,23243,21130,25323,16969,12776,14856,14889,12776,14856,14889,12776,14857,14857,14857,14856,12776,12776,14856,12776,12776,14856,12743,12776,12776,10696,12744,10695,10696,12776,10696,16904,48598,57082,44339,42226,52856,54969,52889,54969,52856,50743,54969,54969,54969,54937,54937,52889,52888,52856,54970,40113,27467,12775,12775,25386,16999,14886,23240,16967,12806,19080,21160,25321,37998,42158,46450,48531,44304,44270,31594,33707,48465,46351,48465,50611,48464,35755,27305,14791,10630,8550,6437,4356,4291,21031,40015,31564,33709,31693,35854,48432,31530,14791,19017,14855,4356,4324,4323,12805,8580,8548,8550,17001,16969,36018,40277,38131,35953,38099,38099,38099,38099,38099,38132,38067,27437,16936,10565,12742,10597,10565,10565,10565,10565,12743,10630,10597,10597,10565,10565,8550,4323,2210,2210,2210,4323,12743,14856,16936,21129,25322,16902,10692,10692,10692,12772,12740,8547,10628,8547,10628,6435,6435,8549,10695,8550,8550,6502,8550,50},
{52890,52857,52857,50809,50777,48697,48697,50777,50777,48729,48729,48729,50809,48729,50809,48729,48729,48696,48729,48729,50777,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,52857,52889,52857,52857,52889,50809,50809,52857,52857,52857,52889,52857,50777,52857,52889,52857,50809,50809,50809,50777,50776,50777,50809,50809,50809,50777,50777,50777,50777,50809,48696,42423,38230,36117,21196,14857,17002,14889,12809,17002,17002,17002,16970,14889,12776,19082,19049,19050,21162,19049,19049,23243,19050,14857,14856,14889,14856,14857,14889,14856,14889,14857,14824,14857,12776,14824,14856,12776,12776,14856,12744,12776,12776,10696,12776,10663,10663,12744,12743,16936,50711,57050,44338,40178,54937,55002,54969,54970,52856,50776,54970,54969,54969,54970,54969,54937,52889,52856,54969,44338,23241,8582,10695,8517,8549,16967,29579,16999,16968,14855,10661,25321,35918,40079,44305,48564,42160,44302,29514,35852,54804,50578,48498,50610,48432,33675,29450,21130,16969,16968,10662,6404,4323,27435,44273,35821,29547,33741,29482,42127,27403,16871,31628,27467,8549,6469,8549,12837,10692,8548,12743,17002,12743,29615,42325,48663,50809,52857,50809,50809,50809,50809,50809,50777,48663,23308,10597,12710,8549,8517,8517,8517,10565,12743,8549,8485,6404,6404,6436,10598,4291,2243,2211,2211,8517,6437,6404,6436,16903,16870,10596,10660,12805,10692,10627,10660,8547,8580,6435,4354,6435,6435,8582,8582,8550,8550,6469,6469,39},
{52890,52857,52889,50809,50777,48696,48697,48729,50777,48729,50777,48729,48729,48697,48729,48729,48729,48729,48729,50777,50809,48729,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,52857,52857,50809,52857,52857,50777,52857,52857,50809,52857,52857,52825,50809,52857,52857,52857,50777,50777,50809,50809,50777,50777,50809,50809,50776,50776,50777,50777,50777,48696,42390,38230,38197,21163,14857,16970,14889,14921,17002,19050,19082,17002,14889,10696,16937,19050,21162,21162,19049,21130,25323,19050,14889,14857,14889,14856,14857,14889,12776,14889,14857,12776,14856,12776,12776,14857,12743,12776,14856,12776,12776,12744,10663,12744,10663,10663,12776,10663,16936,46517,54937,40178,42259,57050,57050,57050,55002,54969,54969,54970,54970,55002,55002,54970,55002,54969,57050,50710,25354,14854,6469,6437,14823,21129,19015,25354,23274,31693,25419,23274,29547,46451,48532,46385,48564,35854,40045,21094,40014,50578,50545,48497,50577,44271,27370,25290,12743,8549,16999,10693,4324,4291,37968,50612,46386,42193,31661,44207,46254,27402,37967,46418,31629,10663,10695,10694,14886,12805,6468,19081,17034,6437,21195,40245,50777,46583,42325,50777,48663,42357,50776,50776,50809,42325,23275,12678,10598,4356,4324,2276,6502,10631,12711,6437,6404,4324,2178,6372,8549,4291,2243,2211,4291,10630,6405,12678,23209,21095,8547,6435,8548,12773,12773,8515,6467,6435,4323,2242,6435,10628,8517,6502,6502,6502,8550,6501,10663,42},
{52890,52857,52857,50809,50777,48696,48697,50777,50777,48729,50777,50809,48729,48729,48729,48729,48729,50777,50777,48729,50809,50777,50809,50777,50809,50809,50809,50809,50809,50841,52890,50809,50809,50777,52857,50777,50809,50809,50809,52857,52857,52889,52857,50777,52857,50776,50809,52857,50809,50809,50777,50777,50809,50777,50777,50777,50776,50776,50776,50777,50776,50776,48696,42423,38230,38197,21196,14857,16970,14889,14889,17002,16970,19082,19050,14889,10696,14857,16969,16969,14856,16969,16969,16937,19050,14889,14889,16970,14856,16937,14889,12776,14856,14824,21163,21195,17001,19114,23275,21195,21162,25421,23276,25388,25421,21195,23276,27533,25421,17002,14921,17001,29549,29614,35985,35986,35952,31727,33807,38033,44339,42258,42259,40145,40146,44339,40113,33839,33840,35920,29612,12709,12774,10662,6468,25387,29483,25290,23273,21128,21160,19081,19048,37966,46418,54904,48499,44338,31628,31658,19014,42158,50545,50545,48529,35852,27401,25322,25290,16904,12775,16967,10693,4324,8452,48532,48564,50645,44338,33741,35854,37934,23178,18984,33774,16936,8550,8550,6437,8549,8580,6468,23340,14889,8518,21195,42325,50777,48631,44405,50776,48631,44405,50744,48696,48696,33905,23275,12645,10630,4356,4324,4291,6437,8518,12711,6404,2211,2211,2211,4291,8517,4324,4291,2243,2211,6436,27435,33610,31530,21160,10660,8516,6435,6435,8548,4355,6435,6435,2243,2178,8515,25386,27468,21162,16968,12775,10630,12775,12776,56},
{54970,52889,52857,50809,50777,48696,48696,50777,50809,50777,50777,50777,48729,48729,48729,50809,48729,48729,50777,50777,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,52890,50809,50809,50809,50809,50777,50809,50809,52857,52857,50777,52889,52857,50809,50809,50809,50809,52857,50809,50809,52857,50777,50777,50777,50777,50809,50809,50777,50777,50809,50777,50809,46616,42390,38262,38197,21228,16937,17002,14922,17002,19083,17002,17002,19082,16970,10696,16969,16937,16937,16969,19050,16969,16969,19049,16969,16969,19050,16969,16969,16937,23243,25356,23243,25388,25421,19114,21162,23275,23308,23308,29614,23308,29615,29646,27501,25389,25485,21259,14953,17034,17002,25388,27501,35985,33872,25420,14889,16969,31661,35920,33807,33806,27468,27500,35887,25356,10663,8583,12775,19080,10662,10694,17000,8614,23274,25289,31596,19016,19080,17000,8582,14855,44305,46352,46386,44273,46418,37967,33772,18982,44239,48465,50545,35885,12708,21129,25323,25322,21129,19082,16968,8549,4323,16870,54903,48564,33709,33741,37967,35854,33741,25291,16937,23275,14856,8583,6469,6437,4324,4356,8549,23276,17002,8517,23340,44438,48696,44405,48663,50776,44437,48631,48696,50776,46551,23308,25421,14726,12678,10630,8485,8485,8517,8484,12711,8517,6404,6372,6371,6404,8517,6436,4323,4291,2211,4291,23209,31497,18950,16936,10629,6435,4387,4323,6435,4355,8548,6403,4291,2210,12709,33806,33806,33774,35919,31693,23274,16936,10630,53},
{52890,52857,52857,50809,50777,48696,48696,50777,50809,50777,50777,48729,48729,48729,48729,48729,48729,50777,50777,50777,50809,50809,50809,50809,50809,50809,50809,52890,50809,52890,52890,50809,52857,52889,50809,50809,50809,50809,52857,52857,50809,50809,50809,50809,50809,50809,50809,52857,50809,50809,50777,50777,50777,50809,50777,50809,50777,50777,50776,50777,50776,50777,46616,42390,40310,38132,21163,14889,17002,14889,14921,17002,16969,19083,17002,14889,10696,16969,19017,16969,16969,19017,19017,19017,19049,19017,19049,19049,16937,16969,16936,35887,40146,33807,31694,21227,14921,19082,19114,23308,27501,33840,27501,27501,31727,29614,25389,23308,21227,14953,19147,17002,25389,27501,33872,31824,27501,17001,25388,35953,33807,33807,35887,29549,27501,35887,29614,12841,8583,14856,21192,14919,14855,12807,8549,27500,27402,35822,16872,12743,14856,8550,12743,37999,46385,48467,44273,48563,46450,33771,21095,48465,48464,48465,31659,19079,25322,25322,25290,21161,14888,10727,6437,4324,29547,54969,46418,33741,33741,40080,37934,31628,33742,21227,14921,17034,10663,4357,4357,10662,6468,14888,19115,16970,12743,27566,48663,48631,40147,48663,48696,40244,46583,50744,50776,38099,21162,25421,14758,12678,12678,10533,10533,10598,8484,8485,10565,10565,10565,10565,10565,6436,6436,4291,4291,2211,2178,4323,12709,10596,6435,6435,6435,8548,4355,4355,4354,6467,4291,2210,2210,4291,25354,33838,33741,31693,23241,21129,12775,6470,47},
{52890,52889,52857,52857,50777,48697,48696,50777,50809,50809,50809,50777,50809,50809,50809,48729,48729,48729,50777,50777,50809,50777,50777,50809,50809,50841,50809,50809,52890,50809,52890,50841,50809,52857,52857,52857,52889,50809,50809,50809,50809,50809,50777,50777,50809,52889,50809,50777,52857,50777,50777,50809,50777,50777,50777,50776,50777,50777,50777,50777,50776,50777,48696,40342,38230,40245,21228,14857,17002,14857,14921,17002,17002,19083,17002,14889,12776,16969,19050,19017,19017,19049,19017,16969,19049,16969,19049,19017,16937,19049,19016,38032,50711,48630,42324,17034,12840,19114,19049,23308,27501,33873,27534,27533,29646,29647,21196,27534,25421,17001,19114,17034,25388,25388,29647,31760,27468,29581,31662,29581,27469,35855,35887,31661,25356,33807,29582,12809,8615,14920,21192,16999,16967,19079,14821,42225,33677,40113,16904,10631,8550,6469,10630,35886,46385,37902,35821,50612,40080,25320,25288,48497,50545,46384,42192,31660,23242,23210,23210,23274,21130,17000,8581,6436,42225,52791,42192,37934,35822,42160,35822,31596,44339,23307,10728,12808,12776,19115,17034,12807,6436,23307,21162,12776,14921,31792,50777,46518,40211,50777,46550,40244,50744,50776,50777,31728,21195,33872,16872,12678,10630,8517,6437,6404,4324,2211,10630,10663,6404,6371,4323,4323,4356,4291,2243,2211,4323,8516,10660,8580,8547,8580,8547,6435,6435,6467,8580,6435,4291,4291,4291,2211,10597,31693,33806,23209,19049,19049,10630,8582,62},
{52890,52889,50809,50809,50777,48697,48729,50777,52857,52857,50809,50777,48729,50777,50777,50809,48729,50777,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,52890,52857,52857,52857,52857,52857,50809,50809,52857,50809,50777,52889,52857,52857,52857,52857,50809,50777,50809,50809,52857,50777,50776,50777,50777,50776,50777,50777,50809,50776,50777,50777,46616,40342,40310,38165,21196,14857,16970,12809,14889,17002,17002,19050,19050,14889,14857,19050,19082,19082,19050,19050,19050,19050,19050,19049,19050,19050,19017,19050,19017,40178,52889,52889,48631,23340,17034,23275,21194,25421,29679,33872,31759,31727,29614,29647,27534,31727,27501,17001,19147,17034,27533,29614,33873,31792,31726,29581,31727,27501,29582,35887,35920,31694,29549,35887,31694,12841,10696,14888,21127,16966,14886,19079,21127,48532,31597,42259,19049,21130,14824,12743,14824,33774,44272,42161,42161,42225,16967,19047,29514,48497,48497,48464,46385,33708,23241,21097,25323,23242,23275,19048,8612,10660,44306,37935,42225,33676,40080,42193,29483,29548,48565,23308,12808,12840,14888,21228,21227,14887,8549,21195,19050,10663,21196,40179,50776,40211,42324,50776,42324,44437,50776,50776,50777,31695,25388,42292,18985,12646,8517,6437,4324,4356,4292,4292,12808,14986,2243,2211,4324,4356,6436,4355,4323,2210,6403,6435,10660,12772,10660,10692,10660,6467,10660,8579,8516,8517,8550,12743,12775,12743,8549,16936,33806,33741,23242,14823,8550,10695,68},
{52857,52857,50809,50809,50809,50777,50777,50809,52857,52889,52857,50777,48729,50777,50809,50777,48729,50777,50809,50777,50777,50777,50809,50809,50809,50809,50809,50809,50841,50841,50809,52857,52857,52890,50809,52857,50777,52857,52889,50809,50777,52857,52889,52889,52857,52857,52857,52857,50809,50809,50809,50809,50809,50777,50777,50809,50809,50777,50776,50776,50776,50777,46616,40342,40343,33939,17002,16970,16970,12776,14889,19082,16970,19050,23243,21130,31760,25454,25454,23341,25486,25454,25453,25454,23340,27566,29614,33808,33840,35920,33807,38033,40178,38066,35953,31727,27533,33807,31726,29647,31727,35953,35953,35920,31727,29646,33808,33872,33807,29614,29646,27501,29582,25421,25422,23373,25421,21195,21228,21260,23276,25388,25388,21227,23308,25388,23308,12841,10663,23208,25352,19078,16966,16966,23240,52758,31596,42194,16936,12743,10630,14888,14888,33774,40046,46387,48532,27466,10693,12774,31659,50578,50545,48464,50578,35821,23210,21097,27403,23210,21162,14855,10693,10660,35886,35821,46418,42160,52726,42226,31596,33773,44372,21163,12808,14921,12776,17002,16968,8581,14887,25388,14857,4357,25421,44438,48696,50744,48663,48695,50744,48695,50777,50776,42292,33840,27501,40212,18984,12645,8517,4292,4324,4356,4324,6404,8647,17035,4292,2211,2211,4291,6404,8549,4356,4291,4355,6468,12741,12740,12772,10627,8547,8612,8579,8548,8581,8582,8550,12775,16969,14888,14856,12743,19049,35887,21161,10630,10662,10663,65},
{52857,52857,52890,52857,50809,50809,50777,50809,50777,52857,52889,50809,50809,50809,50777,50809,50777,50809,50809,50809,50809,50777,50777,50809,50809,50841,50809,50809,50809,50841,50841,50841,52890,50842,52857,50809,52857,52890,52857,52857,52857,50777,52857,52889,52857,50809,50809,52857,50777,50809,50809,52857,50809,50777,50777,50809,52857,50777,50776,50776,50777,50809,48664,40310,42390,35953,19018,16970,17002,14889,19017,21130,16937,23210,35855,23210,35985,25454,23406,21260,25487,21293,23341,23373,23341,25454,31759,33839,42291,44372,46485,46550,42324,44372,33807,31727,31662,37968,33807,25421,29614,35887,33774,37968,35887,33807,35952,42259,38033,38033,40146,33807,25420,19115,19148,14922,14922,12874,14922,12874,14954,12841,10728,8616,14922,12809,12841,12808,10662,33739,27400,19111,23272,16998,27433,54903,31596,38001,12743,8550,10663,6469,8549,25355,27435,18984,14822,14853,12806,10661,33739,46319,48432,48464,50545,37901,29483,23242,27403,21129,21161,14887,10693,8548,33806,44305,50645,50645,52823,44306,31595,42193,44340,12744,4356,6437,6437,6405,10694,12774,19146,25421,16969,4389,25421,48663,44438,35985,48631,44437,38034,48663,40212,29712,36051,33873,29614,33873,18952,12646,12678,8485,10565,10598,8517,6404,12743,14888,8452,6339,6372,4291,6404,6469,6436,4323,4291,8548,12773,6435,10660,12772,12772,10692,8580,6501,8550,8550,8550,12775,16969,16969,14856,14824,12710,23274,27435,19049,10662,8550,50},
{52857,52857,52889,52857,52857,50777,50809,52857,52857,52857,52889,50809,50809,50809,48729,50809,48729,50777,50777,50809,50777,50809,50809,50809,50777,50809,50809,52889,50809,50841,50809,52890,50842,50809,52857,50809,52857,52857,52857,52889,52889,52857,50809,52857,52857,50809,50809,52857,50809,50809,50777,50777,50809,48696,48664,48664,48663,48663,48696,48696,48664,50744,46584,40310,42358,35921,16970,16969,17002,14889,14824,19082,16937,27469,40080,29549,31695,23341,19180,19180,19180,19180,19180,19180,19147,19115,29647,25420,40178,44404,44436,46517,44404,42259,31694,29581,29581,35887,29549,23275,31662,35855,33742,35887,35854,33806,35887,40113,35888,35920,33839,25420,23275,23373,19147,17035,14922,14954,12841,14922,14922,17002,12809,14922,12809,14922,10728,12808,8550,23240,29513,21127,19079,16966,29547,52823,25323,21130,10631,8582,12807,10694,8549,16903,16967,6468,6469,12742,19079,16934,40013,50480,50512,48464,48465,40046,37967,27435,25322,21161,19049,10629,10662,10629,31596,44241,48565,42193,42161,44339,33676,48500,38001,14825,4357,6470,6437,4291,6468,12806,25420,21227,8582,4389,27599,48663,44437,44437,48631,46550,44437,50744,19017,8551,38164,27501,29614,38099,21098,12645,14758,12613,10533,12613,10565,10565,12678,10565,12645,12645,10597,8517,10565,6404,6404,4291,2211,8516,14853,10628,10660,10692,10660,8515,14854,16968,12775,10598,8549,10630,14824,12776,19049,21096,25290,31693,37966,25387,8582,8550,34},
{52889,52889,52857,52889,52857,50777,50809,52857,52857,52857,52857,50809,50777,50777,50777,48729,50777,50777,50809,50809,50777,50809,50809,50809,50809,50809,50809,52889,52890,52890,50809,50809,50809,52889,52857,50809,52857,52890,50809,52857,52857,52857,52857,50809,50809,50809,52857,50777,50809,50777,50809,50776,52857,33841,23309,23341,23341,25421,25422,25389,25389,25422,23341,21261,23341,33840,21163,16937,16970,14889,14857,19050,16970,25356,33775,21130,16937,19180,19180,19148,19180,19148,19180,19180,19179,19115,25453,27533,40178,46485,46517,46517,42291,42291,31727,29582,31630,35887,31662,25324,29582,33807,33742,33774,35854,33774,35887,42226,35887,33807,29581,21162,23340,25421,10696,12808,12841,14921,14889,14921,12743,14889,21163,21227,14889,16969,12776,19082,8582,16935,31561,25288,19047,14886,35918,54871,21097,8550,10663,14823,19016,16903,14790,16903,16998,14886,12742,12774,16999,21127,44239,50512,50512,48464,48432,37901,23176,25322,25290,23210,21162,14856,8549,19048,42128,46419,48597,46386,37903,42258,31628,48532,46452,27404,18984,19017,18984,16904,14855,8517,8582,8550,4357,4324,29712,46551,33840,40179,46550,38066,40211,44437,25388,21195,38131,31727,35985,35985,23275,12645,14791,12613,10565,10565,10532,10565,14759,10597,10565,10565,10565,10565,8549,6404,6404,2243,2211,4323,10661,14853,14885,14884,12804,16933,35886,40112,38031,35886,29548,14791,10630,10662,19081,31628,33774,33806,31693,19049,6469,6469,36},
{52889,52889,52889,52889,52889,50777,50777,50777,52857,52889,52857,50809,50777,50809,50777,48729,48729,50777,50777,50809,50809,50809,50809,50809,50809,50809,50841,52890,52890,50841,52857,52889,52857,52857,52857,52889,52857,52857,50809,52857,52857,52857,50777,50777,50777,50777,50777,50777,50776,50809,50809,50777,52857,29680,17035,19116,19148,19148,19148,21196,21196,19116,19116,19148,19116,31694,25356,16937,16970,16969,14889,19050,16970,23244,29582,27501,27534,23309,21261,19180,19212,19180,19148,19180,19180,21260,27533,23307,40178,46485,44372,44404,40178,31726,29549,33743,31630,38000,33807,25323,25388,35952,33807,35887,35854,35887,37968,42193,35855,33807,31726,23307,25420,29647,29647,21227,29647,19082,16969,16969,14824,16969,21195,25388,21195,25421,14888,19082,10663,19048,37899,31594,19047,16935,35821,46418,21130,8550,10630,21162,29419,21032,18952,21096,21191,16998,14885,16998,14886,16934,46384,48433,44206,48465,44207,40014,25290,25322,25290,23242,19049,16969,10663,16968,42127,50645,40178,37934,40080,40080,35853,48532,42259,52791,52823,54904,52823,54871,42194,6404,4324,4356,4324,6437,27599,33905,33905,33905,31825,33873,33905,33905,33906,33873,36018,36018,33872,35985,21130,12645,14791,12613,12613,10565,8452,10565,14791,10565,10565,10565,10565,8485,8549,6404,6404,4323,2243,4291,6468,10661,14853,19078,14820,21159,38031,40112,40112,37999,31660,21129,14823,14888,16936,14823,12711,12711,14823,8582,8550,8550,40},
{54970,52889,52889,52889,52889,50809,50809,52857,52889,52889,52857,50809,50777,50777,50809,50777,48729,50777,50777,50809,50809,50809,50809,50809,50809,50809,52890,50809,50841,52857,52857,52857,50777,52857,52889,52857,52857,52857,50809,50809,52857,52857,52857,52857,50809,50777,52857,50809,50809,50809,50809,50777,52890,29681,19116,19148,21228,21228,19148,21228,19148,19148,21196,21196,21196,29614,25323,16937,19050,14889,14889,19050,16969,21131,27534,23275,21195,21228,19180,19180,19212,19180,19148,19147,19147,19147,25453,25452,38033,40178,38033,42226,33839,35952,31695,29550,29549,35887,33774,23243,27469,35920,31694,33807,35855,37967,38000,42258,35887,33872,29678,21227,29614,38098,40179,38066,38131,35953,35985,33872,35953,33840,33840,35921,35953,35985,25388,23275,17001,14856,23273,27433,21159,21128,35756,44240,23242,8582,8550,25387,37902,23079,21032,18951,23240,19143,16998,14885,14853,21127,46353,50516,46321,50644,50611,40014,25322,25323,25290,23242,21163,17002,12808,8517,35886,46452,19017,29515,52758,37934,44274,42193,44339,54969,54937,54936,54969,48597,35952,6437,4292,4324,4324,4324,6469,6469,8518,8518,6437,8517,6469,8517,8550,10663,33938,33938,25388,23308,14791,12645,14823,12710,10533,10532,10565,10597,14856,14856,12645,10565,6339,6436,10629,6436,4323,2211,2243,2243,4323,6403,6403,14821,14820,23273,38064,40112,31693,25322,25322,23210,14856,16969,16969,14888,14856,14856,12775,8550,8550,8550,40},
{54970,52921,52889,54970,52889,52857,50809,52857,52857,52857,52889,50809,50809,48729,50809,50777,50809,50777,50777,50777,50809,50841,50809,50809,50809,50809,50809,50809,50809,52889,52857,52857,52889,54937,52857,52857,52857,52857,52857,52857,52857,52857,52889,52857,50777,50809,52857,52857,52857,50809,50809,50776,48696,29680,23342,25422,25422,25422,23374,25454,25454,23373,23373,23341,23374,23309,19050,16937,19050,16969,16937,21130,19050,21131,27502,25388,23276,19148,19180,19180,19180,19147,17099,17067,19147,19147,27566,25453,38066,44371,42258,44371,35920,33807,29614,27405,29582,31661,31694,23243,27501,29614,29614,29581,33774,35887,35887,42193,38000,35953,31727,23307,31759,38098,40211,40211,38130,38098,38130,38098,38098,38098,38098,38066,38065,38065,38066,21195,10663,16969,21194,19112,21191,25353,40015,42096,23243,10695,8582,12774,31563,25225,27338,25258,16904,16934,21191,25385,21192,29513,54838,54807,46353,37934,48465,40046,25290,25290,27403,25290,16936,10598,8550,10597,33774,40113,10532,33742,57082,42096,44274,46419,48597,54937,50710,52823,52823,25387,31825,6470,4324,4356,4324,4324,4324,4292,4324,4292,4292,4324,4292,4292,2243,6404,33905,36018,31727,27469,16872,12613,12743,10630,10597,10598,10630,10565,12710,10597,8485,8484,6404,8485,10629,6468,6404,2243,2211,4291,6436,4323,4291,6404,12741,16934,31692,40144,31660,25322,27402,25322,12711,10630,14889,14824,10662,10695,10663,8550,8582,6469,42},
{52889,52889,52889,52889,52889,50809,50777,52857,52857,52857,52857,50809,50809,50777,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,52890,50809,50809,50841,50809,52857,54937,54937,52889,52857,52857,52857,50777,52857,52857,52857,52889,52857,52857,50809,50809,50809,50809,50809,50776,50809,33906,23374,25454,25487,25487,25487,25487,25519,27567,25486,25486,25486,25454,25422,17002,16969,19050,14856,14856,21163,21098,21163,27502,21130,14889,19148,21260,19180,19147,19180,21260,17067,19147,19115,27533,27533,35920,40112,38000,35887,33774,29581,29581,25356,23275,31694,33775,25356,25388,29614,27501,27468,33807,35920,33807,42258,38000,35952,33872,23307,29647,38130,36018,36018,36017,38098,38098,38098,40178,38098,38098,38098,38065,38065,38066,25421,12775,16968,23242,16999,19046,33805,44273,31565,14888,10630,8582,8581,27402,23112,23080,18952,16872,14823,21193,42324,44404,42192,54838,52724,46352,37934,48465,37933,25290,25355,25355,23209,18984,12710,8549,8549,14823,12710,6404,29549,54969,42160,50580,42226,50711,54969,54969,57049,35855,19016,33906,8550,4324,4324,4324,4324,4324,4324,4356,4324,4292,4324,4324,4292,4291,6404,31760,35986,33873,35985,23275,12645,14856,17001,12840,12776,12776,10630,12711,8517,6404,6404,4323,6404,10630,6468,6468,6436,6404,4323,6436,6436,6436,6436,8548,8515,12709,31725,33773,27370,27402,25290,14791,12775,16937,14856,12743,8549,12743,23242,12775,6469,40},
{54970,52890,52890,52889,52857,52857,50809,52857,52857,52857,52857,50809,50809,50777,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,50809,50809,50809,50841,52857,52857,52889,54970,52889,52857,52857,52857,52889,52857,50777,50809,52857,50809,52857,52857,50809,50777,50809,50777,50809,31826,23374,25454,25454,25487,25487,25487,25487,27567,25454,25454,25487,25454,25422,17002,16905,16937,14889,14856,21130,19050,23244,29582,21098,19083,21228,38098,27566,23373,21228,21228,19180,19147,19147,25452,29614,37967,40015,40047,37935,33742,31661,33775,27501,27436,31662,31694,25388,25388,29582,25388,25388,33775,35920,33839,44306,35920,33839,33839,23307,27501,40178,19114,17066,25518,35985,40178,38098,38098,38098,38098,38098,38066,38066,38066,33808,23275,21162,25322,19047,16966,40176,44274,33710,12776,8550,8550,14823,31596,25159,25192,21064,18984,12710,21128,42292,54937,54871,48465,48432,48464,48433,42126,25288,25322,27371,25322,23242,23210,21161,10661,4356,4324,4323,4324,27468,54969,54871,48532,40080,54969,57018,57049,52791,16903,16937,33906,8550,4324,4324,4324,4324,4292,4324,4292,2244,4292,4292,4292,4292,4324,4291,29680,33939,35986,25420,23243,12613,14790,12645,10564,12645,12677,12613,10598,10533,10565,10565,10565,10533,8549,8548,6468,6436,6404,4355,6468,8548,6436,6404,6403,4323,8549,12710,27435,27402,27402,25322,16936,19049,19017,16936,10630,8549,8550,10630,6469,6469,40},
{52890,52889,52857,52889,52857,50809,50809,50809,52889,52857,52857,50809,50809,50777,50809,50777,50809,50809,50809,50809,50841,50809,50841,50809,50809,50809,50841,50841,50809,50809,52890,52889,52889,52857,52857,52857,52857,50777,52857,52857,52857,52857,52857,50777,50777,52889,50777,50809,50809,50777,50809,50809,31761,23342,25422,25454,25454,25487,25487,25487,25487,25422,25454,25487,25454,25422,17002,16937,19050,16969,19017,21130,19049,21163,31662,29517,27469,23308,38097,27566,27566,23340,21228,21260,23340,25421,29646,27501,40080,40014,37934,37934,33741,31661,38000,33743,27436,33775,31694,25323,23275,27501,25388,27469,33775,33807,33839,44339,33806,31726,33807,23307,25388,38098,19115,6534,12808,35985,38098,38130,38130,38066,38098,35953,35985,38098,38098,33808,21098,19048,35952,25418,19014,40177,44274,44274,23275,8517,8549,14791,27273,25160,27370,21097,16904,16871,21128,35952,27500,40046,42126,42126,50577,44239,33739,27434,25322,25290,25322,23242,23242,19048,8548,4356,4356,6404,6372,29516,57049,54904,48532,48532,57050,52823,54871,33775,8550,14888,31857,12776,10662,10663,10663,10662,10630,10630,10630,10663,10663,10630,10663,10663,10630,8550,27599,33939,29614,23307,31661,27272,29514,27304,25191,27240,27272,27239,29449,25224,27304,27272,27272,25191,27369,18950,12677,8516,4323,6404,6468,6436,6468,6436,8517,8517,8582,6469,16936,27467,27403,27403,16936,19017,21097,23242,21129,16936,14791,14823,14856,14824,39},
{52889,52857,50809,52889,52857,50809,50777,52857,52889,50841,50809,50809,50777,48729,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,50841,50841,52889,52857,52889,52857,52889,52889,52889,52857,52857,52857,50809,52857,50809,52857,52857,52857,50777,52857,50809,50777,50809,50777,29712,23342,25486,25486,25487,25486,25486,25487,25487,25454,25454,25454,25454,23341,16970,16937,19082,19082,19017,21130,21130,21163,29614,25387,27468,23340,36017,27566,25453,23373,23308,23341,23373,25421,31759,38065,40113,44241,37934,39982,35854,33774,33807,33807,31630,33774,31694,29549,23275,27501,25388,27500,31694,31726,33774,40145,35887,31726,33807,23308,25420,38098,19115,10696,23308,35953,38066,38066,40179,38098,38098,35985,33904,38065,38065,33807,19017,19048,38064,27499,16934,44371,46354,48532,29613,8582,8550,18984,27241,25192,29548,23307,18984,21064,23240,14854,8516,40046,44239,46287,46319,33675,33707,33773,27370,25290,25322,25290,23242,14886,12773,10661,6468,6469,8484,27467,54969,54872,46387,48565,55002,57050,44338,14758,8550,12808,27534,14856,16969,14888,14888,14921,14888,14888,14888,17001,16969,16969,16937,16969,16969,16936,27599,33906,23308,21194,35756,37738,35853,31660,29482,29450,20965,33545,35756,27337,25224,25192,25223,35658,33708,12612,10596,8548,6435,10629,10596,4291,6371,8516,8550,8550,8550,8550,16936,27435,27435,27435,19016,16936,27435,29515,31628,35854,33773,35854,31661,19049,40},
{52890,50809,50777,52890,52857,50777,50777,50809,52857,52890,50777,50809,50809,50809,50777,50777,50777,50809,50777,50809,50809,50809,50809,50809,50841,50841,50841,50809,50841,50809,52889,52857,52857,52857,52889,52889,52889,52857,52889,52889,50809,52857,50809,52857,52857,50809,52857,52857,50809,50809,50809,50777,29713,23342,25454,25454,25487,25486,25486,25487,25486,25454,25454,25454,29615,33643,23144,16937,19082,16937,16904,19050,19049,23243,29614,23307,25388,23309,21260,19147,23308,23340,23308,25421,23308,21259,25388,25387,27468,35887,33709,33741,33741,31662,29614,31727,31662,31662,31726,27468,25356,27501,27500,29646,31727,33807,33807,38065,31694,31726,33807,27501,31694,35985,25356,23275,25388,31727,35985,35952,38065,33872,38065,35984,35952,35952,35952,33839,21161,19048,38032,25386,16967,46484,50578,50480,29581,10630,21129,31596,25192,25160,29483,27435,21065,21064,27467,14854,12741,40079,50546,48464,48465,42126,48530,35886,25289,25322,25322,25322,27467,14853,10661,10661,8549,8517,8484,23241,57017,52823,40048,52824,57083,54937,37902,23177,12743,16904,25388,21195,16936,19082,25356,23243,19017,25356,23243,19049,25356,21162,21097,19049,21130,21129,31760,33939,29614,27501,35691,37770,33609,31431,31399,31463,31431,37770,37770,33511,31431,33512,31431,37803,31530,18949,23143,16869,10596,14789,8516,4291,8452,29613,29548,23242,16968,12742,16903,29515,27435,27435,14823,19049,25387,38032,40112,40144,44305,42192,23242,10598,43},
{50809,50777,50777,50777,50809,50777,50777,50809,52857,50809,50809,50809,50809,50777,50777,50777,50777,50809,50809,50809,50809,50809,50809,50809,52890,50809,50841,50841,50841,50841,52889,52857,52857,52857,52857,52857,52857,50809,52857,52857,52857,52857,50777,50777,50776,50776,50776,50744,48696,48663,48663,46518,27535,23342,25454,25454,25486,25486,27534,27534,25486,25486,27535,25454,35985,54737,48333,25226,21130,19049,19017,21130,21130,23243,29581,25451,31759,23341,19180,19115,23340,25388,25421,27534,25420,23340,23308,25388,23275,27435,27468,29581,29581,25388,25356,25355,25355,21162,23274,25420,25387,21129,25355,23242,25388,23210,29581,23210,25387,19049,27435,23274,27435,25355,25323,23242,23242,25323,23242,27435,25355,23242,23242,29548,27435,29548,27500,31726,25322,29515,40113,25419,19015,42291,52593,50479,31661,10598,33709,31563,33611,23047,23112,18951,10630,10597,21160,19046,19014,35853,50546,50544,52658,48432,50610,33740,25289,25322,25290,23209,23241,12773,10660,12773,8548,8516,6436,21129,54936,50677,46452,54969,54969,52758,33708,33708,29451,18887,38034,40212,25420,40211,50744,48598,42292,50744,48566,42292,52824,46485,44372,44372,46452,46452,44405,33938,33873,35822,33545,37836,35625,35591,35591,35592,35624,37868,35689,37672,37672,35624,35624,37868,23143,18949,21030,14789,10564,10564,6436,2210,16935,40112,40144,40112,35886,25322,16903,27467,27467,21097,10662,16969,19017,29548,40080,38031,31660,18983,8517,8550,36},
{50809,50777,48729,48729,48729,48697,48729,50777,50809,50809,50809,50777,50809,50777,50777,50777,50777,50809,50809,50809,50809,52890,50809,50809,52890,50809,50841,50841,50809,50841,52889,52889,52857,50809,52857,52857,52857,50809,52857,52857,50809,52857,50711,48631,48663,48631,44437,44405,44405,44405,48631,48631,33841,25390,25421,25421,27502,27502,25454,27534,27534,27502,29615,29615,31694,48365,37769,29418,27403,16969,16937,21130,19049,23211,40113,27531,33839,31792,23341,23308,16969,25420,29614,21195,27533,21194,27501,33774,31694,31661,31693,31693,31661,29581,29581,27501,27500,27468,29613,27500,29548,29548,33773,29548,35888,29581,40113,31629,33806,27467,33805,33773,33806,33806,35951,35887,35887,35888,35887,35919,35887,31661,33774,35920,35887,35919,35887,40145,33741,37967,42226,31726,25386,42258,50480,50480,38000,23275,37935,46320,42126,31563,31628,27435,21162,21129,29580,29579,29579,42127,48465,48464,50577,48432,52724,35885,25321,25322,25322,25322,19047,14853,10692,12773,8581,8516,8516,23176,57017,48500,48532,57050,57082,50677,42127,37934,33610,39884,38002,42325,33807,46518,50743,48663,50744,50744,50744,50776,50776,52857,52889,52824,50776,52889,44438,31858,29615,31563,35624,33642,29319,35592,35592,25093,35625,37868,31464,37704,37672,27238,35657,35755,18917,21030,23143,12676,12709,10628,6371,4291,27500,40112,35886,27402,25322,23241,19016,27467,27435,12710,10598,16936,16969,16936,29548,40144,35853,25322,21161,19016,64},
{50777,48729,48729,48697,48697,50777,50777,50777,50777,50777,50809,50777,50777,48729,50777,50809,50809,50809,50809,50809,50809,50841,50809,50809,52890,50809,50809,50809,50809,52890,52890,52857,52889,52889,52857,52857,52857,52857,52857,52857,52857,52857,50809,52889,52857,52889,52857,50809,50777,50777,50744,50744,52857,40146,38033,35953,38001,38001,35953,35920,38001,35920,38000,38033,38001,48368,44108,46189,46222,21065,19017,21130,19050,21098,44338,40080,44339,38098,29647,29647,27631,31792,31792,27567,31759,27566,29712,29647,29614,31694,33806,29613,31695,29614,31727,31727,29646,31759,29646,31726,33839,33807,35951,33806,38065,31726,38033,31727,38032,29580,37999,31758,35951,33774,38031,33838,38032,35952,35919,38032,35919,35920,35887,35952,35919,31726,31725,40178,31661,33773,40177,33839,23241,40079,50447,50480,37968,16936,23242,35788,39981,29417,27435,21161,19080,16968,14920,19081,31660,46352,48465,48465,46384,48432,54837,29546,23241,25322,25290,23241,19015,12773,14918,12805,12774,8516,10629,31660,57017,40015,50710,57115,57115,50612,42094,42127,42061,42028,40081,38131,33840,48663,50744,40146,48598,50744,44404,50743,44372,19049,25355,48597,44436,50711,35986,31858,35986,35690,35591,35592,35592,35559,35592,35624,35624,37704,37672,37672,37672,35591,37672,33544,25190,23110,14757,10596,12677,10629,6404,4291,21161,29580,29580,25322,25322,25290,16871,29516,23210,10630,16904,16969,16969,16936,14856,29613,38031,37999,37967,37966,131},
{50777,48729,50777,48697,48729,50777,48697,50777,50777,50777,50809,50809,50777,50777,50809,50809,50809,50809,50809,50809,50809,50841,52890,50841,52890,50809,50841,52890,52890,52890,52857,52889,52889,52857,50809,50809,52857,52857,52857,52857,52857,52889,50777,50809,50809,52857,52857,50809,50777,50777,50777,52857,54970,52823,50743,50743,50743,50743,50743,50743,50710,50678,50710,50743,52791,52724,42029,41996,41996,23144,25193,25225,23177,23177,37870,27305,27403,42292,38131,35986,33938,35986,31793,33905,31792,33872,31792,31792,33807,35952,38032,31759,29646,29646,29614,29646,27566,27534,27534,27534,29646,29614,31694,29646,31726,29647,29646,29614,38033,37967,31693,29678,29614,29646,29613,29613,29645,29613,29613,29613,31725,31661,25355,27468,27403,27435,25355,31629,27402,40112,44338,40145,29580,37933,48267,50479,37935,10598,12743,25355,25289,27403,14790,19048,16968,16936,10662,10630,27434,46384,48497,44206,42126,50578,48563,23207,25321,25322,25322,25289,21160,14853,12741,14886,8548,8549,14854,37901,50677,46419,54936,57050,52823,46352,33675,29482,35820,40078,29548,35952,40211,48695,48630,44405,50776,48663,50711,52889,31662,6339,25355,46485,40146,31727,21228,31891,35953,33544,35559,35559,37672,35592,37672,37672,37639,39752,37671,37704,37704,37671,37671,29318,29383,23143,12709,10628,10628,12677,8452,4258,4259,10630,21193,25354,25354,25322,19016,23242,10662,12775,19049,14856,16936,16937,14856,19016,37999,37999,37999,37999,149},
{50777,50809,50777,48697,48729,50777,50777,50777,50777,48729,48697,50809,50809,50777,48729,50809,50809,50809,50809,50841,50809,50841,50841,50841,52890,50809,50809,52890,50809,50809,52890,52890,50809,52857,52857,52889,52857,52857,52889,52889,52889,52889,52857,50809,50809,50777,50809,50777,50809,50809,50809,50809,52889,50743,50711,50711,50711,50711,50743,50743,50711,46451,46352,46352,48399,50512,44240,33512,44073,41928,41896,39783,39815,41896,41929,41929,37768,41995,44173,39980,42060,42060,40013,42061,37867,39914,39882,35721,41929,39882,35721,39916,42062,46352,42094,39948,39948,37835,39915,39947,37867,39948,37867,37868,39980,37868,37900,37867,37868,39948,37867,37933,37901,37868,37868,37900,37868,37932,35820,37900,40046,33610,27238,29351,29319,27271,29352,29384,35755,44239,42193,40210,35920,39947,50314,52592,37968,10598,19082,33710,27305,25257,18918,31628,31661,27500,27467,27435,40014,46384,48465,46319,44238,50610,44272,21126,25321,25322,25322,25290,23274,16998,14885,12741,10629,8549,16902,37965,44305,46452,57050,57082,57049,39982,31628,12677,27304,39915,33643,35953,44404,52824,50711,48566,50776,50744,50711,50776,46517,40114,33807,27501,25389,25421,25421,31891,31661,31367,31431,31399,33447,33479,35592,33511,35592,37672,35559,35559,35559,35559,35592,33479,27271,16870,10628,10628,12709,10628,6435,8516,8452,8485,19016,25354,25322,25322,23209,27435,19016,14823,16969,16969,16937,16969,16936,25387,40112,40079,40079,37999,149},
{50809,50777,50777,48697,48729,50777,48697,50777,50777,48729,48729,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,52890,52890,52890,52890,50809,50809,50809,52889,52889,52857,50809,50809,52857,52857,50809,52857,52857,52890,52889,52857,52857,50809,50809,52857,52857,50809,50809,50809,50809,52857,50711,50743,50710,50711,50711,48662,50710,50743,50743,48630,50645,50677,50611,50544,44239,46220,48300,42028,35656,41993,41928,46155,44075,46155,46187,44042,46154,44074,41961,48332,46220,46188,48333,46186,48300,50347,50311,50313,50380,50511,56984,59130,54837,46221,48301,44106,46220,46187,46251,46252,48300,46252,46220,46253,46188,48300,46187,50348,46187,48365,48300,48299,48267,48332,48268,46187,46219,46187,50479,50381,46121,48234,44073,44073,48267,46219,44107,44174,40080,40178,38000,46189,50314,52593,37967,10630,14823,42128,50546,48367,44206,44240,25321,16934,19015,27402,40014,46385,48465,44175,40013,50610,40079,23207,25289,25290,25290,25322,16903,14886,17030,14885,12774,10628,21095,40013,37966,46484,57115,57115,54904,35723,33643,35723,39882,31366,31595,40211,46517,50776,44340,50711,52824,48630,52824,52857,50711,23145,16839,12678,12710,12678,19049,33939,33643,33545,33611,33512,35592,29319,29319,37770,29384,31366,37704,31399,29286,39850,29384,33479,27271,10628,8516,8516,10596,10628,8547,21129,29548,35886,33741,27435,25354,25289,33773,44337,44305,40079,25354,16969,16969,16937,14856,33806,40144,37999,38031,38031,164},
{50809,50777,48729,48729,48729,48729,50777,50809,50777,48729,48729,50809,50777,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,52890,52890,52857,52889,52889,52857,50809,52857,50809,52857,50809,50809,52857,52857,52857,52857,50809,52857,50809,50809,50809,52857,50809,50809,52857,50809,52857,48598,50743,50710,50711,50711,50711,50711,50711,50710,48630,50710,50711,50644,48399,42028,44075,42061,35855,16872,40080,40046,46320,44207,42126,46352,42126,44239,46352,42126,46352,46320,42126,48465,46319,46320,48433,46286,46319,48433,50644,59196,59196,57050,31662,23242,23307,21162,25355,23210,25323,23242,27436,23242,27500,23242,27501,25323,29581,25355,27500,27435,27434,31661,29580,29548,25322,29548,25289,50612,44273,27401,31627,29514,31627,31660,35853,46353,46418,42225,40146,38033,33708,44109,39982,40080,21162,21162,33740,48433,48465,46320,40079,35854,29547,27467,33806,42225,46418,46418,44240,44174,52658,35820,19013,25322,25322,25290,25322,19016,16968,16966,14885,12805,12741,31627,39981,42224,52856,57115,52856,50611,46352,42159,39980,42028,44142,48500,46485,48663,52824,48566,50744,52856,50711,52824,52889,50743,20999,14758,10564,8452,8420,14824,35986,33545,37770,33544,35559,37704,35592,35560,39915,35624,37671,39752,37704,35624,39948,35624,37672,31464,10628,4323,6436,8548,8548,10628,12741,16967,21128,23176,27402,27402,33740,42159,42224,42192,37934,27435,14856,16937,16936,14823,23242,40112,40079,40111,40111,185},
{50809,50809,48697,50777,50777,50809,50809,50809,50777,50777,50777,48729,50809,50777,50777,50777,50809,50809,50809,50809,50809,50841,50841,50841,52890,50841,52890,52857,52857,52889,52857,52857,50809,50777,50809,52857,52889,52857,50809,52857,50809,50809,50777,52889,52889,50809,50777,50809,50777,50809,50809,50809,52857,50744,50710,50711,50711,50711,50743,50711,50710,48630,50710,48630,52692,50577,42061,44108,44109,33741,18985,40048,40015,42159,42126,40046,44272,42126,42159,46353,42127,42192,42127,37934,42192,40080,40047,44273,40079,42160,46321,50645,59196,59229,57051,19050,8615,12841,10696,14922,6502,8616,6503,8616,8583,10696,8583,8648,8583,8615,8615,8615,8616,8583,8616,6503,8648,8583,12809,12775,46485,35951,27499,29645,29646,29613,31726,31726,42225,52757,50676,42226,29581,16936,27370,27305,40112,16903,16871,42127,54772,50643,52790,40112,37967,27434,23241,25419,40144,48498,48497,48433,46287,52691,31627,21126,25288,25322,25322,25322,23177,21162,16999,16998,16934,16934,35820,39916,42160,54969,57082,57050,48499,37901,21096,31627,44272,52789,46516,46518,50776,50743,50744,52857,50776,52824,52889,52889,52824,21032,16870,17000,8517,6339,12678,35855,35592,37900,35755,35723,37771,37770,37705,37867,35624,35624,35592,37672,39817,39948,33576,25158,23111,8516,10596,6404,4291,4323,8548,6468,6403,2178,8484,23176,27402,29515,25257,31628,29579,27402,21129,14823,16936,16936,14888,14823,23242,40112,40079,42192,203},
{50809,50777,48697,50777,50777,50809,50809,50809,50777,50777,48729,50777,50809,50777,50809,50777,50809,50809,50809,50809,50809,52890,52890,52890,52890,50841,52890,52857,52857,50809,50809,50809,52857,50809,52857,52857,50809,52889,52857,52857,52857,50809,50809,50809,52857,52857,50809,50776,50777,52857,50777,50777,50777,50744,48662,48663,50711,50711,50711,48630,50710,50678,50710,50710,50611,50611,44175,44142,44174,35756,37869,35724,33643,35724,35723,35756,35756,35756,35756,37868,29515,14856,14856,14824,14792,14824,14824,16904,14856,16936,21065,48500,59229,54970,48565,29582,23276,23308,23340,27534,21196,23341,23308,23308,23308,25421,21227,23340,21228,21260,21228,19147,19115,19082,19115,19082,17034,17002,19115,23307,46485,31726,27500,31726,33839,31726,33872,31694,42192,52757,54935,57050,29580,16935,44174,46221,44305,25290,18952,33675,48433,44240,44273,35919,29548,14821,14854,21258,40080,48465,50512,52690,48432,52692,23144,19014,25289,25322,25322,25322,23209,14823,10630,12742,14854,23207,40046,39883,44209,57083,55002,57017,42095,35788,16838,29384,42061,44174,40112,48631,52856,46485,46517,52889,46485,48630,52889,54969,50711,20999,14757,14757,12645,10532,16839,35724,37737,35820,33773,33708,35821,35755,39850,27304,18917,20966,20965,27270,39915,35756,21063,14789,12709,6436,8484,4291,2243,4291,8548,8548,8516,4323,10597,35821,44240,40080,25289,23209,29516,25355,16936,14823,14823,14888,14856,10663,10630,25322,40112,46353,196},
{50809,50777,50777,50777,50777,50809,50809,50809,50777,48729,48697,50777,50809,50809,50777,50777,50809,50809,50809,50809,50809,50809,52890,50809,52890,52890,50841,52889,52857,52857,52857,52857,52857,52857,52857,50777,50777,52857,52857,52857,52857,52857,50809,50809,52857,50809,50809,50809,50777,50809,50809,50777,50776,50776,50776,50744,50776,50744,50776,50776,48630,46484,46484,46484,48464,48498,48532,46451,46451,48532,48531,48532,48564,48532,48532,48532,46451,46483,48531,48564,38000,10663,14857,14857,14857,14856,12776,14889,14824,14857,21065,48565,59261,52856,50678,40179,25388,33873,25388,29712,23308,31825,33873,31792,23340,33905,31727,27566,25421,31792,27599,29680,29679,31792,31825,27534,27566,19114,27599,19114,42291,31726,35952,33871,40177,35920,40211,35952,33741,54870,54904,54969,23209,16935,50512,50413,44272,37933,39981,37868,39916,37835,35756,37967,31628,14822,16967,23338,40080,46320,50544,50610,48399,48531,21063,19014,29547,27435,25322,25322,23209,19016,12743,14888,14855,25353,42158,35657,48434,59195,59195,54936,39982,37901,39948,41963,27174,31367,42160,48663,50744,44339,52824,52856,48630,52857,52889,54970,50678,21031,14725,14758,10564,10532,14726,23111,27369,25224,23078,25159,25191,27239,29449,25191,25191,27271,27271,27304,31498,27272,23143,10629,6403,6436,4323,4291,4291,6371,10660,8548,8582,10662,16968,25322,27434,29515,25322,25289,29580,21129,19049,16936,14856,14888,12775,14888,12711,12711,23242,19016,67},
{50777,50777,50777,50777,50809,52857,50809,50809,50777,50809,50777,50809,50809,50777,50809,50809,50809,50809,50841,50809,50809,50809,50809,50809,50809,50809,50841,52890,52857,52857,52890,52889,52857,52890,52857,52857,52857,52857,52857,52857,52857,50777,52857,52857,50809,50809,50809,50809,50777,50809,52857,50809,50776,50809,50809,50777,50809,50777,50809,50809,48598,44371,44338,44338,48399,48466,46452,46452,44371,46451,46451,46452,46452,46419,44403,44371,44371,44371,44371,46452,38033,14857,17002,19050,21131,21131,16937,21131,19082,19050,25323,42258,54904,50743,54937,38131,27566,31857,29647,31825,23308,31825,25421,27599,19115,31857,29679,29712,27566,29712,29679,29680,31792,27599,31857,27534,27567,19114,27567,21227,36050,31792,31759,29679,31727,31792,35953,38033,25257,48467,57049,54904,25289,16935,25289,29449,44273,37901,44207,46320,44174,44239,52724,44273,31661,19079,16967,23306,40047,48334,50512,50577,48464,50611,21127,21095,35886,35886,31628,25322,25322,21129,21194,14856,16935,19014,33707,37835,42093,46417,42225,44272,46385,40046,42093,42093,50611,48301,42160,50744,52824,48598,52824,52824,50711,52889,54970,54969,50678,25257,16838,23242,6339,6372,14823,12613,12710,8517,4323,6404,8484,8484,10597,2210,2178,6372,6372,8452,6339,4258,8451,10661,8548,8548,8549,4356,2211,4323,10629,10662,10630,12743,19016,25322,27402,27435,27402,25354,29580,19016,23274,16936,10663,10662,12743,12743,12743,12743,12743,8517,22},
{50809,50809,50777,48728,50809,52857,50809,50777,50777,50777,50777,48729,50777,50777,50777,50809,50809,50809,50809,50809,50841,50841,50809,50809,50809,52890,52890,52890,52857,50809,50809,52857,52857,52890,52890,52857,52857,50809,50777,52857,50809,52857,52857,52857,50777,50809,50809,50809,50809,50776,50777,52857,50777,50776,50777,50777,50776,50777,50809,50809,50776,50678,50678,50678,50579,50677,50710,50711,48630,48630,48597,48630,48630,48598,48597,48597,48597,48597,48597,48597,46452,23243,25324,25291,25324,27404,25323,27404,25323,25291,27436,27403,33709,38065,42292,36018,29679,33905,25453,31793,23341,31792,23341,27599,23341,31760,31760,31760,29712,27599,29712,25486,31792,27567,31792,27566,27566,23341,25421,23340,29679,29712,25453,27599,27566,29712,25452,35886,25257,44240,57017,59163,37967,19016,23275,19049,42226,16871,14758,16871,14791,18984,27435,31661,31694,33805,21128,31627,48433,50415,50544,50578,44207,35853,21095,25321,40047,37966,37966,35821,31628,33774,35854,31661,31661,33740,31627,40078,31529,29513,25319,31594,40046,16903,25257,44272,52691,48267,44273,52889,52889,54937,54970,52889,54970,54937,48630,48565,48532,23144,14790,19049,6404,8517,14822,10565,12742,10662,4324,6404,8549,8517,8549,4291,4291,8517,6372,8484,6372,4291,6404,10596,10661,6436,8516,4323,4291,6436,8582,10663,10630,10662,16968,27403,27435,27435,27402,25289,27467,16936,21162,10630,8582,8550,14824,16969,16937,14824,10598,10630,56},
{50809,50777,50809,50777,50809,52857,52857,50809,48729,48697,48729,50777,50777,50777,50809,50777,50809,50809,50841,50809,50809,50809,52890,50841,52890,52890,52890,50809,52857,52857,52857,50809,52889,52857,52889,52857,50809,52889,52857,52857,52857,52857,52857,52857,50777,50809,50809,52857,50809,50809,50777,52889,50809,50777,50777,50776,50776,50809,50809,50776,50744,50711,50678,48597,50578,50677,48630,48663,48630,48630,48598,48597,48598,48597,48597,48565,48597,48598,46517,46516,48565,48565,46484,48532,46484,46484,48533,46452,46452,46484,46484,46484,46452,35953,35986,33937,29679,33906,25453,31825,25454,31760,25453,25486,25486,25486,31792,27501,31792,29647,31792,29712,33938,31792,31825,29679,23341,21228,21228,25421,23373,27599,27599,31792,25453,29679,21227,35919,29514,46418,57082,59163,29580,21128,33774,18984,42194,16872,12743,12743,10663,10631,8517,27468,29581,27467,12709,35853,46385,48432,48464,46384,42159,31595,14757,27467,37999,37967,37966,37934,46418,54903,54936,52757,54936,57016,46418,21127,8484,10597,27401,33675,35788,25257,33610,35657,37672,46187,52725,42291,35952,38033,38065,38065,40179,46517,46517,46484,42225,21031,14725,21162,19016,16903,16903,12678,12710,23242,16904,10597,8517,8517,12710,10630,10597,8517,6372,6404,6404,4291,8484,6403,8580,6403,6403,6372,8517,10663,10663,10663,8582,10630,14791,23209,27435,27467,23209,19016,25322,12743,10663,8582,8582,8550,12743,19017,19017,16904,27435,23274,85},
{52857,50809,52857,50777,52857,52889,52857,48729,50777,48729,48729,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50841,52890,50841,52857,52857,52857,52857,50777,50809,52889,50809,52889,52889,52889,52857,52857,52889,52889,52857,50809,50809,50777,50809,50809,50809,50809,50809,50777,50809,50777,50777,50777,50776,50809,50809,50809,50776,50744,48662,48630,50645,48498,48598,48631,48630,48630,50678,48598,48597,48597,48597,48598,48597,48630,48565,46516,48565,48565,48597,46517,48597,48565,48565,48597,48565,48565,48565,48597,48597,48565,35985,36050,33937,31760,33938,27566,31825,27566,29647,25486,23373,25486,25486,31824,31760,33905,29647,31792,29679,31825,27566,29679,27566,27534,27567,21195,27566,23340,29712,25486,31792,27566,27631,29581,42225,33773,48532,54936,40079,16903,27467,35888,23242,46420,14792,10630,10663,10663,10663,10630,29613,33839,19081,10661,33740,48498,48497,48399,37802,50546,29547,8483,31692,37966,37966,37966,37934,48563,54904,54936,52823,54968,46451,23272,10627,6435,12709,37999,44305,44239,44174,44108,35722,37769,50414,50578,16934,4323,4323,4291,4323,8484,35952,42258,46452,44371,23177,12645,14758,12613,10564,10565,10532,10533,10532,10565,10565,10565,8484,8484,8452,8452,8452,6372,6404,6372,6371,8548,10629,6468,8549,8549,21129,27468,16936,12743,12743,10630,16904,27435,25354,27435,29515,27402,21096,19049,8582,8550,8582,8582,8550,12775,19017,16936,21129,37999,40112,154},
{52857,50809,50809,52857,52857,52857,50809,50777,50777,50777,48729,50809,50809,50809,50777,50809,50809,50809,50809,50809,50809,50841,52890,50841,50809,52889,52857,52889,52889,52889,50809,52889,52857,52857,52857,50809,52889,52857,52857,52857,52889,52889,52857,50809,50809,52857,50809,50809,50777,50809,50809,50809,50809,50809,50809,52857,50809,50777,50777,50777,50776,48630,50743,50678,48498,50678,48663,48630,48662,50743,48630,48597,48565,48630,48597,48598,48598,46517,48597,48565,48565,48565,48565,48565,48564,48565,48565,46516,46484,48564,46484,46516,46517,33839,33905,33808,31727,33873,31695,31727,27533,29647,29647,25421,29647,31759,33937,33840,35953,29679,33905,31792,33873,31759,27566,23308,21227,25389,17001,21228,17034,19147,16969,19147,14889,19082,29614,46451,44338,50613,52823,33740,19016,35887,37936,29580,48565,14824,8582,10630,10695,12743,10631,25420,31693,21128,12709,35853,48465,48465,48399,44043,40013,14789,12709,37966,37966,37966,37934,37934,50677,57017,50710,44338,46483,27498,12708,10692,14853,16966,29546,44240,31595,35788,42126,54837,50446,50512,48563,16934,8581,4324,4324,4323,6404,33807,40178,40145,42226,27435,12677,14791,12743,10630,10630,8485,6371,8452,6371,8484,10597,8485,6371,8484,8484,6404,6404,4259,4259,6436,8516,25387,23274,25355,23242,33774,37999,33741,23177,29581,16936,25355,44370,33773,27402,29548,29548,23177,16936,12775,8550,8582,8582,8550,12775,16937,16904,25387,31693,21129,125},
{52890,50809,50809,52857,52889,52857,50777,50777,50777,50777,50809,50777,50777,50777,50809,50810,50809,50809,50809,50809,50809,50809,50841,50809,50841,50841,52890,52889,52857,50809,52857,52857,52857,52857,52889,52857,52857,52857,52857,52857,52857,52857,52857,52857,52857,50809,50809,50809,50809,50809,50777,50809,50809,50777,50777,50777,50809,50777,50777,50777,50776,50711,50743,50743,48597,48631,48631,46550,48631,48630,46550,46518,46550,48598,48597,48564,50678,48630,50677,50677,50677,50710,50677,50677,50645,50677,50677,50645,50710,50710,50710,50710,50678,48597,48565,48500,48532,48564,48532,48565,48532,48532,46516,42258,40112,44240,42160,50678,48532,25355,25356,27404,25323,23243,23275,33742,27371,23146,21130,19017,23275,21195,19049,19082,29516,27370,29548,52790,44338,50645,52790,35886,25322,40145,42194,38000,46453,14857,10662,10630,8517,10631,8518,12743,31693,31660,27402,40046,44271,48464,50545,48367,33739,21127,21127,37966,37966,37966,29515,25289,31660,35854,29515,27402,29515,23271,19078,16965,21158,16933,27465,40013,23112,21031,42061,48432,48235,50511,37998,12741,6469,4324,4324,4356,6404,29581,42291,38032,38032,33742,10564,14921,19114,12776,12776,10662,6404,6437,4259,6437,10662,6436,4323,10630,8582,6469,6437,4324,6404,6436,8548,21160,23274,27467,33741,37966,37967,38031,31693,18984,12775,19016,35886,35887,29515,29548,23144,25290,18984,21096,16936,10663,8550,8550,12743,14855,14823,16936,23242,12743,99},
{50809,52857,50809,52857,52889,52889,50809,48729,50777,50777,50777,50777,50777,50777,50809,50809,50809,50809,50809,50809,50841,50809,50809,52890,52890,50809,52889,52890,52857,52857,52857,52857,52857,52857,52857,52857,52857,50809,50777,52857,52857,52857,50809,50809,52857,50777,50809,50809,50809,50809,50809,52857,52857,50777,50777,50777,50809,50777,50777,50809,50777,50809,46616,48696,44503,38230,38197,36116,36084,36052,33971,31858,31858,33938,44371,42192,48532,50677,48531,46451,46451,46451,48531,46451,48531,48531,48596,48563,52790,54936,57016,57017,57017,57017,57016,54968,57048,57017,57049,57049,57048,57016,40113,33807,31661,42029,48466,57049,38000,12743,12776,12776,12744,12776,12776,14856,27338,21032,12678,16937,14824,10663,16872,16905,35788,39916,27435,50612,42225,42259,35886,21160,14854,46452,46452,50646,48565,19017,10663,12743,10662,12743,10663,10662,25419,27434,27434,44272,46385,48432,50578,46384,29481,19013,27466,37999,37999,37966,40047,42095,40014,40046,40047,42094,40046,31658,23238,21191,25384,27401,31595,35787,37868,44108,33511,29285,46155,54804,33740,6436,4324,4323,8581,4356,4323,27500,44372,40178,44339,31661,10564,14888,17066,12808,10695,8582,4323,10663,12775,10662,8549,4323,4291,10662,8582,8517,8550,4324,6436,8580,8548,10693,8548,8516,27467,38031,37999,35886,31660,16935,10630,16903,21129,31628,27435,31628,37934,42192,35853,42160,23242,8582,8582,8582,10663,16936,16936,14823,8549,16936,105},
{50809,50777,50809,52857,52889,52889,52857,50809,50777,50777,50777,50777,50809,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,52890,52890,52890,52922,52857,52857,52857,52857,52857,50809,50809,52889,52857,52857,52857,52857,52857,52857,52857,50809,52857,50809,50809,50809,50809,50809,52857,52857,50777,52857,50809,50777,50777,50777,50776,50777,50809,50777,52857,46584,48664,42390,36149,38197,36116,34003,34003,31923,31891,31858,31858,44404,44370,46386,48531,46451,48531,46451,46451,48499,46450,48499,48499,48564,48563,48531,48531,48563,50676,50612,50611,50643,52724,50643,48563,50644,50611,50611,46419,31694,27534,27501,37902,42095,52823,35887,14857,12808,12808,12808,12808,12776,12808,31498,46157,21032,16872,16937,14824,16872,18985,35723,37868,31661,54871,52726,40145,27466,16965,16967,46484,44339,48533,48565,19017,12711,16936,21129,16936,14855,10629,12806,12773,16934,44304,52757,44174,50578,46352,44272,25321,33805,37966,37966,37966,50610,50643,50611,50643,50643,50610,37998,25353,19046,19014,19015,25321,37998,40046,44239,44141,42028,46155,48300,33708,14823,8549,8517,10661,8549,4356,2211,23307,44372,42258,42258,27435,12645,14823,14856,10630,8517,8517,6404,10662,12743,10630,8517,6372,6404,10630,8550,8485,8517,4291,8548,10629,8580,10628,14855,21129,33806,33806,29515,23209,31660,35918,33773,27435,21128,25290,25322,29515,25354,19015,31660,25322,10630,8582,8550,8550,10630,16936,23210,16871,16903,23209,106},
{50809,50809,50809,52857,52890,52857,52857,50809,50809,50777,50777,50809,50809,50809,50809,50809,50809,50809,50841,50841,50809,50809,50809,50809,50841,52890,52889,52857,52857,52889,52889,50809,52857,50809,52857,52889,52889,52857,50809,50809,52889,52857,52857,52857,50809,50809,50809,50809,50809,50809,50809,50777,50809,52857,50777,50777,50777,50809,50777,50776,50776,52857,46616,46616,42422,38197,36149,36084,34004,34003,34003,33971,31890,31858,33938,38099,46517,48532,44338,46419,46451,46451,46451,46451,46418,46451,46418,46450,48498,48531,48498,48498,48466,48498,46450,48531,48499,46418,46418,46418,44305,46451,33840,27534,29615,33742,42128,54871,48565,16937,12808,12809,12776,12776,12776,10663,33448,54346,46156,25160,20999,25192,18920,18920,31531,27370,29547,57017,50678,40145,25385,16998,16934,44338,50677,48597,46452,19017,12743,16936,21129,16936,16935,14854,12805,14918,23208,48465,48531,37836,50578,46351,42192,23209,33773,37998,37966,40079,50611,52822,52757,52757,50676,44271,18982,16934,21158,23239,19078,14853,16901,12676,25321,44271,50577,48333,27337,8550,8550,12743,19081,16934,8516,6404,2211,21162,42324,46452,46484,29516,12645,12645,10532,10532,10532,10532,10565,10565,10532,10532,8484,10532,10565,8452,8452,8452,6371,6371,8516,10660,10660,8516,23241,40080,37967,27402,31661,31661,37999,40144,40112,37999,25322,18984,27435,27435,19016,16935,27435,21161,8582,8582,8582,8582,10630,14823,27467,37933,46386,37934,105},
{50809,50777,50777,52857,52858,52890,50777,50777,50777,50809,50809,50809,50809,50777,50777,50809,50809,50809,50809,50809,50809,50809,50841,52890,52890,52890,52889,52857,52889,52889,52857,52857,52889,52889,52857,52857,52857,52889,50809,50809,52857,50809,50809,50809,52857,50809,50809,50809,50809,50809,50777,50809,50809,50777,50777,50809,50809,50809,50809,50776,50777,50809,46616,48664,42390,38230,38197,36117,34036,34003,34003,34003,31923,29778,31826,36051,38131,42226,46484,52758,50710,50677,46451,52758,46418,52790,46418,48563,46450,52758,48531,48498,48466,48499,48563,50645,52790,50709,50677,50677,50677,48564,33839,27534,27534,31662,44338,54904,50678,14824,10696,10728,10696,10696,10696,10631,37673,54345,52298,50186,50251,48204,41964,18919,27404,21162,40080,59162,48597,42290,27434,25354,19048,44339,52790,44370,44338,19016,10630,16936,21096,16935,19016,19079,14886,8612,21095,48465,44239,44238,50577,42191,27402,25322,33806,37999,37966,37933,42191,54903,54936,52790,42224,50644,33773,16934,14885,16966,19046,21191,19046,10629,8484,25321,25256,18950,8550,8582,8583,12775,21160,14854,10662,6436,2211,19081,42324,44371,44371,37968,12613,12678,10565,12613,10532,10532,10565,10597,10532,10532,10532,8452,10565,8484,8420,8452,6371,6404,8548,10628,12741,8547,29548,38031,37999,40112,37966,35886,40080,35854,29515,25290,19016,16903,23209,25322,19016,23209,27402,25355,10630,8549,8549,8517,14823,25322,21096,21063,23176,31628,106},
{50809,50777,48697,50809,52857,52889,50809,50777,50777,50809,50809,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,52890,52890,52890,52889,52890,52890,52889,50809,52857,50809,52889,52889,52857,52857,50809,52857,52857,50809,52857,50809,52857,52857,50841,50809,50777,50777,50809,50809,50809,50777,50777,50809,50809,50744,50776,50744,50776,50744,50744,50777,46583,48664,42390,38230,38230,38197,36084,34004,34004,33971,31891,31858,33938,38164,33938,44307,46451,48532,48532,46451,46419,48532,46418,48564,46418,48563,46418,48564,48499,46450,46418,48499,48531,48531,48596,48564,48564,48564,48531,46450,33807,27534,27535,29614,40112,54871,44274,12743,10696,10696,10696,10696,10696,10663,29321,35496,39688,41769,39754,33545,33578,31465,27370,19082,27468,42225,46484,42258,25354,19081,19049,42290,50677,46483,48532,23210,14856,16904,23209,16936,19048,19047,16998,8580,21128,48465,48464,46351,48497,33708,25290,23210,31628,37999,37966,29515,37966,48596,50678,44403,31660,29580,21192,16966,19078,16933,19046,16965,19078,12741,8549,8484,10564,12710,19049,10663,8550,10662,21127,16966,10726,6468,6404,19114,42357,38033,33775,33774,12613,12678,12645,12613,10564,10533,10565,12678,10565,10565,8485,8452,8485,8517,8452,6371,6371,8484,10661,8548,10693,8515,19047,37999,37999,38031,29548,27435,27467,25289,23209,25290,21096,27402,33708,40047,33741,21064,21096,33774,35887,29548,27435,40079,46417,35885,33740,42127,42160,35854,105},
{50777,50777,50777,50777,50809,50777,50777,50777,48696,48729,50777,50809,50809,50809,50841,50809,50809,50809,50809,50809,50841,50809,52890,50841,50809,50841,52890,52889,52857,52889,52889,52857,52889,52889,52857,52857,52857,50809,52857,50809,50809,52857,50809,50809,50809,50809,50809,50809,50777,50809,52857,50777,50776,50809,50809,33873,23276,25454,25454,25454,25454,25454,25454,25454,23373,23374,23374,23374,23341,21261,21293,21261,21229,21261,23309,23341,25421,44307,48564,50645,48597,48564,48597,48564,48596,50677,48597,48596,50676,50677,50677,50676,50677,50677,50677,50677,50644,50612,48563,46451,44402,48597,31727,27534,27534,27566,42193,54904,50678,14824,10728,10728,10696,10663,10696,12743,27241,16775,16775,20935,18887,14727,23113,37641,42062,17034,12775,35887,50678,44372,21161,10694,10662,38065,44305,46419,52790,23177,10598,16903,25323,21129,16936,21160,19078,14885,29514,48497,48465,50545,42159,27370,25290,16937,27403,35854,37934,29450,29482,31562,29482,29514,27434,12741,10661,19046,21158,21223,21158,16933,16966,19078,12741,14823,27468,31596,25355,10663,8583,8550,16935,14886,8581,6501,4356,16937,42324,40146,33775,31726,12645,14790,14823,10565,10564,12645,10565,14791,12710,10532,8484,8452,8517,10565,8452,8484,6371,4323,8548,8548,8580,8548,6435,19047,37999,40080,31661,23209,25354,25290,25290,25322,21129,19016,33741,37934,31660,19016,21096,31660,44305,44337,46418,54869,50611,27401,21095,21128,21128,23209,106},
{50777,50809,50777,50777,50809,50777,50809,50809,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50841,50809,50809,50809,52889,52890,52890,52857,52857,52889,52857,52857,50809,52857,52857,52857,50809,52857,50809,50809,50777,50809,52857,50777,50809,50809,50809,50777,50777,52857,50809,52857,50809,52857,31761,14890,17035,17035,19116,19116,19148,17035,17035,17035,17035,17035,17003,14955,14923,14922,14890,14922,14954,14922,14922,17002,27501,27533,27501,27533,29581,29614,29614,29581,29613,29614,29646,29613,29613,29614,29613,29614,27565,27565,29613,31694,29646,29646,35854,40112,44338,31662,25454,25454,27534,42226,54904,50678,14824,10696,10728,10696,10663,8648,16871,31368,20936,25128,23015,18920,18888,16775,23048,37903,19082,14889,40146,46484,42226,21161,10662,8582,35920,46419,48532,52790,23209,10598,16871,31661,25323,12710,19047,16997,14853,31626,50545,48465,48496,42159,27402,27435,14856,27403,42193,42127,52658,50611,48498,50644,50644,40079,19015,12741,21158,23303,23302,21190,21158,19078,19078,16966,16934,21160,27435,31629,10663,8583,8550,12742,19047,12773,8581,6436,14856,40244,40210,44339,35919,12677,12678,8484,10565,14790,10597,10565,14823,16968,14823,12711,10630,8517,8516,8483,10628,8516,6403,8548,12741,10692,10660,8548,6435,21161,29547,29515,27402,27403,25354,25322,23241,21129,14822,25322,29515,29515,21096,23209,25322,42192,42192,35852,46353,48563,21095,6435,6435,10596,12709,107},
{50809,52890,50809,50777,50809,50810,50777,50777,50777,50777,50777,50809,50809,50809,50809,50841,50809,50809,50809,50841,50809,52890,50841,50841,52890,52889,52890,52890,52889,52857,52857,52857,50809,50809,50809,52857,52857,52857,50809,52857,50809,50809,50809,50809,50777,50809,50809,50809,50777,50777,50809,50809,50777,52857,52857,33841,19083,21196,23309,23309,23309,23309,21228,21196,21196,21196,19116,19116,19083,19083,19083,17003,19083,17002,17002,17002,17002,16970,14922,14922,17002,16969,16969,19050,16969,19050,19018,16937,14857,12776,14825,14825,12776,12776,12744,12744,12776,12744,12744,27371,37934,46386,31694,25421,25421,25421,38000,52790,44306,14824,12776,12776,10696,10696,12776,27403,35529,27208,33546,25192,21000,18887,18888,21032,29517,21227,21194,44340,50709,42226,19048,12807,12774,35952,48597,48564,50677,37967,35821,35821,44306,33710,14790,23240,19046,14885,33771,48497,48465,48497,33740,23241,25322,12743,27435,50678,48498,52724,50709,50644,50676,46417,48498,35886,21127,19046,14885,19078,21222,21222,23302,21190,21191,16966,16934,31661,37967,12775,6502,8582,12775,19047,12805,8581,6435,14888,40211,42324,40145,37968,14726,12678,8484,6372,8419,8420,8484,14856,21195,16937,14823,14823,12742,10629,8483,10628,8548,6468,8516,10629,8548,8548,8548,6436,19048,31693,35887,25290,25322,23209,25322,23241,35887,40144,29515,29515,27402,29483,31628,29483,40111,42224,44337,50644,44338,21095,10628,12741,12741,16935,112},
{50809,52890,50809,48729,50809,50810,50809,50809,50809,50777,50777,50809,50777,50809,50809,50809,50809,52857,50841,52890,50841,52890,52890,52890,52890,50841,52857,52857,52889,52889,52857,52889,50809,50777,50809,52857,52857,52857,50809,50809,52857,50809,52857,50809,50809,50777,50809,50809,50809,50777,50809,50809,50809,50809,50776,40179,35953,35953,40179,38034,38066,38066,38066,35985,35985,38034,35954,35954,35953,35953,35953,35985,35985,35953,35985,35986,35985,35953,35985,35953,38033,35953,35953,35953,35953,38033,38001,35953,35953,35953,35921,35921,35888,35921,35921,35888,35888,35888,35888,37869,44272,48499,31662,27534,25454,27502,42193,50644,40113,25421,25421,23341,23373,23341,23341,29582,33612,27110,25062,23015,27273,29385,29352,31498,37870,21163,23242,44305,46484,42227,21193,14886,17032,23275,48630,52791,48597,44241,42160,40014,48467,40048,25322,19047,14885,16966,37965,48465,50545,37965,23208,23209,25323,16936,27403,27435,35854,46450,52823,52822,48629,44272,50709,35887,23240,14886,8580,8580,14853,16965,21190,16998,10692,6435,6468,27466,37967,14856,8614,10726,10660,21159,14886,8548,10660,14887,40179,40211,33807,37968,20999,18918,18853,16740,16773,16772,14692,16837,16773,16773,16740,16837,21126,14820,10596,14821,10628,8548,8516,8516,8548,10661,8548,6469,12743,12775,23242,25322,31661,35821,40047,23242,29580,44338,35788,35788,42159,37934,40047,37999,40144,44271,52624,50511,44172,16901,10628,12741,16934,19015,98},
{52857,52857,50809,50777,50809,50777,50777,50777,50809,50777,50777,50809,50809,50809,50809,50809,50809,50809,52890,52922,52890,50841,50841,50841,50841,50809,52890,52889,52889,52857,52857,52890,50809,52857,52857,52857,52857,52857,50809,52857,52857,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,31727,19050,21131,25389,21163,21195,21196,21163,19050,17002,17034,17002,17002,17002,17034,17002,17002,17002,19050,19050,19050,19083,19082,19083,21163,21163,21163,21163,21163,21163,21195,21195,23244,23243,23275,23243,23243,23243,23275,23275,23243,23276,25356,25355,31628,40080,40048,27501,25422,25421,25421,42193,52725,38065,29679,29647,29647,29647,29647,27567,27567,33710,46059,43816,37544,29321,27305,25160,33546,48238,18952,23241,48563,48598,46453,21194,17000,29613,16905,46485,50710,48532,35853,33740,37966,48499,46385,37999,21159,14853,16966,40078,48497,48465,50677,37999,27403,29515,25322,23242,23210,27403,40047,40046,37934,31659,25385,27466,12740,14853,14885,14917,16966,12772,14885,16965,12805,8547,8516,12742,21128,42193,14888,8614,17030,16965,21158,19046,14853,14886,12773,38098,40179,31694,37967,39817,41996,31464,31432,31432,33512,39849,44206,42029,37835,39948,37802,31561,21158,16869,18982,16869,14789,23209,6404,6436,8549,10662,10662,10630,8550,12742,25387,29548,31628,29515,14823,19016,35854,37998,40046,37934,35854,31628,23176,27402,42061,50445,52525,41993,25255,19014,12676,23208,27467,126},
{50809,52857,50809,50777,50777,48729,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,52857,50809,50841,52890,52890,50841,52890,52890,52890,52890,52890,52857,52889,52889,52857,52857,52889,52889,52889,52857,50809,50809,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50777,50809,52889,40147,31728,33840,33840,33841,33873,33841,33808,33808,31760,31728,31728,31760,31728,31728,31695,31695,31728,31728,31727,31695,31727,31727,31695,31728,31727,31695,29614,31727,29646,29614,31695,29614,29614,29582,29582,29582,27533,27501,29582,27501,27501,27502,27501,33741,31628,33806,29614,25422,23341,25421,42162,52758,31727,27567,27534,27534,27567,27534,27599,27567,29647,35756,35560,41898,39819,29353,27272,33512,46059,18951,27500,44371,46420,48533,19017,19048,35920,16905,46453,54903,44338,33740,33708,40047,44273,42192,29547,19078,16998,19046,44239,48465,46384,52757,40079,31596,23209,25322,25322,23242,29580,35886,35820,40111,42224,25320,16965,14886,16934,19046,21191,21158,21158,14917,16998,14885,10692,10660,29580,42192,44338,14888,6470,8581,12806,16967,14854,8580,10628,10628,35986,40179,33774,35754,43977,41995,29318,29350,29350,33510,46188,42060,37834,37801,37834,37801,27367,23206,18981,16869,14789,16935,16935,14791,12775,8615,10663,8582,8582,8550,12743,25387,27435,25322,16904,12711,23177,23241,29548,29515,29515,35886,46450,46418,42192,44240,48465,50578,46319,27400,16901,12741,19047,29579,146},
{52857,50809,50809,50777,50777,48729,50809,50777,50809,50842,50810,50810,50842,50809,50809,50809,52889,52890,52890,50841,50809,50809,52890,50841,52890,50809,50809,52889,52889,52889,52857,52857,50809,52857,52857,52857,50809,50809,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50777,50776,50776,50809,52890,31760,21163,25356,25389,25389,23308,23309,23308,23276,23276,23276,23276,23276,23308,23276,21227,23308,23308,23276,23276,23308,23308,23308,23308,23308,23308,25388,25389,25389,25388,23340,25421,25389,25421,25421,25389,27501,27501,27469,29582,27469,27469,27469,27469,35822,35821,31694,29582,27534,25454,27502,42226,44306,29582,29615,27535,27535,27567,27535,27567,25486,27534,16936,33675,52559,50413,41963,44043,52363,48105,18951,31726,48597,46452,48565,19049,25387,40113,18985,44371,52790,42225,31596,33676,37934,40079,42160,21160,10725,14918,19078,44239,48464,48432,37933,35886,31596,23178,25290,23210,23210,35886,37934,37933,48563,57016,44337,23239,21159,23272,25352,19047,21159,14885,10661,10693,12740,10692,8580,8516,29547,44338,19049,12743,6469,10695,14887,12806,8580,8579,12773,33905,35986,40145,42027,44074,44075,43976,46024,46057,46056,48333,46089,46056,46088,48169,44009,31528,25287,21127,19014,14821,23274,27467,29613,14856,8582,8582,8550,8582,8550,10663,25354,25322,33774,37967,31661,27402,23177,29516,27435,29548,29515,33741,46418,46385,52789,52822,52790,25322,10597,10693,12773,10660,14822,92},
{50809,50809,50809,50777,50777,48729,50809,50777,50809,50842,50810,50809,50809,50809,50809,50809,52890,52890,52857,50809,50809,52890,50809,50841,52890,50809,52890,52890,52889,52890,52889,52857,52857,52857,50809,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50777,50809,50809,50809,50809,50809,50777,50809,38066,29647,31760,31727,31727,31727,31760,31760,31727,29647,27534,27534,27534,27534,27501,27502,27502,27502,27502,27502,27469,27469,27501,27502,27469,27469,27502,27469,27469,27469,25388,25388,25356,23276,25356,25388,25388,25356,23308,23243,23276,23275,21195,21195,33676,39981,37901,31662,27502,27534,27534,42194,50645,29582,29615,27502,27567,27534,27535,27567,25454,25421,16968,19016,27402,33675,27337,31497,44043,50218,20999,33807,46451,44307,44404,21162,31693,38000,35888,50743,50710,37999,35854,37934,40047,42160,27434,14854,10693,10661,19015,46352,48432,48432,42159,35886,31628,25323,25290,25322,27467,37966,35886,40079,52823,52758,44337,21127,19047,21127,29544,14853,8580,10725,8548,10660,14917,12805,10661,10629,31693,40111,35886,27436,8582,8550,19048,14854,10660,12804,12740,33872,38099,42193,41929,44076,35624,43944,43976,37639,44042,46188,39816,48169,43976,39751,46187,33641,25287,19014,14820,12708,10661,10596,27435,29580,23242,16968,12743,10630,8550,10630,25323,29515,40112,42224,42257,40112,23209,23209,29548,29548,29548,21129,31693,44305,44305,40112,23242,8518,8550,6437,10694,8581,10629,79},
{50809,50809,50809,48729,50777,50777,50809,50809,50777,50809,48729,50809,50809,50841,50809,50841,52890,52857,52890,52890,50809,52890,52890,50809,50841,52890,50841,52890,52857,52890,52889,52857,52857,50809,50809,50809,52857,50809,52857,50809,50809,50809,50809,50809,50809,50809,50777,50809,50809,50809,50809,50809,50809,50777,50809,33873,25421,29582,27502,27534,29582,27502,27534,29582,27534,27502,27502,27469,27501,27502,27501,27534,27502,27534,27534,29614,27534,29582,29582,29582,29614,29614,29614,29647,29647,29614,29614,29614,29614,29646,31694,29646,29614,29646,31695,31695,31695,29646,27534,35822,54838,54870,29613,25389,25389,25389,37967,46452,46453,44404,44372,44372,44372,42292,42291,42259,40178,23274,19081,16969,21130,14824,19049,39850,50186,23111,42194,48565,46420,46485,19082,35920,42193,35887,54904,48597,37967,35886,37966,42159,40079,21127,19014,14854,12774,19015,46352,46352,48464,44239,35854,31661,25290,35788,31595,29515,37967,35853,42192,52855,46418,25321,10596,25321,25320,29577,23270,12772,10692,14885,16998,16997,14885,10662,12775,40112,40014,40047,27435,8614,4356,16934,12741,10660,14885,14820,31791,40212,46320,43944,44009,43976,43976,46056,43976,46057,46089,46056,46056,46056,46056,48202,39880,29447,23207,21094,14789,6435,14822,33806,35919,35919,37967,35886,31693,25387,21161,25290,33741,40112,35886,29548,25354,16903,21129,29548,29516,29515,18951,18951,23144,23144,25290,16903,10630,8550,6469,8549,12743,27467,122},
{50809,50809,50777,48729,50809,50777,50777,50809,50810,50777,50809,50809,50809,50809,50809,52890,50841,52890,52922,52890,52890,50841,50841,52890,52890,50809,52890,52889,52857,52889,52889,52857,50809,52889,52889,52857,52857,52857,52857,50809,50809,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50777,50809,52889,35921,27469,29582,29582,29550,27534,27469,27502,25421,25421,25389,25389,23341,23308,23308,23276,23276,23308,23308,23243,23276,23276,21195,21195,23276,21195,21195,21195,21196,21195,21163,21163,21163,21195,21163,21163,21163,19082,21130,21131,21131,21131,21130,21098,33774,56984,54871,27469,23341,25421,21162,37999,52823,54937,52856,52856,52824,52856,52824,52824,52856,52823,44371,25355,19081,23210,21162,23178,31497,46058,27305,42226,44339,42194,44372,21163,42227,48565,40113,50710,48564,35821,35854,37966,42128,37966,25320,27465,21159,16966,23240,48498,48465,48464,42159,33773,31628,33643,50414,31562,31629,37967,35853,44272,54903,50644,25321,14854,29547,31627,27432,23271,19077,16997,19110,16965,21191,17030,10694,12775,38032,44337,42224,21128,10693,8580,19046,12805,14885,12805,14853,31791,38099,44109,43943,43976,46024,46056,46056,46024,46024,46024,48104,48104,48136,46055,48136,46088,41928,33608,21094,12741,6435,14854,31694,35887,35887,33773,33806,37999,40079,37999,25322,29580,29515,25322,25322,25354,37999,35918,29515,29548,31628,33674,35721,31528,40046,46450,44305,40079,33806,23274,10629,17001,40112,173},
{50809,50809,50809,50777,50777,50777,50777,50777,50809,50777,50809,50809,50809,50809,50809,50809,50809,50841,52890,52890,52890,52890,50809,50810,52890,52890,52890,52857,50809,52857,52889,50809,50809,52857,52857,52857,52889,52857,52857,50809,50809,50809,50809,50777,50777,50809,50809,50809,50777,50809,50777,50809,50777,50809,50809,35986,29647,31727,31760,31760,31760,31760,33840,31760,31760,33808,31728,31728,31728,31760,31728,31728,31760,33808,33808,33808,33808,31727,33775,33808,33808,33807,33840,33840,33840,33808,33807,31727,33807,33840,33807,33775,33775,33807,33807,33840,33839,31759,33807,35887,46385,44305,35887,23276,25388,21097,33773,52791,52856,52823,52823,52823,52824,52823,52823,52823,52823,52823,29580,25354,29548,27403,23210,33676,33643,27370,48532,42291,35921,44372,31629,48565,44339,40113,52791,46451,35821,37934,35821,37934,35853,31658,31690,23272,19046,29514,54870,50578,46319,48465,33741,33773,44174,46189,31530,31661,37999,35853,48596,52790,50677,27466,12741,23274,19047,27465,21126,21158,21158,19110,16997,16965,19079,10694,10631,23242,31659,21128,14853,16966,16965,19078,12773,14885,14852,14820,31726,38098,39817,41864,39751,41831,41863,41831,41863,41896,41831,43943,43944,43944,43976,41864,43944,37703,23110,12708,10660,12741,12740,23209,25354,27468,27435,21129,31661,31660,23209,23209,27403,25322,25322,27403,23274,40112,42224,33773,40079,46351,54704,56783,52591,46352,44337,44337,42224,40047,33708,14823,10695,16968,152},
{50809,50809,50809,50777,48729,48697,50777,50809,50809,50777,50809,50777,50809,50809,50809,50809,50841,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52857,50809,52857,52889,52857,52857,52857,52857,52857,52857,50809,50809,50809,50777,50809,50809,50809,50777,50777,50809,50809,50809,50809,50777,50809,50809,50809,52857,33808,23244,25357,25356,25389,25389,25356,25324,25324,25356,25356,23244,23244,21163,21163,21163,21131,21131,21163,23243,21130,21162,21130,19082,21130,21131,21130,21162,21130,21131,19082,19050,19050,19082,19082,19050,19050,19050,19050,16969,19050,19050,19050,19050,31661,44305,46418,52758,18952,16905,19017,33806,52856,52824,50775,52824,52823,52824,50743,52823,52823,52824,52823,44306,44273,33709,35920,27403,27403,29483,33709,46452,38033,27534,46485,40081,50678,42226,40112,52823,44306,31596,33708,37934,40112,40079,46385,35885,14853,14853,27466,50578,48432,40014,42159,29514,31660,33741,35723,29482,31661,35886,37933,50709,48564,46450,27402,14822,19048,14821,21159,21158,21094,23174,23174,16933,10660,19077,21160,23242,21095,35852,40112,35886,27466,31594,27433,16934,16998,19078,16933,27533,42161,43977,44075,37704,46089,41832,35558,46220,39817,41831,48169,39784,41896,46253,33511,33511,20997,8515,14821,12773,12708,16934,33806,31725,31661,27467,14823,16935,23177,23209,23241,27403,25322,27435,25354,12775,19016,40079,44337,44304,48464,56849,54704,50479,42224,40079,33773,29547,29515,29515,16904,10662,10630,99},
{52857,52889,50809,50777,48697,48696,50777,50809,50809,50809,50809,50810,52890,50809,50809,50841,50809,50809,50841,52890,52890,52890,52922,52890,50841,50809,50809,52857,52889,52889,52857,52889,52889,52889,52889,52857,52857,50777,50809,52857,52857,52857,50809,50809,50809,50777,50809,52857,52857,50809,50809,50809,50777,50809,48696,40146,40113,40146,40146,40146,40146,40179,40146,40114,40114,40114,40114,40146,40146,38066,38066,38066,40146,40114,38066,40114,38066,38066,38066,38065,40146,40114,38065,38065,38033,38001,38033,38000,38033,38033,38000,37968,38001,38000,35920,37968,37968,37968,37968,37935,46418,48531,50613,18920,16872,21130,40112,54937,52824,52824,52856,52856,52857,50775,52856,50775,52824,52856,52856,44240,33708,46452,29483,23241,29547,42225,50646,35954,27502,46486,38000,48598,40145,42225,52790,42193,35821,35854,35821,37934,33708,42257,33805,10660,10628,31627,50545,48465,40015,42127,42127,31628,33708,33610,29483,33774,35886,37966,52757,54968,50709,23240,16902,16934,19047,19046,21159,25255,41832,33543,16934,8580,10693,12741,35886,44337,44369,46418,46418,46385,52789,44305,23240,16965,21158,16932,27532,42094,44042,44107,44009,46089,46089,46089,48301,46122,46121,46089,48169,48202,46220,35624,18981,12740,12740,10628,6403,6403,21193,33838,33774,29580,25355,14855,19049,23209,33741,29548,27402,27435,27435,23242,10663,12711,23176,42192,46384,48398,52624,54736,42125,31660,27467,29515,29515,29548,29548,19016,10630,14855,91},
{52889,52857,50777,48729,50777,48697,48729,50809,50809,50809,50809,50809,50809,50809,50809,52890,50809,50809,50809,50841,52890,50841,52890,50809,52890,52889,50809,52857,52889,52857,50809,50777,50809,52889,52857,52857,52857,50777,50809,52857,52857,50809,50809,50809,50809,50809,50777,50809,52857,50809,50809,52857,50809,50777,50776,35920,31662,31662,31694,31662,31662,31694,31662,29582,27501,27501,27502,27501,27501,27501,27469,27501,27501,27501,27469,27501,27501,27469,27469,29581,29549,27501,29549,29581,29549,29549,29549,29549,27436,29549,27468,27403,29516,27436,27436,27436,29516,29516,29516,33709,50612,48499,44274,18953,14824,21130,38032,52856,50743,50743,50743,50743,52824,50743,52824,50711,50743,52791,50677,40014,42160,40112,21129,19016,23210,42129,46484,33872,27502,48599,33742,44372,40080,42226,50710,37967,33676,35821,40080,40080,37999,40112,27434,16933,19046,35885,48465,50611,50710,44271,44272,21128,29547,40047,42226,37934,35885,42160,54903,52823,50677,31660,25385,23240,23240,19046,12644,18950,27237,18917,19078,12805,6436,4355,10596,35886,40112,40144,44305,48498,35886,14789,23240,19046,19045,21126,29547,44043,46220,42126,39948,37835,39947,46155,46319,44174,39980,39948,41994,48333,39948,29449,21094,19046,10627,6435,6435,10628,29580,33806,25322,19016,21097,16936,23242,25290,23176,29515,33741,27403,27435,21129,10630,12743,16903,33773,50577,54736,54736,52624,35853,27467,27467,29548,29515,29516,29547,19016,10630,12742,63},
{52857,52889,50777,48729,50777,50777,50777,50777,50777,50809,50809,50809,50809,50809,50841,50809,50809,50841,50809,50809,52890,52890,52857,52857,52890,52857,52857,52857,52889,52857,52857,52857,50809,52857,52857,52857,52857,52857,50809,50809,50809,50809,50809,50777,50777,50777,50777,50809,50809,50809,50777,50777,50777,50776,50809,42291,38033,40146,40178,40178,40146,40178,38098,40146,40146,40146,38066,38066,40146,40146,38066,40146,38066,38066,38066,38066,40114,40146,40146,40146,40114,40114,40113,40113,40081,40114,40081,40081,40080,40048,37968,37968,40081,38000,37968,37967,38000,37968,37967,35854,50645,46255,37608,18952,14792,21098,35952,48662,46517,46550,46550,46550,48598,48630,48630,46517,46549,48597,42258,25322,35854,35886,23210,23210,27469,44308,48597,29614,27535,44404,29582,40114,40112,48532,50710,37902,33708,35821,37934,37934,35886,23241,19047,40111,27368,40014,48465,42094,48531,44240,29548,16904,23209,31596,27467,35886,35853,44273,54871,50644,35821,16902,25289,23241,23239,23240,29547,23241,10628,8548,14885,12773,8581,14823,10597,12741,12708,21095,40079,40111,19013,14885,23272,16965,21159,35886,40014,44076,39915,39883,37802,37770,35625,39883,37803,35689,35689,35721,37801,42060,35689,27368,14821,14853,10660,6467,8516,14887,31693,33741,31629,33774,38000,27435,23209,25354,21095,23208,37999,35918,27435,14823,12743,12743,16871,27402,42126,46253,46253,46352,35886,29515,27467,29548,29548,29515,29515,21129,14855,16966,57},
{52889,52890,50777,48729,50777,50777,50777,48729,50809,50809,50809,50809,50809,50809,50841,52890,50809,50809,52890,50841,52890,50841,52889,52857,52890,52889,52857,52857,52857,52857,50809,52857,52857,52857,52857,52857,52857,52857,50777,50777,50809,52857,50809,50809,50777,50777,50777,50776,50776,50776,50777,50777,50777,50809,50744,35952,29582,29582,29615,29647,29647,29647,29614,29582,29582,27502,27501,27501,27501,27501,27469,27469,27469,27469,27469,27469,27469,29581,27501,27501,29582,29549,29549,27501,27501,27469,27501,27501,27468,27468,27436,27436,27501,27469,27469,27468,29549,27468,25356,31629,48564,52691,50383,21065,16937,21130,38032,46517,42291,40243,40211,40243,38162,38130,38130,38098,38130,36017,21227,16968,14823,29549,25322,40047,40178,40146,44372,21195,25422,40178,29582,31695,35887,46516,48596,40079,40079,40079,44273,37934,37934,33773,29514,46385,29481,42159,46255,44076,42159,27402,16904,14888,21096,29548,29548,37966,35853,44305,54903,54936,33773,16902,25355,16935,23240,27465,48597,35918,12708,10661,16998,16934,8582,16936,23177,21096,19047,21127,23239,21126,19045,16965,23271,19046,14852,23272,21127,19015,12710,25322,44305,37998,29418,14726,12613,16902,18982,21063,14789,16869,12708,16901,14853,16997,14884,10660,10660,10629,25387,31693,29548,23242,25354,23241,25322,21161,10629,10628,35886,37999,21129,12711,10630,10662,14823,23144,23144,25159,33675,44305,37967,29515,29548,29548,29580,29548,29516,23210,14823,19047,71},
{52857,52857,50809,50777,50777,48729,50777,50777,50777,50777,50809,50809,50809,50809,50809,50841,50841,50809,50809,52890,52890,52890,52857,52889,52889,52889,52857,52857,50809,52857,50809,52857,52857,52889,52857,52857,50809,50777,52857,52857,52857,52857,50777,50809,50809,50777,50777,50777,50809,50809,50777,50777,50809,50777,50777,40211,29615,25454,25421,25421,27502,27502,25421,25388,25388,27469,29549,29581,29549,27501,27469,27469,27469,27469,27469,27469,25388,27468,27436,27468,27468,27468,27436,27468,27469,27469,27469,25388,27436,27436,25356,25388,25388,25356,25356,27436,27436,27468,25356,29516,35821,37934,39982,27403,21195,21162,40178,46550,42356,40275,38195,38162,38162,38129,38130,38130,38130,23372,10663,16968,21130,31629,42225,50644,42226,42259,44372,14857,25422,38098,27501,6437,14823,44371,44338,35821,35853,40080,42160,33741,23240,21160,37966,27467,23208,44271,48367,46221,35821,18984,14856,16936,27435,37966,33708,37934,35853,50644,54936,54903,33805,19047,16968,10629,25353,23240,42225,42224,21126,16934,14821,12774,10630,14855,23177,23209,23207,23207,19047,12773,14854,12741,16966,14885,19078,14886,8549,10663,10663,10630,25355,33741,33708,33773,31693,19048,12742,14887,10629,14854,10660,12740,14821,16965,21158,16965,10693,4355,6436,27468,27435,19049,23242,25290,25322,19048,10660,14822,29483,31596,35854,37999,29581,23242,23177,31563,31595,31562,35852,44337,38031,29548,29548,29548,29516,29515,29515,23210,14823,25289,90},
{52857,50809,50809,50809,48729,50777,50777,50777,50777,50809,50809,50809,50809,50809,50809,50841,50809,50809,52890,50809,50841,50841,50809,50809,52890,52889,52890,52889,52857,52857,52857,52857,52857,52857,52857,52857,50777,50777,52857,52857,52857,52857,52857,50809,52857,50777,50777,50777,50777,50777,50777,50777,50777,50777,52857,38066,23276,21228,21228,21228,21228,21228,19115,17002,16970,21195,29613,27468,23275,23276,23243,23243,23275,23275,25324,25356,21130,23211,23243,23211,23242,25355,23243,25323,23275,23243,25355,25355,23243,23275,21162,23243,21162,21162,21130,23211,23243,23243,23243,25323,27403,25290,31596,29549,23308,21163,33872,38066,35985,33904,31824,38097,38064,33903,33871,31824,31792,19114,10663,25387,16903,31596,33806,23274,25420,40210,38001,12712,23341,40146,31695,6437,23243,48565,42193,31628,35821,42192,42160,37966,33805,23240,33772,18982,14789,42158,50545,48432,37901,21097,12744,19016,35853,37967,35821,37934,37934,52790,52822,50644,31692,23240,16967,8548,19048,33773,33741,42159,31627,16934,10661,8549,10662,14823,23210,21097,21128,23207,19047,12775,8581,12774,16966,4323,12709,14886,8614,10663,10663,8550,21097,37901,42159,40046,29547,19016,10629,10629,10629,14854,16901,16933,14885,12740,12740,10692,8580,4291,4291,10629,23242,23242,23242,23242,23242,23209,14854,19047,35821,40080,44305,44337,44305,44272,48499,46483,50644,52692,31562,29514,40112,29515,29515,29548,29515,29483,29483,23242,14823,37934,163},
{52857,50809,50809,50842,50809,50777,50809,50809,50777,50777,50777,50777,50809,50841,50841,50809,50809,50809,50809,52890,50809,50841,52890,52890,52890,52890,52857,52889,52889,52889,52889,52889,52857,52857,52889,52857,50777,50777,52825,52857,52857,52857,52857,50809,50809,50777,50777,50777,50777,50777,50776,50777,50776,50776,50809,40179,23276,19115,19116,19115,21196,19147,14922,14889,12776,14921,25356,25388,21163,21130,19050,19082,19082,19050,19050,19050,21130,19082,19050,19050,21162,21130,19050,19017,19017,21130,21162,19049,19049,19050,19050,19050,19049,19017,19017,19017,19017,21098,21130,21162,25355,27403,35855,29582,17002,17034,14889,16969,14856,17001,14889,31660,33643,25289,25322,12775,8583,10663,8582,19048,37967,37902,31661,16968,23307,42292,38033,8550,23308,40179,31727,19017,25323,33807,42161,35821,35854,40112,40047,35820,44305,31625,50644,35853,23208,48367,48399,48465,37966,16936,12711,21129,37934,33708,37966,35853,37966,52758,54903,42225,29579,23208,19047,14854,19015,27370,33676,46385,40112,19046,16934,10630,10662,12743,19049,14823,25321,35885,27435,8582,6470,12774,16966,4355,12805,14886,10663,10663,12743,10630,16936,29515,29547,25322,23177,18983,27467,27435,21128,16934,14820,19046,16933,14853,8515,8580,8516,2243,10629,23274,27435,23209,23242,23209,25322,27403,16936,12742,23209,33773,42192,40079,42159,44272,48530,48531,52691,50577,27400,18950,25321,25322,29515,29516,29548,29515,29548,25354,10629,16934,70},
{50809,50809,50809,50809,50809,50809,50810,50809,50777,50809,50809,50809,50809,50809,50809,50841,50841,50809,50809,52890,50841,50841,52890,50809,52857,52889,52889,52857,54937,54937,52889,52857,52857,52857,52857,52857,50809,50777,52857,52889,52857,50777,50777,50777,50777,50809,50776,50777,50777,50776,50776,50776,50777,50777,50777,46518,27469,19083,19115,19115,19115,19115,17002,14922,14889,14889,19050,25356,23243,21162,21163,21130,21163,21163,21163,23243,21163,21162,21163,21163,21163,21130,21163,21130,23211,21162,23275,21162,21130,21130,21162,23243,23243,21130,19050,19049,21098,21162,21130,23211,25323,27403,35854,42291,27533,29646,23275,27566,23373,31792,19082,40112,52691,46319,31693,12776,10695,10695,8582,12775,33772,50644,44305,21161,27500,44372,35952,12743,21260,35986,29646,21129,25356,31695,35854,31595,31628,33741,40047,42127,50644,35852,52789,48498,25289,48433,48464,48432,37934,16936,10663,25323,42192,42192,37966,33773,37966,46418,48531,33740,27434,21160,16934,16902,23240,33773,35853,44305,27498,19078,19079,10630,10630,12743,12743,8517,23209,29546,29548,16968,8549,12774,16966,6467,12773,16999,10630,8550,21194,31693,27467,25322,23209,23209,27403,21063,35854,37966,31659,23240,14821,19046,19013,16965,12773,8548,6436,4355,8517,19016,31661,23242,23274,25322,21064,25290,19016,12710,14855,29548,40112,40079,42159,50610,54804,52723,52723,50576,27367,16902,16902,27435,29516,27467,29548,29580,25354,19047,8515,10596,56},
{50809,50809,50809,50777,50809,50809,50809,50809,50809,50810,50809,50809,50809,50809,50841,50841,50841,50809,52890,52890,52890,52890,52890,52857,52857,52890,52890,52889,54937,54969,54937,52857,52857,52857,52857,50777,50777,52857,52857,52857,52857,52857,50777,50777,50776,50777,50776,50776,50776,50776,50777,50777,50809,52889,52889,48631,23243,14889,16970,16969,14889,14889,14889,14889,14889,14889,14857,16937,14889,14857,14856,14856,14889,14857,14857,14857,14856,14857,16937,16937,14856,14857,14856,14857,14889,14856,16937,16904,16937,14856,14856,16937,16937,16937,14856,14889,16937,14856,14856,16904,16904,16937,19017,25387,19114,19146,16969,21163,17034,21259,14889,23274,31596,27402,19017,10696,10695,12776,10695,8614,19015,48499,29451,18985,21065,29549,31661,14856,19148,33905,29679,21097,29549,33774,40112,37967,37934,40080,35821,42127,46450,35852,54838,31595,25257,48497,48464,44272,29515,19016,10630,29516,40079,40047,37966,35853,40046,44272,37934,25321,16967,16934,16934,14821,27466,29579,33675,39981,23240,16934,19080,10630,10630,12710,16936,14823,21096,33773,48531,42257,27499,8548,12741,8548,6435,19047,31725,25387,19048,33773,42257,25322,23209,23209,25354,35854,37999,33773,31659,27465,21159,19014,23239,16965,12741,6436,6436,6502,8550,19049,33774,23242,23242,29515,35821,42160,31628,12710,10630,21129,35886,37998,46352,54835,54770,54770,54802,50543,39979,27335,23175,29548,29548,29548,29580,29515,23241,16934,10628,8515,48},
{50809,50809,50809,50809,50809,50777,50777,50809,50809,50777,50809,50809,50809,50809,50841,50809,50809,50809,50809,52890,50841,52890,50841,50809,50809,52857,52890,52889,52889,54937,54937,52889,52857,52857,50777,52857,52889,52857,50809,50809,52857,52857,50809,50777,50777,50777,50777,50777,50809,50777,50777,50776,48664,38099,25389,21163,14889,14921,16970,16970,16970,16970,16970,14889,14889,14889,14889,14889,14857,12809,14889,14889,14857,14857,14889,12776,14889,14857,14857,14857,14857,12776,14857,14856,14857,14889,14889,14856,14857,14856,12776,14857,14889,16937,14856,14856,14857,14856,14857,14824,14824,12776,14824,12743,12744,12776,12744,12743,10663,10663,10696,10695,10663,10663,10631,8583,10663,14888,10695,10662,23241,42128,16774,10534,10534,10501,16872,10599,14922,31793,31759,21130,40081,44273,40014,37934,37967,42160,42159,46418,44304,33706,48498,31594,31562,48465,48464,46352,31628,19017,10662,33773,37999,37966,37967,37933,46450,54935,44273,27434,19047,21128,16934,14822,33741,35821,35723,46287,37900,19014,14855,10630,10630,14856,27436,25290,23208,29547,40112,31660,21192,12741,10661,6436,4291,6404,25322,40047,37966,31660,31628,23209,23242,21097,23209,19049,12710,12710,16903,19015,16934,16934,19079,14854,8581,8549,10630,8582,8582,10630,23275,25323,25354,25322,25322,27435,27403,25322,27468,25322,35853,40078,52691,52657,48431,54771,54803,48464,48464,39946,27368,29515,29548,29548,29548,29515,29515,23208,14853,14821,54},
{50809,50841,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,52890,52890,52890,52890,52890,50809,52889,50809,52857,52857,52857,52889,52857,52889,52857,52857,52857,52889,52857,50777,50777,50777,50809,50809,52857,50777,50777,50777,50777,50777,50777,50777,46518,19083,10664,12776,17002,17002,17002,16970,17002,17002,17002,17002,14922,14922,17002,16970,16969,14889,14889,14889,14857,14857,14857,12809,12776,12809,12809,12809,12809,12776,12776,12776,12808,14889,14856,19050,19049,16937,14857,12808,12808,14889,14824,14856,14857,14856,14857,14856,14857,14857,14824,12744,14857,14856,12776,12776,12744,14824,14824,12776,12744,12776,12776,12776,10663,8583,12808,12743,10695,16968,27403,18952,12614,12647,12646,16840,10599,14889,33841,33808,12711,21130,42193,40014,37934,33708,42127,42159,48498,33739,31626,50611,37965,35755,48302,50545,46385,35854,19016,14823,37967,37999,37999,37934,40047,52790,54935,52790,29580,19015,23273,10629,10597,35821,35789,44076,48333,37802,21127,12774,10630,10662,21129,29581,27435,29580,33805,19047,8516,12741,14853,19080,16935,10663,19082,33774,44305,46385,40014,37934,25322,21129,23210,23210,12743,8550,6469,6469,6436,19048,23274,21162,19049,16969,25388,25388,21162,14888,10663,10630,23274,25354,25354,25322,25322,31693,35886,35854,35821,35854,44271,56949,54869,56916,54836,54835,58997,40045,23175,23175,29547,29548,29548,29548,29548,27402,21160,12708,12740,56},
{52889,50841,50841,50809,50809,50809,50809,50777,50809,50809,50841,50809,50809,50809,50809,50809,50841,52890,52890,52890,50841,50841,52890,52890,52889,52889,52889,52857,52857,52857,52857,52857,52889,52857,52857,52857,52857,50777,50777,50777,50777,50809,50777,50777,50777,50776,50777,50777,50809,50777,27535,19082,14857,17002,17035,17035,14922,17034,16970,17034,17002,17002,17002,14922,14922,17002,21195,21195,23308,23276,21163,16970,17002,17002,16970,14921,16970,14922,14889,14889,14857,14889,14889,16970,16969,14889,14889,14889,14889,14857,12808,14889,14889,14889,14889,14889,14889,14889,14889,14889,14889,14857,14857,14889,14856,12808,14856,19017,21130,21098,19082,14856,12776,10696,10696,8615,8550,16969,16968,14856,12743,23242,25323,25226,23145,25194,21033,10599,12776,33841,35920,10598,14856,35887,33741,33773,33774,33741,33708,37966,23240,25353,44273,33773,37965,52528,46255,48465,40046,19016,16936,37967,37999,37966,31628,35886,50677,50677,44338,19049,10629,19047,8549,19016,40014,35691,46057,44075,27303,19015,16903,8517,14856,23177,21129,21096,19079,12740,8547,8548,14886,16933,25386,31725,14856,10663,16968,40080,44304,44239,48466,27402,23177,21161,23242,23242,10630,8550,8549,8517,12742,19049,23242,23274,23274,29548,29581,25388,16936,12743,8550,23242,25355,25322,25322,25322,23241,31660,33773,27402,27402,37933,48465,50577,50512,56916,56916,42159,12677,6404,12709,27435,29580,29548,29548,27467,21127,16934,10596,8515,35},
{52890,50841,52890,50809,50809,50809,50809,50809,50809,50809,52890,52890,50809,50809,50809,52890,50841,50809,50809,50841,52890,52890,52890,52890,50809,52857,52857,52857,52857,52857,52857,52889,52857,52857,52857,52857,50777,50777,50809,50809,50777,50777,50777,50809,50809,52857,50777,50809,50809,25454,12776,14889,17035,19083,17002,17002,14922,17002,17002,19083,17002,17002,17002,17002,14922,12744,14889,14889,14889,14857,12809,12809,12809,12776,10728,10728,12776,12776,12744,12776,10696,10696,10696,12776,10728,10728,10696,12776,10728,12776,12776,12776,12776,12744,12776,12776,10696,12744,12776,12808,14889,12808,12776,12776,12776,12744,12776,16937,16969,16904,16905,10695,10695,8583,8583,10663,10663,12776,19081,16936,21161,25323,27404,25226,25258,27338,23146,12711,10696,33873,40114,16937,16969,25324,23275,19049,12743,10663,14791,33774,27466,21160,21095,35820,44271,48498,42094,48465,37933,16903,23210,37999,37966,35854,25224,23176,27337,27369,31628,16936,14823,14854,8548,27434,37933,35689,50250,39914,16902,33708,35821,16871,25322,23210,19016,19015,23240,16997,12772,8579,16933,19079,12709,10662,8582,8582,8550,25355,42192,44272,52757,27435,23210,21162,21129,16936,8550,8550,8518,8518,8550,4356,12742,10628,19081,27500,27467,25355,14856,8517,10662,23274,25354,25323,25322,25322,16935,12677,33806,44338,40111,42191,46417,48498,46384,52625,40014,12645,6437,6469,6436,23274,29548,29547,29580,33773,33805,29579,12708,12741,30},
{50841,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,50841,52890,52890,50841,50809,50809,52890,50841,52890,52890,52890,50841,52889,52889,52889,52857,52889,52889,52857,52857,52889,52889,52889,50777,50777,50777,50809,50809,50809,50777,50777,50776,50809,50809,50776,50777,27535,10696,12809,14922,19115,19083,17002,17002,14889,14889,14889,17002,23276,23243,25356,23308,23275,19082,17002,17002,17002,17002,16970,14857,14889,12809,12777,12809,12809,12809,12809,12776,12809,12777,12809,12809,10728,12777,12777,12776,12776,12776,10696,12776,12776,12776,12776,12776,12744,12776,12808,12776,14889,14856,12776,12776,12776,12744,12776,14856,12776,12776,12776,12744,12744,10695,10663,10663,10696,10695,17001,16968,16935,25355,33742,25258,25226,27371,23113,12647,10663,29679,35953,10663,10695,8550,8550,6470,6470,6470,12711,37967,27466,25321,33739,48465,46352,48465,46352,48465,35853,21096,31629,37999,35918,37966,46384,48465,44304,48531,31693,16936,16935,19080,16935,35821,42160,37770,43944,33576,23208,37965,44239,37933,37934,23177,21129,21161,19015,27497,21223,14885,8579,16966,14853,12742,8582,8550,8582,12711,35853,44207,44240,25289,23210,23242,16968,8517,8550,8550,8517,6469,10662,12743,14855,19016,25387,29548,19049,14855,21194,19049,14823,21129,25323,23274,16903,14823,6436,4323,10596,33773,42192,48563,50676,52821,50644,44305,21096,8550,8550,8550,8517,23274,35854,37999,38031,35854,31628,16934,14853,14853,43},
{52889,52857,50809,50841,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,50841,50809,52890,50841,52890,50841,52890,52890,52890,52890,52889,52889,52857,52857,52889,54937,52889,52857,52889,52889,50777,52889,52857,52857,52857,52857,50809,50809,50809,50777,50809,52857,52857,29647,10696,10761,12842,14922,17035,19115,17002,16970,14889,12777,14889,14889,16970,16937,16969,16969,16970,16969,16969,14889,16969,14889,14889,12809,12809,12776,10696,10728,10696,12776,10696,12776,12809,10696,10728,12777,10696,10696,12777,10696,10696,12776,12777,12808,12808,14857,14889,14857,12776,14889,12809,12776,16969,14856,12744,12776,12744,12776,14889,16937,19050,16969,14857,14889,14857,10695,10663,10696,10696,10696,12743,17000,25355,27468,35855,25258,27306,25226,21033,10599,10631,27534,33873,12744,12776,8583,8583,8550,8550,8550,14856,25355,29482,31691,33706,50577,48432,50545,48433,46384,35820,25355,33839,38031,37999,37966,40111,50709,52757,48564,27436,27435,29580,25386,29580,37999,40047,39915,46123,35755,35821,44240,42158,35820,29483,31595,21064,19016,18951,29515,31691,21158,14885,14853,12773,14854,29580,25323,16904,10630,21063,48498,46418,25290,21129,21129,23242,23210,16936,10598,8550,6437,10630,12710,19048,29613,29548,27500,16936,21194,29580,29548,25387,23241,21161,12774,6436,4323,4323,6468,6404,8484,29548,27402,25322,29483,29547,42225,29580,12710,8550,8550,8517,29548,40079,31627,27435,27402,27402,14822,19047,16934,63},
{52890,52890,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50841,50809,50809,50841,50809,52890,52890,52890,50809,52922,52922,52890,52890,52889,52857,52889,52889,52889,52857,52857,52889,50809,52857,52889,52857,52857,50777,50809,50777,50744,50776,50809,52857,29680,10697,10729,10761,12810,14922,16970,14890,19083,19083,19083,17035,14922,16970,19050,16970,17002,16970,16969,16970,17002,16970,17002,17002,16970,12809,14889,14857,12809,12841,12809,12809,12809,12776,12809,12808,12809,12809,10728,12776,12776,12776,12776,12777,12809,14857,14921,16970,17002,16970,14889,12776,12776,12776,14857,12808,12776,12776,12776,12744,12808,16969,19050,16969,14856,14856,14856,14856,14856,12776,10696,10696,10663,12775,29613,25355,35887,25258,27339,23145,21033,10598,8551,25422,33841,10663,12776,10663,10663,8583,6502,8583,16968,16903,27305,29385,35852,31626,46351,50545,42094,42158,29514,19016,33774,35854,35886,25321,27402,37935,40080,31629,10597,8484,16967,16966,21127,37998,37901,44043,46254,33675,40047,42160,37933,33676,18918,33708,29515,33741,35918,40080,29515,23239,21159,16966,12741,12741,21193,40112,37934,35918,35853,48497,44272,25289,23242,19049,19017,25355,27468,27468,23209,21128,29515,31595,33708,31629,29580,29613,25355,29581,27468,23242,23209,23241,16967,8548,6404,6468,6403,8516,6436,2211,4291,4259,2210,2178,14791,35886,27402,33773,33774,29581,16871,21097,31661,29515,29516,29515,27435,14823,21161,16934,51},
{52889,52890,52890,50809,50777,50809,50810,50809,50809,50809,50809,50809,52890,50809,50841,52890,52890,52890,50809,52890,50841,50841,52889,52890,52890,52857,52889,52857,52857,50809,52857,52857,52857,52857,50777,50777,52857,52857,50809,50809,50809,50777,50777,48728,48696,29680,10696,10729,10729,10729,12809,14922,19083,17035,19083,17003,19083,17035,14889,12809,19082,19082,19115,17002,16970,16970,16969,16969,17002,17002,14921,12809,12809,12776,12809,12809,12809,12809,12776,12776,12776,12776,12776,12809,12776,12776,12776,12776,12776,12777,12808,14857,14889,14921,14921,14857,12777,12809,12776,10696,12776,12808,12744,12777,12776,10696,12776,14889,19050,16937,14889,14856,12808,12776,12808,12776,10695,10695,10663,10663,31694,27436,35855,27306,25226,23145,21065,14759,8518,23341,33906,12743,12776,10663,8583,8583,8550,8583,21161,16967,25159,27208,29547,18982,39981,48497,48532,44207,21159,21161,35854,35854,35854,33707,33676,31563,29450,16935,6437,4356,4356,10661,21159,40111,39982,44140,42126,40014,42160,40079,42127,37870,44241,40047,31595,31563,35821,35821,33709,29515,21127,31692,35854,35886,14855,21097,40079,46417,50709,54903,54870,27402,21129,12743,6437,8517,12743,33806,37967,42257,50676,52723,44206,27434,29580,29580,19049,16969,14888,14823,25354,25386,12774,10629,8516,6468,6404,6404,6404,2243,4291,2211,2210,2178,16903,40014,46385,48497,44272,37934,21096,16904,29516,29515,27467,29516,25322,14823,27435,21096,51},
{52890,52890,50841,50842,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,52890,52890,50841,52890,50841,50841,50841,52890,52889,52857,50809,50809,52889,52889,50809,50809,52857,52889,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,42389,23341,10696,10761,10729,10761,10729,12842,14890,19083,17035,19083,17003,17002,17035,14922,14922,16970,16970,16970,14890,14889,12809,14921,14889,16969,16969,14889,14857,12809,12809,12809,12809,12776,12777,12809,10696,10728,12776,12776,14857,12777,12776,12809,12776,12776,12776,12776,14889,14857,12776,12776,12776,12744,12776,12776,12744,12744,12776,10696,10696,10696,10663,12744,12776,14824,12776,12744,10695,12743,10695,10663,10663,10663,10696,10663,14856,37968,25355,23211,25226,25226,23145,21033,14759,8550,23276,38034,14857,10695,8550,8551,8551,8583,8550,17000,21160,29320,29353,25289,27466,52692,50578,52757,42192,21159,23242,33774,33773,37934,46352,48498,48498,37934,14855,4356,6437,4324,4291,16903,40080,35756,48367,40014,31595,35788,37934,42192,46419,48499,25191,42126,52658,44240,40047,37967,25354,10662,19047,21127,19048,12743,21162,29547,42224,48499,40047,31660,25322,25322,23242,8550,8582,8517,21162,35918,44304,50643,48498,44240,40046,33773,27532,21162,14856,14856,14855,23240,14854,10661,8548,8548,10629,6404,4323,4291,2211,6436,4291,4291,2210,10597,23209,29547,35821,29482,29515,21096,19049,25355,25290,25290,27403,21097,21129,29547,31628,78},
{52890,52890,52890,50809,50809,50809,50777,50809,50777,50809,50809,50841,50841,50841,52890,50809,52890,50809,52890,52890,52890,52857,52889,52889,52889,52889,52857,50809,52857,52857,50809,52857,52857,52889,50809,50777,50809,50809,50809,52857,50809,50777,50809,29745,10696,10729,10761,10697,10729,10729,12809,16970,19115,17035,19083,17035,16970,17002,17002,17035,17002,17002,17003,17002,14922,12808,16970,17002,19082,19082,19082,14889,14889,12809,12841,12809,12809,12809,12809,12777,12776,12809,12809,12809,12776,12809,12776,12776,12809,12809,12808,14889,14857,14857,12776,12809,12809,12809,12809,12776,12777,12776,12776,14857,12776,10696,12744,16937,19017,14856,12808,12776,12776,12744,10696,10696,8583,12776,16904,21098,35888,21162,14824,23178,23113,23113,23113,16839,10598,23275,40211,16969,10695,6470,6470,6502,6502,6470,16968,27434,31530,23176,12710,25289,44271,46319,48465,31659,10628,23242,33741,33773,31628,33708,46450,50644,25322,8517,6436,4356,4324,4324,21129,40080,40015,44208,33708,27337,35789,40080,37967,50612,46419,42095,50577,37836,42192,40079,40112,23209,8550,12775,14887,10662,10630,23242,42225,42224,25289,8517,10630,21097,23209,25355,10630,16969,19017,16903,27435,35756,37901,35755,29515,25289,18983,19049,19082,14856,14856,16936,23240,14821,10628,6436,6436,6435,6403,4291,2211,4323,8517,2211,2211,4291,6403,2178,6371,27435,29548,29548,23209,14823,25322,31627,35821,37999,35822,27435,27402,33773,151},
{52922,52890,52890,50809,50777,50809,50777,50809,50809,50809,50809,52890,52890,52890,50841,50841,50841,52890,50809,50841,52890,52890,52857,52857,52857,52890,52857,52889,52890,52890,50809,50809,52857,52857,50809,50809,50809,50809,50809,50809,52857,50777,40212,10696,10729,10761,10761,10697,8649,8649,12809,16970,21196,19115,17002,17003,14922,17002,14922,17002,17002,17002,17035,16970,14922,14889,14857,12809,14857,14889,12809,12809,12841,12809,12809,12777,12809,12809,12777,12776,12776,12777,12776,12809,12776,12776,12776,12776,12776,12809,12808,14857,12809,14857,12776,12809,12777,14857,12776,12776,12808,12776,12776,12809,12776,10696,10696,12776,16937,12776,10695,12743,12744,12776,12744,12744,10663,21130,33774,25323,25356,21163,16937,18920,18887,18920,21033,18952,10598,25388,42259,14824,10663,8550,6470,8550,8550,18985,25258,23242,33642,23176,8549,21062,46351,42094,39949,37965,21159,21161,31661,33741,25257,21064,23208,25289,14791,8517,4356,2244,4292,6404,25355,33742,35789,44240,33741,27370,35821,35853,33676,31530,42095,59130,40112,25289,42257,40079,42192,35886,27435,16968,10663,10662,10663,10663,23274,33774,8517,6437,12743,29548,29548,14856,8517,10662,29581,33774,37966,46320,40014,31563,18983,14790,10662,16968,19082,14888,14888,14856,19079,19046,16933,10628,8516,6403,10628,6403,4291,4291,4291,2211,2211,6436,14886,10629,8452,27435,29548,29515,25322,14790,21128,35854,37934,37999,37934,29515,27435,31692,95},
{52889,50809,50809,50777,50777,50777,50777,50809,50809,50809,50841,50809,50809,52890,50841,50841,50809,50809,50809,52890,52890,52890,52889,52889,52857,50809,52857,52889,52889,52889,50809,50809,50809,52857,50809,50809,50809,50809,50809,50809,50809,50776,48631,29583,19083,10729,8616,8649,8649,10729,12810,12809,12776,21195,23276,19082,17002,17002,16970,19050,19083,17002,19083,16970,16969,17002,16970,14889,14922,14889,14857,14889,12809,12776,12776,12776,14889,12777,12809,12776,12777,12776,12808,16969,16937,16969,16937,16969,16970,14857,12776,12776,12776,12776,12776,14857,16969,16969,14856,16937,16969,14889,12744,14856,14856,14856,14856,12808,12776,12743,12743,14824,14857,12776,12744,10663,8583,16937,33742,25323,25324,23243,21130,18985,16774,14694,16774,16839,14759,25421,40211,12743,8582,6502,6470,6502,8550,12711,16904,19081,27369,27434,12742,27400,58864,48334,44076,40045,21159,19047,29548,33708,42159,44240,42159,40046,23242,8550,6437,4324,2243,8484,29548,27371,31563,40079,35853,27402,25289,25225,25289,42127,46385,50611,27435,23209,42193,37966,44337,44337,42224,33806,10598,10663,14856,12743,19048,31628,14823,12711,16935,31660,35886,25355,12743,10597,12742,33773,42159,29483,21097,10597,4356,6437,6437,4357,10663,14921,16969,21162,25386,23239,16933,14885,14822,8548,14886,10629,6403,4291,4323,4291,4259,6404,19079,12709,6339,27402,29548,29548,25354,14789,16935,29548,29515,27467,27435,29515,29515,33773,144},
{52890,50809,50841,50809,50777,50777,50809,52890,50809,50809,50809,50809,50809,50841,52890,50809,50809,52890,52922,50841,52890,52890,52857,52857,50809,50809,52857,52857,52857,50809,50841,50777,50809,50809,50809,50809,50809,50809,52857,50809,50809,52857,52890,46518,40179,35953,25421,17002,8616,8616,12809,12809,10696,10696,23308,25388,29582,29549,31694,27436,27469,27469,25388,27437,27501,27436,27469,27436,25356,27469,27436,27436,27437,25388,25388,27436,25356,25356,25388,25356,27436,25356,23275,27436,27436,25355,27436,27436,25355,25323,23275,25355,25323,23242,25323,25355,23275,25355,25323,23242,25323,23210,21162,23275,23243,23243,23243,21162,21130,21162,21130,21130,21162,21129,21130,21130,19017,25290,33742,23243,23243,23211,23243,21033,12614,12614,16807,16807,12646,27469,40211,12776,12776,6502,6502,6502,6437,4389,8582,19081,19080,21160,16967,35786,50445,42030,48432,35852,14853,23208,29547,31628,35821,44304,48499,46353,16936,4356,6437,4292,8550,19049,33774,29516,40047,44240,37933,27370,27402,29515,42225,50579,50547,44272,21064,27435,40112,35854,42224,44305,44370,37999,16936,10630,21129,29548,35821,42127,44273,42192,25354,31660,33774,19048,29581,29548,23243,25355,25290,25290,21097,10695,8550,12776,10662,6437,10663,14888,16937,19081,16936,21127,16966,14821,14821,10628,12708,16966,8580,4355,4355,6404,6371,8549,14821,10629,6371,27435,29548,29548,25322,10629,16902,29548,29515,29548,29515,29515,29515,29515,66},
{52890,50809,52890,50809,50777,50809,50777,50809,50809,52890,52890,50809,50809,50809,50809,50809,50841,52890,52890,52890,52890,52890,52857,52857,52857,52857,52889,52889,52857,50809,50809,50809,50809,50809,50809,50777,50809,50809,50809,50809,50809,52857,52922,42293,33872,42259,42291,42260,33840,25389,19083,16970,16969,16937,14889,14857,23340,25356,23243,14856,14889,14889,12809,14889,16969,14857,14889,14889,14857,16937,14889,14888,16969,16937,16969,17002,16969,16969,17002,14889,17002,17002,14889,17001,16969,16936,19050,19050,19017,19017,16969,19049,19082,19050,19082,19082,16969,21162,21130,19049,21162,21130,19050,21162,21130,19049,21163,21130,21130,21162,21130,21129,23242,21130,21162,21162,21130,33710,31661,23275,23275,21163,23210,18952,16775,14694,16774,16807,12646,27501,42292,16937,10663,6502,6470,6470,6437,4389,14888,25419,25385,23305,12773,35820,46320,42095,50545,42126,19014,27433,42160,33774,27436,31596,31661,31661,19049,14856,14888,12743,14857,16905,27436,31595,42094,40014,35821,27370,29515,40079,25257,33643,42094,37933,19016,31660,37934,37934,42192,42192,44337,44272,42192,33806,27435,33740,42159,46352,42127,33708,25290,31660,31661,23209,31629,29548,23274,23274,25322,29548,31660,10630,8518,12743,10630,6437,10630,14856,14888,12743,10662,23208,16933,19079,19047,16966,16902,19078,14853,10660,8516,10629,16935,10629,16934,12709,2178,23209,29515,29547,21128,8516,14790,29515,29515,29548,29515,29515,29515,27435,62},
{52890,50809,50841,50809,50777,50809,50809,50809,50809,52890,52890,52857,52858,50809,52890,50809,52890,52922,52890,52890,52890,52889,52889,52889,52890,52857,52889,52890,52857,50809,50809,50809,50777,50777,50777,50809,50809,50809,50809,50777,50777,50809,42358,36018,38098,42259,40178,42259,42227,42259,44307,40113,35887,29581,19083,10696,10696,10664,10696,8616,8648,8616,8615,8648,8616,8616,8648,8616,8616,8615,8615,8616,10696,8615,10696,8616,8615,8615,8615,8583,8616,8616,8583,8583,8583,8583,8616,10696,8615,8583,8583,8615,10664,8615,8615,8615,8615,10663,8615,8615,8615,8615,8583,10663,8583,8583,10663,8615,8583,8583,8583,8583,8583,8550,8583,8615,8583,16937,31694,23243,25324,23243,25388,21097,16742,16775,18888,16807,12646,27501,42324,19082,10663,6470,6502,6469,6437,4389,10663,23273,25384,23272,21127,40013,44271,44271,48464,35885,16902,37966,59163,44242,27469,21162,21130,19017,19081,16936,19050,17001,12744,14824,12710,25322,42159,40047,37935,25289,31595,37901,21032,27338,42126,33708,21064,42224,44337,46418,42159,42159,46450,31692,21095,35886,37999,42224,31628,31596,29515,29515,33773,42193,35887,29548,31628,29548,19015,6435,2178,14822,37967,33774,25387,16968,12710,8517,8550,14856,19049,27500,25387,25322,27466,25353,19046,19079,16934,14821,19079,19047,14853,14821,23273,16934,14854,6403,2146,21096,29547,29515,23240,14757,18983,29548,27467,27467,29515,29548,31628,23209,56},
{52890,50809,50809,50809,50777,50809,50810,50809,52889,52889,52889,52889,52890,52890,52890,52889,52889,52890,52889,52889,52857,52857,52889,52889,52857,50809,52857,52857,52890,50809,50841,50809,50809,50809,50809,42357,42357,48663,46551,44470,46518,46583,33873,38098,46517,48598,42291,42259,40178,42259,44371,40081,19050,10696,10664,12777,12809,12809,12777,12777,12809,12777,10728,12776,12809,12776,12777,10728,10728,10696,10696,10696,10696,10696,10696,10728,10696,10696,10696,8615,10696,8616,8616,10696,10696,12776,10696,10696,10696,10663,10664,10696,10728,10696,10663,10663,10696,10663,12809,10696,10663,10663,10663,10663,10663,10663,10663,8615,8583,10663,8583,8583,8583,8583,8583,8615,8583,19017,31661,21162,23243,23275,21162,23178,14662,14662,16775,16807,12646,27501,44372,16936,10630,6470,8582,8582,8614,12775,12743,27467,31692,27466,25322,42127,48497,50545,48464,31626,25287,46419,61309,46356,29550,25356,23275,23275,23275,21195,21163,19114,14856,16969,12743,25322,42095,39982,44241,29515,42160,42160,21064,27370,33708,16805,16838,37999,44304,42192,42191,44272,37998,14852,10628,33805,46418,44338,31628,29483,29515,27370,16903,27500,23307,19049,23274,16903,12774,8548,4323,29612,40112,40112,40112,40080,35919,31693,23242,16936,25355,33774,31629,27467,29483,27402,16935,8549,8549,12709,19047,21191,21127,14822,16902,19079,12709,6404,4323,21096,29580,27434,33740,35886,42193,31660,27467,29515,29515,29515,31660,40079,152},
{52890,50809,50841,50809,50777,50809,50809,50809,52890,52889,52889,52857,52889,54970,52890,52889,52889,52889,52890,52889,52857,52889,52889,52857,52890,50809,52890,52857,50809,52857,50841,50809,50809,50809,50841,44438,42357,48631,46583,46550,46582,48631,44437,44436,46517,46485,44372,42259,40178,42226,44371,35920,10631,10663,14921,21228,19050,16969,14889,16937,16969,16969,16969,16937,16937,16970,14889,14889,14889,12808,12809,12776,12776,12744,12776,12776,12777,10696,12744,10696,10696,10696,12776,12776,14856,16937,16937,14857,16905,14856,14824,14824,12744,12776,12776,12776,14889,14824,17002,14857,12776,12744,12743,12776,12776,12744,12744,10663,10663,12744,12744,12744,12776,12776,8582,8583,8583,19017,31694,21162,23243,25356,19049,25258,14630,12581,12582,12582,12646,29581,46517,25355,19049,19050,14824,14888,12775,19081,12742,21097,23242,27466,23175,46386,54869,48464,48465,42159,42127,50645,59195,44308,27469,19049,23210,21130,21162,19049,21130,21130,23210,25387,25323,33741,46385,37902,42159,29482,33709,33709,31596,37934,25224,14661,12678,19049,40144,42192,42192,46418,25322,12774,12806,25354,40112,35886,25322,29515,27402,27435,16904,10630,8517,8550,14855,6436,10661,12773,6468,14790,33806,40144,40079,40079,40079,40111,35919,19016,25387,27435,29516,31628,29548,31661,25354,16903,10629,14822,14789,16902,16934,12709,12709,12677,10629,6436,6404,19016,29547,23208,25288,25352,23240,27467,29548,29548,29515,29515,27403,16936,68},
{52890,50841,50809,50809,50809,50809,50809,50809,52889,54969,54969,54937,54937,54937,52889,52889,52889,52889,54970,52889,52857,52889,52889,50809,50809,50809,50809,52857,52857,52890,50809,50809,50809,50809,50809,50809,50809,50809,50809,50744,50744,50776,48631,42292,38066,44437,40179,38131,40179,40146,44306,35887,23243,29647,35953,38065,40081,37967,40080,37967,37968,38000,38000,38000,35920,35887,35888,33807,33807,35887,35888,33774,33775,31694,31694,33774,31662,31629,31661,29516,29581,31661,29516,31629,31661,29516,31629,31629,29549,31596,29548,29483,29548,29516,29516,29548,27435,27468,29549,27404,27436,27436,27403,27435,27403,25323,25355,25323,25323,25323,25290,23274,25355,25290,21161,25322,23242,27436,31630,21195,23275,25388,19049,23145,14630,14663,14662,12582,14727,31661,46484,23242,12775,12744,8551,10663,8582,10663,8550,14824,21194,29579,23175,48498,52723,48432,31626,18982,40080,48499,59130,46388,29582,21194,23210,19049,21130,19082,19082,21162,16936,19081,16903,33773,42192,35853,44304,29450,29482,37966,35821,42095,35820,16773,12678,10630,27467,42224,40079,35854,12743,8582,6468,10629,37934,40047,29548,27402,27403,29548,14791,6469,6470,8550,8581,4323,6436,10693,8580,6468,12709,35918,35918,31660,40112,38031,29580,16936,17001,16968,27467,44338,31693,42225,44370,44305,40079,33773,40112,42225,40079,40015,40046,33741,14791,12710,14823,23274,25354,25321,19014,21127,19046,27402,29516,29515,29515,29516,21129,8517,42},
{52922,52922,50809,50809,50809,50809,50809,50809,52890,54970,54970,54937,54969,54937,54937,54969,54937,54970,54937,54937,52857,52889,52890,50809,50809,50809,50809,52857,52857,50809,50809,50809,50809,50841,50809,50809,52889,50809,50809,50809,50809,52857,50809,48631,44372,38098,29647,31825,40276,42259,44306,42193,38033,38065,40113,38033,44306,44306,46386,42225,44338,44338,42226,42226,44306,40080,38000,37967,35855,37967,37967,35855,37968,35855,35822,37935,35822,35822,35854,33709,33742,33806,31661,35822,33774,31628,33773,35854,33741,35854,35854,31660,35886,35822,33741,35886,33741,33741,35855,33710,33774,35887,33741,35822,37934,33709,35822,35822,33709,37903,35790,33709,35821,33741,31660,35821,35854,40080,27468,21163,23275,25388,19049,23145,12549,14630,14630,14662,18887,33774,48597,21194,10695,8550,8550,8583,8551,8550,6470,10695,21162,29580,21095,46351,50577,46319,29513,19015,37966,48499,59163,44307,29582,23275,21162,19049,21162,19049,19050,16969,12743,16969,14824,33774,37966,33708,44272,29450,31595,37966,29515,31530,44239,31562,12677,10631,12743,35918,27401,21096,12743,10661,8581,10629,35821,42127,29483,27403,29516,31628,23210,16936,10663,10630,10662,4323,6436,10661,8612,8580,6468,14822,16968,12710,25354,23242,14822,16936,16969,16936,19081,31693,37999,44337,44305,44337,44305,48531,52724,50643,54837,52756,54804,31629,14791,12743,14823,21161,25322,27402,23208,18982,16934,27434,29515,29516,27435,29515,16904,10630,48},
{52890,50841,50809,50809,50809,50841,50809,50809,50809,54937,54937,54969,54969,54970,54969,54937,54937,54969,54969,54937,52889,52889,52857,50809,52857,52890,52890,52890,52857,50809,50809,50841,50809,50809,50809,50809,50809,50809,50809,50809,52857,50809,50809,50776,46517,38066,29647,33971,38163,40243,44339,37999,31693,31726,33775,33808,31726,29548,46386,37967,37999,37999,37967,35887,37967,37967,35887,33806,31661,33774,33742,31661,33742,31661,31629,33742,31629,31629,31629,29516,29516,29581,27468,29548,31629,29483,29548,31629,27435,31629,29548,27435,29548,29516,29516,31628,27435,27403,29517,27436,27403,29516,27403,29483,29548,25323,27435,29516,27402,29516,29483,25322,29483,27435,25322,29515,33709,35822,27436,21130,23243,25323,19049,25194,12549,14630,12549,14662,18920,33774,44404,25420,10695,10663,8583,8583,8551,8550,6470,12776,21194,25387,29515,44207,46320,48466,37967,14823,37933,48531,57082,38033,29614,27468,25355,25356,25355,25323,23275,21163,14888,21162,27435,37967,42193,40080,44273,31564,27402,23209,18983,33708,44207,42159,27369,19017,12743,21128,29579,31693,37967,21128,12741,14886,23241,23241,25322,29516,29548,31629,18984,19049,29581,37934,29515,6436,6436,8516,8580,10660,10661,8549,6437,8550,16968,12742,19081,17001,16969,16969,19049,16903,40111,44337,44305,44337,44305,46418,46418,46418,52691,52724,44273,14790,21129,18984,21129,16936,25387,27434,27435,21160,19014,25354,31628,25354,23177,27403,23241,23209,85},
{52889,50809,50809,50841,50809,50809,50809,50777,52889,52890,54970,54937,54937,54969,54970,54937,54937,52889,54969,52889,52857,52889,52889,50809,52889,52890,52857,52857,52890,50809,50777,50809,50809,50809,50809,50809,52857,50809,50809,50777,50809,50809,50809,50809,52857,44404,38065,36051,38196,44437,44468,44372,35920,35953,31662,29582,21130,14790,46354,35887,33774,35854,33806,33774,33774,35855,35887,35855,31694,33774,33742,31661,33742,31694,29549,31661,31629,31629,31661,27468,27468,29581,27436,29516,31629,29484,29516,29548,27435,29548,29548,27435,29548,31596,29516,31597,29548,27403,31629,29549,27403,29516,27403,27371,29548,27403,27403,29516,27435,27403,29516,27370,27435,29516,27370,29451,33741,35789,27436,21162,25323,25356,19049,25194,14597,14629,14597,16677,20967,33775,46517,25388,10630,10663,8583,8583,8550,14856,25226,25258,25388,16935,23177,41964,35723,42193,19049,12711,35853,52758,54936,35855,29614,23275,23210,25355,21130,21162,19049,16969,10630,19049,29548,38000,38000,40080,44305,29450,25290,27370,31629,42126,42126,42158,40013,35788,40112,33773,31628,29580,23241,19081,6436,4387,4291,8484,27435,29548,27435,29516,19049,8517,19016,35854,27466,8580,6468,8548,8548,10661,12774,10629,10630,12775,12742,8516,6404,12775,19049,19049,14856,23210,44337,44337,44337,44305,40079,37868,46352,46352,44239,44239,42159,33805,37967,42160,35854,14790,27467,29548,31628,23241,14853,23241,27435,37967,40080,40111,42192,29547,78},
{52890,52889,50809,52890,52890,50809,50841,50809,50809,50842,52889,50809,52889,52889,54970,54970,54937,54937,54937,54937,52889,52857,50809,50809,50809,52857,52857,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,52857,52857,52857,52890,50777,38098,35985,31857,38164,42324,42356,44404,40179,40146,38000,35952,38032,35919,46354,40080,40080,40080,38000,40080,40081,33806,33774,33774,33742,33774,33742,31661,31661,29581,29516,31661,31629,29516,31629,27468,27468,29581,27468,27436,29548,27436,29516,29548,27435,29483,31629,27435,29548,31629,31596,29548,31596,27402,31662,33710,27403,29515,27435,27403,29516,27468,27403,29548,27435,27370,29516,27403,27402,29516,27370,27403,35854,35821,27436,21162,23275,25324,21130,27209,20676,20741,20741,20741,25063,35920,46485,23243,10631,8583,8583,10631,8551,10663,12710,23210,21161,19016,31595,42062,44273,31596,12711,12743,37967,57082,50678,46452,38001,27502,27469,27501,27501,27469,25389,23243,14889,21130,31661,35919,31596,33676,46386,29515,27402,37934,40015,42158,42158,42126,42126,39981,40046,29580,8516,8516,6404,6436,4324,2275,4324,14790,27435,29516,29515,16968,8518,6469,6470,8517,8580,10661,8580,8581,6468,8516,23241,31660,33773,23241,12774,6436,4355,14856,19049,16936,12742,33806,44337,44304,44337,44304,44337,48531,48531,52789,50643,50611,44337,46417,44337,44305,40112,33741,35853,40079,40080,27435,14854,23209,29548,29516,29515,18983,23209,14823,37},
{52890,52857,50809,50841,50809,50809,52890,50809,50809,50809,52890,52890,50809,50809,52890,52890,54969,54937,52889,52889,52889,52857,52857,52890,52857,52889,52890,52890,52857,52890,50809,50809,50809,50809,50809,50809,50809,50809,50809,52857,52890,50809,52889,50776,48663,46550,48631,38196,38163,44437,44436,44468,44469,44469,44436,42324,44339,42193,44306,42160,42193,42193,42193,40113,42226,38032,35920,35919,35887,37968,35887,33774,33774,33774,31693,35855,35855,33710,33774,31661,31628,33742,31629,29548,33742,31629,31629,33742,31597,31564,33742,31629,31597,33709,31532,31564,33677,29483,31629,31597,29451,29515,31596,29451,29548,29516,27402,29515,29515,27402,29516,29483,27370,29516,29483,29482,37934,33740,27435,21130,23275,23243,21130,31272,26820,26852,26820,26884,29191,35887,48598,25388,10663,8583,8583,8615,8583,8583,6470,23242,19016,10597,33675,48400,54773,35854,27436,25356,38001,57082,52791,44339,23178,19050,23243,25389,25389,25389,25356,23276,14857,21163,31693,37967,35854,35854,46386,31595,29450,37869,37933,44239,42158,42126,42126,33707,12677,8516,8549,4355,6436,4355,6436,4356,4324,14823,29516,29516,27467,10630,8550,21162,14823,10630,8548,8612,8613,8548,6500,8548,14854,37966,40079,25322,12741,8581,6468,14856,19082,25388,25387,42257,44337,44305,44337,44272,48498,52692,50643,52756,50611,46450,44305,40079,35853,31660,42224,46450,42192,25321,23177,16903,14822,19048,29548,29516,27435,12743,12743,8550,40},
{52857,52857,50809,50809,50809,50809,52890,52890,50841,50841,50809,50841,50841,52890,52890,52889,52889,52889,52857,52889,52890,52889,52857,52890,52857,52857,52857,50809,50809,52890,50809,50809,50841,50809,50809,50809,52857,52857,50809,52857,52857,52857,52857,42324,42324,46550,46550,40276,38163,42356,42356,42356,42356,42356,42356,42357,42292,40211,44372,42291,42291,42291,42323,40178,42291,40211,40211,40179,38066,35985,35985,33872,33873,35953,33840,35953,33872,33808,33840,33840,33807,33840,33839,33807,33840,33807,31727,33839,33775,33774,33808,33775,31694,35887,42160,42192,44338,44306,42193,42161,42193,42193,44273,42160,40080,38000,40112,37999,35854,42094,37934,35822,33709,35821,37870,33741,40047,31628,25355,21130,23275,23243,25258,33223,32931,32995,32963,32995,33351,35887,50679,27437,10663,8583,8583,8583,8583,8583,8550,23274,21160,12806,31627,44239,48464,50644,40080,29581,38001,54936,57016,48501,21129,16936,19082,21162,25388,19050,23243,16970,10631,16969,21130,29549,29483,35821,46451,35789,35821,42128,40014,42159,42126,42126,37933,14789,6435,8581,6500,8580,8612,10693,10661,6436,6469,12743,27435,27435,21097,10566,16936,35887,29580,23274,14887,8548,6468,8548,6468,8581,10629,29580,44338,29547,10661,8613,8581,14823,19049,31726,37999,40111,44337,44305,44304,46417,48531,52724,52756,52756,50611,35853,31628,29515,27435,29547,31660,42192,44305,33708,35854,33741,18983,19016,29515,29516,23241,10630,10630,8582,39},
{52889,52890,50809,50809,50809,52890,50809,50809,50809,50809,52890,50841,50841,50809,50809,50809,52890,52890,52889,52889,52889,52889,52857,52889,50809,52857,52857,52857,50809,50809,50809,50809,50809,50809,50777,52857,52857,52857,50809,50809,50809,52857,52889,48696,48663,50744,50744,40277,38163,44437,44437,42388,42324,42356,42356,44469,42389,42356,44437,42388,42389,42356,42389,40276,42357,38164,38164,33970,33970,31793,33938,27632,29745,29744,27599,27632,27599,27599,27599,29648,29647,27567,25486,25486,25486,25454,25454,25422,25421,25389,25389,25389,23308,25388,42193,48564,50710,50678,48597,46451,48597,50677,50677,48629,46484,44339,50678,42194,33742,52692,40015,35757,35757,35757,33709,25321,23241,27434,25355,21130,23275,25324,27371,35173,39139,37091,37091,39171,39657,38000,52792,27469,10663,8582,8550,8583,6470,8583,16969,23241,19079,12774,29547,44239,50578,50677,44306,33742,42194,52790,46386,46387,21129,14856,21162,27501,27534,25389,25356,21163,14824,12743,12744,14857,18919,33709,42225,31595,31628,40015,31595,33708,42159,40046,31660,16934,14884,14917,12805,16998,16966,12773,19079,12742,6405,12743,29516,29548,25322,29548,31693,35854,33806,16903,6404,6468,6468,6468,6437,6469,6437,10597,35854,33806,16934,10660,14854,23275,27468,29612,33741,23209,29548,44338,44337,52789,50676,52757,54870,54869,48498,31628,29548,29548,29548,29548,29547,27434,40079,33708,35853,33741,21129,23242,25354,21096,21097,12743,10662,10630,38},
{52890,52890,50809,50809,50809,50809,50809,50809,50841,50809,50841,50841,50841,50809,50809,52890,50809,52857,52889,52857,52889,52889,52889,52889,52857,50809,52857,52890,52890,50809,50809,50809,50809,50809,50809,52858,50809,52857,52857,52857,50809,52889,52857,52857,52857,50809,52890,40277,38131,42356,42356,42356,42324,40276,42324,42356,42356,42324,42324,40243,42323,42324,42356,38163,38196,38164,36051,33938,31857,31825,33906,27600,27632,27632,25487,27567,25487,27600,27567,25486,27534,25486,25454,25454,25422,25422,25454,25422,23341,23341,23341,23341,23276,21195,37968,48564,48630,48630,48597,42291,46516,48565,48597,48597,48565,46484,48565,40081,31629,48530,37902,33709,33709,35757,31628,23241,19080,25386,27468,23243,25388,27436,29451,39301,41218,41218,41251,41315,41802,38000,50679,29549,10630,8582,8550,8583,8550,8582,10662,21161,19048,10629,31661,52789,46352,35854,40080,35822,46387,48500,35854,31629,21162,19017,21162,25388,27469,25389,23276,21163,21131,21195,14889,16970,16774,27338,42160,33676,29450,35756,33708,23176,40046,35788,27369,23240,19110,14852,19078,16933,23240,27434,31595,31595,23210,21129,27403,33708,35789,29548,25322,37999,29547,8580,6469,23242,19081,8549,6437,6405,8517,12678,12645,23209,21128,12774,10660,21161,27468,27467,21097,10598,8549,29580,42225,42160,42192,44305,40079,44272,44337,33741,29516,29515,29548,29547,29548,25289,29548,25354,29515,29548,21129,21161,44305,31595,35854,19016,8550,8550,35},
{52890,52890,50809,50809,50809,50809,50809,52890,50809,50809,50809,50809,50809,50841,50809,52890,50809,50809,52889,52857,52889,52889,52889,52857,52857,52857,52890,52890,52857,50809,50809,50809,50809,50809,50809,50777,50809,52889,52889,50809,52857,52857,50809,50809,50809,52889,52890,40309,40244,42388,42356,44437,44437,42388,44437,42388,42357,42356,44437,42356,42356,42356,42389,40243,40277,38132,36051,36051,33938,31825,33938,29713,29712,31792,27631,27632,29680,29680,27567,25486,25486,27535,25486,27567,27567,25486,25454,27534,25454,25454,25421,25421,23308,23276,25421,31694,31694,29581,42226,38033,38033,35887,35920,35887,38001,38065,40146,37968,37934,50578,37902,35789,33709,31661,27499,25385,21192,25386,27468,23275,25355,25388,25128,41219,43234,43234,43331,43427,37674,42194,52824,33775,16904,8582,8550,8583,6470,10663,27468,27499,29580,29548,44338,54838,35821,25290,35854,23242,25322,40080,37966,25322,21130,21130,23243,27501,29582,29582,27502,27501,25356,27501,19083,17002,14694,23112,35853,31595,29450,40014,37966,23144,27370,31563,23209,25289,21127,19046,19046,19047,25353,23209,35853,48498,46418,33741,35821,44304,46386,16968,10630,33806,23241,8548,10629,31726,31693,8517,6405,8518,12743,12710,12678,19016,21064,19015,12709,12742,19016,21129,12775,8550,10630,21129,33774,21064,21064,29547,16838,31628,46450,31660,27435,29548,29547,29548,29547,25321,25322,25290,29548,29515,21096,19016,40112,29547,35821,27403,12710,14855,59},
{52890,52890,50809,50809,50809,50809,50841,50841,52890,52890,50841,50809,52890,50841,50809,50841,50841,50809,52889,52889,52857,52889,52889,52857,52857,52890,52890,52857,50809,52857,50809,50809,50809,52857,50809,50809,52857,52857,50809,52857,52857,50809,52857,52889,52889,52857,52857,50777,50776,50776,50776,50744,50776,50744,50776,48696,50744,50776,50776,50744,50744,48664,44471,42422,42390,38197,36116,36084,36052,31891,29810,29778,31858,31858,31826,31858,33971,31858,31825,31793,29680,27567,21261,21294,21261,21228,21261,21293,21261,23341,21293,21261,21228,21228,23276,31694,25388,21130,40146,35889,31728,27469,27469,25389,25356,23308,25421,23275,35822,48466,35756,33677,33709,29548,23305,19112,12806,25354,25388,21163,23275,23275,29355,35270,35237,39463,50093,43786,37772,50678,48565,37968,25290,10662,8583,8550,10630,10630,23210,19048,14887,19048,37901,40046,25290,25323,31629,19049,16969,35822,42191,31628,21162,19049,21130,27469,25388,27501,25389,25388,21163,27469,19050,19082,16774,23112,40080,29483,27370,29418,27369,21032,29516,25257,25290,21064,12580,16870,25353,27467,27434,14823,14791,25322,31660,23175,37998,44272,25289,12710,6469,19048,16967,8548,8548,6468,6468,6437,10598,16936,10597,14856,21162,25355,33773,35886,16903,14823,21129,16968,10630,8614,10662,21097,27435,19016,21097,25322,12743,16903,38032,33741,27435,29548,29515,29547,29548,23177,14790,23209,29548,33741,27369,33773,40079,14823,14822,42225,40144,35886,116},
{52890,52890,52890,50841,50841,50809,50809,50809,50809,50841,50809,50809,52890,50841,52890,52890,52889,52857,52857,52889,52889,52889,52889,52857,52889,52889,50809,50809,50809,50809,50809,50809,50809,50777,52857,52857,52857,52857,52857,52857,52857,52857,52857,52857,52857,52889,50809,50809,50809,52889,50809,50809,52857,52857,52857,50809,50809,50809,52857,50809,52857,50777,44503,44503,42423,38230,36149,36117,36116,31923,27730,29778,31891,33971,31858,38131,36084,31890,29712,31793,33874,27567,14955,14987,14987,14955,14955,14987,14955,14988,14988,14987,14955,27534,31662,37967,31726,27468,37968,31727,31695,27501,25421,25389,25356,23308,25422,23243,33709,46321,33644,33644,33644,31629,21193,14919,10694,21161,25323,21130,23243,23243,23243,25323,25291,33710,54904,37903,31596,54904,48598,38032,33708,19049,8550,14856,27468,21130,21129,16935,16967,16935,35820,37965,21128,23243,29581,21130,12743,31628,44241,29548,21130,21162,21162,29614,29615,29615,29582,29615,27502,27470,23276,21163,14758,16838,31629,25258,29450,29483,27402,21065,27370,25257,25322,27402,29515,31661,31693,27435,23242,10598,8549,21128,27434,19014,37966,44304,42192,35854,25322,14854,8548,8580,6468,10629,16935,6437,16936,27468,14791,12710,16969,19017,25355,27402,25322,25355,25322,27468,19049,14823,10630,18983,21096,21096,21097,12743,10630,10630,21129,29548,29547,29547,29515,29515,29515,29580,29515,27435,29548,33773,35853,31660,37967,16936,27467,46450,46418,46418,176},
{52857,50809,50841,50809,50809,52890,52889,50809,50809,50809,50809,50809,50809,52890,52890,52890,52890,52857,52857,52857,52857,52857,52857,52889,52857,52857,52857,50809,50809,50809,50841,52857,50809,52857,52890,52889,50809,52857,50809,50809,50809,50809,52857,52857,52857,52857,50777,50809,52857,52857,50809,52857,50809,50809,52857,52857,50809,50809,50777,50809,52857,48696,44503,44503,40342,38229,36117,36117,36084,36084,27730,29778,31891,31890,33938,44405,38132,29777,27664,27600,46550,36019,14955,12907,14987,14955,14988,14955,14987,14987,14988,14988,14955,38034,44305,42128,42226,48597,42258,33775,31727,27502,27469,27501,27469,23308,25422,21163,35854,44208,33644,33676,33676,25322,21225,19112,12775,21194,25355,21163,23243,23243,23243,23276,23243,31694,52791,38032,35822,52791,48597,42258,33741,23210,21098,29516,31628,21065,23242,16935,12806,16935,40013,35820,16935,23275,40113,23275,16936,33676,44241,23210,21130,19049,19081,27501,27469,29582,25388,31695,25356,27502,21163,21163,16839,27403,33742,23145,29450,31595,40046,31596,25289,27370,27370,27402,27402,35854,44337,31661,14823,10630,16999,16966,29611,29547,37934,37966,23176,35854,42224,21127,8579,8580,8580,14854,29581,10598,6437,12743,19049,12742,8517,8517,21161,27402,23209,16903,31660,42225,40144,37999,33741,37934,42192,37934,16871,8550,10630,10630,16968,27468,29548,29580,33709,35854,37966,42224,48531,33773,29515,29515,27402,12709,25322,25354,40144,44369,44337,44305,184},
{52890,52857,50809,50841,50809,52890,50809,50809,50841,50809,50841,52890,50841,50809,50809,52857,52857,52890,52857,52857,52857,52857,52857,50809,52857,52889,50809,50809,50809,52890,50809,52857,52857,52857,52857,52857,50809,52857,50809,52857,52889,50809,52857,52889,50809,50809,52857,52857,50809,50777,50809,52857,52857,50809,50809,50777,50809,50777,50776,50809,50777,48696,44471,42423,40342,38197,36084,36084,34003,38229,29746,29778,29811,31891,36019,38131,38164,36019,31858,29680,44437,42357,17100,15020,14988,17068,17068,14988,14988,17068,15020,14987,12875,23341,31694,33774,42291,48598,42226,31695,31695,29549,27469,29549,29549,25388,25422,21196,27436,29484,29484,27404,27436,14888,21226,21226,17001,23274,25356,23243,25355,25356,25356,23276,23275,31694,54904,42226,40080,52823,50646,44306,35822,25355,27404,38000,35919,35887,37967,25354,19047,21095,44272,33772,21161,23243,31661,21130,16936,37934,46419,25323,21162,21129,21129,27501,25389,29582,25356,29614,25356,27502,19082,19114,18984,35887,40145,33741,33675,40013,40014,29482,33676,33675,31627,27402,21096,37999,42225,35886,12743,14823,21127,23239,29546,40079,37967,29515,12710,16936,35886,16965,10725,10692,10692,8580,6404,8550,4357,6405,4356,8550,12678,10630,21129,25322,16968,12742,35919,40080,40112,40112,44337,50643,48499,44305,35919,27500,21129,14791,16903,31693,37999,40079,37966,35821,31628,25289,42193,35886,29515,29548,27435,16903,21128,37999,46450,44337,44337,46418,175},
{52890,50809,50809,50809,52890,50809,50841,50809,50809,50809,50841,50809,50809,50809,50809,52890,52857,54937,52857,54937,52889,52857,52857,50809,52857,52889,52857,52889,50809,52890,50809,52857,52890,52857,52857,52857,52857,52857,50809,52857,52889,50809,52857,52857,50809,50809,52857,52857,50809,50809,50809,50809,52857,50809,50777,50777,50809,50809,50809,50809,50809,48729,44503,42423,40342,38197,36117,36084,36116,38165,29778,29778,29811,33971,38099,44372,40212,38099,31858,31825,29679,36018,23439,23407,23374,25422,25454,23406,23373,23374,23342,23374,23374,23309,27566,33839,40146,38065,40145,40145,46452,48597,48565,48533,48565,48565,29647,25389,33775,29549,29550,27469,25389,14954,21227,23339,21227,25387,23243,21195,23275,25356,25356,25356,23275,31661,52823,44338,46387,50678,52824,52758,29548,14856,19017,23243,12743,21194,33807,25322,25353,29578,46353,29514,27467,25323,40015,23274,18984,42192,48500,27436,23210,21130,21130,29614,31695,31695,27502,31663,27469,29550,21195,21163,14791,27403,46419,46418,44271,42126,31562,29450,25224,25257,21064,14791,21129,40144,40079,35853,31628,33773,27496,33739,37966,27433,31627,29515,12743,8517,21128,16901,8580,6467,12741,10662,14824,12743,6437,4357,4324,8485,25322,25387,25322,21161,8516,16936,37999,37967,37999,37999,37999,42159,42192,42256,46450,46417,44305,35854,18984,29580,35886,29547,29547,29515,27435,19016,27402,31628,29515,29515,25355,10630,16968,42225,42192,40112,44305,44369,173},
{52890,52857,50809,50841,50809,50809,52890,50809,50809,50841,50809,50809,50809,52890,52890,52889,52857,54937,54937,54969,52889,52857,52889,52857,50809,52890,52857,50809,50809,52857,52857,52857,50809,52857,52890,52889,52857,52857,50777,50809,50809,50777,52857,50809,52857,52857,50809,52857,52889,50809,52857,52857,50809,52857,52857,50777,50777,50777,52857,50809,50809,50777,44503,42423,40342,38197,36117,36084,34004,33972,29779,27698,31859,31890,38099,48532,36018,38164,29680,29712,29713,31825,29745,33938,42291,38097,36017,33872,27567,31792,31759,38065,42259,35953,33839,40177,40145,33806,33807,38000,50710,52790,52823,52823,52823,50743,29647,25356,44273,37934,35757,33709,25355,10695,17033,25387,21193,29547,25356,23275,25388,27469,27469,25389,25356,31694,52823,46451,50645,50678,54937,50613,29548,21162,21130,12743,8517,16969,33840,16969,8549,29547,40047,35820,14822,23242,46386,31694,23209,50579,44274,25291,21130,23243,23210,29582,29582,31663,27502,29582,27437,27502,23308,21163,14758,25290,42226,44305,44272,42158,50545,44174,35788,37901,23177,8550,25419,42257,44305,42159,40014,42159,35884,25320,29547,29547,25322,12743,21130,25355,21128,16966,8580,6435,23274,29613,23242,14791,6372,14790,27500,37999,31692,42224,27435,19016,6435,25419,37967,35887,35918,37999,33676,37933,42192,44305,40079,33773,31627,31628,21129,21129,29547,29515,31628,29548,23242,19016,14791,23210,27434,29548,23242,8550,10630,25355,42192,40111,37966,40078,188},
{50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,50809,50809,50809,52890,54937,54937,52889,52889,52857,52857,52857,52857,52857,52857,52857,52857,52857,50809,50809,52857,50809,50809,52857,50809,52857,52857,50809,52857,52857,52857,52857,50809,50809,52857,50809,50809,52857,50809,50809,50809,52857,52857,50777,50809,52857,50777,50777,50777,48729,42423,42423,40310,36149,36117,34004,34004,31924,29778,27666,31891,31890,38131,44339,31857,38132,31825,29712,27600,29648,33874,38099,44403,42257,38096,33904,25454,31792,31791,42258,44306,35952,25421,38097,40145,31759,33807,38001,52758,52823,52823,52791,52791,50678,31728,29582,35919,25355,25323,31629,27436,16969,19113,27466,25386,29548,25388,25388,27501,27501,27501,27501,25388,33774,50743,52726,52823,48532,57050,42193,21130,21162,31694,27500,27468,29581,33775,19049,8549,27402,40079,31627,12742,25355,46353,25323,25290,40015,29484,25323,21130,25356,21130,27501,25420,29582,23243,29582,23211,27502,21163,21163,18984,23145,23209,37934,33707,44206,40013,33675,44239,42159,27435,8550,29580,40112,33740,35853,40014,48498,54870,37999,29547,33741,16969,8550,10630,25354,29546,14852,12804,10660,10628,14822,27403,27435,38032,50644,54838,46385,23238,29578,29548,19015,14822,33806,35886,35886,35886,37966,42159,42159,40047,31628,27467,27435,29515,31628,23209,14822,21128,29548,31628,29515,19016,14823,10598,21129,29548,29515,16936,8582,10662,10630,33805,44304,46385,48530,208},
{50809,50809,50809,50809,50809,50809,52890,52890,50809,50777,50809,50809,50809,52890,50809,50809,52890,52889,52889,52857,52857,52857,52857,52857,52889,50809,52857,52857,52857,52857,52857,52857,52857,52857,50809,50809,50809,52857,52857,52857,52857,52857,52857,52857,52857,50809,52889,52857,50809,50809,50777,52857,52889,50809,50809,50809,50777,50809,50777,50777,50776,48696,44503,42423,40310,36149,36117,34036,34004,31891,29810,29778,34003,33971,38098,44339,36019,38099,31825,29745,27600,29713,33874,36018,42290,40177,38064,31824,23373,31792,33871,44338,44305,40113,25388,42291,40145,31694,31694,35920,40113,40146,46452,52790,50710,44372,27502,27502,19083,16970,17002,29614,23307,23339,25452,31759,29581,29548,23243,23243,25356,25388,25356,25356,23275,29549,50742,50645,50678,48597,57017,37935,14824,19016,25354,25386,25354,25355,31726,21194,16968,29482,27434,16934,12741,27435,40047,23210,14791,14824,21130,25355,25290,27435,25323,31662,31694,31695,27436,29582,27437,27502,23276,21163,16904,29484,31629,31627,33739,44239,33741,23209,40046,37934,21129,12711,31726,42224,40079,44337,44305,40013,40046,29515,29483,12710,6470,8550,6470,12677,21126,16997,12804,14853,12742,19048,29516,33773,46418,52757,52790,44305,23207,19078,21160,12741,19048,33806,35886,33806,35886,37966,44305,46385,35886,29515,29548,29516,29548,29548,23209,10661,21128,27370,27370,27402,16936,10630,10630,21129,29515,27403,12743,10662,10663,8550,16936,40111,44304,37933,107},
{52857,50809,50809,50809,50809,50809,50809,50809,52890,50809,50809,50809,50809,50841,50809,52889,50842,52890,52857,52890,52857,50809,52857,52889,52857,52857,52889,52857,52889,52889,52889,52857,52857,52857,52857,52857,52857,52857,52889,50809,52889,52857,50809,52857,52857,50809,52857,50809,50809,50809,50809,50809,50809,50809,50777,50777,50809,50776,50777,50809,50809,48729,42423,44471,40342,36117,34068,34036,34004,31891,34004,29778,31891,31858,36018,44307,40245,38132,29712,27632,27632,31793,33906,33905,42290,40144,40145,31759,21293,31824,31791,33839,42193,44338,48564,48597,40178,31694,29614,40146,48597,44339,46452,48597,48597,42258,31727,29615,21229,21196,27502,35953,33840,31759,23339,25387,25388,29580,19082,21162,23275,23275,23276,23276,23243,27468,50710,52758,48597,50645,56985,31596,23307,25418,19078,14854,16966,16967,31726,25354,19015,23241,29580,25353,19047,23273,40047,29516,23275,16937,19050,33742,52757,50677,50677,48532,42193,27469,21162,21162,19049,16969,14856,12776,16936,33741,25289,29547,27401,42126,31627,25258,27370,27337,19016,16904,33774,37966,33740,42257,42224,46353,48498,37934,31628,29548,23242,14791,18984,31595,25319,19045,14885,23305,31725,27467,29548,29548,29516,35821,46353,48563,35853,19014,12709,8548,10661,19015,33806,33806,35886,40112,40079,44305,37967,29547,29515,31628,31628,29515,16902,12709,23208,37934,44240,44272,23209,10598,16903,23209,27403,23209,16904,12711,8582,8582,8549,27500,42224,35820,144},
{50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,50841,50841,50841,52890,50809,52890,50809,52889,50809,52857,52857,52857,52857,52857,52889,52889,52857,52857,52889,52889,52857,52857,52857,52857,52857,52889,52857,52857,52889,52889,52857,50809,50777,50809,50809,50809,52857,52857,52889,52857,50809,50809,50809,50809,50777,50776,50777,50809,50809,48729,44471,44471,40342,36149,36117,34036,34004,34004,34004,29778,29810,31858,38098,42259,40212,44438,31825,29712,27632,31793,38099,42292,42290,40177,38064,33936,23406,31824,33872,37968,42193,44370,54904,48565,40146,31694,31726,44404,54936,54936,52855,52855,52856,46517,38066,31695,23309,21196,29614,27534,27501,25420,21192,27531,25353,31629,21195,25388,27468,25420,27468,27469,25388,31661,50711,48532,48564,52856,52758,27467,19049,23241,27498,23305,23272,25353,33806,27435,21127,31660,46450,35852,19015,14854,35854,25355,27500,16969,23178,48467,50612,46419,40080,27468,21129,16969,14889,14856,12743,10663,8582,8550,23307,27467,14821,19014,12676,29547,33708,23209,23177,21096,19016,23274,40047,42225,42225,42224,44305,50645,46450,33805,29516,33709,44304,44304,50643,37964,19046,16933,14852,12805,16967,29516,29548,31629,25257,29482,46450,50676,52757,37999,12709,8516,8580,10661,19080,33741,35886,37967,31628,40112,40079,31628,31629,29548,29547,25353,12708,10596,21127,31628,31595,31595,23209,18984,29580,25322,27403,27435,25290,23209,21161,14855,10630,12710,35853,46418,213},
{50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,50841,50841,52890,52857,50809,52890,52857,52857,52857,52857,52857,52857,52857,52857,52889,52857,52889,52857,52857,50809,50809,52857,52889,52889,52857,52889,52857,50809,50809,52857,52889,50809,52889,50809,50809,52857,52857,52857,50809,52857,50809,50809,52857,50809,50777,50777,50777,50809,48728,44503,44503,40310,36117,36084,34004,34004,36084,31923,29810,31891,31858,33938,38099,40212,46518,36018,31793,27632,31825,36051,42259,42322,40177,40145,35984,23406,31791,38097,46419,44305,46451,54969,46452,31662,25388,27501,38066,46485,46517,48565,46485,46485,42292,38034,33840,27502,25421,27501,25356,23340,21194,23305,29644,27466,31661,25355,27501,27501,27501,27501,27501,27500,31661,50743,52791,50645,54936,44339,25355,25355,23243,23274,27499,29579,29611,35919,29548,21128,37933,37965,27401,12741,12742,27436,25355,16936,18985,40018,40082,19016,16968,14856,14824,12743,10696,10663,8583,8582,8550,6501,10662,21160,14789,14789,16870,21128,40112,42128,44273,29483,21096,18984,21161,40144,42224,42225,42224,42225,27467,19015,19047,25322,29515,44304,44272,46384,19013,14885,14852,16966,12709,19016,29516,29516,29516,35854,50645,52822,52757,48531,33805,12773,8548,6468,8548,8548,14822,12709,8484,6339,12677,31693,29548,29548,29548,29547,25353,16901,10628,18983,29516,31628,44305,44305,31660,21129,19048,25323,23209,35821,42159,48531,42225,35886,25322,29547,52757,205},
{50809,50809,50809,50841,50809,50809,50809,50809,50809,50841,50809,50809,50841,52890,50841,50809,50809,50841,52890,52857,52889,52889,52889,52857,52857,52857,52857,52889,52889,52889,52857,52889,52857,52857,52857,52857,52857,50809,52889,52857,50809,50809,52857,52889,52857,52857,52857,52857,50809,50809,50809,50809,52857,50809,50777,50809,50777,50777,52857,50776,50777,48696,44503,44503,42423,36117,34036,34036,34004,31891,29779,29778,31923,31858,29745,33906,36051,42325,36051,29712,25487,31793,35986,42323,44370,40145,38097,31823,21293,29711,33936,42225,44273,48532,52888,48597,31694,23276,25421,25421,25421,25421,27501,25356,21163,23276,33873,38066,27469,31695,42259,29582,25421,21194,25386,23305,23242,33741,33709,25323,19016,23243,25323,25355,27435,31660,50710,48565,48564,57049,38000,25323,23275,23243,19050,25387,35886,31692,31660,29547,31594,37866,46353,44305,19014,14822,23243,12776,6437,29581,27436,19017,14824,12808,12744,10695,10663,10663,8550,8550,6502,6502,6469,16935,27433,23207,25256,21031,25289,35788,37901,33708,27338,19016,16936,12743,27468,42225,44305,35854,14823,12742,14886,16967,21097,37966,44272,42192,40111,19046,12772,14852,27498,29581,25323,27435,29483,29516,31596,46385,42192,25321,16934,14789,10693,6468,4356,4323,6436,6436,4291,2211,2211,2178,14790,29580,29548,29548,29515,27434,25320,16934,14757,29515,37999,44305,40144,21129,12711,10630,19016,12710,16903,18983,23209,38031,46418,44337,42159,31660,119},
{50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,50809,50809,50809,50841,50809,50809,52857,54937,54938,52857,52889,52889,52889,52889,52857,52889,52889,52857,52857,52857,52857,52857,52857,50809,52857,52857,52857,52857,52857,50809,50809,52857,50809,50809,50809,50777,50777,52857,50809,52857,52857,52857,50809,52857,50809,50777,50809,50777,50777,48729,42423,44503,40342,36117,36117,34004,31924,29778,29746,29778,31923,29777,29745,36019,33906,33906,31825,27632,25487,31793,33873,42323,44403,40177,40145,31759,25453,33872,35919,44305,42160,40081,40081,44306,35887,25356,27469,25389,23308,25421,25388,23276,19115,23276,35920,40049,23178,27468,38032,31759,31695,25388,23306,23305,25354,31628,31629,27371,14856,21130,23242,23242,23274,29547,52758,52823,48565,57017,35822,25323,23243,21162,21130,25323,42225,33773,35820,42191,48430,54637,46352,33740,35853,42192,31630,10631,8549,40048,25355,21130,19050,16969,14856,14856,12776,12776,10663,8582,6469,6501,6437,21194,40080,31594,27304,16838,25290,29482,42159,33708,23176,21064,19016,14823,12711,35886,42224,31628,16904,10662,12774,16935,10630,23242,42192,44272,37997,25351,14884,12772,12772,19047,27435,27435,29516,23176,31628,35886,16933,16934,14790,14854,6436,4323,4323,8549,8581,6436,4291,4291,4291,8549,16936,29548,29515,29516,29548,29514,27401,21095,21128,27435,33773,31660,23209,14791,14790,12743,12743,10630,8582,10630,8517,16870,35853,31627,23208,16901,47},
{50809,50809,50809,50841,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,50809,52857,54937,54969,54937,54970,52857,52889,52889,52889,52889,52889,52889,52889,52857,52857,52857,50809,50809,52857,52889,50809,50809,52857,50809,52889,52857,50809,50809,52857,50809,52857,50777,50777,50809,52857,50777,50809,52857,50809,50777,50777,50776,50777,48696,42423,42423,40310,36149,34037,31924,34004,29811,29778,31859,31890,31858,33938,33970,29745,33970,33905,31825,31825,33873,33872,46485,46517,40145,38000,31694,35921,44404,40145,42160,37870,42227,44372,44338,48564,38065,38065,35953,29647,40145,38033,35984,35952,35951,46485,44339,31695,33808,40146,31727,29646,29613,29612,27467,23241,27403,31597,27436,16936,27403,25322,27403,27467,29547,50646,50678,50678,54937,33677,27468,27436,27436,25356,25323,42226,31628,35755,50545,48464,46286,31562,21095,35886,40047,29516,21130,14856,42160,29483,23210,19082,19017,16969,14889,16968,14887,6469,6469,4389,4356,4356,21162,40145,40047,27304,16805,33676,40013,44206,42159,33708,21064,21097,14856,8583,19081,35886,37934,31661,19049,14823,23307,14823,8550,21161,44305,35917,23238,14884,12804,10692,19016,27435,29548,29516,37967,50677,35885,16933,31659,35854,23241,6436,4356,6436,12741,10693,6468,4259,4259,8582,12775,14856,29515,29515,29515,29548,27434,25321,35821,40047,27467,27467,27435,25289,31628,29515,23242,14823,8582,10663,10630,8549,10564,14757,14724,18981,25349,75},
{50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,50841,50809,50841,50809,50809,50809,52889,54969,52889,54937,52857,52857,52889,52857,52889,52889,52889,52889,52857,52857,50777,52857,52857,50809,52857,50809,52857,52857,52889,52857,52857,52857,52857,52857,52857,50809,52857,50809,52857,50809,50777,50777,50809,50809,50777,50777,50777,50777,50809,48696,42423,42455,40342,36117,34004,31924,31891,29811,29746,31891,33971,31858,34003,33938,29745,33971,33938,33938,33938,36019,33905,42292,42323,40177,40210,31792,23341,33872,35952,35920,37936,42194,38033,40112,48596,40178,38098,33872,29647,40145,38097,38065,38064,38064,46452,40146,29647,25388,33807,33775,29581,29581,31693,31692,29580,21161,25323,29515,35853,42128,40014,40047,37934,33740,48565,50678,52758,52758,33677,29581,31662,31662,31662,29549,29548,37935,46353,50512,50644,42128,37868,27433,37967,33742,27403,27436,21130,37935,52757,35887,19050,19049,19082,25421,25388,14920,6469,4389,4356,4324,4324,21162,37935,37869,33577,14660,29515,44271,42158,42158,35820,21096,21096,19016,14823,10662,29547,44337,42257,31693,29548,33708,16936,8582,10630,21159,21126,21158,19045,14884,12741,21161,27435,27436,29548,27435,16871,10598,14822,14821,19047,25321,12774,6436,10661,12709,14854,10661,12677,19016,14791,12710,12742,25355,29548,29548,29548,27467,21095,12708,14820,29547,31628,40079,42192,42192,35821,35821,25322,8550,10630,8550,10630,12709,12676,10531,16901,23269,74},
{50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,50809,52890,50841,50809,50809,52890,50841,50841,52890,52890,52889,52889,52857,52857,52889,52857,52889,52889,52889,52889,52889,52857,52825,52857,52857,50809,52857,50809,52857,52857,52857,52857,50809,50777,52857,52889,52857,50809,50777,50809,50809,50809,50777,50777,50777,50777,50777,50809,50777,50809,50809,48729,42423,42423,40342,36117,36117,34004,31891,29811,27698,29810,33971,31858,33938,31890,29777,31858,33938,33937,40244,31825,29680,31792,40177,38096,36016,29679,25421,35952,38033,29615,35888,42194,38000,37999,46483,38065,35984,40178,33872,35952,38064,38032,38032,38032,42226,48532,40113,31694,31727,33807,29614,29613,27500,27467,37966,27371,31563,44173,50546,50579,50546,50579,46352,33772,48597,48565,56984,46387,29516,23275,25323,23275,23275,23275,25355,25355,35853,44239,48499,48531,46319,46417,42224,42192,40080,27436,25291,40080,54871,31661,19082,19050,21163,29615,23308,12775,14888,6469,6469,6404,4356,16936,31597,37901,35625,14660,18918,42126,42126,42158,33740,21096,21096,23177,35887,35854,27433,27401,29580,23209,40144,37966,19049,8550,10630,21126,16932,21158,19077,14885,14853,25355,27435,27435,23177,25290,8485,16936,10597,8484,12645,31660,27499,10629,6403,10629,19048,14821,31692,44305,37999,31661,25322,27403,29580,29580,29548,29515,23207,19014,19014,27434,33741,44369,44305,42192,25322,21129,23242,14823,14791,14855,14821,19013,12740,6403,10563,21157,78},
{50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,50841,50809,50809,50809,50809,52890,50841,50841,50841,50809,52890,52889,52889,52857,52889,52889,52889,52889,52889,52889,52889,52857,52889,52890,52857,52857,52857,52857,52857,50809,50777,52857,52857,52857,50777,52857,50809,50809,50809,50809,50777,50777,50777,50777,50777,50777,50776,50777,50809,50809,52857,48729,42423,42423,40310,36117,34036,31924,31923,29811,29778,34004,34003,31858,33938,33970,31858,29745,31858,33905,38131,29679,31760,29712,38097,35984,38064,29711,27534,35984,38032,33807,37935,42193,40112,42160,48564,40146,40145,40178,40178,38032,38032,38032,38032,35919,35888,52822,52790,44338,40178,33807,31759,31727,29581,27434,44272,37869,37868,48398,50579,50546,48498,50546,48465,40047,48564,50645,57050,37935,27436,25323,23275,23243,23243,23243,23242,21097,31629,27466,27401,46319,48432,50611,35853,35853,40015,33708,33708,50613,48500,23242,21162,19082,21163,29614,21194,8581,8550,6469,6437,6405,4324,4356,12710,31531,33479,29286,37803,44206,42126,44239,33708,23144,23144,23177,25289,40079,40111,27434,25322,21097,23242,16936,12743,19016,16935,21159,19045,14852,19046,16933,19015,27403,27403,27435,40080,42225,21096,33742,18984,10565,8452,10597,19080,16967,8516,14789,19047,23240,40144,44305,44305,42192,35886,29515,29548,29548,29515,29515,27466,21159,19014,25321,33773,35853,31595,29515,21097,8549,16968,35854,29547,23209,21127,16965,12740,4322,12740,19044,55},
{50809,50809,50809,50841,50809,52857,50809,50809,50809,50809,52890,52890,50809,50809,50809,52890,50809,50809,50809,50809,52890,52889,52889,52889,52857,52889,52857,52889,52889,52889,52857,52857,52857,52857,52857,50809,52857,50809,50809,52889,50809,50809,52857,52889,52857,52857,52889,50809,50809,50809,50809,50776,50777,50809,50777,50777,50809,50777,50777,50777,52857,48696,42423,42423,40310,36117,34004,34004,31891,31891,29778,36085,31891,31890,31825,33938,31793,36019,31793,29680,31760,27599,25487,25486,38097,35952,38064,29711,25454,35952,42225,50612,50579,48531,52724,52691,50709,40113,38000,40145,40145,44338,44371,37999,38032,42193,40048,57050,57049,50612,38032,29613,29581,29614,31694,29579,50579,42225,42094,44238,48498,48498,48465,48465,48498,44270,50645,48564,56985,27371,33742,35887,35887,35855,35887,37968,37968,31661,31628,23241,33707,48432,50545,48530,31660,37966,52724,50644,48499,31596,35855,29516,19082,21195,21162,27501,16967,10661,8614,8614,6436,6404,6404,4356,8549,25257,31368,37640,41930,44108,42125,40013,33676,21096,21096,21096,23209,27434,19015,21128,12742,10663,8550,8517,12743,33741,33708,27465,19045,14852,14822,14790,23242,27435,27435,27436,31628,37999,16871,21129,27435,21129,10597,8484,12742,25386,31692,37966,21127,27467,37967,33741,31628,29483,27435,27435,29548,29580,31660,35886,31693,19014,12772,25321,31661,25321,27369,31595,23209,10630,10630,29548,44305,31660,14821,12772,12772,8579,12739,21221,73},
{52857,52857,52890,50809,50809,50809,50809,50809,50809,50809,50809,52890,50809,50809,50809,50809,50809,50809,50809,52890,52890,52889,52857,52889,52857,52857,52889,52857,52890,52857,52857,52857,52857,52857,52857,52857,52889,52857,52857,52857,50809,50809,52857,52857,52889,52857,50809,50809,52857,50809,50777,50809,50777,50809,50809,50809,50809,50809,50809,50777,52857,48729,44503,42423,40342,36149,34037,31924,31891,31891,29778,27698,31890,31858,31858,31825,31825,40212,29745,29713,29680,29680,25487,29648,40210,38064,38064,31759,23373,35952,35887,35854,40047,42193,42193,42160,42226,25420,23275,25388,27468,29581,33807,33774,35854,33806,33742,52758,48597,46451,33774,27501,25356,27468,21226,21161,40080,35887,31628,37901,40079,40015,39982,39982,37902,29449,46451,52791,52791,23177,44339,50677,50677,50710,50677,48597,50710,54936,37999,18982,37901,48433,50578,46417,31627,29579,42192,48531,44274,29483,27467,29548,19049,21163,19049,25419,16934,10694,10661,10694,6469,6469,10694,8581,8516,8517,14725,18918,23144,33707,40046,31627,27402,21096,19016,19016,21128,21127,12708,16935,10695,10663,12776,12743,8550,21161,44305,33739,19077,16933,14823,16839,23210,27435,27435,23177,33741,46451,12678,4324,6404,8549,10630,8550,14888,14855,16903,12677,12709,33773,29515,27435,29515,29516,29516,33741,37999,37967,35886,33773,27435,19047,19014,25353,31693,37966,42160,44272,35854,10630,8582,12742,37999,37965,16933,14852,12804,14884,12739,19076,75},
{52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,50841,50809,52890,50841,52890,52890,50809,50841,52890,52890,52857,52889,52889,52857,52889,52857,52857,52889,52857,52889,52857,52889,52857,52857,52857,52857,52889,52890,52889,52889,52889,52890,52890,52890,52890,52889,52889,52890,52889,50809,52889,50809,52857,52889,52857,52857,52889,52857,50809,52889,48729,44503,42455,40310,36117,34036,31923,31891,31891,29843,29811,33971,36051,36083,33938,40212,36018,29712,27600,27600,27599,25487,31760,42258,38096,38096,29711,23341,35984,19081,21162,23274,25323,23274,25387,25355,14856,12808,16937,19049,19017,21129,29549,25355,17002,14857,19082,14823,16969,12743,12743,25388,35952,19082,10630,12743,25421,16937,19049,25388,21098,10630,10663,10663,14823,44338,52791,46453,23242,48597,50677,50645,50645,50677,35886,16901,25289,40014,29546,42126,50579,50545,50611,37966,21095,23209,35919,44371,29548,27468,44306,42225,40080,37999,33740,21127,14886,12806,8581,6469,8549,14886,10660,6436,6404,6404,10597,16902,27402,35821,42160,42193,23209,19016,21064,19016,16902,16902,14854,10695,10663,14856,21162,21129,16871,31627,23207,21126,14854,12775,16871,16871,27403,27403,37967,50644,48531,12711,4357,4357,6469,10663,8517,8549,6437,4291,4323,16967,40080,29515,27435,29515,29548,29515,35886,33741,29547,29483,29516,21129,23241,23239,23241,31628,29548,29515,31563,25322,19081,14823,12709,21095,25319,25350,16996,14852,19044,23269,23237,79},
{52890,50841,50809,50809,50777,50809,50841,50809,50809,50841,52890,52890,50809,50809,52890,50841,52890,50841,50809,50809,52889,50809,52889,52889,52857,52857,52857,52857,52857,52889,52857,52857,52857,52889,52889,52889,52890,42358,36051,38132,38132,38132,38164,38164,38164,38164,38164,38164,38164,38164,38164,38164,38164,38164,38196,40277,40277,40277,40277,40245,40245,38164,36051,34003,33939,29778,27698,27697,27665,25584,25552,25585,27665,31792,31825,29680,31793,31792,27632,27632,27632,31760,33873,35985,38065,33871,35952,38032,31727,31759,17002,16969,14888,23243,25355,25323,21194,16969,14856,17001,21130,25356,25356,27468,23275,14921,12808,12809,16970,14889,12777,16969,25356,19115,8583,8550,12776,19082,12776,12776,25388,19114,8550,8615,10696,14824,44338,57049,37969,12711,29582,31694,35920,44337,46449,29578,21159,25385,33740,25321,42158,40014,48464,46385,40111,25321,29580,38000,44339,29581,31629,50676,44240,46418,42127,40014,31562,21128,16967,10693,8581,12773,21191,14885,8580,6436,6436,8580,19047,21096,27434,37901,35821,21064,19016,19016,19016,16903,16967,19047,12775,10663,10631,14855,31659,37966,42159,35852,19014,12742,12743,23243,19049,16903,29483,31595,44305,48498,14791,4357,10630,12742,8548,6436,8548,8581,6468,6435,27467,40145,29515,27435,29516,29548,29548,29548,29483,31596,29516,27467,16936,27434,21159,23208,31596,29548,29515,29515,14822,23209,33773,27465,14852,12739,16932,21157,21125,21125,19077,21189,88},
{52857,50809,50809,50809,50777,50809,50809,50809,52890,50809,50809,52890,50809,50809,52890,50809,50841,52922,52890,50809,50809,52889,52857,52857,52889,52889,52857,52857,52889,52889,52857,50776,48696,44471,42390,44470,44438,31858,27633,27633,27633,27633,27633,27665,27665,27665,27665,27633,27665,27665,29713,29713,29745,27665,29713,29745,29745,29745,29745,29745,27665,27633,27632,27632,27600,25552,25520,25520,25487,23439,25487,23406,23406,23406,23374,23374,25454,25487,25486,27535,27567,33873,40146,40146,33808,29582,31662,35854,29549,29614,19115,21130,21130,25355,25355,25355,25323,19017,16969,19082,27468,27436,25387,27501,19114,14889,12808,14889,14889,12776,12743,19017,25388,8615,8583,8518,8518,8518,8583,10696,23340,17034,6470,6470,8550,10662,42226,56984,29549,6502,6470,8583,21130,35852,42188,29577,16998,21160,25386,27401,44271,50578,48529,46385,42192,27467,31660,40112,38065,25355,37967,52724,44207,42159,44305,44305,44273,31693,14855,12808,8549,16998,19046,14885,10693,8581,8549,8516,16934,25322,29483,29482,25289,23177,21097,18984,16903,14790,14822,23273,10695,10663,10663,10662,16967,33772,48530,52692,29547,10630,12743,23210,19049,12645,21064,35821,52724,52725,16904,10630,14855,8548,6468,6403,10660,12741,10628,10661,12709,27467,29548,29548,29516,29515,29548,27435,27467,31628,29548,25322,19016,29547,23240,21128,29516,29548,29547,18984,10630,16903,31660,25351,14851,16933,21093,31592,25286,10627,8546,14884,62},
{50809,50809,50809,50809,50810,50810,50809,50809,50809,50809,50809,50809,50841,50809,50841,50841,52890,52890,50809,50841,52890,52857,52857,52857,52889,52889,52889,52857,52889,52889,52889,38099,25454,27633,27600,27632,25552,27665,27665,27665,27665,27665,27665,27665,27665,29745,27665,27697,27697,27665,29745,27665,29745,29745,29745,29745,29745,29745,29778,29745,27697,27665,29713,29713,27632,25552,25520,25520,25519,25487,25519,23406,23406,23406,25487,23406,25454,25486,25454,25486,27566,33872,38033,38065,33808,29485,27404,29484,25259,31695,23276,27468,25388,25323,23275,25355,25323,31629,27468,27436,31694,31661,29548,27435,23307,17001,21195,29581,29548,31694,31661,33806,27501,8583,8551,8518,8518,8518,8551,12744,27501,17034,4390,6502,8615,10662,42258,57017,29516,10663,6470,10696,25323,35852,40108,23239,14918,8613,14854,31594,46351,42093,46351,37966,35854,21160,21160,35854,40179,25355,44306,46386,40080,42160,40080,44306,40079,31662,10663,10664,10662,16966,19078,14853,8580,6436,6404,10628,23272,31627,29482,31562,33709,21129,18984,19016,18984,12677,21096,31628,14856,8614,8614,10630,12775,12742,14790,14790,12743,10663,12743,16871,14725,14693,14725,27403,31563,27402,16871,16967,12741,10692,8548,12740,14853,12740,10628,14886,10660,8516,27435,29515,29515,29548,29515,27402,29516,27435,23209,23242,23274,29547,21128,21128,35854,29547,16935,10565,10630,21096,25256,25319,23238,27399,25286,18980,14820,6435,4322,12708,25},
{50809,50841,50809,50809,50810,52890,50809,50809,50809,50841,50841,50809,50809,50809,50809,52890,50841,52890,52890,52890,52890,52857,52889,52889,52857,52889,52889,52889,52889,52889,54970,33873,23374,27665,27665,27633,27633,27633,27665,27665,27665,27665,27665,27665,27665,27665,27665,29745,27665,27665,29713,27665,29745,27665,29745,29745,29745,27665,29745,27697,27665,27665,29745,29745,27632,27600,25520,25487,25519,23439,23439,25487,23406,23406,23439,23406,25486,25486,25486,27567,29615,33840,33872,38033,33840,29517,31630,31695,29484,50646,27500,25388,23275,21130,21162,29548,27435,31661,31629,27435,31629,31661,29548,25355,25388,14856,23275,29581,27435,33774,35886,35886,31694,12776,10599,10566,10566,10599,10599,17001,33872,16969,4389,6502,8615,12743,42258,52792,21064,10663,8518,14856,29549,35885,37963,21159,21224,19079,16934,35852,48465,44272,50578,38000,33742,27466,12708,25354,40211,31727,48531,40015,37967,38000,33774,33741,27468,21162,17001,19082,25386,21159,21158,16997,10660,6468,8548,16966,27433,44271,42094,44207,44240,23177,19016,19048,19016,25322,27466,31627,14856,10663,10630,16936,19049,10629,8485,10598,10630,10662,12743,16904,14725,14693,14725,10565,10500,16871,16904,12774,14885,16933,14820,14853,12740,14853,10628,14854,14886,10629,23242,27435,29515,29515,29548,27403,27435,35886,40079,40111,29547,29483,21096,19048,42192,31628,25354,27467,14823,18983,25288,21093,16932,21093,16899,14884,12772,8547,8547,12708,32},
{50809,50809,50777,50809,50809,50809,50809,50809,50809,52890,52890,50809,52890,50809,50841,50809,50809,50841,52890,52922,52890,52857,52857,52857,52857,52889,52889,52889,52889,52889,52890,31793,21327,27665,27665,25552,25520,31858,31891,31890,31858,31858,31891,31890,31890,31858,31858,31890,31858,31826,31890,31890,31858,31858,31858,31891,31858,31826,31890,31858,31858,29778,29777,31890,27697,27697,27632,27632,27632,25552,25552,25519,25487,23439,25487,25487,25486,27599,25519,25486,27566,33872,38033,40147,33840,31630,27436,25356,27371,46419,29580,25388,23210,21129,23242,29581,31661,25387,25355,27468,31693,27468,29581,21162,25387,21194,27436,31693,27403,33741,35886,35886,33774,12776,10631,12615,12647,12647,12647,19049,35920,16969,4389,4422,6470,12742,46419,48533,21130,25356,23276,27469,33742,35885,31690,23239,21127,27432,27433,40045,46352,52691,52691,35887,29548,29547,21192,19015,38033,44372,46418,40113,33807,29581,21162,19114,17001,14889,14889,14888,14887,16998,16965,19078,14917,10692,10725,10693,16934,40078,44239,44239,42094,25290,21097,18984,18983,21063,25256,25353,14823,10663,10662,21162,19048,10629,10597,14823,10630,10663,12743,14824,10598,12678,10597,8517,10565,27403,16936,6404,10596,14789,23208,23240,16901,16934,10628,6436,12741,12741,23241,29515,29515,29548,29580,29483,25290,29515,31595,29547,27435,31660,25322,29547,42192,35886,16903,19048,12743,12677,21064,23239,16964,12739,8546,16964,12739,8547,10627,10660,46},
{52857,50809,50777,50809,50809,50809,50809,50809,50809,50809,52890,52890,50809,50841,50841,50841,50809,50841,50809,50809,52890,52890,52857,50777,52889,52889,52889,52889,52889,52857,50777,27599,23407,29745,29713,33906,33906,31792,27567,25519,25519,25519,27567,27600,27567,25519,27600,27632,27567,27567,27600,27632,27600,27600,27632,27632,25519,27567,27567,25519,25519,23439,23406,23439,23406,21326,21326,21326,21293,21294,21294,19181,21261,21261,21261,21261,23374,25421,25454,25454,25454,27502,27534,29648,27534,31662,25388,17002,19083,29614,29549,29549,27436,25355,23275,29548,31661,23275,21162,23242,31661,31693,29581,23274,21162,19049,21129,29549,27468,33774,35886,35886,35887,14856,12679,14695,14695,14695,14695,21130,33807,17034,6470,8583,10696,14856,46452,35888,16904,12776,8518,16968,29581,31692,27465,23240,25353,25385,27433,44271,46319,48464,52659,31629,23210,35853,42225,19048,35984,38033,23242,10663,8550,8550,6470,6470,6470,6437,4357,4357,6437,14886,14886,14918,14885,10692,8548,8548,12773,31626,44238,42158,44239,29418,21031,27370,44241,46254,37868,29515,31661,29548,23209,21129,19049,6436,12711,16937,10630,10663,12743,16969,16904,12678,12678,12710,14758,31661,16936,12678,27403,42192,52757,52789,33740,23175,10596,6436,10661,10629,23241,29548,29548,29548,29548,29515,25322,27467,29516,29515,29515,31661,33773,35854,33708,31595,16903,16903,19016,18984,14790,16933,19077,10691,8547,14884,14884,14852,12772,12739,78},
{50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50841,50841,50809,50809,50809,50809,52890,50841,50809,50809,52890,52890,52890,52889,52889,52889,52889,52889,52889,52857,50776,33905,40212,48696,48664,50809,50809,38131,35986,35954,33906,33938,33906,33905,33905,33906,33906,33873,33873,33873,33873,33873,31793,31793,31760,31792,31728,31728,29648,29615,29615,27567,27567,25454,25454,23374,25422,23341,23341,23341,21229,21228,23341,23340,23341,23341,27502,27502,27534,29615,29582,25421,23309,23309,27501,27404,27501,17002,17003,16970,23307,31661,23275,25388,21162,27468,33774,27468,16968,27435,29548,29548,31629,25322,19049,21130,25387,25355,31661,33806,35919,37966,35919,14856,12711,16743,16743,16743,14695,21162,33871,19082,6470,6503,10663,12743,46419,27437,14856,10695,6502,16969,29581,29547,25352,19047,19047,16934,29482,48465,50579,48400,42158,25355,14823,33806,42225,16935,33903,25356,14824,6405,4324,6437,6437,4389,4357,4357,4357,4324,6404,14854,10693,8581,10661,10661,6436,6404,6436,19015,42158,37900,39980,35723,44241,57049,56885,50282,41994,35821,46450,46417,40079,21128,12742,6437,16969,19049,10630,10630,10662,19049,14856,12678,14758,12710,21129,33709,35854,50677,56983,54838,50643,52724,48498,42127,16934,10693,8548,8516,23274,29580,29548,29548,29515,27435,27403,29548,29548,29515,29515,29548,37934,33741,16903,33740,42094,42159,42127,31628,16871,21063,18981,12771,12740,14884,16965,16932,16965,12708,69},
{52857,50777,50777,50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,50809,50841,50841,52890,50809,50841,52890,52889,52889,52889,52889,52889,52889,52889,52889,52889,52857,52857,40211,44437,52857,52889,50776,48696,52857,52889,52889,52889,52889,52857,50808,52857,52857,52889,52857,52857,50808,52856,50776,50776,50776,50808,52857,50808,50808,50809,50809,50744,50776,50776,48696,48696,46583,46583,42422,42390,42390,40245,38132,42324,40243,40244,38132,38099,38099,38099,40180,40179,36018,35987,38067,40113,31531,25388,17034,17035,16970,21162,31694,27468,23275,21097,29581,33742,29581,25355,31662,31661,29548,29516,31661,25323,23275,29581,25322,31693,33806,35886,35886,33806,12776,14727,16711,16743,16743,16743,21162,38065,19082,6470,6470,6470,10630,38000,19018,12743,12744,8551,16969,33774,29579,29609,25351,23240,27434,35852,46352,42060,48367,52659,33741,23242,25289,25322,16934,33871,27469,14856,19049,19049,14921,14857,19115,21163,19083,17002,14889,12809,17032,12837,6468,6436,6468,6436,6404,6436,23208,44272,42126,50579,52724,56983,57017,50479,50282,37768,21063,35886,44305,37966,16902,8548,8549,25388,23210,10630,10662,10663,16969,21130,14758,12710,14791,27435,31693,35822,37999,48498,52725,48466,35722,46385,46385,16902,10694,12742,12741,23273,31628,29548,29548,31628,29515,33741,31628,29580,29515,29515,29547,21129,14790,12775,16871,33708,40014,31563,16870,10597,25257,25256,19014,21062,18981,18917,16869,10563,10531,101},
{52890,50777,50809,50809,50809,52890,50809,50809,50809,52890,52890,50841,50809,50809,50841,52890,52890,50841,50841,52889,52889,52857,52857,52857,52890,52857,52857,52857,52889,52889,52857,40211,40179,50776,50809,50776,48631,50776,50776,50776,50808,50776,50808,50776,50776,50776,50776,50776,50776,50776,50776,50776,50744,50776,50776,50776,50776,50743,48695,50744,48695,48695,48696,48663,46615,44535,44502,42358,42390,42357,40245,38165,40276,40243,40276,38100,36019,36051,38099,38067,38099,36018,33906,38003,48466,46223,14857,17002,17035,17002,21162,27468,23242,25388,21130,31662,27436,27468,23275,23243,29581,33774,31661,31629,25388,23242,29581,27468,31693,35854,35886,35918,35854,12776,14760,16743,16743,16775,16743,23243,35952,19114,6470,6470,6470,8550,10630,8550,10663,10663,6503,14856,31694,25386,19046,31690,29546,25256,37900,46352,46318,50512,50611,35854,33773,25256,31627,27433,35919,25421,14856,33806,25388,21195,19082,23308,27534,23309,21196,21196,14922,14951,12805,6468,6436,6468,6468,8581,10693,16934,37933,48465,56917,54771,48432,50578,48367,42028,25255,14823,12710,16935,25354,12741,6436,14823,29548,25323,14856,12743,12711,16936,21064,14758,14726,21096,33741,33741,33741,33741,35821,48564,52822,46353,46385,40047,12710,6404,6469,10629,21161,29548,29548,29547,35853,42160,33741,27467,29548,29548,29515,27435,12742,10663,12743,10630,16935,42257,44337,40079,33708,40046,44272,44273,42159,42159,44240,40046,40046,46385,167},
{52857,50809,50809,50809,50809,50809,50841,50809,50809,52890,50841,50809,50809,50809,50809,52890,52890,52890,52890,52890,52889,52889,52857,52857,52890,52857,52889,52889,52857,52857,52857,40212,44405,52857,50809,50809,50744,50776,50808,50776,50776,50776,50776,50776,50776,50776,50776,50776,50776,50808,50744,50776,50776,50776,50776,50776,50808,50776,50776,50776,50744,48695,48696,48696,46616,44503,44503,42357,42390,40309,40245,38133,40212,40244,40244,36019,38132,36019,36051,36018,38067,36018,33906,35955,50546,46287,16937,19083,17002,14922,21195,27468,21162,25355,21162,25355,31662,29581,27468,23275,25355,29581,29581,31629,23274,21162,25355,25387,29580,35886,35886,35886,33806,12776,18921,16743,18791,16743,16743,27404,38033,19082,6470,6502,6470,6470,8583,6502,10663,10663,6503,14856,31661,21193,16967,33804,29482,27369,40013,46319,50611,50609,46418,27434,31628,25288,31660,40079,38033,33840,19017,44307,29549,19082,19050,23276,25421,25389,23309,14889,12808,14918,14918,8581,6468,10661,10661,12741,12773,8548,12741,37965,46352,25224,12644,18983,19015,19016,33741,29548,10663,10662,19047,14854,6437,21195,29548,23275,10663,12775,12776,19016,16806,16773,14693,25322,33774,33741,33741,33741,33741,48498,52789,50611,50644,33773,19049,10597,8517,10629,21128,35854,35886,35886,35886,29548,19016,27468,29548,29548,29548,31628,25322,29580,16903,10630,8549,25354,44337,44304,48498,50644,46418,52757,52789,54870,54902,52756,52789,57048,182},
{50809,50809,50809,50841,50809,50809,50809,50809,50809,50841,50809,50809,50809,50809,50809,52890,52890,52890,52890,50809,52889,52889,52889,52889,52889,52857,52890,52889,52857,52857,52890,40244,42292,50776,50808,50809,50776,50776,50808,50808,50776,50776,50776,50776,50776,50776,50776,50776,50808,50776,50776,50808,50776,50776,50776,50776,50776,50808,50776,50777,50744,48695,48696,48696,48664,44503,44503,40309,42358,40277,38197,38165,38164,40244,40212,38067,38099,38099,36019,36019,38066,36018,33938,35955,46355,42096,16970,19083,17034,17035,21195,25388,21130,25356,27436,27468,33774,25355,23243,27468,25388,29581,31661,27468,23242,21130,23275,29548,31693,35886,35886,35886,33806,14856,18921,18791,16743,16743,18823,27403,35920,21195,6470,6502,6502,6502,8583,6534,12776,14857,6470,14824,31725,19047,14886,31659,23176,27402,40013,46352,52691,50609,42192,14757,19016,18983,29515,42160,40178,38001,25290,52791,31630,16969,19050,23308,21227,23275,12808,6469,12808,16998,16965,12773,12805,16966,16966,14853,10693,6468,14822,21127,10628,6404,4356,4324,6404,14823,19016,16935,10663,16968,16999,12774,10630,27468,29516,25355,12711,10630,12743,18985,14758,16903,21064,31661,33774,33741,33773,33741,37934,42061,37836,52691,40014,29482,31660,37999,27435,12709,19047,37999,29547,27435,31596,23210,21161,29548,29515,29548,29548,27435,31661,35854,33709,23242,16903,14790,35885,42191,46385,54837,52756,52691,48498,48465,46353,37966,42192,48498,146},
{50777,50809,50841,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,50809,50809,52890,52890,52890,52890,52890,52889,52889,52857,52890,52889,52857,52857,52857,52857,52857,52890,42292,42292,50776,50808,50808,50776,50776,50776,50776,50776,50776,50776,50776,50776,50776,50776,50808,50776,50776,50776,50776,50776,50776,50776,50776,50776,50776,50776,50744,50776,50776,48696,46583,48696,44470,44503,40310,42390,40277,38197,38165,40212,40244,40244,38099,38132,38132,38131,36051,38066,38099,35986,33906,38034,33808,17002,17035,17034,17035,27502,27468,23275,25355,27468,25355,29581,27500,23242,29581,27468,27468,31694,27468,23275,19049,21162,27468,31661,35854,35886,35918,33806,12776,18889,18823,16743,16743,18855,27436,33807,25389,6502,6502,6502,6502,6502,8550,14889,14889,6502,14856,33806,23272,23240,33739,21095,29546,42126,48464,44206,50545,42159,19047,14822,23241,35854,25322,35921,29582,29483,57050,29517,17001,17001,23307,23307,16968,12775,17034,12807,19078,21158,19110,16933,16997,23239,18982,10628,12773,14854,16934,8548,6468,6404,6436,14823,25354,23209,16936,12743,16935,16934,8549,19016,31628,29516,27403,10663,10663,10630,14824,10598,21163,27468,31661,33741,33773,33773,33773,46419,52757,46353,48499,37934,31628,37934,35853,23241,10661,10629,27467,29548,29516,29548,19049,25355,29548,29515,27435,27435,14822,10662,12678,21096,40111,37999,31660,37933,42223,50676,52789,50611,40045,35787,31562,25256,27368,48498,44208,129},
{50809,50809,50809,52890,50841,50841,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,52890,52890,52890,52889,52890,52857,52857,52889,52857,52857,52889,52889,52857,52922,42325,44405,50776,50808,50776,50776,50776,50776,50776,50808,50808,50776,50776,50776,50776,50776,50808,50808,50808,50808,50776,50776,50776,50776,50776,50776,50776,50776,50744,50744,48696,48728,48664,48696,44470,44503,42390,42422,40277,40277,38165,40212,40244,40244,38099,38100,38131,36050,36018,38099,38099,36018,31858,35986,33809,16970,17035,17034,17002,25388,27500,21162,21162,25388,25323,29548,27500,19049,25323,27500,21130,29581,27436,23242,25355,29581,31661,25387,29548,35886,33806,29613,12776,16840,18791,18823,18823,18855,29516,33807,25421,8550,6502,6502,6502,6502,6502,10695,14856,8551,12776,33805,29545,35916,44271,33674,35820,42191,48497,27401,31628,27434,16966,16934,27467,40079,18984,31727,31727,40081,57017,29484,19049,16968,21161,19080,12806,12807,14889,14854,23269,25349,23270,21157,23270,16966,10564,14822,19047,21126,16965,10660,19015,37968,23242,21129,29515,29548,19016,33806,33708,21128,8485,25323,31629,31596,27436,12743,10630,14856,25355,27468,25355,29516,33741,33741,33741,33773,35853,50644,48531,35821,25321,23241,14789,16902,25354,19047,12741,10628,23209,31629,31628,27436,16936,29516,29548,31693,29515,33741,31628,19017,12743,10630,29548,46385,46450,50643,50610,56917,54803,33609,16837,14757,12708,12676,21094,44304,31530,133},
{50809,50809,50809,50809,50809,50809,50809,50809,50841,50841,50809,50809,50809,50809,50809,50841,52890,52889,52890,54937,52889,52889,52857,52857,52857,52857,52889,52889,52889,52889,52889,50777,50777,50809,50809,50809,50776,50744,50776,50776,50776,50776,50744,50776,50744,50744,50776,50808,50776,50776,50776,50776,50809,50776,50776,50776,50776,50776,50776,50744,50744,48695,48696,48728,46616,44503,46616,42358,44470,42357,40277,42357,40245,40245,40276,38131,40212,40212,38131,38099,38099,38098,38066,33938,36018,35953,19082,17035,17034,19083,21195,27500,29581,25323,23242,27436,31694,27468,23242,23243,29613,23242,29581,29548,27468,16937,16969,27436,27468,27468,31693,23243,23243,12744,16808,16743,18823,16743,16775,29516,33839,23308,8551,6502,6470,6534,6502,6470,8615,10696,8551,12743,27530,29577,38029,46416,44239,33707,42126,37965,16935,12709,14854,14854,35886,33773,23208,12710,27534,29615,40081,50645,25323,19049,16936,17001,16968,17000,14888,10662,16998,21157,25414,23302,25382,23270,16934,16903,19015,19047,21158,19045,12773,12740,23209,21129,23210,23177,21129,16936,21129,42126,29482,14823,31661,31629,31628,29516,12711,16936,27436,27500,31661,27403,31629,33741,33774,33741,33741,37967,31595,23143,16966,12740,10660,8547,14854,25322,23209,19015,14854,23241,31628,27435,23210,23242,31628,27435,33741,35886,33740,37934,25323,14855,12743,14790,37998,44304,42191,44271,42126,37900,23111,18951,16870,14790,16870,25288,33707,35821,160},
{50809,50777,50809,50809,50809,50809,50809,50809,50841,50809,50809,50809,50841,50809,50841,50841,50809,52890,54970,54969,54970,52890,52857,52889,52857,52889,52857,52857,52889,52889,52889,52889,52890,52889,52857,52857,50777,50776,50809,50809,50776,50776,50777,50809,50776,50776,50776,50776,50808,50776,50776,50809,50809,50776,50776,50776,50776,50776,50776,50777,50776,42356,44470,42357,42357,42357,38164,38164,38164,38164,38131,40244,38099,35986,38131,38131,38099,38131,38131,35986,36018,38131,35985,35986,38131,35953,17002,19115,19115,17002,19049,27500,25387,23275,23243,25323,29581,27468,27468,27436,29581,25355,31661,27468,23243,19082,16936,23275,29516,31693,25355,27469,27501,12744,14728,18824,16775,16743,16775,23210,25388,19050,8583,6502,6502,6502,6502,6470,8583,10696,8583,12808,27465,31658,38029,44303,44206,33708,44272,33739,10661,14887,16935,23273,33806,23208,14886,8549,27502,31695,48533,50645,23210,16969,14889,14889,12776,12775,12775,12807,19110,14885,14885,14852,16965,14853,21160,21064,19015,21159,21158,16997,12805,10660,12741,23242,23210,16968,16935,37999,31660,35853,37933,27370,33741,31661,31661,31628,18984,27500,25355,27436,29581,31629,31661,33741,33741,33741,33773,16871,18984,18983,19046,19078,19078,16998,19046,25322,25322,19081,8549,21128,31661,35886,37999,31628,29548,27435,29548,27435,16903,19049,14823,29548,29580,23209,23209,21031,16838,14757,14725,14757,12709,12710,10597,10564,25289,42127,35821,46419,165},
{50809,50777,50777,50809,52857,52889,50841,50809,50809,50809,50809,50809,52890,52890,52890,52890,50809,52890,52889,54937,54937,52890,52857,52857,52890,52890,52889,52857,52857,50809,52857,52857,52857,50809,52889,50809,50809,52889,52857,52857,52857,50809,52857,50809,50809,52857,50777,50809,50777,50777,50809,52857,50777,50777,50809,50777,50776,48696,46583,46583,44471,33938,31825,31825,33873,31793,33873,36018,36019,38131,38131,40212,40179,38099,36019,36051,36019,38099,36051,36019,36051,38131,38099,38132,38132,31825,17002,19115,21195,19082,25388,25388,19082,19017,19017,29549,31629,25388,25388,21195,23275,21130,31661,27500,21130,25356,31662,31694,27500,27436,19049,21162,25323,10631,14728,16743,16775,16743,16743,27469,31727,21228,6503,6470,6502,6502,6470,6470,10695,23307,25355,21161,27465,31723,35917,46319,42126,40078,46352,42160,21128,19047,19015,27435,29515,25354,16935,8549,25389,33808,46452,40113,21162,16969,14889,14857,12808,12776,10695,10662,17030,14885,14917,14917,10661,8548,14854,21096,19015,21159,23239,21158,14885,12773,23242,33709,19017,8550,21162,42257,44305,48530,54804,33708,33741,31661,31628,35854,31564,31661,31661,29549,29548,29516,31661,31661,33741,35854,35822,18985,35887,25289,12644,14790,16967,14822,21127,25354,25322,21129,6436,16935,29516,31660,33708,31628,29548,29515,29515,25322,12710,10663,10630,16935,37967,42159,33675,27337,23144,18951,14790,12645,8484,8484,12677,12676,44304,48466,37966,46451,166},
{50809,50809,50777,50809,52857,50809,50809,50841,50809,50809,52890,50809,52890,52890,52890,52890,52890,50841,52889,54937,54970,52889,52889,52890,52889,52890,52857,52857,52889,50809,52857,52889,52889,52857,52857,52890,52890,52857,50809,52857,52889,52889,52857,50777,52857,52857,50809,52857,50809,50809,50809,50809,50777,50777,50809,50809,50777,46550,44438,42357,38132,36051,38164,38132,38132,40212,40244,42325,40245,44438,42357,40245,40212,38164,38132,38164,38164,38165,38132,36084,34003,36052,36084,36084,36052,29746,14922,19082,21195,21163,27468,27468,21195,21130,25356,29581,31661,27468,25355,25388,19082,21162,29613,23242,23243,25355,27436,31661,27500,27436,19049,29581,31661,10631,14695,18791,16743,18791,16743,31662,33840,25388,8583,4422,6470,6470,6470,6502,8550,25388,27468,23274,21193,21161,31627,46352,44239,33773,27403,44339,44305,19015,19048,29580,35854,31660,16966,8549,25389,33808,33774,31661,19050,17002,16969,14889,16970,14889,14888,8581,14886,19078,14886,10693,6500,6468,21161,21064,23242,25321,25288,21159,12772,12774,16903,31628,23242,8583,27500,44337,44305,54869,50644,33709,33774,31661,31628,44305,31597,21162,27436,29581,29548,27468,31661,29516,31628,37967,48531,21064,19049,29581,25290,10564,8484,8452,12709,25354,25322,21161,8516,14823,27468,29548,29548,29548,29548,31628,27435,29548,14823,10662,10663,10597,16902,42159,50577,54771,46286,29449,18950,8484,6339,10596,12708,18949,48465,40046,35821,42192,190},
{48697,50777,50809,52890,52857,50809,50809,50809,50841,50809,50809,50809,50809,50809,52890,52890,50809,52890,52889,52889,54937,52890,52890,52889,52890,52857,52857,52889,52889,52890,52889,50809,52857,52857,50809,52857,52857,52857,50777,52857,50809,52857,50809,50809,50809,50809,52857,50809,52857,50809,50809,50809,50809,50776,50776,50777,50777,46583,46518,44470,42325,38164,38164,36083,33939,38131,40244,38132,36084,36084,36051,33971,31890,33971,33971,36051,33971,33971,38164,36052,33971,33971,33939,31891,36084,29745,23276,33840,33807,35919,35854,29581,25388,27468,27468,31661,33806,25323,19049,23275,25388,31661,35887,23242,23243,27468,19050,27468,27468,27436,19017,27468,27467,16937,16808,16743,16742,18823,18823,31662,31726,25421,8583,6503,14889,16969,16969,17002,19082,27468,27435,23274,12840,21195,33773,46319,44240,27436,27501,29581,29613,12741,12774,14855,31694,35918,19047,12774,23275,38066,40146,29613,23243,19050,17002,17002,21196,23308,16968,12807,12807,14887,8613,8581,6468,6436,18984,25289,25355,27403,23208,16933,16934,16935,12710,14823,23242,10663,19049,42225,42192,40047,37902,33741,33741,31661,33741,48531,21097,12711,12742,19017,18984,21097,33774,31628,29516,35821,52790,25258,4324,8517,14823,16904,10565,8484,10597,25322,25322,19015,10596,14823,29548,29548,31628,29515,29515,40079,46386,31596,16904,10662,10630,10630,16870,23175,21062,18949,18950,14757,12677,10596,6403,12708,12675,31659,42159,33741,33708,46418,227},
{48729,50777,50809,50809,52857,50809,52890,50809,50809,50809,52890,50841,52890,50841,52890,52890,52890,52890,50809,52889,54937,52889,52890,52889,52889,52889,52857,52889,52889,52857,52889,50809,52857,52857,52857,50809,52857,50809,52857,52857,52857,52857,52857,50809,52857,52857,50809,50809,50777,50777,50809,52857,50809,50809,50809,50809,50776,48663,46583,46551,46583,44471,38131,36019,33906,38132,38132,36084,36052,33971,34004,33971,33939,33939,31890,31891,34004,36116,34004,31891,36084,40245,38099,40212,33938,27599,27501,42258,42226,42258,37966,29548,25388,27500,29581,25355,33807,31694,27436,25356,23275,29581,31693,31661,29581,25323,16936,27468,29548,29614,21130,19049,19017,16937,18856,18791,16743,18791,18823,29549,31759,25421,8583,6470,10663,8550,6470,10663,12743,17001,25322,25355,16969,17067,31629,44240,42160,29548,33806,29549,23274,14854,14919,19015,31693,33805,21127,12774,23274,35953,25388,31694,35855,19017,19050,19082,25389,27437,21162,21162,14855,10695,8549,10694,4356,4356,8484,31628,31628,29548,23208,37999,44274,21162,10662,10663,12743,14856,10630,29581,33806,27403,31596,33741,33741,31661,40080,42193,25323,16904,14791,16936,21097,21097,31661,29516,25290,37967,44272,21097,6405,6469,8550,14824,10597,8548,10596,21129,25322,16967,14854,29580,29516,29548,31661,27435,29483,35853,35821,31628,19048,10662,12743,14823,21127,8515,4291,4291,2210,4290,4291,4258,6402,14853,16900,35853,33676,35789,37999,40079,141},
{50777,50809,50841,52857,52889,52890,52890,52890,50809,50841,52890,50809,50841,52890,52890,52922,52890,52890,52890,52889,54938,52889,52857,52890,52889,52857,50809,52890,52857,52857,52857,52857,52857,52857,50809,52857,50809,50809,50809,50809,52857,50809,50809,50809,52857,52889,52857,50809,50809,50809,50777,50809,50809,50809,52889,52889,44503,38164,40277,40277,38132,33971,36084,33971,31859,31891,33939,36051,34003,36052,33971,33939,31825,33874,33906,36018,33939,31858,31826,29778,33939,44470,42358,42357,42390,35987,29614,33840,27533,31726,35887,25388,23275,25388,23275,23275,25421,23275,25388,27501,27501,27469,21195,25356,27468,25388,23275,27501,27501,25356,19050,21195,21195,14889,16840,18920,16840,16808,18888,25356,27534,23341,10663,8615,10663,8583,8583,8583,6502,8615,21162,21162,12808,17034,29516,44207,44239,50643,46385,27434,21128,21160,19048,29547,40079,31660,16966,12773,23338,33872,19049,40113,42225,38032,38032,35919,46420,42226,42290,35887,14887,8549,10693,12806,8548,6468,12742,25257,31594,37933,25320,25320,27369,16903,10630,10663,12743,31694,35887,27435,38000,35919,33741,35854,33774,33709,31530,25257,29581,31629,29548,29580,44305,46451,48564,44338,42160,46418,46352,21129,4357,4357,12711,23209,12740,10659,12708,23242,25322,19047,12709,23209,29515,29515,31661,37967,42128,42160,25322,14790,37967,29580,27435,23241,19014,10596,4323,6371,8483,4323,4291,4290,6403,16901,21094,29514,35853,37934,35854,37966,111},
{50809,50809,50841,52890,52889,52890,52890,52889,50841,50841,52890,50841,52890,52890,52890,52890,52922,52890,52890,52857,52889,52889,52890,52889,52889,52889,52889,52857,52857,52889,52857,52857,52889,52889,50809,52857,50809,50809,50809,52857,52857,52857,50809,50809,52857,50809,52857,50809,50777,52857,50777,50777,50809,52857,48696,33938,23406,33971,38197,36116,34004,29811,27698,27698,27763,29811,29843,34037,31956,29876,31924,31891,29810,31891,36052,36051,33971,34004,33972,33972,34004,31891,33971,34004,31891,29745,17034,14889,14856,19081,27501,21195,19115,21228,21195,19115,19083,19115,19115,19115,19115,19115,19083,19082,17002,17002,16969,17002,16969,14889,14857,17002,14889,17002,16970,17002,14889,16969,16970,16969,14889,14889,14857,14889,14921,14921,12841,10696,8615,8583,8583,10663,12809,19148,27469,42127,46384,54837,33707,16934,19112,19080,21128,37999,35821,25321,14886,12805,21192,38066,25323,42258,48564,50709,46451,48532,50710,48629,50710,37999,12741,10693,14918,16966,16966,14821,14854,29514,46319,46318,33705,25320,25321,31628,12678,10631,8582,16903,37967,44337,44305,35887,33773,33774,35854,37934,48498,44240,31628,33741,33709,42193,54903,54871,52822,50644,44272,54903,48564,21096,14790,29417,42028,50380,37800,25286,19014,21161,21096,16966,10628,10564,27467,29515,29515,29515,29483,23177,23209,27467,46482,46450,44305,27466,14821,8515,6403,12676,10628,6403,4323,4322,6370,21062,44239,33675,44338,37999,33741,35886,118},
{50809,50809,50809,52890,52922,52890,52857,52890,52890,50841,52890,52890,52890,52890,52890,52890,52890,52890,52890,52889,52857,52889,52890,52857,52889,52889,52889,52889,52890,52889,52889,50809,52889,52889,52857,50809,50809,52857,52857,52857,50809,50809,50777,52857,52857,50809,52857,52857,50777,50777,50809,52889,50777,38164,23438,19245,21358,31923,34004,33971,31923,31891,27698,27666,25585,27730,29843,29811,29811,29811,27730,29811,34036,31923,34003,34036,31956,34004,34036,33971,33971,38197,38197,38164,36116,29746,17002,19082,21163,31662,38066,23341,21260,23341,23341,23341,23308,23308,21228,23276,23308,21228,21228,21228,21228,21195,21196,17034,19115,17035,17034,19083,19083,17002,17034,21163,21162,19082,19115,19083,17034,17034,17034,17034,17034,12809,10728,12841,12809,10696,10696,14921,14954,19115,23276,37998,46384,54869,40046,14854,16967,19080,16902,25353,19047,16934,21192,16967,21160,40178,33774,46484,48499,40112,37999,46386,44306,46419,35886,23275,14855,12806,10694,14854,16966,12708,12708,33707,52625,52624,44205,29514,21128,42159,29515,10630,10663,16904,18951,33740,31627,21097,29516,33773,37934,35821,48532,37934,31628,25322,33741,48564,54903,54870,54870,54903,46386,42192,37934,40015,50512,54573,56554,56521,46057,31432,23208,19047,16902,16934,10660,8548,27435,29580,29548,29548,27435,14823,25322,42225,46418,46418,42224,23207,12707,8515,6403,12741,12740,8483,4323,6435,6370,33772,50578,33708,46385,40047,37934,35820,124},
{50809,50777,50842,50809,52890,52922,52889,50809,50809,50841,50841,50841,52890,52890,50809,50809,52890,52890,52890,52889,52889,52889,52889,52889,52890,52889,52857,52890,52889,52889,52857,52857,52889,52889,52857,50809,50777,52857,52857,52857,50809,52857,50809,50809,50809,52857,50809,50809,50809,52890,50809,40309,27632,21326,21358,21326,31825,36083,38196,36084,33971,29778,25617,27665,27666,27730,27698,27730,27698,29746,31923,38164,42357,40244,40277,42357,40244,40244,40276,36051,33939,36084,36084,36051,36084,31793,19115,23276,25356,35920,44405,23309,21228,21228,21228,21227,21228,23308,23308,23308,23308,21228,21196,19147,21195,21195,21195,17035,17035,17035,19115,19115,19115,17002,17002,44308,44372,19050,17035,17034,17034,17034,14954,19115,19082,10728,10728,12809,10728,10696,10728,10727,10727,14921,21227,35885,46417,54869,44304,16902,14854,14822,23241,23272,16966,19047,23305,14854,21160,40178,33774,46483,48531,40112,40079,46419,44273,46386,23209,10630,14855,8581,4324,4356,10629,12774,12741,16934,42192,33707,21030,16902,14790,31563,44272,25354,10630,18984,23144,21032,18951,14823,14823,27403,33773,23177,21129,27435,29548,18950,40079,50644,46418,44338,46386,44338,44338,44338,37934,37934,42127,48366,52460,52427,46220,44174,29450,16935,16966,16966,16934,10660,27435,27435,27467,27435,23210,12710,31693,44370,44337,46418,44337,29513,14788,10660,8547,12772,14853,8547,6435,8515,8483,42126,35723,29482,42160,46418,46320,42159,120},
{50809,50809,52890,50809,50809,52890,52922,50841,50841,50809,50841,50841,52890,50841,52890,50841,52890,52889,52857,52890,52889,52889,52889,52889,52857,52857,52857,52889,52857,52889,52857,52889,52857,52889,50809,52857,52857,50809,50809,50809,50777,52857,52857,50777,50809,50809,50809,52889,52857,44470,27664,21358,21326,21390,21358,21326,31825,38196,38197,38132,36084,34004,31924,31859,29810,31923,31924,34004,34004,36052,38230,40310,40277,40245,40277,38164,40244,40277,40277,36084,33939,33971,36052,38165,38132,38132,31728,31728,29647,38065,42292,21195,19147,19115,19115,19115,19147,21228,21228,21228,21228,21228,21228,19115,21196,19115,19115,17034,17034,17034,19115,21195,19147,17002,19115,29582,35888,17002,17035,17034,17034,17034,12809,23308,19115,10696,10696,12809,10696,10696,10728,12775,10695,17002,19114,35884,50643,56950,46417,21159,19079,23208,31627,23240,19079,16934,19015,16999,19048,42227,42194,48531,44273,35821,42192,44273,46419,40080,14855,8549,8549,6436,8517,6469,4356,4324,6436,12774,27500,21194,16935,16967,21097,40079,44272,42127,23209,16904,23112,23144,18984,16904,16936,16936,29548,21097,23178,27435,33708,33709,42094,42159,16806,6371,12677,10564,8451,27434,35886,35886,37934,37901,48530,56983,57015,52724,31628,25387,27466,23272,21159,16966,29548,33741,35886,37934,25355,10663,16936,37999,37998,37998,44240,40013,25351,16965,12740,16965,16932,12740,12740,14821,23240,48465,31530,33676,44240,56983,42061,35755,148},
{50809,50809,50809,50809,50809,50809,50841,50841,52890,50809,50841,50809,50809,52890,52890,52890,52890,52890,52889,52889,52889,52889,52889,52889,52857,52857,52857,52857,52857,50809,52857,52857,52857,52889,52889,52857,52890,52857,50809,52857,52857,50809,52857,52857,50777,52857,52890,46584,31825,21326,21358,21391,21358,21391,21390,19278,27664,42357,42358,38164,40244,36052,31826,31859,31858,29778,29745,33972,31891,31859,34004,33971,31858,31923,31891,31858,31858,31859,31891,33971,31891,29810,31858,34003,33971,33971,36019,29680,29648,29647,25453,19148,21228,21228,19148,19148,21228,19148,21228,21228,21195,21228,21195,19147,19147,17067,19148,19148,19147,19147,19147,21196,19147,19115,21228,21163,21163,19115,19115,19147,19115,19115,17034,23308,19114,14953,14921,14921,10728,10695,12840,12807,10695,19082,21162,37997,52723,56950,40078,21159,23240,27434,23241,23241,25385,12773,14854,16999,21128,44340,50678,48531,44370,37967,48531,48499,40079,16934,8581,6469,6437,6469,10662,8614,4356,4324,6436,12807,12807,10694,8549,12775,16936,25355,35821,33676,29515,27402,27337,25224,25257,21129,14823,16936,29548,35854,46418,37933,42094,42127,44239,44272,14791,2211,21161,37967,33774,35854,35886,35854,27370,40047,54903,52790,42193,35853,40079,42225,31628,25322,16934,12741,25354,35886,37999,40079,29580,10630,10630,25354,44337,44272,46450,54869,44239,23206,16965,16964,19045,16933,12772,8547,23240,35788,29418,33675,35787,39980,37933,31529,175},
{52890,50809,50809,50809,50809,52890,52890,50809,50841,50809,50809,50809,52890,52890,52890,52890,52890,52890,52857,52889,52857,52857,52889,52889,52857,50809,50809,52857,52889,50809,52857,52857,52889,52857,50809,52857,52857,52857,52890,52857,52857,50809,50809,52857,52889,46616,33971,23406,19278,21391,21358,21358,21358,21358,21391,19278,27664,36084,36084,36084,33971,29811,27666,27698,25650,27731,27763,27731,27731,25650,27731,29811,31924,27730,27730,29778,29778,31891,31956,31923,31891,31956,34004,34004,36117,36117,31858,14922,14921,14922,14955,12874,17068,17067,19148,17067,17067,14954,14954,17067,14922,17067,19148,17067,17067,17035,19148,17035,17035,17067,17034,17035,17035,17035,17035,17002,12841,14922,14921,14922,14954,14954,17034,17002,14921,21226,25419,14887,8582,8582,14919,17000,25420,21195,19081,42191,54837,56950,31659,16934,19079,10693,6468,16967,23240,21159,16934,16934,19048,42292,48597,48498,35885,37901,44273,42192,27499,12773,12774,8548,10630,23307,21162,19082,17001,14888,19048,16966,10661,6436,10629,18984,10630,10630,16903,21161,14790,31628,33642,48432,42094,23177,14823,16936,29548,48532,44240,33708,29449,42159,44239,44240,18951,2179,12678,16871,29515,35854,35886,35854,44273,46385,37998,21127,8514,8547,19015,35918,27434,25322,23241,10597,23209,29548,29547,29548,23274,10630,10662,12742,33838,44337,40014,29482,23176,21095,16965,16964,16964,14852,4321,16869,29449,37901,35853,33708,37901,31563,40015,33707,195},
{52922,52889,50809,50809,50809,50809,50809,52890,50809,52890,50841,52890,52890,52890,50841,52890,52890,52889,52889,52889,52857,52857,52889,52889,52889,52857,50809,52857,52889,50809,52889,52857,52857,52857,52890,52857,50809,50809,50809,52857,52857,50777,50809,50809,38164,23406,19246,21326,21358,21358,21358,21358,21358,21358,21358,19246,27632,33971,31891,29778,29778,27698,25618,25650,25650,27731,25683,25650,25618,25617,27731,27730,29779,29811,27730,27698,29811,31923,29778,29811,31924,31924,31892,31891,31923,34004,29745,21261,21261,19213,21261,21294,19213,21261,21293,23374,21325,23374,21293,21261,19180,21261,23373,21293,21293,21293,23341,21293,19148,21228,21228,21228,19147,19148,19148,19115,17002,17002,14921,17002,17034,17034,17034,19114,19114,23307,25419,17000,14888,12775,14920,17000,27500,21195,16968,44337,52725,42225,27434,19047,14854,8582,8549,16967,16934,33805,31692,19079,16967,42259,48532,50644,42160,46418,48564,50645,38031,12805,19080,19114,14888,27500,14856,12776,17002,10630,19111,16998,10628,6436,16935,37934,14790,10630,12711,12711,12678,23144,27336,33707,25289,16904,14856,16904,27435,46451,46419,46386,33643,42094,42159,42159,21064,2178,12678,14790,31661,35854,35822,37902,44337,40110,19045,12772,14852,10627,14853,21159,33740,35854,31661,12710,23209,29580,29548,29515,18984,12775,10662,10630,21129,42224,31562,21064,14790,10629,19045,16996,16932,16965,14820,44272,37868,44305,42160,31562,35820,29482,35821,42127,220},
{52889,52857,50809,50809,50809,50841,50809,50809,50809,52890,52890,50841,50841,52890,50841,52890,52890,52857,52890,52889,52857,52857,52889,52889,52889,52857,50809,52857,52857,52889,52857,52889,52889,52889,52857,52857,50809,50809,50777,50809,52889,50809,52857,48729,34004,25584,21358,21326,21358,21358,21358,21358,21358,21358,21326,19245,29712,38229,34004,31891,29811,27698,25650,25618,25651,25618,23570,27731,25618,25586,27763,27763,29843,29843,27731,29810,31891,34004,31858,31826,31859,29746,29778,31891,29811,29811,29778,23406,23374,23374,23374,23374,23374,23374,25487,25487,25519,27599,25487,25454,25454,25454,25486,25486,23373,25454,25454,23406,21261,21261,23341,19147,19147,21228,21228,19148,17002,17034,17034,17067,19115,17066,19147,21227,21227,27500,25387,21161,21161,16968,14888,14888,12775,12775,17001,33806,31629,25355,25321,23240,12806,10694,10661,21192,25386,42192,44305,29580,16935,40177,48564,50676,50611,52756,50644,44305,27434,16934,29646,33873,21227,33807,35887,33742,23275,14953,14919,14918,12806,6468,6403,35853,33741,12710,12711,16936,35854,50513,31529,25192,14790,14791,14791,14824,19016,25290,25257,21031,23144,40046,42159,31628,23210,14823,33774,40080,35886,35886,33708,29483,42160,29578,14852,16964,16964,14852,12772,6467,19048,27403,25354,12742,25354,31693,27435,31628,31628,40112,33773,23209,14790,29547,33740,23176,12677,8516,14852,16996,12772,10626,31659,44273,35821,46386,40047,20998,35788,31595,29515,54870,213},
{52889,50809,50777,50809,50841,50841,50841,50841,52890,52890,50809,50841,52890,52890,52890,52890,52890,52889,52857,52889,52889,52890,52857,52890,52890,52857,52857,50809,52857,52889,52889,52857,52889,50809,52857,50809,50809,50841,50809,50809,52857,52857,52889,48729,38230,38262,34036,25552,21326,21326,21358,21358,21391,21359,21358,19246,29744,36116,31891,31924,31923,27731,25650,25650,25683,25651,27731,25683,25651,25651,27764,27763,27796,29843,29811,34036,34004,34036,36084,33971,31891,31891,29843,31923,29843,31891,31956,29745,29713,29745,29713,29713,29745,29778,29778,29745,31858,33938,31826,29745,29745,29712,31826,31793,29713,29712,27599,25487,21261,21261,21228,21195,21228,23340,23341,23308,21195,21195,17034,17001,19114,17002,21227,23340,23340,29612,27499,21128,21161,16968,10695,10663,8549,10695,12776,23243,23308,23307,23241,19046,17031,16998,16966,23240,33740,44305,42192,29612,19015,42257,50677,50644,50611,48530,50610,42159,16934,14886,27533,33840,25388,46485,44339,38000,21129,14887,14886,8580,10660,10693,10629,33708,44272,31595,12678,16838,40014,52592,41995,23079,12645,14823,16936,16904,18984,25290,27403,23177,23210,35853,40047,25322,23243,8485,18983,31628,35886,33806,37934,52693,25322,10661,14886,14885,14884,16997,16997,6435,16936,25355,27402,14823,25354,42225,23209,29548,29547,31660,42192,46450,42192,37933,31659,14821,16901,16966,14884,12771,14852,12739,31627,37901,33741,40046,46419,40014,42126,33708,37934,57015,217},
{52889,52857,50809,50809,52890,52889,52857,50841,52890,50809,50841,52890,50841,50841,52890,52890,52890,52889,52889,52857,52889,52889,52857,52889,52857,52889,52889,50809,52857,52889,52889,50809,50809,52857,50809,50809,50777,50809,50809,50809,52857,52857,52857,50810,38229,38262,36182,36182,31891,23471,19245,21326,21358,21391,21359,21358,23406,38098,38098,40179,40211,33970,25520,27698,27633,27665,27633,29778,27730,27730,29811,29843,29811,29843,29811,31891,31923,31924,31923,31923,31923,34004,31956,34036,34004,34004,34036,36084,36084,36116,36084,36084,36084,33906,36019,33938,31825,31857,31825,36019,33938,31793,31857,31825,33938,31858,29647,29679,31792,29647,21228,27533,27501,27533,31695,31727,33839,29646,27501,23275,23339,23275,23307,23340,21226,33773,44371,19081,14856,25356,8582,8582,8614,10663,12808,23308,23308,21161,21192,19079,16998,16999,16998,19078,31659,46353,31628,19016,19047,44305,50677,48531,50611,48498,50643,29579,10660,23273,29580,46419,27436,19017,29549,27501,16969,16999,16998,12773,6468,6468,25354,46419,44272,40014,29482,42095,54772,56917,50577,16870,12645,23242,16936,16968,16936,23209,40047,16903,8517,31596,35854,21162,23242,6404,14823,29548,35887,35886,35853,46353,25290,14823,14790,10596,10628,8548,10661,10661,19048,27403,29516,29548,37967,44338,27435,23274,21161,12677,21064,37999,40078,27465,16933,16933,16933,12707,16964,14884,16964,14852,25353,35821,33740,40014,54837,40045,33707,37933,50644,56982,219},
{52857,50809,50777,50777,50809,52890,52890,50841,52890,50841,50809,52890,50841,50809,52890,52890,52890,52890,52889,52889,52889,52889,52889,52890,52857,52857,52857,52889,50809,52857,52857,52889,52890,52922,50809,50777,50809,50777,50809,52857,52857,50809,50809,50809,42390,38229,36149,36182,36214,36149,29778,23439,21326,21390,21359,19278,23406,40146,54936,54936,54969,44405,21195,31760,25421,31760,31727,27534,31760,29614,29614,31791,29679,29646,29679,31759,33873,33872,29679,33904,29711,33872,36017,33905,33905,35985,33905,35985,33905,33905,33905,35953,31791,31759,35984,35952,31727,25421,27501,33807,27501,29581,27501,27533,27501,27500,29582,27501,25420,27533,25388,25388,27500,29581,29613,29614,29580,27500,27468,23307,27500,25387,27468,27501,25387,35886,33773,14855,12775,25388,10695,8615,8582,10695,14888,23308,21227,16967,21160,23272,21191,17031,16998,21159,37998,44305,31628,23242,16967,35853,27402,33741,37934,23176,21160,21159,10693,12774,31693,40111,19016,25356,35888,29582,14856,14886,16965,19110,12773,8548,14789,38032,42160,31563,29450,39948,44174,35787,16902,10564,16902,25354,14824,16904,19016,25322,48466,16870,10598,29515,23177,19049,23242,10565,14823,31693,35886,35886,35886,50644,31629,31629,31661,14790,8451,10628,19047,40112,31661,27403,29548,31628,33709,29548,25322,12710,14790,14823,12710,16902,25320,16900,14820,14820,10627,12772,16964,16964,14853,8547,21128,33773,40047,37933,33642,35722,33643,40046,56983,56917,223},
{52889,52889,50777,50809,50809,52890,52857,52890,52890,52890,50809,52890,52890,52890,52890,52890,52890,52889,52921,54970,52890,52889,52857,52890,52857,50809,52857,52889,52857,50809,52857,52890,52857,52857,52857,50809,50809,50809,50809,52857,50777,50777,50809,52889,50809,46616,38262,36181,36214,38262,38295,36149,27697,21358,21326,19278,23439,40211,48598,46517,46516,48598,42259,44404,42291,44404,44404,44372,46484,44404,44371,46484,46452,44339,44372,46452,46485,46485,44339,44371,44371,44371,44403,44404,44371,44371,44371,42291,42291,44371,40178,42226,40113,44371,44371,42290,44372,42291,42258,44339,33742,42194,42259,42226,42290,42258,44339,42259,42259,42258,40145,40113,40113,40145,40178,40145,40113,40145,40145,38000,40112,40145,42225,42258,40112,40145,23241,14887,19081,19082,8582,6502,6502,8582,14921,21195,21195,19112,21192,21159,21159,27466,21192,21127,42192,44305,35886,21194,6469,19048,21161,29548,31692,16934,12773,16998,10661,10596,31660,33741,16904,19049,31694,27501,16969,17000,14886,19110,19110,12773,4323,12743,25322,21097,12710,31595,33609,19014,8580,6403,33773,29515,16904,16936,18984,25289,46385,23145,27435,37902,35789,18984,23275,10597,8516,14854,35854,35886,37934,52789,33709,12678,21161,27468,19015,14853,14853,29611,35886,27402,27467,31596,25290,19016,33741,35854,37934,33709,16935,14855,21127,19045,12739,8547,8547,10691,12740,8515,4290,6370,23273,46418,37933,35821,29515,40079,29449,44304,57015,54869,203},
{52890,52890,50777,50841,52890,52857,52890,52890,52890,52890,50809,52890,52922,52890,52890,52890,52890,52890,52889,54938,52890,52889,52889,52890,52889,52889,50809,50809,52889,52857,50809,52857,52857,52857,52890,50809,50841,50809,50809,50809,50777,50809,50809,50809,50777,50809,48729,42455,38230,36182,36214,36214,38262,34069,25584,21326,21326,25519,25519,27567,31759,52823,52857,54937,52824,52856,52888,50744,52824,50743,50743,52856,50711,52824,54937,50711,52824,52856,52824,52824,54969,50711,52823,50711,50678,52823,50678,48630,50743,52856,48597,50677,48565,50679,50743,48597,50743,48597,48597,52855,48564,52791,52857,48564,50742,48565,52824,54904,46452,48629,48629,52823,52823,50677,48565,50742,52823,50742,52823,46451,48564,50677,46451,50710,46483,50645,21161,12807,6469,8582,8583,6470,6470,8615,17034,21195,19115,21193,19079,16967,16934,27466,21127,19047,42192,40079,25321,12774,6469,10694,23275,27435,25353,19047,12773,16966,10661,27435,42192,33773,40113,38032,31661,23275,16969,19049,16999,14853,19078,14887,8517,8518,10663,10630,14758,29449,29481,14853,10661,14821,33740,21097,16904,16904,16936,23209,46385,23112,37935,37934,35788,14855,14887,6436,6500,6468,21128,35886,40079,57016,35855,4292,4324,8485,16966,16965,12836,14852,25321,27467,27435,18984,14888,12743,21129,35886,35788,21096,10597,21129,25352,16965,16964,12739,6434,6434,8547,4323,4258,4258,21128,50612,35788,31594,27337,46418,42093,54870,56950,52691,164},
{52889,52889,50777,50809,52890,52890,52890,50809,50809,50841,52890,52890,52890,52890,52890,52857,52857,52857,52889,52889,52889,52889,52889,52890,52889,52889,52889,52857,52889,52857,52857,52857,52890,50809,50809,52890,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,48696,42423,38262,36214,36214,38327,38295,34004,25552,19245,21326,21326,23438,38164,31792,38131,31760,35985,35985,33840,35954,33872,31760,35985,33840,35953,38066,33840,35986,38098,38098,40179,42259,38065,40178,38066,35953,40146,35985,35985,42258,40178,52724,54837,48465,50611,50612,50580,50579,50579,50579,50612,48498,50645,50645,50579,50612,50612,52692,50644,48499,54904,48598,46484,44372,40178,46420,48598,46452,48597,48565,44371,40145,44338,40112,46452,42225,50677,25354,12775,6502,8615,8583,6470,6470,10695,19082,19115,17002,21162,23273,21127,19047,16966,19079,12709,31660,31693,16935,14919,8549,8549,29581,25321,19111,16998,12741,14886,19112,31693,35919,33774,42192,44273,35854,21129,16969,16968,16967,14886,16934,14855,10630,8517,8582,16903,42160,52658,29448,16934,4356,14822,33740,35822,16871,16936,16904,21129,46385,25225,37935,33708,14758,16903,16998,10692,12773,8580,8515,27434,48531,54870,37967,12678,14856,8517,14854,19078,16965,16997,19079,27467,29516,18983,21129,10663,8582,25355,46418,40112,19048,14823,19047,16964,16997,14916,8546,8579,8579,6403,6403,4291,14822,46451,42159,40046,31563,29449,52691,56950,52722,46351,182},
{52889,52857,50809,50809,52890,52857,52890,50841,50809,50841,52890,52890,52922,52890,52890,52857,52890,52857,52889,52889,52857,52857,52857,52889,52889,52889,52857,50809,52857,52889,52889,52890,52890,50809,50809,50809,50809,50809,50809,50809,50809,50809,50777,50777,50809,50809,50809,50809,50809,52890,48697,40375,36182,38263,38295,40375,38294,31890,23439,19278,19278,19213,19245,19246,17132,14987,15020,17068,12907,14955,14955,12874,12907,12874,12874,12906,14987,17100,19180,19148,23308,23340,21260,17034,14922,14922,14922,14922,14954,16937,46288,58899,48335,46190,46189,46190,46223,46222,44173,44141,46222,44142,44142,46222,44142,44141,44141,44109,44109,54838,35888,25388,21163,16970,27469,27469,27436,38000,25354,21160,14823,21161,25321,21160,19047,42160,27499,12807,8583,10630,10663,6502,6470,10695,17034,19082,17002,19114,19047,23273,19047,16902,19080,6469,16968,31661,16967,12806,6469,12775,23273,19046,12805,16966,16999,16967,21161,33806,38032,38000,40112,50612,37999,29614,16969,16968,17000,12742,14855,12775,10630,8550,10630,21096,42094,50480,29416,12741,4356,12741,37966,42160,19017,16936,16904,21097,46353,25289,35822,29451,10598,14855,19048,19112,21191,16965,10692,12709,19047,14789,21095,19049,8518,12711,16903,14854,14853,14852,19079,25322,31693,33741,37967,21129,10663,10630,33773,37966,29515,14822,12740,16965,16964,16997,14916,16996,12772,6467,4355,4291,12676,48531,54870,42126,35787,37899,56983,56950,52723,44272,180},
{52889,50809,50777,50809,50809,52857,52890,50809,52890,50841,52890,52890,52890,52890,52890,52857,52857,52890,52889,52889,52857,52889,52889,52889,52857,50809,52857,52857,52889,52857,52889,52890,50809,50809,50809,52890,50841,50809,50809,50809,50809,50809,50809,50809,52857,50809,50809,52857,50777,52857,52857,50809,46648,40342,38262,38295,38295,40407,40342,31858,19245,19246,17165,21326,17133,14988,15020,15052,12907,14987,15020,12907,12907,12939,12907,14987,17068,17067,17100,19180,21260,23340,23308,17067,14955,12874,12874,14954,14955,16938,48336,54737,46223,46223,46221,46190,46223,46254,46222,44142,46190,46189,44141,46189,44141,44141,44141,44141,44141,48499,31728,23309,19083,19051,27469,27501,29581,38000,19112,23306,19081,21161,23241,21193,16935,37967,27435,19080,14856,16968,25387,21097,10663,10695,19082,19083,14921,19082,19047,16934,23241,21160,16935,8549,19016,29548,21192,10661,8582,27500,23240,19078,14886,16967,19048,21129,25289,33806,40080,44305,52757,44241,35854,35920,23275,14888,12775,12807,12775,12711,10662,10565,25225,48433,54804,37933,18982,10629,8516,23208,50676,40047,18984,16936,16904,21097,44272,31563,35789,33709,14823,16936,21195,25388,21129,21160,14917,14886,10693,8548,12774,8517,14856,14791,12645,14788,16965,16965,14853,27435,23242,12678,29547,44305,31660,23242,23175,16901,14821,14822,8547,19046,16997,16964,19077,19077,14853,10628,4323,4291,10531,40079,46352,33643,33706,52723,56983,56982,44174,42159,188},
{52889,52857,50809,50809,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52857,52889,52857,52857,52857,52857,52889,52857,52889,52857,52857,52890,52890,52890,52889,52857,50809,50809,50809,50777,50777,50841,50809,52857,50809,50777,50777,50809,52857,50809,52857,50809,50809,50809,50777,46616,40374,38294,40375,40407,44568,40310,29777,19213,19278,17100,12907,14987,14988,12874,12907,14955,12875,12874,12907,12907,14955,14987,14987,17100,17034,19148,19180,21228,14954,14922,12842,12874,12874,12841,16937,50480,54706,46222,46221,46189,46221,44140,46222,46222,46189,46221,46188,46188,46221,46221,46221,46221,44141,46189,40013,33808,27534,21195,21163,31726,27533,27436,33773,21225,23273,17000,16968,21161,21225,19048,35919,31693,19112,21193,21193,31595,37804,33774,17002,19115,19082,12808,16969,23275,21161,38031,35886,14822,10662,19113,29548,19047,10694,6436,14822,19079,16966,16966,25354,21097,29515,35854,33773,35918,40112,48531,35854,31596,33742,21195,12775,10663,19081,10630,10662,12711,12710,29449,23142,21062,23207,16934,10693,14854,27367,50643,42160,16903,14856,16904,21097,42159,37901,31595,35822,19049,23243,21162,23275,19082,19049,17000,14855,14919,10629,23242,16936,35887,23209,14757,23239,25350,23238,16966,25322,19016,16936,42224,46450,46418,44305,35852,21094,14821,10628,4355,10596,16997,16997,19077,19046,12740,14821,8516,4323,2210,25321,44174,33708,31561,56982,56983,50578,31562,40014,179},
{50809,52857,50809,50809,52889,52890,52890,50809,50841,52890,52922,52890,52922,52890,52890,52890,52890,52890,52890,52889,52889,52857,52857,52889,52890,52889,50809,52857,52857,52889,52889,50841,52890,52857,52889,50809,50777,50809,50777,50809,50809,52890,52857,50809,50809,50777,50809,50777,50809,50777,50809,50809,50809,50777,50809,50777,46648,40374,40375,42488,44568,46648,36116,27697,27697,25584,23471,23439,23439,23406,21326,21294,21326,23406,21326,21325,21293,23373,23373,23406,23406,23405,23405,21293,19212,19180,21261,21261,21228,23308,37934,46319,46188,46221,46222,46221,44140,46189,46222,46221,46253,46253,46221,46221,46221,46253,46220,46221,46221,44239,42259,38067,25389,23276,29613,25420,31629,40079,27499,19112,16968,19080,17000,19080,14887,38000,33806,19112,17000,17000,31660,37934,31694,12808,12744,12776,10663,16970,14824,19017,23209,23241,16935,12742,19080,31694,23241,10661,8549,16999,21159,19110,19078,23241,25290,31596,27337,27435,38064,37999,33741,23242,33774,38001,19082,17001,14856,21162,8517,12710,14791,16903,25256,16934,16935,25353,16934,8516,23240,40045,54804,46418,21129,16904,16936,19016,40079,35756,31595,37934,33774,25387,19081,21227,19114,17001,16969,12775,12775,16936,33742,16903,21161,31661,27435,14757,18981,27466,25322,25322,23242,31693,46450,44369,44337,46450,42159,23207,12740,12773,10660,10595,14885,19078,21158,19046,10628,16966,10628,4291,2178,25289,44239,39981,42191,59063,56918,37835,31627,37933,163},
{50777,50809,52857,50809,52890,52889,50809,52890,52890,52890,52922,52890,52890,50841,52890,52890,52890,52890,52890,52889,52890,52857,52857,52857,52889,52857,52857,50809,52889,52889,52889,52890,50809,50809,52857,50809,50777,50809,50809,50809,50809,52857,50809,50777,50777,50777,50809,50809,50809,50809,50809,50777,50809,50777,50777,50809,50809,48728,46616,44535,44503,44536,42455,34068,34068,31955,29810,29810,29777,29810,29777,27664,29745,29745,27664,27664,27664,29712,27664,27632,27632,27632,27599,27599,27599,27599,29679,29679,29712,29711,31726,40047,42126,42126,42127,42094,42126,42095,42095,42094,42094,42094,42062,42062,42094,42093,44174,42061,39948,46321,33841,29615,21195,17002,23276,23276,35887,37966,29548,23273,19113,21193,17032,17032,14855,21194,25355,19080,12807,12742,35821,29549,29581,12776,8550,14856,27469,38034,23210,21064,19016,21128,19015,19048,27435,27468,25354,10693,10661,19111,21191,16998,21159,29481,37902,23177,23242,23274,12710,25323,31662,21130,23243,35953,19082,14889,17001,16937,8517,10662,14823,21096,25256,21127,35919,23272,12741,10628,48530,52691,48497,46417,33677,14824,16936,21097,40047,35821,31628,42127,33741,35887,27500,23275,19082,17001,19050,10662,12743,25323,35855,12743,4324,6404,14790,19016,12709,12677,12710,21129,14856,19048,37999,46450,42224,33740,23175,16901,10627,14853,16965,16965,16965,14853,12772,19046,10596,12741,4322,2210,2178,21129,37933,44239,56950,56949,50578,42127,40014,40046,154},
{50777,52857,50809,50809,52890,52890,52890,52890,52890,52890,52922,52890,52922,52890,52890,52890,52890,52890,52890,52889,52890,52857,52889,52889,52857,52857,52857,52857,52890,52889,50809,50841,52889,52889,52857,50809,50809,50809,50809,50809,52857,50809,50777,50809,52857,50809,50809,50777,50809,52857,50809,50777,50777,50809,50777,50777,50777,50777,50809,48696,46648,44536,40375,31955,34036,31923,27729,29778,27664,29777,27664,27632,27664,27632,27599,27632,27599,27631,27632,27599,27599,27599,27599,27567,27566,27567,27599,27599,27598,29679,29647,29646,29646,29646,27533,29646,33839,31694,27533,29613,29581,27468,27436,27436,27436,27436,31661,29580,18984,29581,29647,23341,21164,19083,17035,21196,40080,33741,21162,25386,19113,14920,12839,14919,17032,10662,12807,17000,10695,16968,42160,29516,27469,12809,8550,29646,50743,50678,27403,21032,23177,23176,21160,23208,29548,23275,25386,14919,10693,19079,19078,16998,19045,40078,42160,23177,25387,29645,12710,27468,31727,23308,25389,35953,21162,12776,23307,14856,8549,12711,14791,16838,27369,21127,29580,23240,10596,18982,37869,40014,37900,39980,31596,14856,16936,18985,35854,37934,27434,37934,16871,21097,25355,19081,14889,19082,16936,12743,14856,31661,35887,16839,12678,23242,35919,48564,35918,16935,10662,12775,10695,10663,14823,37966,46417,35820,21125,19044,16932,14820,16964,19045,16932,12772,10660,12773,12708,8516,4291,2211,2178,19016,33708,48466,56982,54803,48431,46385,37966,37966,157},
{50809,50809,50777,50809,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52857,52857,52890,52890,52889,52857,52889,52889,52889,52857,52890,50841,50809,50809,50809,50809,52857,50809,52890,50809,52857,50809,50809,50777,50809,50809,50809,52857,50777,50777,50777,50809,50809,50777,50777,52857,50809,50777,50777,50776,50777,50776,50777,50777,48696,40375,34035,34036,31923,29810,27697,27665,27665,27632,27664,27664,27632,27600,27632,27632,27664,27599,27599,27599,27599,27599,27599,29679,29679,31727,29679,29646,31727,29647,29679,31759,31727,29678,31759,33871,31726,29581,27502,25421,25356,23308,23308,25356,23275,31662,33806,16904,25420,29647,23309,19050,19083,17002,23276,37999,35854,23275,21161,21193,17000,12775,14887,19112,14888,10694,17032,19112,19048,29548,33741,27469,12809,8583,10630,27501,48597,29484,25193,25257,23144,25289,25321,23241,23243,23274,10694,10661,16998,14886,16998,21191,27401,27370,23177,23242,21129,12711,25356,42260,27469,21196,35953,21195,12776,31758,23275,6437,10663,18984,31562,31561,21127,14886,19046,16901,42192,37901,35821,29449,31529,25322,16936,14856,19016,35821,37967,21063,40047,16871,16904,16904,16968,12776,23275,19017,10598,25323,33806,33773,37967,50710,57016,54903,50644,35853,23209,19049,12775,10695,10695,10630,19015,33707,31626,25350,21157,21157,19045,14852,16965,19077,10660,12773,12741,12741,10628,6403,4290,4290,14822,42159,56950,54869,54836,52690,46385,37966,37933,155},
{50777,50809,52857,52857,50809,50809,52890,52890,52890,52922,52890,52890,52922,52890,52857,52890,52890,52890,52890,52890,52889,52857,52857,52889,52857,52857,52857,50809,50841,50809,50809,50809,52889,52857,50809,52890,50841,52857,52857,50809,50809,50777,50809,50809,52857,50777,50777,50809,52857,50809,50809,50809,50809,50809,50809,50776,50777,50776,50777,50744,50777,46584,40342,42423,38197,34036,31923,29811,27730,27698,27665,29778,31858,31891,29713,29777,31857,31858,31858,29777,27632,27600,29680,33873,42292,42291,46419,46451,44338,46419,42259,38033,48533,48532,46483,46483,46483,46451,50613,35920,27502,27502,23275,25388,42226,31596,33709,37934,21097,31727,31728,23341,17003,17035,17002,27502,40079,37934,27499,21160,23273,21193,12807,12775,19112,17032,12807,12775,27465,21158,29548,29549,27469,12808,10695,8549,6436,17001,19017,37935,35854,21096,14758,27468,25355,25388,19047,10693,12773,19111,12773,10693,16966,25321,25290,23242,23242,19049,12776,21130,46421,31663,19018,35953,21163,14888,38065,31694,8550,10631,18952,37803,44140,16902,8516,12741,23207,52724,48433,50612,44272,46354,25290,14856,16937,19017,33709,42127,21096,42128,16871,16936,19016,21130,19049,29614,40112,40081,35855,35822,33774,37934,42192,48563,52756,33707,27369,29547,33742,19049,10663,10662,12742,19014,14788,10594,19077,19077,19077,16964,14853,14820,19045,8548,12741,16934,16934,10596,6371,4323,4290,16934,54804,59030,56949,56884,59030,50579,37966,40014,155},
{50809,50809,50777,50809,50809,52890,52890,52889,52890,52922,52922,52890,52890,52890,52890,52857,52890,52857,52890,50809,50809,52889,52889,52857,52890,52889,52890,50809,50809,50809,50809,50777,50809,52857,50809,50809,52857,52857,52857,50809,52857,50809,50841,50809,50777,50809,50809,50809,50809,52857,50809,52857,52857,50809,52857,50809,50776,50777,50809,50809,50777,46584,40342,42423,40310,36084,31924,29811,27730,27698,27698,29778,31858,33939,29745,31858,31890,31857,31890,31890,27664,29713,29680,33873,42292,44339,46419,48499,46418,48531,48565,44339,46419,46419,44338,44338,44338,46386,48531,33807,23309,25422,23276,35856,48532,33644,37870,40015,19017,35920,29647,23341,17003,17002,19083,33775,42127,37934,25354,19048,21225,21225,14920,12807,19112,19112,14919,8614,19079,21191,16968,25355,33742,25323,19114,19082,19082,19050,23210,50645,42225,19048,12742,21162,23275,27468,21127,16966,12774,19111,19078,12805,16967,31660,25258,23210,19049,21162,14856,14823,27468,27502,23276,33808,21162,25355,38064,25355,14856,10630,18952,25224,35754,10596,6469,8516,21128,37836,54839,52692,42095,40014,27402,16904,16937,19017,31660,44240,23176,42160,18952,16936,16936,19049,19017,25356,25387,23209,35854,35886,35822,35854,35853,37934,42191,27465,12740,16934,19017,14856,10662,12711,19015,23239,14820,10627,16965,12739,14884,19077,14852,14852,16934,6469,6436,19048,21160,8516,4291,4291,4291,10596,29417,27336,29416,29416,29481,40046,42127,37933,152},
{50809,50809,50777,50809,52890,52922,52890,52890,52890,52922,52922,52890,52890,52890,52890,52890,52890,52890,52890,52890,50841,52890,50809,50809,52890,50809,50809,50841,50809,50777,50809,50809,52889,52857,50809,50809,52857,52857,52857,52857,50809,50809,50809,50809,50777,50809,50809,50809,50809,52889,50809,50809,50809,50777,50809,50809,50809,50777,50777,50809,50777,46616,42423,40310,40310,36117,31924,29811,27730,27730,27730,29778,31858,36019,31826,33939,33938,29777,29745,29745,29745,31825,29680,33905,40211,42291,40113,44274,46386,48499,44339,38000,46387,46354,42225,42225,44273,42160,40112,35888,21196,23277,23309,27469,44339,35789,42096,37934,21065,33774,38098,29680,19083,16970,23309,27468,39982,37934,31693,19080,21193,25386,14920,10662,14920,14919,17032,12807,21161,16999,8549,21096,44273,31661,19049,16969,23243,23276,29516,50677,38032,25387,25387,21163,23276,31629,29515,19081,10662,14854,16998,19110,19047,37902,27403,14856,14823,27501,16936,14856,25356,25388,23308,27469,21130,33774,33807,12743,19050,12710,18985,21063,23239,10693,6468,8516,12677,46386,54871,42063,52757,42127,27402,16904,16936,19016,29515,46321,23144,44240,18984,16936,14823,21130,23274,23275,23275,23242,33774,35854,35822,35821,35821,37901,40046,27401,21126,16934,10630,19049,25354,25289,23208,21158,14852,12740,16965,14884,19045,19044,23272,27467,16936,6404,10663,16969,23241,8483,4290,10596,8516,2210,2178,4290,4258,2210,4290,25288,37933,35820,166},
{50809,52857,52857,52857,52890,52890,52890,52890,52890,52890,52922,52890,52890,52890,52890,52890,52890,52890,52890,50809,50841,50809,50809,50841,50841,50841,50841,50841,50809,50809,50809,52857,50809,52857,52857,52857,50809,52857,52857,52857,50809,50809,50809,50777,50809,50777,52857,52857,50809,50809,50809,50809,50809,50777,50777,50777,50809,50776,50777,50809,50777,46616,40342,40310,38165,34036,31956,29811,27731,27698,27698,29810,31891,36019,36019,31858,31858,29745,27664,29745,29744,29745,29712,33938,40211,44371,40113,44306,46386,48498,42258,40145,44338,44306,44338,42225,44273,42193,40080,42194,27404,25357,25389,23276,38033,31629,40080,46386,31629,33775,35986,29647,21196,21196,19082,25355,40014,37901,23241,16968,19081,21193,14920,10695,17000,12839,17031,19080,21192,21192,14887,23241,52725,31661,19049,14888,23243,25356,35855,46451,33774,21162,23242,23276,23276,27435,31629,25323,14856,12743,14854,23304,23272,31563,27339,18985,25290,29581,14824,23308,25421,21228,23308,31662,23210,38032,23307,8583,14856,14791,19017,18983,19046,10693,10661,8548,25321,37867,46320,35821,44273,37837,31595,16904,16936,16937,23210,44272,25289,44240,19016,16904,21162,27468,35920,27500,25355,33741,35854,35854,35854,35854,35853,42192,44240,37933,42224,25321,12710,10662,31693,40111,33708,27432,19045,14852,19077,16932,12740,21125,31658,37999,27435,8517,17001,17001,27402,12741,8548,12740,8548,6403,2210,6371,4258,2178,8483,31626,35788,27402,119},
{50809,52857,52857,52857,52857,52890,52890,52922,50841,52890,52890,52890,52890,52890,52890,52889,52857,52890,52890,52890,50841,50841,50841,50809,50841,50809,52890,50809,50809,50809,50809,52857,50809,50809,50809,52857,50809,52857,52857,50809,50809,50809,50809,50777,50809,52857,52857,50777,50809,50776,50809,52857,50809,50809,50777,50777,50777,50776,50777,50777,50777,46583,40342,42423,38197,34036,31924,27698,27731,27698,27666,29746,31858,42325,38099,33938,31858,29745,29713,29777,31825,31793,29680,29712,40211,42291,42258,48499,46385,48531,44306,42225,44370,44306,46355,44306,44306,44306,46386,46322,37903,31598,25356,23243,33840,31597,40015,50612,27436,31727,31760,25421,25421,23341,17002,23275,37934,42094,46386,27500,17000,23274,10695,12807,21225,17000,19112,25384,21192,14855,14855,29547,56984,33710,21130,14888,21195,25355,42161,48597,21161,8517,21161,38065,23275,23210,35855,29516,16936,12808,12743,19080,23272,46386,29483,23177,25290,25355,14856,23309,27502,23309,27533,40113,31694,38000,14888,8583,10663,16936,21065,18983,21159,10628,10693,8548,37966,54837,40013,27401,25224,23112,27402,16936,12775,16904,23209,44272,25288,46386,21064,25323,27436,27468,33807,29548,27403,33741,35854,35886,35854,33773,37934,52822,57016,54935,54935,50612,18984,10630,16936,42225,48497,37964,19045,16997,19077,12740,6435,10627,16933,8450,12742,16969,17034,16968,21128,14821,14854,14821,16934,12741,6403,2178,4290,8547,14853,23143,35820,33676,127},
{52857,52857,50809,52857,52890,52889,52890,52890,52890,52922,52890,52890,52890,52890,52890,52889,52890,52890,52890,52890,50841,50841,50809,50841,50809,52890,52890,50809,50809,50809,50809,52857,50809,50809,52857,52889,52857,50777,52857,52857,50809,50777,50777,50809,50809,50809,50777,50777,50809,50777,50809,50809,50777,50777,50777,50777,50777,50776,50777,50777,50777,46616,40342,40342,40278,36085,31924,29779,29811,27730,27698,29746,31858,42293,35987,31858,31858,31858,31858,31825,29777,29713,31793,36018,42324,42323,42258,48532,46418,48531,42225,42225,44305,44306,46354,44274,42258,42225,46353,44241,48467,33743,25357,25356,40146,31597,37967,42193,25323,31663,40179,33840,31727,29614,25421,29548,37901,40046,52757,27499,19113,23274,8582,10695,21193,17032,16999,29577,21191,14887,12709,33707,52725,31629,21130,14856,23243,25356,37999,29612,14854,14854,31660,57049,33806,29549,31693,25388,10663,12743,12775,25322,27402,44305,27337,27402,33709,29548,14856,23276,27534,25389,25420,33774,35920,27468,10663,17002,17001,21096,25322,21127,19078,12773,14853,12741,35853,56984,35755,44305,37901,29385,27338,18984,14824,21162,27402,46385,25224,44305,29483,33774,27403,27436,33774,29581,29548,35822,35854,35854,35854,33773,40079,46321,48465,50643,44272,37933,27435,25355,16935,27434,33772,25351,16965,16997,19045,16965,12772,21128,27434,10597,16968,21195,16969,19048,23208,16934,12708,12740,14821,16966,8516,2145,10628,12772,10596,27402,33707,35821,154},
{52857,52857,52857,52857,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52857,52889,52889,52890,52857,52890,52857,50809,50809,52890,50809,50809,50809,50809,50809,50841,50809,50809,52857,52889,50809,50777,50809,50809,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50777,50777,50777,50809,50777,50777,50777,50777,50777,50776,50744,50809,46616,40343,40310,40310,34037,31924,29811,29811,29778,27698,29778,31859,40212,42260,33905,33938,29745,29745,31858,29745,27599,27600,40244,38066,31792,38097,46451,46418,48531,46387,46387,44306,44338,44339,44307,44306,44338,46451,40015,48499,29550,25324,27437,42292,31629,35822,40112,29581,27469,23309,27534,27501,31727,31727,33709,39982,35853,37999,21161,19080,23274,10663,6502,14888,17032,21192,29609,25352,19112,14822,35821,44307,29581,21162,21129,23275,25356,38000,42225,29611,21127,27434,52855,35919,16967,16967,14855,8582,10662,21129,29548,27403,31660,42128,35789,25354,29548,19049,21195,27534,23308,23276,38000,29581,12776,10663,25388,42226,46353,46352,29512,19078,19078,16966,16901,42225,50580,37837,42127,46320,44176,29483,16936,19017,23210,25289,48466,25223,44240,37902,37967,35855,29548,38032,33774,33774,35854,35854,35854,35854,35886,50612,44240,40015,33741,16869,10628,10628,29612,40112,27401,14821,19014,19077,16965,16965,19109,19077,29611,42193,23177,29580,27468,16969,21129,21095,14821,12708,12709,12741,10628,4323,4226,14820,10595,8451,21096,23111,31562,179},
{50809,52857,52889,52890,52922,52922,52890,52890,52890,52890,52890,52890,52890,52890,52889,52857,52889,52890,52889,52889,52890,50809,50777,52857,52889,50809,50809,50809,50809,50809,50809,52857,52857,52889,52857,50777,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50841,50777,50809,50809,50809,50809,50809,50777,50777,50777,50809,50777,50777,50776,50809,46584,40310,40310,38262,34037,31924,29779,31891,29811,27698,29778,31826,38100,50646,44371,38163,29745,27632,31825,29777,29712,31825,42324,40179,33938,38065,44370,46418,48563,46387,46419,44273,44305,46387,46355,44273,44305,48565,40015,40080,27404,25356,27404,44340,37968,29581,31727,27469,21195,12809,19083,19147,17034,19082,25323,33708,48499,44305,23274,21193,19081,10662,8582,6502,8582,19048,27464,23272,21160,16935,27500,40211,29581,25387,27436,27468,25355,40081,57017,54968,42225,19046,33838,33805,16967,12806,12775,10662,8549,14823,29515,35821,33741,50580,23209,12711,33806,23242,21162,27534,25389,27469,44307,31662,10663,14856,33742,44273,50545,50447,35786,21190,19078,14853,14789,29514,46288,48466,52758,56983,48401,35822,16904,16937,19049,25257,48466,25192,42128,29451,23209,27435,29548,27435,27468,35854,35854,35854,35854,35854,42160,37935,19016,10630,4324,10694,8548,8516,8516,31692,29545,16933,16933,14821,19077,16965,16964,14884,12740,8484,19016,35854,33774,21162,14856,19048,14822,6403,4291,6371,2178,2178,8483,27432,35788,29450,27369,18983,23111,148},
{50809,52857,52889,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52889,52890,54938,52890,52857,50809,52889,52889,52857,52857,52857,50809,50809,50809,50809,50809,50809,50809,52857,52889,50809,50809,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50776,50776,50809,50777,50809,50809,50777,50777,50777,50777,50776,50776,44535,40310,38229,38230,36117,31923,29778,31859,29778,27665,27665,29713,33906,40178,42259,33905,27600,25519,25552,27600,27632,27599,35953,33873,29712,35985,42258,42225,46451,42225,44371,44306,42225,44338,44339,44306,44338,46419,40015,40048,29581,29549,29549,44372,40113,14856,21163,25389,25421,19114,21196,17035,14889,14889,23275,35821,33774,27500,21161,25353,21193,14888,10695,6502,10695,21160,25416,21191,16999,14855,29613,38066,29581,25355,27436,27468,25388,31661,48500,57017,40112,16934,14854,23272,14918,10726,10726,12806,10661,16935,27402,33740,35821,35821,18984,14824,29548,16936,23243,33808,27534,23243,33807,31662,14888,19082,38000,46385,52593,48366,37932,21191,16965,16998,16998,27434,46254,44174,42126,46320,33643,42193,21129,19017,19017,25322,48498,29418,42160,27371,14823,14823,21097,23242,21129,31693,35854,33806,35854,35854,44240,14758,4357,6469,8581,10661,8548,4355,4323,12708,21158,19046,16933,16933,14884,14852,23273,27434,12710,8452,31661,35854,35854,31694,16969,12775,8484,6372,8484,10629,4290,12677,27369,42127,42127,35755,31595,27402,31496,159},
{52890,52890,52889,52890,52890,52890,52890,52890,52890,52922,52890,52890,52890,52889,52889,54970,54970,54937,52889,52889,52857,52889,52889,52890,52890,50809,50809,50809,50809,50841,50809,50809,52857,52857,50809,52857,52857,50809,52857,50809,50809,50809,50809,50809,50809,50809,50809,50777,50777,50809,50777,50776,50777,50777,50777,50777,50776,50777,50777,50776,50809,46583,40310,38229,38230,36117,34004,29745,27600,27600,23374,17002,19083,17035,17002,17035,14954,14955,14987,14955,14954,14987,14955,14954,14987,14987,14987,17067,29711,33839,33806,33806,33774,33774,33806,35887,33838,33806,33774,33774,29581,29614,29581,29581,31662,31727,17001,21228,23276,23276,21195,19147,14922,19083,19082,25388,33775,16936,12776,19049,25385,21192,14887,12808,12775,19048,29545,27496,21191,12742,14823,29581,31825,27533,23275,25388,25388,25356,27468,46419,44306,16935,21160,12806,16999,14918,14886,12774,14886,12774,14790,42159,59031,46320,29548,21097,25258,27435,16969,25388,44372,40179,25324,31694,31726,23275,27468,42160,50577,50479,46253,25287,10628,10661,12805,19078,29547,44207,44207,33739,33675,27272,33677,16904,16936,19017,25322,46418,35790,44241,27435,16904,16904,19016,27468,27468,31661,33774,33774,33773,37999,54903,23242,4356,8549,16967,10693,10692,12741,6436,12740,19013,19046,12740,14885,14852,12772,33806,37999,19016,19016,35886,35854,35854,37967,27468,12743,10662,8517,12775,8516,6370,40079,52691,44305,35788,35788,35756,42093,56750,230},
{52889,50809,52889,52922,52890,52922,52890,52890,52890,52890,52890,52889,52890,52889,52889,54970,54969,54969,52889,52889,52889,52857,52889,52889,50809,50809,50841,50809,50809,52857,52857,52857,52857,52857,52857,52857,50777,50809,50809,50809,50809,50809,50809,50809,50809,50777,50777,50809,52857,50777,50777,50809,50777,50777,50777,50777,50777,50777,50776,50777,50777,44535,40310,38230,38197,36117,36084,23341,17002,19082,21195,23276,23308,23309,10793,10794,10794,10794,10794,10794,10794,12874,12874,12842,12874,12842,12874,12874,31825,29679,25388,27436,27468,27469,27468,27500,27532,27468,25420,29614,14889,21195,14921,19082,19082,16970,21195,23308,23243,25388,17002,17035,12809,29614,25356,23275,23243,21163,19082,19082,27466,21192,21192,16967,21129,23241,29577,25416,19079,19080,25289,38000,31792,29582,25355,25355,25356,27469,27501,40113,25354,16934,23273,16966,16966,16966,12806,10693,12838,8613,8581,29515,46352,37803,31595,23177,31596,37967,21097,12711,19049,38034,25356,31693,27468,27468,33774,42192,50544,48333,33674,14821,8580,6500,8580,10693,35853,52725,46320,35821,35788,33643,31660,16936,16937,19017,23242,46386,29387,37936,29548,16904,16968,19016,21161,23242,29581,29580,35854,33773,42160,52724,25322,4356,14888,19048,19078,12804,12773,8548,12773,16933,19046,14853,14885,12804,12772,16901,12708,10597,33741,35886,35853,33773,25290,16903,12743,8549,8548,12741,4290,19015,52757,50611,40111,31595,33707,37868,46221,48299,188},
{52857,52890,52889,52890,52922,52890,52890,52890,52890,52890,52890,52889,52890,52922,52890,52889,54937,52889,54970,52889,52857,52857,52889,52889,52857,50809,52890,50841,52890,52889,50809,52857,52890,52857,52857,50809,50809,50809,50809,50777,50809,50777,50777,50809,50809,50809,52857,50809,52857,52857,50777,50809,50777,50777,50777,50777,50777,50776,50776,50776,50777,46616,42423,40310,38229,36117,34004,23341,21163,21163,21196,25389,27469,25421,12842,10794,10794,10794,12874,12842,12874,12874,12842,12874,12874,10794,12874,14987,33970,29679,21195,23243,25388,25388,23275,25388,19115,17002,19082,27502,14921,19147,14921,19115,17035,14889,21195,25388,23308,21195,17002,21228,14856,35920,27436,23275,23243,23275,23243,21130,23306,23305,25353,23273,21128,27466,25383,25384,14919,12774,31595,52791,31760,29614,23275,25355,25356,27501,27501,42226,27500,19047,23209,14855,16967,14886,12838,12774,12838,12774,8581,16871,40046,37770,37934,42193,56984,50612,21129,12711,14856,33840,23308,29581,38000,27468,31661,44272,46287,39980,23239,14886,10661,8613,10661,8516,35886,59163,50579,54936,44273,44207,33676,18984,16936,19017,23209,44305,29452,37903,31628,16904,16936,16903,25387,23242,29548,25354,33741,37934,46418,42127,25257,8518,27500,23273,14885,16966,12773,14853,16966,19046,19046,16997,16933,14885,19047,25354,16903,23242,37967,35886,35854,33741,14822,12710,10630,10629,16966,10660,8515,23207,35853,42225,33806,33708,33675,33675,33642,27303,96},
{52889,54970,52890,52889,54970,52890,52890,52889,52890,52890,52890,52890,52889,52889,52922,52889,52889,52889,52922,52889,52857,52889,52857,52890,52890,50841,52890,50809,50809,52857,50777,52857,52890,50809,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,52857,50809,50809,50777,50777,50776,50777,50777,50809,50777,50777,50776,50744,50776,48664,42423,38230,38229,36117,36052,29713,27567,21261,23309,23308,25421,23373,10793,10794,10794,12874,12874,12874,12874,12842,12874,12874,12842,12842,12874,14987,33937,29711,29711,27533,29548,29548,29516,27469,12809,8648,10729,25421,14922,21228,14921,19115,19115,17001,23340,23276,21195,17002,16970,29582,19049,33741,29549,29548,29516,27468,27436,25355,21160,25353,25385,25353,23208,31658,25415,23272,21160,14854,33741,52823,33808,29614,25355,25388,25388,27534,31727,40114,27500,21160,16903,8549,12774,14918,12805,12838,12805,10725,10662,27435,27337,33577,52757,59097,57049,48531,16936,10663,21195,29615,23276,29581,35888,23243,21162,23209,21064,18982,14885,19078,14885,12773,12773,12709,31594,48465,50644,61276,48563,40014,31595,19016,16904,16936,21097,44305,29451,31628,35789,14823,16904,25355,31694,31694,27468,29516,31596,48532,52758,54903,33774,6405,10597,23274,21160,14854,14853,14853,14853,19046,23239,19078,16965,16933,23273,40079,31595,33773,35886,35886,35886,33773,16903,12743,10630,8484,19016,16933,16933,21127,27402,23274,38065,35821,33675,33643,31562,27336,99},
{52890,52890,54938,54938,54970,52922,52922,52889,52889,52890,52890,52889,52889,52889,52890,52889,52889,52889,52890,52890,52890,50809,52889,52890,52890,52857,52890,50809,50809,52889,52857,50809,52857,52857,52857,52857,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50777,50809,50777,50777,50809,50809,50809,50777,50777,50777,50744,50776,50776,46583,40310,38230,38197,36117,33971,29713,29680,23374,21228,19147,23341,21228,12874,12906,12907,12906,14987,12907,14955,14955,14955,14955,12874,14955,12906,19148,36018,31726,33905,31759,31629,31661,31662,27502,12842,10697,12809,25454,14922,21196,17002,19115,21195,17034,21195,23308,21195,17034,14921,21195,19017,44338,54936,54903,54904,50710,50611,42094,25353,21160,23273,31660,31659,29576,27528,19079,14854,14886,29613,46484,33808,31727,25355,25355,27468,27534,31728,40146,27500,19079,14886,12838,19111,19111,16998,16998,14853,14886,8517,21129,27337,33545,46287,50644,50644,44240,16936,10663,25389,27535,25389,40145,35855,21097,25387,25355,21096,19046,16933,16997,14885,12741,12741,14854,31594,37835,42126,46385,52757,50644,46385,27370,16936,16936,21097,42192,33676,29515,37902,16871,25388,27468,31694,33774,27467,29548,27435,29483,29418,23112,23210,6437,6405,4356,8549,10565,10564,10564,10629,12741,21159,23271,23270,16933,10596,8484,25354,37966,35854,35886,37934,35854,19016,12710,6404,16968,18983,10531,14821,21127,29547,23209,31628,31562,33675,31530,31563,31530,127},
{52890,52890,54970,54970,54970,54970,54970,52890,52890,52890,52889,52890,52890,52889,52889,52922,52889,52889,52889,52889,52889,52857,52889,52890,52889,52857,52857,52857,50777,50809,52857,52857,52890,50809,50809,52857,52889,50809,50809,52890,50809,50809,50777,50809,50809,50809,50777,50809,50809,50809,50777,50777,50777,50776,50776,50777,50776,50776,50744,50744,50776,44503,42391,38230,38230,36117,33939,29648,27599,21228,19115,19115,21196,17035,17067,17100,17100,15019,14987,14987,14987,14987,14987,14987,17067,14987,14987,17067,29711,29646,27533,27533,27533,29646,33841,25487,12874,8648,10729,25454,14921,19147,14889,19083,19147,17034,19115,21163,23276,19083,17002,19147,14856,46354,56983,54838,54871,56821,54642,48433,25353,16999,16935,25386,38063,27496,23271,23305,23243,23243,29614,33807,29647,31695,25323,25388,27468,27502,31727,40114,27468,19080,14918,16999,19111,21191,19078,19111,19111,14886,8581,12774,23143,41930,39915,48564,50612,37902,21097,14856,23276,25421,29582,48532,46354,33709,35854,35822,31595,23239,23239,19078,12805,12805,12773,14822,19014,37998,44207,42192,40079,42159,42061,27402,14824,16936,21129,40111,40047,29514,37934,29516,27468,25355,29549,31662,27468,27468,29516,23210,21097,27402,25387,6404,6437,6405,6437,12679,12613,10533,14823,14823,14823,16934,25385,29547,14855,10597,35854,35886,35886,35886,35886,33741,27402,25322,16871,25387,29516,12612,10531,14757,31596,23177,23208,40047,33708,29482,29417,29417,132},
{54970,54970,52922,54970,54937,54937,54938,52890,52890,52890,52889,52890,52890,52890,52890,52889,52889,54970,54970,54970,52857,52857,52889,52889,52890,52857,52857,52857,52857,50809,52890,52857,50809,50809,52857,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,52857,50809,50809,50809,50777,50777,50776,50777,50777,50776,50776,50744,50744,50776,44503,40342,38230,38197,36117,33873,29648,25454,21228,21228,19115,21260,21229,21294,21326,21358,19213,17068,17100,17100,17100,19180,19180,21293,19180,14987,17067,19148,19180,17067,17067,17067,17067,29647,25454,14922,10697,10729,25421,14922,21196,14922,19115,19050,17034,21195,21195,23308,19083,17034,21196,17002,27468,27436,42128,54838,54837,54903,44338,23240,21192,21161,19016,21160,25385,21127,38032,29548,27468,29549,31694,27534,31727,25355,27436,27501,27501,27502,38034,25388,16999,19111,21159,19079,19111,19078,14885,16966,14886,16935,14855,23143,46090,52660,59196,59196,46387,29549,16969,31695,29647,29614,31694,50645,56950,54869,57016,48432,29512,25351,21158,14885,10692,12805,10660,10596,44306,54837,42127,40047,33642,35787,23177,14824,19017,23210,40047,37934,27401,42192,35886,35919,29581,29614,33840,27468,29549,33774,23242,23210,33742,29516,12710,8517,10597,21064,23145,16806,12613,10532,8485,8452,6371,21096,37934,27403,18984,37967,35886,35854,35854,37999,48564,48467,44273,25354,14790,19048,16903,10564,16837,29449,23143,52789,52756,33675,29482,27369,37901,133},
{54970,54970,52889,54970,54970,54970,52889,52889,52890,52889,52889,52889,52889,52889,52889,54937,54938,54937,52889,52889,52889,52889,52890,52857,52889,52890,50809,52857,52857,52857,52857,50809,50809,52858,52857,50809,52857,50809,50809,50809,50809,50809,50809,50809,50777,50777,52857,50777,50809,50809,50777,50777,50777,50809,50809,50776,50777,50776,50777,50776,50777,44503,40310,40310,38229,38197,40147,29615,25422,23309,21228,21228,21260,21293,19213,21293,25519,19213,17068,17068,17100,19148,17100,19180,21293,19212,17132,19180,19213,19213,19180,17100,17099,19180,27599,25454,14954,10729,12809,25422,19083,21195,16970,21196,21196,19115,21196,21195,23276,17002,19115,21163,14889,19082,14824,42161,56918,54870,52789,48531,23240,23273,23241,19047,23273,23272,27433,48532,27435,27436,29548,35919,27534,31727,25323,25356,27468,25421,25422,33808,21194,12806,21192,19111,16998,19046,19078,16998,19079,16998,19079,19079,23142,44108,59065,57115,57115,52823,25355,16936,29614,29647,27534,27469,31662,37934,29515,29483,25289,21126,25351,16997,14821,14886,14885,10692,16902,48433,48433,40046,46385,44208,52725,23209,16936,16936,23209,37966,40014,18983,27403,25322,29580,33742,29549,27501,25356,25387,27468,23210,27403,37967,33741,37869,37836,48301,41962,23144,10565,8484,8485,8452,6404,6372,6338,10596,16902,31629,37966,37934,37934,37967,37934,50612,35757,20999,16871,14823,10597,12710,21129,31627,50643,54903,54870,42093,33675,31595,35789,54871,127},
{55002,54970,52890,54970,55002,54970,52890,52890,52890,52889,52889,52890,52857,52890,52889,54937,54937,54937,52857,52889,52889,52857,52857,52889,52889,52890,52857,52857,52857,52857,52857,52857,52857,50777,50809,52889,52889,50809,50809,50809,50809,50809,50777,50809,50809,50777,50809,50777,52857,50777,50776,50777,50809,48696,50744,50777,50777,50776,50776,50776,50777,44503,40310,38230,38229,36084,38001,29615,27567,21261,21196,23341,21261,21326,19213,21326,23438,21293,17100,17100,17100,19213,21293,19180,21293,19213,19180,17100,17100,17100,17067,17068,17067,17067,27567,25454,17035,10761,10761,25422,19115,21228,16970,21196,19115,17034,19115,19050,23276,16970,17002,19115,16969,19083,14889,44273,52692,50676,52725,40079,19015,19048,25321,25321,27433,27464,31691,50645,29484,27436,29580,35952,27502,27534,25323,25388,27469,25421,25422,31760,23339,14951,14886,12806,14886,19110,21191,19046,19046,19079,16999,23272,25288,46320,48466,48499,57049,52791,23210,16936,42259,44339,29581,23308,27501,27468,16904,16935,14822,12708,16933,21190,16998,12773,14917,14885,16901,44337,44240,39949,42094,46320,44272,25257,14856,18984,23209,35854,42160,14791,14856,16904,16904,16936,23210,14790,25323,23242,8517,21129,33773,44338,46418,37803,37770,48334,29416,6371,4291,6371,6404,6372,4259,21097,33774,19016,23209,35919,35886,35886,37934,31595,33740,46418,37935,14759,14823,12710,6404,14823,23242,35821,52757,59162,54837,42094,33675,31595,48467,48499,81},
{55002,54970,52922,52922,54970,54970,54970,54970,54938,54970,54970,52890,52857,52889,52889,52889,52889,52857,52857,52889,54937,52889,52890,52857,50809,52889,52857,52857,50809,52857,52889,52857,50809,50809,52857,52857,52857,50809,50809,50809,50809,50809,50777,50841,50809,50777,50777,50809,52857,50777,50777,50776,50809,46484,44306,50776,50776,50776,50776,50776,50777,44536,40310,38165,29713,31793,37969,29583,25454,19148,21261,19180,21293,21326,21293,21326,23406,19213,19213,19212,19180,21293,21293,19213,21293,19213,17100,14987,14955,14954,14954,14954,14954,17035,27599,25454,17035,10761,12842,25421,19115,21228,17002,21228,19115,19115,19115,19083,23308,17002,19082,19115,17002,19115,14922,19050,21130,21130,19017,19016,23273,21128,21096,27434,35916,31688,35885,50645,29484,29548,31661,33839,27502,25421,25323,25356,25388,25388,17001,17000,19112,14918,14918,14918,12805,19111,21191,14918,16934,19080,14888,21128,33772,44272,29546,19015,18983,21096,23210,14824,23242,35919,33807,29582,29582,31661,18983,21159,16933,19046,21093,23270,19109,19078,14885,12772,16966,29546,44305,52756,44304,52724,50611,27370,16936,19016,21129,35854,44241,14824,16969,16904,16904,14823,23210,21064,21064,21064,14758,23209,37967,29515,33741,25225,23177,23208,10564,2243,4291,6372,4291,4258,4291,18983,33773,23177,31661,35886,35886,35886,35854,31595,44273,54935,40048,14791,14823,10630,6437,14823,19016,16838,33675,56918,39981,35788,33708,31563,44240,44239,77},
{54970,54970,52890,52890,52890,52890,54970,54970,54937,54970,54970,52889,52889,52889,52889,54969,52889,52857,54938,54937,54937,52889,52889,52889,52857,52857,50809,52857,52857,52857,52857,52857,52857,52889,52857,52857,50809,50809,50809,50809,50777,50809,50809,50841,50809,50777,50777,50809,50809,50809,50809,50777,50777,50743,50677,50776,50777,50777,50776,50776,50777,44503,36083,36019,29713,27600,29614,29550,25454,19180,19148,19180,19213,17133,15019,19180,19212,19180,17100,17067,17067,17100,19180,19148,19212,17100,14987,14987,17100,14987,14954,14955,14955,14954,27567,25486,17035,12809,14922,25421,19082,21195,17002,21228,19115,21195,21196,21195,23308,14921,17034,19115,17002,19115,14890,12842,14890,14857,10696,12807,23337,25353,25353,25355,46419,33805,23241,48565,27436,29614,27501,33840,27502,25421,23275,25356,29614,21193,12806,14887,19080,14918,16998,17030,19079,21159,21191,16998,16999,25354,14823,21096,35885,42160,29514,16966,21129,19016,25420,12776,10630,27500,33807,25389,29581,33741,33741,25384,19078,16965,23271,19077,19109,19109,14885,12773,16966,29579,35788,37901,35820,46353,52626,29482,19017,19017,21097,33709,48434,16871,8549,16904,16936,16904,21129,18854,16773,16773,16773,31596,37934,31629,37967,40079,40046,16901,6403,4291,4291,4291,2211,6435,12742,8549,6371,21129,37967,35886,35886,37934,37934,46386,52757,54935,42128,14758,14791,8517,10630,14790,16870,16806,33676,33577,31530,29482,33676,31562,40046,46352,71},
{54970,52889,50809,52889,52890,52889,54970,55002,54970,54970,54970,54937,54937,54937,52889,54937,54937,52889,52889,52889,52889,52889,52889,52889,52857,52857,52890,52857,50809,52857,52857,50809,52857,52857,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50777,50776,50777,50743,50710,48663,50744,48696,48696,48663,48696,42357,33840,31759,33840,29679,27469,29582,29614,23374,21261,17133,17133,17133,17133,19181,21326,21325,21261,17100,17100,19213,19213,19180,23406,19213,19180,19180,21293,21293,19180,19180,19180,19180,27599,25454,17003,10728,10761,23341,16970,19147,14922,21196,19083,19115,10728,17002,23308,14889,17002,19115,17034,19083,14857,12809,14890,16970,12809,12775,19112,16999,14920,16936,31692,21160,23274,48564,29516,29581,23307,35921,27502,27534,23275,25356,25387,23273,19079,12838,14919,12838,12806,16966,21191,23240,14854,16999,19047,21161,14823,21128,16902,21128,29579,25320,40079,40079,25355,12743,12743,29581,31727,25389,31662,37966,37998,29578,19077,19045,19078,14917,16997,19078,14853,12773,14886,37966,35820,37901,37901,31496,46220,29482,14823,16936,21097,31596,50579,18919,8485,16936,16936,16936,21129,23209,18951,16740,25257,35886,37967,27370,16871,27337,33674,10628,6435,4323,4291,4291,2178,16935,37999,27435,14758,33774,35854,35886,35886,33741,29515,37901,50644,54902,44241,14790,10630,8517,14823,12743,18983,23210,27402,23176,33741,48499,33708,31563,35853,42191,55},
{52890,52890,52890,52889,52890,52922,52889,54970,52890,54970,57050,54970,54937,54937,54937,52890,52889,52889,52889,52857,52889,52890,52889,52857,52857,52889,52857,52857,52857,50809,52857,50809,50809,50809,50777,52857,50809,50809,50809,50809,52857,50809,50809,50809,50809,50809,50809,50777,50777,50777,50776,48598,48565,46484,48597,37967,44339,44371,44371,42291,42290,38032,35854,33773,35854,31661,23243,27436,27469,21261,19213,19213,19181,19181,19180,19180,19213,21293,21293,19180,17100,19212,21293,17100,21261,21325,17067,17100,19180,17100,19180,19148,19180,19148,27567,27567,17035,8648,10728,25389,17002,19147,14921,21196,19083,19115,14922,17002,25388,16970,17034,19115,17002,19115,14889,14889,14922,14889,16969,19081,21257,17032,14888,21160,27432,21127,23274,48564,29548,21162,21195,31727,23340,27534,23243,25356,29613,21160,19111,12838,10726,12806,10726,12838,21192,25352,19047,16967,21194,14855,16936,16967,12741,10628,14822,12709,18982,40046,23242,12743,12743,25355,23275,29647,29582,31661,25321,19078,19078,19110,19110,14885,12805,16998,10660,8548,12709,48596,46385,42159,48531,40013,48432,44208,16871,19017,21129,31596,48498,14725,16870,16936,16936,16936,21097,25322,21032,16740,29515,37967,37999,29515,33643,46188,35753,14821,8548,6468,6436,4291,6403,12741,23273,25289,27435,37967,35886,35854,35854,33741,35854,48563,54903,46386,37869,29516,25323,14791,14791,12743,14790,14725,25257,25289,25224,46418,42159,31562,35853,33774,35},
{52890,52922,52890,52890,52890,52890,52922,52890,52922,52890,54938,54969,54969,54969,52889,52889,52889,52889,52889,52857,52890,52890,52889,52857,52857,52857,52890,52857,52857,52857,52857,50809,52857,50809,52857,52857,50809,52857,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50776,50777,50744,50776,48630,48630,50711,50711,50744,50743,50744,48695,44404,40145,38033,33840,31760,31727,27501,25388,21228,23406,27696,27664,21293,21293,19213,19213,19212,21293,21261,17099,21261,21261,19148,19180,23406,17067,14987,17067,17100,17100,17067,17099,19115,29647,27567,14987,10729,12809,25421,19115,21228,19115,21228,19083,19115,21195,21163,25421,17002,17034,21195,19082,21195,14889,14922,17002,14921,14920,19112,21225,10726,14887,27464,25383,19046,21161,48597,27436,16969,19115,23308,21228,27534,23275,23275,23275,16999,19143,21192,12806,10725,10694,8613,19079,21159,19079,23273,21195,19048,21160,14854,12741,16935,25321,19015,16903,40047,25323,12711,14856,29613,23243,35920,33807,33774,23241,12740,12805,12773,16998,19078,16965,19111,12805,8581,12741,40078,50611,44175,42030,37868,54837,48433,16903,16969,19017,29483,46418,21063,31628,19016,16936,16904,21097,16903,14758,16838,33709,37967,40080,37903,50480,44139,23206,19014,10628,8548,6435,4323,14822,21160,10565,16903,35887,37934,35886,35854,37934,37934,46450,52822,52790,52758,46386,44241,35822,16903,12743,10630,14822,14757,33676,25224,35821,50579,39981,31563,40047,40081,46},
{52890,52922,52890,52890,52922,52922,52890,52890,52890,52857,52889,52889,52889,54938,52889,52889,52922,54970,52889,52857,52857,52889,52889,52889,52857,52857,52857,50809,50809,50809,52857,52857,52857,50809,50777,50777,50809,52857,50777,50809,50809,50809,50809,50809,50809,50809,50777,50809,52857,50809,50777,50777,50776,50711,50711,50776,50777,50777,50777,50777,50777,46551,42291,46452,38033,27501,29646,25356,23276,21260,19213,19245,21326,17067,17067,14987,17067,17067,17067,14987,14987,17067,17067,14987,14987,23373,19180,17067,17067,17099,17067,17035,19180,19147,29679,25454,17035,10729,12809,25389,19115,21195,17002,21228,19115,19083,21163,19082,25421,14922,17002,19115,19082,21195,16969,17002,17002,16969,14889,17000,19144,17000,19079,25383,23303,21159,25419,48597,27436,14889,19050,17002,21228,25454,23243,23275,27500,19080,14886,19079,19111,16999,14886,10662,14886,16966,21160,35887,23275,14855,23240,16933,19046,21127,21127,21094,29450,31596,29549,12743,14823,44404,48597,46418,54936,52823,25353,14886,14919,12774,14885,19110,16998,12805,10661,8581,8548,21062,46385,50612,52659,44239,57016,46354,16903,16969,19016,27434,48498,21064,23210,19016,16903,16904,19048,25355,21097,25257,35886,29515,29515,21031,29482,29513,14820,19046,19046,10661,4356,4323,14821,40144,29548,25258,37967,35886,35886,35854,27402,33675,46386,54903,52757,54936,52725,23112,16903,14791,12710,8517,19016,27436,42126,27337,23111,31497,39949,33643,37934,37968,64},
{52889,52890,52922,52890,52889,52922,52890,52890,52890,52890,52890,52890,52890,52890,52889,52889,52922,52889,52889,52889,52857,52857,52857,52857,52857,50809,50809,50809,50809,50809,52857,50809,52857,50809,52857,52857,50809,50809,50809,52857,50809,50809,50809,50777,50809,50777,50809,50777,52857,50809,50776,50776,50809,50711,50744,50776,50776,50776,50776,50744,50776,44503,46583,50743,42193,31694,35888,29549,25389,21293,19245,17165,17133,19213,19245,19181,19180,19180,19148,17067,17100,19213,19180,17100,17067,25486,25486,21325,21293,23438,23373,25486,23406,25485,40243,40212,19115,10761,12841,25389,19083,19115,14921,21228,19083,19083,21163,19082,27502,17002,19115,21195,21163,23308,23275,25356,23308,19082,21194,21224,17063,14919,21191,29608,23336,21159,31694,48565,27468,19082,21163,16969,19147,27535,23275,23275,23275,23275,21227,19145,19112,14918,16999,14887,10693,14854,27498,40111,27468,14791,23241,23272,23304,23271,19014,27401,33643,21031,29581,25355,25290,33741,37967,35788,48499,44306,19015,19047,27467,21160,19078,19046,14885,12741,16966,12741,6436,21160,37932,40013,39949,46352,50643,40014,14823,16936,19016,25322,48498,27402,23177,18984,16936,16904,19016,25257,18951,33741,35886,37934,35822,44272,40078,27465,16933,19014,14853,8548,4356,6404,16934,21127,18982,31628,37967,35919,35886,35886,35886,48499,54871,52790,54871,54903,46386,18951,14791,14791,8550,8549,23242,25355,39981,42159,48500,54903,35788,33643,35788,48532,133},
{52890,52890,52857,52890,52890,52922,52890,52890,52857,52890,52890,52890,52890,52922,52889,52889,54970,52889,52889,52889,52857,52857,52857,52857,52857,50809,50809,50809,50809,50809,50809,50809,52890,50809,52857,50777,50809,50809,52857,52857,50809,50809,50809,50777,50809,50777,50777,50809,50777,50777,50777,50776,50776,48630,50744,50777,50776,50777,50777,50776,50777,44471,40310,46551,42259,29614,33807,27501,25421,23374,19246,19245,19245,19245,19278,19245,17132,17100,17100,17068,17100,21293,19213,19180,17100,23406,23406,23406,23406,23438,23373,25519,25486,29646,50776,57082,23309,12809,12841,25421,21195,21196,17002,23309,19115,21195,23276,19082,25421,23341,23341,25389,23308,25389,25388,25389,25356,16969,19113,21224,19111,21192,19111,25385,14854,19079,29613,48565,29581,27501,23276,16969,19147,27567,23243,23275,19049,27469,27534,25421,23307,14887,16967,17031,14919,16967,33773,40047,29516,16936,14855,16936,19048,23304,21127,23144,25256,25257,31629,44274,40079,35822,31596,29450,31595,29482,16966,19047,40111,33740,25320,21158,10692,10661,10692,19079,12773,23241,46450,42126,35788,31561,29448,33741,16936,16936,19049,25322,48530,37901,42193,23210,16968,16936,19048,21031,23046,35886,35886,27402,18983,31594,29512,21158,21158,16965,12773,4387,4323,4323,14853,19014,25321,37999,37967,35919,35886,37934,42159,50644,52822,52790,54903,50579,40047,21064,12710,12710,6437,14855,21064,14757,37934,57016,54838,50612,35755,35756,35788,46353,142},
{52889,52922,52890,52890,52922,52890,52890,52890,52890,52922,52890,52857,52890,52889,54970,54937,52889,52889,52857,52889,52857,52889,52890,52890,52857,50809,50809,50809,50809,50809,50777,50809,50841,52857,50777,50777,50777,50809,50809,50809,50809,50809,50777,50777,50809,50809,50777,50809,50777,50777,50809,50809,50776,48631,50744,50777,50809,50776,50744,50776,50776,44503,40310,40310,42390,40277,38099,29648,27567,23406,23439,21326,21293,21293,21293,21260,19180,19180,19148,19115,19180,21228,21293,19180,19180,21260,21260,21260,23341,21260,21228,21228,23341,25453,29646,38065,23276,17034,17002,25421,19115,21195,17002,21228,17002,21195,23276,14889,17002,12809,12841,14889,14857,19082,16969,17002,19050,14857,14920,19144,19144,21224,23272,33773,19047,21160,31693,48597,27500,25388,25388,17002,19115,27567,23243,23275,23275,25356,23309,21196,21195,14919,14919,12774,14919,16966,35886,37966,27403,19017,16937,12775,19048,23272,16966,12709,23209,25321,38000,44273,44273,33741,33773,44305,48531,48531,31692,27402,31627,40013,33707,21094,12805,8548,10661,19046,16966,40078,46352,39981,37933,46352,42126,40048,16936,16936,19016,25322,40079,35821,40046,21096,16936,16936,19048,23111,18853,29450,37934,29450,33642,37802,23207,14788,14788,14853,8548,4355,4323,4323,14886,19014,33773,37967,37967,37967,31596,27369,42160,54903,52789,52822,54935,54870,44240,18983,12710,10598,8517,21064,12579,12644,16902,18983,23144,42192,40014,35788,33675,35853,177},
{52890,52922,52890,52890,52922,52922,52890,52890,52890,52890,52890,52890,52890,52890,54970,54937,52889,52889,52889,52889,52857,50809,50842,52890,52857,50809,50809,50809,50809,50809,50809,50809,50809,52857,52857,50777,50809,52889,50809,50777,52857,52857,50777,50777,50809,50809,50777,50777,50776,50777,50777,50777,50776,48630,50744,50777,50776,50777,50776,50776,50776,42455,40310,40310,40310,36117,31825,27567,25422,23374,25454,27535,27535,27470,27469,27533,25421,27501,27469,25421,27469,25421,27501,27469,25389,27501,27501,27502,27469,27502,29582,27501,27501,29614,23309,14922,19115,21228,17034,25389,21196,21195,17034,21228,16969,19115,21195,16969,21196,17002,17002,19083,17002,23308,23243,25356,23308,19082,21194,17031,17063,19111,23304,38031,25321,25321,31694,48565,29581,19049,19082,17002,19115,27567,23243,23243,19082,23276,23341,19116,21195,16999,14887,12774,14887,23273,40046,37934,21129,12743,12743,14856,19017,27434,16902,19015,33804,33740,37934,40047,40080,29548,37999,50612,50612,52757,37966,37934,46353,37901,27401,21126,19046,14853,14886,12774,10629,33773,57015,44207,46385,56982,52691,42128,16903,16936,19016,23210,23209,33740,37869,18984,16936,19016,19016,25290,27337,21030,33708,40079,48432,25255,12708,16933,19046,14853,6435,4355,4323,4323,14854,27466,37967,37934,37967,37967,35886,46419,54870,54871,54903,54903,48499,48531,33709,18951,14791,6404,21162,23209,10531,10596,10628,6435,12741,35919,29482,35788,31562,35854,152},
{52922,52922,52890,52890,52890,52890,52922,52890,52890,52890,52890,52890,52890,52889,54937,52922,52889,52889,52857,52857,52890,50809,50809,50809,50841,50809,50841,50809,50809,50809,50809,50809,52889,52857,52857,52857,52857,50809,50777,50777,50809,52857,50777,50777,50809,50777,50777,50777,50776,50777,50776,50744,50776,48663,50744,50777,50776,50776,50776,50744,50777,44503,40310,40278,38197,36116,33938,31727,31760,27599,23341,25454,23374,23341,23341,23341,23341,23308,21228,21228,23308,23341,25389,23341,25389,23308,25389,23308,23308,25421,25421,25389,25389,27534,21228,12841,12874,14922,14954,23341,21228,21228,17002,21228,19115,21195,21195,19083,23276,17002,19083,19115,19082,25388,25356,25356,25356,21227,19112,19111,19112,21224,27465,37998,23240,23240,27468,46484,31662,16969,14921,17002,19147,27567,23308,23243,23243,23276,21228,19115,21195,16935,14919,14854,10661,31659,37933,37934,23210,16936,21097,12743,12711,21128,21096,16903,25321,33740,21096,27403,33839,33774,44306,52725,48531,42127,23208,16902,35820,44207,31594,21158,21191,19046,12741,8581,6436,12742,31628,42094,48432,37836,42159,46386,21097,16936,16968,21129,21162,33741,37901,16903,16936,16936,21097,29548,33774,18918,16838,21128,31595,25353,16966,19078,21158,10628,8548,6435,4323,2211,10628,33805,37967,35886,37967,37934,35853,44240,52757,52789,54903,52724,44305,42160,37935,33741,35854,25290,23209,25321,14788,8547,10660,27434,16902,42226,46353,35788,33642,35854,141},
{52922,52890,52890,52890,52890,52890,52922,52890,52890,52890,52890,52857,52857,52889,54969,52889,52889,52889,52857,52890,52889,50809,50809,50809,50809,50809,50841,50809,50809,50809,50809,50809,50809,50809,52857,52857,52857,50809,50776,50777,50809,50809,52857,50809,50809,50777,50777,50809,50809,50776,50777,50777,50744,50744,50776,50777,50777,50776,50744,50776,50776,42423,38230,38230,40278,36149,36051,33873,31760,21325,23439,23439,21358,19245,19213,17133,17100,17100,15019,14987,17067,19213,19213,19180,17100,17067,19180,17100,17100,19180,19180,19180,21261,25454,21228,10793,12874,12841,14922,25421,21196,21195,17002,21228,17002,19115,19115,16969,23276,19082,21163,19115,17002,25389,23276,25388,25388,21194,17032,17063,19144,19144,23272,37999,23273,14853,27465,46484,31662,16969,14921,17002,19115,27535,23276,23243,19082,23275,21261,19148,21162,21193,12806,14919,19047,37965,40046,40014,25322,16903,35822,31661,29547,40046,21064,12742,8548,21193,16968,27468,31694,23210,31628,33773,25322,16903,14790,18951,35821,42126,37933,23271,21158,19046,14854,8548,6436,12742,31628,31595,25288,16805,27370,29450,19016,16968,16968,19049,21129,31661,33741,25290,16936,16936,19016,27370,29483,18885,25224,37998,23176,14789,16933,23270,19046,6467,6435,8548,6435,6403,8483,31660,37967,37966,37967,29515,31628,48531,54903,52789,54903,54903,46451,31661,40047,37902,37966,23209,16903,16966,16933,14852,12773,25321,33709,59129,50579,35755,33643,35821,171},
{52857,52890,52890,52890,52890,52890,52890,52890,52890,52890,52857,52857,52890,52889,54937,52889,52889,52889,52857,52890,52890,52857,52857,50809,50841,50809,50809,50809,50809,50809,50809,50809,50777,52857,52857,52857,50809,50809,50809,50809,50777,50809,50809,50809,50777,50776,50777,50777,50777,50777,50776,50777,50744,50776,50777,50777,50777,50777,50744,50776,50777,42423,38230,38230,40310,38197,38132,33775,25356,19148,17133,19213,19213,17165,17165,15020,17100,17100,15019,14987,14987,19180,19213,17100,15019,17067,15019,17067,19212,19213,17132,17100,19180,23406,19180,12841,14954,14922,14922,23341,21196,21163,16970,21228,14921,19082,19115,17002,23276,19082,19082,19050,16969,23308,21162,23307,25355,23371,19176,17031,17063,14919,16967,35919,23273,14886,31689,48531,33742,16969,16969,17002,19115,27567,21195,23243,21195,21195,23309,19115,23243,19048,21162,25420,31661,42127,40014,40046,25355,16904,25322,44272,46352,48465,12710,8550,12775,16934,27501,31728,25290,23275,23275,12710,6404,8517,21161,31595,31563,37966,37901,29546,23239,19110,16966,12741,8580,14886,31661,19016,8484,8484,27402,29483,18984,16936,19016,21130,21129,23210,27435,37967,29548,18984,16936,23144,18852,18853,18885,25287,14853,10660,19078,23238,14853,6403,6435,10693,6435,8580,6435,10596,33773,37999,37967,40079,50677,54870,52790,54903,54903,52757,37902,27468,27467,21031,16838,14791,14791,10661,16934,14852,10659,29546,54904,52724,37835,35820,33675,35820,215},
{52890,52922,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52889,54937,54937,54937,52857,52857,52857,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,52857,52857,52857,52857,50809,52889,52857,50809,52857,50777,50777,50777,50777,50809,50777,50809,50809,50776,50777,50809,50777,50776,50777,50776,50776,50744,48696,50776,44503,40310,38230,40342,36117,42325,54903,54904,38131,21358,23471,23471,23472,21391,23439,23503,23471,23471,23471,23471,25519,25551,23471,23471,23471,23438,25519,25551,25551,25551,25551,29711,29711,21228,14954,14922,14954,14922,25389,25421,25389,23275,25421,21195,23308,25388,23308,27469,23276,25388,25356,23308,27469,25355,25388,25388,23306,21224,23337,23304,17032,19080,33806,21160,19079,27496,46450,33774,17001,16969,16969,19083,27599,23275,23275,19082,21195,23341,23308,23275,23209,38000,33839,31693,37966,37966,37966,27403,14856,14823,31628,42127,27435,16936,14954,14888,27467,33742,33775,31630,25389,25420,12774,6437,8549,16936,29483,25322,27467,27370,23176,21159,21126,14885,16998,14853,16966,29515,14822,8517,8516,37999,46386,23209,16904,16936,21162,19049,19017,31693,35854,35886,33741,23177,23144,16772,16740,16804,23206,16965,16933,21126,23271,14820,6435,8580,10660,6435,8580,6468,4290,14790,35887,29547,35821,48531,52822,52822,54935,56983,48499,29483,27435,29548,21097,12710,12710,10630,6437,14854,16934,16901,44304,57049,54903,42061,35820,33675,33675,149},
{52889,52889,52890,52922,52922,52890,52890,52857,52890,52890,52890,52890,52890,52889,52889,54970,54970,52889,52857,50809,50809,50809,50809,52857,52890,50809,50777,50777,50809,50809,50809,50777,52857,52857,50809,50809,52889,50809,52857,52889,50809,50809,50809,50777,50777,50809,50809,50777,50809,50809,50809,50776,50777,50809,50777,50744,50776,50776,50776,50744,50776,42423,40310,40310,42390,36116,38132,42325,42325,40244,27697,25584,25616,25584,25584,25616,25616,25616,25584,25584,27664,27729,27696,27664,27664,27664,27696,27696,29776,31922,29744,29744,46550,46583,31760,17002,17002,19148,19115,19082,25388,27469,27468,27501,27501,27501,29581,29549,29581,29581,27501,29582,29582,27501,29582,29582,29581,25388,23307,25387,25387,21195,21195,25387,23274,21194,23241,44370,33774,16969,16969,17002,19083,27599,23308,23243,21162,21195,23373,29648,29614,31596,48466,35854,19048,27434,35853,35821,25322,19016,27500,25290,23242,12711,25420,17000,10694,21128,31661,31662,46420,23243,17000,12806,10662,12775,10663,10598,8550,23210,23274,16903,16967,19046,16966,19078,21158,16933,25321,14854,6404,10597,46418,48499,23145,14856,16936,21162,19017,27467,35886,35886,35886,37934,35854,35723,35623,35591,35623,35688,25285,16932,21126,21126,12772,10628,16966,14853,8548,10661,6468,6435,6403,21096,31660,46386,52822,52790,54871,48532,40079,31628,31661,25322,31629,23177,12710,12710,6469,6437,14823,14822,12676,44305,56983,48433,35788,35756,35788,35723,123}
};

const uint16_t London PROGMEM [320][241] = {
{52891,52891,52891,52923,52923,52891,52891,52891,52891,50843,50843,50843,50843,50842,50843,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,50842,50842,50810,50810,50810,50810,48762,48762,48730,48730,48730,48730,48697,48697,48697,48697,46649,46649,46617,46617,46617,46585,44536,44536,44504,44504,44504,42424,42423,42456,44504,44536,46585,46617,46649,46649,46617,46617,46617,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46585,44537,44536,44536,44536,44504,42456,42424,42424,42456,44536,44536,46584,46617,46616,46617,46617,46617,46616,44504,46584,40343,38230,27600,19148,17035,17035,16970,16938,19018,21067,18986,19018,16841,16905,16938,14857,14889,14890,12809,14890,12809,17003,21293,23374,27632,25487,14922,23407,23374,25520,21261,19148,21261,23342,21261,19147,23341,25454,19083,10598,10598,10598,14824,12744,10631,10599,12711,16970,10663,10663,12776,14857,10663,12776,10631,12744,10599,10598,10566,10663,12711,12711,10598,10631,12744,10598,10566,10566,12711,10598,10598,33906,48697,57084,40180,10631,12744,12711,14889,25519,25519,23374,23374,23373,23374,29745,27632,27632,27632,25519,25454,12711,12711,8518,25486,40245,21228,25453,42390,42390,40278,25454,16937,14824,10566,8485,10565,21163,27534,29614,29581,31727,33840,27500,21162,31759,38163,35986,16937,8420,27567,29712,31825,31793,31826,31826,31826,33906,33906,33906,33971,38164,21228,17002,27535,31793,36019,36052,25454,36018,23308,25486,36051,139},
{52891,52923,52923,52923,52891,52891,52891,52891,52891,50843,50843,50843,50842,50842,50842,52891,52891,52923,52923,52923,52891,52891,52891,52891,50843,50842,50842,50810,50810,50810,50810,48762,48762,48730,48730,48730,48730,48697,48697,48697,48697,46649,46649,46649,46617,46585,46585,44536,44536,44536,44504,44472,42424,42424,42456,44504,44537,46617,46617,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46649,46617,46617,46617,46617,46617,44536,44536,44536,44536,42456,42456,42456,42423,42424,44536,44536,46584,46584,46617,46617,46617,46617,46617,38165,44504,42391,40278,36084,25552,25487,25519,25422,19018,25389,25487,29713,31826,27633,27633,27633,27665,27665,29746,29713,29745,29745,31826,25552,21261,23374,25487,25552,23375,21293,23407,23374,21293,23374,21326,27632,25421,19050,23341,19083,10631,10598,10598,12744,10631,10566,8517,10631,14889,10598,10630,12776,14857,10631,12744,10598,12711,10598,8518,8518,10631,10630,10630,8518,10630,10663,10598,8518,10598,10663,10598,10598,31760,50842,57116,40213,12711,12744,12711,14825,27600,31826,29713,29680,27632,25487,23373,21228,19180,19147,23374,23374,21196,19115,12776,25421,44503,36084,25454,42390,42391,40310,23341,12743,10598,10598,8485,8453,19115,29647,25421,23275,29614,31726,33839,23275,31759,40211,31792,12711,8452,23341,29713,31825,31826,31858,31858,31858,33906,31858,33939,36051,38164,17002,12711,16970,19115,16937,21195,27566,31792,19115,27599,36051,135},
{52891,52923,52923,52923,52923,52891,52891,52891,52891,52891,50843,50843,50842,50842,50842,52891,52891,52923,52891,52923,52891,52891,52891,52891,50843,50842,50842,50810,50810,50810,50810,48762,48730,48730,48730,48730,48730,48729,48697,48697,48697,48697,46649,46617,46617,46617,46617,46584,44536,44536,44504,42456,42424,42456,42456,44504,44537,46617,46617,46617,46617,46617,46649,46649,46617,46617,46617,46617,46617,46617,46649,46617,46617,46617,46617,44569,46584,44536,44537,44536,44504,44504,42456,42424,42424,42424,44536,44536,46584,46584,46617,46617,46617,46617,48697,40278,40310,42391,38165,27633,23406,21293,23342,21261,19181,21261,23342,27633,27632,27632,25552,25552,23439,25487,23439,25520,25519,23471,23439,23439,19180,23439,23406,19180,21261,21293,23439,21294,19115,21293,21326,29713,25421,19050,23373,16970,10599,10631,10599,12744,10631,10598,8518,10663,14857,10598,10631,12776,12776,10630,12744,10631,12711,10598,10566,10566,12711,10598,10598,8518,10631,12679,10598,8518,10598,10663,10598,10598,27567,50777,57117,40213,12711,12744,12712,14825,19180,19115,12744,10598,8518,10598,14857,8485,8485,8485,21196,25487,25519,21260,14857,23341,48697,38197,25454,40310,42423,36019,14824,10631,10598,10566,8485,8485,21163,33873,21194,27501,33807,29646,27468,21162,33840,40212,19050,8452,8485,23308,31825,31858,33906,31858,31858,33939,33939,33938,33939,36019,36084,14824,10598,12712,14824,8517,14792,35985,29679,19115,29744,36051,139},
{52891,52891,52923,52923,52923,52923,52891,52923,52891,52891,50843,50842,50842,50843,50843,50843,52891,52923,52891,52891,52923,52891,52891,52891,50843,50842,50842,50810,50810,50810,50810,48762,48730,48730,48730,48730,48730,48730,48697,48697,48697,48697,46649,46617,46617,46617,46585,46584,44536,44536,44504,44504,44504,42424,42456,44536,44536,46617,46617,46617,46617,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,44569,44569,46585,44536,44537,44536,44536,42456,42456,42424,42424,42456,44504,46584,46584,46584,46584,46617,46617,46617,46617,44504,40310,42423,40310,29745,23374,17003,17035,17003,17003,14922,14922,23407,23439,23439,23439,23439,21229,21261,19180,23471,23374,19148,21294,19148,14889,17067,19148,12809,19212,21261,19148,23406,23407,14954,14922,23373,23341,16969,21228,14857,10598,10598,10598,10663,10631,8518,8518,12711,14857,10566,10631,12776,12744,10631,12711,10631,10663,10598,10598,10598,10663,10663,12776,10663,10631,10631,10566,8517,10598,10631,10631,10598,27567,48664,57117,40245,12711,12744,12744,12776,21293,21261,14889,12776,12776,16970,23341,21195,21196,21260,23373,21196,25487,17035,12776,21260,46681,36084,25454,50810,44471,19115,12711,10630,10598,10566,10533,10533,21162,29647,16936,27468,29614,29582,31726,23242,31727,40212,19050,6372,8485,25486,31858,33939,31858,33938,31890,33906,33938,33938,33971,36051,36052,10630,8485,8485,8485,8453,14824,38131,27566,21228,33971,36019,140},
{52891,52923,52923,52923,52923,52891,52891,52923,52891,52891,50843,50842,50842,50811,50843,50843,52891,52891,52891,52891,52891,52891,52891,52891,52891,50843,50842,50810,50810,50810,50810,48762,48762,48730,48730,48730,48730,48697,48697,48697,48697,48697,46649,46617,46617,46617,46617,46584,44536,44536,44504,42456,42456,42424,44504,44504,44536,46617,46617,46617,46617,46617,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,44569,44569,46585,44537,44537,44536,44504,42456,42456,42424,42424,42456,44536,44536,44536,46584,46617,46617,46617,46617,46617,46617,42358,42391,38197,31858,25552,27600,27600,27600,27632,27600,25519,23407,23407,25520,23439,23407,21294,21294,21294,23439,23407,21294,27633,27665,27633,29713,27665,27665,23439,25487,27600,23439,23439,25551,23374,14889,17002,14889,23341,14857,10598,10598,10598,10663,10631,10598,8518,12711,12744,8518,10598,12744,12711,12711,10631,10631,10631,10566,8518,10566,10631,14889,19148,14889,10631,10630,8518,8485,10630,10631,10598,8517,31760,50842,55068,40245,12711,12744,12744,12744,25487,31858,27664,27632,27600,27664,27632,27600,25519,27600,23309,10631,23341,19148,12809,23341,48762,38197,31760,31793,27534,14856,12743,12679,10598,10598,10566,8485,21163,27534,21130,29614,29614,29581,27468,23243,27469,35986,31728,23308,23276,25454,31858,33939,33971,33939,33971,33938,36019,33971,33971,36084,36084,14857,6372,8452,8485,8452,14824,36018,21260,23308,36019,36019,133},
{52891,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,50843,50810,50842,52891,52891,52891,52891,52923,52923,52923,52891,52891,52891,52891,52891,50842,50810,50811,50810,50810,48762,50778,50778,48730,48730,48730,48697,48697,48697,48697,46649,46649,46617,46617,46617,46617,46585,44536,44504,44504,42456,44504,44504,44504,44504,46617,46617,46617,46649,46649,46649,46649,46649,46617,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46585,44537,44537,44536,44504,44504,42456,42456,42424,44504,44536,46584,46584,46584,46617,46617,46617,46617,46617,46617,44503,42391,42391,29745,23374,25487,25520,27600,21261,23374,27633,27665,27633,25552,25520,25519,27632,25552,25487,23439,25487,25487,21294,23374,23342,25487,23439,23407,19148,19115,21293,21293,21293,21261,23374,12776,17034,17002,23406,12776,10598,10598,10631,12711,10630,10598,8518,12744,12776,10598,10630,12744,10631,12776,10631,10631,10663,10630,10598,10598,12711,14889,17035,12776,10631,10630,10566,8517,10630,10631,10631,10566,31825,46551,50842,40245,12711,12744,12744,12744,23406,27600,23374,23341,21261,19148,19147,14889,14857,17002,23341,12776,21229,21228,14857,19115,27567,33906,36019,19082,19082,19082,16937,14792,12711,12679,10566,10533,25389,29614,21130,29582,27500,29581,31727,23242,25388,33872,35953,31759,25421,29647,33906,33971,33971,33971,33971,33939,33938,33971,33938,36051,36019,25422,12744,8485,8452,8452,12711,36018,21260,25453,36051,36051,118},
{52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,50843,50842,50842,50842,52891,52891,52891,52891,52923,52923,52923,52923,52923,52891,52891,52891,50842,50842,50842,50810,50810,50810,48762,48730,48730,48730,48730,48697,48697,48697,48697,46649,46649,46649,46649,46617,46617,44536,44536,44504,44504,44504,42456,44504,44504,44504,44569,46617,46617,46617,46649,46649,46649,46617,46617,46649,46617,46617,46617,46617,46617,46617,46617,46617,46585,46584,44536,44536,44536,44536,44504,44504,42424,42424,42424,44504,44536,44536,44536,46584,46617,46617,46617,46617,46617,46617,44536,40278,38165,33939,27600,19181,19115,17003,14922,17003,17067,23439,23407,17035,17068,17068,21294,19181,17035,17035,19213,21293,19213,21293,17003,21261,21326,21326,23374,19148,21261,19180,17067,27600,23406,12808,17034,17035,25487,12711,10598,10598,10631,10663,10598,8518,8518,12776,12744,10598,10598,12744,10631,12744,10598,10631,10631,10598,10566,10598,10663,14889,19115,12776,10631,10598,8518,8518,10630,10598,10598,8518,27535,46552,57116,42358,14856,14889,14889,19050,23309,19083,10631,8485,8485,8485,14857,8485,8485,14857,23341,12711,23374,19115,12776,17002,14857,33873,55035,52955,52890,25421,21163,21163,16969,12711,10565,8453,27534,31727,19017,23243,29614,27501,29581,21162,23275,27468,12678,8453,12679,29680,33971,36019,36051,33971,33971,33971,33971,33939,33971,33971,33939,36051,36019,29680,21228,12711,12711,29647,21195,29647,36051,36051,114},
{52923,52923,52923,52923,52923,52923,52891,52923,52891,52891,52891,50843,50842,50842,50843,52891,52891,52891,52923,52923,52923,52923,52923,52923,52891,52891,50842,50842,50842,50810,50810,50810,50810,50810,48730,48730,48730,48730,48697,48697,48697,46649,46649,46617,46617,46585,46584,44536,44536,44504,44472,44472,42456,42456,42456,44536,46585,46617,46649,46649,46649,46649,46649,46617,46649,46617,46617,46617,46617,46617,46617,46649,46617,46617,44536,44536,44536,44536,44536,44536,44504,44504,42424,42424,42424,44504,44536,44536,44536,46584,46617,46617,46617,46617,46617,46617,44536,44504,44536,31858,25487,21293,23406,25519,25552,25552,25519,23439,23407,19213,21294,21293,19181,21293,21294,21293,23374,23439,23439,23406,21261,25520,25552,23407,21261,23374,27665,23406,21261,25519,23406,12809,19180,19148,23406,12711,10598,10598,10631,12744,10631,10598,8518,12744,10631,10598,10566,12712,10630,12744,10598,12711,10630,10566,10566,10598,10663,14922,17002,14824,10663,10598,8518,8518,10631,10598,10598,8518,25454,44439,57116,42390,23373,25454,25486,21260,23406,25487,21261,21228,21261,21260,27632,27567,27567,27600,25487,10598,23374,12776,12744,16970,12776,33874,57116,55003,55003,38164,23340,21227,16969,12743,10565,10533,31760,31760,19049,21130,31727,23243,33840,19049,25388,29614,10598,8485,14857,29713,33938,33971,33971,36019,36051,33971,33971,33971,36052,36051,31858,33971,36051,36051,36051,33971,25486,23341,23308,31793,36051,36051,120},
{52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,50843,50842,50842,50843,52891,52891,52891,52923,52923,52923,52891,52891,52891,52891,50843,50842,50842,50842,50842,50810,50810,50810,48730,48730,48730,48730,48697,48697,46649,46617,46617,46649,46617,46617,46584,44536,44504,44504,44472,42424,42424,42424,42456,44536,46617,46617,46617,46649,46649,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,44568,44536,44537,44537,44536,44504,44504,42456,44504,44504,42424,44504,44536,44536,44536,44536,46617,46617,46617,46617,46617,46617,44536,42391,38165,27632,23407,23439,27600,27665,27600,25487,25519,27665,27633,27632,27665,29745,29745,27632,25552,25520,27632,25519,25487,25519,25552,25519,25487,23439,21261,19148,19116,21293,23439,27632,25486,12809,19180,19148,23373,10631,10598,10598,10631,10663,10631,10598,10598,12776,10631,8518,8518,10631,10631,12776,10598,12743,10598,10598,10566,10631,12711,17002,17002,14824,10631,10598,10566,8518,10630,10598,10598,8518,25422,42358,57116,38132,23341,25421,23341,19082,29745,29778,27665,27632,27664,27600,25519,23374,23374,25519,29712,10631,25454,21196,14857,19083,16937,21163,50777,55036,52923,44471,25454,27534,21163,14824,10565,12678,40212,33873,23275,21162,29614,25356,29614,23243,25356,25356,10533,8485,16969,31793,33939,36019,36019,33971,36019,33971,34003,36051,36052,36052,31858,36051,36051,38132,36052,36084,27567,23308,25421,36051,36051,33938,130},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,50843,50842,50843,52891,52891,52891,52891,52891,52891,52891,52923,52891,52891,52891,52891,50843,50842,50842,50842,50810,50810,48762,48730,48730,48730,48697,48697,48697,46617,46617,46617,46617,46617,46617,46585,44536,44504,44504,42456,42424,42424,42456,42456,44536,46617,46617,46649,46649,46617,46617,46617,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,44536,44537,44536,44536,44504,42456,42456,42424,42424,42424,44504,44536,44536,46584,46584,46616,46617,46617,46617,46617,46649,44536,42391,42423,25487,19148,21294,19148,19213,14890,14890,14922,14954,14922,12777,17035,19148,17068,14922,12777,12777,14922,12809,12777,17068,23407,21294,21294,21261,23407,25487,23374,21294,21229,27632,25519,12744,14922,12776,14922,10663,12711,10630,10631,10631,10663,10598,10598,10663,10631,10598,10598,10631,10598,12744,10598,10663,10598,10630,8518,10631,10630,10631,10630,12776,10631,10631,10566,10598,10598,10630,10598,10598,23373,42358,55036,31793,23341,25421,21228,23341,40310,44503,42423,40343,42423,40310,40343,42391,40310,29745,29680,10598,25487,19083,12744,19083,17002,12711,21195,50809,52923,40244,31760,36051,21195,29647,23276,19050,38132,29647,21162,19082,16904,27501,31727,21098,19049,23308,8485,6372,19115,31858,33938,33939,33971,36051,36051,36051,36051,36051,36051,36019,33938,36051,36084,38164,38132,36051,23341,19115,23341,36051,36051,33906,137},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52891,52891,52891,52891,50843,50842,50842,50842,50842,50810,50810,48762,48730,48730,48730,48730,48698,48697,46617,46617,46617,46617,46617,46617,46585,44536,44504,44504,42456,42455,42424,42456,44504,44536,46617,46617,46649,46649,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46584,44536,44536,44504,44504,42456,42456,42423,42424,42424,42456,44536,44536,46584,46584,46617,46617,46617,46617,46617,46617,46584,42423,44504,25519,19181,21229,21261,23406,19180,21229,21261,27633,27665,23374,27632,27665,23407,25487,23407,23407,25487,23439,25519,23439,21294,25487,23439,23406,23439,25519,21261,21293,21261,29778,27567,12776,14857,12744,12776,12744,12809,10631,12776,10663,12776,10631,12744,12744,12776,12744,10663,10631,10631,14857,12711,12744,10598,10631,10598,10631,10598,10631,10598,14857,10631,12711,10598,10631,10598,10598,10663,12711,25454,48665,55003,29647,23341,23341,19115,29680,40310,38165,31761,29615,27567,27567,29680,27599,25454,25422,29712,21228,31826,16970,10598,17002,19082,12679,10598,27534,48697,31825,36018,33873,10630,23276,38164,27534,33873,42325,33873,19082,31760,31728,21130,23276,25421,25388,8453,6340,23341,33938,36051,33971,33971,34003,34003,36052,36084,36051,36052,33971,31858,36051,36084,38164,38132,36052,21195,19115,25486,38132,36051,31793,120},
{52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,50842,50842,50810,50810,50810,50810,50810,48730,48730,48730,48730,48698,48697,46649,46617,46617,46617,46617,46617,46585,44536,44504,42456,42456,42423,42456,42456,44504,44536,46617,46617,46649,46649,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46585,46584,44536,44536,44504,44504,44504,42456,42423,42424,42424,42456,44504,44536,46584,46584,46617,46617,46617,46617,46617,46649,44536,40310,38197,27633,23406,27600,25519,25520,25552,25520,23407,29746,29778,29713,29713,27665,27600,27632,27665,27633,27632,25551,25519,25519,23407,25552,25552,21261,23374,23374,23407,21229,17002,25552,29745,21260,23341,16970,21227,19115,21261,29745,23341,10663,10598,17002,27567,10631,10631,12711,25486,12744,12744,10631,16970,12776,10598,10598,16969,14824,10598,10598,16969,17002,10631,10598,12776,16970,10598,10598,14824,16970,27567,55004,50777,25453,25421,25421,19082,33906,38197,33938,29680,27599,27599,29712,36019,33938,29680,27534,33971,33938,44471,40277,38132,29680,17002,21195,19115,29647,38164,25453,40212,27567,23276,12678,16969,35986,38131,33905,25421,19050,23276,23275,25420,23308,27501,25388,8420,6372,27534,33938,36051,36051,36051,36051,33971,34003,36051,36051,38164,36051,33939,36084,38132,38164,36084,33971,19082,21163,31760,38164,38132,29680,112},
{52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,50843,50843,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,50842,50842,50842,50842,50810,50810,50810,48762,48730,48730,48730,48697,46649,46617,46617,46617,46617,46617,46585,44536,44536,44504,42456,42424,42423,42423,42456,44504,44536,46617,46617,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46585,44536,44536,44504,44504,42456,42424,42424,42423,42423,42424,44504,44536,44536,46584,46616,46617,46617,46617,46617,46649,44536,42391,40278,31858,25519,17067,19148,21326,21293,19181,17003,23407,23407,19116,21294,21326,17068,21294,21326,21294,19181,17035,14922,14922,14890,19116,17067,17035,23406,23406,23374,23406,23373,23342,29778,29745,27534,23308,23308,19050,27567,40277,25487,10631,10598,23341,29648,10631,12743,14824,29712,12776,12744,12744,21228,14857,10631,10598,19115,14857,10630,10598,19115,17002,10663,10598,16969,16970,10598,10566,14857,17002,27567,55036,46584,25421,25421,25421,21195,36083,36051,31793,25486,25454,25422,25486,25487,25454,21195,21195,33971,33938,46584,50778,46551,25454,23373,19082,16969,27502,33938,29712,40277,23276,33841,29647,19082,19082,38099,27534,25421,17002,10598,19050,29679,25388,23243,21162,6372,8452,31760,36051,36019,36051,36019,36051,36051,36084,36052,36052,38132,36019,33906,36052,38197,38165,38164,33906,19082,17002,33873,38164,36051,31825,91},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,50842,50842,50842,50843,52891,52891,52891,52891,52891,52891,52891,52891,52891,50843,50843,50842,50842,50810,50810,50810,50810,48730,48730,48697,46649,46649,46649,46617,46617,46617,46584,44536,44536,44536,44504,42456,42424,44472,44472,44504,44536,46585,46617,46649,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46649,46649,46617,46617,46617,46617,46585,46585,46584,44537,44504,44504,42456,42424,42424,42423,42423,42424,44504,44536,46584,44536,46584,46617,46617,46617,46617,46617,46584,42391,38165,31891,27665,21261,23407,25584,25552,25552,23374,21261,21261,25519,23407,23406,23406,21326,23439,19148,21261,25520,27632,27600,27632,25519,25520,25520,23407,23406,23439,23407,25519,31858,38197,33873,29614,23243,23243,19083,29680,38164,21228,8518,8485,25422,25422,12711,12679,16937,31760,12744,10663,12776,21228,14857,10631,10631,19115,12776,10631,10598,19147,16970,12744,12679,17034,14889,10631,10631,19082,17034,29648,55004,42325,23341,25421,23341,21227,40309,38165,36019,31858,33906,31825,36019,36052,36019,27534,27599,31825,31793,46616,48664,44503,29647,14824,12679,19050,33905,36051,31825,35986,12678,14791,33905,35986,25453,38132,21195,16937,14824,12711,19017,33873,25421,19017,25356,6372,10565,31825,36084,36052,36052,36051,36051,36051,36051,36084,38165,38165,33971,31825,33971,38165,40245,38132,31793,19115,21228,38099,38164,33939,33906,102},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50842,50842,50810,50842,50843,50842,50843,50843,52891,52891,52891,52891,52891,50843,50842,50842,50842,50810,50810,50810,50810,48730,48730,48697,48697,46649,46649,46617,46617,46617,46585,44536,44536,44536,44504,44504,42424,42424,44504,44504,44504,44537,46617,46649,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46649,46649,46617,46617,46617,46617,46585,46585,44536,44536,44504,44504,42456,42456,42423,42423,42423,42424,44504,44536,44536,46584,46584,46617,46617,46617,46617,46649,44536,42423,44504,31858,25519,27600,27600,27632,27632,27632,27697,29778,27697,27665,27665,27665,27665,27633,25552,27633,27632,25584,27633,27632,25487,19180,21261,25519,23439,23406,25519,23439,23374,27600,33938,33873,31727,16905,19082,19050,31793,38164,31793,27567,27567,33873,21195,12711,12679,16970,29648,12711,12711,14856,21228,12776,12711,12711,21196,12776,10631,10630,19179,14857,12711,10598,19083,14824,12711,10631,19115,16937,35986,48697,35986,25421,25421,23276,25421,38197,31793,25454,23308,21260,21260,27599,25486,23373,19082,27567,29679,27534,29647,29711,36018,23374,16970,12679,19082,33938,38164,40245,27567,27534,25421,23308,31793,38164,33906,21228,23308,14889,14824,14792,21195,29647,19050,19049,6340,14824,33971,36084,36084,36084,36051,36051,36052,36051,36084,38165,40277,33906,33938,36084,38197,40245,38132,29647,16969,23341,38132,38132,33906,36019,106},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,50843,50843,50842,50842,50810,50842,50843,50842,50843,50811,50810,50842,50843,50842,50842,50842,50843,50842,50842,50810,50810,50810,48762,48762,48730,48730,48698,48697,46649,46649,46617,46617,46585,44536,44536,44504,44504,44504,44472,42424,42456,44504,44536,44536,46617,46649,48697,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46649,46649,46617,46617,46617,44569,44537,44536,44536,44536,44504,42456,42456,42424,42423,42423,42424,44536,44536,44536,46584,46584,46617,46617,46617,46617,48697,46584,42391,38165,33971,29745,21229,21326,23471,23439,21294,21326,17068,19116,12809,12809,12777,19213,17035,14954,19181,17100,17068,21326,21293,19115,27600,21293,14857,16970,14922,19213,17035,14889,21261,25487,31760,21130,12679,16905,14856,23341,25389,23341,23341,23309,31793,17002,10631,12711,16937,23341,14857,12744,19050,21196,14824,12744,12744,19082,12744,12711,12743,17035,14857,12744,12743,17002,12744,12744,12743,16970,14824,36051,42325,33873,27534,25453,23308,27599,42358,40277,33971,33938,36051,31858,31858,31793,27599,21228,31825,29647,29615,21195,21194,31792,23342,19083,12711,21228,36019,40244,36051,27599,33905,35986,31760,21162,33938,29712,21228,29712,23309,14856,19050,21228,33905,27502,16969,6339,21163,36019,36084,36084,36084,36051,36084,36084,36084,36084,38164,40277,33938,36019,36084,38165,38132,38164,29680,19082,27567,38164,36051,31793,36051,89},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,50843,50842,50842,50810,50842,50842,50842,50842,50810,50810,50811,50810,50810,50810,50810,50842,50842,50842,50810,50810,50810,48762,48730,48730,48730,48697,48697,46649,46649,46617,44569,44536,44536,44536,44504,44504,42456,42424,42424,42456,44504,44536,44536,46617,48697,48697,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,44536,44536,44536,44504,44504,42456,42456,42424,42423,42424,42424,44536,44536,44536,44536,44536,46617,46617,46617,46617,46617,44536,42423,44504,29745,23406,21294,23374,25552,25519,25584,27665,23374,23407,23406,25487,23406,25519,25520,25520,25520,25584,25487,19116,19180,19148,23374,25487,25519,27600,25552,25520,25519,23374,17035,23341,29680,16937,12711,12744,14857,27567,27567,27567,29647,29648,33906,31760,16937,10631,10598,12711,19083,10598,31793,21228,14922,14857,14857,12776,14857,12744,12776,12776,14922,14889,14857,14889,14824,14856,12744,12744,12711,31793,40245,31760,27599,27566,27534,33970,40277,36051,31793,31793,31858,31793,33906,31825,27535,25421,33906,23373,25421,25388,21162,29647,23341,17002,12744,21228,35986,38164,33938,27599,29680,29679,29680,29712,36051,23341,12711,14824,14856,10598,10630,25454,38099,35986,19050,12711,25389,36051,38165,36084,36052,36084,36052,38132,38132,38164,38197,40277,36051,38164,38197,38165,36084,38132,25421,19082,31793,36116,34003,31793,33938,60},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50842,50842,50842,50842,50842,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50842,50842,50842,50810,50810,50810,48730,48730,48697,48697,48697,46649,46649,46617,44536,44536,44536,44536,44504,44504,42456,42456,42456,42456,44504,44504,44536,46617,48697,48697,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46617,46585,44536,44536,44504,44504,42456,42424,42424,42424,42424,42424,44504,44536,44536,44536,46616,46617,46617,46617,46617,46617,46584,42391,42391,31858,27568,25487,25519,27600,25519,25519,25519,29713,29745,27665,27665,27632,25519,27600,25520,27665,27633,27633,25455,25487,27665,25487,23374,25519,25487,25519,25520,25487,23374,25519,27600,25454,16938,12679,12711,12711,19050,19018,16937,19050,42358,25422,21228,16937,10598,8518,12679,19050,10631,27534,17034,29614,19082,14921,21195,33807,29614,29614,25421,31760,31792,27534,29614,31727,27501,19082,25421,38099,33873,40244,27599,27567,27566,21195,36051,36019,31826,25454,25454,25422,25486,25454,23308,19083,19115,25486,21260,29712,25420,23308,27567,25454,19115,12743,19082,33906,40277,29712,27599,27599,25518,29712,33906,29647,16969,27566,25421,25389,10630,8517,21195,27567,29647,25454,21195,31793,36052,38165,38164,36084,36084,36084,36052,36116,38164,40277,38165,36051,38165,40245,38197,38165,36083,23340,21195,33906,36051,33971,31825,31760,69},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52890,50842,50842,50842,50810,50810,50810,50810,48762,48730,48730,48762,48730,48762,50810,50810,50810,50810,50810,50810,50810,48762,48730,48730,48697,48697,46649,46649,46617,46584,44536,44536,44536,44504,44504,42456,42456,42456,42456,44504,44504,44536,46617,46649,46649,48697,46649,46617,46617,46617,46617,46617,46617,46617,46649,46617,46617,46617,46617,46617,46585,46585,44536,44536,44536,42456,42456,42456,42424,42424,42424,42424,44504,44536,44536,44536,46584,46617,46617,46617,46617,48665,46584,42423,38197,33971,27633,14922,19148,21294,21326,23406,19181,14922,14922,12777,14890,14857,12809,14890,12777,17068,19213,21261,19116,17035,17035,19148,17035,14889,10696,12809,14890,12809,12744,21261,29648,31728,21131,12679,12679,10631,10598,10631,10598,12679,42358,23341,14889,17002,10631,8517,12679,16937,12679,19115,21194,50676,38032,33872,40112,50677,25355,25388,36018,46583,46583,40244,31760,27501,23243,29613,35952,33840,29647,38164,25486,27566,27534,29647,38164,40277,38164,33939,33938,33906,31858,31793,31793,23309,29680,29744,16969,29680,21227,25422,27534,23374,16970,10631,19082,33906,38197,29647,29647,27567,25486,29712,29647,31825,27567,21195,16969,14856,12711,10566,14824,31728,21195,27567,19082,33938,38164,38165,38165,36116,38164,36084,36084,36084,38164,40277,38132,36051,38164,38197,38197,38197,36051,19147,23340,36084,36051,31825,33906,27502,73},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,50842,50842,50810,50810,50810,48762,48762,48762,48730,48730,48730,48730,48762,50810,50810,50810,50810,50810,50810,50810,48762,48730,48730,48697,48697,46649,46649,46617,44569,44536,44536,44536,44504,44504,44504,44504,44504,44504,44504,44536,44569,46617,46649,46649,46649,46649,46617,46617,46617,46617,46617,46617,46617,46617,46649,46649,46649,46617,46617,46617,44569,44536,44537,44536,44504,42456,42424,42424,42424,42424,42424,42456,44536,44536,44536,46584,46617,46617,46617,46617,48697,46584,44504,44504,40278,33971,23374,25487,25487,25487,23374,21261,21261,21261,19180,21229,21229,21261,21293,21261,23407,23374,23407,21261,21294,21294,25487,23439,25520,21261,21229,21261,21228,23341,23374,27567,27502,21163,12679,10599,10598,10598,10598,10598,12679,42326,27502,12744,21196,10598,8485,12711,14857,10631,14921,21129,50644,31693,29613,29613,31726,21195,23308,40212,44503,44503,44471,42357,38131,29647,33839,31727,19082,25421,36051,25486,27566,27567,33971,38196,33906,31760,27599,27599,27599,31793,29648,27535,21228,31760,31793,14857,35986,25454,14824,25454,40245,31825,27567,27599,33906,33971,29647,31760,25453,23373,31792,29679,29679,29679,23308,19114,25453,14889,14824,19082,33873,19114,27599,27567,36019,38164,38197,38197,38165,38164,38165,38164,38164,38165,40277,38164,38164,38164,40277,40278,38197,31825,17002,25453,38165,36084,31825,33939,21195,67},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,50842,50842,50842,50810,50810,50810,50810,48762,48730,48730,48730,48730,48730,48730,48762,50810,50810,50810,50810,50810,48762,48730,48730,48730,48697,46649,46617,46617,44569,44536,44536,44504,44504,42456,44504,44504,44504,44504,44504,44536,46617,46617,46649,46649,46649,46649,46617,46617,46617,46617,46617,46617,46617,46649,46649,46649,46649,46617,46617,46617,46617,46585,44536,44536,44504,42456,42424,42424,42424,42424,42424,42456,44536,44536,44536,44536,46584,46617,46617,46617,46617,46617,46617,46617,48729,40277,19148,21229,19148,19181,21229,19180,27632,27632,27600,23406,23342,23342,23374,23407,25519,25487,23406,25519,23374,23309,31566,25260,25260,27340,27275,33581,35888,31695,23146,29485,25227,23114,16840,12679,12679,12679,12679,12679,12711,42358,31761,14856,23276,10630,8485,12744,14824,10631,14921,21194,50644,37999,35920,21162,19049,19082,25388,44405,44503,46551,46551,44470,42390,33906,35952,23275,33841,31760,31825,25421,25486,25486,31825,38164,36019,31793,27599,27535,27599,31825,25454,23341,19082,33938,27567,10631,31760,27534,8518,27567,48697,44503,36051,27534,27567,31793,27567,25454,19082,19050,31793,31792,29679,31760,25421,12743,16969,16970,8518,10566,12743,23341,36019,38197,36084,38229,40277,40245,40245,38197,38164,40245,40277,40245,40277,38164,38197,40245,40278,40278,40277,31793,19083,29680,38165,36084,31793,35986,16969,66},
{52923,52923,52923,52923,52923,52923,52923,52923,52891,52923,52923,52891,52891,52891,52891,50843,50843,50843,50810,50810,50810,50810,50810,48762,48762,48762,48762,48762,48730,48762,48762,48762,48762,50810,50810,48762,48730,48730,48697,48697,46649,46617,46617,44536,44536,44536,44504,44504,44504,44504,44504,44504,44504,44504,44536,46585,46617,46649,46649,46649,46649,46617,46617,46617,46617,46617,46617,46617,46649,46649,46649,46617,46617,46617,46617,46617,44536,44536,44536,44504,42456,42456,42424,42424,42423,42456,42456,44536,44536,46584,46585,46617,46617,46617,46617,46617,46617,46649,46617,48697,40278,21229,25454,25519,25519,25519,25487,19180,19148,19148,23406,23406,25454,25389,23244,16937,19050,19018,21066,25259,27372,31533,29420,27307,29388,27242,25195,31630,27372,25129,29388,33679,27275,16840,12679,12679,12679,14759,12679,12646,42325,33906,19050,21228,12711,8518,14889,12711,12711,14889,25355,50644,33839,31759,23275,21130,21163,21195,33873,46551,46551,46551,46551,44503,31792,23275,16937,25389,31792,29680,25454,25486,27567,36019,40310,38132,36019,33938,33906,33939,36051,33906,27567,27534,33970,21228,8485,12711,25454,36019,40277,40277,33906,29647,29647,23341,27567,27566,25389,23340,27534,31793,31792,27599,36018,21195,12711,14824,23309,10598,10598,8485,21228,40245,40277,38165,40310,40278,40277,40277,40245,40277,40245,40245,40278,40310,38164,40277,40278,40310,40277,38197,27567,19115,31826,38164,36051,31825,31825,16937,60},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,50842,50842,50842,50842,50842,50810,50810,50810,50810,48730,50810,50810,48762,48762,48762,48730,48762,48762,48762,48762,48730,48730,48730,48730,48697,46649,46617,46617,46584,44536,44536,44504,44504,44504,44504,44504,44504,44504,44504,44536,46585,46649,46649,46649,46649,46649,46617,46617,46617,46617,46617,46617,46617,46649,46617,46649,46617,46617,46617,46617,46617,44569,44568,44536,44504,42456,42456,42424,42456,42456,42456,42456,44536,44536,46584,46584,46617,46617,46617,46617,46617,46617,48665,46617,48697,40278,23374,25487,27664,23341,25422,27470,29551,29551,31631,27470,27438,27405,29583,29583,31696,29647,29615,27567,27535,27535,21228,23309,25422,25422,25454,38132,31761,25422,25454,23341,31760,23276,12711,12647,12647,10598,14792,14792,10598,42293,38099,19050,27502,10631,8485,16937,12711,10631,12744,25355,46450,25355,25355,29582,19082,35985,38163,33905,42325,46551,48664,46519,29614,23243,19017,16904,16937,23308,27567,27534,27566,27566,36051,33938,29712,27567,27567,27535,31793,29712,27567,21228,25454,33970,17002,8485,12711,23309,27567,38197,38197,23308,27566,31760,21163,16937,21195,21163,19050,29679,31825,31825,29679,27566,14921,19147,25454,27567,12711,10631,14824,14857,36051,38165,40245,40278,40277,40277,40277,38197,40277,40310,40310,42390,42358,38164,40278,42391,42390,40310,40277,29647,23341,36052,36084,33939,33906,29648,14856,64},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52923,52891,52891,50842,50842,50810,50842,50842,50810,50810,50810,50810,50810,50810,48762,48762,50810,48730,48730,48730,48762,48762,50810,48762,48730,48730,48730,48697,46649,46617,46617,44536,44536,44536,44536,44504,44504,44504,44536,44504,44504,44504,44504,44536,46649,46649,48697,48697,48697,46649,46617,46617,46617,44569,46617,46617,46649,46617,46617,46617,46617,46617,46617,46617,44568,44536,44536,44504,44504,42456,42456,42456,42456,42456,44504,44536,44536,44536,44536,46616,46617,46617,46617,46617,48665,48665,48697,48697,46584,42390,40278,38197,42261,33841,29616,29616,29648,27600,27600,27600,27567,27600,27632,27632,27600,27600,27600,27632,25487,25487,27567,25454,25455,27567,27535,25454,25454,25454,25454,25454,23276,12743,12679,14759,12679,14792,12711,12679,42325,36019,14824,21196,10631,8485,10598,10566,12711,12808,27500,44337,33839,31758,35920,21130,36017,40211,38098,46550,50809,46518,25453,16937,12711,16904,16904,16904,23308,25486,25453,25486,25486,38132,33939,31825,29680,29680,29647,29712,27599,27567,21195,29712,31825,12711,8485,17002,27600,14857,25454,31825,23308,27534,27566,19114,14824,21163,16969,14856,29615,31760,29712,31792,25453,14856,14889,23373,34003,16970,10631,14856,14824,40245,38197,42358,42358,40277,40277,40277,40277,40278,40310,40310,42390,40310,40245,40310,42390,42358,40278,38164,23340,25454,38197,38164,33906,35986,25454,16937,76},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,50843,50842,50842,50810,50810,50810,50810,50810,48762,48762,48762,48730,48730,48730,48730,48730,48730,48762,48730,48730,48730,48730,48697,48697,46649,46617,46617,44536,44536,44536,44536,44536,44536,44536,44504,44504,44504,44504,46585,46649,48697,48697,48697,46649,46649,46617,46617,46617,46617,46617,46649,46617,46617,46617,46649,46617,46617,46617,44569,44569,44536,44536,44536,44504,42456,42456,42456,42423,42456,44504,44536,44536,46584,46584,46617,46617,48665,46617,48665,48697,48697,48697,48697,48697,48697,48697,46649,46649,44536,42456,40310,36084,33972,34003,33971,34003,33971,33971,33939,40278,38132,25487,38197,21261,19115,27567,27535,23342,31794,27567,27534,27502,21163,19083,25454,25389,14792,12679,12711,12678,12711,10598,12711,40212,36019,23243,29615,10631,8485,8518,8518,12744,12809,31661,42192,29613,27533,40179,21130,35953,40211,36018,25421,31759,29614,16905,16937,12711,16904,19017,19050,25421,23341,25486,21195,27566,40277,36019,33874,31793,31793,31793,31858,31825,29680,23341,31858,27567,10566,10566,19083,29680,14856,14921,21195,27599,31793,23340,19114,14791,16937,14856,19050,31792,31792,29679,35986,25421,10630,12711,27664,38196,29647,8518,10598,12711,38132,38197,40310,42358,42358,40310,40277,40277,40277,40310,42358,42391,40310,40277,40277,42390,42390,40278,36019,21228,27566,38164,38164,33873,36019,21163,16969,71},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50843,50843,50843,50842,50810,50810,50810,50810,50810,48762,48762,48762,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48697,46617,46617,46617,46585,44536,44536,44536,44536,44536,44536,44536,44504,44504,44504,46584,46617,48697,48697,48697,48697,48697,46617,46617,46617,46617,46617,46649,46649,46649,46617,46617,46617,46617,46617,46617,44536,44536,44536,44536,44504,42456,42456,42424,42424,42424,44504,44536,44536,46584,46617,46617,46617,46617,46617,48665,48697,48697,48697,48697,48665,46617,46617,46617,46617,46649,44536,40343,40310,40310,40310,40278,38197,38165,36084,36084,42391,38133,25487,29778,25487,21261,27535,27502,25422,33906,21228,27535,29615,19115,16970,29647,25421,14824,10631,14792,14791,14792,14791,12711,40212,40213,33873,35953,12679,10598,10598,8518,12711,12744,33774,35919,23275,25387,38099,19049,33872,40244,36018,23243,31726,31760,16970,16937,12711,14824,33873,27534,19082,16937,25486,10663,29745,38132,29680,25454,25422,25454,25454,27535,25421,23308,23308,33971,25454,8485,10631,23374,27632,17002,17067,19147,17002,14889,19115,19114,14856,12743,10630,21227,31793,31824,29711,31825,17034,17034,23373,29744,33873,40212,16970,8453,25454,40278,40310,40310,42358,42358,42358,40310,40310,40277,42358,42391,44471,40245,40277,42358,42423,42390,42390,31825,21195,29680,38164,38164,29712,33906,21228,21195,84},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,50843,50843,50843,50842,50810,50810,50810,50810,48762,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48697,46649,46617,46617,46585,44536,44536,44536,44536,44536,44536,44536,44536,44536,44536,46584,46617,48697,48697,48730,48730,48697,46649,46617,46617,46617,46617,46617,46649,46649,46649,46649,46617,46617,46617,46617,44536,44537,44537,44536,44504,42456,42456,42424,42456,42456,44504,44536,46584,46584,46617,46617,46617,46617,46617,48697,48697,46649,46649,48665,48665,46617,46649,46617,46617,46617,44536,40343,44536,44471,42391,40310,40278,40278,36084,36084,29745,25455,21293,27665,29713,29712,27632,23374,25487,25487,25389,31825,29647,23308,21163,29680,29647,16937,16937,14824,10598,14824,10598,12711,38099,44471,25421,25421,35854,33774,12711,8518,12776,12776,33806,38000,27501,27468,40244,16969,33872,40276,38099,27533,35985,33840,19018,19017,12711,14824,25421,19050,14824,19115,19082,8485,31825,38165,36019,31793,29713,29712,31793,29713,27599,23341,27534,38132,19082,8485,16970,23341,29713,19147,19115,14921,12711,12679,17002,25388,33905,33873,29711,33873,31792,31825,31792,31793,12711,10630,17067,34035,38099,29680,36051,33873,42358,38197,40310,42390,42390,40310,40310,42358,42358,42358,42358,44471,44471,40213,40277,42358,42423,42390,42358,27567,21195,31825,38164,36084,31793,29647,23373,23340,86},
{54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,50843,50843,50843,50811,50810,50810,50810,50810,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48697,48697,46649,46617,46617,46617,44537,44568,44536,44536,44536,44536,44536,44504,44536,44536,46584,46617,46649,48697,48697,48730,48697,46649,46617,46617,46617,46617,46649,46649,46617,46649,46617,46617,46617,46617,44569,44568,44537,44537,44536,44536,42456,42456,42424,42424,42456,42456,44504,44536,46584,46617,46617,46617,46617,46617,48697,48697,46649,46649,48665,48697,46617,46617,46649,46617,46617,44536,40343,40310,40310,40310,40278,38197,38165,36052,33971,29713,25519,27600,27632,25487,25519,27600,21261,23374,25422,23309,31760,27567,29647,23276,29680,31792,16969,16937,16905,10598,14824,10598,12711,38099,38100,19018,14824,37999,40047,16904,8485,12776,12776,35886,33838,29581,27533,36018,19017,33840,40276,38098,23275,31759,33872,19050,19050,14791,14824,21163,19083,16970,21228,19082,8485,31825,38197,33971,31825,31825,29712,31826,29745,29712,25421,31793,33906,19018,19017,27501,23341,29713,21261,19115,14921,12776,12743,17034,25421,36018,40212,40212,36018,31824,33905,33938,29679,14889,17001,23405,36083,38164,27566,31825,27599,31825,38197,40277,40278,42390,42390,42358,42358,42358,42358,42391,44471,42390,40245,40278,44471,44503,42390,40278,27534,23341,36084,36084,33971,33938,16937,6404,8485,37},
{54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50843,50843,50843,50811,50811,50810,50810,50810,48762,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48730,48697,48697,46649,46617,46617,46617,46585,44537,44536,44536,44536,44536,44536,44536,44536,44536,46584,46617,46649,48697,48697,48697,48697,46649,46617,46617,46617,46649,46617,46649,46649,46617,46617,46617,46617,46585,44569,44568,44536,44536,44536,44504,42456,42456,42456,42456,42456,42456,44536,46584,46617,46617,46617,46617,48665,48665,48665,48665,48665,48697,48697,48697,46617,46649,46617,46617,46617,44536,42391,38262,40310,42423,40342,40310,40278,38197,36117,33971,27632,31826,29745,25487,27567,31826,25454,27600,38164,31793,27567,27534,19115,16970,31760,29647,16969,16969,16905,10598,14792,12646,12711,36019,35986,27566,25356,33774,37934,21097,8486,12776,12776,37999,31693,27501,21227,31825,19050,31759,40244,36018,23274,31759,33873,19050,19050,12711,14824,21163,23341,16970,16937,19115,8453,31825,33939,29712,25486,25486,25454,27600,23373,23309,19115,31825,31793,29646,38066,46518,33873,33938,21260,21292,19179,17001,14889,19114,25453,38099,38131,33906,33905,33873,31825,31792,17066,19212,23405,29679,33873,29711,23340,31760,14856,17002,29745,38197,40277,40277,40310,42390,42390,42390,42390,44471,44504,42390,40310,42358,44471,44471,42390,38132,21227,25454,38164,36084,31857,36051,23276,16937,16969,78},
{55003,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50843,50843,50843,50811,50811,50810,50810,50810,50778,48730,48730,48730,48730,48730,48730,48730,48730,48698,48730,48730,48730,48730,48730,48697,48697,46649,46617,46617,46617,44537,46585,44536,44536,44536,44536,44536,44536,44536,44536,46584,46617,46649,48697,48697,48697,48697,46649,46617,46617,46617,46649,46617,46649,46649,46649,46617,46617,46617,46585,44569,44536,44536,44536,44536,44504,42456,42456,42456,42456,42424,42456,44536,44536,44536,46617,46617,46617,48665,48665,48665,48697,48697,48697,48697,48697,46617,46617,46617,46617,46617,44536,42423,38230,40278,40278,38197,36117,36084,36052,33971,33906,31793,38165,36052,29745,23374,29745,19148,23374,44471,31794,23373,23341,19083,19082,29647,25421,19018,16937,16937,12678,14824,12678,12711,36019,44504,29647,23308,12711,12711,14889,23341,19082,16937,37999,25387,21130,19050,31760,19082,31727,40244,38098,23307,33839,42325,21195,19082,14856,16937,19082,23341,16937,16969,19147,10630,33938,38197,33939,31825,29712,29713,31793,27534,25389,21195,33938,27567,23243,31760,38099,27566,29712,27599,29744,21293,17066,17034,21292,29647,42357,42357,35986,29679,33937,31824,35986,12776,10695,17034,38261,42325,21162,23340,31792,16969,12711,12711,27567,38164,40277,40310,42390,42390,42391,44471,44471,44503,40277,42423,44471,44471,44471,42391,36019,23340,29680,38132,36051,31825,36019,19082,16969,19050,77},
{55003,55003,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,50843,50843,50842,50810,50810,50810,48762,48730,48730,48730,48730,48730,48730,48730,48730,48697,48698,48729,48730,48730,48730,48697,48697,48697,46617,46649,46617,46585,46584,46584,44536,44536,44536,44536,44536,44536,44536,44536,46617,46617,46649,48697,48697,48697,46649,46617,46617,46617,46617,46649,46649,46649,46649,46617,46649,46617,46617,46617,44569,44569,44536,44536,44536,44536,44536,42456,42456,42456,42456,44504,44536,44568,46617,46617,46649,46649,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,46617,42456,40343,38197,38197,36117,36117,38165,36084,34004,33907,25455,29713,29745,25487,31826,33938,21261,25519,44471,40278,23374,25486,23373,23341,25421,27534,25421,19050,16937,14824,14857,14824,14792,38099,46616,25454,12679,10566,8518,19115,29712,21260,17002,35886,27468,25388,19049,29647,21162,29646,40211,38098,25420,31791,27534,23308,31727,29614,23308,23308,23373,21228,19115,17002,14856,27599,29680,25487,25454,23341,23341,29712,29680,25454,29680,36051,21196,8453,27534,27534,21228,31793,25486,31825,23438,23373,21292,27599,38066,46551,46583,44438,44438,31792,31792,35986,21195,21195,25486,36051,36018,16969,23340,31825,19050,14856,12711,14857,27535,38132,40278,42358,42358,42391,44471,46584,42391,40310,42423,44503,44471,44471,42391,27599,21195,31825,36084,36051,33906,31825,16969,16969,16970,73},
{55003,55004,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52923,52891,52891,52891,52891,50843,50842,50810,50810,50810,48762,48762,48730,48730,48730,48730,48730,48697,48697,48697,48697,48730,48730,48730,48730,48730,48697,48697,46617,46617,46617,46617,46617,46584,44536,44536,44536,44536,44536,44536,44537,46585,46617,46617,46649,46649,48697,48697,46649,46649,46617,46584,46617,46617,46649,46649,46617,46617,46617,46584,46584,44536,44536,44536,42455,42455,42423,42423,42391,42391,42391,40343,40343,40342,42390,42391,42391,42391,42423,42391,44471,44439,42390,44438,42390,42358,42358,42358,40278,40277,40245,40245,40245,38164,33971,33939,33971,33971,33939,33939,33906,33906,33906,27632,21261,25487,23374,21261,25454,29680,23341,25454,29680,27567,19115,21228,21260,19115,19050,21195,17002,14824,16937,16970,16937,16969,19050,23341,25454,19115,14889,14857,14825,17002,19115,16970,14856,35853,25387,25388,14824,29679,25421,31727,42324,40244,31759,40243,29647,19082,29647,40244,38164,27566,23309,25454,25421,14856,8485,8485,10631,10663,10663,10566,8485,27567,29712,25486,31760,27599,14889,8485,14824,16969,21228,40245,42358,42423,31857,23405,27599,33938,33840,46485,44470,46550,42325,27501,19050,19082,23340,27598,31792,31760,29647,16904,23308,31792,31792,33905,33906,33906,31793,27567,36019,40310,42358,42390,44471,44504,42390,42423,44471,44504,44471,44471,42390,25421,23308,36019,38132,33938,33906,29615,16937,16969,19050,64},
{52955,55004,52955,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,50843,50843,50843,50810,50810,50810,48762,48762,48730,48730,48730,48730,48730,48697,48697,48697,48697,48730,48730,48730,48730,48730,48697,48697,46649,46617,46617,46585,46617,46584,44536,44536,44536,44536,44536,44536,46617,46617,46617,46617,46649,46649,46649,46617,46649,46617,40278,31793,27567,27567,25487,27535,25454,25454,25454,29712,23374,23374,23341,23374,21293,21261,21261,25487,23374,21229,21261,21261,21228,21228,21261,23341,25454,19148,19148,21196,21261,19148,19148,21228,25454,21196,19115,17035,19148,19115,17002,17002,21261,21228,19115,17002,14922,17035,14922,14889,14922,19180,14922,16970,16970,14857,14857,14890,12744,19115,12776,12809,14857,12744,12809,12809,14889,17002,14922,10663,12776,12776,12744,12776,12776,16937,19083,14857,14889,14922,14922,14857,14889,16937,16970,14857,14824,23275,19114,16969,25356,31792,29647,38099,46518,46485,42259,46485,38066,16937,21163,27566,27566,25454,19083,19115,17002,12711,10598,8550,10598,10631,10631,8518,16937,27534,31793,23340,14889,17002,19082,10630,25486,29647,25421,44471,46616,48665,44373,40244,29712,38099,35953,29582,27501,27469,23276,19082,21195,29615,33840,31760,29679,38099,25388,14791,21163,31793,16937,12743,14791,12743,12743,25421,23341,36019,42358,42391,44471,44503,42390,44503,44504,46584,44471,44471,36084,21195,23341,38164,38164,33906,33939,23308,16969,16969,19018,62},
{55004,52955,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50843,50843,50842,50810,50810,50810,48762,48730,48730,48730,48730,48697,48698,48698,48697,48697,48698,48698,48698,48698,48697,48697,48697,46649,46617,46617,46617,46585,46584,44536,44536,44536,44536,44536,44569,46617,46617,46617,46649,46649,46649,46649,48697,48697,46617,38164,27632,23374,21293,19148,25454,19180,21261,21229,27567,23341,21293,19116,21261,19180,19116,21261,23406,23341,19148,17035,21196,19148,17035,19180,21228,25454,19115,17002,19148,19115,19083,25519,25487,25519,25454,23374,21293,21293,21293,21261,19213,19181,19180,17067,17067,17067,19116,17067,17003,17035,17067,17035,17002,17035,17068,17035,17035,14922,17035,17003,17002,17034,17067,17035,19180,19180,17035,17035,14922,14922,12776,12744,12744,12776,12777,12776,12744,12744,12776,12776,12776,12776,14857,12776,12711,10631,10631,10663,10631,12711,10631,12711,12744,12711,10631,12711,10631,10598,10630,10631,10598,10598,10598,10631,10631,12711,12711,10663,10631,10631,10631,10631,19147,25454,25453,27566,27567,21163,23308,27567,21195,33906,33938,31760,44439,35987,42293,42292,44503,29647,31759,27501,12743,14824,8485,8485,12678,23340,29680,27502,31728,31760,35986,19049,12678,23276,31825,16904,8452,10565,8485,10565,25421,23341,27502,33906,42391,46584,31760,33906,44503,46616,46551,44471,44471,31793,19147,27534,38165,36084,31825,33938,19082,16969,17002,16937,77},
{55003,55004,52955,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,50843,50842,50810,50810,48762,48762,48730,48730,48730,48730,48730,48698,48697,48697,48697,48697,48697,48697,48697,46649,46649,46649,46617,46617,46617,46617,46585,46584,46584,44536,44536,44536,46585,46617,46617,46617,46617,46616,46616,46585,46584,46584,46617,44536,36051,29680,19148,19180,19116,19148,19148,19116,21228,27632,17035,17035,17035,17002,17035,17035,16970,23374,21228,16970,19115,17003,19083,17035,17002,21196,23374,14890,17003,17035,17002,31826,31858,25454,23374,23374,23374,19213,19148,19181,19213,17100,17067,19148,17068,17035,17035,17067,17067,14922,14922,14922,14922,14922,14922,14922,14922,14922,14922,14954,17003,14954,14890,17002,17003,17067,14922,14857,12776,17002,14890,12744,10664,10663,10663,12744,12744,10663,10663,10696,12776,14857,10631,12712,12744,10631,10631,10631,10631,10631,10631,10631,12711,12744,12712,10631,10631,10598,10630,10630,10631,10599,10598,10598,12711,10631,10598,10598,10631,10599,10631,10631,12744,23308,21195,27502,36051,33938,23308,21195,25486,29712,33906,36051,40212,33906,10598,27502,40180,46551,29647,31727,25388,14824,14856,14824,12678,12678,21130,21195,14856,19049,23308,23308,14856,10598,23276,31793,14856,8452,8485,8452,8485,21227,23373,23308,16970,40212,46584,21228,12711,29680,46616,46551,44471,40310,23341,19114,29712,38164,36051,31825,33906,19050,16969,16969,16937,75},
{55003,52956,52955,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,50843,50842,50842,50810,50810,48762,48730,48730,48730,48730,48698,48697,48697,48697,48697,48697,48697,48697,48697,46649,46617,46617,46617,46617,46617,46617,46617,46584,44536,44536,44536,44536,46585,46617,46617,46649,40310,29680,33971,29680,31826,33939,31826,31858,31793,27567,19148,19148,19148,19148,19148,19148,19148,27599,19148,17035,17035,17035,17035,19083,19116,23374,21261,17035,19083,17035,17035,17035,17003,21228,23374,19116,21228,17035,21228,42358,31825,25454,23374,23374,23374,21261,19148,19181,19181,17100,17068,19148,17068,17035,14955,17067,17035,14922,14922,14922,14922,14922,14954,14954,14922,14922,14922,14954,14954,14889,14889,14954,17002,19147,17034,14922,14857,14954,14889,12744,10663,10663,12744,12777,12776,10663,10663,10696,12744,14857,12744,12744,12744,10631,10599,10599,10631,10631,10631,10630,10663,12744,12744,10631,10631,10631,10631,10598,10631,10631,10598,10598,12711,12712,8518,8518,10631,10631,10630,10631,10599,21195,23308,25454,21163,25486,23308,21228,21260,27599,31825,35986,25421,21228,18952,37741,38001,44471,29615,31727,27468,14856,14824,12711,12711,12711,21163,23341,27534,29679,36019,36051,38099,38099,38132,33873,25454,23308,23308,23341,23341,25421,23341,23341,16904,31760,46584,48697,29647,12711,25421,44471,44536,36051,23308,19115,36019,38164,36019,33906,29680,16969,19050,16969,16969,73},
{55003,55003,52923,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,50842,50842,50810,50810,48762,48730,48730,48730,48730,48730,48698,48697,48697,48697,48697,48697,48697,48697,46649,46617,46649,46617,46617,46617,46617,46617,46585,44536,44536,44536,46585,46617,46617,46617,46649,38197,23406,29745,21261,27632,29713,25454,23341,31826,27600,27600,21229,19115,21229,19116,21261,21228,27567,25455,19115,17035,17035,17003,21229,23374,23341,25487,21228,17003,17035,14922,17035,16970,19148,23341,14890,17003,17003,21229,42390,31825,23374,23374,23374,23374,21261,19148,19213,19213,17068,17036,19148,19148,17035,14987,17068,17067,14954,12842,14922,14922,14922,14922,14922,12842,14922,14954,14987,14922,12841,14857,14922,17002,17035,14857,14922,10663,17002,14889,12809,12776,10664,12744,14857,12777,10696,10663,12744,12777,12776,8550,10630,12711,10663,10631,10631,10663,10663,10631,10631,12712,12744,12744,10631,10631,10631,10631,10631,10663,10631,10598,10599,12679,10631,10598,10631,10663,10631,10598,10630,10630,19050,27502,25453,16969,29647,25421,21228,21228,27567,31825,33906,21163,21195,25324,37806,40179,44471,38131,38131,27469,16937,14824,12679,12678,12711,21163,27502,35986,31825,29647,29647,29647,29615,27567,31792,27567,27502,27534,27534,29647,23341,23341,23373,14824,31727,40244,42358,42390,29745,12744,19083,40277,31793,23341,23341,38197,38164,33938,36019,25421,16970,16937,16969,16937,62},
{55004,54971,54971,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,50843,50842,50842,50810,50810,50810,48762,48730,48730,48730,48698,48698,48697,48697,48697,48697,48698,48697,48697,48697,46649,46649,46617,46649,46617,46617,46617,46585,46584,44536,44536,46584,46617,46617,46649,48729,40245,21293,29713,19115,27567,25454,19148,19148,29713,27600,27600,21229,19180,23406,17035,19116,21228,27567,25487,19116,17067,21293,17003,21229,23342,23374,25519,21261,17003,21228,16970,19115,17003,21228,23374,14922,17003,17003,23309,42358,29745,23374,23373,23374,23373,21261,19148,19213,21294,17068,17068,19181,19148,17035,17035,17067,17068,14954,14922,14922,14922,14922,14922,14954,14922,14954,14987,14987,12874,12809,14857,17002,17035,19212,17100,14987,17067,14954,14857,14889,12776,12712,12776,14857,12809,10664,10664,12744,12776,10631,10663,12776,12744,10631,10631,10598,10631,10631,10631,10631,10663,12744,10663,10599,10631,10631,10598,10598,10631,10599,10598,10598,10631,10599,10631,10663,10663,10599,10598,10598,10663,19082,29614,25454,21195,29647,27567,23341,21260,27567,29712,23309,23309,19050,12711,21163,36018,46551,36018,36018,27534,21195,21163,16937,14824,16937,25389,33841,31760,33873,19082,10565,10565,10566,10565,27566,19114,10598,10630,10598,19082,21228,23373,23373,14792,31694,33839,40211,33873,36019,36051,16969,29679,35986,21228,25486,38197,38132,33906,36019,21163,19050,19050,16969,16969,74},
{55004,55003,55003,52955,52955,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,50842,50810,50810,50810,50810,48762,48730,48730,48730,48698,48697,48697,48697,48697,48697,48697,48698,48697,48697,46649,46649,46649,46649,46649,46649,46617,46585,46585,46584,44536,46585,46617,46649,46649,48697,33939,21228,27632,21228,25454,27600,21228,23341,29745,25487,21228,21196,21196,21261,19115,19115,19148,25487,17067,17035,19083,17067,17035,17035,17035,23374,21228,17035,19083,19116,17035,17035,17035,21228,23341,17003,17003,17003,23342,42358,29745,23374,23374,23374,25422,21261,19148,19181,19213,19148,19148,19180,19148,17035,17035,17067,17067,14954,14922,14954,14922,14954,14955,14954,14955,14954,14954,14986,14922,14889,14890,17035,17035,19148,19212,19180,19212,17035,12809,12776,12744,12776,12777,14889,12809,12776,12776,14857,14889,12776,12809,14922,14889,12776,12712,12711,12744,12744,12711,12712,12744,12776,12744,12744,12777,12776,12712,12744,12776,12776,12776,12744,14857,12776,12744,12776,12776,12744,10663,12744,14954,21196,29647,27534,29615,27534,29680,23373,23308,27567,29745,16937,23276,21163,8453,16904,38098,46551,40244,31793,33873,36019,36051,38131,38164,33906,38099,38099,29647,33938,21195,8485,8485,8485,8485,27534,21195,10598,12678,10598,19082,21228,23373,25454,14824,27566,29614,35985,40211,33872,36018,38098,38066,29680,19114,31793,40277,38197,31793,35986,21195,21196,21195,21163,21195,87},
{55003,55003,55003,52955,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,50842,50810,50810,50810,50810,48762,48730,48730,48730,48730,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,46649,46649,46649,46649,46617,46617,46617,46585,46584,46584,46584,46617,46617,46617,46617,27632,21228,27600,21261,23406,25519,19148,19115,29745,25487,23374,19148,19148,27600,19180,17035,19115,25487,14922,17002,17035,14922,17002,17002,14890,23374,21293,19116,17035,21261,19083,17035,17002,19148,23341,14857,25455,19148,23341,42358,29745,23373,23373,23373,23374,21261,17068,19213,19181,17100,17068,21293,21294,17068,17003,19181,19148,17035,14954,14955,14955,14955,14987,19180,17100,14987,14954,17035,14954,14954,17035,19148,17099,17035,14954,14954,14922,14922,14922,14922,14922,17002,19116,19213,19181,17035,14922,14954,14954,14890,17035,19180,19180,17067,17067,19180,19148,17002,17002,19115,19115,17067,17003,17035,19148,17035,17035,19115,19115,17067,19148,19180,21261,19148,14954,14987,17067,14954,14889,14922,12841,14889,27566,27567,33873,23308,29712,23341,23341,27567,29713,23341,21228,19082,8485,16904,35986,46551,46584,36051,27502,19082,21195,21195,19050,25421,25421,23340,25453,33873,21195,8485,10533,8485,8485,25421,21195,10598,12678,10598,19050,23308,25422,27567,14824,23308,25453,19049,40146,42292,35953,40179,42325,25421,21163,36051,38197,38132,31825,29647,25454,23341,23276,21228,23276,80},
{55003,55003,55003,55003,54971,55004,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50843,50842,50842,50810,50810,50810,48762,48762,48730,48730,48730,48730,48697,48697,48697,48697,48697,48697,48697,48697,48697,46649,46649,46649,46617,46617,46617,46617,46617,46617,46616,46616,46617,46649,46584,44504,25519,19180,27600,23341,21261,25519,19115,16970,31858,25487,19116,19180,19115,19180,19148,17035,17035,25519,17002,17003,17035,14922,17035,17035,14922,25487,19148,17003,17035,17035,17035,17035,14922,19148,23374,14890,36019,25455,27567,42423,36051,25519,27567,27567,27600,23406,21293,21326,21326,21261,21294,21326,21326,19181,19148,19213,19180,17100,17068,17068,17068,17067,17100,19213,19180,17100,17035,17067,17068,17067,19148,19212,19212,19180,17067,17067,17067,17067,17067,17067,17067,19116,19148,19148,19180,19180,19148,19148,19148,17100,19115,17067,17099,17067,17067,19148,19148,19115,19147,19148,19148,19148,19148,17035,17035,17002,17002,17035,17034,14954,14954,14954,14954,14954,14954,14954,14922,14889,14889,12809,14922,17002,25421,27534,29647,21228,27632,21260,23373,27567,31793,23374,21260,21196,8485,14824,36018,48697,42358,36019,27502,19114,23470,23438,10631,21195,25453,23308,27534,29712,31793,31793,31792,31792,31793,29712,31760,31760,31792,31760,31825,23308,25421,25486,19050,21195,25453,19017,33840,42357,42325,42357,38066,23276,25389,38164,38197,36019,33938,16937,12744,12679,8485,10598,10598,42},
{55003,55003,55003,54971,54971,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50843,50842,50842,50810,50810,50810,48762,48762,48762,48730,48730,48730,48697,48697,48697,48697,48697,48697,48697,48697,48697,46649,48697,46649,46617,46617,46617,46617,46617,46617,46617,46617,46617,46649,44503,42390,29713,19115,25519,21261,23341,27599,19148,21228,31826,23406,17067,19116,19115,19148,19148,19116,19148,25487,17035,17035,17035,17003,17035,17003,17003,25486,19148,17003,17035,17035,17035,17035,17035,21228,23374,17002,31826,19148,23341,46617,38197,29680,27600,27632,27632,23439,19213,21326,21294,21294,21294,21294,21294,17068,17003,17035,17067,17067,17035,17035,17035,17067,17067,17067,17035,17068,14987,14987,17035,17068,17100,17067,17067,17099,17067,17067,17067,17035,17002,14954,17002,17067,17067,17035,17067,19180,19180,19148,17067,17067,17035,17035,17100,14986,14922,14922,17002,17067,17067,17035,14954,17035,17002,14889,14922,14922,17002,14922,14922,17035,14954,14889,14922,14954,14954,14954,12874,12809,12809,12776,23341,19082,23308,27534,21195,21163,29712,23341,25454,25454,33939,29745,25454,19082,8518,14791,35986,46584,35986,36051,27567,19147,27664,25583,10598,21163,31792,23275,21227,31825,25421,16969,17002,17002,16969,25421,23308,14824,14889,14824,19114,23341,25453,27631,25421,23276,25388,23308,25388,42324,42325,42325,31760,21163,27567,38197,36084,33906,38100,23308,21195,19050,16969,16969,16969,63},
{55003,55003,55003,55003,54971,54971,52923,52923,54971,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50843,50842,50842,50810,50810,50810,50810,50778,48730,48730,48730,48730,48729,48697,48697,48697,48697,48697,48697,48697,48697,48697,46649,46649,46649,46617,46617,46617,46617,46617,46585,46617,46617,46649,46616,36052,27567,19115,21228,19148,21228,21261,19116,17003,29777,23406,19116,19115,17067,19180,19115,19115,19148,25519,14922,17003,17035,14922,17003,17002,14890,23406,19115,17003,19083,17003,17035,17035,14890,19148,21293,14889,31793,23407,27535,46584,38197,29680,27567,27632,27632,25487,19148,21294,21294,19148,19148,19213,19213,17035,14922,17035,17035,14955,14922,14922,14922,14922,14889,12744,10696,14889,12841,12874,14922,14954,14922,12809,12744,14922,14954,14987,14954,14954,14889,12744,12776,14922,17067,21261,19180,19147,12809,12744,14889,14922,17002,19148,19148,14922,10631,10599,12744,17002,17067,12744,12744,14922,12776,12711,12776,14889,14889,12712,12776,14922,14889,10663,12744,14921,12874,14954,12874,12809,12776,12776,21261,17002,23276,25454,19050,23341,29680,23341,25486,25454,33939,31826,27567,16969,10566,12711,38066,38099,29646,33840,29648,21195,23405,23373,19050,25389,29646,21162,23243,31825,23308,8485,8517,8485,8452,23276,23276,8485,8452,6372,14824,23373,25454,27599,19082,25389,25356,23275,21194,38131,42325,40212,25389,19082,31825,40277,38132,33906,36018,23308,21228,19050,17002,17002,19082,59},
{55003,55003,55003,55003,55003,54971,54971,52923,54971,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50843,50843,50811,50810,50810,50810,50810,48730,48730,48730,48730,48698,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,46649,46649,46649,46649,46617,46617,46617,46584,46616,46617,46649,46617,25454,21228,21228,25487,21229,21229,23374,19116,17003,29713,25486,23342,19116,19180,27632,19180,21229,21261,27600,17002,17035,19115,16970,17035,17035,16970,25487,21228,19148,19116,19116,19116,17035,17002,21228,25454,17003,23406,21261,23374,46616,38197,29680,27599,27600,27632,23406,19148,21261,21261,19148,17068,19213,19213,17035,14889,17035,17035,14955,12842,12874,12874,14922,12777,12744,10696,12841,12841,12874,14922,14987,12841,12776,12809,14954,14954,14954,14954,17035,14921,12809,12777,14954,17035,19180,19148,17035,14889,14889,14889,14922,17002,17067,17067,17002,12776,12776,12809,17002,14922,12809,14857,17035,14922,12776,12809,14922,14857,12776,12809,14889,12777,12776,12776,14889,12841,14954,14955,14922,12841,12809,21260,19050,23308,25454,21196,23308,27567,21228,23373,23341,36051,25454,14856,12744,10598,12711,38098,38098,29549,35953,31760,27567,29647,29647,29679,29679,25421,16904,23308,31792,23309,8485,8485,8485,8420,21195,23341,8452,8452,6372,14824,25421,25454,27567,16969,23308,27502,23308,27501,31759,40211,35985,25389,21228,40277,40277,38132,36018,31793,23308,23308,19082,19050,17002,19050,87},
{55004,55003,55003,55003,55003,55003,54971,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,50843,50843,50811,50810,50810,50810,50810,48730,48730,48730,48730,48730,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,46649,46649,46617,46617,46617,46617,46617,46617,46617,48697,42423,23341,23341,19148,27600,21261,21261,21261,19115,21261,25487,27567,23406,23341,23406,23374,23374,23374,23374,23406,23341,23341,23342,23341,21261,23341,21261,23341,21293,21261,21261,21261,21228,21261,21261,21228,21260,21228,36019,23374,25487,46617,38197,29712,27600,27632,29680,23407,19181,21261,19245,19181,19181,19181,19213,19148,17003,17035,17035,17035,14954,14955,14955,17035,17067,17067,17035,17067,17067,14987,17035,17100,17100,19212,19213,17067,17067,17067,17067,17067,17067,19116,17067,19147,19148,17067,17067,17035,17035,19148,17067,14954,17002,17035,17035,17035,17035,17035,14954,17035,17035,17035,19115,19115,19115,17002,14922,17003,17003,17035,14954,17003,14922,14922,14954,14954,14954,14954,14987,14890,14857,14922,23341,14857,23340,27534,23276,21228,25454,21195,23373,23308,36019,23308,19050,19083,16970,21163,42324,38066,23242,33808,29647,14824,10630,10598,10598,16969,23341,16937,23276,31825,25421,12743,14824,14824,14824,23308,27502,14824,14856,14824,19082,25421,25486,29648,19082,21130,31759,27501,29646,29614,38065,29614,21195,27534,42390,40309,36051,36019,27566,21228,21195,19050,19082,19082,16969,82},
{55004,55004,55004,55003,55003,55003,55003,55003,52923,52955,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50843,50843,50842,50810,50810,50810,48730,48730,48730,48730,48730,48730,48730,48697,48697,48730,48730,48730,48730,48730,48697,48697,48697,48697,46649,46649,46649,46649,46617,46617,46649,48698,44504,40245,25487,17035,25454,19148,19148,19148,19148,19148,23406,17035,19083,17002,17035,17035,17002,17002,17002,17002,14889,14889,14922,14857,14857,14889,14890,14922,14889,14857,14857,14857,14857,14857,14825,14824,14857,12808,23309,21293,25422,46584,38165,27632,27599,27600,27632,25487,17068,21261,21261,19181,17068,19213,21261,17067,14889,17035,17035,14987,14922,14954,14955,17035,12809,12744,12776,16970,14922,14954,14954,14987,12841,12809,12809,14954,14954,14954,14954,14954,17002,19148,19147,17002,17035,19180,19180,14954,12777,12777,12777,14889,12744,12776,14889,14889,12744,10663,12776,14922,12776,12776,14857,17002,12776,10663,12744,14889,12776,12744,12776,14954,12744,10663,12744,14922,12841,14922,14954,12809,10664,17002,27600,14857,23308,25454,23276,23308,25421,21195,25454,16937,27599,14857,8453,12679,10598,10566,31727,33839,21097,31727,29680,16970,10598,8485,10565,19082,21227,16937,25389,31760,38066,40179,40212,42292,40244,33873,35986,42292,40244,40244,42325,27567,27599,25486,19083,19050,33807,33840,27468,31759,33872,25388,21228,33906,42358,40277,36019,36019,25454,23341,23308,19115,19114,19050,16969,121},
{55004,55004,55003,55003,55003,55003,55003,55003,54971,52955,54971,52923,52923,52923,52923,52923,52923,52891,52891,52891,50843,50843,50842,50810,50810,50810,50810,48762,48730,48730,48697,48697,46617,46617,46617,46584,46584,46616,46584,46584,46584,46584,44536,44504,44504,44504,44471,44471,44471,42390,42391,44471,42390,40278,40310,29713,25487,27632,25487,25487,25519,27600,21228,19083,10663,12744,12744,12744,14857,12744,12776,12776,12712,10663,12712,10664,10663,10663,12712,14857,12744,10631,10663,10631,12711,12711,12711,12712,12712,12711,12808,29680,23374,25487,44536,38165,27632,25519,27599,27600,23406,17003,21261,21294,19181,17035,19213,19213,17035,12777,17035,17068,17035,12842,14922,14954,14954,12744,10631,10631,14889,12841,14922,12874,14987,12841,12776,12809,14922,14954,14954,12874,14954,14954,19148,17067,17002,14954,19180,19180,17002,12809,12777,12776,14889,12744,10663,10663,14889,12744,12712,12744,14922,12776,12777,14857,14954,12776,12744,12776,14889,12776,10696,12744,14857,12744,12711,10664,12841,12841,12874,14954,12841,10696,19148,27600,14857,23276,25453,29615,33906,44438,38132,31760,10630,25422,14856,10565,12711,10631,10566,31726,27500,21096,31727,29647,14857,10598,8485,10598,23243,17001,12743,29647,48696,44438,35953,35953,35953,35986,46551,44438,35954,35953,35953,35954,40212,27599,19115,19050,21195,31694,35920,27468,33839,31760,23308,23340,40277,40277,38197,36019,33873,23308,23308,23308,21195,19115,21163,21163,103},
{55004,55004,55004,55004,55004,55003,55003,55003,55003,55004,54971,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50842,50810,50810,50810,50810,48730,48730,48697,48697,33938,31761,29713,29680,29712,29680,29680,29680,27600,27600,29680,29680,29648,29648,27567,29647,27567,27567,27567,27535,27534,27567,25486,25454,25486,25487,27567,25487,25454,25487,25454,23374,19083,14889,14857,14857,14857,12777,14857,12776,14857,14857,12776,12744,12776,12744,12744,12744,12744,12744,12744,12744,12744,12711,12744,12744,12711,12711,12744,12744,10663,25454,23374,25519,46617,38197,27632,27632,27632,27632,25487,19148,19213,21294,19213,19148,19181,19213,19148,17035,19115,17068,17068,14987,14954,14987,17067,17035,17035,14922,17035,17035,17035,17035,17100,17099,17068,17100,17067,17067,17067,14987,17067,17067,17100,19148,17067,17035,19148,19148,17067,17067,17067,17067,17067,17035,17035,17035,17035,17034,17002,17035,17035,17035,17067,17067,17100,17067,17035,17002,17003,17067,17035,17035,17002,17002,14954,14954,14954,14954,14954,12874,12841,12809,12841,19115,21163,23276,27534,27534,44503,46551,40212,19050,10565,23276,21195,10565,10598,10630,10565,29646,23242,16903,29679,29680,27567,29647,29647,27566,21163,21163,16969,40212,55003,27534,19049,21162,21162,25356,50744,29614,21162,21195,21227,25356,42357,25454,16969,19050,19049,31759,33872,31727,33840,25453,21195,27535,42390,40277,36083,36084,31728,23276,23308,23308,23276,21195,21163,25421,104},
{55004,55004,55004,55004,55004,55003,55003,55003,52923,52891,52891,50842,50810,50810,50778,50778,48729,48729,48697,48697,48697,48697,48665,48665,46616,46584,46552,44471,42358,36051,21261,21261,21293,17035,14889,14890,14890,14889,14889,14857,14857,14857,14857,14889,14857,14857,14890,14889,14889,14890,14889,14889,14889,14857,14857,14857,14857,14857,12777,12776,12776,12776,12744,12744,12712,10631,10663,10631,10631,10663,10631,10631,10663,10631,10631,10663,10631,10663,10631,10631,10631,10631,10631,10631,10631,10631,10631,10631,10631,10631,10598,31761,36116,38165,44536,38165,29680,27600,27600,27632,25487,19181,19213,21293,19213,17100,19181,19213,17068,17035,17067,17067,17067,14954,14955,14987,17035,14889,14889,14889,14922,14922,14954,14955,17035,14922,14889,14922,17035,14987,14987,14954,14954,17003,19148,17067,14986,14922,17035,17067,17035,14890,12809,12809,14922,12808,12809,12809,14922,12776,12712,12744,14889,12809,12809,12809,14954,12776,12776,14857,14922,14857,12809,12809,16970,14889,12776,14954,14922,14889,12841,12874,12809,12744,12776,19083,16905,21195,27534,31792,48697,42358,40212,16905,10566,23308,21196,8485,12678,12679,10565,29614,23210,16871,27567,29680,17002,19050,16937,16969,16969,23275,21195,50777,50745,31760,33873,31759,29614,42292,48664,27501,27501,29582,27534,42292,48696,25421,14824,19050,19082,33839,33839,33839,33872,23276,23308,38132,40310,40277,33938,36051,25454,25421,25453,23341,21227,23276,16969,25454,114},
{55004,55004,55004,55004,55004,55003,55003,55003,55003,54971,55003,54971,55003,54971,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,50843,50843,50843,50843,50843,36051,19115,21229,21261,17003,12744,12777,12809,12777,14857,12777,12776,12777,12777,12777,12777,12777,14857,14857,12777,14857,14857,14857,14857,12777,12777,14857,12776,12776,12777,12744,12777,12776,12744,12776,12744,12744,12776,12744,12744,12744,12744,12744,12776,12712,12744,12744,12712,12744,12712,12712,12744,12711,12744,12744,10664,12712,12712,10663,12744,12712,10664,17002,14922,21260,46584,38197,29680,27567,27599,27600,23439,17067,19213,21294,19180,14987,19180,19181,17035,12809,17035,17035,17003,14890,14922,14922,14922,12744,10631,10664,12809,12809,12841,12842,14954,12777,10663,10696,14922,14954,14955,14954,14922,14890,17067,17067,17035,12776,10696,12777,14954,12776,12744,12776,14922,12744,10663,12744,14889,10663,10631,12776,14857,12776,12744,12744,14890,10663,12744,14889,17002,12744,10663,10663,12776,12744,10695,12809,12841,12841,12874,14954,12809,10696,14889,19115,14857,21162,27502,35986,48697,40212,38132,16937,10598,23341,29647,8485,10598,10630,8485,23308,16904,12678,27502,29680,19050,19082,8452,19082,19082,21195,29679,57084,40212,23308,25421,25389,23276,44405,40179,23275,25420,25453,27501,44405,44405,21162,16969,19082,19049,33807,33807,35985,25486,21195,25454,42391,40278,38197,33938,33906,27567,27567,27534,27534,25454,23341,23308,27534,126},
{55004,55004,55004,55004,55004,55004,55003,55003,55003,55003,54971,54971,52923,52923,52923,52923,52891,52923,52923,52891,52891,50843,50842,50810,50810,50810,50810,50810,50810,35987,19115,21293,21294,17067,12777,14890,14890,14858,14890,14858,14890,14890,14890,14890,14922,14890,14922,14890,14890,16970,14890,14922,16970,14890,14890,14922,14890,14890,14890,14890,14890,14889,14857,14889,14857,14857,14890,14857,14857,14889,14889,14857,14889,14857,14889,14857,12809,14889,14889,14857,14889,14889,14857,14890,14857,14857,14922,14857,14889,14889,12776,21261,33939,38165,44569,38230,29745,27632,27632,27600,23439,17068,19181,19213,19148,19148,19213,19213,19116,14954,17067,17067,17035,17003,17035,17035,17035,14922,14889,14890,17002,14955,14954,14987,14987,17002,14954,17035,17035,17035,14987,14987,17035,17035,17099,17100,17067,17035,19148,17100,17067,17034,14954,17034,17035,14954,14922,17003,17003,14954,17002,17003,17035,17003,17035,17067,17035,14922,17002,17067,17035,17035,17035,17002,17035,17035,17035,14922,14954,14954,14922,14954,12841,12809,14890,19115,14824,19082,25421,38164,48729,40245,40212,16905,19050,27534,25421,16937,21163,23276,21163,33873,29679,14824,25421,31793,19082,19082,8452,16969,21163,25453,40212,55003,36018,31759,31759,29647,33840,50777,33840,27501,29614,31759,35985,50777,31727,25421,12743,19082,16937,31759,33840,35953,25421,21163,33873,42390,40277,38132,35986,19050,16937,14856,14856,14824,12743,14856,29679,23276,107},
{55036,55004,55004,55004,55004,55004,55003,55003,55003,55003,54971,54971,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,50842,50842,50810,50810,50810,36084,31858,29778,21294,19148,19148,19181,17035,19116,19181,17035,19181,19149,17036,19181,17068,17068,19181,17068,17068,19181,17068,19148,19180,17067,19181,19180,17035,19180,19148,17035,21261,19116,17067,19148,17035,19148,19148,17003,19116,17068,17035,19148,19148,17035,19148,17035,17035,19148,17003,17035,19148,17002,17067,17067,17002,19116,19116,17035,19116,17035,17035,19148,17002,25454,25487,29712,46617,38165,27632,27632,27632,27632,25487,19180,19213,21293,19213,19180,19181,19181,19148,17035,19148,19116,17067,17035,19116,17068,17035,14954,14922,14922,14955,14987,14987,17035,14987,14922,14954,17002,17035,14987,17067,14987,14987,14954,17067,17067,17035,17002,19180,19180,17067,14954,14922,14954,14954,14889,14889,14922,14954,14889,12809,14889,17035,14890,14889,14922,17035,14889,12777,12809,14922,14922,14889,14889,17003,14890,14889,14889,14954,14922,12874,14954,12809,10696,12776,17035,14824,16937,25389,44471,50810,46616,46551,16937,19082,29647,31792,19083,21131,16905,12711,27502,16937,10565,25421,31760,21228,21228,19050,14856,21195,23340,46551,50777,27501,27566,27501,25421,31760,48599,27468,27501,29614,31726,38098,46551,23307,29614,14857,21196,14824,31727,35985,31792,23308,23276,40310,40277,38164,36051,36019,23341,23308,23308,23308,21196,21195,21195,27534,23341,108},
{55036,55036,55004,55004,55004,55003,55003,55003,55003,55003,55003,54971,52923,52923,52923,52923,52923,52891,52891,52891,52891,50843,50842,50842,50810,50810,50810,29745,31923,34036,23407,19213,19181,19213,19181,21294,21262,21294,19246,21262,21294,21294,21293,21294,21294,21294,21294,21326,21294,21326,21326,21293,21294,21293,21294,21294,19213,21293,21294,19213,21293,21293,19180,21293,21293,21293,21294,21261,21261,21293,21261,21326,21294,21261,23374,21293,21261,23374,21293,21261,21293,21261,21325,23374,21293,23374,23374,21261,23373,23374,21293,14922,17002,23341,46584,36084,27632,27600,27632,27632,25487,14955,19213,19213,19148,14922,17067,19181,17035,14890,17067,17068,17003,14922,19180,19180,17035,12744,10631,10663,12841,12841,12842,14922,14954,12776,12744,12776,14922,12874,14987,14955,14922,14889,14954,17035,14922,14954,19180,19180,14922,12777,10696,12777,14922,12744,12744,12776,14922,10695,10663,10696,14922,12776,12744,12777,14922,10663,10631,12744,14889,12744,10663,10663,14889,12776,12776,12776,14857,12809,14922,14954,12776,10695,12776,14889,12776,16937,27502,27502,25421,25389,16969,14856,25421,29680,25389,16904,23276,27534,25389,25389,16905,8485,23308,31793,25421,27502,27534,25388,25453,27501,52922,44406,25388,27469,25389,23275,46518,38099,21162,23275,23307,23307,48631,35953,27501,27534,16937,21195,16904,33808,36018,25453,21163,29680,42391,40278,38164,36083,29712,25454,23341,23308,23308,23308,21163,25454,23308,27567,114},
{57084,57084,55004,55004,55004,55004,55003,55003,55003,55003,55003,54971,52923,52923,52923,52923,52923,52891,52891,52891,52891,50843,50842,50842,50843,50810,50810,42456,40375,42456,40375,38230,38263,38295,36182,40343,38263,36150,38262,36182,36150,38263,34069,36182,38263,36150,36150,38230,34069,36150,36182,25487,23406,19180,21229,23406,19180,21260,23406,19148,21293,21293,19116,23406,19213,19148,23406,19180,19148,23438,19148,21293,23406,19148,23374,23374,19148,25487,21293,21228,23438,19180,21228,25454,19115,21261,23406,17067,23374,21293,21228,29713,25487,29713,46617,40278,29712,27632,27632,27632,23406,14955,19181,19213,19148,17003,17035,19180,19148,17035,19181,19181,17035,17003,19180,19181,17035,14889,14922,14922,14954,14922,14954,14954,14987,14922,14889,14890,14955,14954,14987,14987,14954,14890,14890,14922,14954,14954,17100,19148,17035,14922,14922,14922,14954,14921,14889,14922,17002,14922,14889,14922,17067,14954,14922,14954,17035,14889,14922,14922,14922,14889,14889,14889,14954,14922,17002,17002,14922,14889,14922,14954,12809,12808,12776,19147,16970,16937,27534,23276,19050,16937,12711,25453,36019,23308,16937,14856,23308,40212,27534,23308,19050,10598,25389,33873,16937,10566,10566,10598,21195,35986,55035,35954,27534,31727,31727,31759,48696,33873,29646,31727,31760,33873,48664,31695,21162,23308,21163,21195,16969,33840,31792,23308,21227,38131,40310,40277,38131,36019,27534,25389,23308,23308,23276,23276,19082,27534,23341,29712,116},
{57084,57084,55036,55004,55004,55004,55003,55003,55003,55003,55003,55003,52955,52923,52923,52923,52923,52923,52891,52891,52891,50843,50842,50843,50843,50810,50811,46682,44601,42521,44601,40408,40408,40408,38263,40376,38263,34069,38263,36182,34069,36214,34069,34069,36182,34069,34069,36150,31956,34069,31891,17035,17035,14954,14890,17067,14889,14922,17067,12809,14922,17035,12809,17003,17002,14889,17067,14922,14890,19148,14922,17002,21229,14890,17067,19116,16970,19181,17035,14890,17067,17002,17002,19116,14922,17002,19148,17002,19148,19147,21261,31826,23406,25455,46617,40278,29713,27632,27632,27632,23406,19148,19148,19148,19181,19181,19180,19180,19213,19181,21261,19181,17100,17067,17067,17067,17067,17035,17067,17067,17100,17067,14987,17067,17067,17035,17067,17067,17100,17067,14987,14987,14987,17035,17035,17002,17035,17067,19148,19148,17035,14954,17034,17002,17035,14954,17002,17035,17067,17035,17035,17002,19115,17002,14922,14954,17067,14954,14922,17002,17002,14857,14857,14857,14954,14922,14954,14954,14921,12809,12841,14922,12809,12776,12809,12841,14889,14824,25421,33905,27534,14824,12743,29712,31761,12711,19082,14824,19050,40277,31792,21195,12743,6372,23340,33906,16969,12711,10598,14792,19114,46551,50777,27501,21195,21195,21195,33872,48631,25421,21195,21195,21162,38066,38099,16904,14759,21195,21163,21195,19050,29614,27567,23341,25454,42390,40277,38164,36051,33873,25421,25421,23341,23308,23276,21163,23340,23308,25421,29679,111},
{57084,57084,55036,55004,55004,55003,55003,55003,55003,55003,55003,55003,52955,52923,52923,52923,52923,52923,52923,52891,52891,50843,50843,50843,50843,50842,50810,48730,48730,44536,42455,36084,36117,40310,38230,38230,38230,36117,36117,36117,36149,36149,34036,31923,36149,38230,38230,38230,38230,36117,29810,25520,21293,21261,19181,19148,19148,19116,17035,17035,17035,17035,17035,17035,17035,17035,17067,19115,19115,19148,17067,19148,19148,19116,19148,19148,19116,19148,19116,19116,19116,19116,19148,19148,19148,19116,19116,19115,19148,19148,17035,36084,46616,31826,44536,36084,29680,27600,27600,27632,25487,17003,19148,17100,17100,17035,19148,19181,19180,14954,14889,14889,14954,14922,17067,17067,17035,14890,19180,19148,17035,12874,14954,14987,14987,12776,12776,12809,14954,14954,15019,14954,14954,12809,12776,12776,14922,17002,19213,19213,14954,12809,12809,12841,14922,12776,10663,12809,14922,12776,12777,12776,14954,12744,10663,12744,17003,12776,10663,14889,14889,10663,10631,10663,14922,12808,12744,12809,12776,12744,12841,14922,12776,12744,12776,12776,14889,14824,25421,25454,16937,12678,14889,38132,27502,12711,21163,19082,23340,36019,29647,23308,17002,14856,21195,33938,16969,10598,10598,16937,23340,50809,46551,29646,31759,31759,31760,44438,44405,31760,33840,33840,33873,46551,31760,31727,21195,21195,19017,19050,16937,27534,25421,23308,36051,42358,40277,36051,38131,27567,25421,25454,25453,23308,21228,19082,25453,27534,25454,25453,101},
{57084,57084,55004,55004,55003,55003,55003,55003,55003,55003,55004,55004,52955,52955,52923,52923,52923,52923,52923,52891,52891,52891,50843,50842,50842,50842,50842,50810,52891,52890,42325,21261,23373,36051,33971,36051,36084,31858,33939,36051,33938,33971,31826,29713,33971,38197,38197,38165,38197,36117,27665,27665,27664,25551,21293,19180,17067,17035,17067,17035,21229,17035,17035,19148,17035,19115,19115,17067,19116,19148,17067,19148,19116,17035,19116,19116,17035,19116,19116,17035,19148,17035,19116,19148,19115,17067,19115,17035,19148,17067,17067,40245,48697,31826,44504,38197,29745,27600,27599,27632,23406,17003,19181,19181,19181,17035,19181,21293,19148,14954,14889,17002,14954,14922,17067,19148,17035,14922,19180,19181,17067,14954,17067,17067,14987,12809,12809,14889,14987,14987,15019,14987,14954,14922,14890,14890,14954,17035,19180,19180,14954,14922,17035,17035,14922,12808,12776,14857,17035,14889,14889,14922,17035,14889,14857,14857,17035,14857,14857,14857,14922,12809,12777,12776,17002,14922,14922,14954,12841,12809,14889,14922,12777,12776,12809,12776,14922,12743,25421,21195,12711,12678,21195,40245,21163,12743,21163,21228,23308,23340,27534,23309,14857,12711,21228,31825,31825,35986,35986,27566,31792,52922,33840,21162,21194,19082,23275,48631,27566,25453,19082,21130,25388,46551,27501,42325,25421,21130,16937,21163,19082,27534,23308,25453,42390,40277,40245,33938,36019,27567,27534,27534,27502,25421,23308,19082,23308,31793,27567,19050,93},
{57084,57084,55036,55004,55004,55003,55003,55003,55003,55003,55003,55003,55003,52955,52923,52923,52923,52923,52923,52891,52891,52891,50843,50843,50842,50842,50842,50842,50843,50843,44438,23341,21293,33971,36052,36116,38197,33971,33939,38164,42357,42325,31858,29713,33939,36084,36052,36084,38197,36117,27665,25584,27665,27665,25552,21294,17068,17067,17035,17067,17035,17003,17035,17035,17035,17002,17035,17003,17003,17035,17003,17003,17035,17035,17035,17003,17003,17035,17003,17035,17035,17002,17035,17035,17003,17003,17035,17002,17035,17035,19115,42358,50810,40278,44536,38197,29713,27632,27632,27632,23406,17068,19148,19148,19181,19181,21294,21294,19245,19245,19213,19213,19148,17067,19148,19148,17068,17067,17068,17100,19181,17132,17100,17100,17099,17067,17067,17100,19213,19245,17132,17100,17100,17068,17067,17067,19148,19180,19148,19148,19213,17100,17100,17099,17067,17035,17035,17067,17099,19115,17035,19147,19180,17099,17035,17067,19115,17035,17035,17035,17067,17035,17002,17002,17035,17034,17002,14954,14954,14922,14922,14954,12841,12809,12809,12776,12776,12743,25421,23308,12711,12711,25454,38132,16937,19050,21195,21163,21195,23276,21195,16970,16937,12711,31760,42358,42325,40244,40244,38099,40245,48697,31727,31727,31760,31760,35986,46519,27533,29614,29647,29679,40179,42325,29647,27534,16936,19049,16904,19050,21195,23308,21195,38099,42358,40245,38100,33906,23340,23340,23308,23276,21195,21163,21163,25421,21195,25454,27566,19082,99},
{57084,57084,55036,55004,55003,55003,55003,55003,55003,55003,55003,55003,52955,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,50843,50842,50842,50842,50842,50810,44504,31793,29680,33938,38197,38164,38164,38197,38165,40212,46518,42358,36052,36084,36084,38197,40278,38165,38229,36149,29745,27632,27697,27697,31858,29810,27665,23374,21261,23374,21229,19148,19116,19116,19181,19148,19148,19116,19148,19148,19180,19116,19148,19148,19148,21196,19116,19148,21228,19148,19180,19148,21229,21261,19180,19181,21261,19148,21228,21261,19180,25454,25455,29713,46617,40310,29745,27632,27664,29713,25520,21326,23471,23439,21326,21326,23407,23407,21326,21326,21358,21326,19213,19213,21326,21326,19213,19148,21326,19277,19245,17133,17165,17165,19180,17100,17100,17100,19213,19245,19245,19245,19180,19180,21293,19213,19180,21293,23406,21326,19213,19212,19245,17165,19180,19180,21261,21293,19212,21260,21261,21293,21261,19148,19148,21228,21261,19180,21260,21261,19115,17035,19148,19180,17067,17067,19180,19148,17035,14954,14987,14954,12809,12776,12776,10696,8518,10566,23308,19082,12743,12678,29712,29680,12711,16905,25389,25453,19082,12743,21163,12743,14856,14824,44471,48632,21163,19050,19082,19050,27502,38099,19017,21130,21130,19050,29647,31760,16937,19050,19050,19082,33905,27501,21162,23210,16936,23242,16904,21195,21195,21195,25421,44471,42358,38164,38131,33873,21195,23340,21195,21163,21195,21163,21227,25453,23308,25453,27534,12711,85},
{57084,57084,57084,55004,55004,55004,55003,55003,55003,55003,55003,55003,52955,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,50843,52891,52891,50842,50810,50842,50842,48729,40277,38164,38165,42423,44504,40278,40310,44471,38132,40244,40245,36084,36084,36052,36084,38165,36116,36117,38197,36084,34004,36117,36085,33972,36117,36117,31891,33972,31859,27697,29778,19245,21294,29745,21293,27632,29745,27632,31825,27632,29745,31858,21293,23373,33971,25487,23406,29712,19180,27632,25486,19180,31858,23374,19148,31825,19115,23438,27599,17067,21293,21326,25487,52923,48730,40310,40245,40277,40278,36052,29778,34036,34004,27698,25617,29810,27730,25617,25584,29810,27730,25584,25584,29843,29842,25584,25519,27730,27697,23504,21391,23504,23504,23471,21326,23406,23439,23471,23503,23568,21520,21391,23406,27664,27729,23471,25584,31891,29810,23438,21326,21423,21423,23438,19180,21293,23406,25487,21293,21325,23406,25486,21261,21293,23374,25487,19147,19180,25519,21293,19115,19116,21261,21325,19180,19148,21293,19180,19180,19245,19212,17034,14922,21260,27599,29647,27567,31793,31793,21163,14856,33938,42390,40212,29647,25421,27502,29680,14856,25389,16969,10598,14791,38164,31792,31792,36018,38099,38099,36018,33873,33905,36018,38099,36051,31792,31759,35986,36018,36019,36018,31759,29646,31760,21194,16904,23275,16936,21195,21163,19050,35986,44438,42358,38132,36051,29647,23341,27502,25454,25421,25454,21228,25421,25454,23308,27566,19114,14824,79},
{57084,57084,57084,55036,55004,55004,55003,55003,55003,55003,55003,55003,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,50843,52891,52891,50842,50842,50842,50810,50810,50810,50810,50810,48730,48730,50810,48730,52923,40245,33971,36052,34004,36084,36084,36084,38164,38229,34069,34036,36117,34036,31923,36117,31923,36084,40375,34069,40375,40343,36150,42455,29843,34036,33939,14954,23406,31825,23406,31857,25519,23406,33970,17035,19148,38197,27632,21293,29745,14921,25519,25454,14889,33906,23374,16970,33938,14857,21325,27600,12809,31858,25519,29680,57084,57116,48729,48697,48697,48729,42423,34036,38295,40343,34069,29843,36149,36181,31956,29843,36149,36149,31955,29842,34069,34069,31891,27664,27697,27729,27729,25616,27794,29842,25617,23471,27664,29777,27664,23568,23633,23633,25584,23438,23439,25584,25584,27664,31923,31923,25616,23471,23503,25584,25584,25519,25551,27632,27632,23406,25486,25486,27631,25454,25454,25487,25519,23374,23438,25551,27632,25487,23438,25487,25552,23406,23406,19180,14922,17034,19180,21293,21293,21293,21228,19082,21195,21195,21163,21163,14824,19082,33970,42325,29647,17002,14857,25421,23341,16969,29680,16969,10565,12711,31825,23340,14823,16937,16969,16937,25388,23276,10630,12711,12743,12710,25389,16937,12678,12679,12678,12711,25388,12678,16969,19016,16904,21194,21162,25388,19082,23308,42390,42358,40277,38131,33905,25421,25389,27502,25389,25453,25421,21227,25454,23341,25421,25421,19050,14791,89},
{57084,57084,57084,55004,55004,55003,55003,55004,55003,55003,55003,55003,55003,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50843,52891,52891,50843,50843,50810,50810,50810,50810,50810,50810,50810,48762,50810,50810,52923,42390,36084,38165,36084,36084,36084,38197,40310,38262,34037,34037,36149,36117,34068,34069,34036,36117,40375,34101,42455,40375,36149,42456,36182,40343,42455,27697,33939,31858,21325,27664,25454,21293,33938,19148,21260,36083,27599,21228,29712,14922,27599,25454,14889,31825,21261,19115,33938,14889,21260,27567,21260,31793,21294,25519,55003,57116,50810,50777,50777,50777,44536,38230,38295,38295,36149,34068,36149,36149,34068,31956,36149,36149,34004,31923,34036,34036,31955,29842,29842,31923,29842,27762,27730,25681,27729,27697,31890,31858,27697,23569,23634,25682,27697,29777,27697,27664,27664,25616,25681,27697,27697,29810,31890,29810,27632,23406,25552,31890,27632,21261,23341,23341,25519,23341,21260,21261,25519,23406,21260,21293,23471,21293,21228,21293,23438,21261,17067,21261,19147,12808,17034,17002,17034,14921,16970,10598,8517,8517,10598,14824,14856,14857,23341,14889,21228,19115,14857,27534,25421,29680,36051,17002,14824,12711,33873,25454,12743,14856,14889,14889,23308,23308,8453,8485,10533,8485,25388,16937,8452,8453,8485,8485,25388,12678,19082,18984,16871,23275,21162,21129,16969,35986,44471,42358,38132,36051,29680,25421,25453,25421,25421,25454,21163,23308,25421,25421,25421,23276,19082,16969,94},
{57084,57084,55036,55004,55004,55004,55004,55003,55003,55003,55003,55003,52955,52955,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,50843,50842,50842,50842,50810,50810,50810,50810,50810,50810,50810,50810,50810,52891,44503,38197,38230,38164,40278,40278,38197,40342,40342,36149,38230,40343,38230,40375,38262,40375,36149,42424,34069,38294,42488,40375,42488,38230,36149,44568,38262,40375,44568,38229,40310,31826,19212,33971,27632,25519,38229,34003,29745,36083,27631,36083,33971,27600,33971,29745,25486,36084,17003,21260,29712,17035,33938,33971,36084,57084,57116,50777,48697,48697,50777,42390,31923,38262,38262,31988,25616,29875,31956,27697,27697,34036,36116,29810,27697,34003,31923,27697,23503,27729,27697,23536,21423,21423,21423,23471,25551,31923,31891,25519,21391,23601,23568,21390,25551,27664,27664,23471,21422,21488,23536,23406,25584,29777,29745,23406,21261,29777,29810,21293,17035,19115,19147,21293,17067,17067,19180,21293,19148,17035,19115,19180,17035,17035,19148,21228,21293,27567,25454,19148,14889,14921,12808,14921,19114,19115,14856,14856,14856,16969,19082,14824,14856,23308,16937,21228,21227,14889,16970,17002,21228,33970,19050,14824,16937,31792,29679,25421,25421,25454,25454,29679,31760,25389,25389,25421,25421,27566,27502,25389,25421,25421,25421,27534,27534,29647,19049,18951,31727,23242,18951,31793,40310,42358,40277,36051,33938,27566,27534,27534,27567,27534,23309,16969,23341,25421,29679,21163,16937,21228,16969,80},
{57084,57084,55036,55036,55004,55004,55004,55004,55003,55003,55003,55003,52955,52955,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,50843,50843,50842,50842,50842,50810,50810,50810,50810,50810,50810,50810,50810,50810,46616,42391,42423,40310,42423,42423,42391,38197,40310,36149,34037,36149,34069,34069,36182,36149,44536,42456,36182,40343,50810,48762,46649,36182,34069,42455,36182,38262,50842,50842,50842,42455,34068,38229,36117,34004,44503,46616,46648,29745,21325,29745,27632,21293,38164,48697,48664,38164,17035,17067,33906,23341,33938,33971,36051,44438,54970,50810,48697,48664,46583,40277,27697,27664,25584,27729,27664,25552,25519,29745,25584,23438,23471,29777,25519,25487,23406,27697,23438,23438,21293,27632,21293,21325,23374,27664,21325,21228,23374,27632,25551,21325,25519,27632,19180,19179,21228,27664,23438,23373,21325,27632,19147,19115,21293,25519,17002,17034,21228,25551,17034,17002,21260,25518,31661,27501,27534,27534,29549,27501,25421,27501,29581,27501,21260,25487,29713,29777,21228,21260,23406,25454,25486,27631,27599,29679,33938,33938,38131,40244,40277,29647,27599,23341,14857,21260,19115,21228,10663,12711,14824,33906,23276,19082,16937,31792,31760,25421,25454,27534,27534,29647,31760,23308,25421,25421,25388,27566,25453,21227,23308,23308,21195,27501,23275,27534,21130,18983,38066,27436,16870,25421,38197,42390,38164,35986,27534,23308,23341,23308,23276,21195,21195,23308,16937,14824,25453,23308,14824,25453,14824,68},
{57084,57084,55036,55036,55004,55004,55003,55003,55003,55003,55003,55003,55003,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,50843,50842,50842,50842,50842,50810,50810,50810,50810,48762,50810,50810,50810,50810,50810,50810,50810,50778,50810,44471,27599,40277,44504,40343,42423,42423,42423,42456,42423,50810,46649,44536,46648,54971,52922,50810,46616,44536,48697,46649,48697,52922,54971,52922,48729,48729,48730,50810,48729,52923,55003,52923,46616,44503,46616,46584,46551,50809,52890,52890,46616,42390,42390,48697,48664,44471,33939,36019,36019,33906,33905,27566,27566,29615,42358,21228,10631,12711,25422,21195,12679,14824,27567,19050,12711,10663,27599,12776,10598,10631,25519,14856,12776,10631,25454,12776,12744,14824,25519,10663,8485,12711,23373,14889,12711,19050,25421,14856,12711,12679,23406,10760,12744,14792,25454,10630,8517,12776,21228,10630,8485,14824,23308,10598,10598,14856,27533,31628,25290,23242,25323,35822,31629,27436,27404,37870,31597,23341,21261,23406,27632,27632,46583,46584,42357,27599,23308,19115,16969,16969,29680,42325,42390,44439,31760,27534,19050,14857,23373,21260,23406,10631,10631,14824,33938,17002,17002,14856,31792,29647,14888,19050,19082,19050,23340,27567,10598,10598,10598,10566,25421,21163,10565,10566,10565,10565,25389,14856,19082,21162,18983,35920,29549,18951,14791,21163,38132,36051,33938,25421,23341,23276,23308,25421,21195,16937,25421,25421,21163,27566,19082,19115,25454,16969,86},
{57084,57084,55036,55036,55004,55004,55003,55003,55003,55003,55003,55003,55003,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,50843,50842,50842,50842,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50778,50778,50810,36051,29712,44471,48729,48697,48729,50777,48729,48729,48729,48697,50777,50810,50810,50777,48729,50809,50810,50810,50810,50810,50842,50810,50777,50810,52890,52890,52890,52890,52890,50842,50809,50810,52890,52890,52890,52890,50842,50810,48729,48697,48729,48729,48729,46616,46584,44503,33970,36018,29648,27567,29680,21228,23373,27566,40277,23341,12744,12711,16969,19050,21163,12743,14856,14824,14824,10663,16937,12711,8518,10598,16970,19050,12744,10598,14824,14986,12776,10566,19050,10695,8517,12678,16969,17066,10630,10566,16937,21228,16969,10598,17002,10793,12776,12679,17002,12776,10598,12678,16937,14824,10566,12678,19017,14824,14856,12711,23275,23210,14791,14791,18985,16871,12678,14759,23177,33775,23243,25422,21261,23406,27632,25454,38067,38131,38164,21228,14857,14889,17002,19082,31760,42357,27534,25389,23341,27567,19050,14824,23373,23341,19148,14921,12711,12744,31793,14824,14824,16937,29680,29679,16969,19082,19082,19082,23340,29679,14791,14791,14791,12743,25421,23340,12711,14791,14792,14791,25453,19082,25388,23242,18983,38001,33775,18886,16936,19115,29647,33938,31760,31727,31727,29647,29615,29647,19082,27534,31760,29680,21195,25454,19082,25454,25454,19050,91},
{57084,57084,55036,55036,55004,55004,55003,55003,55003,55003,55003,55003,55003,55003,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,50842,50842,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,48762,50810,36117,31923,40277,48729,46616,48697,48697,46616,48697,48697,48697,48729,48729,50777,50778,48729,50777,50809,50777,50810,50810,50810,50842,50810,50810,50810,50810,50842,50810,50810,50842,50842,50810,52890,50810,50810,50810,50777,50810,50810,48729,50778,48697,48697,48729,48664,46583,33906,33938,29680,25486,25422,16937,16969,21163,33873,19050,21065,18920,18952,16937,25291,21033,18985,18985,23178,21000,18920,16937,23146,25129,18985,19050,27307,25096,16872,21065,27339,25096,18952,21066,27339,27177,21033,23146,29388,27209,18985,25259,33548,29225,18985,27339,31468,27209,18985,27339,31467,27241,18985,27307,31500,27241,21065,31468,31468,25161,18985,33580,33548,29290,16872,29355,31403,29289,18985,29387,29355,31695,21261,25487,27664,16970,10598,14889,27599,19115,14921,16969,17001,23308,31792,42325,23341,19050,21195,21228,19050,14857,21228,23373,19115,14857,10630,10631,23341,12776,16937,19082,31760,33873,38099,38099,38067,38099,38131,38131,40212,38132,38132,38164,35986,35986,38131,38131,38131,38131,31824,36018,38098,23242,21063,33774,31662,18886,21129,27599,29647,36019,29646,29548,29516,29580,25420,23308,10598,21163,23308,27534,27566,19050,23276,35986,27599,23308,60},
{57084,57084,55036,55036,55004,55004,55004,55003,55003,55003,55004,55003,55003,55003,55003,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,50842,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,46617,42488,44569,48697,46616,46616,46616,46616,46616,46616,46616,48697,48697,48697,48729,50777,48729,50777,50777,50777,50809,50809,50809,50810,50810,50810,50809,50809,50810,50810,50810,50810,50810,50810,50809,50810,50778,50777,50809,50777,50777,48729,48697,48697,48697,48697,46616,44471,44471,54971,48664,38132,33873,31761,33874,29680,27534,37806,35693,29485,27502,37839,37774,27371,25389,35726,35661,27437,29615,35726,35661,25356,31695,37839,35660,25356,27501,31629,29452,23243,27469,33645,31532,27404,27469,31565,29485,25356,29484,33613,33581,23308,27501,27372,23178,21163,25291,25258,25194,19050,23211,25227,23178,21131,23178,23146,23146,21163,23178,25226,23210,19050,21098,23178,23210,21163,23211,23243,33841,21261,25487,27665,16970,10631,16969,31793,21228,14921,16969,19115,21195,29680,42325,42358,42390,42358,19082,19050,14889,21261,27567,19082,17002,10630,10630,17002,12743,19049,27534,40244,42292,48696,48696,48664,48696,48664,48631,50777,48696,48697,48697,44470,46583,48696,48696,48664,48664,42325,46583,42357,31726,27402,31727,33840,14757,12678,12679,16904,21163,25322,31594,27369,25256,21129,19114,10566,12776,12711,23276,31760,14824,23308,27534,29679,33873,84},
{57084,57084,57084,55036,55004,55004,55004,55004,55004,55004,55003,55003,55003,55003,55003,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,50843,50842,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,46617,42456,44536,46617,48697,48697,48697,48697,48697,48697,48697,48729,50777,50777,50777,50777,50777,50809,50810,50810,50810,50810,50810,50810,50810,50810,50810,50842,50810,50810,52890,50842,50810,50810,50810,50810,50810,50810,50777,48729,48729,48729,48697,48697,48697,48697,48665,48696,48632,50810,57116,52922,46584,42358,42390,36084,27664,29680,29712,27664,27632,29777,29778,27632,27599,29745,31858,27632,25551,25617,25584,25519,27600,27665,27697,23438,21293,21293,23405,25519,23406,23438,25519,25519,25454,23406,25519,25519,27599,27664,27632,23438,23503,21455,25552,25519,29745,29745,29777,27631,29680,27599,29680,27567,27567,27599,29680,25454,25486,25551,27567,27567,29648,29712,31825,27599,29680,27567,31792,31826,19116,21261,19083,12711,17002,31858,21228,16970,16970,16970,17002,27534,42357,35986,33938,31760,19083,19083,16970,21196,29680,17002,14889,10598,10565,10598,14824,25421,31727,52890,46518,25421,25356,25356,25356,48599,42325,23275,23243,21163,25388,48696,29647,19050,19050,19050,25421,44438,23276,21163,27500,25290,25355,38033,29515,27402,27401,27402,25256,29449,27369,21096,21031,23242,21228,12711,14824,12711,23308,29647,14824,31728,29680,31793,31761,95},
{57084,57084,57084,55036,55004,55004,55004,55004,55004,55003,55003,55003,55003,55003,52955,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,50842,50842,50842,50810,50842,50842,50810,50810,50810,50810,50810,50810,50778,50810,48730,46649,46649,48697,48697,48697,48697,48697,48697,48697,48697,48729,50778,48729,48729,48697,48697,48697,48697,48697,48697,48697,46649,46617,46649,46649,46649,46649,48697,46649,46649,46649,46649,46649,46649,46617,46617,44537,44537,44536,44536,44536,44536,44537,46617,46617,44536,40310,40278,38197,40277,40277,36084,36084,36051,36052,34036,34036,31891,29778,31858,29842,29810,29745,27632,25552,25519,25519,23374,23406,23439,21326,27664,25519,19148,19148,17067,17035,17035,19115,17035,17002,17002,21228,21228,19115,14922,16970,17002,16970,17002,19180,19147,17035,17035,33971,44536,40309,38164,23341,21228,16937,23341,16937,14889,19115,25453,10566,12743,23341,10663,19115,25454,29680,46584,40212,36019,25421,33938,31793,16970,17002,19115,12711,17002,31858,19148,16970,16969,17002,23308,29679,42357,25454,21195,16937,19050,16970,14824,21195,31825,14889,14921,10663,10598,10630,19082,27534,33905,55003,35953,21162,21195,23275,23307,46551,29614,21195,23275,23308,27533,46583,23275,21195,23308,25388,31727,38099,16904,21195,23307,23275,23242,27436,29547,29546,27433,27369,25256,23143,16870,16838,16903,21195,23308,19082,16969,14856,21195,23341,25421,31728,29648,29648,29647,117},
{57084,55036,55036,55036,55036,55004,55004,55004,55004,55003,55003,55003,55003,55003,54971,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52923,52923,52891,52891,52891,52891,50842,50842,50842,50842,50842,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,48730,48730,48730,48730,48697,48697,48697,48697,48697,48697,48730,48730,48730,48730,48697,48697,48697,46649,46649,46617,46617,46617,44569,44569,44569,46617,46649,46649,46617,46649,46649,46649,46617,46617,44569,44537,44537,44536,44536,42488,42456,44536,44537,44569,46617,44536,40310,38229,38165,38197,36084,38165,36084,31858,31858,31890,31891,31923,34003,31923,31891,31858,29810,29746,27697,27633,27633,27600,27600,27600,25552,33971,27600,21293,21293,21261,21228,19148,19115,17035,17003,17035,23341,21228,21196,17003,19083,19083,19083,19115,21228,21261,19115,17002,33906,46584,25486,25454,23308,21195,14856,27567,23308,23341,23373,25421,14857,12744,19083,12712,14889,19148,25421,31760,16969,27567,31760,31825,29680,17002,17035,19116,12711,16970,33938,21196,16970,16969,19115,21196,29647,42325,40212,38099,38132,19083,14889,14857,21196,33905,16970,17035,10631,8517,10631,16969,27566,40211,52890,35986,27534,29614,29582,35985,50777,31727,27501,27502,27501,40244,46518,27469,27502,27501,27534,40212,44438,42357,31792,25388,23275,21162,16903,16806,16838,16838,14758,14758,14726,12678,12678,25421,27534,25389,16969,19050,16937,25421,16937,25421,29647,40245,33906,29680,87},
{57084,57084,57084,55036,55036,55036,55004,55004,55004,55003,55003,55003,55003,55003,55003,54971,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,50842,50842,50842,50810,50810,50810,50810,50810,50810,50810,50810,50810,48730,48730,48730,48730,48730,48697,48697,48697,48697,48697,48730,48730,48730,48697,48697,48697,48697,48697,46649,46649,46617,46617,46617,44569,46617,46617,46617,46649,46649,46649,46649,46649,46617,46617,46617,44569,44537,44536,44536,44536,42456,44536,44569,44569,44569,46649,44536,44504,44504,44536,44504,44536,44504,44504,42423,42423,42423,42423,42456,44504,44504,40343,38198,34037,31924,33972,33972,31891,31891,29745,27632,25552,25519,25519,21293,27632,29745,25519,29713,33971,33939,31826,33906,25454,23341,29680,27599,36019,38165,27599,29680,29680,10663,10663,33905,48696,44503,33906,23308,19115,12743,31793,19082,14856,27534,29647,10598,16970,19148,10663,12776,12809,23276,31760,23341,23373,25454,23373,27632,16970,14857,19115,12744,17002,31858,21228,16970,16969,16970,16970,27566,40277,40277,40245,29680,29745,29713,14857,23308,31792,16937,12744,10598,8485,10598,16969,29646,46518,48664,21195,16904,16936,16936,29647,44470,16969,16936,16969,16936,40179,33840,12711,14856,14856,19017,38099,40212,21195,23243,25388,25388,21194,27402,29514,27369,14758,10565,8485,10598,12711,16937,33906,25454,25454,12711,8485,23341,27566,19050,23308,31825,48697,40213,29712,95},
{57084,57084,57084,55036,55036,55036,55004,55004,55004,55003,55004,55003,55003,55003,55003,55003,52955,52955,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,50843,50843,52891,52891,50810,50810,50810,50810,50810,50810,50810,50810,50810,50778,50778,48730,48730,48730,48697,48697,48697,48697,48697,48730,48730,48730,48730,48697,48697,48697,48697,46649,46649,46617,46649,46617,46617,46617,46649,46649,46649,46649,46649,46649,46649,46617,46617,46617,44569,44569,44537,42488,44536,42456,44536,44537,44569,46617,46649,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,46649,46649,44537,40343,36150,34004,33972,34004,33972,31891,27665,27633,23407,25519,27632,23374,25519,31826,38165,42390,46649,46617,46649,33906,23309,29680,31825,29712,40245,40245,23341,36019,31826,12711,16970,36051,48696,46584,31825,23341,16969,14824,31793,21195,19082,38099,33906,8486,23308,23341,10631,12711,14857,14825,16937,14889,14856,23341,27567,27632,14889,12776,19115,12743,17002,31858,21228,16970,16969,21163,25389,27566,40244,27534,19050,14856,33906,31858,14889,23341,29647,14792,8485,8485,8485,8517,16969,27566,48664,46551,31760,31727,31760,31792,46551,44438,31727,31760,31760,35921,50744,48631,48631,48696,48664,38099,25421,14791,10598,23275,25388,23308,21130,29515,29514,29515,14791,8453,8485,10630,12711,16904,40245,29680,27534,10598,10598,25421,25421,16937,19082,33938,44471,44439,29680,92},
{57084,57084,57084,55036,55036,55036,55036,55004,55004,55004,55004,55003,55003,55003,55003,55003,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52890,50842,50842,50842,50842,50810,50810,50810,50810,50810,50778,48730,48730,48730,48697,48697,48697,48697,48697,48730,48730,48730,48730,48697,48697,48697,46649,46649,46649,46617,46617,46617,46617,46617,46649,46649,46649,46649,48697,48697,46649,46649,46617,44569,44537,44537,44536,44536,44536,44536,44536,44537,44569,46617,46617,48665,46649,48697,48697,48697,48697,48697,48697,48697,46649,48697,48697,46649,46649,46649,44536,40343,38230,44471,42423,42391,42391,42391,33971,27632,27665,27633,25552,25487,25487,29713,38197,44471,44471,42390,42390,29648,19115,23341,31793,38132,40245,31825,23341,38099,33938,12711,27567,40244,40244,40244,33938,25453,19082,16969,31793,21228,23308,40244,31793,16937,14857,21196,12808,12711,12712,12744,10598,10598,12744,25454,27599,27600,14857,12744,17002,10663,14922,31890,21261,16970,16970,19115,25421,29615,40277,33906,29615,25389,38100,36051,14889,25454,29647,14824,8453,10598,10566,12711,16969,31727,54970,38066,14791,12711,12711,12743,46551,29647,12678,12711,12710,21162,52890,59164,59164,57116,48664,27501,27469,14824,12678,25388,27501,27534,27468,35820,33708,42259,21131,8452,8485,10598,12678,19083,42390,38164,27534,10566,14824,23308,23308,19050,21195,27502,40213,46616,27567,67},
{57116,57084,57084,55036,55036,55036,55036,55004,55004,55004,55004,55003,55003,55003,55003,55003,52955,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,50842,50842,50842,50842,50810,50810,50810,50810,50810,50810,50778,48730,48730,48730,48697,48697,48697,48730,48730,48730,48730,48730,48730,48729,48697,46649,46649,46649,46617,46617,46617,46617,46617,46649,46649,46649,48697,48697,46649,46649,46649,46617,44569,44537,44537,44536,44536,44504,44536,44536,44537,46617,46617,46617,46617,46649,46649,48697,48697,48697,48697,48697,48697,48697,48697,48697,46649,46649,42391,40343,38198,38165,40278,40278,38230,38197,38165,31859,27600,27665,27632,23407,25519,27599,29745,38197,42423,29647,27567,31760,21228,19115,17002,31793,40212,35986,29680,21163,27502,29680,12712,21163,40212,38164,38164,35986,25453,21228,25453,33873,25421,29679,25421,21195,17002,16905,23341,14889,12744,10663,12776,12711,10631,16937,23374,31826,21261,14857,12711,14889,10631,14921,31858,21293,16970,17002,19050,16969,27534,40245,42358,44438,42325,46616,42391,14889,27534,25453,14824,8485,10631,12711,12776,8517,31695,52922,40212,35986,38099,40179,40212,50777,42260,40211,42324,42292,44438,54970,54970,54938,54938,46551,29679,29647,21195,19049,25388,25388,23340,27435,35820,33707,25354,21163,8453,8485,10565,10598,19082,40310,40245,27534,10566,19115,21228,16937,23308,31793,40245,46584,46617,27567,105},
{57084,57084,57084,57084,57084,57084,55036,55036,55004,55004,55004,55003,55003,55003,55003,55003,52955,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52923,52923,52891,52891,52890,52890,52891,52890,52890,52890,52891,52891,50842,50842,50810,50810,50810,50810,50810,50810,50810,50810,48730,48730,48730,48697,48697,48697,48730,48730,48730,48730,48730,48730,48697,48697,46649,46649,46649,46649,46617,46617,46617,46617,46649,46649,46649,48697,48697,46649,46649,46649,46617,44569,44568,44536,44536,44536,44504,44536,44536,44537,44569,46617,46617,46649,46649,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,46649,46649,36085,36085,36084,34004,33972,31924,31924,31891,31859,27665,27633,27633,25552,23406,21326,27632,29745,40278,44471,25454,25486,29679,19115,19115,19083,35953,35954,31760,21228,27534,21196,27534,12712,14824,40212,38164,38164,33905,25454,14824,14856,33905,27534,25389,21163,19082,14824,16937,23308,14922,12744,12744,12776,10631,10630,16970,21196,29713,19180,12776,12744,12776,10631,14889,31890,23341,16969,16969,17002,21195,27534,40277,31760,25421,25421,42358,46552,16970,25421,19049,14856,8517,10598,10631,12743,10566,23243,44471,29615,16904,16937,16936,38066,44438,31728,16872,16937,21163,42293,42357,25388,23243,31760,19082,23308,36018,33937,27566,23308,25388,23308,18984,18984,16871,27468,25389,8452,8485,10565,12678,16904,38164,38164,27567,10598,25454,23341,16905,25454,23308,27534,50810,48697,27567,113},
{55036,57084,57084,57084,57084,57084,55036,57084,55036,55004,55004,55003,55003,55003,54971,52955,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52923,52891,52891,52891,52891,52891,52891,52890,52890,52890,52891,52891,50843,50842,50842,50842,50810,50810,50810,50810,50810,50810,50778,48730,48730,48729,48698,48730,48730,48730,48730,48762,48730,48730,48697,48697,46649,46649,46649,46649,44569,46617,46617,44569,46617,46649,46649,46649,48697,48697,46649,46649,46617,44569,44569,44537,44536,44536,44536,44536,44536,44569,46617,46617,46617,46649,46649,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,46649,38230,36117,38165,31858,31891,34004,33971,34004,34004,31891,33971,33971,25519,25519,23406,27600,29745,38197,42390,27535,27534,29680,19115,14857,17035,38131,27535,31793,27567,31825,21196,25454,12711,14824,36019,38164,33938,29712,25454,12711,19050,31792,23276,21195,33873,40212,38099,29647,29647,17003,12744,14857,12777,10631,10598,16969,19082,25454,14922,14889,14921,17002,17034,17067,31858,21293,16969,16969,19082,25421,27566,40277,29712,21228,19050,38067,48664,16970,29614,19049,14856,8485,10598,10630,12743,10598,19050,40245,25421,10598,12678,12710,31825,42325,29647,12678,10565,12679,33873,36019,33873,31792,31760,19017,19049,29646,27533,25453,23308,25421,21195,23309,17002,12744,25389,27567,8452,8485,10533,12678,12711,31793,36051,29712,23308,27567,19082,23276,23308,14889,29680,52923,48729,29647,103},
{57084,57084,57084,57084,57084,57084,57084,57084,55036,55004,55003,55003,55003,55003,54971,52955,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52890,52891,52891,52891,52890,52890,52890,50842,50810,50810,50810,50810,50810,50810,50810,48730,48730,48730,48729,48729,48730,48730,48762,48762,48730,48730,48730,48729,46649,46649,46649,46649,46617,46617,44569,44569,44569,46617,46617,46649,48697,48697,48697,46649,46617,46617,44569,44537,44537,44536,44536,44536,44536,44569,46617,46617,46649,46649,46649,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,46649,46649,44569,42423,44471,42423,40278,36084,38165,38197,36084,33939,23406,27632,27632,23406,23374,38165,38197,42358,25454,25453,27599,19115,17002,21228,38164,35954,31793,25421,21163,23276,25454,12744,12744,16937,36051,25486,21228,12711,8485,21130,29680,16970,19049,42324,42325,31792,29647,23309,17002,10664,12744,12744,10631,8518,19050,16970,23309,12744,12744,12744,12744,12744,14857,31858,23406,16969,16970,17002,16970,25421,38164,42358,42358,42325,44471,36019,23276,33840,21162,14824,8485,10566,10598,10630,10566,16969,38164,40245,40245,40244,40277,40245,40244,40277,31793,12678,10598,12678,12678,12710,12678,10598,12646,12646,12646,10597,19082,23340,25421,21195,27600,17035,14890,25454,29647,8452,10533,10533,12678,14759,14791,21162,29647,27534,23308,19082,29615,21196,19082,44439,52923,50778,27567,138},
{55036,55036,55036,55036,57084,57084,57084,55036,55004,55004,55003,55003,55003,55003,55003,55003,52955,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52890,52890,52890,52891,52891,52891,50810,50810,50810,50810,50810,50810,50810,50778,50778,48730,48730,48730,48730,48762,50810,48762,48762,48730,48698,48697,48697,46649,46649,46617,46617,46617,46617,46617,44569,46617,46617,46649,48697,48697,46649,46649,46617,46617,44569,44537,44537,44537,44536,42488,44537,44569,46617,46617,46617,46649,46649,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,44537,38262,40343,44504,42391,38165,36084,40310,33971,25519,21261,29713,27600,27632,23406,42391,44504,46584,27567,27567,29680,25454,27534,25454,27534,40211,31825,23373,23276,19082,27599,14857,14792,16937,33906,31825,25421,21195,19050,21163,21228,14889,19017,44405,33905,21130,29646,21260,23374,14889,14857,12777,10631,8517,19082,16970,25454,12776,12776,10631,8550,10631,12743,29745,25454,16970,16969,16970,17002,25453,38164,33905,29679,29647,35986,25421,25453,31759,27403,16904,8485,10598,8485,10630,10598,14856,38164,40277,40277,40277,42325,40244,40244,36018,25389,12711,10566,10598,10597,10598,12678,12678,10598,12678,12646,10598,16936,23308,25421,21228,23374,14889,17002,19115,29647,8485,10533,8485,12678,14823,16904,19050,23308,27534,16937,21195,29680,38132,48697,50810,50843,50810,33873,164},
{55036,55036,55036,55036,57084,57084,57084,55036,55004,55003,55003,55003,55003,55003,55003,55003,52955,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52890,52890,52890,52891,52891,50810,50810,50810,50810,50810,50810,50810,50810,50778,50778,48730,48730,50778,50810,50810,50810,48762,48730,48730,48729,48697,48697,46649,46649,46617,46617,46617,46617,46617,46617,46617,46649,46649,46649,46649,46649,46617,46617,44569,44537,44537,44536,44536,44536,44536,44569,46617,46617,46617,46649,46649,46649,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,46649,42456,38263,38230,36182,36117,38197,44471,44471,31826,25454,27665,27632,27599,29680,25486,42391,46617,46616,23342,23342,25487,23407,25487,23375,19148,19082,38132,33939,19115,16905,27534,14857,14792,17002,31825,21227,23340,27566,21228,16937,12711,10598,14824,46518,38067,27534,33840,29745,25519,17035,14890,14857,10631,8518,23341,25454,23341,14889,17002,14889,14856,14921,17002,27632,19148,16970,14921,14889,21163,29679,40244,27502,16937,14824,31760,27566,27599,35887,27468,19050,8485,10565,8485,10598,10598,14824,38131,31793,21228,23340,21195,29680,40245,33873,25388,21162,16904,19049,21130,21097,16936,19017,16936,16936,16904,14824,16904,23308,23341,25454,19213,14922,14922,21260,35987,8453,8485,8453,14791,21163,25388,25453,25421,29679,14856,21163,23341,42390,48665,50843,52891,50842,35987,145},
{55036,55036,55036,55036,55036,57084,55036,55004,55003,55003,55003,55003,55003,55003,55003,55003,52955,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52890,52890,52890,52890,50810,50810,50810,50810,50810,50810,50810,50810,50778,50778,50778,48730,48730,50810,50810,50810,48762,48730,48730,46649,46649,46649,46649,46649,46617,46617,46617,46617,46617,44569,46617,46649,46649,46649,46649,46649,46649,46617,44569,44537,44537,44536,44536,44536,44536,44569,46617,46617,46617,46649,48697,46649,48697,48697,48697,48697,48697,48697,48697,48697,48730,48697,46649,46649,42456,40343,36150,38263,34037,34004,33972,36117,40310,36084,31826,27600,25454,25486,17035,29712,31858,27632,21261,23407,21229,21261,21294,21229,19148,12776,27567,27535,21228,14857,27534,14856,12743,19050,31793,19147,23341,27599,23341,10630,12743,16969,19050,46551,31728,21163,35953,29712,23374,21228,14922,12744,10599,14857,29745,25487,23341,12776,17002,10663,10631,10695,12776,25551,19148,16970,16937,14889,14889,25421,40245,38164,36018,35986,38132,25421,25421,35952,23242,19050,8518,10598,10598,10630,12711,14824,36051,29647,10630,12743,10630,25421,42357,33873,8453,10565,10565,31760,40212,29647,16969,25421,25388,21195,29647,27566,16969,23308,23308,25551,19181,17035,14954,17034,33906,12711,12711,12711,16937,23242,31726,31759,25421,27502,19082,29680,29680,44439,46584,52891,50842,50810,33906,111},
{55036,55036,55036,55036,55036,55036,55036,55036,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,54971,52923,52923,52923,52923,52891,52923,52891,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52890,52890,52890,52891,52891,50842,50810,50810,50810,50810,50810,50778,50810,50778,50778,50778,48730,50810,50810,48762,48730,48730,48730,46649,46649,46649,46649,46649,46617,46617,46617,44569,44569,44569,44569,46649,46649,46649,46649,46649,46649,46617,44569,44537,44537,44536,44536,44536,44536,44569,46617,46617,46617,46649,48697,46649,48697,48697,48697,48697,48697,48697,48697,46617,40278,48697,46649,44536,44536,40343,36182,38230,36117,34004,34004,36085,29746,23406,36019,33939,29745,25454,16970,21261,19116,19019,17003,14890,14922,17003,19148,17003,14889,12777,14890,19116,19083,14824,23308,14824,14792,25454,29647,21228,25454,29712,25421,12743,21195,23276,19050,46518,35986,27501,31727,29712,23374,21293,17035,10663,10631,16938,27632,23374,12776,12776,14857,10598,10598,10631,10631,27600,23373,14889,14857,16937,14856,23308,38132,36051,33873,31793,33938,23276,23308,35919,19049,19050,8518,10598,10598,10598,10598,12743,36051,33906,23276,25389,23340,31760,42325,38099,23276,21163,19049,31728,40277,40212,38132,33905,23243,19017,33905,35985,21130,23308,21228,25519,17035,17002,14922,17002,29680,16969,17002,19082,27468,37900,37965,33838,27534,21131,25389,27534,25454,31761,50778,52891,52891,50810,33841,106},
{57084,57084,55036,55036,57084,55036,55004,55004,55004,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52890,52890,52890,50842,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,48762,50810,50810,50810,48730,48730,48730,48729,46649,46649,46649,46649,46617,46617,46617,46617,44537,44569,44569,46649,46649,46649,46649,46649,46649,46617,44569,44569,44537,44536,44536,44537,44537,44569,46617,46617,46617,46649,46649,48697,48697,48697,48697,48697,48697,48697,48697,44504,29745,40310,44568,44536,44537,40343,38230,36150,34069,31924,29810,27665,21326,27600,38132,38132,31825,25454,19148,31859,25487,31761,27600,27600,23374,23342,25487,23406,17003,14857,14889,21228,17003,14824,25422,21196,19082,33873,31793,19083,25486,29712,25453,14824,23308,25389,21163,23276,21195,16905,21162,27599,25487,17002,14889,10598,10599,14857,27566,23374,14857,14889,14922,14889,12776,12743,12776,29745,23373,14857,14824,14856,21260,23308,36018,25421,16937,12711,23308,27566,25389,14824,12679,16937,10566,12711,14824,12744,12711,12711,33906,38164,40277,42357,44438,42325,40245,40245,42358,38131,29679,29680,40277,38164,38099,33873,23308,14856,16969,16969,14824,23308,23341,25519,17067,17067,14922,14889,19115,16969,16969,21162,33675,37867,35819,35952,31792,23308,25389,31825,46552,50810,50842,50842,52891,50843,38100,113},
{55036,57084,55036,55036,57084,55036,55004,55004,55004,55003,55003,55003,55003,55003,55003,55003,55003,55003,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,50842,50810,50810,50810,50810,50810,50810,50810,50810,48762,48762,48762,50810,50810,50810,48730,48730,48730,48697,46649,46649,46649,46649,46649,46617,46617,46617,44569,44568,44569,46649,46649,46649,46649,46649,46649,46617,46617,44569,44537,44536,44536,44537,44537,46617,46617,46617,46649,46649,46649,48697,48697,48729,48729,48729,48697,48697,48697,48697,42391,31858,38197,44536,44537,42456,38295,36150,34069,31924,25585,23439,25552,31826,25455,29713,27567,23375,23406,44504,38197,38197,42391,44471,33939,27567,31793,31825,23341,14857,14922,21228,23341,14857,27567,21228,23308,33938,31793,12679,25454,33906,25454,16969,23308,25421,23340,23340,21163,14889,14824,23341,21228,16970,14889,10663,14824,19082,27567,23341,12776,14922,12776,12744,10663,12711,14856,27632,23341,14824,14824,14824,17002,21227,31760,36018,33873,31793,25421,35986,27567,12776,10598,16905,10598,10566,10598,10566,10630,12711,33873,38131,38132,40212,38132,38132,40245,40212,38099,33905,27566,29647,40310,31793,12711,19050,23340,14856,23276,25388,19050,23275,23374,23406,17067,17002,14922,14921,19115,17002,17002,21162,33674,37867,35886,36018,29647,23340,19050,31825,44471,48697,50842,50810,50842,50843,44471,134},
{55036,57084,55036,57084,55036,55036,57084,55004,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52890,52890,50842,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,48762,50810,50810,50810,48730,48730,48730,48697,48697,46649,46649,46649,46649,46649,46617,46617,44569,44568,44569,46617,46649,46681,46649,46649,46617,46617,44569,44569,44537,44536,44536,44537,44537,44569,46617,46617,46649,46649,48697,48697,48697,48697,48729,48729,48730,48697,48697,48697,48730,44536,38197,34004,38197,40343,40343,34069,29843,27666,27665,33972,31859,19181,21229,19181,17035,17068,19148,23374,23374,25422,38164,42358,33906,27502,29680,29712,23341,16970,21196,25389,36019,21163,33873,23309,23308,38164,31825,17002,35986,23276,19018,25389,29647,33840,29647,27534,23340,19115,16969,25454,19083,10631,12776,14889,27501,25355,27502,23341,14922,14857,10663,10631,8518,10598,10630,33938,31825,16970,16970,16969,16970,23308,38067,40244,29615,29647,27566,33841,21163,10599,10598,16905,10598,10598,10598,8485,10631,10630,31792,33906,12711,12711,12743,23276,40245,38132,14824,10598,10597,27534,40310,33873,6339,21195,31792,25421,40211,44470,29647,19082,25519,19213,17067,14954,14922,14921,14889,14889,14889,23241,37867,37867,42192,33873,27566,21195,19050,31793,40245,50778,52891,50810,50842,52923,38132,149},
{57084,57084,57084,57084,55036,55036,55036,55004,55004,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52923,52923,52891,52891,52891,52891,52891,52891,52891,52890,52890,52890,50842,52890,50842,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,48762,48730,48730,48730,48697,46649,46649,46649,46649,46617,46617,46617,46617,44569,44568,44569,46617,46649,46649,46649,46649,46649,46617,44569,44569,44568,44568,44536,44537,44536,44569,46617,46617,46649,48697,48697,48697,48697,48697,48697,48729,48729,48697,48697,48697,48697,46649,46649,42423,36084,31924,31892,29811,25617,25617,34036,36084,38165,40310,36084,36117,19214,17101,21262,36052,40310,42391,36052,40213,33874,27535,31760,31760,23276,19115,36019,33906,23308,21227,33873,21163,25421,27534,19082,16937,35986,19050,21163,31760,16969,14791,21195,19050,10566,12711,12679,14856,19082,23341,19115,14889,29581,29548,27567,21196,14954,14922,14889,12711,12744,14856,12744,27567,31825,17002,17002,16969,19050,29615,35986,38099,16937,14824,21163,25421,21195,12744,10598,16937,10598,10566,10598,8485,10630,10598,31792,33906,8485,6372,6372,16937,40277,40244,12743,6404,8452,25421,42357,38132,27534,31760,33873,40146,33808,33775,25388,19082,27664,19180,19148,19148,14922,17002,14889,14921,14889,27369,37867,35754,35886,29680,19082,23308,23308,31760,40277,50843,50843,50810,50843,50810,29679,156},
{57084,57084,57084,57084,57084,57084,55036,55004,55004,55004,55003,55003,55003,55003,55003,55003,55003,55003,55003,54971,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52890,52890,52890,52890,52890,50842,50810,50842,50810,50810,50810,50810,50810,50810,50810,48762,48730,48730,48730,48729,48697,46649,46649,46649,46649,46617,46617,46617,44569,44569,44569,46617,46649,46649,46649,46649,46649,46617,44569,44569,44569,44568,44568,44537,44536,44569,46649,46617,46649,48697,48697,48697,48697,48697,48729,48729,48697,48697,48697,48697,46649,46649,46649,48729,44536,29811,23473,23472,29811,34037,34036,36084,36116,38197,38197,36084,21295,17069,17037,21262,31793,35986,36019,40213,35987,31760,23309,23244,23276,21228,19083,27502,23308,21195,33873,21195,27567,33905,27534,16937,35985,48664,40213,27502,12711,10565,14856,14792,10565,10598,10598,10598,23340,35986,25454,16970,25356,29581,31792,21163,17035,17067,14922,14857,12776,12808,12776,25486,29712,17002,19050,19082,14889,21163,35986,42325,38099,38132,29680,21195,21195,14857,10566,16969,10598,10630,12711,10598,12744,10566,31760,36051,29647,29647,29680,33873,40277,40277,31793,29679,23373,25421,40277,40277,42358,33906,31760,38033,44373,46486,29647,19050,25487,17002,16970,14922,14890,14922,14889,12776,14856,31594,37867,33707,31726,29647,16937,25454,23211,27404,46584,50843,50810,50810,52923,46519,29679,140},
{57084,57084,55036,57084,57084,57084,57084,55036,55036,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,54971,52923,52923,52923,52955,54971,55003,54971,54971,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52890,52890,52890,52890,52890,50842,50842,50842,50842,50810,50810,50810,50810,50810,50810,48762,48730,48730,48730,48729,48697,48697,46649,46649,46649,46649,46617,46617,44569,44537,44537,46617,46649,46649,46649,46649,46617,46617,46617,46617,44569,44569,44568,44537,44569,44569,46649,46617,46649,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,48697,46649,46649,46649,44536,40343,31892,29811,27698,27698,27698,33972,36117,36084,40310,38197,34003,19214,14989,14956,19182,31825,33906,33874,38132,33873,27534,19051,16970,16970,12744,19083,25422,23276,19082,29647,27534,29680,23341,19050,14856,31727,40211,29647,16970,10598,12711,14792,14857,16969,12711,12711,16969,25421,35986,25421,16970,23275,25388,25388,21195,17002,14921,14857,10598,8517,14857,10663,23373,29745,17002,17002,16970,16970,19050,35986,40277,33873,35986,29647,19115,21228,16937,8518,16969,10630,8517,10598,8485,10630,10566,29680,38164,40277,42390,42390,42390,40277,40277,42390,40245,31825,25454,40277,40245,35986,29679,31760,38098,44438,46519,40179,25421,21228,16970,14922,16970,14922,17002,12711,12711,14823,37867,39915,33708,29679,23341,23276,25454,16937,19017,50810,50810,50778,50843,52923,38132,31793,132},
{57084,57084,55036,55036,57084,55036,55036,55036,55004,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,52923,55003,55003,55003,55003,54971,54971,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52923,52891,52891,52891,52891,52891,52890,52890,52890,52890,52890,52890,50842,50842,50810,50810,50810,50810,50810,50810,48762,48730,48730,48730,46681,48729,48697,46649,46649,46649,46649,46617,46617,44569,44569,44568,46617,46649,46649,46649,46649,46617,46617,46617,46617,44569,44569,44569,44537,44537,44569,46617,46617,46617,48697,48697,48697,48697,48697,48697,48729,48697,48729,48697,46649,46649,46649,42391,38197,34004,38230,38295,36150,29843,23472,27633,31891,33971,38197,34003,33971,19182,17134,17102,21295,31793,29680,33938,38132,31793,31826,21196,16970,16970,12744,23341,29680,21196,21163,33938,21196,31760,33905,29712,21228,16970,12679,12744,12744,12679,16970,16969,19082,19050,14792,14856,16970,25389,31793,25454,21196,23243,25388,23308,21228,17002,14889,10663,10598,10598,12776,10663,23341,29712,19050,17002,17002,19083,29615,35986,38164,19050,14824,21195,16970,21163,16970,8518,16937,10631,8517,12711,10565,10630,10598,27567,38132,33873,33841,33873,33873,40245,40245,35954,29680,25454,23308,40245,38164,14791,8485,8485,27566,29647,21162,14824,16970,21228,19147,16970,17034,16970,16969,14856,12744,23209,37899,37867,29548,23341,21163,27534,23276,12743,31793,52955,50810,50810,52891,48697,33906,31825,137},
{57084,57084,55036,55036,55036,55036,55036,57084,55036,55004,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,54971,54971,52923,52923,52923,52923,52923,52923,52891,52891,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,50842,50842,50842,52891,50842,50810,50810,50810,48762,48730,48730,48730,48730,48729,48697,46649,46649,46649,46649,46617,44569,44569,44568,44569,46649,46649,46649,46649,46649,46617,46617,46617,44569,44569,44569,44569,44537,44537,44569,46617,46617,46649,48697,48697,48697,48697,48697,48697,48729,48729,48697,48697,48697,46617,42391,36084,38165,40310,42456,38295,36150,36150,31892,23505,25520,25520,34004,31826,31826,17069,17069,17069,21262,33971,36019,38164,38164,31825,36019,19116,14825,16938,14857,16938,21229,23341,16969,36018,14792,31760,38132,33905,23276,16937,12679,14824,16937,10598,16937,19083,14824,12711,12743,14856,16937,33841,31793,16970,17035,25356,25387,25421,21196,16969,21228,19115,17002,19115,25454,12776,23341,29680,19082,17002,16970,16970,23308,33938,42357,33841,27567,21196,14856,19083,16970,10598,14792,10631,8485,12711,10566,10630,10565,27534,38132,14791,6340,6372,12678,38164,42357,19082,6372,8485,19050,40245,40245,14824,8453,8485,25453,29680,25389,23308,12711,25422,12744,12679,12776,14889,16969,19082,10598,29482,39947,35787,23307,23308,16905,27567,33906,40245,48665,52891,50810,50778,55003,40245,31760,29647,134},
{57084,55036,55036,55036,55036,55036,55036,57084,55036,55036,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,52923,52923,52923,52923,52923,52923,52923,52923,52891,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,50843,50842,50810,50810,50810,48762,48730,48730,48730,48730,48729,48729,46649,46649,46649,46617,46617,44569,44569,44569,44569,46649,46649,46649,46649,46649,46617,46617,46617,44569,44569,44569,44537,44569,44537,44569,46617,46649,46617,46649,48697,48697,48697,48697,48729,48730,48729,48697,46649,42423,40310,42391,44471,48730,42456,40343,40343,38230,36118,34037,31924,31826,21294,23406,25487,25487,23374,23374,14890,17003,14890,17003,19083,21228,21229,23374,17003,14890,16971,16971,16970,17003,14922,19050,29680,12711,27567,38132,31825,23308,23341,6372,14792,16937,10566,14857,21195,16905,14889,16969,16905,25453,29680,27599,17035,21260,23275,25355,31760,21260,19115,31761,33906,25454,31826,31890,10631,21163,29680,19115,17002,16970,16937,16969,29712,35986,33873,25454,19082,16937,23243,17002,8518,12743,12711,10566,12744,10631,12776,10598,25454,40244,16937,8452,8485,12711,38132,42358,23276,8485,10565,19017,40245,40245,36018,29712,23341,23308,36051,27567,25421,16937,27599,23340,25389,23308,23308,21228,21195,19114,33740,35819,27434,21228,25421,19082,25421,38132,44503,50843,50810,50778,50810,55003,35954,31761,23308,126},
{57084,55003,55035,55036,55036,55036,55036,55036,55036,55035,55003,55004,55003,55003,55004,55003,55003,55003,55003,55003,55003,55004,55004,55003,55003,55003,55003,55003,54971,52923,52955,52955,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52890,52891,50842,50842,50810,50810,50810,48762,48762,48730,48730,48730,48697,48697,46649,46649,46649,46617,46617,46617,44569,44569,44569,46649,46649,46681,46682,46649,46649,46617,46649,46617,44569,44569,44569,44569,44537,44569,46649,46649,46649,48697,48697,48697,48730,48729,48730,48730,48697,46584,42423,38197,40278,46649,48730,46649,44536,40311,40343,36150,34037,34005,34004,38197,38164,29745,17067,25422,31792,29713,14890,12810,18986,19019,10696,12777,14922,17003,17035,14922,14922,17036,21261,14857,14857,19180,27794,19310,31825,36019,33938,25421,33873,29647,21196,16937,14824,21228,23276,25421,21195,14824,16937,19050,25454,27599,12744,10598,21162,25355,31760,21196,19115,44471,46649,33873,35986,33906,12744,19082,23308,19083,16970,16969,16969,16970,16970,12711,19049,21163,16937,19050,21163,21196,10566,12711,12679,8485,10598,8485,10630,10598,25421,38164,36051,38099,36019,38131,40277,40277,40212,36019,31793,25421,40245,40277,42358,36019,25486,21227,38099,27567,25421,23309,25454,27534,23308,21163,19082,21163,25421,19050,16904,16872,16969,21228,19082,27534,29680,42390,46584,52891,52891,50810,50842,50777,33938,23341,14824,128},
{55036,55004,55004,55036,55036,55004,55003,55004,55004,55004,55004,55004,55004,55004,55003,55003,55003,55003,55003,55003,55004,55003,55004,55003,55004,55004,55004,55003,54971,54971,54971,55003,52955,54971,52923,52923,52923,52923,52923,55004,55003,55003,54971,52923,55003,54971,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,50843,50842,50810,50810,50810,48762,48730,48730,48730,48730,48730,46649,46649,46649,46617,46617,44569,44569,46617,48729,48697,48697,46649,46617,46617,46617,44569,44569,44536,44536,44536,44536,44536,46616,46617,46617,46617,46617,46617,46617,48697,48697,46617,44471,40310,36084,42391,46649,46617,46616,46584,44504,42358,36052,31891,36085,34004,36117,38164,40245,31793,17034,25422,29680,21260,23342,23374,25454,25487,23406,23374,25454,25455,23406,25455,23406,27567,29648,23342,14857,23308,29907,21487,29680,33873,40244,29615,44438,44405,23309,16937,10566,19083,21228,21228,21196,19018,14856,19115,23341,25454,10631,8550,21098,29549,33905,19115,19115,40278,44471,33840,38098,36018,19115,27534,29713,25454,25422,25454,29647,27534,29647,27501,33873,40277,25454,19082,21130,19050,10598,12711,12711,10598,12743,8485,10598,10598,23308,38132,38164,40277,42357,42325,40245,40277,42358,40245,36018,25454,38164,40277,40245,38132,33905,23308,38099,31760,29647,21195,21163,25421,19083,14857,14824,19017,25421,16937,10598,10598,16969,23308,14856,29647,29647,35987,48730,50842,52891,50810,52923,40213,38099,21163,12743,129},
{55004,55004,55004,55004,55036,55004,55004,55004,55004,55004,55004,55004,55004,55004,55004,55004,55004,55004,55004,55036,55003,55003,55004,55004,55004,55036,55004,55003,55003,54971,55003,55003,54971,54971,52923,52923,52923,54971,48729,38131,36050,36018,35986,35986,35953,35953,35953,33841,33841,33841,31792,33872,33840,31760,31792,31760,31727,29679,29679,29647,27567,27567,27567,27534,27599,27567,27567,27534,27534,25454,25454,25454,25421,25421,25454,25421,23373,23373,23341,23341,23341,23308,23309,23308,21228,21228,21196,21228,21228,21196,21196,21195,21228,21195,21195,19115,21163,19115,19115,19115,19082,19083,19115,19083,19082,17002,17002,16970,17002,16937,14889,16970,16969,14889,14824,14824,14824,12744,14824,14824,12712,12776,12776,12744,12744,12744,12744,12744,12711,12712,12744,12743,12743,12711,12743,12711,12679,10631,10630,12711,12711,12679,10630,12679,10598,10598,10598,10598,10631,10631,10631,10598,10566,10566,10598,23276,23374,12711,10631,23308,33840,33906,19083,19050,42358,42390,27533,36019,36084,10630,21228,29712,19115,17002,16969,17002,16970,33873,40244,44470,35986,33906,23276,19049,21163,10598,10598,12711,10630,12776,10565,10598,8485,21195,38131,38132,40244,40277,42326,42358,42390,42390,40245,36018,27534,38132,40245,40245,38132,33938,23276,36018,29647,29647,21228,19050,23308,21163,14824,14824,19050,25421,16969,10630,10598,21163,21163,14824,31760,42325,48665,50842,50810,52891,52891,52923,31760,35986,19050,12679,128},
{55004,55004,55004,55004,55036,55004,55003,55036,55036,55004,55004,55036,55036,55036,55036,55036,55036,55036,55004,55004,55004,55004,55004,55004,55004,55036,55036,55036,55003,55003,55003,55003,54971,52923,52923,52923,52923,55036,40212,14857,14889,14889,14889,14889,14856,14856,14857,14857,14856,14856,14856,14857,14857,14857,14856,14824,14824,14856,14857,14824,14824,14824,14857,14824,14824,14824,12776,12744,12776,12776,12744,12711,12711,12744,12744,12744,12744,12776,12776,12744,12744,12744,12776,12776,12744,12744,12744,12744,12711,12712,12711,12711,12744,12712,12679,10663,10631,10631,10631,10599,10631,10631,10631,10631,10631,10631,10631,10598,10599,10598,10598,10598,10598,10598,10598,10598,10598,10598,10598,10598,10598,10598,10598,10598,10566,10566,10598,10598,10566,10598,10598,10630,10598,10598,10598,10598,10566,10566,10566,8518,8518,8486,10566,10566,10566,10598,10598,10598,10598,10598,12679,10598,10566,10566,10566,29648,25454,10631,14857,33905,27468,33905,19115,21163,40245,38099,31695,36019,36084,12711,21195,29713,19115,17002,17002,16970,23308,31760,40212,25389,23308,27502,25421,23307,25389,10598,12679,12711,10663,16969,10598,12711,8517,21195,38164,36051,38099,38131,38132,40277,40277,40277,38099,33873,25421,38099,40277,25421,12743,14824,14823,36018,29679,27502,14856,14824,21228,21195,12743,12743,14889,23341,16969,10566,12678,25454,12744,12711,25486,38164,46584,52891,50810,52923,52923,48697,31761,27534,14824,12711,113},
{55003,55003,55003,55004,55004,55004,55004,55036,55036,55004,55004,55036,55036,55036,57084,55036,57084,57084,57084,55036,55036,55004,55004,55036,55036,55036,57084,55036,55003,55003,55003,52955,52955,52923,52923,52923,52923,55036,36019,14825,14857,14857,14857,14857,14857,14856,14824,14857,14857,14857,14857,14824,14857,14824,14824,14824,14857,14857,14857,14857,14857,14824,14856,14824,14857,14824,14824,14825,14824,14824,12744,12744,12744,12776,14824,12776,12776,12776,12744,12744,14824,12776,12776,14824,14824,14824,12776,12744,12744,12744,12744,12744,12744,12712,12744,12711,12711,12711,12711,12711,12712,12744,12712,10631,10631,10631,10631,10599,10599,10599,10598,10598,10598,10598,10599,10598,10598,10598,10598,10598,10598,10599,10598,10598,10598,10566,10598,10598,10566,10598,10598,10630,10598,10598,10598,10598,10598,10566,10566,8518,8517,8485,10566,10566,10566,10566,10598,10598,10631,10598,10631,10598,10566,10566,8518,23309,23406,10631,16937,29647,27403,33840,17002,19083,33906,38033,33840,33938,36084,12743,19082,27600,19115,17002,17002,23309,29680,33873,38164,21195,14824,16969,29647,25388,19082,16970,21195,14824,10566,12711,8485,10598,10631,19114,38164,25453,16937,19050,16936,33873,42390,31792,10598,12678,12743,36051,42325,23308,6372,10565,10630,35986,29680,25453,14824,12743,21195,29647,25454,23308,23308,25486,23341,21228,21227,23373,14824,14856,29647,38164,50778,50842,50810,52923,52956,44438,33873,16970,16937,25356,110},
{55003,55003,55003,55004,55003,55003,55003,55004,55036,55036,55036,55036,55036,55036,57084,57084,57084,57084,57084,55036,55036,55036,55036,55003,55004,55036,55036,55004,55003,55003,55003,55003,55003,52923,52923,52923,52923,55036,35986,14856,14889,16937,14889,14889,14857,14856,14856,14857,14856,14857,14857,14857,14824,14824,14824,12776,14824,14824,14824,14824,14824,12744,12776,12776,12744,12776,14824,14824,14824,12744,12744,12744,12712,12744,12744,12744,12744,12744,12744,12744,12744,12744,14825,14824,14824,12744,12744,12776,12744,12744,12744,12744,12744,12744,12744,12711,12711,12711,12711,12679,12712,12712,12712,12711,10631,10631,10631,10631,10631,10599,10631,10599,10598,10598,10599,10598,10598,10598,10599,10598,10598,10599,10598,10566,8518,10566,10598,10566,10566,10598,10598,10598,10598,10598,10598,10598,10566,10566,10566,10566,10566,8485,10566,10566,10566,10598,10598,10598,10598,10631,12679,10598,10566,10566,8517,21163,23406,10631,12711,21195,25323,19082,14824,19115,42292,40146,35920,33938,38164,12776,19115,29680,19115,16970,16969,16970,16969,31760,42325,38132,38099,31792,29646,25388,16970,12711,16969,14857,8485,8485,8517,10630,12743,19082,40212,25389,12711,12743,12711,31793,44471,33873,8452,10565,12678,36019,42358,33873,25421,21227,16937,31792,25486,23308,23276,19082,25421,38164,38164,36019,33905,29745,31825,29647,27567,25486,14856,21195,25454,36019,52891,48730,50810,55004,55004,38132,33873,16937,21195,23308,113},
{55003,55003,55003,55004,55003,55003,55004,55004,55036,55036,55036,55036,57084,57084,57084,57084,57116,57116,57116,57116,57084,57084,57084,57084,55036,55003,55036,55004,55004,55003,55003,54971,55003,54971,52923,52923,52923,55036,33873,14889,16969,16970,16937,16970,16937,14857,16937,16937,16937,16937,14857,14889,14857,14824,14889,14889,14857,14857,14857,14824,14825,12776,12776,14824,12776,14824,12744,14824,12776,12744,12744,12711,12711,12744,12744,12744,12744,12744,12744,12744,12744,12744,12744,12744,12744,12776,14824,12744,12744,12744,12712,12744,12744,12744,12711,12711,12711,12711,12711,12711,12711,12712,12711,10663,10631,10631,10631,10631,10631,10631,10599,10599,10631,10599,10598,10598,10598,10631,10599,10598,10631,10599,10598,10598,8518,8518,10566,10566,10566,10598,10598,10598,10598,10598,10598,10598,10598,10566,10566,10566,8485,8485,8485,10566,8485,10566,10598,10598,10598,10631,10631,10598,10566,10566,8485,21195,23341,10631,10631,21163,23243,16936,14824,19082,42291,42259,35920,33938,36116,14856,21163,31793,19115,17002,14889,14857,16937,31760,40212,31792,31793,27566,27533,23243,19050,10631,14792,14824,8485,10630,10630,10630,10630,17001,38164,33905,29679,31760,31793,38132,44470,40245,31760,27567,23341,35986,38132,38164,40212,29712,27566,38131,23275,21195,25388,29647,40245,42325,38132,36051,36051,33906,33938,31793,25421,25486,16969,21195,12743,40212,52923,48730,50842,50810,35987,27534,27567,14792,27567,29647,114},
{55003,55003,55004,55004,55004,55003,55004,55004,55036,55036,55036,55036,57084,57084,57084,57084,57116,57116,57116,57116,57084,57084,57084,57084,55036,55003,55003,55004,55036,55036,55004,55004,55004,55004,55004,55004,55036,57116,31793,14857,16970,16970,16937,16970,16969,14889,16937,16937,14889,16937,16937,16937,14889,14857,16937,14889,14857,14857,14857,14857,14857,14857,14824,12776,14824,14825,14824,14824,12744,12776,12744,12711,12711,12744,12744,12744,12744,12744,12744,12744,12711,12743,12744,12711,12711,12712,12711,12744,12744,10631,12679,12711,12711,12711,12711,12711,12711,12711,12711,10631,12711,12711,12711,10631,10631,12679,10631,10631,10631,10631,10598,10631,10631,10598,10598,10598,10598,10598,10598,10598,10599,10631,10599,10598,10598,10598,10598,10598,10566,10598,10598,10598,10598,10598,10598,10598,10598,10598,10566,8518,8485,8485,8485,10566,10566,10566,10598,10566,10598,10631,10631,10598,10566,10566,8485,19115,29680,29648,27567,21195,23210,16872,16937,27534,38065,42323,35920,33906,38164,14856,19082,27632,19115,16970,14889,19050,25454,33906,38099,19050,16969,14824,27501,25388,21260,21261,25421,16937,8518,12711,14856,14856,10630,16969,38066,38099,38131,40244,40212,42325,42357,42325,42325,36051,33906,42357,44471,44438,42358,40245,42325,33841,19082,23275,31727,38099,38099,31728,31760,33938,38164,36051,38132,38164,23373,25486,19050,16937,16937,48697,50842,48730,52891,52923,31793,25389,16937,12711,27534,29647,111},
{55003,55004,55004,55004,55035,55004,55004,55036,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57084,57084,57084,55036,55004,55004,52890,48664,48664,48664,48664,48632,46584,48632,46551,44438,44471,25422,14857,16970,16970,16937,14857,14889,14857,16937,14857,14857,14857,14857,14889,14857,16937,14857,14857,14857,14857,14824,12776,12776,14824,14824,14824,14824,14824,14824,12744,12744,14792,12712,12711,10631,12711,12711,12711,12711,12744,12712,12711,12711,12711,12712,12711,12711,12711,12711,12711,12711,12711,10631,10631,10631,10663,10663,10631,10598,10631,10631,10631,12679,12679,12679,10599,10599,10631,10598,10631,10631,10631,10631,10630,10630,10598,10598,10598,10598,10598,10598,10598,10599,10598,10599,10598,10598,10598,10598,10566,10566,10598,10566,10598,10598,10598,10598,10598,10598,10598,10566,10566,10566,10566,10566,10566,10566,10566,10598,10566,10598,10598,10598,10598,10566,10566,8485,16937,29745,40278,42423,29680,23307,16936,23210,27534,38033,44372,35920,33874,38197,14824,17002,27599,19082,16969,16969,16969,21163,31760,38131,29647,29615,25389,25388,27469,21196,23374,27566,19082,8517,8517,10598,10663,10598,23275,48631,48663,48663,50744,50744,50744,50777,50777,48696,48664,50744,52890,50809,50777,50777,48696,42325,29647,21162,23308,31792,33905,23243,18984,19049,27534,36051,31793,14792,12711,23341,27599,21195,10566,21196,52891,50810,50810,50810,52891,31793,27566,12711,21163,33873,33873,149},
{55003,55004,55004,55004,55004,55036,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57084,57084,57084,57084,55004,55004,55036,29615,10598,10631,10630,10630,10630,10630,10598,12711,12711,12711,16937,16937,16969,16969,14889,14889,14857,14857,14857,14857,14856,14856,14857,14889,14857,14857,14889,14889,14857,14824,14824,14824,14824,14824,14857,14824,12744,12744,12744,12776,12776,12744,12711,12711,12711,12712,12744,12744,12744,12744,12744,12744,12744,12744,14824,12744,12744,12776,12744,14824,14824,12744,12744,12744,12776,12776,12776,12744,12711,12711,12711,12679,12711,12712,10631,12679,12711,12711,12711,12711,12679,10631,10631,10631,10631,10663,10631,10599,10598,10598,10630,10599,10598,10599,10598,10566,10598,10599,10598,10598,10598,10598,10598,10598,10598,10566,10598,10599,10598,10598,10598,10598,10598,10598,10598,10598,10566,10598,10598,10598,10566,10566,10598,10598,10566,10566,10566,10598,29680,38197,36084,29647,29614,16936,27534,27534,38065,44371,35952,31825,38164,14824,19050,29712,19115,14889,14889,14824,12711,29647,38132,35986,33938,29680,21195,27501,19083,19147,25421,23341,14889,21260,21292,12776,10598,27533,54969,54937,54937,54937,54937,54937,54970,54937,50776,50776,46485,33873,29647,29614,29582,27502,40212,31792,29647,23275,31760,36018,23275,14791,14758,21162,38164,31825,10630,10566,23341,29647,23341,10598,25421,52923,50810,48730,50810,40277,21228,29647,14824,23244,25421,31793,171},
{55003,55003,55004,55004,55036,55036,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,55036,55003,55036,44471,14856,8518,8518,8485,8518,8518,8518,8518,10598,14857,14857,16970,14857,16970,17002,14857,16937,16937,14824,14857,14857,14857,14857,14824,14825,14824,14825,14857,14824,14824,14824,12744,14824,14824,14824,12776,12744,12744,12776,12744,14824,12776,12744,12711,12711,12711,12744,12744,12744,12744,12744,12744,12743,12744,12712,12712,12712,12711,12712,12712,12744,12744,12712,12712,12711,12712,12744,12712,12711,10631,10631,10631,10631,10663,10631,10631,10631,10631,10631,10631,10631,10631,10631,10630,10631,10599,10598,10598,10598,10599,10598,10598,10599,10631,10631,10599,10598,10598,10598,10598,10598,10598,10598,10598,10566,10566,10566,10598,10599,10598,10566,10566,10566,10566,10598,10598,10598,10566,10566,8518,8517,10566,10598,10598,10566,8518,10566,8485,10631,27599,38197,38164,25454,23341,12743,16969,29680,40146,44339,35953,31825,38164,14824,16937,27599,17002,14857,14824,14824,19050,29615,35986,16937,12711,14824,23307,27566,16970,16970,23340,23340,17002,25550,21357,10631,8517,38033,54937,52857,54937,54937,52857,52889,54970,52857,50744,50744,29646,10630,8485,8485,6372,12678,44471,33873,27535,19115,25454,27567,23308,19147,19082,21195,36084,33906,12711,10598,23308,29647,25486,10630,27502,52891,48730,44471,50810,29648,14792,19082,14856,21163,29647,31760,185},
{55003,55003,55004,55036,55036,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,55036,55003,55004,55003,33906,14856,8518,8517,8518,8518,8518,8518,8518,8518,8517,10598,23276,21196,23276,23309,21195,21195,21163,19115,19115,19083,19083,19115,19083,19083,19083,19082,19115,19083,19083,19083,19050,19082,19050,17002,17002,19050,19050,16970,16970,17002,17002,17002,16970,16937,14889,16970,16970,16938,16937,14889,16937,14889,14857,14857,14857,14857,14857,14824,14857,14857,14857,14857,14857,14856,14857,14857,14824,12776,12744,12744,12744,12744,12744,12744,12744,12744,12711,12744,12744,12744,12744,12744,12711,12711,12711,12679,12711,10631,10631,10631,10631,12679,10631,10631,10631,10631,10599,10598,10631,10598,10599,10631,10599,10598,10599,10598,10599,10599,10599,10599,10598,10631,10598,10630,10598,10598,10598,10598,10566,10566,10566,10598,10566,10566,10566,10566,8485,10598,27599,40277,36084,27599,23341,12711,21163,27534,33839,44371,33839,31825,38197,14824,14857,25454,16937,14824,12711,12711,19050,25421,31760,19082,16937,16937,29581,21194,16970,16937,23276,21163,25388,29679,27566,23276,25388,48598,54970,54937,54937,54970,54937,54937,52889,52824,50743,48631,31695,21195,21195,23243,21130,27502,46551,27567,23309,23309,23308,21260,21261,21261,21228,19147,36052,36019,14824,8485,19082,27567,23341,12711,27502,52891,48697,46584,46552,21195,16937,23276,16969,19050,36018,38099,191},
{55004,55004,55003,55036,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,55003,55003,55004,55004,38099,14824,8518,10598,10598,10598,10566,10598,10598,10566,10598,10598,21196,21195,21228,23308,19083,19083,19083,19082,19083,19050,19050,19050,19050,19083,19082,19050,19083,19083,17002,17002,19083,19082,19083,17002,17002,17002,19082,19083,17002,16970,16970,16970,16937,14889,14889,16970,16970,16970,16970,17002,16970,16937,14889,14889,14889,16938,14889,14857,14889,14889,14889,14857,14857,14857,14857,14857,14857,12776,12744,12744,12744,12744,12744,12712,12712,12744,10663,12711,12711,10663,12711,10663,10631,10631,10631,10631,10631,10631,10631,10599,10598,10631,10599,10631,10631,10598,10598,10598,10599,10599,10631,10598,10598,10598,10599,10598,10598,10598,10598,10599,10598,10599,10598,10598,10598,10598,10566,10566,10566,10566,10566,10566,10566,10566,10566,10566,8517,10566,25454,40310,36084,23374,23308,14824,16970,27566,35920,42291,33872,38132,38197,14856,16937,31825,21228,23308,27535,27502,27534,21195,29647,38164,40244,38132,29613,19082,16970,14857,21196,29679,54969,54970,54970,55002,52856,52824,50744,52856,54970,52857,50711,48631,48630,50744,50744,48663,46550,46550,44405,42292,35986,35986,29680,23308,23341,23309,23309,23308,23308,21260,21228,19115,31793,33938,31793,21228,23341,27567,16969,14824,25454,52891,50778,52891,40213,25389,21163,19082,19050,19082,38131,44438,171},
{55004,55004,55004,55036,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,55004,55003,55036,55003,44471,19082,10598,10598,10598,10598,10598,10599,10598,10598,10599,10598,21196,21196,21228,23308,21195,21196,21195,21163,21195,19115,19083,19115,19083,19083,19115,19083,19115,19083,19082,19082,19050,19050,17002,17002,16970,16970,16970,16970,16970,14889,14857,14889,14857,14857,14857,14889,14889,14889,14889,14889,14889,14857,14857,14857,14857,14857,14857,14825,14889,14857,14889,14857,14857,14857,14889,14857,14857,14856,14824,12744,12744,12744,12776,12776,12744,12744,12744,12744,12744,12744,12744,12744,12711,12711,10631,10663,10663,10631,10631,10631,10631,10631,10599,10631,10631,10598,10598,10598,10598,10631,10631,10599,10598,10598,10599,10598,10598,10598,10598,10598,10598,10598,10598,10566,10598,10598,10566,10566,10566,10566,10566,10566,10566,10566,10566,10566,10566,8485,23374,40278,38165,23341,23341,12744,21163,29679,38065,40146,36018,42390,38197,14857,23276,40244,25389,29647,42357,44438,44438,29614,29679,40244,40245,38164,29646,21195,16970,14857,19115,38098,57050,54970,54937,54937,46485,44372,44372,48630,55002,48631,42259,40179,40179,48663,48696,46550,44405,42324,40179,38098,29679,31760,19083,21260,23341,23341,23308,23308,23308,21260,21228,19082,31825,33971,27632,33971,31793,25454,14792,21163,29647,52891,50810,52923,31793,33873,27567,27534,21163,25421,38099,44471,172},
{55004,55004,55004,55036,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,55003,55003,55036,55003,42358,19082,8518,8518,8518,10598,10598,10598,10598,10598,10598,10598,19115,19115,21196,23309,21163,21196,21196,21163,21196,21195,19115,19115,19083,19083,19083,19083,19083,19083,19050,19050,19050,19050,19050,19051,19050,19050,19050,19050,16970,16970,16970,16970,16937,16937,16937,16970,16938,16970,16970,16969,16970,16937,14889,14889,14889,14857,14857,14857,14857,14825,14857,14857,14824,12776,14824,12776,12776,12744,12711,12711,12711,12711,12744,12744,12744,12744,12744,12744,12712,12744,12744,12712,12711,12712,12711,12711,12711,10631,10663,10631,10631,10631,10631,12679,10631,10631,10631,10599,10631,10631,10599,10599,10598,10599,10598,10598,10598,10598,10598,10598,10599,10598,10598,10598,10598,10566,10566,10566,10566,10566,10566,10566,10566,10566,10566,8485,8485,10631,21228,25454,31793,23309,23341,14857,14857,31759,38098,35952,40212,42391,40245,14857,19017,36018,27566,29647,38163,42325,42357,29647,29614,38131,40244,38131,29581,23276,16970,12776,19082,44372,57050,54969,54937,54937,55002,57083,57115,57083,57050,57050,55002,54970,52889,50776,48663,44437,42292,40211,36018,35985,36018,29648,16937,27567,21260,21228,23308,21260,21228,21228,21228,16969,29712,31793,23308,12743,19083,27534,14792,21196,29647,50843,52891,48697,33906,29712,31793,33873,25453,29679,38132,46551,175},
{55036,55036,55036,57084,57116,57116,57116,57116,57148,57116,57116,57116,57148,57148,57116,57116,57116,57116,57116,57116,57084,57084,55003,55003,55003,55004,44471,19083,8518,8518,8518,10566,10566,8518,8518,10598,10598,10598,19115,21195,21228,23308,21163,21163,21163,21163,21163,19115,19083,19083,19082,19082,19082,17002,17002,17002,17002,17002,16970,16970,16970,16970,16970,16969,16970,16970,16970,16970,16937,16969,16937,14857,14857,16937,16970,16970,16970,16970,16937,16937,14889,14889,14889,14889,14889,14857,14857,14857,14857,14857,14857,14857,14857,14824,14825,14824,12776,12776,12744,12744,12744,12744,12744,12744,12744,12712,12711,12711,12711,10631,10631,10631,10631,12711,10631,10631,10631,10631,10631,10631,10599,10631,10631,10598,10566,10566,10599,10598,10598,10598,10598,10598,10631,10598,10598,10598,10598,10598,10598,10599,10598,10566,10598,10598,10566,10566,10566,10566,10566,10566,10566,10566,10566,8518,8518,10631,16937,10598,10631,25421,23309,14889,23276,31760,36018,33905,42358,42391,40278,16970,12711,33905,29647,27534,42324,40244,42325,31760,29646,40211,40244,38131,29581,23275,16970,12744,21195,50744,57083,57050,55002,54970,57083,54937,40179,42259,40179,40179,40211,38033,35953,35953,33873,40211,42292,40179,36017,33905,35986,19115,21195,29680,23341,21228,21228,21228,21195,21195,21195,16937,29712,36019,23276,12711,16905,29615,14792,21195,27567,52891,52923,44439,42390,27567,31760,33906,29679,35986,42358,44503,170},
{55036,55036,57116,57116,57116,57116,57116,57148,59197,59197,59197,59197,59197,59197,59197,57148,57116,57116,57116,57084,57084,57084,55004,55003,55004,55036,46551,19050,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,19115,21228,21196,23309,21195,21163,21163,19115,21163,19115,19083,19083,19082,19083,19083,19083,19082,19050,19050,19082,19050,19050,19050,17002,17002,17002,17002,17002,16970,16970,16969,16937,16937,14857,14857,16937,16937,14889,14889,14857,14857,14857,14857,14857,14857,14857,14857,14857,14857,14857,14857,14824,14824,14824,14824,14856,14857,14857,12776,12744,12744,14824,12776,12744,12744,12744,12744,12744,12744,12711,12744,12711,12711,12711,12711,12711,12711,12679,12711,10631,10631,10631,10631,10631,10631,10598,10598,10598,10599,10598,10598,10598,10598,10598,10598,10566,10598,10598,10598,10598,10566,10566,10566,10566,10598,10566,10566,10566,10566,10566,10566,10566,10565,10566,10566,10566,8517,8485,8485,8485,10598,25389,23309,16937,21195,29679,33937,38131,42390,42391,38165,19082,14856,44438,35921,38066,50776,50744,52825,38067,27501,40211,40212,38099,29613,23276,16970,12711,16937,42324,44405,44405,46485,46518,44405,31728,6372,8452,8517,10630,10630,8550,8518,8517,14856,29614,29647,27534,27533,27534,29647,14824,21195,29615,23341,23341,33906,33906,33905,33905,33905,31825,36018,38164,25454,25421,23341,31760,14824,21196,25389,52891,52923,29615,31728,27567,29680,33873,29679,40244,46551,44471,179},
{55036,57084,57116,57116,57116,57116,57116,57148,59197,59197,59197,59197,59197,59197,59197,59197,59196,57116,57116,57116,57084,57084,55036,55036,55036,55036,42358,14856,8518,8518,8518,8518,8518,8518,8518,8518,8518,8485,19050,21196,19115,19115,19083,19083,19083,19083,19115,19115,19083,19082,19050,19050,19050,19083,19083,19083,19082,19083,19083,19083,19082,17002,16970,17002,17002,19050,16970,16970,16970,16970,16937,14857,14857,16938,16970,16937,14889,14857,14857,14857,14857,14857,14857,14857,14857,14857,14857,14857,14857,14824,14824,12776,14825,14857,12776,12776,12744,12744,12744,12744,12744,12712,12712,12711,10663,12712,12711,10663,12711,10631,12711,10631,10631,10631,10631,10631,12679,10599,10599,10599,10599,10599,10631,10599,10598,10598,10599,10598,10598,10599,10598,10598,10598,10566,10598,10598,10598,10598,10566,10566,10566,10598,10598,10566,10566,10566,8485,8517,10566,8485,8517,8517,8485,8485,8517,8517,10566,8485,10566,23276,23341,16937,19082,25486,31792,40245,42391,42391,33938,14856,23276,48663,42292,50744,48598,50711,52824,40179,27469,42292,42325,40212,33774,23276,16970,12711,8485,8485,8485,8485,10566,14889,12743,10630,10566,10598,12711,12776,10695,10695,10663,10631,14856,8420,6372,6372,8485,12678,25389,14824,21162,27534,23309,29679,42325,40245,42292,42292,40244,40277,40212,38132,27567,23341,21195,31760,19050,23308,23276,52891,48665,29680,33905,27534,31760,31760,27566,46551,48664,48696,191},
{57084,57084,57084,57116,57116,57116,57116,57148,59197,59197,59197,59197,59197,59197,59197,59197,59197,57116,57116,57116,57084,55036,55035,55036,55003,55004,42357,12744,8518,8518,8518,8518,8518,8518,8518,8517,8518,8453,21228,29647,27534,27535,25454,27535,27535,25422,25454,25454,25454,25389,23341,23341,23341,23374,25422,23341,23341,23341,21261,23309,23341,21228,23341,23309,21228,21228,21228,21228,21228,21228,21228,21228,21196,21196,23309,21260,21196,21196,21196,19115,19147,19147,19115,21196,19115,21195,19115,19115,19115,19115,19083,19083,19050,19083,17002,16969,16937,16969,16970,16937,14889,14857,14857,14857,14857,14857,14857,14857,14857,14857,14857,14857,14824,14857,14856,14856,14857,14857,14824,14857,14857,14857,14857,14824,14824,14824,14824,14824,14824,14824,14824,14824,14824,14824,14824,14824,14824,14824,14824,14824,14824,12776,14824,14824,12744,12744,12744,12743,12744,12744,12744,12776,12744,12744,10598,10598,10598,10598,10598,21163,23308,12776,14824,25421,33906,42358,40310,40278,27567,12711,35953,46550,44372,50711,42291,44404,48598,40146,42259,44405,42292,40179,35920,21195,16970,10631,8485,8485,8485,8485,10598,17066,19212,17034,8518,8518,12744,14857,12776,12744,10663,10663,12711,6372,8453,8453,10565,12743,27534,14889,25388,29647,23309,33873,38131,40244,40212,40244,40244,40244,40212,38164,31760,27567,23341,29680,25422,23309,19083,50810,40245,25453,19082,25421,29647,31760,31792,48697,46584,48697,192},
{55036,55036,57084,57116,57116,57116,57116,57148,57148,59196,59197,59197,59197,59197,59197,59197,57148,57116,57084,55036,55036,55036,55003,55003,50810,50810,38164,12744,8518,10598,10598,10566,8518,8518,8518,8518,8518,8517,10631,14824,14824,12744,12744,12744,12743,12711,12711,12711,12743,29680,29679,27535,27534,25454,25454,25422,23373,25454,25453,25421,25454,25454,27535,25486,25421,25454,25454,27566,25486,25454,27567,25487,25486,25454,27534,25486,25486,27566,27566,25454,25454,25454,25486,27534,27566,27566,27534,27566,27534,25454,27566,27566,27566,27566,25486,25454,25454,25453,25486,25486,25453,25421,25421,25453,23373,23341,23373,25421,25454,25454,25421,23373,23373,25421,25389,25421,25421,25421,25389,25421,25421,25453,25389,25388,25388,25388,25421,25421,25421,23308,23308,23276,23341,23340,23340,23340,23340,23340,23340,23340,23308,23308,23276,23276,21228,21227,21228,21195,21195,21163,21195,21228,21228,19115,8485,8485,8485,8485,8485,16969,21228,14824,14857,25486,27632,40277,42390,36084,19082,16904,44404,46485,48598,48598,44404,46485,46517,38065,44405,42291,42259,42259,29581,19049,17002,10598,8485,8485,8485,8485,10598,14954,17034,10598,8485,10566,12743,12776,12776,12711,10630,10630,14889,12744,8453,8485,8517,12711,25454,14856,23308,27566,21228,29647,33873,40244,40212,40212,40212,40212,40212,38132,33938,27599,21195,29680,29647,21163,16970,46584,31792,23308,19050,25421,31760,31825,42357,46583,44471,48664,164},
{55036,55036,57084,57116,57116,57116,57116,57116,57116,57116,59197,59197,59197,59197,59197,59197,57116,57084,55036,55004,55004,55003,55003,52955,52955,55003,40244,14889,10598,10631,10631,10631,10598,10631,10599,10598,10631,10599,10598,10598,10598,10598,10598,10598,10566,10598,10598,10566,10566,19083,14857,14857,14857,14824,14824,14792,12744,14824,12776,12744,12744,14792,14792,14824,14824,12776,12776,14824,12744,12744,14824,12744,12744,14792,14792,12743,12744,14824,14824,12743,12744,12744,12744,12743,14792,12776,12744,12744,12744,12744,12744,12744,12744,12744,12743,12711,12711,12711,12743,12711,12711,12711,12711,12711,12711,10631,12679,12711,12711,12711,12711,12679,12679,12679,12679,12711,12679,12679,12679,12678,12679,12679,10631,10598,10598,10630,10630,10630,10630,10598,10598,10598,10598,10598,10598,10598,10598,10598,10598,10598,10598,10598,10598,10566,10598,10598,10598,10566,10566,10566,10566,10566,10566,8518,8485,8485,8485,8518,8518,12744,23341,14824,14857,25454,27567,36084,42390,31825,14824,25388,48598,44372,50743,44372,44404,48598,42291,42291,44404,42259,44340,38066,23242,19050,14890,10598,8485,8485,8485,8485,10663,19244,19212,12743,8485,10598,12808,14889,12808,12743,10630,12743,14889,19115,25388,27501,25454,25421,25421,14824,23340,29712,25389,25421,31792,40244,40244,40244,40244,40212,40212,38132,33971,27567,16937,29680,21163,21163,19082,38067,25453,23308,21130,27566,31825,29679,42357,42390,42390,46616,93},
{55036,55036,57084,57084,57116,57116,57116,57116,57116,57116,57148,59197,59197,59197,59197,59197,57116,57084,55004,55003,55003,55003,55003,52955,52923,52923,38164,21260,10631,10599,10599,10599,10598,10631,10631,10599,10631,10599,10598,10630,10631,10630,10631,10631,10598,10598,10631,10598,10631,14889,10631,10631,10631,10631,10631,10631,10631,10630,10630,10598,10630,10631,10631,10630,10598,10631,10631,10631,10631,10598,10598,10598,10598,10630,10631,10631,10630,10598,10631,10598,10598,10598,10631,10631,10631,10599,10599,10598,10598,10598,10598,10598,10599,10598,10598,10598,10566,8518,8518,8518,10566,10566,10566,10566,8518,8518,8518,8518,10566,10566,8518,10566,8518,8518,8518,8486,8518,8518,8518,8518,8518,8518,8518,8486,8486,8518,10566,8485,8518,8518,8518,8518,8486,8485,8485,8517,8485,8485,8486,8518,10566,8485,8517,8518,8518,8518,10566,8517,8518,8518,8517,8485,8485,8485,8485,8485,8485,10566,10566,10566,14857,21260,14889,25454,27599,33971,40245,25486,12743,38066,48598,44372,50711,44372,46485,48598,40113,46485,44404,42226,42291,31695,23210,19049,14890,10598,8485,8485,8485,8485,12711,19212,19212,19180,10695,10631,14856,14889,14889,12776,10663,12775,17001,27501,35986,36018,36018,29712,27502,14824,25421,33905,31760,16969,29647,33970,33938,33938,33938,33938,31858,29712,25487,25454,16970,29680,16969,23308,19050,27599,27534,25389,25453,31825,29712,31760,44503,44470,44503,44438,100},
{55004,55036,57084,57084,57116,57116,57116,57116,57116,57116,57116,59197,59197,59197,59197,59197,57116,55003,55003,52955,52955,52955,52955,52955,52923,52923,42390,21228,10598,10599,10598,10599,10598,10598,10598,10599,10631,10598,10598,10630,10598,10598,10598,10630,10598,10630,10631,10598,10630,16970,16937,14857,14857,14857,16937,16905,14856,14889,14857,14857,14857,14856,14889,14857,14824,14857,14856,14856,14856,14824,12744,14824,14856,14857,14857,14857,14857,14889,14857,14857,14857,14856,14857,14824,12776,12776,14824,12776,12776,12776,12744,12744,12744,12744,12744,12712,12711,10631,10631,10631,10631,10631,10631,10631,10631,10598,10599,10598,10599,10599,10598,10598,10566,10598,10598,10598,10598,10598,10599,10598,10598,10598,10598,10566,10566,10598,10598,10566,10566,10598,10598,8518,10566,10566,10566,10598,10566,10566,10566,10566,10566,10566,10566,10598,10598,10598,10566,10566,10598,10566,10566,10566,10566,8485,8485,8485,8485,10566,10566,10598,10598,14824,19115,21196,21228,27534,31761,21163,23275,46550,44405,50744,48598,46517,48598,44404,40146,46453,42259,42259,40179,29614,25323,19049,14857,8517,8485,8517,8485,8485,10663,14889,10663,8517,10598,10598,12743,10695,10663,10630,10598,10598,14856,25389,21195,23308,21162,21195,29647,16937,25453,36051,33873,23308,31857,33938,33938,33938,33938,33938,31825,29680,23406,23374,16970,25486,21195,25389,16969,29647,27534,25421,27501,31792,33873,38099,44471,42358,48664,29647,88},
{55004,55004,55036,55036,57084,57084,57116,57116,57116,57116,57116,59196,59197,59197,59196,57116,55036,55003,52955,52923,52923,52923,52923,52923,52923,55004,33874,19115,10599,10631,10631,10631,10598,10598,10599,10598,10631,10598,10598,10631,10598,8518,10598,10631,10598,10630,10631,10598,10598,17002,16970,17002,16970,16970,16970,16970,16969,16969,16969,16969,16937,16937,16970,16969,16937,16969,16937,16937,14889,14857,14856,14824,12744,14824,14857,14857,14824,14857,14857,14824,14824,14824,14824,14857,14824,14857,14825,14825,14857,14857,14857,14857,14857,14857,14824,12744,12711,10631,10631,10631,12711,10631,10631,10663,12711,10631,10631,10631,10631,10631,10631,10631,10631,10599,10599,10599,10599,10598,10599,10598,10566,10598,10598,10598,10566,10566,10598,10598,10598,10598,10566,10566,10598,10566,10598,10566,10566,10598,10566,10566,10566,10566,10566,10566,10566,10566,8518,10566,10598,10598,10598,10598,10598,10566,10566,8485,8485,10566,10598,10598,10598,12711,25454,12744,12744,19017,27566,19082,33840,46485,38066,42292,40146,42259,42291,38065,42259,44404,42227,44339,38065,35953,25290,19017,14857,8517,8485,10598,8518,8485,14856,21293,12776,8485,8518,10631,14889,12808,17034,19082,16937,19082,19115,23308,14824,12678,14791,19050,29647,16969,23308,40277,29615,23341,31858,33938,33938,33938,33939,33938,31858,29713,25454,25486,19083,25486,21195,16969,21195,29647,27534,27501,23275,33905,33937,44470,44470,44470,42325,19049,79},
{55003,55004,55004,55036,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57084,55003,52923,52923,52923,52923,52923,52923,52923,52923,55004,42390,25422,10598,10598,8550,10598,10599,10631,10631,10599,10631,10631,10599,10631,10599,8518,10598,10631,10599,10598,10631,10599,10631,19083,16969,16970,16970,16938,16937,16970,16937,16937,14889,14889,16937,16937,16970,16970,16937,16970,16969,14889,16937,16937,14824,14824,14824,14857,14857,14857,14857,14889,14857,14856,14857,14825,14824,14824,14824,14824,14824,14824,12776,12776,12776,12776,14824,14824,12744,12744,12711,12711,12711,12711,12711,12711,10663,10663,10663,10631,12679,10631,10631,10631,10631,10631,10631,10631,10599,10599,10631,10631,10631,10631,10598,10599,10631,10598,10598,10598,10631,10598,10598,10599,10598,10598,10599,10598,10598,10598,10598,10598,10566,10598,10598,10598,10598,10566,10566,10598,8518,10566,10598,10598,10566,10598,10566,10566,10566,8485,8485,10566,10566,10598,10631,12712,27535,16905,14792,19050,27534,16904,25388,27534,19017,23275,27500,19016,23274,40146,46485,44339,42227,42259,38033,38034,29483,19017,12776,8517,8485,10598,10598,8518,14921,21293,19212,12743,8485,10598,10696,12808,25486,31824,33905,31792,25453,21195,21195,19050,21162,23276,29679,14889,23308,38164,19082,23340,31858,33938,31858,33906,33938,31890,31858,27664,25454,25487,17034,27534,25389,14824,27534,29647,27566,29647,19017,23308,38131,50777,48697,50809,35986,19081,87},
{55003,55003,55004,55036,55036,55036,55036,55036,55036,55036,55036,57116,57116,55036,55036,55003,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,44536,25486,10599,10598,8518,10598,10598,10598,10599,10599,10631,10631,10599,10631,10631,10598,10598,10631,10631,10598,10631,10599,10599,23276,21196,23276,23308,21228,23309,21228,21196,23276,21228,21228,21228,21196,23309,21228,21195,21196,21196,21196,21196,19115,19083,19050,17002,19083,19083,19083,19083,19083,19050,19083,19050,17002,16970,16970,16970,16970,16970,16970,16970,16970,14857,14889,16970,14889,14857,14889,14824,14824,12776,12776,14824,12744,12744,12744,12744,12744,12711,12679,12744,12711,10663,12711,10631,10631,12679,10631,12679,10631,10631,10631,10631,10631,10631,10599,10598,10598,10631,10599,10598,10598,10598,10598,10598,10598,10598,10598,10598,10598,10566,10566,10566,10566,10566,8518,8517,8518,8518,8518,10566,10566,10566,10566,10566,8518,8485,8485,8485,8517,10566,10598,10631,12711,25422,29680,21163,14824,29679,29614,29614,33905,23243,31726,29581,33872,35952,42291,42259,38065,40114,35920,42259,31727,29483,21129,12744,8485,8485,10566,8518,8518,12776,12808,10598,8485,10598,14889,19180,21325,27566,35986,33905,31792,27534,21195,35986,38099,38099,31825,29647,17002,21227,38131,21195,25486,31858,33971,33939,33971,33939,33939,31890,29745,27599,25487,19115,23341,25422,21162,31760,29647,27566,29647,14791,27534,46551,48697,48697,50842,27501,23274,95},
{55003,55003,55003,55004,55004,55004,55004,55004,55003,55003,55003,55036,55036,55004,55003,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,44471,21260,10631,10598,8518,10598,10599,10566,10598,10631,10631,10631,10599,10631,10631,10599,10599,10631,10631,10598,10631,10630,10598,23276,21196,21228,21228,21228,23308,23276,21228,23308,21196,21228,21228,21196,21228,21196,19115,21195,19115,19115,19083,19083,19083,17002,16970,19082,17002,17002,19050,19050,17002,19050,19083,17002,16970,16969,16969,16970,16970,16937,14889,14889,21196,21228,21196,19148,19147,19115,17034,16970,14889,17002,17002,16970,16970,16970,16938,16937,14889,14857,16938,14857,14857,14857,14857,14857,14857,14824,14857,14857,14825,14857,14857,14857,14857,14857,14857,14825,14857,14857,14825,14857,14857,14857,14857,14857,14825,12776,14857,14857,14825,14825,14825,14857,14857,14857,14857,14825,14824,14824,14856,14824,14856,14824,12776,12744,12744,12711,12744,12744,12744,14889,16970,14857,17002,14824,14824,14856,23276,29614,31759,38066,23275,31727,29581,38033,35985,38033,38000,38032,33807,35952,40147,21195,27403,21097,12712,8485,8485,8517,8517,8518,17002,17034,8517,19212,23503,23503,23502,19212,25389,36018,33905,33873,29647,21163,23340,19082,19082,19082,29647,17002,23308,36051,27534,29680,31793,33970,33939,33971,33971,33939,31858,29745,27600,25519,19147,21260,27567,23308,29647,27566,27566,29614,16969,36018,48664,46584,48664,42357,29614,25355,97},
{55003,55003,55003,55004,55003,55003,55003,55003,55003,52955,52955,52955,55003,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,46617,25486,10631,10599,10598,10599,10631,10631,10631,10631,10631,10631,10631,10598,10631,10631,10631,10631,10631,10630,10631,10631,10598,23276,23276,23309,23309,23308,23309,23308,23276,25389,21228,21228,23276,21196,21196,21196,21196,21228,21196,19115,19115,19083,19083,17002,17002,19082,17002,19050,19050,17002,19050,17002,17002,16970,16970,16969,16969,16937,16937,16937,16937,16937,27600,27567,27665,27665,25552,21293,19180,19115,14890,17002,16970,14889,14889,14889,14889,14857,14857,14857,14857,14857,14857,14857,14857,14857,14857,14857,12809,14857,12809,12809,14857,14857,12809,12776,12809,12809,14857,14857,14857,14857,14889,14857,14889,14857,14857,14857,14857,12809,14857,14825,14824,14824,14857,14857,14889,14857,12776,14857,12776,12776,12744,12776,12744,12744,12744,12744,12744,12744,12712,12744,10663,12711,10631,12744,25454,23275,40211,36018,42324,44405,31694,38098,38033,46550,48631,48630,46518,46485,44404,40179,19017,14792,27468,21162,12679,8485,8485,8485,8485,8518,14889,10630,14889,25648,23503,23470,23470,21293,23340,35986,33938,33905,29647,19082,33906,27534,14824,14856,27567,19082,27567,36051,29647,29680,29745,31890,31890,31890,31858,31858,31826,29713,27567,25519,19147,21228,31825,21163,29647,27567,29679,29614,21162,42357,50809,50777,50810,27534,23275,25387,104},
{52923,52923,55003,55003,55003,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52923,52923,52891,52891,52923,52923,52923,50842,36051,10631,8550,8550,10598,10598,10599,10631,10599,10631,10631,10598,10598,10631,10631,10631,10631,10631,10598,10631,10631,10598,23276,23309,23309,23309,21228,23309,23308,21228,23276,21196,21228,23308,21163,21196,21163,21163,21196,21163,19083,19083,19115,19083,17002,17002,19082,19050,19050,19050,19083,19051,17002,16970,16969,16969,16937,14889,14857,14889,14889,14857,16937,19148,17067,21325,25552,27729,14987,19213,19180,17035,19180,17067,14922,14954,14954,14987,12809,12776,12777,10696,12777,12809,14922,12809,12809,12809,12809,12841,12842,12776,14890,14889,10663,10631,12776,14954,12776,12776,12809,12776,12744,12776,12777,14889,12744,10663,10631,12744,10663,12809,14922,14889,12776,10631,10663,12777,14857,12809,12809,10663,10663,10631,12776,10664,12744,10631,12744,10663,10598,10631,10631,10598,10631,10631,10631,23308,29646,38034,40179,42292,35985,40211,40179,44437,46518,46550,46550,48598,44405,25388,10598,8453,14824,27500,23275,10566,8485,8485,8485,8485,8517,10630,8517,19147,27696,21390,21357,21390,19180,21228,33873,31825,31792,25453,19082,29679,27567,23276,21195,27567,27534,29679,38099,29679,29712,29745,33971,33971,33971,33971,33971,31890,29745,29712,27599,21196,23341,23341,12743,29679,29679,29647,27566,23308,46583,48664,48664,44438,23307,29646,25388,114},
{52923,52923,52955,52955,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52923,52923,52891,52891,52891,52891,52891,52891,52923,52891,52891,52923,50778,42326,40245,40245,42325,42325,42326,44406,44406,44438,44438,44438,44438,44438,44439,44439,44438,44438,44438,44438,44471,38099,27567,21228,23308,23309,23276,23309,23309,21228,23309,21196,21196,21228,21196,21196,21195,21195,21163,21163,19115,19115,19115,19083,19050,21196,17002,17002,16970,17002,16970,16970,16970,16970,16937,16937,14889,16937,14889,16937,14889,14889,16969,19180,19212,19180,19245,23439,14922,17100,14986,14954,17002,14889,12776,14922,14922,14922,10664,12744,12777,10696,12776,10663,12777,10663,10631,12776,12841,10696,10664,10631,12809,12744,10663,10631,10696,12809,10663,10663,10663,10598,10631,10664,10599,8550,10663,8518,10598,10663,10631,10663,12777,10664,10631,10631,10631,10598,10631,12776,12776,10598,10631,10599,10631,10631,12744,10631,10663,10631,10598,10598,10631,8550,10598,10598,8486,10599,10599,10631,10566,16937,19082,14824,12711,12743,12679,12678,12679,12711,12711,10598,12679,12679,19018,27501,25355,21163,27534,27501,27533,27501,25453,25421,23340,31824,25616,14921,12743,14824,12679,21228,21195,16937,16969,21163,19050,31760,38099,38099,31792,27567,40212,33905,38099,29712,29680,31793,33971,33971,33971,33939,33939,31858,29745,29680,27600,21228,21228,25389,12711,29647,27566,29615,27566,35953,50810,48697,50809,31727,16968,29646,27468,122},
{52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52891,52923,52923,52891,52891,52891,52891,52891,52923,52891,52891,52891,52891,52923,55003,55004,55036,55036,57116,57116,59197,59197,59197,59197,59197,59197,59197,59197,59197,59197,59197,57149,59197,52890,29680,23276,23276,23276,23309,23276,23309,23309,23276,23309,23276,23276,23308,21195,21196,21195,21195,21195,21195,19115,19115,19115,19083,17002,16970,16970,16970,16969,16970,16969,16970,16970,16938,16937,16937,16937,16937,14889,16970,16970,16970,16970,19148,17067,19180,21293,27697,14954,19148,14922,14987,17035,12809,12744,14922,14954,14922,10631,12841,17067,14955,14955,10696,12841,10631,8551,12777,14922,10663,10663,10631,12776,10631,10631,10631,10696,10728,10663,10663,10663,8518,10631,14857,8518,8550,12744,8550,8550,10663,10598,8550,10664,10696,10631,10631,10631,8518,12744,12776,12776,10599,10631,8518,10598,10631,12776,12744,10663,10663,10631,10598,12744,10630,10631,10631,8485,10631,10631,10566,8485,8453,8453,8485,8485,8453,8453,10631,8517,8518,8485,14824,19050,14824,19082,27533,25388,27501,35985,31792,33840,31759,31759,29678,29678,36050,25648,12743,6339,10630,12678,21260,16937,8517,12678,21195,19082,23308,19017,19017,16904,35986,48697,31793,38099,29712,29680,29745,31858,31858,33938,33939,33906,31858,29745,29680,27600,21228,23373,27567,14791,27534,29647,29647,31792,44470,48664,48664,46583,23275,23275,25420,27501,141},
{52891,52891,52923,52923,52891,52923,52923,52923,52923,52923,52891,52891,52891,52891,52923,52923,52923,52891,52891,52923,52923,52923,52891,52891,52923,52891,52891,52891,52891,52923,52923,52955,55003,55036,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,48632,29680,29680,29647,23276,23276,23309,21228,23341,25421,21228,23341,21228,21228,23308,21196,21195,21195,21195,21228,19115,19115,19083,19083,19050,16969,16969,17002,16970,16970,16970,17002,17002,16970,17002,17002,16970,16970,17002,16970,17002,17002,16970,16970,25487,23439,23438,23503,25584,17100,19180,14954,12809,12841,12776,10696,12809,12809,12809,10663,12776,12841,12809,12809,10664,12744,10664,10664,10696,12744,10631,10631,10663,10664,10663,10631,10631,10696,10696,10663,10696,10664,10631,10631,12744,10663,10631,10664,10631,10598,10631,10631,8550,10663,10696,12744,10631,10631,10631,10631,12744,12712,10631,10663,10631,10631,10631,10631,10631,10631,10631,10598,10598,10631,10598,10663,10631,8518,8518,10631,10598,8485,8485,8485,8485,10566,8485,8485,23309,10566,10566,10566,14824,19083,14857,16937,27533,27565,42292,52857,52824,50776,50776,52824,52825,50744,38130,27729,17066,12808,16969,12776,21195,31792,31792,31793,27534,19082,21195,14824,12711,14791,33873,36018,27533,36019,29680,29680,31793,33938,33971,33971,33971,33939,31858,29745,29713,27600,23341,23308,27567,19050,25421,29647,29646,33873,50777,48697,50777,44438,21162,29646,25420,29646,167},
{52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52891,52891,52891,52923,52923,52923,52923,52891,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,52891,52923,52923,55003,55004,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,52922,52858,52858,38100,21195,23276,23309,23276,23309,23341,21228,23309,23308,21228,23276,21195,21196,21195,19147,21195,19115,19082,19082,19082,17002,16970,16937,16970,16970,16970,16970,16970,16970,17002,17002,19050,19050,17002,17002,17003,17002,17002,16970,16970,19180,17099,19213,23438,25584,15019,19213,17067,14954,17035,17067,12841,10696,10696,10663,10631,12809,14987,14954,14890,12809,12776,12776,10728,12841,12809,10663,10663,10631,12841,10696,8550,8550,12776,12776,12744,12744,10663,12712,10631,12744,12744,12744,12744,10696,10598,10631,10631,10598,10663,10696,12744,10631,10631,10696,10663,12777,10663,10663,12776,10696,10696,10663,10599,10598,10663,12809,10598,10566,10598,10598,10631,12744,10663,8518,10599,10631,8517,8485,8485,8485,8485,8485,8485,21196,10566,10566,10566,12711,16970,14824,14824,25388,25453,48598,54937,54970,54970,54937,54970,57050,50744,36049,27728,21422,23438,23438,21293,21195,31760,31792,33905,27534,21163,23276,21195,23276,21227,31760,27501,23340,36018,33873,27631,31793,33971,33971,33971,33971,33938,31858,31793,29713,27600,23341,21196,29648,25454,25389,29647,29679,38131,50810,50777,50842,35986,21162,27468,25452,35985,168},
{52891,52891,52891,52891,52891,52891,52923,52923,52923,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,55003,55004,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,44438,21196,23308,25421,23308,23308,25389,23276,23309,23276,21196,21195,21195,21195,21163,19115,19115,19083,19083,19115,19083,19050,17002,16970,17002,17002,17002,17002,17002,17002,17002,17002,17002,17002,17002,17002,19083,19051,17002,16970,16970,17067,17067,17100,21293,27697,14954,17067,14922,14954,14890,12744,10663,12809,12809,12776,10663,12776,14954,12842,12841,10664,12776,8518,8518,12809,12809,8550,8550,8550,12809,12809,10696,10663,10663,10631,8518,10631,10598,8518,10598,10663,8550,10599,12744,10663,8518,10631,10664,10631,10631,12776,12744,10663,8550,8518,10631,12744,10663,10598,10663,8518,8518,10631,8518,8518,10631,12776,8518,8486,8518,8485,10598,12711,10663,8485,10598,12679,10566,8485,8485,8485,8485,8485,8485,21196,10598,10566,10566,10566,8485,8485,14824,27501,25421,50744,52857,52889,54970,54937,54969,57050,44469,36082,27729,17132,17034,19147,14889,21195,19082,12743,14856,19082,21195,25454,38099,38131,36018,31792,23308,25453,35954,31792,27599,27599,31825,33939,33938,31826,31858,31825,29713,27632,27600,23341,21163,27567,29615,23308,31760,33905,46583,46616,48664,46584,31760,27500,23274,27566,42325,120},
{52891,52891,52891,52891,52891,52891,52891,52891,52923,52891,52891,52891,52891,52891,52891,52891,52891,52923,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,55003,55003,55036,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57116,46519,23276,23308,25389,23309,23308,25389,23276,23341,21228,21195,21195,21163,21195,21195,19083,19083,19083,19083,19115,19082,19050,19050,19050,19050,17002,19083,19083,17002,19051,17002,16970,17002,16970,16970,17002,16970,16970,17002,17002,16970,19180,19180,17067,23406,31923,17099,19245,14954,14954,14954,10696,10696,14955,14955,14987,12809,12809,14987,14955,14987,12809,12841,8550,8582,12841,14954,8551,8550,10631,14922,14954,14987,12841,10696,10663,10598,10631,10631,8518,10631,10696,8518,8550,12744,10696,8550,10696,14922,12809,12776,14922,14922,12809,10631,10598,10663,12808,12776,10663,10663,8518,8550,10631,10598,8550,10631,12809,10631,8518,8518,8518,10631,10598,10566,8485,10598,10631,8485,8485,8485,8485,8485,8453,10566,21229,10598,10566,10566,10566,10566,10566,12743,29647,29679,52889,52857,54937,54969,54937,54970,54970,40243,38130,29841,14889,6372,10630,10630,19115,17002,8485,10565,16937,21195,21195,31792,31792,29679,31760,27566,27534,31760,23276,29680,25486,31858,36051,33939,33939,33939,33938,31826,29745,29680,23373,21195,27534,27567,25389,31727,36018,50777,48697,50809,42293,23242,29646,23307,31727,46551,67},
{52891,52891,52891,52891,52891,52891,52891,52891,52923,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,55003,55003,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57116,48632,23309,23341,23341,23308,23276,23276,21228,21228,21195,21163,21195,21195,19115,19115,21163,19083,19115,19083,19083,21163,19115,19082,19083,19083,19083,19083,19083,19083,19083,19083,17002,17002,19050,19050,19083,17002,17002,19083,19050,19050,25486,23471,25584,25616,29778,21325,19245,14987,12809,14922,14922,12776,12776,12777,12777,10663,12744,12841,12809,12776,12809,12776,10663,10663,12776,12744,10663,10663,10663,12776,12809,12776,10663,10696,12744,10663,10631,10631,10663,10631,10663,10664,10696,10696,12744,10631,10631,10663,12744,10696,12744,10696,10631,10663,10696,10695,10631,10631,12744,10663,10631,10631,10631,10663,10631,10664,10631,10598,8518,10598,10598,10631,10566,8485,8485,8485,10566,8452,8453,6405,6405,8453,8452,10566,21228,10598,10566,10566,10566,10566,10566,12679,27534,35985,54937,54937,54969,54970,54937,54969,52889,38130,38162,31954,14954,8485,10630,10631,21195,31792,29712,31792,25421,29647,29680,29615,29647,31760,38132,27599,31760,27567,21163,31792,29712,31793,36051,33971,33971,33939,31858,31826,29745,29712,29648,21195,29679,29647,25389,29647,40212,50810,50777,50842,27501,27533,25420,25452,38131,38132,55},
{52891,52891,52891,52891,52891,52891,52923,52891,52891,52891,52923,52923,52891,52891,52891,52891,52923,52923,52923,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,55003,55003,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57116,50777,31825,31825,31792,29680,29680,29647,27599,27599,27567,27534,27566,25486,25486,23373,25486,25454,25454,25454,25421,25421,25422,23341,21261,23341,21260,21228,23341,23341,23341,21261,23309,21260,21260,21260,21228,21228,21196,21228,21228,19115,19180,17099,14922,21325,19180,17034,21358,17100,17067,17067,14922,12808,14954,14986,14955,10696,12809,17068,14955,10664,10663,14889,10663,10663,14922,14954,10631,10631,10663,12874,12874,14889,10631,10728,12841,12841,12809,10663,10631,10599,12776,10663,10663,12809,14889,10598,10631,10631,10663,12744,12776,10663,10598,12744,10663,10663,10663,10598,10598,12776,14857,12744,10663,14857,10631,12712,10663,8518,8518,12744,10631,14824,10598,8485,8485,10598,16970,16937,14857,14857,16937,14792,14856,16937,23341,10598,10566,10566,10566,10566,10566,10630,19115,38131,54970,52889,54937,54970,54970,54970,52856,36049,38162,31921,21390,21325,21325,21292,21260,31793,33906,33906,29680,36019,31792,14824,14824,25421,38132,27566,29647,25422,19082,33873,31825,31793,33971,33939,33939,33939,33906,31826,29745,27632,25422,25454,31760,31760,23340,35986,46583,48664,48696,44503,23308,29678,23307,27566,46551,23275,111},
{52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,55003,55004,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,55035,48697,48664,48664,46616,46616,46584,46552,44503,44471,42423,42423,42423,42391,42358,40310,42390,42391,42390,42390,42390,42390,42358,42358,42358,42358,40310,42391,42391,42358,42390,42391,42358,42358,42390,42390,42358,42358,42391,42391,42326,27632,21325,12808,21293,21358,17067,19245,17067,14954,14921,12744,10663,14922,12874,12874,10663,12776,12809,10696,8518,8518,12776,8550,8551,12809,12841,8550,8550,8550,12809,12841,12777,8550,10696,12841,10663,10663,10631,8518,8550,12776,8550,8518,12776,12809,10598,10631,10598,8550,10631,12809,12712,8550,10631,8518,8550,10664,12744,10599,10663,10631,10598,10631,10631,10598,10599,10663,8518,10566,10631,10598,19050,10631,8485,8453,14791,29615,31760,27567,27566,29647,25421,23276,17002,21228,10598,10566,10566,10566,10566,8517,10566,21195,44437,54970,52889,54937,54970,55002,57050,50809,38130,35984,31921,29809,27696,25583,25583,23405,40245,38164,38164,38164,38132,35986,33906,36019,35986,31793,25421,19050,25486,16970,38164,25421,31793,34003,33971,33971,33939,33938,31826,31825,29745,25486,23341,29647,31792,25389,38164,48696,46551,50810,33905,27533,27533,25420,35985,44438,12743,162},
{52891,52891,52891,52891,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52955,55003,55003,55036,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,55036,55003,55003,55003,54971,52923,52923,50843,50810,50810,50810,48730,48730,48730,48730,48730,48730,48762,48762,48762,48762,48762,48762,48762,50842,50843,50843,50842,50810,50810,48762,48730,48730,48730,48730,48730,48730,48730,48762,50843,48730,31891,21325,12809,19180,25616,21325,23438,17100,14954,14954,12776,12776,14954,14954,14954,12809,12809,12809,8551,8518,10631,12744,8551,8550,12809,14922,8550,8550,10598,12841,14922,12809,8518,10696,14922,10663,10663,10631,8550,8550,12809,10598,8518,12809,12842,10598,10598,8518,8518,10631,14922,12744,10631,12744,12744,12776,12744,12776,10598,10631,8518,8518,10631,8518,8518,10599,10631,8518,10566,10598,10598,21163,14824,12679,10630,14791,23340,31760,29679,27534,27599,23276,10598,8485,21196,10631,10566,10565,8485,10566,10598,14824,21195,48631,54970,52889,54970,54970,55002,57083,52857,38130,31824,19147,19147,21260,21324,21325,21292,21195,16937,16969,31825,33906,16937,12711,33873,38164,29712,25486,21163,25454,19082,40212,19115,29680,36051,34003,33971,33939,33938,31858,29777,31825,23373,16969,27566,29680,23340,44470,46616,48697,52890,23308,31726,27500,27501,44438,29680,21130,192},
{52891,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52955,55003,55036,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,55003,55003,52923,52891,52891,52891,50842,50810,50810,48762,48730,48730,48730,48698,48697,46649,48729,48730,48730,48730,48730,48730,48730,48730,48730,48762,50810,48762,48762,48730,48730,48730,48730,48730,48730,48729,48697,48730,48730,46584,50810,42423,34036,31923,23471,23438,21326,21325,23406,23373,23406,23374,21293,21293,23374,23374,23374,21261,21261,21261,23309,23309,23309,23341,23341,21261,23341,21261,23341,21261,21261,21261,21293,21293,21228,21293,23341,21261,21261,21261,21293,21293,23341,21293,23374,23374,23373,21261,23341,23374,23341,23341,21261,21293,23374,23374,23374,23341,23341,21261,21261,21261,21261,21228,21228,21228,19147,21196,14889,14857,14857,10598,19049,27502,29647,27534,25421,21195,31727,33840,31760,31793,17002,8485,10566,21228,10631,10566,10565,12679,10598,12679,17002,25421,52824,54969,54937,54970,55002,57083,55003,44502,29808,23438,12744,10630,8518,8518,10598,16937,16937,17002,16969,19050,17002,14857,14824,16937,16969,27567,27567,21195,23341,27534,38131,23308,27599,31858,31858,31858,31858,31825,29713,29680,29680,25454,19115,29680,29647,29679,46584,44470,48697,46583,25420,29646,23307,31792,46551,16904,38067,160},
{52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52955,52955,55003,55004,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,55036,55036,55003,52923,52923,52923,52891,52891,50842,50810,50810,48762,48730,48730,48730,48730,48697,46649,48729,48730,48730,48762,48730,48730,48730,48730,48730,48762,50810,50810,48762,48762,48730,48730,48730,48730,48730,48730,48730,48730,46617,40310,50842,44536,36149,34036,21326,17067,14922,14954,23438,23406,25519,25487,25487,23406,25487,25487,25486,23406,25487,25487,25487,25486,25454,25487,25487,25454,25487,25487,25487,25454,23406,25454,25454,25454,23374,23406,23406,23374,23374,25454,23374,23374,23406,23406,23374,23374,23374,23373,23374,23374,23373,21293,23374,23374,23374,23374,23342,23341,23406,25454,23341,23342,23342,21261,21261,23341,23309,19148,10663,10566,10598,8485,16969,23340,27566,27534,25453,25388,33873,33905,29615,27534,19083,8485,10566,21228,10631,8485,8485,23308,16937,12711,23308,29647,52857,54937,54970,54970,52889,36051,29777,23535,23567,21390,12809,12776,14889,19147,14889,27599,29712,31761,27599,25422,21228,25421,25454,21228,19083,27567,23276,19082,23308,33938,33906,23340,27599,33971,33938,33906,31858,31858,31793,29713,27632,25486,23341,29615,29647,38132,48664,46551,48697,31760,27500,27500,27468,38099,38099,14856,48664,96},
{52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52955,52955,55003,55036,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,55036,55035,55003,52923,52923,52923,52923,52923,50843,50810,50810,48762,48762,48730,48730,48730,48697,48697,48730,48730,48730,48730,48730,48730,48730,48730,48762,48762,50810,50810,48762,48762,48730,48730,48730,48730,48730,48730,48730,48730,46649,46616,48730,36181,31923,29810,21358,19180,17132,21358,19180,19245,17100,14922,17067,21326,17132,12809,19148,23471,27762,27794,23536,14890,23406,12809,12744,21293,21358,12744,12744,14889,21358,17067,10663,10631,17034,27761,23470,17034,12809,10663,14987,23471,29777,27729,19180,10631,10663,19180,27697,10664,12809,25551,12776,10663,25584,25487,10631,21325,19212,8550,17067,25616,23471,12808,10631,10598,12711,12776,8485,10631,10631,10598,19017,25388,29647,29679,29647,27534,33905,38099,27534,25421,19083,8517,8518,21228,10631,12744,8485,25454,16970,14792,31792,31728,25389,25356,35952,33904,31792,25648,23568,25615,23567,21390,12809,12744,10598,10631,10598,29712,17002,14856,16937,27567,25486,12743,12743,16937,27599,29680,23308,19017,21195,36019,31825,25453,29712,36084,33971,36019,33971,33938,31858,31793,27632,25519,21228,23308,29679,44438,48696,46584,48664,23243,31726,27468,27533,48632,23276,29647,46551,50},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52955,52955,55003,55036,57084,57116,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57084,57084,55036,55003,54971,52923,52923,52923,52923,52923,52923,50843,50810,48762,48762,48730,48730,48730,48697,48697,48730,48730,48730,48762,48762,48730,48730,48730,48762,50810,50810,50810,50810,50810,48762,48730,48730,48730,48730,48730,48730,48730,48697,46617,50810,34036,31955,42423,25616,21391,17100,17132,17068,19245,17100,14922,14987,19278,17132,14954,12809,19212,25649,25617,19278,10664,19180,10663,10631,19148,19213,10631,8550,10696,19245,17002,10599,10599,14922,23470,19212,12776,12808,10598,12841,21293,23471,23471,17035,10598,10599,17035,25551,12776,12776,21293,10631,10631,19180,17034,8518,17035,12808,8485,14954,21358,19245,12776,10631,8485,8517,19115,10630,25454,33905,31793,29647,27534,33873,33937,38131,36018,33905,36018,44470,44438,19115,8485,8517,21228,16969,27535,10598,12743,10598,12743,21195,12711,8485,14791,25388,31759,40276,27696,25616,25583,23535,19277,10631,12776,14824,14824,10630,29680,23341,19115,19115,25519,25519,17002,16969,16970,25486,29679,27534,21129,21163,31792,33906,29680,29680,34003,33971,33971,33939,31858,31825,29712,27599,25486,23276,21195,36019,46583,46583,48664,38099,23242,31726,27500,33905,44438,14823,44470,31760,36},
{52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52955,52923,52923,52923,52923,52955,55003,55036,57084,57084,57084,55036,57084,57084,57084,57116,57116,57084,57084,57084,57084,57084,55003,55003,55003,52923,52923,54971,55003,52923,52923,50843,50842,50810,48762,48762,48730,48730,48729,48697,48730,48730,48762,48762,48762,48730,48730,48730,48762,50810,50810,50810,50810,50810,48730,48730,48730,48730,48730,48730,48730,48730,48730,44471,50810,36149,34036,44568,29842,25584,19245,19245,19213,21391,21358,19181,19213,27794,27795,29940,19246,19245,29907,29875,17100,12776,17035,12809,14889,19245,19180,10664,10663,12776,21358,17067,10664,10663,17034,25616,23503,19148,14954,14921,19212,25616,27762,27729,19212,10664,10663,19213,27762,19212,17067,23471,10598,12712,12809,12744,10663,14922,10631,12744,19180,21423,23535,14954,12776,17034,21260,19083,12744,25421,33872,29679,27566,27533,33905,36018,40211,38099,31792,33905,38099,38099,19115,8485,8485,23309,29680,33906,12679,10566,10566,10566,8485,10566,10566,14824,29646,21162,40309,27729,25616,23567,23535,21325,10631,12744,10631,12711,10598,27567,16970,12711,12744,25486,27599,12743,10631,12744,25486,29647,29679,25356,25421,25389,38131,35986,27567,36051,33971,33938,33906,31858,31825,29712,27599,25486,23308,19082,40277,48696,46616,48664,27533,29613,27467,27533,42357,29647,21195,48729,19017,46},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52955,55003,55003,57084,57084,57084,57084,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,55036,55003,55003,55003,54971,54971,55003,55003,52923,52891,50842,50842,50810,50810,48762,48730,48730,48730,48730,48730,48730,48762,48762,48762,48762,48730,48762,48762,50810,50810,50810,50810,48762,48762,48730,48730,48730,48730,48730,48730,48730,50810,40310,48729,38262,34068,40342,27729,25617,19245,19245,19245,19213,19245,21326,21293,21358,21359,21391,19245,17133,21391,21359,19245,17067,17099,17035,19180,19180,17132,17035,14986,14986,19180,17100,14922,14922,17034,19212,19212,17067,17034,17067,17035,19245,21293,17100,17035,14890,14889,17067,19245,17067,17067,17035,12776,14889,16970,14889,14922,17035,17034,14921,14954,14922,14954,14889,12808,14889,14889,14857,17002,25421,35985,36018,36018,35985,36018,38099,31760,27566,25421,35986,27502,23341,19116,8485,8518,19083,38066,42358,10631,10598,10598,10598,10598,10598,10598,16937,33840,12711,40277,27761,25648,23535,23567,21390,10598,12711,8452,8485,10566,25486,14857,8485,8485,23373,27599,10630,10566,12678,23341,27567,25388,27501,29647,25453,40244,38099,25486,36084,36051,36051,33971,33939,31858,29777,29713,27567,21260,23308,48632,50809,50777,48697,25355,29613,23274,31727,46583,16936,38099,38132,12743,63},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52955,52955,55003,55003,55036,55036,57084,57084,55036,55036,57084,57084,57084,57084,57084,57084,57084,55036,55035,55035,55003,55003,55003,55003,55003,54971,52923,52891,50842,50842,50810,50810,48762,48730,48730,48730,48730,48730,48762,48762,50810,48762,48762,48762,48762,48762,50810,50810,50810,50810,48762,48762,48730,48730,48730,48730,48730,48730,48730,50810,48697,46649,38262,38262,46649,31923,27697,19213,19245,17132,19245,17067,12842,14987,29843,29875,29843,27794,21358,27762,27794,27827,14954,17067,10696,10664,19213,21293,12809,12777,12809,23439,17035,10631,10631,17035,27697,25616,17132,12809,8518,12809,23503,27697,12777,14889,10631,10598,21261,27762,25616,21358,10695,10598,12809,14889,10631,12744,17002,10598,10598,14889,8517,8518,12776,8550,8485,10598,14857,19115,25421,35953,36018,38164,38131,35986,35986,16970,14759,25421,38131,33873,29712,19115,8485,10566,19050,35953,40278,12679,10598,10598,10598,10598,10598,10566,19082,33873,12711,38164,29809,25648,23567,23567,21390,10630,12776,12776,14824,10598,25454,23308,19050,19050,23341,23341,12743,29679,31792,31792,33905,23308,29647,23308,31792,42357,44438,36051,33971,33971,33971,33939,33938,31858,31825,31793,27631,23340,29647,50777,48696,48697,35986,29645,29613,25420,38164,36018,16936,48664,21163,6372,36},
{52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52955,52955,52955,55003,55003,55003,55004,55036,55036,57084,57084,57084,55036,55036,55036,57084,57084,57084,57084,57084,57084,57084,55035,55003,55003,55003,55003,55003,54971,52923,52891,52891,50842,50810,50810,50810,48730,48730,48730,48730,48730,48730,48762,50810,50810,50810,48762,48762,48762,50810,50810,50810,50810,48762,48762,48730,48730,48730,48730,48730,48730,48730,50810,48730,46616,36181,36149,34068,23503,21326,17068,19181,17068,19212,17067,14954,17035,19277,17100,17067,17035,17100,17100,17100,15019,14922,17035,10696,10696,19180,17067,12809,12809,12776,19245,14889,10631,10631,14922,27664,25551,14889,10663,10598,14889,21390,19277,10599,19212,17067,8518,19212,25584,23438,21293,12744,10598,12809,14954,12809,14921,23374,23438,12808,12809,8518,10598,12744,8517,8485,10566,14857,19115,25389,38034,40211,42325,38132,33905,31760,23340,21195,35986,40212,42357,42357,21196,8485,12679,25421,40147,38165,10631,10598,10598,10598,10598,10598,8518,21163,33872,23308,36083,27761,23600,23567,23567,23503,12808,12744,10663,12711,10598,23341,21195,19083,21195,23341,19082,12743,31760,35986,33906,35986,27534,23308,14856,33905,44471,46583,42358,33938,33938,33938,33938,31858,31825,31793,29745,27632,25454,21098,29549,33905,31792,21129,29580,25419,27533,46551,21195,29647,44438,8517,8452,60},
{52891,52891,52923,52923,52923,52923,52923,52923,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,55003,52923,52923,52923,52955,55003,55003,55003,55003,55003,55003,55036,57084,57084,57084,55036,55036,55036,57084,57084,57084,57084,57084,57084,57084,55036,55036,55036,55035,55003,55003,55003,52955,52923,52923,52891,50842,50810,50810,50810,48730,48730,48730,48730,48730,48730,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,48762,48762,48730,48730,48730,48730,48730,48730,48730,50810,48729,36084,38294,34101,31955,23504,21358,19213,19213,19213,19213,19245,23503,23438,19213,17067,17067,14954,17100,17068,17068,14955,19213,17035,14890,17035,19213,17035,17067,17067,14954,19180,14889,12776,12776,17067,27664,25584,17002,12809,12809,14889,21422,23471,14922,23406,21261,12744,21293,25616,21390,19212,12808,12809,14954,17002,17002,17002,21326,23438,12809,14922,10696,12744,12776,12744,12744,12711,12744,16937,25389,38066,35986,19115,23276,29647,29646,23276,19050,25421,36018,31728,27534,19083,8485,23276,35986,42292,31826,12679,10598,10598,10598,10598,10566,8517,23276,33905,33905,31857,27761,25648,23568,25616,23567,17067,12776,14856,12776,10630,19115,23341,33970,36019,33938,27566,16969,27534,29679,29680,29680,27501,25356,10598,36018,46583,44471,42357,33971,36051,33971,33971,33939,33938,31858,31858,29744,27567,16871,16871,23275,25355,21064,25387,25387,33872,42325,12743,44438,27534,6340,8452,99},
{52891,52891,52891,52923,52923,52923,52923,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52955,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55004,55036,57084,57084,55036,55035,55003,55003,55035,57084,57084,57084,57084,57084,55036,55036,55036,57084,55036,55003,55003,55004,55003,52923,52923,52891,50842,50842,50810,50810,48730,48730,48730,48730,48730,48730,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,50810,48762,48762,48730,48730,48730,48730,48730,48730,48730,50810,50778,40310,38294,31955,25616,21358,21326,19245,19278,19213,21294,19245,14987,17067,21358,17132,17067,17100,21326,27697,25649,21358,14889,25584,23407,14889,21293,21326,14922,14922,17002,17100,17099,17002,12809,17002,12776,10663,14857,14921,12744,12809,17035,12744,14889,23406,25519,14889,17067,12809,12776,19245,27729,19212,14921,14921,12744,12776,21358,23438,14857,21325,23503,21293,14922,12744,10663,12711,16970,27567,27599,36018,33905,23341,23276,27533,27533,19050,14856,21130,33873,23308,16970,17002,10598,27534,23308,42325,31793,10631,10598,10598,10598,12711,12679,10566,19050,27534,33937,40309,31987,27761,23600,23535,21487,12873,14889,19212,19212,21260,21228,21228,23341,23276,23276,23276,19082,19082,10631,10630,21130,29679,27501,10630,38066,46584,44470,40277,36019,33971,33971,33971,33938,31858,31826,31825,31793,29647,23275,23307,19016,21097,23210,23274,25387,42357,29615,23275,48664,12711,6372,10630,138},
{52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52955,55003,55003,52955,52955,55003,55003,55003,55003,55003,55003,55003,55004,55036,55036,55003,55003,55003,55003,55003,55003,55036,57084,57084,57084,57084,57084,57084,55036,57084,57084,55036,55003,55003,55003,52923,52923,52891,52891,50842,50842,50810,48762,48730,48730,48730,48730,48762,50810,50810,50811,50810,50810,50810,50810,50810,50842,50810,48762,48762,48762,48730,48730,48730,48730,48730,48730,48730,50810,52891,48730,34068,29875,34003,21358,17132,17100,19213,17100,21293,19148,12809,14954,19245,14987,12842,12874,19245,25617,25649,19245,12777,23438,17100,8551,19180,19245,12744,10664,12776,17067,14987,14890,8550,14889,12809,10663,12744,10696,8485,10663,14889,8485,8518,21325,23406,10631,17035,10663,8486,19147,25616,14954,12744,12776,8485,10598,21325,21293,17034,21293,21325,17035,12776,10631,8517,8517,19050,36051,35986,36018,38099,35986,31760,29614,29679,31760,31727,27534,31792,31760,29647,19050,21163,23341,10565,44405,36019,10598,10598,10598,12744,21195,19050,19018,19050,27533,33937,44535,46681,31922,36116,38293,36180,23470,23438,17034,17002,17002,12776,21196,12743,8485,10533,14791,16969,19083,10566,8485,21163,27566,23275,12743,38099,46584,46551,40277,36051,36051,33971,33938,33938,33906,31825,31825,29712,29647,25421,23276,21064,21032,23209,25387,29678,44470,16904,40212,35986,6372,8452,21195,167},
{52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52923,52955,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55004,55004,55004,55035,55035,55035,55035,55035,55036,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,55036,55003,55003,55003,52923,52923,52923,52891,52891,50842,50810,48762,48730,48730,48730,48730,48762,50810,50810,50842,50842,50810,50810,50810,50842,50842,50810,48762,48762,48762,48730,48730,48730,48730,48762,48762,48762,50810,52891,48730,36149,36181,44568,27762,23504,19213,19245,17132,21326,21294,19180,19245,19245,14987,12907,12842,21326,27795,27794,19213,12809,17067,12777,12777,19213,17100,17035,14954,14922,25681,27794,25584,10631,17067,27762,25584,12809,12809,12776,12809,14986,14889,12776,25519,25584,10631,17067,12776,8550,17067,25617,12841,14954,14921,12744,10663,25551,23406,14921,23471,25584,14922,14857,10631,8485,8485,17002,36019,33938,36018,36018,27469,25388,31760,36018,44438,44503,40212,46583,44438,40212,19083,38067,27600,12711,46519,38132,10598,10598,10566,23276,19115,14824,19050,23308,25453,33905,44503,46713,25550,25485,31857,36115,33969,27696,10663,6372,10566,10598,21163,16969,10598,10630,14791,16905,25421,27534,25421,40244,38131,25421,14856,36018,44503,42358,42325,36051,36051,36051,33971,33939,33938,33906,33905,31792,29647,27566,23308,18984,21032,23144,27533,40179,38099,19017,48664,21195,10630,14824,31792,166},
{52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52923,55003,52955,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55004,55004,55036,57084,55036,55036,55036,55036,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,55036,55004,55003,55003,52923,52923,52923,52891,52891,50842,50810,50810,48730,48730,48730,48730,48762,50811,50843,50842,50842,50810,50810,50810,50842,50842,50842,48762,48762,48730,48730,48730,48730,48730,48730,48762,50810,50810,52891,50810,34068,34036,40277,27729,25617,21326,19245,21326,19245,23438,19213,19213,21326,21358,21326,21326,19245,19278,19213,17067,14954,17068,14955,14954,19148,19180,17035,17003,17035,19180,19148,17067,14922,17035,17035,17002,14922,17035,17034,17002,17067,19115,14922,19147,17035,17035,19147,14889,14857,17099,21293,17100,17002,14921,14889,14889,19180,19212,17034,14922,14922,14889,14889,10631,8485,8485,16970,36019,33938,38098,33873,23308,21163,33872,36018,29647,27502,42325,42293,27534,23276,21195,35953,25486,16905,48632,36019,10566,10598,10598,16969,19082,14824,19050,19082,19082,33873,46615,50874,48761,46681,46648,42454,33969,27696,12776,8517,10598,10598,19082,33938,33938,33906,29680,21163,23341,29712,35986,48697,38099,25420,19082,33873,42390,38131,40212,36051,36019,36019,33971,33971,33938,33906,33905,31793,29647,27534,23308,19016,21064,27402,29646,46551,23308,33873,42357,10565,8485,16969,40244,163},
{52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52923,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55004,55004,55003,55036,57084,57084,57084,57084,55036,55036,55036,57084,57084,57084,57084,57084,57084,57084,57084,55036,55003,55003,54971,52923,52923,52891,52891,50843,50842,50810,50810,48730,48730,48730,48730,50810,50810,50842,50810,50842,50810,50810,50810,50843,50842,50842,48762,48762,48730,48730,48730,48730,48730,48762,48762,50810,50842,52891,50810,29810,25616,48794,29842,23536,19213,19245,17132,21358,31988,14954,12874,29843,29875,27827,27827,21391,15052,14987,10664,12809,17035,10664,10663,21293,21326,10696,10663,14857,17035,10631,8550,8550,17002,10663,10598,14889,10696,8518,12744,14857,8518,10663,14922,10598,17099,19180,8550,8485,19180,25649,23438,12776,12776,8518,12743,25583,27729,23438,12744,8453,10598,12776,8518,8485,8485,17002,36019,33938,36018,33905,33873,33873,38066,35985,25389,21163,42325,31760,16937,12678,33873,33873,21228,19018,48664,33938,8518,10598,10598,12743,23308,23308,25421,27534,29647,36050,29647,29712,42455,48794,50842,42454,34001,27663,21293,19148,19212,19180,19082,23341,21195,21228,21195,21195,19082,12678,38067,44438,25387,23274,19114,21162,21195,25453,42325,36051,36018,36018,33938,33938,33938,33906,33905,31825,31792,29680,23276,21097,23112,29581,35986,44470,16936,46551,27501,8485,10630,27566,44470,147},
{52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52923,52955,55003,55003,55003,55003,55004,55004,55004,55004,55003,55003,55003,55003,55003,55003,55003,55036,57084,57084,57084,57084,57084,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,55036,55003,54971,52923,52923,52923,52891,52891,50843,50842,50810,48762,48730,48730,48730,48730,50810,50842,50842,50842,50842,50842,50810,50810,50811,50810,50810,48762,48762,48762,48730,48730,48730,48730,48762,50810,50810,50842,52890,50843,34004,25649,40375,27697,23471,17132,17133,17100,19213,27762,14987,14987,25649,27762,25714,25649,21391,25617,25617,21294,12776,17067,12745,10696,19180,19180,12809,10696,12776,23439,23471,23503,14889,17067,25584,17035,14889,12776,10631,12776,14921,10598,10663,14889,10598,10663,21326,23471,17034,21293,25584,17002,12744,12809,10598,10663,25551,19180,12776,21357,21293,10663,12744,8518,8518,8485,16969,35986,33906,36018,36018,38131,36018,35985,38098,38099,38099,38131,40277,33905,27534,29679,29615,21163,25389,46583,31793,8518,10598,10598,10630,12679,12679,12678,27534,36051,38163,21227,10598,14824,23308,36051,36115,33969,29808,17099,14889,14889,12776,16969,14824,8452,8452,12711,21195,16969,21163,44471,25420,19049,25354,21195,12711,6340,21162,42390,40212,40212,40244,40244,40245,40244,40244,40212,38164,38164,38131,25421,21130,18984,27533,42390,29647,23308,46551,12710,8485,14856,36051,44470,128},
{52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,52955,55003,55003,55004,55004,55004,55004,55004,55004,55003,55003,55003,55003,55003,55003,55036,55036,57084,57084,57116,57116,55036,55036,55036,55036,57084,57084,57084,57084,57084,57084,57084,55035,55003,54971,52923,52923,52891,52891,52891,52891,50842,50810,50810,48762,48730,48730,48762,50810,50810,50843,50843,50843,50843,50810,50810,50810,50810,48762,48762,48762,48730,48730,48730,48730,48730,48762,50810,50810,52890,52890,52890,34069,29843,31955,25584,21391,19213,19245,21293,19245,25616,19245,19212,23536,23536,23536,23503,21326,23504,23536,21358,14954,17067,14922,14922,19148,17099,14955,14922,14954,21326,21358,23439,14954,17067,21390,17067,14921,14922,14922,14922,17035,14889,14889,14954,12744,12744,21325,23471,19180,21293,21325,17035,14889,14922,14889,12808,21293,17035,14889,21293,19212,14890,14857,10599,8518,8485,16937,36018,33905,36018,33872,29679,29647,33840,38099,40212,36018,27534,27534,36019,36018,40212,29679,35986,46551,44470,27567,10566,10598,10598,10598,8517,8485,8485,29647,35953,36018,21228,12679,12711,10598,10598,29678,40242,34002,12841,6372,8453,8485,16937,16969,10598,10598,10630,14824,19050,40245,40212,19049,21096,27435,29680,21163,14824,29680,38131,38131,40244,40244,40244,40244,40212,40244,40212,40212,38131,38132,25453,21162,29614,29614,44503,16937,40212,33873,8452,8485,25421,42390,40244,106},
{52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52955,55003,55003,55004,55004,55035,55036,55036,55036,55036,55003,55003,55004,55004,55004,55036,55036,57084,57084,57084,57116,57116,55036,55036,55036,57084,57084,57084,57084,57084,57084,55036,57084,55035,55003,54971,52923,52923,52891,52891,52923,52891,52891,50842,50810,48762,48730,48730,48762,50810,50810,50810,50842,50842,50842,50810,50810,50810,48762,48762,48762,48762,48730,48730,48730,48730,48730,48762,50810,50810,52890,52891,52890,38262,34068,29810,23471,21358,19245,19245,17164,21326,21326,14955,17067,27697,27730,25681,17067,17067,14987,12841,12842,14922,25617,25681,14889,21261,21358,12809,12777,17067,17067,12744,10631,10696,19213,25616,12744,14889,21325,21358,14889,17034,12712,12809,23471,27664,19180,19148,10631,10663,14922,10663,10631,19115,14922,10631,14857,23471,14922,16970,25584,21325,10631,12744,10598,8485,8486,16969,36019,33938,36018,31792,29712,29712,31760,36050,25421,21163,27534,21130,23308,44471,40244,33872,38098,42358,42390,25486,10566,10598,10598,14824,21163,19050,12711,29614,33873,36051,21195,12711,12711,12711,12710,31758,42388,36082,14953,8517,10566,8517,14856,27599,29680,29680,21195,10598,25421,48696,33872,23242,21096,36018,29712,17001,17002,38099,42325,33906,40244,40244,40244,40244,40244,40244,40244,40212,38131,40212,25453,25420,31727,35986,38099,21162,48697,19050,8485,10630,36018,44503,33905,104},
{52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,55003,55003,55004,55004,55004,55004,55036,55036,55036,55003,55003,55003,55004,55004,55036,55036,55036,57084,57084,57116,57116,57084,57084,57084,57084,57084,57084,57084,57116,57084,55036,55036,55035,55003,55003,55003,54971,52923,52923,52923,52923,52923,52891,50843,50810,50810,48762,48730,48762,48762,50842,50843,50842,50842,50842,50842,50810,50810,50810,48762,48762,48762,48730,48730,48730,48730,48730,48762,50810,50810,52890,52891,52891,36149,31955,27697,19246,19213,17132,17100,14987,17133,19180,12810,14955,23536,23536,23504,14922,15019,12842,10696,12777,12777,23504,23439,10664,19180,17067,10664,10663,12841,17132,14987,14954,10598,14954,19180,8518,12776,19180,17100,12744,12809,8518,10631,21325,23438,21261,19115,10598,8485,12808,8518,8517,14857,12744,8485,12743,21325,14889,12743,21357,19245,8518,8485,8485,8486,8486,16970,33971,33938,36018,38066,38066,38066,33905,36018,27534,23308,29615,19017,16904,27535,33873,23275,29614,42325,46583,29680,10566,10598,10566,16937,19082,16969,14856,27566,33905,36051,21195,12679,12711,12711,12711,33904,44437,36082,19179,17067,19180,19179,19082,27534,29679,27534,27502,19082,38132,42325,25322,25322,23242,42358,29680,23340,19115,40244,44471,33873,40244,40244,40244,40244,40212,40212,40212,40212,38131,40244,27501,33905,42325,44471,23308,35953,42357,12711,10597,21195,44470,44438,27534,133},
{52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52955,55003,55003,55004,55036,55036,55036,55036,57084,57084,55036,55036,55003,55003,55003,55035,57084,57084,57084,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57116,57084,57084,55036,55003,55003,55003,55003,55003,55003,55003,52923,52923,52923,52923,52891,50810,50810,48762,48762,48762,50810,50842,50842,50843,50842,50842,50842,50811,50810,50810,50810,48762,48762,48730,48730,48730,48730,48730,50810,50810,50810,52890,52891,52891,38294,36181,44568,27729,23471,19213,17132,17132,19245,21326,19245,19278,27729,27794,25650,12874,14987,14955,17067,17035,17035,27697,25617,14922,23439,19180,19180,21325,19148,25616,27729,27697,10696,14922,14889,14922,17067,23439,21293,12776,17002,14889,12809,25551,25648,25648,19180,10631,8485,14889,10663,10663,14889,12776,10663,12776,23503,17067,12744,23438,23535,12744,8453,8485,8485,8485,14824,31826,33905,35985,31760,21163,23275,35953,35986,40244,29647,23308,21195,25453,19050,25388,23275,23308,40245,48664,29681,10566,10598,10598,14856,19018,16970,14824,27501,29679,38131,19083,12711,12711,12711,12743,36017,42389,38162,29743,25550,23437,23373,17001,14824,16937,14856,14823,21163,44503,29679,16936,18983,29582,44438,38099,25421,21227,44438,38164,40212,46551,46551,46551,46550,46518,46518,46518,44438,42357,44438,36018,40179,48664,44438,19082,48664,27502,10598,10565,29679,46583,38099,27501,154},
{52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52923,52955,55003,55003,55003,55004,55035,55036,55036,55036,55036,55036,55036,55035,55003,55003,55003,55004,55036,57084,57084,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,55003,55003,55003,55003,55003,55003,55003,55003,54971,52923,52923,52891,50842,50810,48762,48762,48762,50810,50842,50843,50842,50842,50842,50842,50843,50842,50810,50842,50810,48762,48762,48730,48730,48730,48730,50810,50810,50842,52891,52891,52891,40407,36181,42488,29907,27730,21391,21358,19245,19213,21293,17067,17100,19213,19213,17067,14955,17067,17132,19212,17068,14955,19213,17035,17067,19180,17067,17002,17035,19213,19212,17002,14889,14889,17067,14922,14922,17035,14922,14889,14922,14922,12809,17002,17002,14922,14921,19212,21325,21261,17034,12776,12809,14922,14857,12776,14857,14889,12808,14889,21325,19180,8518,8485,8485,8485,8485,8518,10566,23275,33937,33872,31760,27534,31792,35985,31727,21228,14856,27534,27534,19082,19049,25388,25421,40245,44471,27567,10566,10598,10598,10598,10533,10565,8485,29615,31760,38131,19050,12711,12711,10631,16969,38162,42388,38162,27598,25517,25518,23373,12679,10565,10565,10566,12743,31760,38131,23275,19017,21096,29614,42390,29712,16969,23276,44471,33873,52857,57083,57083,57083,57083,57083,57083,57083,57083,57083,54970,46551,44470,44438,40212,38066,42357,42325,33873,14856,36018,42357,29614,31694,171},
{52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52955,55003,55003,55004,55004,55036,55036,55036,57084,55036,55036,55036,55035,55035,55003,55003,55004,55004,57084,57084,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,55036,55035,55003,55003,55003,55003,55003,55003,55003,55003,55003,52923,52891,50843,50842,48762,48762,48730,50810,50842,50843,50842,50843,50843,50843,50843,50842,50842,50842,50810,48762,48762,48730,48730,48730,48730,50810,50810,50842,52891,52891,52891,38294,34101,46681,29842,23536,19245,19245,17132,21326,19213,12809,14954,17132,17100,12809,10696,14987,17100,17100,12842,12809,19180,10631,10664,17003,12809,10631,10631,17100,19213,12776,10599,10631,17035,10663,8518,12809,10599,8485,12744,12776,8485,12744,12808,8485,8518,21325,25551,23471,17035,8517,8517,12776,10598,8518,12744,10631,8485,10663,23503,21293,8485,8485,8485,8485,8518,19116,17003,21195,35985,38099,40244,38164,33905,36018,23308,19083,23308,19050,19050,10598,16937,25421,25453,42325,42325,25454,8518,10598,10598,12744,19083,21163,19050,33840,33938,36051,19050,12711,12711,10631,19082,42355,42388,33937,10630,10598,12775,16969,16969,16969,16937,16937,16937,27469,23307,29614,23242,23209,35986,40309,31857,21228,29679,44439,36018,57083,57051,57051,57051,57051,57051,57083,57051,55003,57083,40211,23307,21194,16969,14823,14824,23308,44438,36018,16936,33873,36018,25388,35920,164},
{52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,55003,55003,55003,55004,55036,57084,57084,57084,57084,55036,55036,55036,55036,55004,55035,55003,55003,55004,57084,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57116,57084,57084,55036,55036,55036,55035,55004,55004,55003,55003,55004,55003,55003,55003,54971,52923,52891,50842,50810,48762,48730,50810,50842,50843,50843,50843,50842,50843,52891,50843,50842,50842,50810,48762,48762,48730,48730,48730,48730,48762,50810,50810,52891,52891,52891,38294,34068,44568,31923,23504,19212,19213,19213,21326,21326,14954,17100,19277,17133,14987,14922,19213,25649,25649,21358,14986,19180,14922,17035,14955,12809,14890,17034,14954,17003,12841,10663,10696,17035,12809,12809,14922,12776,10663,14889,14889,14889,14954,14922,10631,10598,23438,23535,23471,17002,10631,10663,17067,23535,19147,12712,10631,10631,12776,23503,19148,8485,8485,8485,8485,8485,8485,8453,23275,35985,31727,29679,33872,36018,38131,33873,23276,27502,12711,19017,19082,21163,25421,19082,42292,46551,23374,10566,10598,10598,16937,19050,23308,27502,29582,33905,33938,16937,12711,12711,12711,19081,42388,42388,25518,14856,14888,14888,12711,12743,14824,14856,14856,16937,23341,27534,31792,16904,23274,40212,40245,33906,29647,40245,38164,46518,57083,55002,57051,55003,55003,57051,57051,57083,57083,55003,42292,35953,35953,35921,33840,35921,40211,40244,33905,25421,21130,21130,27533,44437,113},
{52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52923,52955,52955,55003,55003,55003,55036,55036,57084,57084,57084,57084,57084,55036,55036,55035,55003,55003,55003,55004,55003,57084,57084,57084,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,55036,55035,55036,55035,55003,55003,55004,55003,55003,55003,55003,55003,54971,52923,52891,50810,50810,48762,48730,50810,50842,50843,50843,50843,50843,52891,50843,50842,50842,50811,50810,48762,48762,48730,48730,48730,48730,50810,50810,52890,52891,52891,52923,40375,32020,29810,23504,21423,19245,19277,19245,19213,21326,19213,19213,19277,19213,17100,19181,19213,21326,21358,19213,17067,19180,19148,19180,17003,14922,17067,19213,19148,17035,17067,17003,14922,17035,17035,17067,17002,17002,17067,17035,17034,19148,19147,17067,17002,12808,17099,19147,17067,17002,14889,14921,17002,19148,17002,14857,14857,14857,14889,19180,17035,10598,8485,12711,10599,10631,14824,14857,27566,35985,31792,27566,31760,33872,29647,29679,23308,23308,16905,14824,19082,16937,23308,21162,35986,48696,25454,8518,10598,10566,16969,16970,16970,12744,31728,23340,16937,14791,12711,12711,10631,19081,42356,42356,25453,21228,14889,16969,16937,16937,17002,19050,16970,14889,25422,31759,23275,16936,33840,46584,38197,23341,23341,44504,33905,52889,57051,57051,57051,57083,57051,57083,57083,52857,46518,46485,46518,46518,46551,46551,46550,46551,42292,31759,42325,50776,25356,16903,35985,48631,110},
{52891,52891,52891,52891,52923,52891,52891,52891,52891,52923,52923,52923,52923,52955,52955,52955,55003,55003,55004,55036,55036,57084,55036,55036,55036,55036,55035,55035,55035,55004,55004,55003,55003,57084,57084,57084,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,55036,55036,55035,55036,55036,55003,55003,55003,55003,55003,55003,55003,55003,52923,52891,50843,50810,50810,48762,48762,48762,50810,50842,50842,52891,52891,52891,50843,50842,50842,50810,50810,48762,48762,48730,48730,48730,48730,50810,50842,52890,52891,52891,52891,42455,34101,23504,23471,21358,17132,19277,19213,19245,17100,17100,21294,25617,19213,12842,12809,17068,17100,17068,12776,12841,17100,10663,10696,17035,17035,10663,10599,14889,27761,27729,27762,17100,17035,10663,10631,14922,10663,8550,14889,12776,8550,14889,14954,10598,10663,12776,8517,10598,14857,10598,8518,14922,10598,8518,14857,12744,10598,12808,23503,23503,10631,8485,8485,10566,10598,10598,10566,27534,38066,38131,36018,40212,38066,29647,25389,16905,14792,12743,10598,14791,12743,23275,25421,40179,46551,23341,8518,10598,10598,12711,12743,12711,10630,31760,29647,27534,14792,14856,19050,19082,25421,42357,33970,23373,23308,17002,14889,14856,16937,16937,14857,10631,8518,23276,31726,29614,25454,33938,42391,33938,14857,25454,44503,40212,57083,57051,57051,57083,57083,57083,57083,57083,42291,44437,44404,42324,42292,42324,42324,42292,42325,40211,35953,54971,44437,25355,23242,40178,46518,195},
{52891,52891,52891,52891,52923,52891,52923,52923,52891,52923,52923,52923,52923,52955,52955,52955,55003,55003,55004,55036,55036,55036,55036,55036,57084,55036,55036,55035,55003,55004,55003,55003,55003,55036,57084,57084,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,55036,55036,55036,55035,55003,55003,55003,55003,55003,55003,55003,54971,52923,52923,52891,50842,50810,50810,48762,48762,48762,50810,50842,50843,52891,52891,52891,50843,50843,50842,50810,50810,48762,48762,48762,48730,48730,48730,50810,52890,52890,52891,52891,52891,40375,34068,25617,34068,23471,17165,19245,17132,19213,17067,14955,17067,21423,19245,17067,14954,17100,21358,21358,17100,12809,17100,10696,12841,14954,14890,10696,10663,12809,17067,14922,14922,12744,14954,10696,10631,12841,10631,8550,12809,12776,10663,12809,12776,10631,10631,12711,8485,10566,14857,8486,8518,14857,10598,8550,12744,10631,8518,12776,23438,21325,10599,8485,8485,10566,8485,8453,6372,27501,38098,33905,29678,44437,33808,27533,21163,12743,14824,19082,16937,12678,19017,25421,21227,35986,40244,23308,8518,10598,10598,10631,12711,12678,10598,31727,31792,38164,16937,19114,29712,33938,38164,40278,27567,19083,14824,12743,10630,12679,12744,16937,14857,10566,8517,21130,29581,38066,23406,36084,25422,14889,8485,23341,40212,46550,57083,57050,57051,57083,57083,57083,57115,52824,35920,44405,44405,42324,42292,42292,42324,42292,42292,40179,40211,55003,38098,31694,38065,46486,48663,199},
{52891,52891,52891,52891,52923,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52955,55003,55003,55004,55036,55036,55036,55036,55036,57084,55036,55036,55036,55036,55003,55003,55003,55003,55036,57084,57084,57084,57116,57116,57116,57116,57084,57084,57084,57084,57084,55036,55036,55036,55035,55003,55003,55003,55003,55003,55003,54971,52923,52923,52923,52891,50842,50810,50810,48762,48762,48762,50810,50842,52891,50843,50843,50842,50843,50842,50842,50842,50810,50810,48762,48730,48730,48730,48730,50810,50842,52890,52891,52891,52923,42455,31988,29842,38229,25616,19278,21358,21326,19245,19245,23439,23471,21358,21326,21358,19245,19245,23471,23471,19278,14987,19180,17100,19213,14987,14922,14954,17035,14954,14922,12809,12809,14857,17034,12841,14889,14922,12776,14889,17067,17002,19212,19180,12809,12776,12744,12809,10663,12711,14889,10663,10631,14889,12711,10631,12809,12744,10696,14889,23406,21325,10599,8518,8518,8518,19050,19082,19082,29646,33872,40178,42258,44405,21195,21162,16937,14791,16937,16905,14824,10565,16937,25421,16937,35986,44470,23308,8518,10598,10598,16970,19083,19115,14792,31760,31824,36051,14856,31792,42390,40244,38164,38164,23341,14824,17002,14824,10598,10598,12679,17002,14857,10598,8485,16937,33808,42358,23341,31825,23341,14857,14824,21163,35954,52890,57083,57083,57083,57083,57083,57083,59164,42259,44404,50744,48631,46551,46550,46550,46550,46550,46550,46518,48631,50744,48664,44437,46550,48631,50744,196},
{52923,52891,52891,52923,52923,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52955,55003,55003,55004,55035,55036,55036,57084,57084,57084,55036,55036,55036,55035,55035,55004,55004,55035,55035,55036,57084,57084,57084,57116,57116,57116,57084,57084,57084,57084,57084,55036,55036,57084,55036,55003,55003,55004,55003,55003,55003,54971,52923,52923,52923,52891,50842,50810,50810,48762,48762,48762,50810,50842,50843,50843,52891,52891,50843,50842,50842,50843,50842,48762,48762,48762,48730,48730,48730,50810,50842,52891,52891,52891,52923,42423,32020,34068,40375,31923,23504,23504,21358,19245,19213,17100,17100,23471,19180,12842,12841,19180,25584,23536,21391,14954,17099,14922,14890,21326,21293,12808,12809,17067,27762,29842,25583,14889,21358,27729,19148,19180,27697,17002,14889,12776,14857,14889,17002,12809,14889,14889,12776,12809,14922,12744,12776,16970,12776,14857,17035,12776,12776,17035,25551,12809,10598,8518,14792,21163,31760,35985,33840,35920,33840,40178,42290,50743,33840,29614,23276,16969,19115,21163,14824,14856,19050,23340,23341,42325,50809,23341,8517,10598,10598,16970,19018,19082,14792,33873,31792,36051,14824,21195,25453,25453,25421,25421,17002,12743,16970,14824,10565,10566,10598,17002,16970,10631,10598,16937,38099,44471,21261,27599,36019,14889,25422,25422,35953,57115,57051,57051,57083,57083,57083,57083,57051,35952,52857,59164,42292,21130,19050,21130,21130,23275,38098,54970,44437,44373,44405,42324,44373,42324,42324,171},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52955,52955,55003,55003,55004,55003,55035,55035,55036,57084,57084,57084,55036,55036,55036,55003,55003,55003,55003,55003,55035,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,55036,55036,55036,55036,55003,55004,55004,55003,55003,55003,52923,52923,52923,52923,52923,50842,50810,50810,50810,48762,48762,50810,50842,50843,50843,52891,50843,50843,50842,50842,50843,50810,50810,48762,48762,48730,48730,48762,50810,52891,52891,52891,52891,52923,40310,29875,29907,40407,38262,23471,21326,19213,19245,17100,14955,14987,23504,17100,10728,10728,17132,23504,23536,19278,14987,14987,12744,12744,19213,19180,10663,12808,19147,25649,25649,23471,10631,21293,23471,14986,17099,25584,12776,12744,10630,10631,14889,14857,10631,10663,12711,8485,10598,12777,8518,8518,12776,10598,8518,14889,12743,10598,14921,23374,10663,10598,8518,8518,12744,33905,38099,38098,40179,42291,46484,48597,48663,21162,21227,19082,12711,14824,23276,12679,14824,16905,23276,25453,42325,46584,23276,8518,10598,10598,14824,14856,14856,12679,27566,29647,36051,12743,12711,19050,10631,10663,10631,12712,14889,19082,16970,12711,12711,12744,16970,14857,10598,10566,21163,44503,44471,23341,23340,36051,23309,40213,31761,44405,57115,57051,57083,57083,57083,57083,57115,48631,40146,55002,57083,33872,25388,27533,29614,29614,31727,40211,52857,42325,42325,44405,44372,42324,42324,42324,165},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,55003,55003,55003,55004,55004,55004,55035,55035,55036,57084,57084,57084,57084,57084,55036,55003,55003,55003,55003,55003,55035,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,55036,55036,57084,55036,55003,55004,55003,55003,55003,55003,52923,52923,52923,52923,52891,50842,50810,50810,50810,48762,50810,50810,50842,52891,52891,52891,50843,50842,50842,50842,50842,50810,50810,48762,48762,48762,48762,48762,50810,52891,52891,52891,52891,52923,40342,29908,29940,32020,32020,21358,21390,19278,19246,19246,19213,19245,23504,19245,15019,12809,19278,27827,27795,25649,14955,17100,12841,12841,21326,17100,17067,17034,17034,27729,27794,25584,10663,17067,12777,12776,21293,29810,12712,14857,12711,12744,17002,12809,10663,12744,12776,8550,10631,14889,10631,12744,14889,12744,10663,21293,27729,10663,12776,10631,10630,10599,8518,8485,8453,14792,21228,21228,27501,38065,52856,52889,55002,38066,25421,25454,19115,14792,21163,12744,14856,19082,23308,16969,40244,40277,19115,8518,10598,10598,12711,21131,21195,23276,33905,33905,36018,12711,16937,23341,10631,12711,12711,12744,14857,19083,14824,10631,12711,14824,14889,14889,10598,10598,16937,40244,44470,25421,23340,38132,25454,46551,36019,54970,57051,57083,57083,57083,57083,57083,57115,40113,48598,57083,50776,40211,40212,38099,40179,40212,46518,54970,46518,42357,46518,46518,46518,46518,46517,46517,174},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52955,52955,55003,55003,55003,55003,55003,55036,55036,55036,55036,55036,57084,55036,55036,57084,55036,55036,55003,55003,55003,55003,55036,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,55036,55035,55003,55004,55003,55003,55003,55003,55003,55003,52923,52923,52923,52923,52891,50842,50810,50810,50810,50810,50810,50810,50842,52891,52891,52891,52891,50843,50842,50842,50842,50810,48762,48762,48762,48762,48762,48762,50810,52891,52923,52891,52891,52923,42455,36149,34036,27697,23504,21391,19278,19278,17067,19148,19148,17067,19180,17100,17035,17035,17067,19212,19212,19180,17035,19115,17035,17035,19148,19147,17035,17035,17034,19180,21261,19180,17034,19115,17002,17002,17067,19147,14890,14889,14889,14889,14890,14922,14889,14889,14890,14922,17002,14922,14889,17002,17002,14922,14922,19115,19147,16937,16970,16969,14857,10598,8518,8485,8485,10631,23309,23308,31727,38098,40211,38066,33905,23308,29647,23373,21228,14824,16969,14824,14824,14791,21195,16937,40212,42358,17002,8518,10598,10598,16937,21163,21131,14856,29680,29679,36018,12679,23276,23341,10663,12744,12711,12712,12744,17035,14857,10663,12744,12711,17002,16970,10598,8485,12711,38131,44503,25486,27566,38131,33873,40245,38067,57083,57051,57083,57083,57083,57083,57083,54937,33774,52825,57116,35953,16968,19049,16937,16937,19017,31759,52857,42292,52890,40147,27469,27501,25388,25388,31695,173},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,55003,55003,55003,55003,55035,55036,55036,55036,55036,57084,55036,55036,55036,55036,55036,55004,55003,55035,55035,55003,55035,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,55036,55003,55003,55004,55003,55003,55003,55003,55003,54971,52923,52923,52923,52891,52891,50842,50810,50810,50810,50810,50810,50842,52891,52891,52923,52891,52891,52891,50842,50842,50842,50810,48762,48762,48762,48762,48762,48762,50842,52891,52891,52923,52923,55003,36052,21261,21260,19180,19115,17067,17067,17067,16970,16969,16970,16970,16970,17002,16970,16970,16937,16937,16938,16938,16938,16937,16970,16970,16970,16970,16970,16970,16970,14889,14889,16970,16970,14889,16970,16969,14857,14857,14889,14857,14857,14857,14857,14857,14857,16937,19083,16970,14890,16970,21196,19115,16970,16970,14889,14857,14857,14889,14889,16937,14857,10598,8518,8485,8485,12711,23341,21260,31760,38098,38099,31760,29680,25421,31760,27567,21163,14824,14857,12743,14791,12743,21195,21195,42357,48664,17002,10566,10598,10598,19050,16969,21131,14856,29679,29679,36018,12711,25454,23308,12711,12776,12776,14889,12711,16970,14857,10566,10566,10566,16970,16969,10598,8485,10566,38132,46584,25486,25421,27566,40244,38132,48631,57083,57051,57083,57083,57083,57083,57116,44372,33774,44372,46518,40211,40211,40212,42325,42325,44437,46518,44405,46518,54938,23275,19082,21163,21130,21162,25356,164},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52955,55003,54971,55003,55003,55003,55004,55035,57084,57084,55036,55036,57084,57084,57084,57084,55036,55036,55036,55003,55035,55035,55035,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,55036,55035,55003,55003,55004,55003,55003,55003,55003,55003,54971,52923,52923,52891,50842,50842,50842,50810,50810,50810,50810,50842,52891,52923,52923,52923,52891,50843,50842,50842,50810,50810,48762,48762,48762,48762,48762,48762,50843,52891,52923,52923,52891,55003,38132,12744,12776,12776,12776,12776,14857,12776,12776,12743,12711,12711,12711,12712,12712,12711,12711,10631,10663,10631,10631,10631,10631,10631,12711,12711,10631,10630,10630,10630,10598,10598,10631,12711,10631,10598,8550,8550,8518,10598,8550,8518,10598,10566,8518,10598,10631,10631,10631,12711,19082,16970,12744,12711,10598,8518,8518,10566,10566,8518,10566,10598,10598,8518,8518,12711,23309,23308,31792,38131,31792,21163,25421,25421,29679,31825,19115,14824,14856,12711,12743,14824,19082,19115,40244,46616,16970,10566,10598,10598,16937,16937,16937,14824,31792,29647,33938,12711,27534,23308,10631,14857,14857,19115,14857,16970,14857,10598,8518,10566,14889,16969,10631,10566,12711,38099,48697,36051,31760,33873,33905,35986,54970,57051,57083,57083,57083,57083,57083,57115,37968,44404,54970,50744,42292,40212,40212,40244,42292,46551,52857,46486,52857,48632,40180,42292,42292,42260,44405,50776,210},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,54971,55003,55003,55003,55003,55035,55036,57084,57084,55036,57084,57084,55036,57084,57084,55035,55003,55036,55035,55036,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,55036,55003,55003,55003,55004,55003,55003,55003,55003,55003,55003,52923,52923,52891,50843,50842,50810,50810,50810,50810,50810,50842,52891,52891,52923,52891,52891,50843,50842,50842,50810,50810,50810,48762,48762,48762,48762,50810,52891,52923,52923,52923,52923,52923,50810,46552,46584,46584,46584,46584,46584,46584,46584,46584,46584,46584,46584,46584,44504,44504,44504,44503,42391,42423,40310,34004,33972,33971,48663,54937,48632,40277,40245,38164,23374,14954,25454,35986,25486,23341,14889,23341,12776,10598,8518,10566,10599,10599,10599,10598,10566,10598,10598,10599,10631,10631,10598,19050,21228,12711,12711,12679,10631,10599,10598,10598,10598,8518,8518,12744,23373,23341,31792,38098,33905,27534,27501,29679,33873,31858,17035,16969,14857,10598,10598,12711,19082,19050,40245,44503,16970,8518,10598,10598,10566,8485,10565,12711,29679,31792,27566,14889,31760,25421,10631,14824,12776,21196,17002,14889,14825,10598,10598,10630,14889,16970,10631,12744,14857,35986,48664,40245,31760,25421,25421,38099,57083,57050,57083,57083,57083,57083,57083,52824,31693,50776,57116,44405,16904,14824,16904,14856,16936,29646,52857,46551,54970,25356,14824,16936,14823,12711,19049,42292,198},
{52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,55003,55003,55003,55003,55035,55036,57084,57084,57084,57084,55036,55036,55036,57084,55036,55003,55003,55003,55035,55036,55036,55036,57084,57084,57084,57084,57084,55036,57084,57084,57084,57084,57084,55004,55003,55003,55003,55003,55004,55036,55003,55003,55003,55003,52923,52923,52891,50843,50842,50842,50810,50810,50810,50810,50842,52891,52891,52891,52891,52891,50843,50842,50842,50842,50810,48762,48762,48762,48762,48762,50810,52891,52923,52923,52923,52923,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,50875,50875,50875,50875,50843,48762,48762,46682,40376,38263,36149,52890,63421,57084,46584,44471,44503,25454,17035,31857,42357,25551,25551,14889,23374,12712,12744,12712,10598,10631,10598,10598,10566,10598,8550,8518,8518,8518,8518,10598,23342,16937,12744,12744,10598,10598,10598,10598,10599,10598,8518,8518,14856,25421,25421,29647,38098,42357,42357,38131,35985,27534,23341,14889,10631,10630,10566,10565,10566,12679,14792,38164,38164,16970,10566,10598,10598,14824,14856,12711,12711,19082,35986,25421,23276,27502,23308,12711,12744,14889,19083,12711,16937,14857,10631,10598,10598,14857,16970,12711,10630,12679,38066,44471,38131,31760,25388,25453,48664,57083,57051,57083,57083,57083,57083,57116,42227,29580,44372,48598,40179,38034,38066,40179,40211,42324,44405,46518,46518,48631,38066,38131,38099,40211,40212,42292,46550,171},
{54971,52923,52923,52923,54971,52923,52923,52923,52923,54971,54971,54971,55003,55003,55003,55003,55003,55003,55035,57084,55036,55036,57084,57084,57084,55036,57084,55036,55036,55036,55035,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,55004,55003,55003,55003,55004,55004,55004,55003,55003,55003,54971,52923,52923,52891,52891,50842,50842,50810,50810,50810,50810,50842,52891,52891,52891,52923,52891,50842,50843,50843,50843,50810,50810,50810,48762,48762,48762,50810,50842,52891,52923,52923,52923,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,50875,50875,50843,48762,48730,46649,46617,38263,36182,34004,50745,61309,50810,48729,42390,40278,27600,17002,27599,42390,31825,23341,10663,25454,12712,14825,12776,10566,10631,10631,10631,8518,8518,8518,8518,8518,10599,12679,14824,14792,10598,10598,10598,10598,10598,10598,10598,10599,10598,8518,8518,16969,23340,23308,25421,38066,42324,38163,38098,36018,29647,19148,14889,12711,8485,8517,10566,10566,12679,19050,46583,38132,16970,10566,10598,12711,21195,19082,19082,14824,21163,33938,23341,23308,29712,23276,12711,12744,14857,19115,14857,16970,16970,10631,10566,10565,14856,19083,12744,10598,12711,33873,35986,31727,35953,31628,35952,55002,57083,57083,57083,57083,57083,57083,57083,31661,40178,52889,50744,44437,44373,44373,44405,44405,48599,50777,44437,50777,46551,40179,40179,40180,38099,40212,48631,52857,168},
{54971,54971,54971,54971,54971,54971,52955,55003,54971,54971,54971,55003,55003,55003,55003,55003,55003,55003,55035,55036,55036,55036,57084,57084,57084,57084,57084,55036,55036,55036,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,55036,55004,55035,55003,55003,55003,55004,55003,55003,55003,55003,54971,52923,52923,52891,50842,50842,50842,50810,50810,50810,50810,50842,52891,52891,52891,52891,52891,50843,50843,50843,50843,50842,50842,50810,48762,48762,48762,48762,50842,52891,52923,55003,55003,55003,54971,52923,52923,52891,50810,48729,48665,46616,44504,40310,38197,38165,36052,33939,31826,29745,27664,25552,23406,23374,19148,17003,17003,14890,19083,23309,17035,19148,19116,19083,17003,14857,14889,23309,16970,12776,12776,16970,12777,14857,12712,12744,12744,10631,12712,10631,10631,10663,10598,10631,10631,12711,16872,12679,10598,10598,10598,10598,10598,10566,10598,10599,10566,8518,8518,19050,23341,23308,33840,38131,42325,40244,38098,35985,35986,17035,12711,16937,8517,10566,8518,10566,16905,25388,46551,42391,14889,10598,10566,16937,23308,14792,16969,16969,23308,29679,23308,16937,33938,23341,14824,12744,17002,16970,16937,19083,16970,12744,12743,12679,14857,16970,12744,12711,12711,29647,31661,33775,35887,25322,46485,57083,57051,57115,57115,59163,57115,59164,50711,29547,48630,57116,50712,21130,14823,16904,16904,16936,29614,50809,48663,54970,21195,10597,10630,12743,10597,14823,38034,50744,171},
{55003,54971,55003,55003,55003,54971,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55036,55036,55036,55036,57084,57084,57084,55036,55036,55036,55036,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,55036,55003,55003,55003,55003,55003,55003,55004,55004,55003,55003,55003,52923,52923,52923,52891,50842,50842,50842,50810,50810,50810,50842,50842,52891,52891,52891,52891,50843,50843,50843,50843,50810,50842,50842,48762,48762,48794,48795,50843,50843,52891,50842,48729,46584,42358,38197,36052,33971,31858,27665,27664,27632,23439,25584,25519,23407,23439,21293,21293,19212,19115,21293,19116,14890,19148,19115,14890,19116,14857,10664,10598,10599,8550,8550,8518,10631,10631,12711,12744,12712,14857,19083,12744,12712,12712,10663,14857,14857,12712,12744,10663,12711,10663,10663,14824,16905,18953,18985,12711,10598,10598,10598,10598,10598,10598,10598,10599,8518,10566,8518,19082,23341,21260,33905,31727,31694,31726,31759,38131,27534,14824,12711,17002,8518,10566,10566,10566,14824,27534,46584,44471,14825,10598,10598,10631,21163,16969,19050,16937,23276,27534,27534,19050,36018,27599,12776,12744,16970,10631,10631,17034,14889,12744,12744,14824,14857,14857,14824,12743,12743,29614,35920,40146,27435,27403,52890,55003,57051,48664,50776,48664,46550,48599,33775,31660,42292,48631,42292,33873,35986,38066,38066,38098,42292,48631,44437,46551,38099,40179,40179,42292,42292,42324,46486,44405,188},
{55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,52955,55003,55003,55003,55003,55003,55003,55003,55035,55036,55003,55036,55036,55036,57084,55036,55036,55036,55036,55036,55036,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,55003,55035,55003,55003,55003,55003,55003,55004,55003,55003,54971,52923,52923,52923,52891,50843,50842,50810,50810,50810,50810,50810,50842,50843,52891,52891,52891,50843,50842,50843,50843,50843,50843,50843,48762,46617,42423,38230,33939,31826,29745,25519,25487,25487,23406,25519,25487,23439,25551,23438,23406,21325,21261,21293,19181,19180,23406,21261,21293,21326,17067,17067,14954,14889,14922,14889,17002,19180,14922,17003,17067,12809,12744,10598,10598,8518,8518,8518,8518,8518,10598,12711,10663,12744,14857,12776,10631,10599,10664,12809,12744,12744,14857,16938,12711,16872,14824,14824,12679,10598,10598,10598,10598,10598,10598,10598,10631,8518,10566,8518,19050,25421,19115,31760,33807,29580,29580,31791,38131,21163,14824,14824,19115,10631,8485,8517,12679,14824,21163,48664,42391,14824,10566,10598,10598,16969,16969,16905,16904,21195,31792,33905,21195,33938,33905,16970,12679,10631,12711,12711,16970,14889,14824,12744,14824,14857,14889,14824,10631,10598,27501,38066,35887,25289,38033,57083,57083,48664,21260,29777,17002,12711,14856,19049,38033,52825,50744,46518,44438,44438,44438,46518,48631,50777,44438,50777,44438,31728,31728,33808,31760,33873,46551,52857,46518,207},
{55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55004,55004,55003,55035,55036,55036,55036,55035,55036,55036,57084,57084,55036,55036,57084,57084,57084,57084,57084,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,55035,55003,55003,55003,55003,55003,55003,55003,55003,55003,54971,52923,52923,52891,52891,50843,50842,50810,50810,50842,50810,50810,50842,50842,50843,52891,52923,52923,52923,50810,48697,42423,36084,29745,25519,23342,19180,19148,17035,17035,17003,14922,16970,14922,14890,14922,14889,14889,17035,17035,19147,21229,19148,21293,19180,19116,19180,17002,17035,19116,17003,19148,21326,17035,19148,14922,14857,14857,12744,12744,12744,12712,17035,21228,12776,12744,8518,8518,8518,8518,8518,8485,8518,10598,12711,12711,12777,12776,10631,12809,12744,10598,12744,14889,14824,14792,10598,10598,10598,10598,10598,10598,10598,10598,10598,10598,10599,10598,10599,10566,21228,27566,25486,33873,29613,29580,29580,29679,29647,25389,19083,19083,21228,14824,8517,8517,10598,10630,16937,44406,38132,14824,10598,10598,10598,8485,8485,8485,19082,33873,38131,29647,14824,33905,33905,21228,12711,12711,12711,12711,14889,16970,12711,10631,12711,14857,16970,12776,10598,8485,25389,38033,29580,25321,48631,57051,57115,33873,23373,23373,12711,14856,12743,23275,40211,57116,52890,23275,16904,16936,16937,19017,27501,50744,50744,52890,27501,16936,16937,16969,19017,21162,40179,50744,48664,184},
{55003,55003,55003,55003,55003,55004,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55036,57084,55036,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,55036,55003,55003,55003,55003,55003,55004,55004,55003,55003,54971,52923,52923,52923,52891,50842,50842,50810,50842,50842,50810,50842,50843,52923,52923,50843,48697,42391,36116,33971,27632,27664,25552,23406,27665,25519,23374,25487,19180,21229,17067,14889,12809,12777,12777,12777,12776,12776,12776,12744,12776,12776,14857,19115,17035,17035,17002,14857,14889,12809,12777,14922,14890,12777,17002,17035,12777,12777,10631,10631,10664,10664,12776,12744,10663,14889,14890,10663,10631,8485,8517,8517,8518,8517,8518,8518,10631,12711,10631,10631,12712,12711,10599,10631,14792,14792,10598,10598,10598,10598,10598,10598,10598,10630,10598,10598,10598,10631,12776,12711,23341,27599,29680,33905,23307,27499,27500,25454,14824,16969,23341,25454,19115,14857,10565,16969,12711,12711,14824,40180,36019,12744,10566,10598,10631,16937,16937,12711,16937,31727,35986,29647,14824,31792,31825,23308,12776,12711,12711,12679,14889,16937,12711,10598,10598,12711,16970,12776,10598,8453,25356,33839,29549,27468,54970,57083,55002,27599,29712,17002,14824,14792,14823,29548,40179,48631,46518,31727,33840,35953,35953,35953,40179,46583,46518,48664,44438,46550,46551,46551,48631,48663,48631,44405,48664,182},
{55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55004,55003,55003,55003,55003,55004,55003,55003,55035,55036,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,55036,55004,55003,55003,55003,55004,55004,55004,55003,55003,54971,52923,52923,52923,52891,50843,50842,50843,50843,50875,52923,50843,46649,42423,38197,31858,29745,25552,25552,27664,25487,25552,25552,25519,27632,23407,21326,23374,21229,23439,25584,19213,23406,21229,14890,12777,10663,10663,12712,10663,10663,10631,10599,10599,10599,10663,12776,12744,12809,14922,12744,12744,10664,10631,10631,10663,12744,17035,17003,12744,12809,10631,10599,10631,8550,10598,10599,10663,14922,14889,10598,8517,8485,8485,8485,8485,8485,8486,8518,10598,10599,10631,12712,10631,12711,14792,10599,10631,10631,10631,10598,10598,10631,12679,10630,10598,10598,10599,14825,12744,23341,27566,27599,29647,19050,25356,21227,21228,17001,17002,25421,27567,21228,16937,12679,16937,19082,16970,14792,36018,42326,12712,10566,10598,10631,19050,16937,16970,19050,33873,35986,27567,10630,27566,31825,23276,17002,10631,10631,10663,14921,16969,12711,10630,10598,10663,14922,12776,10598,8485,25356,38065,29614,40146,57083,57083,46551,25519,21228,14824,14856,12711,19049,33774,48663,50776,46550,44470,44438,46518,46518,48631,50777,46518,52857,44405,27566,29614,25389,25356,27469,42259,52890,48631,52857,97},
{55003,55003,55003,55004,55035,55035,55003,55003,55003,55003,55003,55003,55003,55004,55004,55003,55003,55003,55004,55036,55035,55036,55036,55036,57084,57084,57084,57084,57084,57084,55036,55036,57084,57084,57084,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,55004,55003,55003,55003,55003,55003,55003,55003,55003,52923,52923,52923,52923,52891,52891,52923,48762,46649,36084,36052,25519,21261,19213,21326,23439,29778,27600,27632,29745,23406,27632,25519,19180,19148,17003,17035,19116,17035,21261,17067,12777,14922,14922,14889,19180,17035,12809,10696,8550,10598,10598,10598,10599,10598,8518,10598,10598,12744,12744,10631,12744,12776,10663,10664,10663,10631,14857,12744,12744,17002,12776,10599,10599,8550,10598,10599,10598,10663,10663,10663,19148,12776,8518,10598,10598,10598,8486,8486,8518,8518,10598,10663,10598,12712,14824,14824,16905,14824,14824,14824,12744,12712,14824,12711,10598,10598,10598,12744,10631,25454,29680,29679,29680,27534,25454,23373,27566,23373,23373,25421,27534,23373,21228,16937,21228,21196,21195,10598,35954,42390,12711,10566,10598,10631,19082,16937,16969,21130,31759,33905,29647,14824,25453,29680,19050,21195,10631,10631,12711,14889,14889,12711,10630,10598,10630,16970,14857,10598,8517,23275,40179,31694,48598,57083,57115,38099,21260,12679,10630,14856,12711,23274,38000,57083,57083,29615,19083,21131,19017,19050,25388,48631,52857,52890,29614,21162,23243,23276,23275,27469,40179,50744,48664,44405,95},
{55004,55003,55003,55003,55003,55003,55035,55035,55035,55003,55003,55003,55003,55004,55004,55004,55003,55003,55035,55036,57084,57084,55036,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,55004,55004,55003,55003,55035,55004,55003,55003,55003,52923,52923,52923,52923,52955,52923,44536,25454,19148,10663,10631,10664,16970,23406,23439,23374,23407,21261,23407,23407,19116,21293,21293,19148,23374,21229,19181,19148,12809,12744,12777,12776,12776,12776,12777,19116,14922,17003,21293,17035,14857,10631,10599,10631,10631,10631,10631,10631,14825,10599,10631,12809,12777,12744,14857,14889,12744,12777,10631,10664,12712,10663,14922,14857,10631,10663,10663,14889,10631,8486,8485,14857,12809,12776,16970,29680,21228,8485,8518,8518,8517,8518,8486,8518,12712,14824,16905,16937,12711,8518,8518,8518,8518,8486,8485,8518,10598,10598,10598,10598,25486,29712,29680,29680,27566,25486,25453,25518,27599,23373,23341,25422,25454,19082,10598,14856,10565,14856,12743,33905,38132,12711,10598,10598,10598,12711,12711,10631,21162,27533,33937,29647,19082,31760,31760,16969,21228,12744,10630,12711,14889,16970,12743,10566,10630,10631,16970,14857,10598,8517,19050,38033,35887,54938,57083,54938,27534,16937,12678,14824,14856,16969,23274,33839,48599,48631,33840,33872,33905,35953,35953,38099,48631,46550,48663,46550,48631,46550,46518,46550,50744,48631,44437,52825,42325,153},
{55004,55004,55004,55004,55035,55035,55036,55035,55036,55036,55004,55036,55003,55003,55003,55003,55035,55035,55035,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,55036,55004,55004,55003,55003,55004,55004,55004,55003,55003,52923,55003,55004,50843,38197,23374,14922,12744,10631,10664,17002,21261,21261,23407,21261,21261,23407,21229,19148,17067,14922,14922,12777,12777,17003,14890,14922,19148,17068,19148,17003,14889,14922,17067,14922,14922,14922,14922,14955,14922,21229,23407,17002,12809,10631,10631,10631,10631,10599,10599,10663,12776,10599,10664,14922,12777,10664,12776,10664,10663,10599,8518,10599,12809,12777,14857,14890,23374,17035,21196,21228,21196,19115,21196,25421,33938,27599,8486,8518,8518,8517,8518,8518,8518,12711,14792,14824,14824,10630,8486,8486,8485,10598,16970,21228,14857,12776,12744,10566,10598,25453,27599,27599,29679,29647,27567,27599,29680,27599,25453,23341,25422,23341,21228,8485,8452,14857,19050,19050,40277,36019,12711,10598,10598,10631,12711,12711,10566,19082,27565,36018,25421,10598,27567,31825,14857,19083,16970,10598,10631,12776,14890,12744,10566,10598,10598,16970,14889,10598,8517,19018,31758,42291,57051,57083,50744,19115,14889,14856,19050,19082,21194,23274,46518,52857,46550,44405,44405,44405,44438,46518,48664,48631,52857,42292,21162,21130,19049,16937,21097,38066,52890,50744,48599,16904,53},
{55004,55004,55035,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55003,55003,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,55036,55004,55003,55003,55003,55004,55004,55004,55003,55004,55036,48697,36052,25519,14889,10664,12744,12777,12744,10663,12744,12712,12712,12777,14890,19116,21261,19115,19148,19148,14954,14922,17068,17035,14922,14922,14922,14922,14890,19148,25487,19181,23439,19116,14857,14955,17035,14922,17067,17003,17035,19116,17003,19148,19116,12744,10631,10599,10631,10631,10599,10598,8518,8518,8518,10599,10664,10664,10599,10599,10631,10631,12712,10631,8518,10631,17035,31793,36052,31825,23309,17002,23309,25422,33873,29679,23341,12744,10631,8518,8485,8485,8486,8486,10598,12744,14792,19017,12679,8485,8486,8485,10599,21229,25487,21228,14890,12744,10598,10598,23341,27534,27566,27599,29679,29712,31793,29712,25518,25486,27534,25422,27567,21228,10565,8485,19050,21196,27534,44470,36019,12679,10598,10598,10631,16970,16937,14857,21163,31759,36018,25421,10598,29712,27567,12711,14857,17002,10631,10598,12744,16970,12776,10566,10566,10598,14889,14889,12679,10598,19083,31726,48663,57083,57115,42325,12744,12711,10598,19050,21227,21162,29549,54970,59196,33873,16904,16937,16969,16937,21162,42324,52890,50777,35920,29647,31759,33840,33873,35953,42292,46550,48664,48631,44405,173},
{55004,55004,55036,55036,57084,55036,57084,57084,55036,55036,57084,57084,57084,57084,55036,57084,57084,57084,57084,57084,57084,57084,57084,55036,57084,57084,55036,57084,57116,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,55036,55004,55003,55003,55003,55004,55003,55036,55036,46617,33907,21261,17035,14922,12744,12712,12744,10663,10631,10599,10599,10631,12744,12777,12776,12744,12744,12744,12809,14922,17035,21294,17036,14890,17003,17002,14890,14922,14922,19181,19116,14890,19148,23374,19180,19181,14890,14922,19180,14954,14890,14890,12777,12809,14890,14922,19115,12744,10599,10599,10599,10631,8518,8518,8518,8486,8518,10599,10631,10631,12712,10599,8518,8518,8518,10598,10599,8518,16970,27567,29680,31826,27567,19050,16970,21228,21260,8518,12711,14857,16970,16970,16937,16938,17002,19083,19082,16937,12679,8518,8518,8486,8486,10664,12777,14825,12776,12744,10599,10598,23373,25519,27567,27599,29680,29744,29680,25486,23341,19115,25486,25454,21228,21228,10598,10565,8485,8485,27534,44470,38132,10598,10598,10598,12711,19050,16969,16970,23275,31792,29679,23308,14824,25421,23341,12711,12776,21196,12711,10598,12744,17002,14889,12744,12744,12776,14857,14824,12711,12711,19115,38099,54938,57083,57083,29647,14824,14856,14888,19082,25421,21161,29581,46486,48663,35920,33872,35953,35953,38066,38099,46518,48664,50744,44405,44437,44438,44405,42325,46551,50744,46518,52857,25388,21130,86},
{55003,55036,55036,55036,57084,57084,57084,57084,57084,55036,57084,57084,57084,55036,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,55036,55003,55003,55003,55003,55036,55036,46617,31826,21261,19116,17003,17003,17003,14857,12744,12744,12712,10631,10631,12744,12744,12744,12744,12744,12744,12744,12744,12744,10664,10631,10664,12777,12777,17035,16970,17003,19180,17002,14922,17003,14890,17003,14922,14922,23407,23374,21261,17035,12809,14890,16970,12777,14922,14857,12744,17035,19148,14922,12744,10598,10631,8518,8518,8518,8518,8518,8518,8518,10663,12744,10631,8518,10598,10599,10598,10631,8550,10599,12744,14889,25519,25454,23309,12744,16937,16970,10631,16970,17002,21228,23309,19115,21228,21260,21260,23341,16970,8518,8518,8518,8518,8518,8518,8518,8518,10599,12712,10599,10598,23341,25486,25486,27567,29647,29680,27599,25454,19082,14824,25454,25486,14889,14856,14824,14824,12711,12678,21195,44438,36052,10598,10598,10598,10631,14824,14824,12711,23275,29646,36018,23276,14856,25421,25421,12711,14824,25422,12744,8518,12711,16970,12744,12712,12744,14825,14857,14824,12711,10631,19050,48631,57051,57083,52857,14857,16937,12743,14856,19050,31792,25387,42324,52890,48599,44372,42324,42325,42325,44405,46583,48631,52890,42260,16904,16969,19049,16969,19017,33872,50809,50744,46518,29581,29614,119},
{55035,55003,55036,55036,57084,57084,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,55036,55035,55003,55035,55068,50810,33907,21294,19148,17003,14890,14858,14857,12744,10631,10631,12744,12744,12712,10631,10631,12744,12744,12744,12712,12744,10664,10664,10664,10631,10631,10631,10631,10631,12744,12777,19116,19148,14890,14890,14922,14890,14922,17003,17035,19213,17035,19148,23407,19116,14890,14857,12777,14890,14890,14890,17036,12809,12809,19148,17002,10664,8518,8518,10598,10598,10598,8518,8486,8518,10598,10663,10631,10631,10599,10598,12712,10631,10663,8518,10663,17002,14889,19115,25487,23341,19083,14857,12776,14857,16937,21196,19116,21196,21228,23341,23309,10599,8550,8518,8518,8518,8518,10599,10631,10599,10566,10663,10631,10598,25421,27534,27534,27567,27534,27566,25454,21228,19050,14857,25454,25486,19115,21163,16937,16969,14824,14824,27502,44438,31825,10631,10598,10598,10598,10598,10566,8485,23275,31759,36018,23308,16937,27567,29712,12679,14824,23374,12711,10598,12711,17035,14825,12711,12744,14824,14889,14889,10630,8518,14824,50777,57116,57116,33873,14889,19083,19115,23308,23308,31759,25323,50776,59196,40179,14856,16937,16937,16937,19082,40147,52890,48632,42292,40179,40211,42324,42325,44405,46518,46518,52857,40212,35986,40180,144},
{55035,55036,55036,55036,57084,57084,57084,55036,57084,55036,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,55036,55003,55036,55003,40245,23374,17003,14890,12777,12809,14857,12777,10663,10631,10631,10664,12744,10664,12711,10599,10599,10599,10599,12809,19116,21261,19148,12777,10664,10631,10631,10631,12712,12744,10663,10631,10631,12776,14922,19148,17035,14890,17035,19148,14954,14955,14890,12809,14922,17003,21261,19148,14890,17003,17035,14857,12777,12809,12809,12744,14890,19115,14889,10599,10599,8518,8518,8518,8518,8518,8518,8485,10598,12712,12744,10663,12777,10631,8518,10566,10599,10631,8485,19115,40310,36051,17035,14889,10631,12711,12712,19083,14890,19083,19083,19147,19148,10631,10566,8518,8518,8518,8518,8518,8518,8486,8518,12744,10631,10599,25421,27534,27534,27566,25486,25486,23308,19050,16969,16937,25454,25422,31760,25454,10630,14792,12711,14791,35953,42390,29712,10630,10598,10566,12711,19050,19050,14824,25421,33873,36018,23308,16969,23341,31793,12711,12744,16969,8518,10566,10631,16970,12776,10598,10566,10598,16937,16937,10598,10565,10598,40147,48566,46485,19049,16904,19049,19082,21195,31759,29581,25387,44405,48631,40146,35953,38066,38098,38098,40179,44437,48664,50777,35953,33840,31727,31728,33808,42292,52857,50744,48663,16969,14791,16936,65},
{55035,57084,57084,57084,57084,57084,57084,55036,57084,55036,55036,57084,57084,57084,55036,55036,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,55036,57084,48729,29680,17035,17003,16970,17002,14922,14889,14857,12777,14857,14890,12777,12744,12712,10663,10663,10599,10599,12744,14922,19181,14922,14922,19148,19116,21261,19083,12744,10664,10664,10664,10663,10664,10663,10663,10664,10663,12744,10664,12744,12712,10631,8550,10663,10631,10631,10631,10631,12777,10663,10631,8550,8550,8518,8518,10598,8518,10599,8518,12711,10631,8486,8486,8518,8518,8518,8486,8518,8518,8485,8486,10598,8518,8486,8486,8518,8518,8518,8486,8485,12711,23309,23374,16970,10631,12744,14857,14825,14857,12744,12744,14889,25421,29645,16936,14824,8485,8486,8485,8485,8485,8486,8518,12711,12777,12711,10630,25421,27534,25486,27534,27534,23373,17002,14857,14824,14824,27599,23341,36019,25454,12679,14792,12743,10598,33840,42390,31793,10598,10598,10598,12744,17002,16970,16937,27502,33840,36018,21228,16937,19083,21228,14824,12744,21196,10598,10566,12711,19115,14857,10598,8485,10566,16970,16970,10598,10598,8517,14791,21129,25321,29579,31660,31627,29613,29613,44405,29613,38033,54970,50744,42325,42325,42325,42325,44405,46518,48664,50777,42293,21162,21162,21130,21163,23276,35986,50776,50744,48631,44437,44437,46518,180},
{55036,57084,57084,57084,57084,57084,57084,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57116,44471,21294,17003,14890,17003,14890,12744,10631,10631,12712,12777,12777,12744,10631,12712,12776,12776,12744,12744,21261,19181,14890,17067,17003,14890,14890,14857,19148,25552,21261,19148,12809,10631,10663,10664,10664,12712,12744,8550,8518,8518,8518,8518,8518,8518,8518,10599,10598,10598,8550,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8486,8486,8518,8486,8518,8486,8486,8518,8486,8486,8486,8485,8486,8518,8518,8518,8518,8551,8550,8486,8518,8518,8485,8485,8485,8453,8485,8453,6405,19049,27467,25355,16904,8485,8517,8486,8485,8485,8486,8518,12744,14889,12744,10630,25454,27567,27566,27566,27567,21195,14824,12711,10630,14824,25454,25421,40245,23341,12679,14792,12711,10566,33841,42358,33906,10566,10598,10598,12744,16937,16937,12711,25421,33872,36051,21195,25454,25454,25454,10631,12711,21228,12711,10598,12711,19115,12776,10566,8485,10566,16937,14889,10630,10565,8485,14824,23275,25322,29547,29579,29547,29646,25420,35952,27468,44405,59196,46518,16937,16936,16969,19017,19050,33872,54970,48631,44438,46518,46518,46551,46551,48632,48631,46550,52889,23275,14824,16904,16936,72},
{55036,57084,57084,57084,57084,57084,57084,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57116,44438,23374,19148,19148,19148,19148,16970,17035,19083,17035,16970,12744,10664,10631,10631,10631,12744,12776,12712,10631,12744,14857,17035,19181,14954,14890,19213,19148,19213,14955,12809,19148,19181,19115,14889,10631,10664,12744,12744,10598,10598,8518,8518,10598,10566,8518,8518,10598,10598,10598,10566,8518,8518,8518,8518,8518,8486,8518,8518,8518,8518,8518,8518,8518,8518,8518,8486,8518,8518,8485,8518,8518,8485,8518,8486,8518,8485,8485,8518,8518,8518,8518,10599,10599,8518,8486,8486,8485,8486,8486,8485,8486,8486,8485,8453,16937,25322,29514,19015,8485,8517,8486,8486,8486,8485,8518,14857,16970,12744,10631,27534,27599,29647,27599,25486,14856,12711,10598,10598,14889,29680,33906,40277,19148,12711,12744,10631,10598,16937,27535,29680,10566,10598,10598,10598,10566,10566,8517,25388,31792,36050,21163,23341,25454,23276,12711,12711,12711,12711,10598,12711,19115,12776,10566,8485,8485,16937,16937,10631,10566,8485,16905,29614,23209,29546,31627,29547,31694,27468,29613,25322,42259,46518,42292,38066,40179,40179,40179,42292,44405,48696,52857,23275,19049,21130,21130,21162,31727,52857,50744,48631,33873,35986,38066,38098,154},
{57084,57084,57084,57084,57084,57084,57084,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,55003,29680,27567,23309,16970,14889,17035,17035,17003,14889,14890,16970,14922,17003,14889,12744,10664,10631,8550,10599,10599,10599,10598,10631,14922,21261,27632,21294,14890,14922,17035,14890,14955,14922,14955,25552,23374,14922,12744,14857,8550,10598,10598,10598,8550,8518,8518,8518,10599,10599,10599,10598,8518,8518,8518,8518,8518,8486,8518,8518,8518,8518,8518,8518,8518,8486,8518,8486,8486,8486,8486,8518,8486,8486,8486,8486,8486,8453,8485,8485,8518,8518,10599,10598,10598,8518,8486,8518,8518,8485,8486,8486,8486,8486,8485,8485,8518,12678,23241,19016,8485,8518,8485,8485,8485,8485,8486,14857,17002,14824,12711,27535,27599,29679,29680,27599,16969,12679,10630,12711,16969,29679,38164,46583,19115,12711,21196,14856,16970,8485,10566,14856,10598,10598,10598,10598,8485,8485,8485,29614,33904,36050,19082,25422,23276,27567,14889,12679,12711,12711,10630,10631,17035,14857,10566,8485,8517,16937,16970,12711,10566,8485,12743,25421,21129,29546,31627,31692,31694,25387,27500,31727,54971,52857,42292,38067,38067,38099,40179,42325,50744,48663,44437,29614,31727,33840,33872,35953,40179,48664,52890,35986,29647,33840,31728,31760,146},
{57084,57084,57084,57084,57084,57116,57084,57116,57116,57116,57084,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,52923,31760,25422,25454,21228,23341,21229,17002,14890,12744,12777,14857,14890,16970,14857,14857,14890,12777,10631,10599,10599,10598,10631,16970,23374,21261,23407,27633,21261,19148,17068,14923,17035,17068,21294,25552,19181,19148,17035,14857,8518,10598,8518,8518,10598,8518,8518,8518,10598,10598,10599,10598,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8485,8518,10663,8486,8486,8486,8486,8518,8518,12679,19082,12679,10598,10598,8518,10599,10598,8518,8486,8486,8486,8486,8485,8485,8486,8485,8486,8485,8485,8485,8485,16936,14823,8518,8518,8485,8485,8485,8485,8485,12744,14889,14824,12711,27534,27599,29679,27631,25519,19083,12743,12744,16937,19115,25421,29680,44438,19115,10598,10598,14889,21228,10566,10598,10566,10598,10598,10598,12711,16905,14824,10598,29614,33905,36051,19017,31760,21195,29680,16970,14824,14857,16970,10631,10631,19115,14857,10566,8485,8485,14857,17002,12711,10631,10598,14824,27534,21161,31627,31627,31660,29646,23274,25387,38066,55003,50777,21162,16969,19049,19049,21130,31694,52857,52857,44405,40179,40179,40180,40180,44405,50776,48664,50744,23275,21194,23275,23275,25355,115},
{57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,38099,25454,25454,21228,19148,19148,21229,23342,21229,21261,17035,12777,12744,12744,10664,12712,14857,16970,12777,12776,19148,19148,17035,19148,17035,14922,17035,21229,27600,25487,17100,23439,23439,19148,19148,17067,14922,14922,14922,10598,8518,8518,10598,8518,8518,8518,8518,10598,10598,10599,10598,8518,8518,8518,8518,8518,8486,8518,8518,8518,8518,8486,8518,8518,8518,8518,8485,10663,12777,10598,8518,8518,8486,12776,10598,16937,35985,14856,10631,10631,10599,8518,10566,8518,8518,8485,8486,8486,8485,8486,8485,8485,8486,8485,8485,8485,8485,14791,14791,8518,8518,8485,8485,8485,8485,8485,10566,12711,12776,12711,27534,27599,27599,29680,27631,23341,14889,16937,16970,16937,27534,25421,40277,19083,10566,10598,14889,21228,8518,10598,10598,10598,10598,10598,14792,19082,21195,16904,25388,27566,38131,16969,25453,25486,38131,19082,14824,14857,14889,12712,12711,19083,14889,12711,12711,12711,14889,14857,12679,10598,10630,14856,27502,23242,31627,31660,27500,29614,23242,27468,40179,46485,44405,40179,42292,44373,42324,42325,44405,48631,52857,21162,16904,16936,16936,16936,29581,52857,52857,46518,40179,40212,42292,42292,44438,196},
{57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,48664,33938,27632,25519,25487,23438,19148,17003,14922,17003,19116,17035,17035,14890,10664,12744,14890,14857,12777,12776,21261,21261,14858,14922,12744,10664,10664,10664,17035,27633,23374,23406,12809,10696,12777,12809,12777,17035,17035,8550,10598,8518,8518,8518,8518,8518,8518,10566,10598,10598,10598,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8486,8518,8518,8486,8518,8485,10631,10664,8550,10631,10631,10631,12744,16970,10599,10663,8550,8486,8518,10599,8518,8518,8518,8518,8485,8486,8486,8485,8486,8485,8485,8485,8485,8485,8485,10598,16968,16936,8485,8485,8485,8485,8485,8485,8485,8518,12711,14824,12711,27534,27566,27567,27599,27567,21260,14889,16969,17002,14889,25454,25454,38197,16970,10598,10598,17002,23308,8518,10598,10598,10598,10598,10598,14856,19050,19083,14824,25389,27534,38099,19050,23341,29745,36018,25454,31793,29680,23373,21228,14857,21195,12776,10631,12711,12776,14857,14857,12711,10598,10630,14856,27502,23242,29579,31627,27500,23275,23242,31662,52890,57083,42292,31760,33840,33841,33840,40179,50744,48663,46518,42324,44405,44405,44437,44438,46518,48696,54970,23243,14823,16904,14824,16937,25388,181},
{57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57116,50809,38164,31826,29745,27632,25519,25519,21326,21293,19180,19181,23374,21261,14922,14857,12809,12744,12744,10631,10599,12744,17002,17068,19116,17003,23342,23342,19148,12809,12777,16970,21261,17002,10664,10663,10663,19147,17067,8518,8518,8518,8518,8518,8518,8518,8518,10566,10598,10566,10598,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8486,8518,8518,8518,8518,8486,8485,8485,8486,8518,8518,8518,10663,12744,10631,10632,10631,10631,10632,10599,10599,8518,8518,8486,8485,8486,8486,8485,8486,8486,8486,8486,8485,8486,8485,10598,21128,19016,8518,8485,8485,8485,8486,8485,8485,10598,10631,14824,12711,27567,29647,27631,27599,27599,21196,14889,14889,16970,14856,23309,31793,42390,16970,10566,10566,21196,21228,10566,10598,10598,10598,10598,10598,12679,12743,12743,10630,27501,31727,33905,16904,25454,29680,27534,25486,33971,33905,29679,21228,14857,19083,14857,10631,10598,12711,14857,14889,12711,10565,10565,12743,21228,21162,29547,31660,29580,27500,25355,31662,52857,54938,25420,19050,21162,23243,23243,29581,50744,55003,38034,25388,25389,25389,25388,31727,50777,50777,38098,29614,29614,27534,21163,33873,33872,105},
{55036,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,57148,57148,57116,57116,57116,57116,57116,57116,57084,57116,55003,42390,36084,36052,31923,29778,25551,27632,25519,19213,19181,19148,14857,14889,17003,14857,12777,10631,10631,10631,10664,14922,23374,29810,29746,19181,21261,23406,21293,21293,17002,21261,27633,17035,19148,25519,19148,8518,10598,8518,8518,8518,8518,8518,8518,10598,10598,8518,8550,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8485,8518,8518,8486,8518,8486,8486,8486,8485,8518,8486,8485,8518,8518,8518,10631,10631,12744,10631,10599,10599,10598,10599,8518,8518,8518,8518,8486,8518,8486,8486,8518,8486,8485,10598,8517,12711,14856,8518,8485,8485,8485,8485,8485,8485,10631,12744,14825,12743,29647,29680,29712,27631,27567,21228,14889,16937,16970,16969,23341,23341,44471,14889,10598,10566,21228,21196,10566,10598,10598,10598,10598,10598,10598,8485,8485,10566,31727,33840,14824,14791,29680,29680,25454,29712,33938,31793,31760,21163,16905,21163,14889,12679,10566,8518,12711,16970,12711,8485,8485,12711,16937,23242,29547,31660,31661,31726,23274,38066,46518,44437,44372,44404,44405,44437,44438,44437,46550,50777,29581,25388,27501,29582,29582,35921,44405,31727,25388,25421,23275,23275,19082,33840,31760,109},
{57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,57148,59196,59196,57148,57116,57116,57116,57116,57116,57116,57084,57116,57084,50777,42358,38132,40245,42358,42390,36084,31825,25487,21228,16970,17003,19180,19083,14922,12776,16970,17035,17035,17035,14889,14922,23374,23406,27600,25519,21293,25519,25552,25552,36117,33971,33971,29745,19115,8518,8518,8518,8518,8518,8518,8518,8518,10598,10598,10598,10598,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8486,8518,8486,8486,8486,8486,8486,8518,8486,8518,8486,8486,8518,8518,8518,8485,8518,10631,8518,10599,8518,8518,10599,10631,10599,8518,8518,8518,8518,10598,8518,8518,8486,8485,21162,12679,12711,12711,8518,8485,8485,8485,8485,8485,8485,10631,12711,14857,14824,27631,29680,29712,29712,29712,23309,16970,16969,19082,17034,23405,23341,42390,14889,10598,10566,21163,19115,10566,10598,10598,10598,10598,10598,14824,19050,19017,12711,31759,36017,46486,44405,40244,25487,16937,31857,33938,31793,29647,19050,19082,21228,14857,12711,10566,10566,12711,17002,12744,10566,8485,12711,19083,19017,29547,31660,31692,33839,25387,50744,59196,44405,27501,27501,29582,27501,31695,48631,54970,46551,42325,42325,40179,40212,44405,35953,23275,21130,23243,23275,21162,23243,21162,27533,29614,112},
{57116,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59196,59196,59196,57148,57116,57116,57116,57116,57116,57116,57116,57084,57084,57116,55003,46551,38164,36084,38197,38165,40277,52890,50711,21196,14857,19115,17035,16970,12777,17003,19148,17067,14955,14954,14955,14922,17003,23439,29745,27632,31923,31923,27665,27697,25552,27665,36084,19116,8518,8518,8518,8518,8518,8518,8518,8518,10598,10598,10598,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8486,8486,8486,8518,8518,8518,8518,8486,8518,8486,8486,8518,8486,8518,8486,8518,8518,10566,8518,8485,14857,10599,8518,8518,8518,8518,8518,10598,8518,8518,10566,8518,8518,21194,23308,19017,16936,8485,8485,8485,8485,8485,8485,8485,10631,10631,14857,10631,14857,14857,14857,14857,23309,21195,17034,17002,19115,19082,25453,23341,38164,14889,10566,10566,17002,19083,10566,10598,10598,10598,10598,10598,14856,16969,21163,16937,25453,33872,48631,40179,33873,27600,19115,33938,31857,31825,27534,19050,16969,23341,14824,12743,12711,12711,12744,16937,12776,12743,14792,14857,19050,14791,29515,31660,33772,35920,27435,46517,52857,33840,25420,27469,27501,27501,31727,46551,46518,31662,25355,23275,19049,25420,29614,21130,19049,21195,29647,23276,21130,21130,16937,27501,29614,109},
{57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57116,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59196,59196,59196,59197,59197,59196,59196,57116,57116,57116,57116,57116,57116,57116,57084,57084,57116,57116,52923,46551,38165,38132,38165,46584,55003,27567,21261,23309,14890,14922,12777,12777,14889,19116,23374,21294,21326,23374,21261,21294,23406,25520,34004,29778,25519,29810,29745,29745,34004,17003,8518,10566,8518,10566,8518,8518,8518,8518,8518,10566,10598,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8486,8486,8486,8486,8518,8518,8486,8518,8486,8518,8486,8486,8518,8486,8518,8518,8518,8518,10566,8486,8486,10631,10598,8518,8518,8518,8486,8486,8518,8518,8486,8486,8486,8518,23275,21194,16904,14824,8485,8485,8485,8485,8485,8485,8485,10631,14857,14857,8486,8485,8485,8485,6373,23308,21228,14856,14824,19050,19082,25454,25454,40309,14857,10598,10566,19083,19083,10566,10598,10598,10598,10598,10566,16937,16969,16970,16937,25421,29647,33873,27534,21228,17002,25454,33906,33906,33938,25389,19050,12743,16937,10631,12711,14857,16970,16969,16937,14856,29680,38100,36019,23276,16871,29547,31660,31692,33807,38000,50712,46518,44437,44437,44437,44437,44437,46518,46518,46518,42292,42324,42325,31760,31727,33840,31727,21195,21195,23275,21130,19082,21195,16937,29647,31792,115},
{57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59196,59197,59197,59197,59197,59197,59197,59196,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57116,57084,52923,46584,40277,36084,36084,25487,29680,40310,29680,23341,14857,17002,16970,17002,23308,31793,31891,31891,29746,25552,25487,21261,21294,27632,31891,38197,31890,29745,38197,19148,8518,8518,8518,8518,8518,8518,8518,8518,10566,10566,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8486,8486,8518,8486,8518,8486,8518,8518,8486,8485,8518,8518,8518,8518,8486,8518,8486,8518,8518,8486,8486,8518,8486,8486,8486,10598,14857,19115,21196,23308,29614,21163,12743,8485,8485,8485,8485,8485,8485,8485,10631,14889,17002,10566,8485,8485,8485,8453,21195,38197,33938,23341,21260,19082,25486,27567,44471,14857,10598,8518,19083,19050,10566,10598,10598,10598,10598,10598,10598,10565,16937,23276,27534,29614,27533,29679,27566,23308,31792,33906,33938,31825,23341,23308,16969,19082,19018,19050,16969,16969,16937,16904,14824,25454,38132,38099,25389,16904,29546,31659,31660,31759,46518,33808,31728,23308,23243,23243,21195,23275,42260,59196,46551,27501,27501,27502,27502,29647,46551,52858,27502,23243,23308,19049,23243,25421,19082,31760,33873,109},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,59196,59197,59197,59197,59197,59197,59197,59197,59197,59196,59196,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,52923,46616,38165,25486,19180,23374,23341,23341,17002,38066,48664,48696,50810,50777,50809,44503,36052,31891,29778,27632,27664,25552,27632,34003,38197,42423,40343,19148,8486,8518,8518,10566,8518,8518,8518,8518,10566,10566,10566,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8486,8486,8518,8486,8518,8486,8518,8518,8485,8518,8518,8518,8518,8518,8486,8486,8486,8518,8518,8485,8485,8518,8486,8485,10663,25487,31826,27567,23341,21196,25389,19082,10598,8485,8485,8485,8485,8485,8485,8485,10631,14857,16970,10599,8485,8485,8485,8485,14889,38164,31858,25454,36019,21228,23373,25454,44471,12776,10598,8518,19083,17002,10566,10598,10598,10598,10598,10598,12679,12678,23276,40212,27566,29647,25453,31792,31824,29679,31825,29680,25453,27566,31793,33938,36051,38132,38132,38132,38164,40244,40212,38131,25421,23341,38131,38131,25421,19017,27467,25322,21162,27533,27534,19082,16937,19050,25388,21195,25420,25421,33872,42292,31695,19049,21130,21195,21130,23275,31695,21163,14792,16937,16904,14856,19049,16969,14824,19050,21130,94},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59196,59196,59197,59197,59197,59197,59197,59197,59197,59196,59196,59196,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,55036,55035,55003,55003,46584,38131,33938,25454,21260,17002,14922,21261,33971,48729,52890,55003,59196,50810,46616,40310,31891,33971,29745,31858,29778,23471,27665,34004,17035,8518,8518,8518,8518,8518,8518,8518,8518,10598,8518,8518,10598,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8486,8518,8518,8486,8518,8518,10599,8518,8518,8518,8518,8486,8486,8486,8486,8486,8485,8486,8485,8485,8485,8518,12776,10663,10631,10663,12712,12679,23275,16969,8485,8485,8485,8485,8485,8485,8485,19050,29647,29647,14824,6405,8485,8485,8485,12744,31825,27600,23373,23341,19115,23373,23373,38197,12744,10598,8518,19083,16970,10598,10598,10598,10598,10598,10598,16937,19082,25389,33906,27534,27534,27566,31760,25453,25421,31792,27566,19082,25421,31793,33938,36018,38131,38132,38099,38164,40212,38164,38131,33905,27566,36051,36051,25421,19050,23307,21162,14856,27566,29614,27501,16937,16936,31760,19017,23275,27501,27501,25420,27501,29613,27533,27533,27501,25388,23307,19082,14824,16904,16904,16904,14856,12711,14791,19017,21130,96},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59197,59197,59197,59197,59197,59197,59197,59197,59196,59197,59196,59196,57148,57148,57116,57116,57116,57116,57116,57116,57084,57084,57084,55003,55003,55003,55004,52923,48697,33906,27599,19115,25454,25486,27534,35986,48664,55003,57148,55003,55003,52923,46616,46584,40310,34004,31890,27697,25552,23406,14890,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,10598,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8486,8518,8518,8518,8486,8518,10598,8518,8518,8486,8518,8486,8486,8486,8486,8486,8485,8486,8485,8485,8485,8485,8518,8518,8485,8518,8486,8486,14824,12711,8485,8485,8485,8486,8485,8485,8453,31728,48696,48631,27534,12744,10631,8485,8485,8518,14856,14856,16937,19083,16969,23374,25454,36084,12744,10598,8485,21196,16970,10566,10598,10598,10598,10598,14792,23308,14856,23308,31825,21195,23340,27566,23308,19050,21227,29647,29647,19082,21195,31792,35986,36051,38131,38164,38164,40212,40245,38164,38164,36018,27566,33905,29679,27501,29614,29647,29614,19049,21162,23275,25388,16904,16904,27534,16969,19049,27533,25388,25420,23275,25420,23307,23307,23307,23275,25388,25388,14824,19017,21163,23275,21195,21130,14856,19050,21195,93},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59197,59197,59197,59197,59197,59197,59197,59197,59197,59197,59197,59197,59197,59196,57116,57116,57116,57116,57116,57116,57116,57084,57084,55036,55003,55003,52923,52923,52956,50810,48697,38164,38132,38132,44503,52922,52922,52890,52890,50810,48761,46616,46616,50810,44504,38197,36116,34036,31858,31890,14889,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,10566,8518,10598,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,10598,8486,8486,8518,8486,8486,8486,8486,8486,8485,8486,8485,8485,8485,8485,8485,8486,8485,8485,8485,8485,8485,8518,8518,8518,8518,8518,10566,10598,8518,14824,19050,19082,19082,19050,14825,8518,8485,8485,8485,8453,8485,12776,17002,27567,31793,42325,10663,10566,8485,21195,16937,10566,10598,10598,10598,10598,12679,19115,16969,25421,31793,23276,31825,29647,29647,33873,31760,31792,31760,25421,19082,33873,29712,29647,31728,29680,31792,31727,31760,31727,31760,31759,27501,27566,27534,31759,27534,25389,16937,16936,16969,21162,27501,23308,19082,27533,29646,27468,33873,33872,29614,21130,25355,19049,16936,19017,19049,16936,19017,16936,23308,25421,29647,29615,27534,19082,21130,23308,93},
{57116,57116,57116,57116,57116,57116,57116,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59197,59197,59197,59197,59197,59197,59229,59197,59197,59197,59197,59197,59197,59197,59197,57116,57116,57116,57116,57116,57116,57084,57084,55036,55003,55003,55003,52923,52923,52923,52923,52923,52955,50842,46616,46616,50777,52890,55003,52923,50842,48729,46584,46584,44503,42423,44504,36084,31858,38197,21229,8486,10566,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8486,8486,8518,8518,8518,10598,8518,8518,8518,8486,8486,8486,8486,8486,8518,8486,8518,8486,8486,8486,8485,8485,8486,8485,8485,8485,8485,8485,8485,8485,8485,8518,8518,8518,8518,8518,8518,8518,8453,8453,6405,6405,6405,10566,10566,8485,8486,8485,8485,8485,10630,16969,27600,38164,42358,10599,8485,8485,25454,14857,10566,10598,10598,10598,10598,10598,16969,16937,25421,31792,23340,33905,21228,12678,16937,16969,23308,21195,19082,10598,21195,14856,8485,16937,19082,23275,23275,16904,25421,27501,23308,29647,31792,29646,21194,21130,21162,21130,19049,25388,27566,29679,27501,21130,27501,31759,27501,27533,31727,31792,31759,33872,33840,33840,33872,31727,31727,29647,21162,25421,29679,35986,31793,31760,23276,21130,25356,96},
{57116,57116,57116,57116,57116,57116,57116,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59196,59197,59197,59197,59197,59197,59229,59229,59229,59197,59197,59197,59197,59197,59196,59197,59197,59196,57116,57116,57116,57116,57084,57084,57084,55003,55003,55003,55003,52955,52923,52923,52923,52923,52923,52923,55003,55003,52923,52923,52891,52890,52923,52891,50842,50842,48729,46616,44536,42423,38165,27665,17035,8486,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,10598,8518,10598,8518,8518,8486,8485,8486,8486,8486,8486,8486,8486,8486,8485,8485,8486,8485,8485,8486,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8518,8485,8485,8485,8485,8485,8485,8485,8485,8485,8518,8518,8485,8485,8485,8485,8453,10630,16970,27599,38164,38100,8485,8485,8485,25486,14856,10566,10598,10598,10566,10566,10598,10598,10598,23308,29679,23308,23308,19082,10533,8452,8420,8452,8485,10598,10565,10565,10565,8485,14824,25421,29647,23308,21130,27501,27533,27501,31727,31727,25421,31727,33873,27533,31727,25356,19082,25388,27501,23275,19017,27534,23308,16904,21194,27469,29646,31694,33840,33840,31792,33840,31727,31727,31727,23275,23308,29614,33841,33873,31792,25389,21163,25389,98},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59197,59197,59229,59229,59229,59229,61277,59229,59229,59197,59197,59197,59196,59197,59197,59197,57148,57116,57116,57116,57116,57084,57084,55036,55003,55003,55003,54971,52923,52923,52923,52923,52923,52923,52923,52955,52955,52955,52955,52923,52923,52923,52923,52923,50842,48729,48729,46616,46616,46616,27567,8486,8518,8518,8518,8518,8518,8486,8518,10598,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,10598,8518,8550,8518,8486,8485,8486,8486,8486,8486,8486,8486,8518,8486,8486,8485,8485,8485,8485,8486,8486,8486,8486,8486,8485,8485,8485,8485,8485,8518,8485,8485,8485,8485,8485,8485,8485,8485,8518,8518,8518,8518,10631,19115,21228,21163,19115,21228,29647,31825,36051,10631,8453,8485,25421,14857,12679,12743,14824,14856,16937,21163,23275,21162,27501,21228,21163,19050,23275,12646,8453,8452,10598,12743,14824,14791,14791,14791,10598,14823,27502,31760,29711,21162,25388,31727,27501,31759,33905,31792,29614,25388,25356,23307,21195,21195,23308,27501,19082,12711,23308,19049,10533,18984,25388,27533,29581,31694,31759,31727,31695,25421,25356,19049,23275,23275,31792,33873,33905,31792,25421,21195,25421,99},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59229,59229,59229,59229,61277,61277,61277,59229,59229,59197,59197,59197,59197,59197,59197,59196,57148,57116,57116,57116,57084,57084,55036,55003,55003,55003,55003,55003,52923,52923,52923,52923,52923,52923,52955,52955,55003,55003,52923,52923,52923,52923,52923,52923,52923,52923,52923,50810,50810,27600,8485,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,10599,10599,8550,8485,8518,8486,8518,8486,8486,8486,8518,8486,8486,8485,8485,8485,8485,8485,8485,8485,8485,8485,8486,8486,8485,8485,8485,8485,8486,8518,8518,8485,8485,8485,8485,8485,8485,8485,8518,12678,8485,10566,16904,21195,25421,23341,21228,23373,31760,29647,31760,25421,25421,25421,27598,31760,31759,31759,31792,33872,31792,33872,33872,27533,27533,27534,25420,19050,21163,14791,8453,8452,8485,16937,19050,12711,12711,12678,12711,19049,31760,35986,35986,25388,25388,25421,31759,31792,29679,29646,23275,21195,23307,23308,23275,16937,21195,25421,23308,19050,25420,21195,8452,19049,27501,29614,31727,33807,31791,23243,23275,29614,25388,19050,23243,25388,31728,33938,31792,31759,25421,19082,25389,87},
{57116,57116,57116,57116,57116,57116,57116,57116,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59229,59229,59229,61277,61277,61277,61277,59229,59229,59197,59197,59197,59197,59197,59197,59196,57148,57116,57116,57116,57084,57084,57084,55003,55003,55003,55003,52923,52923,52923,52923,52923,52923,52923,52923,52955,52955,52955,52955,52923,52923,52923,52923,52923,52923,50842,50810,50810,52891,29680,8453,8518,8518,8518,8518,8518,8518,8518,8518,10566,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,10598,8518,10599,8518,8486,8486,8486,8486,8486,8486,8485,8485,8486,8518,8486,8486,8486,8485,8485,8485,8485,8485,8485,8485,8486,8485,8485,8485,8485,8485,8518,8485,8485,8485,8485,8485,8485,8485,8485,12646,16871,10598,12678,33642,21064,10631,8485,14856,21195,25454,29647,29680,31760,33872,31760,31760,35985,33905,33872,33905,35986,31792,31759,33905,27534,29614,29679,27533,21163,23308,14791,8452,8452,10565,14791,14791,10533,10565,10565,10598,16969,29614,31759,33905,25388,27501,33872,27468,33872,33872,27501,29614,29647,27534,27534,25388,21195,29647,29614,31759,25388,27501,33905,27501,29647,33840,33872,33905,35953,35985,29646,27501,33872,31760,31759,23275,25388,33873,35986,31793,31759,23308,19082,23276,87},
{57116,57116,57116,57116,57148,57148,57116,57116,57148,57116,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59197,59197,59229,61277,61277,61277,61277,59229,59229,59229,59229,59197,59197,59197,59197,59197,59196,57148,57116,57116,57084,57084,57084,55036,55003,55003,55003,55003,52955,52923,52923,52923,52923,52923,52923,52955,52955,52955,52955,52923,52923,52923,52923,52923,52923,50842,50810,50778,52923,31793,8485,8518,8518,8518,8518,8518,8486,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8486,8518,10599,10598,8518,8485,8486,8486,8485,8485,8486,8486,8486,8486,8486,8486,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,12710,14791,10598,16904,33839,29614,23309,29647,25421,23341,29680,33873,33873,35986,33841,33905,35986,35986,35985,33905,31727,29614,27566,29646,27534,25388,29647,31792,27534,25421,23308,12711,8452,8485,19114,25388,23308,25388,23276,23275,21162,23275,27534,31792,31792,25420,27501,31792,31727,36018,33905,29679,27533,27533,27501,27533,25420,23275,29614,27533,31760,25388,27534,31727,21162,29614,33840,35985,35985,38066,35985,35985,35985,33872,31727,31792,27501,19017,23275,25388,25421,25388,19017,19050,21163,87},
{57116,57116,57116,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59197,59197,59229,59229,61277,61277,61277,59229,61277,61277,59197,59197,59197,59197,59197,59196,59196,59196,57116,57116,57116,57084,57084,55036,55035,55003,55003,55003,52955,52923,52923,52923,52923,52923,52923,52955,52955,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,55036,36051,8453,8518,8518,8518,8518,8518,10631,12711,8518,10566,8518,8518,8518,8518,10566,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,10599,10599,8518,8486,8485,8486,8486,8485,8485,8485,8486,8486,8486,8486,8486,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,8485,10566,10598,12743,21196,27664,27567,38100,40245,25454,21228,42325,44439,29680,27534,14856,12678,27534,21195,21163,25388,40212,42325,42325,40212,33840,31727,23275,23340,23275,23308,25453,12711,8485,8485,14824,19050,19050,16936,16904,16904,16904,16936,29614,29679,27566,23307,25388,27533,25452,31727,29679,27534,23242,23243,25388,25420,25420,23275,25420,29646,27566,21162,27533,25388,12678,25420,31759,33872,33840,33872,33839,33839,31759,29678,25452,23275,25388,19049,25420,27501,25420,23275,19017,14824,19050,82},
{57116,57116,57116,57116,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59197,59197,59197,59197,59197,59197,59197,59229,59229,59229,59229,59229,61309,61310,61310,61309,61342,61342,61341,61310,61310,61310,61310,61309,61309,61309,61309,61309,61309,59229,59229,59229,59197,57149,57116,57116,57116,57084,57084,55036,55036,55004,55004,55004,55004,55004,55036,55036,55036,55036,55036,55004,55004,55004,55004,55004,55004,52955,55003,48730,48730,33874,8485,10566,8518,8518,10566,8518,12744,12776,8518,10598,10566,10566,10566,10566,10598,10598,10566,10598,8518,10598,8518,8518,10566,8518,8518,8518,8518,8518,8518,8518,10631,12744,8518,8518,8518,8485,8486,8518,8485,8485,8485,8486,8485,8486,8486,8486,8486,8485,8486,8486,8485,8485,8485,8485,8485,8518,8517,8517,8518,8485,8485,8485,8486,8486,8485,8485,8485,8485,8485,8485,8485,8453,19017,23308,14889,21228,19147,12711,12679,10663,21195,23276,44439,31760,16970,17002,8453,10598,10630,8517,14856,42292,42357,42390,40245,19050,23308,31760,27534,19082,21195,25420,12711,8453,10533,16969,23308,21163,19017,19017,19017,19082,21162,25421,27534,29646,21162,29646,29646,25452,33872,33840,25388,25388,25420,25421,29614,27533,23242,27501,33840,27566,16936,25388,25388,16904,29646,35985,38098,38066,38098,38066,35985,35985,35953,31792,25452,23308,19049,21162,23243,19049,16937,19017,16937,21195,97},
{57148,57148,57116,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,46551,36019,36019,36019,36020,38068,36019,36052,36019,36019,38132,38132,38132,38132,38132,40213,40245,40245,42293,42325,42325,42326,42326,42325,42326,42325,40245,42325,42325,40245,42326,40245,40245,42326,40245,40245,42326,42326,42326,42326,42326,42326,42358,40278,42326,42326,40277,40278,40278,42326,40278,40278,40278,42358,42358,42358,42359,42358,42358,42391,42359,21228,14889,14857,14857,16937,14824,14856,14857,12744,12744,12744,12776,12744,12776,12744,12744,12744,12744,12744,12744,12744,12744,12712,12712,10631,12711,10631,10631,12712,10631,10631,10631,10631,12744,10664,10631,10599,10598,10598,10598,10598,10598,10598,10566,10566,10599,10598,10566,10598,10599,10598,10566,8518,8518,8518,8518,8518,10566,10566,8518,8518,10598,10598,10598,10598,10598,10631,12711,10630,10566,10598,10566,8518,10566,12711,29679,19082,19050,19083,21228,14856,8485,8517,19050,16937,19050,25421,29680,21196,8485,8485,8485,19017,29647,35986,42325,42390,42357,38099,38099,42325,40277,35986,33873,31793,16904,16969,10598,16937,16937,12711,14791,14824,16937,12678,23275,35985,40147,40147,27501,40179,27468,27501,33904,31727,25420,25420,27566,27501,27501,25420,21130,25420,29679,31727,19081,25388,27501,23274,31727,35920,35985,35985,35985,38066,38033,35953,35953,33872,29614,21195,19017,21162,23308,23340,25388,23308,19049,29647,130},
{59196,59196,57148,59196,59196,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,35986,14857,14857,14857,14857,14889,16970,14922,21261,21261,14954,25487,21293,17035,23407,19148,17003,23309,19148,19083,23341,19115,19115,21261,17003,19116,19148,14954,17035,21228,14922,21228,21228,16970,21261,21196,16970,21229,19116,16970,21228,19083,17002,19148,17002,16970,17035,14922,14889,17002,14889,17002,17035,14890,17035,17003,14889,17002,17003,14857,17002,14857,12744,12777,14889,12776,12776,14857,12711,12744,12744,12744,12744,12744,10664,10663,12712,10664,10631,10664,10631,10631,10664,10663,10631,10631,10631,10599,10631,10631,12711,10631,10631,10599,10599,10631,10631,10598,10566,8518,10598,10598,8518,10598,8518,8518,10566,8518,8518,8518,10598,10566,10566,8518,8486,8518,8518,8485,8518,8518,8485,8518,10566,8517,10566,8518,8486,10598,10631,8518,8518,10598,10566,10566,8518,14824,29647,19050,19115,19114,21228,19082,10598,8485,12743,21228,14856,21163,27567,27535,8485,8485,16969,31760,44470,27501,42357,42358,42325,42357,42357,40277,40277,40244,40212,33905,29679,36019,25421,27567,31825,14856,12711,23276,31792,12776,16970,21196,23341,29615,23276,27501,31727,23275,35953,33808,27501,25420,31727,31792,19049,23275,21195,27501,31791,33872,23275,27534,33905,33904,38033,40146,40179,38098,38098,38066,35985,38098,31759,31759,33807,23275,23243,21195,19049,21130,23275,23308,16936,29647,125},
{59196,59197,59196,59196,59196,59196,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,33873,14888,14889,14889,14922,14955,14955,17035,17036,17036,14987,14955,14922,17035,17035,14955,14923,14923,14923,14923,14923,14923,14955,17003,14922,14955,14955,14923,14923,17003,14923,17003,17035,14923,17035,17035,14922,17003,14955,14922,17003,14955,14955,17003,14923,14922,14955,14922,14922,14922,14922,14922,14922,14890,14890,14922,14890,14922,14890,14857,16970,12776,12744,12777,12776,12776,12744,12744,12744,12744,12744,12744,10664,12744,12744,12744,10664,12744,12744,12744,12744,12712,10664,12712,12712,10631,10631,10631,10631,10631,10631,10631,10599,10599,8518,8518,10599,10598,10566,10566,8518,8518,8518,8518,8518,10566,8518,10566,10566,10566,8518,8518,8518,8517,10566,8518,8486,8486,8486,8485,8486,8486,8486,10566,8486,8518,8518,10598,10599,10598,10566,10566,10566,10566,10566,8518,16969,19115,19115,19082,19114,23276,12743,8485,8485,21228,14889,14889,25454,31826,10566,8485,25421,35985,40244,25388,42325,42390,42357,40277,40277,40245,40245,40212,38132,38131,38099,36051,27566,23341,21228,12678,14824,25453,31792,12744,8518,10631,12744,14889,17002,12744,10566,12711,29614,25420,27533,29646,29614,27533,23307,19081,16936,23275,36017,33840,27501,36018,42325,38163,40211,40179,38131,38098,29646,27533,25420,33872,23274,23275,27468,23242,23243,21130,29646,25420,21195,25388,19050,33840,131},
{57148,59197,59196,59196,57148,59196,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,52857,44405,40212,23309,12842,12875,12842,14987,14955,14955,14955,14923,14922,17003,17003,14955,14922,14922,14890,12842,12842,14922,14922,14890,12842,14922,12842,12842,14890,14890,14890,14890,12842,14890,12842,14890,12842,12842,14890,12842,14890,14858,14858,12809,12809,12810,12810,12809,12809,12777,12809,12777,12777,12777,12777,12777,12777,12777,12744,12776,12744,12744,12744,12744,12744,10696,10696,12744,12744,12744,12744,12809,14922,12777,12744,12744,12744,12744,10696,12744,12744,10664,12744,12744,10663,10598,10598,10598,10566,10598,10598,10566,8518,8518,8518,8518,10566,10566,10566,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8517,8518,8518,8517,8518,8518,8486,10566,8518,8518,8518,10566,10566,10566,8518,8518,8518,8518,10566,10566,21196,19050,19083,19147,17002,21228,16969,8485,12679,25486,21228,12743,21228,31826,12711,8453,25421,36018,35953,36018,42357,42358,42357,42325,42325,40277,40245,40212,38131,36051,36019,29777,25519,23406,21228,10630,12743,27534,31825,14889,12743,14856,14889,17002,17034,14857,10598,21163,23276,23275,33905,27534,25420,29582,33840,25356,25356,31694,36018,36018,27469,42292,29647,27501,29581,31759,33872,33872,31759,33840,31727,33839,31694,29646,33905,33840,27533,23275,33840,27501,21195,23275,19017,29646,128},
{57148,59196,59196,59196,57148,59197,59196,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,50810,42326,42326,23309,12744,14890,14890,14857,14922,14922,12809,14890,12809,12809,14922,14922,12809,14890,14858,12777,14890,14890,12809,14890,12841,12809,14857,14890,12809,14857,14890,12809,14858,14857,12809,14889,14857,12809,14922,14890,12777,14890,14890,12777,14890,14858,12777,14890,14857,12777,12809,12809,12776,12777,12777,10696,12809,12809,12744,12777,12777,12744,12744,12776,12744,12777,12777,10696,10696,12744,12712,14890,19148,12777,12744,12744,12744,12776,10696,10696,12744,12744,10696,12776,12744,10631,10631,10631,10598,10598,10598,10566,8518,8518,8518,10566,10566,10598,10566,10566,10566,8518,10566,10566,8518,8518,10566,8518,8518,10566,8518,8518,10566,8518,10566,10566,8485,8518,8518,8485,10566,8518,8485,10566,8485,8517,10566,10534,10566,10566,8485,8518,10566,8518,8518,10598,23308,19147,14889,19115,19114,21227,21260,10566,12711,19083,25454,10566,14824,36019,14857,8485,10630,31728,40212,42357,42357,42358,40277,42325,40277,40245,40277,38164,36051,29745,23503,23471,23471,25519,25518,16969,14824,25454,33906,36018,36051,36083,36051,36051,36051,38132,38131,33873,12711,23275,31792,25421,33905,33905,29614,27501,35953,40179,42292,35986,31727,44437,29647,27533,33807,35985,38066,38098,38098,38066,40147,33872,35985,35985,38066,33872,27533,29646,31759,23210,27468,31759,23243,38066,150},
{59196,59197,59197,57148,59196,59197,59197,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59229,38099,6437,8486,8518,10631,10631,10631,10631,10631,10599,10631,10631,10631,10599,10631,10631,10631,10599,10599,10631,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,8551,8551,10599,10598,10599,10599,10599,10599,10599,10599,10599,8518,10566,10566,8518,10598,8550,8518,8518,8550,8518,8518,8518,8518,8518,8518,12744,12712,12744,14857,12744,12776,14857,10663,10663,10664,10631,8551,10664,10663,10631,10663,10663,10599,10663,10631,10631,10631,10631,10598,10631,12711,10631,10599,10598,10598,10598,12711,10599,10598,10598,10566,10598,10598,10598,10598,10566,10598,10566,8518,8518,10598,8518,10598,10566,8518,10566,10598,10631,10598,10566,8518,10566,10598,10631,10598,8518,10598,10598,10631,10631,10598,10566,10566,10598,10598,10598,10598,10598,8518,14824,23373,23405,16969,19082,19115,23340,25486,10598,14824,19082,31825,8485,12711,31825,19083,8485,8453,29615,48632,27534,40212,42358,42325,42357,40277,40244,36051,29745,23503,23471,23503,23471,23438,25551,33938,17002,12743,27599,33906,23341,21228,23309,23309,23341,25454,23374,21196,23308,14791,21162,31792,29647,33905,38099,38098,23275,21162,38098,33905,33905,25388,31695,35985,38034,25355,25388,25388,27469,33840,38065,33840,19049,23275,27501,33839,38098,35953,29647,27469,29614,35952,38066,35920,42292,166},
{59196,59197,59196,59197,59197,59197,59197,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59229,40180,8518,8518,8518,10599,10631,10631,10631,10631,10631,10599,10631,10631,10631,10631,10631,10631,10599,10599,10599,10599,10631,10631,10599,10599,10599,10599,10598,10598,10599,10598,10566,10599,10566,8518,10599,10599,10599,10599,10599,10598,10599,10598,10599,10599,8518,8518,10566,8518,8550,8518,8518,10566,8518,8518,8518,8518,8486,8518,8518,8486,12712,12744,12712,14824,14824,12776,12744,12744,12744,12712,12744,12712,10664,10664,10663,12712,10663,10663,10663,10631,10631,12711,10599,19115,16970,10631,10631,10598,10598,10598,10598,10631,10631,10566,12711,12679,8518,10598,10566,10598,10566,8518,10598,10566,10566,10598,8518,10566,10566,8518,8518,10598,10631,10598,10566,10598,10566,10566,10598,10598,8518,10566,10598,10566,10566,10598,10566,10566,10566,10631,10598,8518,8518,10631,17002,21195,25486,16969,17002,21227,29679,29711,10630,16937,42357,35986,16937,19050,33874,25454,8485,8453,29615,44406,27566,40244,42358,42325,40277,42325,31858,25583,25616,25584,25583,23471,23471,23438,21293,31825,19082,12678,27567,31825,14889,10630,10631,10663,14889,17002,14857,8485,14856,14856,21162,31792,19082,31792,36018,38099,25421,16904,31759,40212,40212,31760,33840,42292,38066,29614,27534,29582,27501,31759,35985,25420,25388,25388,19017,19016,16904,14823,16904,19049,16904,19049,33872,40146,44437,160},
{59196,59196,59196,59197,59197,59196,59196,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,50777,40179,38099,40179,19050,12809,17035,12842,14890,14890,21229,14922,14890,14857,14890,12809,12809,14857,12777,12777,12809,12776,12744,14857,14890,14922,12809,14922,17003,12776,17002,19180,12777,17035,19115,12809,14857,12777,12744,21228,17002,12744,17002,12744,10696,14921,12777,12744,12744,10631,12777,14922,10631,12744,14889,10631,12744,16970,12744,12744,14889,12711,10631,10631,10631,12776,14889,10631,12776,14857,10631,14857,14857,10663,10663,10663,10631,10663,10631,10631,10631,10631,12711,16970,33841,19051,10631,10631,10598,10598,10598,10598,12744,10631,10566,10631,10631,8518,10598,10599,10598,10598,10631,10598,10631,12679,10598,10598,8518,10598,8518,10566,10598,10631,10598,10598,10598,10566,8518,8518,10566,8518,10566,10598,8518,8518,10598,8518,8518,10598,10599,10598,10566,10598,12744,25454,12776,29680,19082,19082,27598,31824,29679,10631,10631,38132,40212,33905,35986,27567,25422,10566,19050,31793,27566,25421,40245,42358,42325,42325,42390,33971,25584,27664,25551,23471,23438,23438,21358,21260,29679,25389,14856,19082,31825,16969,8550,10631,10663,14889,17035,14922,8485,16969,16937,21162,31792,35986,33905,35985,38066,29614,23308,21162,33840,40244,40212,40244,40211,40211,40244,40211,40211,35985,29582,31727,19016,23242,21129,19049,16936,19016,21162,21130,19049,12646,19017,35920,38033,38098,167},
{59197,59197,59196,59229,59229,59229,59229,59229,59229,59229,59197,59197,59197,59197,59197,59229,59229,59229,59229,59229,59229,61310,59262,61342,38066,14922,17036,12842,14955,14954,17068,17003,14923,14922,14922,19148,23374,14922,14890,14890,14890,14857,12776,14889,25487,31859,12809,21229,25519,12777,29713,38229,14889,34003,36117,14922,14922,14890,12777,36117,27665,14890,34004,17035,12776,27565,19115,17003,19148,12744,19213,36182,17003,16970,34037,12777,19148,36214,14922,19148,34134,14954,10663,12776,10664,23406,36181,14889,21326,31923,10664,25519,36182,19115,12744,12744,10696,12776,12744,10663,19116,21294,21261,29745,35987,16970,10599,10631,10598,10598,10598,10598,12712,10599,10598,8518,8518,10598,10566,8518,8518,10598,10631,10598,10631,10631,10566,10598,8518,10598,8518,10566,10598,10566,10566,10566,10598,10598,8518,8517,10566,10566,10566,10598,8518,8518,10566,8518,8518,10566,10599,10598,10598,10631,12744,29745,23374,33906,23341,23308,29711,31791,29679,12711,10631,23341,42325,16969,16969,25421,33906,10631,27534,29712,38131,25388,36019,42390,42358,40277,42390,34036,33970,38197,38164,36084,36083,36084,36052,31760,31728,19114,19050,14856,33905,25486,23309,23341,25421,25486,25486,25454,21195,31793,16969,16969,29647,33937,35985,35986,38099,29614,29647,16936,29614,38098,38098,38098,38098,31792,33840,38131,38163,38131,31759,35953,25323,23275,27533,27501,23275,25388,27501,16904,16904,19016,31726,38065,40211,42292,179},
{59196,59196,59229,42325,31761,31826,31794,31793,31794,31794,31826,31826,33874,33906,35987,35987,36019,36020,36052,36019,36019,36052,38100,36052,33907,17002,17035,12841,14922,14922,14922,16970,16971,14922,14890,17035,19148,14922,14922,14890,14890,14857,14857,14922,21261,19116,12809,21261,19148,14857,23374,27600,14889,27600,23342,14922,14890,14890,14857,29713,19181,14890,29746,23342,14857,23340,14889,19116,21261,12744,19148,34004,23374,17002,29746,12744,19148,34036,19180,17068,31988,17067,12744,12809,10696,21326,34101,19148,19213,29842,12809,23439,36149,19116,12712,12744,12744,12744,10696,10664,19180,25552,27632,27600,36019,16970,10598,10598,10598,10598,10598,10566,8518,8518,8518,10566,10566,10598,10566,8518,8518,8518,8518,10598,8518,8518,10566,8518,8518,10598,8518,10566,10566,10598,10598,10566,8518,10566,10566,8518,10598,10566,10598,10598,8518,8518,10566,8518,10566,10566,8518,10566,10566,8485,12711,29712,31858,36084,21228,21227,31792,31824,27598,10630,10598,25389,40212,12711,14792,27566,31792,17002,29679,33906,36019,31793,38132,42358,42358,40277,40342,36084,42357,42422,42390,42423,42390,40310,42358,35986,27599,16969,19082,16969,33873,33971,33970,33970,36051,36051,36051,36051,38164,36019,12743,21195,29679,36018,36018,35953,33840,25420,29646,25453,29646,35953,36018,38066,38098,27501,23307,40211,38131,38131,33872,35953,31694,38065,38066,31759,27468,33807,27468,23242,27501,21130,31662,38065,35953,40146,154},
{57148,59196,59229,31728,8518,10696,12744,10599,10664,10664,8551,10664,10696,8551,10664,10664,8551,10664,12744,8550,10664,10664,8583,10664,12712,10631,12744,12744,10631,12744,12777,10631,12744,12744,10631,12744,12744,10663,12744,12777,10631,12744,12777,12744,12744,12744,10631,12777,12744,10663,12744,12744,10664,12744,12744,10664,12776,12809,10664,12744,12777,12712,12712,12777,12777,12777,12776,10631,14857,12809,12712,12712,12777,12744,12744,12809,12744,12744,12777,12712,12744,12809,12744,12777,12809,12777,12744,12744,12712,14889,12777,12744,12744,14857,12744,12744,12777,12744,12776,12777,12712,19148,25551,25487,35987,19050,10598,10598,10598,10631,10598,10598,10566,10598,10598,10598,10598,10598,10566,8518,10566,10631,12744,10598,10566,10598,10598,8518,8518,10598,10598,10598,10598,10598,10566,10598,10598,10598,10599,12679,10566,10598,10631,10598,10566,10566,10566,10598,10598,10566,10631,10598,10598,12711,12744,29713,29777,36052,21196,23275,31824,33904,27566,10631,12744,27534,40245,16969,17001,31760,31793,33905,25454,27534,35954,35986,46584,48697,44503,40277,40309,40309,44471,42390,42390,23341,27567,42358,40245,29647,25421,16937,23308,19082,31792,23308,14824,14889,12743,14889,17035,17002,25421,29647,21163,38098,44405,44437,46518,46518,44438,31760,31759,33872,40211,42324,42324,42324,44405,38098,31727,44438,42357,42325,40212,40211,31726,42292,42292,42324,35985,27436,23274,33839,38033,33840,40179,42292,38065,38098,153},
{59197,59196,59229,31728,10664,12744,12777,12776,12712,12777,12744,12712,12744,12744,12712,12744,14857,12744,12776,14825,12744,12776,12776,10664,12744,10664,10631,10663,12744,12712,12744,12712,10664,12744,12712,10664,12744,12712,10664,12744,12712,12712,10664,10664,10631,12744,10663,12712,12744,10664,12711,12744,10664,12744,12712,10663,12744,12744,10631,10664,12744,10663,12744,12744,10631,10631,12744,10631,12712,12712,10631,12712,12712,10631,10664,12744,10631,12744,12712,10631,12712,10663,10631,12712,12712,10631,10663,12776,10631,10664,12744,10599,10663,12744,10598,10663,12712,10599,12712,12744,10631,23374,25552,23406,35987,17002,10598,10598,10598,10598,10598,10566,8518,10598,10598,10598,10598,10598,10598,10598,10566,10598,10631,10598,10566,10566,10566,12711,12711,10598,10631,10598,10599,12776,10631,10566,10566,10598,10631,12712,10598,10598,10598,10598,10631,10631,10566,10566,8518,10598,12711,10598,10598,12744,12711,27632,29745,33971,19083,23308,31792,33872,27566,14889,19082,31760,38131,33873,35986,33906,33873,36018,23276,16937,33906,40180,46584,48664,40277,38229,36083,42358,38131,42390,42358,12743,19082,44439,40245,25389,19050,16969,25421,16969,31792,23308,10631,12743,10566,19050,21228,27534,33906,36051,31727,44405,48631,48664,50777,50744,46583,38098,48631,50743,52889,52857,52889,54970,52857,42325,44405,46551,46551,46518,42325,38098,35953,46486,46518,46518,46550,42324,40179,42260,38098,38066,44405,42292,35985,40146,147},
{59196,57148,59229,29680,10631,10631,14890,12744,10631,14922,12712,10631,14890,10664,10599,14922,12712,10599,16970,10664,10631,14922,10631,10599,12712,10631,10599,14857,10631,10599,14857,10631,10599,14889,10663,10599,14889,10631,10599,14889,10631,10599,14857,10631,10598,12744,10631,10599,14890,10631,10599,14889,10631,10598,14889,10631,10599,14889,10631,10598,14889,10631,10599,14890,10631,10598,12744,10631,10598,14857,10631,10598,14857,10663,10598,14857,10663,10566,14857,10631,10598,12809,10664,10598,12777,10663,8550,12744,10663,10598,14857,10663,10598,14889,10664,10598,14825,12712,8518,12776,14889,25519,25519,23438,35987,19050,10566,10598,10598,10598,10598,10598,10631,10598,10566,10631,12712,10566,10598,10631,10598,10598,10599,10598,10631,10631,10598,10598,10598,10598,14857,10631,10598,12711,10598,10598,10598,10566,12679,14824,10598,10566,8518,10566,10631,10599,10566,10631,10631,10566,10631,10598,10598,12711,12711,27600,29745,33939,19050,23308,31792,33904,25421,8518,10598,29647,36019,19082,21195,29647,21195,40244,35986,25388,40212,44438,48697,48664,44438,40277,29679,40245,36051,42358,42358,35986,35986,42326,42325,33873,16904,19082,27501,16969,31792,27534,12743,14856,14856,27502,23308,35986,29647,40212,38131,46551,48631,48631,48664,50744,40178,40146,46485,48663,38066,38033,38098,46517,35951,21129,25355,23243,25356,29613,35920,29581,33839,38098,38033,38066,38065,38066,38066,38065,38065,38033,35952,35952,35920,35952,134},
{59197,59197,59229,29647,10664,12744,12776,12744,12744,12744,12744,12744,12744,12744,12744,12744,12744,12744,12777,12776,12744,12776,12744,10631,12744,10663,10663,12744,12712,10664,12744,12744,10663,12744,12712,10663,12744,12744,10631,12744,12712,10631,12744,12712,10599,12744,10663,10631,12744,12744,10631,12776,12744,10631,12777,12744,10631,12776,12712,10631,12776,12744,10631,12777,10663,10598,12712,10663,10599,12777,12744,10631,12777,12712,10599,12777,12712,10599,12776,12712,10599,12777,12712,10599,12776,10663,10566,10664,10664,10599,12777,10664,10598,12776,12711,10598,12744,10664,8518,12776,16970,27633,25519,23406,36019,19018,10566,10598,10599,10599,10598,10598,12744,10598,10598,10631,12711,10598,10598,10631,10598,10631,12711,10598,10631,10631,10598,10598,10598,10598,12776,10631,10598,10631,10598,10598,10566,10566,10599,12679,10566,10566,8518,10598,10631,10566,8518,10631,10631,10566,10598,10598,10598,10598,10631,29680,29680,29745,19082,23340,31792,31791,21227,8485,8485,29647,33873,14824,16937,27534,21163,27566,35986,36019,44438,48697,48664,46584,44471,40277,21260,40277,40212,44470,42390,42390,44471,42358,42390,38132,12678,19049,31727,14856,31792,31760,16937,23340,29647,33873,27566,29647,25356,38164,40212,38164,38132,50777,50777,48664,38065,46517,46550,52857,44405,44405,44405,42258,35983,25355,23243,10565,12645,19049,35920,31726,35952,40178,38098,38098,38098,38098,38065,38033,38033,38065,38033,38033,35920,35920,136},
{59197,59197,59229,29615,10599,12777,12777,12712,12777,12777,10664,12744,12744,12712,12776,12776,10664,12777,12777,10663,12776,12777,12744,12777,12776,10631,12777,12744,10631,12744,12744,10631,12744,12744,10631,12744,12744,10631,12744,12744,10631,12744,12744,10631,12744,12744,10631,12744,12744,10631,12744,12744,10631,12744,12712,10599,12744,10664,10631,12744,12744,10631,12744,12744,10631,12744,12712,10599,12744,12712,10631,12744,10664,10599,12744,12712,10599,10664,10663,10598,12712,12712,10599,10664,12712,10631,10664,12744,10599,12712,12712,10599,12712,12712,10566,10663,12712,10598,10631,12744,8518,19115,25519,23374,35987,17002,10566,10598,10598,10631,10598,10598,12679,10566,10566,10598,8518,10598,10598,10631,10598,10631,12711,10598,8518,8518,10598,10566,8518,10598,10566,10598,10566,8518,10566,10598,8518,10566,10598,8518,10598,10598,8518,10598,10598,8518,10566,10598,10566,10598,8518,10566,10598,8518,10598,29712,29713,29680,19082,19082,31824,27598,14824,8518,8485,29615,25421,14791,19082,33873,19082,29679,31760,36019,40277,38099,44471,44438,40244,33937,19114,40244,44438,55003,52890,48664,38066,40179,42390,40212,14824,27501,33872,14856,33841,29679,16937,21195,29647,25421,23275,16936,23276,42325,35986,33938,38132,52923,50809,42357,42324,48631,50744,35952,35888,35920,46518,48663,40178,23275,29646,29581,27501,27501,33872,31726,33839,38130,38098,38098,38065,38066,38066,38065,38033,38001,35952,35952,35887,35920,134},
{59197,59197,59197,46551,31760,27534,21196,17003,14889,17035,21261,21261,21228,17035,14922,14857,12777,12777,14857,14890,12809,12809,14890,12777,12776,14857,14922,12777,12777,12777,12809,14857,14857,12809,12777,14857,12777,12809,12777,12777,12777,14857,14857,17002,14889,12776,14857,14890,12809,14857,14890,14857,14857,14857,14857,14857,12809,14857,14857,12809,14857,14857,12777,12809,14922,12777,12744,12776,14922,12777,12777,12777,12777,12777,12809,12809,12777,12777,12809,12777,12777,12777,12777,12776,12809,14890,12744,12744,12744,14890,12776,12744,12776,14857,12744,12776,12776,12744,12744,12777,10664,21228,27664,23406,36019,16970,10566,10598,10598,10599,10599,10598,10566,10566,10566,10598,10598,10566,8518,8518,10566,8518,8518,10598,8518,10566,10566,8518,8518,10566,10566,10598,10598,10598,10598,10566,8518,10566,10566,10566,10598,8518,8518,10566,8518,8486,10566,8518,10566,10598,10598,10566,8518,8518,10598,27600,31793,27632,21228,21195,25453,31792,14824,10598,10631,29647,29647,23308,33905,35986,16937,31728,29647,36019,40277,38099,44470,44438,38131,27567,19114,44471,55035,57116,55035,48664,25225,33742,42423,40245,14824,27501,33872,14824,33841,21195,16904,16937,21130,19017,25356,14856,19082,40245,38132,38099,48664,50810,48697,38099,42292,46551,50777,46518,46518,48631,54938,48663,40211,27500,38098,44405,42324,42324,40179,35920,38033,44404,42324,42324,42291,40211,42259,42291,42291,42259,40146,38065,38033,38065,142},
{59197,59197,57148,59197,59229,57116,54971,50744,44405,35986,29647,25486,25486,27664,27632,21293,25486,23341,19148,17067,17003,14857,12777,12776,12776,14922,17002,14922,14890,12809,12777,17003,17003,14857,12777,12776,12777,12777,12777,12777,12777,12776,12777,17035,17067,12776,14890,16970,14857,14922,14922,12777,14922,17003,12809,14890,14890,12777,14890,14890,12776,12777,12744,12744,12744,12744,12776,14890,17035,12776,14890,14890,12744,12809,12777,12744,12744,12744,12744,10664,10664,10664,12776,12777,10664,12777,12744,12744,12744,12809,12744,12776,12744,10664,12777,12744,12712,12712,10664,10664,12744,17035,25487,16970,33874,19050,8518,10598,10631,12679,10631,10598,10663,10598,10566,12679,12712,10598,8518,10566,10598,10598,10598,10566,12679,12744,8518,10566,10566,10566,10598,10566,10566,10598,10598,10598,10598,10598,10598,10630,10598,8518,8518,10566,12711,12712,10566,8518,10598,10566,10631,10598,10566,10598,10598,25487,27599,29680,16969,29647,27534,25420,21195,8485,8485,38067,27535,14824,19082,35954,12678,31728,29680,38099,27566,35953,44503,44438,35986,27534,23340,44503,55003,55003,52858,40244,25290,33742,42422,42325,14824,25388,35952,19050,25421,16937,21195,29647,31728,25453,23275,16937,19050,38099,42325,40244,52890,50777,44503,35953,42292,48663,40211,31726,31694,40146,55002,46550,35920,31727,35921,35953,38033,42324,52857,42324,33840,35888,35888,35953,50744,54970,44437,33840,35920,35888,42260,50777,48663,33840,129},
{59197,57149,57116,57116,57116,57116,57116,57149,59197,59197,57116,54971,48696,44438,38067,29679,27534,25486,25519,27600,23406,21229,12809,14857,12744,17002,17035,14922,14857,14890,14922,17035,17035,12809,12809,12777,12809,12809,12777,12809,12809,12777,12809,17003,14890,10664,14922,14922,12809,17035,14954,12809,17035,17003,14857,14922,14955,12809,14922,17003,12777,12777,12776,12777,12776,12744,10664,14954,19148,12744,12809,14922,12777,14857,12777,12744,12744,10664,12744,12744,10664,12744,12809,14890,12744,14890,12777,10664,12776,12777,12744,12809,14890,12776,17035,14889,10664,12777,12776,10664,14857,12744,10599,8518,33906,19050,8518,10598,10598,10631,10631,10631,12711,10599,10566,12711,12744,10566,10566,10598,10566,10598,10566,10566,10598,10598,10566,8518,8518,10566,10566,10566,10566,10598,10598,10598,10631,10598,10598,10598,10566,8518,8518,10598,12711,12711,8518,12711,10631,10566,10598,10598,10598,8518,8518,31793,36019,23341,17002,25421,29679,27566,14888,8485,8518,38099,27534,21195,25421,33841,16904,27534,29680,38132,27566,25421,42325,42357,35986,27534,27567,44470,46583,36019,29647,27502,25421,42291,42358,42357,16904,23275,35985,21195,21195,16904,29679,35986,31760,33873,23242,19081,23340,40212,38099,48664,52890,48729,38131,42324,44405,48631,40179,40211,44405,54970,55002,40179,29581,40179,44372,46518,46518,46550,48663,42324,44437,44405,44405,46486,52857,54938,48599,42292,42292,42292,44438,50777,48664,38066,147},
{57149,57149,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59197,59197,59164,54971,48696,42357,38099,31760,25421,19115,19083,12712,14889,17035,14922,12777,14857,14890,17067,17035,14890,14890,12809,12809,14857,12777,12809,12809,12809,14857,17003,17003,12744,17003,17035,12809,17035,17003,12809,14955,14954,14889,14954,14922,12777,14955,17003,12809,12777,12777,12777,12776,12744,10664,14922,17068,12744,14890,14890,12744,14890,14890,12777,12744,10664,10664,10664,10664,12744,12809,12809,12744,14890,12744,10664,12777,12777,10696,12809,14890,12744,12809,12809,10696,14922,14889,10663,12744,12809,12712,10599,23309,16970,10598,10599,10599,12711,10631,10598,10663,10598,10598,10599,10631,10598,10566,8518,8518,10631,12712,8518,10631,12711,10566,10598,10630,10566,8518,10566,10566,10598,10598,10566,10598,10566,10598,8518,10566,8518,8518,10598,10631,10631,10566,12711,12711,10598,10631,10598,10598,10566,8518,14857,27599,21228,33906,25454,25421,33937,21195,10598,12711,38099,40243,46583,33841,27534,14856,21195,31760,46519,29680,16969,38132,33841,38099,29647,33905,44536,38197,23341,21163,12711,23308,42356,42358,42390,16969,21162,35952,21163,23275,16904,25389,25388,23340,36018,27533,25420,19049,23308,42357,52923,52890,48664,33872,40211,48631,50744,40179,40179,42291,52889,55002,44373,44340,44405,44405,50712,38065,48631,44405,31694,29581,31727,31727,48631,55002,46486,29614,29614,29582,35953,52857,48664,31662,29549,112},
{59197,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59229,59229,59196,57051,52825,44438,35953,27534,23340,17034,14889,12809,12777,17035,17100,14890,14922,14922,14890,14889,12809,12809,12809,12809,14889,17035,14922,12744,14954,14954,12809,17035,17003,12809,14955,14922,12809,14955,14922,14858,14955,17003,12777,12777,12777,12744,12777,12744,12744,17003,19213,12744,14890,14890,12776,14922,14857,12777,12809,12809,12744,10664,10664,10664,12809,14890,12744,14890,12744,10664,12777,12777,12744,12776,12744,10664,12776,12776,12744,12809,12809,10696,12744,12744,10664,12776,12777,10631,10599,10599,10598,10631,10598,10598,10599,10566,10598,8518,8518,10598,8518,8518,8518,10631,12711,8518,10631,12711,10598,10598,10598,10566,8518,8518,10566,10566,10566,10566,10566,10566,8518,8517,10598,10566,8518,10566,8518,8518,10566,12679,12711,10566,10631,10598,10598,10566,8518,10631,23308,21228,27567,36051,23308,33872,19115,12679,12743,40179,42324,50777,40212,31760,21162,19050,27567,46551,27535,23276,33938,31729,38099,33938,36051,38164,29680,21195,23340,12711,23340,33873,42358,44438,19050,21162,33872,21130,23308,14856,10566,19050,27534,38066,31726,21130,16904,14823,40245,44471,44406,38131,35985,42292,48631,33872,33808,35920,50744,55002,44373,33840,33840,33840,46518,44405,35985,46550,40146,44372,44405,44437,48631,52889,52857,46518,44405,44405,46486,48664,50777,46518,42292,42260,159},
{59196,59196,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59197,59229,59229,61309,59229,57115,52857,46518,40146,29647,25453,19147,14889,14889,12809,12809,14922,14922,14890,14890,12777,14857,17035,17003,12744,14955,17003,14857,17035,17067,12809,14954,17035,14890,17035,14922,14857,14955,14922,12777,12777,12776,12777,12777,12744,12744,14857,14889,12776,12809,12809,12776,14922,12809,12744,12744,12744,12744,12809,12777,12744,12810,14858,12744,14954,14954,12744,12777,12777,12744,12776,12744,12744,14890,12809,10696,12777,12809,10696,12776,12809,12744,12744,10664,10631,8518,10598,10598,10598,10566,8518,10566,8518,10566,8518,8518,10566,8518,8518,10566,8518,8518,8518,8518,8518,10566,10566,8518,8518,8518,10566,8518,8518,10566,8518,8518,10566,8518,8485,10598,8518,8518,10566,8518,8518,8518,8486,8518,10566,8485,8518,10566,8485,8518,12744,25421,23308,23373,33971,27599,29646,19082,12711,14824,42357,33873,38067,36018,36051,23276,19050,27534,46551,25454,25389,31825,29649,31761,31825,38164,23373,23308,23276,21228,12711,29647,33905,42325,40277,21195,21130,31727,23275,23276,14824,10598,19050,31760,31759,27501,14824,21163,16936,44471,46584,44438,33872,38130,44437,50712,44405,44405,48598,54938,54970,48631,46486,46486,46518,50744,35920,44404,44405,38066,33840,35921,33840,44437,54970,48663,33807,33808,31727,35953,50744,50744,31727,29582,29582,109},
{59196,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59197,59197,59197,59197,59197,59197,59229,59229,61309,61310,61309,59228,57050,50711,42291,35920,25388,21227,17002,14889,14922,14890,14890,17067,19148,12777,17035,17035,14889,17100,17035,12809,17035,17068,14889,17068,14922,12777,14955,17067,12809,14890,12809,12777,12777,12744,10664,14889,14922,12776,12809,12809,12777,14890,12809,12776,12776,12744,10696,10696,12744,12744,14890,12809,12744,14955,14890,10696,12776,12777,10696,12744,12776,10664,17067,17003,10664,14922,14857,10664,12809,12777,12744,12809,12777,12744,14889,14857,14889,14889,12744,10663,10598,10599,10631,10631,10631,10631,10598,10598,10599,10598,10598,10631,10598,10599,10599,10566,10599,10599,10598,10631,10598,10598,10631,10599,10598,10599,10598,10631,10631,10598,10599,10631,10598,10631,10599,10598,10631,10598,10598,10598,10566,10566,8518,8485,21163,23309,19115,25454,25421,29679,14856,23438,27567,40212,14857,14857,29647,33906,25454,23276,29647,40245,23341,27534,31793,31762,25422,31825,36051,23341,29712,21228,21228,12744,21195,25421,40245,40277,23308,19082,29614,25389,23308,16936,14792,19050,33938,44438,44470,35986,23308,23308,52923,50842,44471,35985,42324,50744,40179,33840,33807,44405,50744,42292,29614,29614,29614,33840,38098,35952,48598,35920,35888,38033,35953,44405,54970,50776,38034,38033,38033,40179,50744,50744,40147,38034,38034,38034,169},
{59196,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59196,59197,59197,59197,59197,59197,59197,59197,59229,59229,59229,59229,61309,61310,63390,63422,63390,61276,57050,48663,42291,35953,27534,21196,21228,17035,12777,17035,17068,14889,19181,19148,14857,17035,14955,14857,17003,14922,12809,17003,14922,12777,12809,12777,14857,14922,12777,12776,12809,14890,12777,12809,14889,12776,12841,12809,12776,12744,12744,12744,12744,12712,12712,12809,12809,12744,14922,12809,12744,12744,12777,10664,12809,12809,10664,14922,14890,10664,14889,12809,12712,14857,12776,10664,12777,12744,10631,12744,10663,10631,10631,10599,10598,10566,8518,8518,10663,12744,10598,8518,8518,8518,10566,8518,8518,8518,8518,10598,10598,10598,10598,10598,8518,8518,8518,8518,8518,10598,8518,8518,8518,8518,8518,8518,8517,8485,8518,8518,8518,8518,8518,8518,8518,8485,8485,8485,10566,17002,25421,16969,21130,23275,25453,14857,12776,31793,40245,31760,31760,31760,29679,27502,21163,29647,44438,23276,23341,33971,31794,23277,36051,31760,27599,29647,19050,25454,14824,21195,27534,40277,42423,27534,23243,29646,23308,21195,12711,12679,19050,38131,50777,46551,44438,23340,38132,52923,48697,38099,40179,46518,46550,40147,40179,44372,50776,21130,27533,29678,25356,25356,25420,29582,46486,42292,40179,42292,44372,42292,46518,52890,50776,42259,40179,40179,42259,50744,50744,40146,35953,35921,33840,161},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59197,59197,59197,59197,59197,59197,59197,59229,59229,59229,59229,59229,61277,61277,61309,61309,61309,61309,61309,63390,63422,63389,61277,57050,50711,42292,33808,25453,21228,17002,17034,14954,14890,17067,17067,14922,17067,14923,14889,17035,17035,14890,14890,14857,14857,14922,14857,12776,14890,14922,12809,14890,14889,12777,12842,12809,12777,12809,12777,12744,12777,12777,12744,12842,14890,12776,14922,12809,12776,12777,14890,12744,12809,12809,12744,12809,12809,12776,12777,12777,12744,12809,12777,12744,12809,12776,10664,12777,12777,10663,10663,12744,10631,12744,12744,10631,10664,12744,10631,10599,10631,10599,10631,10631,10599,10599,10599,10598,10631,10663,10631,10631,10631,10599,10599,10598,10598,10599,10631,10598,10598,10598,8518,8518,10598,10598,8518,10566,8518,8518,10598,10566,8518,8517,10566,8518,8518,21163,38164,29615,42358,44471,31760,14889,12711,23308,23308,19050,19082,38099,31728,29647,19082,23276,48697,23276,19083,33906,31794,23277,38164,25421,23373,19082,17002,33905,14856,19082,23341,40245,42423,29679,23275,31726,25356,21163,14791,12678,19050,36018,48697,38131,46584,31825,48664,50810,44471,38131,42324,31727,33839,29614,31694,33872,29614,14758,29614,25388,6371,8420,14824,33872,48631,35920,29581,31727,31695,38033,52889,52857,33840,31694,31694,31694,46551,50777,35953,27469,29582,27501,38098,171},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59197,59197,59197,59197,59197,59229,59229,59229,59229,59229,59229,59229,61277,61277,61277,61277,61277,61277,61309,61309,61309,61309,61277,61309,61309,61310,61309,59196,54970,48663,42324,33873,25421,21195,17034,12809,17035,17068,12809,17068,17068,12809,12809,12809,12777,12777,12777,12744,14889,14922,12777,14922,14890,12744,12809,12809,12777,12744,12744,12744,12744,12744,12712,12841,14890,12776,17003,12809,12777,12777,14890,12777,12777,12776,10696,17035,14922,10696,14922,12777,10664,14890,12809,10664,12809,12744,10663,12809,10696,10631,10664,12744,10664,12744,12777,10663,10631,10631,10598,10598,10599,10598,10599,10599,10598,10598,10598,10598,10598,10598,10598,10631,12711,10631,10631,10631,10598,10598,10598,10598,10599,10599,10566,8518,8518,10598,10598,10566,8518,8518,10566,10566,10566,8518,8518,10566,10599,19083,25421,10566,29680,42390,27567,16937,10631,10598,8518,10566,14856,25421,23276,27566,23276,21163,48664,23308,19083,33906,29681,27535,38132,21163,21195,14856,21163,38132,17002,23340,23373,40245,40277,33905,35953,33839,25356,19082,19017,25421,29614,40211,46583,38132,46584,38131,33938,36019,38131,44437,35985,21129,29581,29614,31726,31726,23243,12678,27500,31727,23275,23275,27501,44372,44372,35953,42292,42292,44405,50744,52857,46550,42260,42260,42292,46518,48664,46518,40179,40147,38098,40179,44405,165},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59196,59197,59197,59197,59197,59197,59197,59229,59229,59229,61277,59229,59229,59229,59229,59229,61277,61277,61277,61309,61309,61309,61309,61277,61277,61277,59229,59229,59197,59229,59229,61309,61309,59229,59196,54970,50712,42292,35953,29647,19115,19083,17002,12777,12777,12777,12809,14857,12777,12744,14922,17003,12777,14890,14890,12777,14890,12809,12777,12744,12744,12744,12744,12744,12744,12809,14955,12744,17035,12809,10664,12777,14857,12744,12809,12809,12744,17067,14922,10664,17003,12841,10663,14922,14857,10664,14954,12776,10631,12744,10664,10631,14889,12776,10663,12744,12776,10631,10631,10631,10598,10598,10598,10598,10599,10599,10598,8518,8518,8550,8518,10598,10598,10631,10599,10598,10599,10663,10631,10599,10566,10566,10598,10598,10566,8518,8518,8518,8518,8518,8518,12679,12711,10566,10566,10566,10566,10598,10598,12711,10566,10598,12711,27535,16937,14857,12711,12711,12679,10631,21195,33938,35986,31760,23341,21195,40245,19115,21196,33939,31794,31761,31825,23275,21195,12743,31760,40212,14856,23373,19082,25454,42358,27567,33839,38032,25356,21130,29647,48630,48631,46518,40244,42358,44471,36051,33873,33873,36018,44502,36018,21097,29581,27500,29581,27533,21195,19017,31694,40179,40178,38066,38033,48631,44405,38001,35921,35953,38066,50777,52890,40179,33840,35888,33807,44405,50777,40179,31662,31694,29581,38033,46517,141},
{57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59196,59196,59197,59197,59197,59197,59197,59197,59229,59229,61277,61277,59229,59229,59229,59229,59229,61277,61277,61309,61309,61309,61277,61277,61277,59229,59229,59197,59197,59197,59197,59229,59229,59229,59197,59197,59197,59229,61309,61309,59196,57051,50744,44405,33873,27502,21228,14889,12776,12777,10663,14922,17035,12777,12841,14922,12777,14922,14922,12777,12777,12744,12744,12744,12744,12744,14922,17068,12777,17035,14890,12744,12776,12809,12744,12777,12809,12744,14890,14890,12776,12777,12776,10664,14857,12777,10664,12744,12744,10664,10664,10664,10631,14889,12744,10631,10631,10663,10631,12744,12776,10631,10598,10598,8518,10631,10599,10598,10598,10598,10598,10598,10598,10598,10598,10631,10598,10599,10598,10598,10599,10599,10598,10599,10598,8518,8518,8518,8518,8518,8485,12711,16970,12744,10598,8518,8486,8486,10598,8485,12744,23374,21228,25422,21196,19083,19115,12711,23341,25454,12744,19082,25421,27567,29647,27534,25357,40277,19050,25454,31858,31794,33939,25454,23340,19115,12743,44438,40212,14824,23308,27599,25454,42358,25454,27435,40113,27501,23243,40179,46550,46582,48631,40244,40244,42357,40244,38131,33938,38098,46551,38163,23242,33839,29646,31694,29549,23210,29581,29581,33807,33807,35920,50777,50744,38033,33808,33840,35920,50712,52890,44373,33840,35920,35888,44405,52824,44372,31695,33808,31727,38033,46485,42292,107},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59197,59197,59197,59197,59197,59197,59229,61277,61277,61277,59229,59229,59229,59229,59229,59229,61277,61309,61277,61277,61277,61277,61277,59229,59229,59197,59197,59197,59197,59197,59229,59229,59197,59197,59196,59196,59197,59197,59197,59229,59229,59229,59229,59196,54971,48632,40244,33873,25421,19083,17035,12776,12809,17035,12776,14922,14922,12777,14890,14857,12777,12776,12744,12744,14922,17035,12777,17067,14890,12744,12776,12809,12744,14889,14922,12744,12744,12777,12744,14889,12809,10696,12744,12744,10664,10664,10664,10664,10664,10631,10631,12809,10664,10631,12809,12809,10631,12776,12777,10599,10631,10631,10599,10631,10598,10598,10599,10598,10598,10598,10598,10598,10631,10631,10599,10631,10599,10598,10566,8518,10598,10631,12711,10599,8518,8518,8518,10598,8517,12712,12744,12712,10598,8518,8485,8517,10566,8485,12744,16970,19115,23309,21163,21195,14889,12743,25454,25454,12743,16970,25422,25389,27567,29647,23340,40245,21195,31728,29713,42390,38164,31759,42325,16970,16970,52890,40212,12711,19050,27534,25454,40277,27567,27468,38065,27501,21130,35986,42357,42357,42325,40212,38164,25454,21195,25453,31760,40211,38131,36018,44372,38066,35953,35985,48663,48631,31694,40179,42292,42292,48598,52824,46485,44405,42324,44405,46518,52857,52857,44405,42260,42260,42259,46550,48663,42260,35953,35953,35921,40146,42292,33873,64},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59197,59197,59197,59197,59197,59197,59229,61277,61309,61309,61277,61277,59229,59229,59229,59229,59229,61277,61277,61277,61277,61277,61277,61277,59229,59229,59229,59197,59197,59197,59197,59229,59197,59197,59197,59196,59196,59196,59197,59197,59197,59197,59196,59196,57148,57116,57116,57116,55036,55003,50810,46552,38164,31825,27567,19083,17035,19116,12744,12777,12809,12777,14857,12777,12776,17003,23374,12744,17068,14922,12744,12776,12809,12777,12809,12809,10696,19148,19181,10631,19180,23407,12777,12809,12809,10696,14922,12809,10664,12744,10663,10631,14889,10663,10599,12744,14889,10631,12809,14954,10663,10598,10631,10631,10631,10631,10598,10599,10599,10598,10599,10598,10598,10631,10631,10631,10631,10598,10566,10598,8518,8518,10598,10599,10598,10599,10599,8518,17003,8518,8518,10566,10598,10598,8518,8517,8517,10566,8518,12711,10599,8518,12711,25453,29680,25389,12679,12711,10598,12743,14792,16970,21163,25453,29679,27566,29680,19082,31728,33938,52890,33906,44437,50744,12679,19050,46551,33938,14824,21195,27534,23341,40245,29648,25387,38065,27534,21130,35953,31760,29647,29680,33873,46551,46584,44471,42325,36018,46518,42291,35920,42292,40179,42292,44373,46550,40114,40146,40179,40211,40178,44405,44339,35952,33839,35920,35920,46518,54970,48599,31727,33807,31694,38066,50744,38066,25356,25356,25356,29614,35952,29647,14857,50},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59196,59197,59197,59197,59197,59197,59229,59229,61277,61277,61309,61309,61277,61277,59229,59229,59229,59229,59229,61277,61277,61277,61277,61277,59229,59229,59229,59197,59197,59197,59197,59197,59197,59197,59197,59196,59197,59196,59164,59196,59197,59197,59197,59197,59196,59196,57116,57116,57084,55004,55003,52955,52955,52956,52956,52956,52923,50778,46584,40277,31793,27599,23374,14857,14889,17035,12776,14922,17067,12777,17068,14922,12776,12809,12809,12776,12744,12776,12744,14857,14922,12744,14922,14954,12744,12809,12777,12744,17035,17067,10664,19148,14890,10599,17067,12777,10631,12777,10664,10598,12744,12744,10598,10598,10598,10598,10663,10631,10598,10631,10663,10598,10599,10598,10598,10631,10631,10631,10631,10599,10598,8518,8518,8518,10598,10598,8518,8518,8518,10599,16970,8518,8518,8518,10598,10598,8518,8517,8517,10598,8518,10631,10631,10631,12679,25421,29680,29679,25389,27534,29647,29647,25454,23276,29615,33873,35986,36018,35986,17002,31728,44438,54970,48631,52825,50744,16969,16937,42325,33938,12743,25421,27566,25421,36019,31761,25355,40113,29614,16904,33905,23308,10566,10631,17002,44438,52923,50842,38131,44372,46550,52857,42259,40146,40179,52857,57051,33774,27435,33775,35921,38001,44373,52857,44404,38033,38033,38033,44405,54970,50777,38066,38034,38033,42227,48663,48631,35953,35953,35921,35953,42325,35954,12679,12646,51},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59196,59197,59197,59197,59197,59229,59229,59229,61277,61277,61309,61309,61277,59229,59229,59229,59229,59229,59229,59229,61277,61277,61277,59229,59197,59197,59197,59196,59197,59197,59229,59229,59197,59197,59197,59197,59197,59196,59196,59196,59197,59229,59197,59197,59196,59196,57116,57116,57084,55004,55003,52955,52923,52923,52923,52923,52891,52891,52923,52923,55004,55003,52890,48632,42358,36051,25454,23308,21228,14889,14954,12874,12809,12809,12809,12744,12777,12777,12744,12776,12744,12744,12809,12809,10664,12809,12744,10663,12777,14890,12744,17067,14890,10663,14857,10664,10631,14922,14857,10631,10696,10664,10631,10598,10598,10598,12744,10631,10566,10599,10631,10631,10631,10631,10599,10631,10631,10599,10631,10631,10598,8518,8518,8518,10599,10598,8518,8518,10598,12744,14889,8518,8518,8518,10598,10598,8518,8518,8518,10566,8517,10631,10631,10599,12744,29647,25453,23276,23276,23308,25389,16937,12744,10631,21163,27534,25454,29647,27534,19082,29680,46551,57083,57083,55003,52857,14856,16937,40245,36018,14824,19114,23340,25454,31793,33874,23243,40080,31694,19049,33873,23341,8518,10631,10598,36019,42390,44471,36018,42291,48631,42292,35920,35920,46550,54970,46551,33774,40146,44405,44405,44372,48598,48663,44405,42259,42292,42292,46550,52889,50712,40179,40147,40146,42259,48631,46550,35953,35953,35920,35953,42357,38099,12711,12711,50},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59197,59197,59197,59197,59197,59229,59229,59229,61277,61309,61309,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59197,59197,59197,59197,59197,59197,59229,59229,59197,59197,59197,59197,59197,59196,59196,59196,59197,59229,59229,59197,59197,59196,57116,57116,57084,55004,55003,52923,52923,52923,52923,52923,52923,52891,52891,52891,52923,52923,52955,55004,55036,55036,55003,52890,48664,42325,36019,29680,21196,14921,14921,12776,14922,14922,12777,14890,14889,12777,14890,14890,12744,12809,12809,12744,14857,14857,12744,12809,12776,10664,10664,12712,10631,12809,12777,10663,12744,12776,10663,10631,10631,10599,10663,10663,10631,10631,10664,10631,10663,12712,10631,10631,12744,10663,12712,12711,10599,10599,10631,10599,10599,10598,10598,10598,10631,12744,14889,8518,8518,8518,10598,10598,10566,8485,8485,10566,10631,12712,10631,10599,12711,25389,23308,21195,19082,16937,14824,12744,12744,10631,19115,27534,21228,27534,27599,21227,31728,52857,55003,55003,55003,54970,19083,14857,40245,33906,14792,21195,25453,27566,27567,33906,21097,38032,31759,16904,33840,27502,14824,14856,14856,23308,21228,33905,42324,46486,50712,44405,42292,44405,50809,52889,46518,46485,48598,50712,50776,35887,48631,42259,33807,33840,33840,38033,52857,52857,35921,31727,31727,33807,48599,48663,33807,29582,29582,29582,44373,44471,38099,12744,12679,50},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59197,59197,59197,59197,59197,59197,59197,59229,59229,61277,61309,61309,59229,59229,59229,59229,59229,59229,59229,59229,59229,59197,59197,59197,59197,59197,59197,59197,59197,59197,59197,59197,59197,59197,59197,59196,59196,59196,59196,59196,59229,59229,59229,59229,59197,59196,57116,57116,57084,55036,55003,54971,52923,52923,52923,52923,52891,50843,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52955,55004,55036,55036,52923,48696,42358,35986,29680,25454,16970,17034,14890,10664,14922,17003,12744,14857,14889,10663,14922,14922,10631,14857,12777,12712,12744,12744,10631,12777,16970,10631,12776,12776,10599,10631,10631,10599,10663,10631,10598,10631,12712,10631,10663,10631,10598,12711,12776,12744,12744,12712,10599,10598,10631,10631,10599,10598,8518,10631,10631,10631,14824,8518,8518,10566,10598,10598,8486,8485,8485,10566,8518,10631,10631,10599,10631,23276,44438,35953,33905,23341,19115,12744,12743,16969,19114,23308,23276,23308,27566,23341,33808,57083,57051,57051,55003,54970,19115,16937,40244,33906,14824,21163,23308,27599,25422,35987,21129,38032,33807,16936,31792,38131,40244,40212,40244,33970,21228,33905,46550,48631,48631,38033,35953,42292,55002,52857,38065,38066,38033,42324,42259,40178,46485,33807,38066,40147,40179,50744,52890,44405,38034,38066,40146,46485,48663,42292,35921,35953,35920,42292,46551,44503,33938,12744,12679,54},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59196,59197,59197,59197,59197,59197,59197,59197,59229,59229,59229,61277,61277,61277,61277,59229,59229,59229,59229,59229,59229,59229,59197,59197,59197,59197,59197,59196,59197,59197,59197,59196,59197,59197,59229,59197,59197,59196,59196,59196,59196,59196,59229,61277,59229,59229,59197,59196,57116,57116,57084,55036,55003,52955,52923,52923,52923,52923,52891,50843,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,55003,55004,55036,55004,55004,52890,48697,44438,36019,27567,25454,21293,12776,17002,14890,10663,19148,17003,10631,14858,14890,10663,12744,10663,10631,10663,12712,10631,12744,10631,10598,10598,10631,10599,10631,10599,10598,10598,10599,10598,10631,10599,10598,10631,12744,10663,12744,14857,10631,10598,10598,10598,10598,8518,8518,14857,19115,8518,10631,8518,10566,10566,10598,10598,8518,10566,10566,10566,8485,10631,10631,12711,10631,14824,29582,31759,29614,38099,33906,14856,12744,12744,14824,14824,23308,21195,25453,23308,29647,48664,48664,50744,50744,48697,21163,17002,38164,38132,16905,19050,27534,31792,21228,33938,19050,38032,33839,19049,33840,29712,23308,23276,23276,27534,25421,38066,46517,50744,40146,35953,40146,52857,54970,40179,35953,35953,35953,46518,33807,46550,38001,40146,42259,42259,42259,50744,52857,44372,38066,38066,38033,46485,48631,40146,33807,33808,33808,42292,48664,46551,33906,14857,10631,62},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59196,59197,59197,59197,59197,59197,59197,59197,59229,59229,59229,59229,59229,59229,59229,61277,59229,59229,59229,59229,59229,59229,59197,59197,59197,59197,59197,59197,59197,59197,59197,59197,59196,59197,61277,59229,59197,59196,59196,59196,59196,59197,59229,61277,61277,59229,59197,59197,57148,57116,57084,55003,55003,52923,52923,52923,52923,52923,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,52955,52923,52923,52923,52923,52923,52955,55003,55004,55004,52890,48697,44438,38099,29712,23309,21261,19148,12776,14922,14922,10663,12744,12744,12712,10631,12712,12712,12776,12744,10631,10598,10631,10599,10663,10631,10598,10599,10599,10598,10631,10599,10598,10631,12679,10599,10631,12711,10598,10631,12744,10631,8518,8518,8518,19115,19147,8518,10631,8518,10566,10566,10598,10598,8518,8485,8485,10566,8486,10598,12744,14824,10631,14823,16936,14823,19049,35986,36018,21163,19115,19147,14856,10598,19050,21195,23276,23276,16937,21227,27566,31760,29712,29679,21163,25421,38132,36018,16937,19082,21195,29679,21163,33906,19017,35919,33807,21195,31760,29679,14888,12743,10598,25454,31792,42291,46518,48663,42292,42324,46518,44404,25388,25388,23308,25356,27500,31694,38033,46518,31727,33775,33840,33840,44405,54970,46485,33775,33775,31727,42259,50744,40179,27501,29582,27501,38066,48664,44438,27534,19082,14824,10631,70},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59197,59197,59197,59197,59197,59197,59197,59197,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59197,59197,59197,59197,59197,59196,59197,59196,59197,59197,59197,59197,59229,59229,59229,59197,59196,59196,59196,59197,59229,61277,61277,59229,59197,59196,57116,57084,57084,55003,55003,52923,52923,52923,52923,52891,52891,52891,50843,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,54971,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,55004,55004,55003,52923,48729,44439,36051,31793,23341,16970,14889,17002,10663,10631,12712,10631,14857,14890,10631,10631,12712,10631,10664,10631,10598,10599,10631,10631,10631,10599,10598,10599,10598,10598,10631,10631,10598,10599,10598,10599,10599,10598,8518,19148,19115,8518,10631,8518,10566,10566,10598,10598,8518,8517,8485,10566,8486,10598,10631,14857,14824,16936,19017,16936,16969,16936,12711,14824,23308,21228,14856,12678,14791,21163,23308,23373,21195,19082,27566,25453,27534,29647,23308,21195,38132,36051,23275,23308,25421,33905,19082,33906,19017,35952,27469,21162,29679,29647,16937,12743,10630,17002,31792,44405,48631,44373,35921,38033,40178,38065,21194,19017,10565,10598,21162,29581,46551,38065,33807,38066,38066,44373,52857,50744,38066,38033,38033,40211,48631,46518,35953,33872,33840,35953,44437,46583,38132,42358,40212,16937,10598,80},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59197,59197,59197,59197,59197,59197,59197,59197,59197,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59197,59197,59197,59196,59196,59196,59196,59196,59196,59196,59197,59197,61277,59229,59197,59197,59196,59196,59196,59197,59229,61277,61277,59229,59197,59164,57084,57084,55036,55003,52955,52923,52923,52923,52923,50843,50843,50843,50843,52891,52923,52923,52923,52923,52923,52923,52923,52923,52891,52923,52923,54971,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52956,52923,50842,42423,36084,29745,21228,17035,14890,12712,14857,17002,12712,10631,12711,10631,12712,12712,10631,10631,10599,10598,10631,10599,8518,10599,10598,10599,10631,10631,10631,10599,10598,10598,10566,8518,10566,16970,21196,8518,10631,8518,10566,10566,10598,10598,8485,8485,8485,8518,8485,10566,10598,14792,14823,16904,16969,19017,19017,19049,14824,14824,19082,25421,19082,12744,10630,16937,21227,23276,23308,16969,25453,27566,27502,29647,21163,23275,38132,40244,25388,25388,40212,44438,19082,33873,17002,23275,23243,25420,31727,31792,25389,21195,21163,23340,27534,29647,29614,29614,27534,27534,40243,44469,23243,23275,16904,16904,21162,38066,46518,35952,40211,40179,40179,46486,50777,48599,38034,38033,35953,42259,48631,44372,33840,33808,31727,33840,46518,35986,31760,57117,46584,19018,10631,86},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59196,59197,59197,59197,59197,59197,59197,59197,59197,59197,59229,59229,59229,59197,59197,59229,59229,59229,59229,59229,59229,59197,59197,59197,59196,57148,57116,57116,59196,59196,59197,59197,59197,59229,61277,59197,59197,59197,59196,59196,59196,59229,59229,61277,61277,59229,59196,57116,57116,57084,55035,55003,52955,52923,52923,52923,52923,52923,50843,50843,50843,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52923,52891,52923,52891,48762,40343,44569,46682,36084,36051,25519,19115,21261,19148,16970,14857,12776,10631,12744,12744,10663,12744,10663,10631,10631,10598,10598,10631,10598,10598,10631,10663,10631,10598,8518,10598,8518,8518,8518,14889,21196,8486,10631,8518,8518,10566,10598,14824,12743,10598,10566,10630,10598,10631,12711,19082,21130,16904,16937,19050,23308,21195,21163,16905,21195,27567,23341,14856,10630,12743,21228,23276,23308,16937,25421,33873,19050,14824,14856,27534,40277,38132,31760,31760,44438,42357,19083,21196,14856,10630,25388,31791,31760,38131,38164,40212,40212,38164,40212,40244,40244,40244,38131,29646,36018,44470,27501,31727,33840,31759,31727,46485,42324,33808,33840,33840,35953,50776,50777,35953,31727,31727,33807,46550,46518,29614,27533,27501,29614,40179,42325,42293,33841,55004,48697,19115,12679,86},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59196,59197,59197,59197,59197,59197,59197,59197,59197,59197,59229,59229,59229,59197,59197,59229,59229,59229,59229,59229,59197,59197,59197,59196,59196,57148,57116,57116,57116,59196,59197,59197,59229,59229,59229,59197,59197,59196,59196,59196,59197,59229,61277,59229,59229,59229,59196,57116,57116,57084,57084,55003,52955,52923,52923,52923,52923,52923,50843,50843,50843,50843,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50842,46649,46649,48730,40278,42390,29680,19180,25519,25487,25455,23374,23374,21261,19148,19115,14857,12776,12776,10631,10663,10631,10598,10631,10598,10598,10631,12712,10631,10598,8518,8518,10598,8518,8518,14857,21228,8485,12711,12711,14824,12743,19114,21163,27567,23308,23308,25454,25454,25453,25453,23340,25389,25389,21163,23308,23276,23341,25421,19050,25421,29679,27566,17002,12711,10630,19082,21228,25421,21195,19050,21163,14856,31792,29679,25453,36051,40244,25421,21195,27501,42357,23341,8485,8485,14824,29646,35985,31759,31792,19082,16969,16937,17002,21228,21260,19115,16969,17002,16969,33840,36018,31727,35953,38099,38098,46518,50744,40211,35953,38066,38066,50711,52890,42292,35888,35953,35921,44437,48631,35986,31727,31727,31727,40178,38098,35986,38099,25389,52923,50778,23276,10598,76},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59197,59197,59197,59197,59197,59197,59197,59197,59229,59229,59229,59197,59197,59197,59229,59229,59229,59229,59197,59197,59197,57148,57148,57116,57116,57116,57148,59197,59197,59197,59229,59229,59197,59197,59197,59196,59196,59197,59197,59229,61277,59229,59197,59197,59197,59196,57116,57116,57084,55035,55003,52923,52923,52923,52923,52923,50843,50843,50842,50842,50843,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50842,48730,46649,44537,42488,44504,31826,25519,29745,27664,27600,27632,27600,29745,29777,27632,27567,25487,23406,21293,17067,14922,12744,12744,10631,10598,10663,12777,10663,10631,10631,10631,8550,8518,8518,14824,21228,12744,23309,23341,21228,27501,29679,21163,29679,25421,25421,29679,29647,29647,27567,25421,25421,29647,27502,33873,33873,31760,25454,17002,27502,29680,29679,23308,14824,10630,14824,21195,25421,27534,19082,10566,12743,23340,14856,21163,36018,38164,25421,23210,25290,33775,27567,12743,19050,16969,29614,40178,31759,31759,16969,12711,10631,14856,17067,17035,12808,12743,12744,14823,31759,29614,31760,38066,38034,38034,40179,42292,40212,35921,35953,35953,40179,44373,40211,35953,35921,35920,42292,42357,35953,31727,31727,31727,29614,25421,25356,31792,27534,52890,48697,23308,10630,68},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59197,59197,59197,59197,59197,59197,59197,59197,59229,59229,59229,59197,59197,59229,59229,61277,59229,59197,59197,59197,59196,59196,57116,57116,57116,57148,59197,59197,59197,59229,59229,59229,59197,59197,59197,59196,59196,59196,59196,59197,59229,59229,59229,59197,59229,59229,59196,57116,57084,57084,55003,55003,52923,52923,52923,50843,50843,50843,50842,50842,50842,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,50843,50842,48730,46649,44537,42424,40375,27632,19148,27665,27632,23406,23374,25519,27567,27600,27599,27600,27632,31826,36084,25519,29778,29745,29680,31793,23308,16970,12776,10631,10599,10598,19050,14857,14824,14889,21196,36019,29712,27566,25453,23308,29647,31760,29647,36019,33905,31792,29680,31760,31760,31728,31760,27534,29647,23276,21195,38132,38132,25421,16970,25421,29712,29679,25486,16969,12711,12678,19050,25454,23308,25421,29647,29647,27534,12679,25388,36051,40245,33872,23275,25322,31727,29647,23309,23308,25420,35920,40146,29678,33872,16937,12711,12743,14857,17035,14954,12809,12776,12776,12743,33840,38131,25388,19050,16969,19049,21130,27501,27534,14856,14823,14824,14791,16872,29614,29614,27468,29614,29614,29646,31694,31694,31727,31727,23275,16937,21163,35986,33873,48697,50778,23341,10598,66},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59197,59197,59197,59197,59197,59197,59197,59197,59197,59229,59229,59229,59197,59197,59229,61277,61277,59229,59197,59197,59197,59196,59196,59196,57148,59196,59196,59197,59197,59197,59197,59229,59229,59197,59197,59197,59197,59196,59196,59196,59196,59229,59229,59229,59197,59229,59229,59196,57116,57116,55036,55036,55003,52923,52923,52923,50843,50843,50843,50842,50842,50842,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52890,50842,50810,48730,46682,44569,40376,40343,34004,29745,33939,33971,31858,29745,29713,33906,31858,31858,34003,31858,31858,31858,27664,29713,31890,36019,52890,48697,27599,27600,23341,19115,14824,23308,16905,10631,12711,17002,31793,36018,36018,31792,29615,27567,25389,25389,33873,38099,29647,14856,16904,14856,16937,25421,27534,23340,10598,6372,23276,42357,29647,21131,23341,29680,29712,27599,19115,14792,10598,16904,25454,23276,23276,14824,25453,29679,23308,21162,33938,42357,31792,25388,35953,48631,46518,40179,31695,29613,38065,35985,27501,36018,27533,25421,27501,27534,29615,27566,27534,25453,25421,19082,31760,40179,40211,38131,38131,38131,38099,38099,38099,38066,35986,33873,27501,23275,35920,35953,33872,33873,33872,33840,31727,31727,31727,29647,27534,29582,31760,44438,44471,46584,50843,25454,10598,56},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59197,59197,59197,59197,59197,59197,59197,59197,59229,59229,59229,59229,59197,59197,59229,59229,61277,61277,59229,59197,59197,59197,59197,59197,59197,59197,59197,59197,59197,59197,59197,59229,59229,59229,59229,59197,59197,59196,59196,59196,59196,59197,59197,59197,59229,61277,61277,59197,59196,57116,57084,55036,55003,52923,52923,52923,52891,50843,50843,50843,50843,50843,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,50842,48730,46649,44537,40375,38262,38262,40342,42423,44536,44504,40278,36052,38197,38164,36051,36084,31890,31858,27664,27632,25487,33906,31793,50810,42358,21228,19083,25486,23373,19115,14857,14857,12744,14857,19115,21196,12711,27567,33873,31760,36019,38067,21195,31792,27566,31760,36018,33938,33905,31792,27534,25421,27534,16937,12711,31728,40244,25454,21195,25389,29679,29712,27631,23340,14857,10630,16937,21195,19050,23341,19017,23308,31792,33873,36050,38099,40244,33905,29614,33872,52857,59196,59196,33840,31726,40178,33839,31726,40244,44438,44470,46550,46518,46518,46550,46550,44470,44470,38099,31760,38099,38099,36018,36018,36018,36018,36050,36018,35986,36018,35986,29614,27501,38066,40179,38131,38131,38099,38066,35953,35953,35953,33905,33872,31792,31760,48664,50810,40212,44471,29648,10630,49},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59197,59197,59197,59197,59197,59197,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,61277,61277,61277,59229,59197,59197,59197,59229,59229,59197,59197,59197,59196,59197,59229,59229,59229,59229,59229,59197,59197,59196,59196,59196,59197,59196,59196,59197,61277,61277,59229,59197,59196,57116,57084,55036,55003,52923,52923,52923,52923,50843,50842,50843,50843,50843,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,50842,48762,46682,44537,40375,38263,40343,38230,36084,34004,40310,40310,33939,40310,40245,40213,36084,25519,25519,31858,23374,25486,33906,31825,44503,31793,21260,17002,25454,23341,19147,14857,14857,14857,31760,38099,23308,8453,10599,10598,14824,12711,16969,25453,42325,31793,33873,35954,35986,36018,38067,33905,27567,31760,33905,38131,36051,27566,19082,19115,23341,27567,31792,29679,25486,17002,14824,29680,27567,21228,27567,23308,23308,27534,27534,35986,33938,40244,35985,33840,40179,57083,57116,59196,33840,31759,38065,29613,46518,46518,35986,36018,40179,44438,44470,44406,40212,40212,42260,38131,33840,38066,38099,35986,35986,35986,35986,36018,38066,36018,36018,36018,33840,31727,31760,31759,31727,31727,31727,29647,29614,27566,27534,27501,25421,25421,27534,50810,52923,33874,42358,31760,12679,47},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59197,59197,59197,59197,59229,59229,59229,61277,61277,61277,59229,59229,59229,59229,59229,59229,61277,61277,59229,59229,59229,59229,59229,59229,59197,59197,59229,59197,59229,61277,61277,61277,61277,61277,59229,59197,59197,59196,59196,59196,59196,59196,59197,61277,61277,59197,59196,59196,57116,57084,55036,55003,52923,52923,52923,52923,50843,50842,50842,50842,50843,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50843,48762,46682,44569,40376,38263,40375,40310,38197,38165,42390,40310,33971,36052,29778,33971,33971,25519,29745,27599,25454,27600,31826,40245,44438,19115,25487,21196,23374,25453,21196,14857,14857,14857,21228,19083,23276,8485,10631,8518,8485,8485,10598,14857,12711,19083,25422,10631,10598,14824,12711,12711,16905,21163,27534,27566,27534,29647,25454,19082,23276,27566,31760,29680,27567,16969,14824,33873,31760,23308,25389,19050,21163,25421,21163,31792,31825,40244,33937,36050,33872,48664,57083,52890,33873,31726,31758,31727,50777,38099,33840,33873,38098,40212,40244,38099,35953,35986,35986,29614,27533,36018,36018,35953,35986,35986,35953,35986,35986,35986,35985,35986,33905,33873,33840,33872,31792,31792,31759,31727,29614,27534,27566,27534,25453,25389,25421,55003,55003,42390,52955,31793,12679,48},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59197,59197,59229,59229,59229,59229,59229,61277,61277,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59197,59229,59229,59229,61277,61309,61309,61277,61277,61277,59229,59229,59197,59196,59196,59196,59196,59196,59197,59229,59229,59197,59196,59196,57116,57084,55036,55003,52923,52923,52891,52891,50843,50842,50842,50842,50843,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,50842,48730,48730,44569,42488,40343,46584,44504,42423,44504,46616,42391,40310,42390,33971,40277,38197,31858,38165,36019,31793,31825,31793,29712,38100,21260,21260,16970,29680,25422,21196,23309,21196,19082,19147,23341,23276,8485,10631,8518,8518,8518,10598,10598,8485,10630,19050,10598,10598,14824,14824,14857,14791,14791,14791,16937,21195,25421,27534,25454,25421,27566,29680,29680,25454,14889,12711,23341,29712,25389,25421,23341,25486,25453,23275,25453,27534,36018,25421,27501,25388,48632,48697,33873,29614,31726,29613,42324,48631,35953,33873,33905,38099,40244,40212,38066,38034,40147,38066,29614,31727,35985,36018,35986,35986,38034,35985,35986,38034,38066,35986,35986,33905,33905,33873,33873,33873,31824,31727,29647,29614,27534,27566,27534,27534,19050,21131,57116,57116,44471,52891,36019,12678,48},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59197,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,61277,61277,59229,59229,59229,59229,59229,59229,61277,61277,61309,61309,61309,61309,61277,61277,59229,59197,59197,59197,59196,59196,59196,59196,59197,59197,59197,59197,59197,59196,57116,57116,55036,55003,52955,52923,52891,50843,50843,50843,50842,50843,50843,52923,52891,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,50843,48762,48730,44569,42488,42456,48697,44536,40310,42423,44504,44504,44503,44471,42390,46584,46552,42390,40278,42358,44471,44471,40245,21228,25487,38165,23309,17002,33873,23308,29680,40245,33906,27534,19147,21228,23309,8485,10631,8518,8518,8518,10598,10598,8518,14824,21195,10566,14889,19083,23341,19115,19049,16937,14824,16904,14791,10598,14824,29647,29680,27534,29680,27599,29679,21195,14824,14824,29679,29647,29647,23308,19115,21195,19082,25421,29711,38099,27566,21195,21195,46551,46551,27502,33873,29581,31759,50744,42325,33840,33873,33873,40212,40244,38099,33873,35986,35986,29614,33872,48631,50777,38099,35953,35953,35985,40179,40244,38099,33808,31760,31760,38066,35953,33905,29647,27566,27534,29647,29647,33873,27534,21163,16937,16937,10630,21163,59197,57149,52858,55036,42358,10631,50},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59229,61277,61309,61309,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,61277,61277,61277,61277,61277,59229,59229,59229,61277,61277,61309,61309,61309,61309,61309,61277,61277,59229,59197,59197,59197,59196,59196,59196,59196,59197,59197,59197,59197,59196,59196,57116,57084,55036,55003,52955,52923,52923,52891,50843,50843,50842,50843,50843,52891,52923,52923,52923,52891,52923,52923,52923,52923,52923,52923,54971,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52923,52891,52890,52891,50842,48730,48730,44569,42456,38295,42456,48730,46616,42423,40310,40310,33971,36052,33939,31826,42390,33938,29680,25487,27567,27535,33938,21260,23308,31858,29648,17002,29648,27534,33939,38164,31793,31793,23341,21228,21196,10566,12711,8518,8518,8518,10598,10630,10598,21228,21228,8518,21260,19115,16937,16969,19017,16904,10630,12711,12711,12711,12678,27534,33905,27534,29712,27534,27567,19082,12711,12744,25389,27566,38099,23276,16937,21163,19049,27501,33905,38131,29679,42357,44471,35986,33872,35954,38132,23307,40179,50777,35953,35953,35953,40179,40244,40244,38066,33905,35953,35953,29679,42324,52890,48664,33840,33872,35953,40211,40212,42324,33873,31727,31760,33873,35953,35953,29647,27502,27501,27501,29614,29647,33873,16937,14856,10630,10566,8518,19082,57116,59197,57084,55003,40277,14824,48},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59229,61309,61309,61309,61309,61277,61277,61277,61277,61277,61277,59229,59229,59229,59229,59229,59229,61277,61277,61277,61277,61277,61277,61277,61277,61309,61309,61309,61309,61309,61309,61309,61277,59229,59229,59197,59197,59196,59196,59196,59197,59197,59197,59229,59197,59196,59196,57116,57116,55036,55003,52955,52923,52923,52891,52891,50842,50842,50842,50843,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,52891,50842,48762,44537,40343,38263,36150,36182,42423,46617,44504,38197,38229,40278,38165,31858,23439,40310,33971,29713,27600,29680,23374,31826,23341,21196,29680,25454,21228,29648,23308,40277,33939,38164,36019,25486,23341,19050,10631,12744,10566,8518,8518,10598,10598,10566,21196,16970,8518,16970,19115,14857,16937,16937,14856,12678,12711,12711,12711,12678,27502,38099,29680,31825,29647,33906,27535,23341,23341,29679,29680,36018,25454,25421,25453,23308,29614,33872,42358,36018,33905,29679,38132,46583,50810,40212,27501,48631,44405,33840,33873,35985,40212,40244,40212,36018,35986,38066,31792,33872,48696,52923,40212,33840,35953,38098,42292,42324,40179,33872,31727,29647,33873,33873,33841,27534,25389,25389,27534,27534,33905,19050,12711,16937,14824,12679,12679,14856,52891,57117,55036,48697,42390,33873,97},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,61309,63390,61309,61309,61277,61277,61277,61277,61277,61277,59229,59229,59229,59229,59229,59229,59229,61277,61277,61277,61277,61277,61309,61309,61309,61309,61309,61309,61309,61309,61277,61277,59229,59229,59197,59197,59196,59197,59197,59197,59229,59229,59197,59197,59196,57116,57116,57084,55003,55003,52923,52923,52923,52891,50843,50842,50842,50842,50843,52923,52923,52923,52891,52923,52923,52923,52923,52923,52923,54971,54971,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,50842,48762,42423,34037,34037,34037,34036,31956,40310,40343,40310,38229,40343,36084,29713,23439,33971,36052,29712,27632,27567,25454,36019,23341,21228,23373,36019,33906,21260,23308,38165,33938,36019,33873,31793,38132,19115,10631,12744,10566,8518,8518,10598,10598,10566,23308,21228,12679,25389,19083,19050,14824,16937,14824,10598,12679,12711,12679,12678,25389,38132,31793,29680,23373,29680,21260,16970,23341,29712,29679,40244,36018,38132,33873,23308,38099,40211,46551,42292,29679,25421,29615,50777,52923,40245,33840,50777,35953,33840,31760,38066,38163,40212,35985,33840,33873,38099,31759,40244,52890,50744,31792,35953,35953,40212,42292,42259,35985,33840,31727,31727,33840,31760,27534,25388,25421,25421,27534,29647,35986,16937,12711,14857,19115,14792,12679,12711,46552,54971,50777,44471,38099,33938,132},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,61277,61309,61309,61309,61309,61277,61277,61309,61309,61277,59229,59229,59229,61277,61277,61277,61277,61277,61277,61309,61277,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,61277,59229,59229,59197,59197,59197,59197,59197,59197,59197,59197,59196,59196,57116,57116,57084,55003,55003,52923,52923,52891,50843,50843,50843,50842,50842,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52955,52923,52923,54971,55003,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,50842,48762,46649,38263,38263,38262,38230,36150,38230,40343,40310,40310,40342,36084,29778,25519,27600,34003,29745,27567,27567,23406,40244,25486,21260,21228,33906,27567,16970,16937,14857,19115,12744,23276,33938,31858,17002,10631,12744,8518,8518,8518,10598,10598,10566,21196,21195,29614,35986,17002,14856,12744,14791,16904,10598,12646,12678,12679,14824,21163,38099,36051,25454,19082,23341,19115,14824,23308,31825,29679,42357,44503,42358,33971,25422,40212,40179,44470,40212,27534,23276,21195,44503,50810,46551,44438,50777,46551,46518,46551,46583,46583,46583,46551,46518,44437,25453,31727,48696,54971,42292,31792,33872,36018,40212,42292,40179,33840,31759,31760,33873,33840,31727,25421,23308,25388,27534,27501,36018,27534,21163,12711,12711,10598,10598,10630,10630,35954,36018,38099,42325,33938,33906,128},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59196,61277,61309,61309,61309,61309,61277,61309,61309,61309,61309,61277,61277,61277,61277,61277,61277,61277,61277,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,61277,61277,59229,59197,59197,59197,59197,59197,59197,59197,59197,59196,59196,57116,57116,55036,55003,55003,52923,52923,52923,50843,50843,50843,50842,50842,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,54971,52955,52923,54971,46551,50777,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52923,52891,52891,52891,52891,50842,46682,44536,42455,42456,40375,40376,40343,36150,38262,38230,38229,40343,29745,27665,25552,25520,33971,31825,27567,25519,25487,38132,27567,23341,23308,23373,19083,23308,19083,21196,27567,23373,23308,33938,31825,21195,14824,14889,8518,8518,10566,12744,14889,19083,21228,21195,29613,23340,17002,12744,12712,14856,14856,12711,10598,10630,12678,12678,16904,33906,38164,27567,17002,19082,16969,12776,14856,23308,21195,25421,40244,46584,38164,27599,44470,42357,46550,42292,29646,27534,23275,35986,48697,48664,46518,48696,50777,52858,50744,48696,50744,52890,52889,52889,50777,25388,35986,54970,50777,35921,35953,33872,40179,40211,40212,33872,31727,31727,33840,33905,33873,29615,25421,25389,25421,27566,31792,33906,19082,23341,14824,14857,14824,12711,12711,10631,33873,40212,42390,38099,35986,33906,129},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59229,61309,61309,61309,61309,61309,61309,61309,61309,61277,61277,61277,61277,61277,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,61277,59229,59197,59197,59197,59197,59197,59197,59197,59197,59196,59196,57116,57116,57084,55036,55003,52923,52923,52923,52891,50843,50842,50842,50842,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,54971,54971,54971,52923,46552,46551,50810,52923,52923,52923,52891,52891,52891,52923,52923,52891,52891,52891,52891,52891,50843,50810,44537,40375,40375,40375,38295,40343,40343,36149,38230,38230,38197,38197,27665,25519,25487,23407,40278,29745,27632,27599,27567,38164,25487,19147,21228,21228,19083,21196,17002,21228,25486,25454,25454,29647,27567,27534,27567,25454,10630,10599,10598,10631,10598,21195,19115,19050,27501,21195,14889,10631,10631,16937,16904,14792,12711,12743,12743,12711,14856,27534,38164,29712,21228,25454,19083,14824,10630,25389,25421,31760,29647,38131,42390,35986,48663,46550,48663,44437,31759,29679,29646,29647,46584,48631,46518,50777,50809,48664,46551,46551,48631,50744,48630,54970,52857,31759,46550,55003,42292,33840,35953,38034,42292,42292,38066,31695,31695,29647,35953,33905,31760,27501,25421,25389,27566,29615,35986,23308,19082,25421,14857,14857,21196,10598,10598,8518,31760,46584,38164,35986,33938,33906,130},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59229,61309,61309,61309,61277,61309,61309,61309,61309,61277,61277,61277,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,61277,59229,59197,59196,59197,59197,59197,59197,59197,59197,59196,57116,57116,57116,57084,55036,55003,52923,52923,52891,52891,52891,50842,50842,50843,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,55003,50810,46551,50777,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52891,50843,44536,42456,36117,40343,40343,40343,40375,40343,38262,38230,38230,40310,29745,25520,21326,21326,42390,36019,36051,29712,23341,40277,33939,29680,27535,21196,21196,19115,14857,16937,14825,21261,33906,27534,29647,35986,23308,21228,38066,27502,14889,21196,8518,19115,25422,19082,25420,23275,19115,10631,12711,16937,12776,14857,16970,16937,14856,14856,14857,21195,35986,29680,21260,27567,21228,14856,10630,25421,27567,27534,35986,33905,38164,40244,50777,48631,50776,48631,33872,31727,29679,25453,38131,46583,46551,50744,50776,46551,48664,48631,50776,50776,52889,54970,50744,40179,52890,52857,35953,33872,35953,42260,42292,42292,35920,33808,33840,35953,35953,35953,29614,27501,25421,29615,29647,33841,27566,21163,25421,25421,14857,14857,23309,12743,12679,10598,29680,44471,33873,33905,35986,27567,108},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59197,59229,61277,61309,61277,61277,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,61277,61277,59229,59229,59196,59197,59196,59196,59197,59197,59197,59196,57116,57116,57116,57084,55036,55003,52955,52923,52923,52891,50843,50842,50842,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,54971,52890,48664,48697,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,50843,44536,42456,38230,38230,40311,42423,46682,42456,36116,36117,38262,40278,31858,25552,23406,23406,42390,33971,21196,17002,14889,23341,25454,23309,21228,16970,23309,16970,10598,10598,12711,25454,36051,17002,25389,48664,29614,23276,46518,27502,21163,21195,10566,19115,25454,23340,27533,25356,19050,10631,10631,21228,16970,16937,19115,12744,10631,14824,14857,19115,29680,29712,21228,27599,21196,14856,10630,25388,27567,25389,38164,33905,27534,36018,52857,52856,54938,52889,50776,50776,31792,23275,40212,48631,48663,50744,48664,46551,46584,48631,52857,50744,54938,52889,50711,48663,52890,42292,35985,40179,40179,40179,40146,38098,35985,35985,35985,35985,35986,33872,31727,31727,29647,29647,31760,33873,19050,27534,19050,25454,14824,14857,16970,14889,14857,14824,23309,35986,35986,27534,29647,40212,122},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,57148,59197,61277,61309,61277,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,61277,59229,59197,59196,59196,59196,59197,59196,59196,59196,57116,57116,57116,57116,57084,55003,55003,52955,52923,52923,52923,50843,50842,50842,50843,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52890,52891,50777,46584,50810,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,50843,44536,42456,42456,38230,36117,40343,42456,36149,34037,34004,38230,38229,29810,25552,23407,25487,46649,29680,10566,12679,12679,10599,10631,10598,10631,12712,23373,16970,14857,19083,14857,27600,36019,14857,35953,50744,42324,50744,46518,44405,36018,23308,10598,10565,12743,27566,27533,25388,19082,10631,10599,14857,12744,14824,14824,12711,10631,10631,12744,19050,23341,27567,21228,25519,21228,14824,10598,23308,27534,23308,36051,38131,27501,27566,36018,44405,50744,52857,50711,52889,44405,38099,42357,44405,46518,44470,38131,44470,48664,50777,52824,52824,55002,52889,42259,40179,38033,31726,29581,35985,38033,35953,35953,35920,33840,33840,33807,31726,29613,27501,27501,27501,25388,23308,29679,23276,25388,23243,21195,23373,14857,14824,12744,12711,12743,12744,14824,29647,38099,35954,40212,48632,183},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59196,59197,59197,59229,61277,61309,61309,61309,63389,63389,63389,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,59229,59197,59196,59196,59196,59197,59196,59196,59196,57116,57116,57116,57116,57084,55035,55003,52955,52923,52923,52923,52891,50842,50842,50843,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,54971,52923,52923,52923,52891,50810,46551,48697,52923,52923,52923,52923,52923,52923,52923,52923,52891,50843,44537,42456,42424,42456,38230,36117,40343,38230,36117,34004,36149,40310,29746,25519,23407,21293,27567,19083,12711,12679,12679,12712,12711,12711,12712,10631,17002,23341,29712,25454,12744,29745,33939,23341,46518,44404,44437,48664,38066,44438,38098,33873,27534,21195,17002,29679,29679,25356,19083,10631,10566,14824,12744,10598,10598,10598,10566,10630,19147,14824,23308,21260,21228,25486,21228,14857,10598,23243,27534,23308,38131,40277,25421,29646,33905,33905,44437,52857,52856,42259,35954,33905,31727,27533,29614,27501,27502,44438,44503,48631,44437,50777,52857,44405,38098,40211,42292,31726,29581,35985,38033,35985,35953,35920,33872,33839,33807,31726,29613,29614,29614,27534,25421,27534,27566,19049,23308,21162,25388,23308,16937,14857,12712,10631,10630,10631,12711,33873,38131,46551,59197,59197,227},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59197,59197,59229,59229,61309,61309,61309,63390,63390,63389,63389,61309,61309,61309,61309,61309,61309,61309,61310,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,59229,59197,59196,59196,59196,59196,59196,57116,57116,57116,57116,57116,57116,57084,55036,55003,52923,52923,52923,52923,52891,50843,50842,50843,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,55003,52923,54971,54971,52923,52923,52923,52923,52891,52923,52891,46616,46616,52923,52923,52923,52923,52923,52923,52923,52891,50843,48730,44536,42423,42456,40342,40343,42423,38230,36149,34036,34004,38197,29778,23406,23406,19180,12809,12776,12743,12711,12711,12711,10663,10631,12679,10599,14824,21228,27632,25487,12711,21228,33906,40245,33874,31727,44437,44405,38066,44470,33905,33905,29711,27534,14857,12744,16970,19115,19148,14857,14824,14824,19115,17002,12744,12711,12776,16970,25422,12744,23308,19115,14857,19083,17002,12744,10598,21195,31760,25389,38132,40277,25421,29647,33905,36018,40244,42325,44437,42324,29647,27502,29679,31824,35986,31792,25356,38099,27534,35985,35985,35953,40211,40211,40178,38130,38065,33839,27435,35952,35985,35952,35952,33840,33807,33807,31759,31726,29581,29614,29614,27533,23340,29647,16969,23308,19082,25388,21227,25389,16937,12776,19115,12744,10631,10598,12711,27534,35986,38099,50809,50777,199},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59197,59197,59229,59229,61277,61309,63389,63390,63390,63358,63390,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,61277,59229,59197,59197,59197,59197,59196,59196,57148,57116,57116,57116,57116,57116,57084,57084,55003,52923,52923,52923,52923,52891,52891,50843,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,54971,55003,54971,52923,52923,52923,52923,52923,52923,52923,52890,48729,46584,50810,52890,50810,52923,52923,52923,52956,48729,34004,31891,36085,36085,33972,36084,31891,29745,31858,33971,31891,31858,27664,25519,25487,21228,14857,14824,12711,12711,12711,12744,19115,19115,19083,17035,19083,21261,23374,23374,16970,19115,16938,21228,14857,19082,36019,38099,33906,31760,25421,25422,23308,19115,14824,10663,12776,12776,23341,21196,23276,10566,17003,19115,14824,12711,10631,14824,23341,12744,16970,23341,23341,23309,17002,12744,10631,25389,27566,23308,40244,40212,33937,31727,33872,35986,33905,31760,40244,46551,35986,27534,29647,33872,36018,36050,23275,33841,27534,38066,38098,38098,38065,35985,35920,33839,35985,46550,42259,48663,48631,40211,38066,40179,42259,42292,42259,40179,38066,38098,40179,35986,27534,19050,21195,16969,23275,23308,21195,25389,16937,12744,19115,10630,10566,10598,10631,23308,35953,36018,40276,29679,136},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59197,59197,59229,59229,61277,61309,61309,63390,63390,63390,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,61277,59197,59197,59196,59197,59197,59197,59196,57116,57116,57116,57116,57116,57116,57084,57084,55004,52923,52923,52923,52923,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,55003,55003,55003,55003,54971,52923,52923,52923,52923,52923,52923,52923,52891,50778,46584,33971,44471,52955,52923,44536,36051,23406,14889,12776,14922,14922,14889,16970,16970,14857,14857,14889,14857,14857,14857,14922,14857,14857,14857,14824,12744,12743,12711,12711,23341,23341,21293,21261,23341,21228,19148,21196,21196,19148,21196,19115,19148,19083,17002,16970,16970,14922,17002,16970,16970,16970,14889,14889,14889,14824,21228,19083,25421,10598,12711,14856,10566,10598,10598,10631,21196,14824,14824,25454,25486,29745,21228,14857,10630,23308,27534,21195,38099,35986,38132,29679,33872,35985,33905,27534,38099,40277,38099,27566,29647,33873,38131,38099,33840,35985,27533,38098,38098,38098,38065,38065,35985,33839,44405,46550,50744,54970,48663,35953,35952,40179,40179,40211,40179,38066,38033,35953,36018,29680,23275,19017,21163,21195,23308,23276,21195,23308,17002,14857,19147,12711,10566,10598,10631,23308,40180,46551,29614,31759,200},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59196,59197,59197,59229,59229,61277,61277,61309,61309,63390,63390,63390,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,59197,59197,59196,59197,59197,59196,57116,57116,57116,57116,57116,57116,57116,57084,57084,55004,52923,52923,52923,52923,52923,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,55003,52955,55003,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,50842,48762,29778,40245,52923,50810,27599,17067,19147,19147,17035,17035,17035,17002,17003,19083,17002,14921,14857,8518,8517,14824,21228,16970,10631,16970,14889,10631,12744,14825,12711,16970,12776,12776,16970,14857,12744,14889,16970,12744,12744,16970,12744,12711,14857,12776,10631,12744,14857,12711,12711,14857,12711,10631,12711,12711,10598,19082,21196,29680,29680,25486,19083,10598,8517,8517,10598,19083,21196,21196,27535,27567,29745,21228,16937,12711,23340,31728,23340,40212,40212,29646,27566,33873,33905,31760,29679,36018,42357,38132,27566,33840,35986,38131,38099,27566,36018,44438,46550,48663,52857,50744,42324,42292,46518,48631,46518,52890,52889,40178,35952,40146,40178,40179,40178,40146,35953,35985,40211,31760,16969,27534,23276,16904,21195,21195,21195,21163,21228,17002,12743,19115,14889,12743,10631,10630,21195,38067,29647,19082,40212,165},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59197,59197,59229,59229,61277,61277,61309,61309,63390,63358,63358,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,59229,59197,59196,59196,59197,59197,59196,57116,57116,57116,57116,57116,57116,57084,57084,55003,52923,52923,52923,52923,52923,52923,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,55003,55003,52955,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,31859,40245,46616,44471,27567,21228,19180,19115,17034,17067,17068,14922,14857,19082,17002,16970,14857,10566,10631,17002,14857,12776,10663,12711,12776,12711,10631,12744,12744,12712,12711,12744,12744,10631,12711,12711,12711,10631,12711,12711,10599,12711,12711,10598,10631,10631,10631,10566,10598,10631,10566,8518,10598,10598,8485,21196,27567,27600,29745,29744,23309,10631,12679,10566,8485,19083,25487,21293,23341,31825,27599,23309,19082,16937,27566,33873,27534,42325,40244,27566,29646,33937,36018,29614,33873,35986,44406,40244,27534,33905,35986,36050,38131,27501,31760,40212,42292,44405,44437,44405,38098,31727,44372,46518,50744,54970,46518,38065,40146,42259,42227,42259,40146,38033,35953,40179,31728,16969,23340,27566,16937,16937,19082,21163,21163,19082,23341,19050,14824,14857,14824,12744,12711,12711,21163,16937,12743,33840,54971,201},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59229,59229,59229,59229,61309,61309,61309,61309,61309,61309,61309,61309,61309,63389,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,59229,59197,59197,59196,59197,59197,59196,57116,57116,57116,57116,57116,57084,57084,55036,55003,55003,52923,52923,52923,52923,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,54971,52923,52923,54971,55003,54971,54971,52923,52923,52923,52923,52923,52923,52923,52923,52891,52923,52923,52923,31827,33906,48729,25486,25454,21260,21228,19147,17002,19181,19280,17036,10631,14857,19082,19083,17034,16970,17002,16937,12744,16970,16970,14889,16970,16970,14889,14857,14857,12776,14824,14857,14824,14824,14857,14857,12776,12744,12776,12744,12744,14824,12744,12711,12744,12744,12711,12679,12679,10631,10599,10631,10631,10598,10566,21163,25422,23341,31793,29712,23309,14889,12711,10631,8518,17002,14857,12711,19082,29712,29680,21196,16937,12678,21195,27566,23276,40212,38132,27566,27566,33905,35986,29647,33873,36019,46583,40212,27534,31760,35985,38099,38131,29614,21195,31759,35985,38065,35952,35952,33839,27533,46518,46518,52889,50777,40179,35985,40178,40178,42259,40146,40146,35953,35985,38098,19017,19082,27566,16969,16969,14856,19082,21162,21130,19082,23276,17002,12776,12744,12711,10631,10631,12679,19082,27567,23276,35986,36019,137},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59229,59229,59229,59229,61277,61277,61309,61309,61309,61309,61309,61309,61341,63389,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,59229,59197,59197,59196,59197,59196,57116,57116,57116,57116,57116,57116,57084,57084,55003,55003,52955,52923,52923,52923,52923,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,54971,52923,54971,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,52923,52923,52923,31826,29745,48762,36019,23341,21260,21228,19147,17034,19213,19247,21295,12777,19050,25421,23308,23308,23275,21228,19083,12711,16970,17002,16969,16970,16970,16970,14857,14857,14857,14857,14857,14857,14857,14857,14889,14889,14857,14857,14857,14857,14857,14825,14857,14857,14857,14857,12744,12712,12744,12712,12712,12711,12744,12744,14824,16970,21196,31793,29745,23309,12776,14824,12711,10598,12776,12712,10598,19115,27567,27567,19115,14857,12678,21163,25421,19082,38099,40212,29646,27534,33873,35985,38099,29679,40212,48664,42357,27566,31760,35986,38098,36018,29646,23307,33839,38098,38098,38033,38033,35952,44404,46517,48663,52922,48598,38033,40146,42259,40211,40178,38065,38033,35953,38066,27501,23243,27534,27501,16937,19017,14824,19082,19082,19082,19082,21195,19050,12744,17002,16937,12679,10631,10630,21228,38132,25422,23308,23276,89},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59229,59229,59229,59229,59229,59229,61277,61277,61277,61309,61309,61309,61309,63389,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,61277,59229,59197,59196,59196,59197,57148,57116,57116,57116,57116,57084,57084,57084,55036,55003,55003,52923,52923,52923,52923,52923,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,48697,50810,46616,31891,21294,25455,23342,19115,21260,21228,19115,17002,19181,21425,19181,19082,29648,38066,40179,40179,38066,35986,29647,10631,10630,10598,10598,10598,10598,10598,10598,10598,10598,10631,10599,10598,10598,10631,10631,10631,10631,10630,10598,10631,10631,10631,10598,10631,10631,10631,10631,10631,10598,10631,12744,12711,12711,16970,16970,16970,23309,29680,27567,23341,17002,16937,14824,14824,19083,19083,19050,23341,27567,31792,25421,23308,23308,27534,27566,25421,35954,35986,31760,31760,35986,33905,38098,33840,44405,50777,44438,25453,29679,33872,38066,40179,38098,35953,40179,46486,44437,44405,44405,44372,48598,46517,52857,52889,40179,35952,40178,40178,42259,38065,40146,35953,38066,33873,16936,25356,25420,29581,21195,19050,12743,19050,19050,19017,21162,21195,17002,12744,17002,14824,8420,8452,8452,21195,38132,27534,25486,25454,101},
{57116,57116,57116,57116,57116,57116,57116,57116,57084,55036,57084,57116,57116,57116,59197,59229,59229,59229,59229,59229,59229,61277,61277,61277,61309,61309,61309,61309,61309,61309,61309,61309,63389,61341,61309,61309,61309,63389,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,61277,59229,59197,59197,59197,59196,57116,57116,57116,57116,57116,57084,57084,57084,55035,55003,55003,52923,52923,52923,52923,52923,52891,52890,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,50778,46616,44503,38230,40310,33971,25519,23373,21228,21195,19083,16969,17068,21425,14954,16970,14857,12744,19082,19083,10663,12711,12711,12744,12743,10598,12711,14824,10598,10631,12776,10663,10566,12711,14824,10566,10631,12744,10598,10598,12744,14824,10598,12711,14824,10631,10631,12711,12744,10631,10631,12679,10566,12711,21196,21260,17002,16937,14857,14824,14857,12711,12711,12711,25486,21228,17002,14857,12743,10630,23276,27534,21163,33905,27566,21195,27534,27534,27534,38131,36018,33938,38131,38131,29647,33873,29679,35986,48631,50744,50744,48631,42292,44405,38098,40211,40179,42292,44437,46550,46486,44405,48630,52890,50711,50744,54970,46518,35920,38065,40178,40146,40178,40178,35985,35921,38066,25421,23275,27501,25420,29581,27534,19082,12711,16937,16969,16937,19050,21163,19115,12744,16970,14856,8420,8420,6372,17002,36018,27534,25486,25486,99},
{57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57116,57116,59197,61309,59229,59229,59229,59229,61277,61277,61277,61309,61309,61309,61309,61309,61309,63389,63389,63389,63389,63389,63389,63389,63389,63389,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,61277,61277,61277,59229,59197,59197,59196,59196,57116,57116,57116,57084,57084,57084,57084,55036,55003,55003,52923,52923,52923,52923,52923,52923,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,52923,52923,52923,52923,50842,50842,46617,38197,40310,38165,31858,27600,29648,27567,27567,25454,25553,25487,23373,21195,23308,21228,17002,16970,19115,17002,12711,12744,10598,12711,12744,10598,10631,12744,12711,10598,10631,12744,10598,10631,12711,10631,10598,12711,12744,10598,10631,12744,12679,12711,12711,12776,10631,12711,12711,10598,10598,14857,21195,16970,12679,10631,10630,10631,12679,10630,10630,12743,12679,21196,23341,17002,10631,19050,33938,25453,33873,27566,23276,25421,23308,25421,40277,38131,36051,36018,31825,29615,46551,31760,25420,33840,31727,40179,38066,44437,44437,38098,42292,38065,40146,42259,42324,40211,40178,42291,48663,50744,52890,52857,40146,35984,40211,40178,42259,40179,40178,38065,40146,31727,12743,25388,25388,25388,25388,23243,19082,12711,16904,16969,19049,19082,21163,21195,12744,16969,19083,12711,14824,19082,23308,31793,27599,25486,27534,102},
{57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,55036,57084,57116,59229,61309,61309,61309,61309,61277,61277,61277,61277,61309,61309,61309,61309,61309,61309,61309,61309,63389,63389,63389,63389,63389,63389,63389,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,61277,61277,61277,61277,61277,59229,59197,59196,59196,57116,57116,57116,57084,57084,57084,55036,55036,55003,55003,52923,52923,52923,52923,52923,52923,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,52923,52923,55003,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,50810,48697,34003,29777,29745,31825,31825,29745,29713,29745,25454,23373,25551,25486,19115,23374,23406,17002,21196,21228,19082,12711,12744,10598,12711,14824,10631,10631,12744,12711,10598,10631,12744,10566,10599,12711,10631,10598,10631,12711,10598,10663,12711,12744,12744,12711,14857,14824,12744,12711,10598,10598,10598,10566,12711,10631,14857,10631,12711,12743,10631,10598,10598,12743,12743,25421,21196,17002,14824,33905,33905,21195,23308,23340,25421,21162,23308,40212,36051,36051,38099,40277,48696,40244,44470,33905,25420,25421,35953,38066,38098,42324,42324,44371,46485,52825,52889,52890,52889,52857,54938,50744,50776,54970,46518,38065,40146,42291,42259,42259,40211,40146,40146,38098,23308,23243,23275,25356,23275,23275,16969,19050,12679,16937,19050,21130,21162,21195,19115,12744,14824,12743,12711,14824,16937,19115,36051,29679,25486,27534,103},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,59229,61309,61309,61309,61309,61309,61309,61277,61277,61277,61309,61309,61309,61309,61309,61309,61309,63389,63389,63389,63389,63389,63389,63389,63389,63389,63389,61309,61309,61309,61309,61309,61277,61277,59197,61277,61277,61277,61277,61277,59229,59197,59196,57148,57116,57116,57116,57084,57084,57084,55036,55003,55003,52923,52923,52923,52923,52923,52923,52923,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,50810,50810,48664,48665,44504,42358,40278,40310,40278,38164,38197,40277,38164,33938,38164,38132,29680,31826,23309,14889,12776,14857,14857,16970,14824,12744,17002,14857,12744,14824,16970,12744,12711,16937,12776,12711,12776,14889,12712,12712,16970,12744,12744,14889,16969,12776,17002,19115,12711,10598,8518,10566,10598,14824,12744,16937,12711,10598,12679,14824,16937,16937,16937,14824,14856,10598,19082,19083,33905,31856,25453,21195,23308,25453,19114,25421,36051,36018,36018,36018,33873,40212,33905,42325,36018,29647,33840,38066,35953,35953,46518,44404,44404,44404,44372,44372,31694,25388,29581,48663,48598,52890,52857,42259,40146,42259,42259,44372,42259,42259,40179,40211,29614,14856,25420,27501,23308,21162,21162,19049,19049,16937,19050,19050,16937,16904,19050,21163,12744,12744,12678,10598,10598,10598,14856,40212,29712,25486,25486,101},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57116,57116,59229,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,63389,63389,63389,63389,63389,63389,63389,63389,63389,63389,61309,61309,61309,61309,61309,61277,59197,59197,59229,61277,61277,61277,61277,59229,59197,59197,57148,57116,57116,57116,57084,57084,57084,55035,55003,55003,52955,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,50810,50810,48697,48697,36019,21196,19148,19115,21196,19115,19115,21228,19083,19083,19115,23309,25454,21228,19083,14857,19083,21196,16937,17002,17002,16970,16937,17002,19083,14857,17002,17002,16970,14889,19050,17003,14857,16970,17002,16937,14889,17002,19115,16938,16970,23309,23309,14889,12744,12744,12744,10598,10598,10630,12711,14857,12743,12744,12743,14857,17002,16970,16937,16969,14857,14824,14824,19082,23340,25454,21195,21228,21228,27534,25388,25421,35986,31792,33873,33905,29679,35986,38099,33906,27534,23243,31727,38131,38066,40244,44438,42292,35953,38066,42324,42292,27468,18984,35985,48663,50776,54970,48598,40146,42259,42324,42324,44372,42292,42259,31727,27468,23307,21162,23307,29614,25453,19017,16937,16969,16904,10598,14791,16904,14824,14857,19083,21228,12744,14856,16970,10598,10598,10598,14824,38164,31792,25486,27534,103},
{57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57116,59229,61309,63390,63390,61309,61309,61341,61341,61309,61309,61309,61309,61309,61309,61309,61309,63389,63389,63389,63389,63390,63390,63389,63389,63389,63389,63389,61309,61309,61309,61309,61309,61277,59229,59197,59197,61277,61277,61277,61277,59229,59197,59197,59197,57116,57116,57116,57084,57084,57084,55036,55003,55003,52955,52955,52923,52923,52923,52923,52923,52923,52923,52923,52891,52923,52923,52923,52923,52923,52923,52923,54971,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,38164,36084,44504,36051,19083,14857,14857,14889,14857,14857,12744,14857,14824,14824,14857,17002,23309,19115,12711,23374,29713,16970,14857,23374,23341,12711,23309,27567,16970,16937,25454,23341,10663,23309,27599,16970,14857,23373,21261,12744,19148,23341,14890,14857,21261,19083,12711,12744,16970,12744,12743,10566,10566,10631,14824,14857,14889,14857,14824,16937,19050,19083,19050,19050,16969,19050,16937,12679,10598,14792,21196,21195,31760,21195,23308,36051,33938,33905,31825,29679,27566,29615,25421,25356,23307,29647,40211,38131,40211,40179,27533,8485,14823,29646,21227,23308,21162,48631,48631,54970,52857,42258,40146,42291,44372,44405,42292,42324,33807,16872,19049,23275,23275,21162,23276,21163,14824,14856,14888,14824,10598,12711,14824,12711,12711,16937,21195,12743,12744,16937,8485,8518,8485,12743,38132,31825,25486,27566,103},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,55036,57084,57084,59229,61341,63390,63390,63390,63390,61341,63390,63390,63390,63390,63390,61309,61309,61309,61309,63389,63389,63389,63389,63389,63389,63389,63389,63389,63389,63389,61309,61309,61309,61309,61309,61277,59197,59197,59197,59229,61277,61277,61277,59229,59197,59197,59197,59196,57116,57116,57116,55003,55003,55003,54971,52923,52923,52923,52923,48697,48665,52923,52923,52923,52891,52923,52891,52923,52923,52923,52923,52923,52923,52923,52923,52955,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,48697,46617,52923,36051,14857,16969,10663,10631,10631,10631,10631,12711,12744,10631,12711,12711,19115,21196,8518,14824,14889,12744,10598,14889,14857,8518,12744,16937,12711,10598,16970,14889,8518,14824,16970,12744,10598,16937,14889,10566,12744,14857,12744,10598,19115,21196,10599,12744,12711,10566,14824,10598,12711,12711,14889,19083,16970,16970,14857,16937,16970,21195,21163,21163,19050,19082,19017,14824,12679,12679,10630,16937,25421,25421,25453,38164,36051,36018,36018,31825,25421,23276,19082,19082,23307,31727,40211,40179,38131,40211,38098,35985,35986,29679,23242,21195,38033,48663,50777,54971,48599,40178,42259,42291,44372,44372,44372,44372,23243,12710,23275,38131,12711,10630,14856,16970,10566,10598,10598,12678,10598,10598,14792,17002,14856,12743,21195,12711,12743,14824,8485,10598,16970,19082,31792,33873,25486,27567,106},
{57116,57116,57116,57116,57116,57116,57116,55036,57084,55036,55036,55036,57084,57149,61309,61342,63390,63390,63390,61341,61309,61342,63390,63390,63390,63390,63389,61309,61309,61309,63389,63389,63389,63389,63389,63389,63389,63389,63389,63389,61341,61309,61309,61309,61309,61277,59197,59197,59197,59229,59229,61277,59229,59229,59197,59197,59197,59196,57116,57084,55003,46551,46584,52923,52923,52923,52923,52891,50810,29680,33906,50810,42358,50778,52923,52891,52891,52923,52923,52923,52923,52923,52923,52923,54971,54971,54971,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,40278,48697,52923,52923,40213,16970,14857,10631,12712,12776,12776,12711,12744,14857,12711,12744,14824,14857,12711,10598,8485,8485,10566,10566,8485,8486,10566,8485,8485,10566,10566,8485,8485,10566,8485,8485,10566,10566,8485,8486,10566,8485,8485,10566,8485,12744,19050,10631,14824,14857,12679,12744,16970,17002,19050,17002,19082,16970,19083,19115,21195,23276,23309,21228,23308,19050,21195,23308,21163,19083,19082,14857,14792,21163,23308,21163,27534,35986,35986,33938,29679,23276,23276,27534,29679,25421,31727,40211,40179,38099,36018,35953,38066,38131,33873,29614,31727,48663,48663,54970,52857,42292,42291,44404,44372,44404,42324,42324,44372,35920,23308,35954,40212,10631,10630,14857,16970,10598,8517,8485,12743,19083,25422,27567,25454,16969,12679,19083,12711,12711,12776,10566,10566,16937,16969,35986,33938,25486,27566,106},
{57116,57116,57116,57116,57116,57116,57116,57084,55036,55036,55036,55036,57084,57116,59229,61341,63390,63390,61309,61309,61309,61309,61309,63390,63390,63390,63389,61309,61309,63390,63389,63389,63389,63389,63389,63389,63389,63389,63389,63389,63389,63389,61309,61309,61309,61277,59197,59197,59197,59197,59229,59229,59229,59197,59197,59197,59197,57116,57116,54971,55003,52890,50777,52890,52923,52923,52890,52923,46584,27567,35987,40278,23341,44471,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,55003,54971,54971,55003,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,50842,32022,48730,52923,52923,33906,21195,23341,10663,10631,14857,14857,12711,12776,12744,12744,12744,14824,12744,16969,12743,10630,10631,12711,12743,10566,10598,12711,10598,10566,12711,12711,10566,10598,12711,10598,8485,12679,12679,8485,10598,12712,10566,8485,12679,10598,12744,19083,10598,12744,16970,16970,12744,12743,12711,12711,12744,14857,17002,10631,12711,10631,12711,14792,16937,14824,12679,14824,14856,14792,14792,12679,12679,12678,14791,21228,19082,25421,33906,33873,31792,31760,25421,35986,40212,42324,44405,44438,50744,46550,48664,40244,40244,40212,35986,33873,38099,46518,50744,52857,57083,46551,42259,42324,46485,46517,46485,44404,42292,42292,50744,31728,44470,29614,21228,25454,21196,14857,12744,23309,27600,31826,33906,29680,27600,23373,19083,10598,16969,10630,10598,10598,8485,8485,8453,10533,33906,38100,25454,25518,102},
{57116,57116,57116,57116,57116,57116,57116,57116,57084,55036,55036,57084,57116,57084,57149,61309,63390,63390,63390,61309,61309,61309,61309,63390,63390,63390,63390,61309,61309,63390,63389,63390,63390,63390,63389,63389,63389,63389,63389,63389,63389,63357,63389,61309,61309,61277,59197,59197,59197,59197,59197,59229,59229,59229,59197,59196,57116,57116,57116,57116,57116,57084,55036,55003,52923,52891,52890,52890,48664,19115,27567,25454,40245,50842,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,55003,55003,55003,52923,55003,55003,54971,52923,55003,55003,55003,52923,52923,52923,52923,52923,52891,32022,44537,52890,44471,25454,14857,35954,27534,23308,25421,23373,23309,23341,23309,21228,21228,21228,23309,23341,23308,23308,21228,23309,23341,23308,23276,23308,21163,21195,21195,21163,21195,21163,21163,19082,19083,19083,19083,16969,19082,19115,17002,16969,19050,16969,17002,19083,10631,14824,14825,12776,14857,14857,19083,19082,19083,19115,19115,14824,12711,19082,23341,21227,19050,21163,16937,14856,19050,16904,16905,14824,14759,12679,12679,16937,19017,21163,21131,19082,19082,16969,16937,31760,33937,23276,21195,16969,21195,25388,27566,23308,25356,23243,21162,21162,25356,31759,23243,19050,25389,29614,29581,29581,27469,27501,31727,40211,33808,31760,35953,38132,35986,21163,27567,21228,19115,23341,38099,36084,33971,31858,29713,21260,25486,23341,17002,12679,14857,12711,14824,25421,27534,27534,29647,25453,35986,38164,25454,25486,100},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,55036,57084,57116,57116,57116,59229,61309,61342,63390,61309,61309,61309,61309,63389,63390,63390,61310,61309,61309,63390,61309,63389,63390,63390,63390,63390,63390,63390,63389,63389,63389,63389,61309,61309,61309,61277,59197,59197,59196,59197,59197,59229,59196,59197,59197,59197,59197,57148,57116,57116,57084,57084,55003,55003,52923,50810,48729,48729,46584,36018,31793,25454,27567,42358,48697,48729,48729,48697,50778,50810,50778,48729,50777,50778,50810,50777,46584,38131,42325,40245,38099,35986,40180,38132,42326,50777,50777,48697,48697,50777,44504,25716,34037,40310,36018,21195,16970,21228,23308,19115,21163,23341,23309,23341,25422,25422,23309,23308,23341,25421,23341,23341,27567,29680,29680,29680,31728,31728,29615,27566,29647,29615,29615,29647,31728,31728,29648,31760,31793,27534,31792,33873,31728,29647,31760,31793,29647,17002,21196,19115,16970,10598,10565,10566,12776,17034,17002,14857,14792,14857,14824,19017,16969,16969,14856,16905,19082,16937,14792,14791,14791,14792,14792,12679,12678,12679,14856,16937,14792,16937,14824,12711,12711,25453,29679,14856,19018,16904,16937,23276,23308,19050,16936,23275,21162,23210,29581,31759,21130,19049,14823,16936,16903,12710,8485,8484,10565,14824,21163,38099,16937,31760,23308,21195,12678,12711,33874,35954,29648,29680,36051,31825,29712,21260,25454,19115,14889,16970,23341,25453,25453,27566,31793,31760,31792,29712,38099,40244,25453,25486,102},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,55036,57084,57116,57116,57116,59197,59229,61309,61309,61309,61309,61309,61309,63390,63390,63389,61309,61309,61309,61309,61309,63390,63390,63389,63389,63390,63390,63390,63389,63389,63389,63389,61309,61309,61277,61277,59197,59197,57116,57116,59197,59197,59229,59197,59196,57116,57116,57084,55036,55003,52923,52923,50810,50810,50810,46584,48697,48729,44503,44471,40245,27567,33873,42391,48729,48729,48729,46616,48697,48729,48730,46616,48697,48729,50810,48665,44503,42325,46584,42326,27567,29648,29615,31793,35987,46616,46616,44504,44503,48664,40310,25618,12940,14955,17035,19082,19082,17002,12776,10631,12712,21228,23308,23308,23341,25421,23308,21228,23341,23341,27534,31728,31793,33873,31760,31728,29680,29647,29647,29680,31728,31728,29679,29615,29647,29647,29647,29647,31728,27502,29647,29647,27567,27534,21228,27534,25389,29648,25454,16970,16969,14824,14857,16937,19147,21325,17034,16969,14792,12711,19082,19017,12711,12711,12678,16969,21163,23276,14824,10598,12679,12679,14759,12679,12679,10598,10598,12711,12711,16937,14824,12679,14791,19018,23276,25389,19017,19050,16937,23308,27534,16904,14791,23243,23275,21194,25388,33905,38066,33839,19081,16903,16904,12710,10565,10565,8485,8452,31760,29647,12711,16969,21195,27534,16969,12743,14856,16969,27567,31858,36051,31858,29712,19083,23309,19083,14856,10598,23341,27534,27502,25421,29680,31760,31792,31760,35986,40277,25486,25486,100},
{57116,57116,57116,57116,57116,57148,57116,57116,57116,57116,57084,57116,57116,57116,59197,59229,59229,61277,61309,61309,61309,61309,63390,63390,63390,63389,61309,61309,61309,61309,61309,61309,63357,63357,63389,63389,63389,63390,63389,63389,63389,61309,61309,61309,61309,59197,57116,57084,57084,54971,55003,55003,55003,54971,52922,52890,55003,54971,52923,54971,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,50842,52923,50842,50810,52891,52891,50843,50843,52891,52891,50842,50810,50842,48665,35987,35987,31793,23341,27567,29648,33906,31761,38132,35987,40213,50810,50810,48729,48697,50777,42391,31924,29909,36085,31793,21196,23341,23373,21228,14857,17002,16937,12744,12744,14857,14824,12711,12744,12776,12679,12744,16937,21163,23276,23308,21195,21227,23308,23276,21227,23276,23276,21195,21195,23276,21195,21195,23276,23276,19082,21195,21227,21195,19083,19050,19083,17002,21195,14889,14824,12744,14824,12776,14824,12743,12711,12678,12678,12678,12678,14791,14824,12678,10598,12711,14824,21228,25454,12711,14792,16905,14824,12679,12711,14792,12678,10598,12678,10566,10565,10630,12743,14792,16937,21195,29647,19050,21163,16937,19050,21195,21163,27534,31760,35986,38098,40179,44438,42324,38066,23243,12710,12710,12710,10597,10565,10565,16936,31793,19050,14856,14824,23308,27567,25421,19050,16937,19082,27567,31858,33938,31793,29680,12744,14824,12646,10565,8485,19114,27566,27502,27502,31793,31792,31792,31760,35986,40277,25486,25486,102},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57116,57116,59197,59229,59229,61277,61277,61309,61309,61309,61309,61342,63390,63390,63389,63389,61309,63389,61309,61309,61309,61309,63389,63389,63389,63389,63389,63389,63389,61309,61309,59229,52858,52858,52890,52890,52890,52890,44503,48697,54971,55003,55036,57084,57084,57084,57084,57084,57084,57084,57084,57084,55036,55003,55003,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,52923,48664,31728,10631,8486,8518,8518,10598,35987,40245,42358,42358,44439,44471,44471,44471,44471,46551,40245,33972,34004,46584,44471,29680,25454,25486,21228,14889,21196,21228,16937,16970,21228,19050,14857,16970,14857,14824,14857,14824,19082,21195,23276,19115,21195,21228,21163,19082,21195,21195,19082,19082,21163,19082,19050,19082,19114,16969,19082,19082,19050,16969,16937,16937,14857,19082,10565,10565,12711,14824,12711,10598,12678,12711,12711,12711,12711,12711,12743,14856,21163,19050,16937,12711,16905,25421,21163,12711,16905,16937,16937,14791,14791,14792,12679,12679,10598,10598,10566,12743,14824,21196,21196,25454,16905,16937,16937,14791,10565,19082,29614,31760,33873,38066,44405,38099,33873,29679,25421,14855,12710,12678,12678,10598,8517,29647,21195,23308,16937,21195,23308,23341,27567,23276,16937,14824,25454,29712,33906,27600,19083,12711,10598,10598,10565,8453,19082,27566,27534,27534,31825,31792,31792,31792,33905,42390,29679,27534,100},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57149,59229,59229,59229,61277,61277,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,63389,63390,61309,61309,61309,61309,61309,61309,61309,61309,61309,63357,61309,50777,50745,48632,50777,55003,55035,55036,57084,57116,57148,59197,59197,59197,59197,57116,57116,57116,57116,57084,57084,57084,55036,55003,55003,52923,52923,52923,52891,52891,52891,52891,52891,52923,52923,52923,52858,52891,52891,52891,52923,52923,52923,50810,38164,14824,10598,10598,10598,10631,12744,14857,14889,16937,14889,17002,16937,17002,19083,17002,17002,19115,19115,16970,23341,25454,23373,25421,21228,14857,19115,21196,16969,16937,21163,19082,14857,14857,14857,12743,10598,10631,10663,12711,12744,12711,12712,12744,12712,12679,12711,12712,12712,12744,12712,10631,12711,12711,12711,12679,10631,10598,10598,10598,10598,10598,10598,21163,8517,8485,12711,16969,14791,12711,10598,12678,12679,12679,12679,12711,12711,12679,23308,25389,19018,14824,14792,23341,19083,12679,14824,16937,23308,19082,14857,19082,14856,12711,12711,10598,10598,10598,12711,29647,27567,25454,16969,12679,16905,16969,10598,14824,21228,21227,21162,21163,29615,23341,21162,16904,16904,14823,12678,10598,10597,16936,31760,29647,21195,23341,14824,25421,23276,29680,16969,14856,10598,19082,25454,29680,31825,21163,12711,12711,10630,10598,10565,8453,19082,29615,29679,27534,31792,33873,33873,31792,35986,42325,29680,27534,103},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59229,59229,59229,59229,61277,61277,61277,61309,61309,61309,61309,61309,61309,61309,61309,61309,63358,61341,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,55003,57116,59229,59197,59197,57148,57148,57116,57116,59196,59197,59197,59196,57116,57116,57116,57084,57084,57084,57084,55036,55003,55003,55003,52955,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,48697,50810,50842,50842,50842,52891,52923,50810,38132,16905,12679,10598,10598,10599,14857,17002,17002,19083,19082,19083,17002,19083,21196,19115,19115,19082,19050,19083,21196,25486,31793,31825,31793,27599,29680,27599,27534,25454,27534,27534,25421,27566,23308,10566,12711,12711,12711,12711,10631,12711,12711,12712,12711,12679,12711,12711,12711,12744,10631,10631,10631,10631,10598,10566,10598,10566,10566,10598,10566,10566,8518,23276,16969,16872,19017,21195,16937,16969,12678,10630,12679,12711,12711,12711,12743,25421,33873,38132,21195,14791,12743,25454,25421,12711,14792,21195,19082,16969,14856,12711,16905,12678,10598,12678,10598,10566,10598,14792,12711,14856,16937,10631,12679,14792,10631,12743,16937,16969,16937,16937,14857,14856,14791,14856,16904,14823,12743,12678,10630,29614,42357,19147,17002,19082,19115,23308,23309,33873,25453,23308,16969,19114,25421,29680,23309,16937,14824,12679,10598,10598,10565,8485,16969,29647,31792,31792,33873,35953,33905,33905,31792,16937,25454,27534,100},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59197,59197,59229,61309,59229,59229,61277,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,61277,61277,61309,61309,61309,61309,61309,59229,59229,59229,59197,59197,59196,57116,57116,57116,57116,59196,59197,59197,59197,57116,57116,57084,57084,57084,57084,57084,57084,55035,55003,55003,52955,52923,52923,52923,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,50810,38164,14825,10599,10566,8518,10598,12776,16970,16970,17002,17002,17002,17002,17034,19083,19115,19082,17002,19083,17002,17002,27535,40277,38164,36083,38132,36019,33970,36019,36051,33938,36018,36051,48696,40180,12744,23341,10663,8518,8518,10566,10598,8518,10566,10599,10566,10566,10598,10630,8518,10598,10631,10598,8518,10598,10598,8518,10566,10598,10566,8518,10566,10566,21130,27468,25322,29582,19050,14792,16937,12678,12743,12711,12711,12743,12711,14792,33873,44471,33906,27567,16905,12679,25421,19115,14791,16905,31760,29647,19082,14824,19050,12743,12679,10598,12646,10598,10598,10566,8485,8453,10565,10598,8485,8485,10565,10630,10631,10598,10566,10598,10631,10598,10598,10598,14791,14791,10630,10597,12678,16904,44471,40212,27599,25486,21228,19115,33906,25454,27534,25454,14824,14791,19082,25421,27566,23275,19050,14856,12711,12678,10598,10565,8485,19017,29647,31760,33905,31727,27469,25421,25421,25421,14824,25421,27566,102},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59229,59229,59229,59229,61277,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,59229,61277,61277,61309,61309,61309,61277,61277,59229,59229,59197,59196,57116,57116,57116,57116,57116,57116,59196,59196,59196,57116,57116,57116,57084,57084,57084,57084,55036,55036,55004,55003,55003,52955,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,50810,35986,16937,12712,10598,10598,10598,12744,14857,16938,16970,16970,16970,17002,17002,17034,17034,17002,17002,17002,17002,17002,25454,38132,36019,33906,35986,35986,33938,33938,33938,33905,33906,36018,48664,33873,19083,21196,10598,8518,8518,10598,10598,10566,10598,10598,10598,8517,10598,10598,8517,10598,10631,12679,8486,10598,12711,8518,8518,10598,10598,8485,10598,10598,21098,29484,25291,19050,10631,10565,10565,10598,25454,19083,14824,14857,14791,12711,19050,25389,14824,19082,16905,12679,23341,14856,12711,10598,23276,23340,21195,14824,19082,19050,16905,14824,12711,14791,12711,10631,10598,10598,10598,8517,8485,8485,8485,10566,12711,12711,10598,10598,10598,10598,10598,14824,25420,16936,12710,10565,10565,16936,42357,36018,36051,25453,19147,36018,31825,23308,27534,29680,23308,21195,19115,25421,23308,23340,21163,14856,12711,12679,10598,10565,8485,16936,27566,29679,29679,12711,8485,10598,8517,10630,25421,27566,25518,102},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59229,59229,61277,61309,61309,61309,61309,61309,61309,61309,61309,61309,61309,61277,59229,59229,59229,59229,59229,59229,59229,59229,59197,59197,59197,59197,57116,57116,57116,57116,57116,57116,57116,57148,59196,57116,57116,57116,57116,57084,57084,57084,55036,55036,55004,55004,55003,55003,55003,52923,52891,52891,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,48697,42358,42358,38165,29680,25453,12711,10631,10631,10599,10631,12744,16937,16970,17002,16969,17002,17002,17002,19083,17002,19082,17002,17002,17034,17034,17034,21228,21228,21260,23472,23375,23374,29712,31793,29744,36019,25389,23341,29712,23373,14857,10663,10598,8518,10631,10631,10598,10598,12711,10631,10598,10663,10631,10598,10598,12711,12711,8485,10598,12744,10566,8518,10631,10631,8485,10598,14857,27468,27403,25291,14792,10598,8517,8485,12711,19115,16970,14824,14857,12711,12679,12711,19050,19050,16969,12711,10566,14856,12711,10598,12711,16970,23341,23308,23276,14792,16904,19018,21130,14856,16905,14857,14824,14824,12744,12679,10598,10630,10598,8517,8485,10598,10598,10630,10631,10598,10598,10566,19049,31759,21195,14823,14823,12710,19050,36018,33905,31857,27566,25486,38196,31760,29679,25454,25454,21195,16969,21195,25421,21195,23341,21228,19050,14856,12711,10630,10598,8485,16904,29614,29679,27534,10566,10566,12679,10598,10565,29647,27631,27566,102},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59229,61277,61309,61309,61309,61309,61309,61277,61277,61309,61309,61277,59229,59197,59197,59197,59229,59229,59197,59197,59197,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59196,59196,57116,57116,57116,57084,57084,57084,55036,55003,55003,55003,55003,55003,55003,52923,52923,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,50810,46616,46616,44503,36019,25389,12744,10599,10599,10598,10630,16970,19148,21228,23341,23340,23308,21260,21228,21228,21228,21228,21195,19147,19115,19147,19115,19050,17002,17002,21360,21295,17003,31858,29712,23341,36019,19115,12711,29712,27600,14889,14857,10631,10631,12711,14824,10631,10631,14792,12744,10599,12712,12744,10631,10598,14824,14824,8518,10631,14857,10598,8518,12712,12711,8485,10598,14889,25388,25323,25388,21227,14921,12776,10630,21195,14857,12679,12678,10630,12678,12679,12679,12711,10630,10566,10598,10598,12744,21196,25389,21195,16937,19050,21163,19050,14792,16937,16937,16969,14856,14856,14856,14824,14824,14857,12679,10630,10630,10598,10566,10566,10598,8517,10598,10631,10630,10598,10598,25356,23307,16968,14791,14824,14791,27534,31825,31792,23308,19115,40245,40277,29680,29712,29647,21228,12743,12711,23308,23341,25486,25421,23308,19082,16937,12743,12678,10598,8485,14856,29647,29679,33840,23308,16937,16937,14856,14824,27567,27631,27566,102},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57116,57116,57116,57116,57116,57116,57116,59197,59229,59229,61277,61309,61309,61309,61309,61277,61277,61277,61277,59229,59197,59197,59197,59197,59197,59197,59196,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59196,59196,57116,57116,57116,57084,57084,57084,55004,55004,55003,55003,55003,55003,54971,52923,52923,52891,52891,52891,50843,52891,52891,52891,52923,52923,52923,52923,52923,55003,52923,52923,48729,27502,19050,14889,10599,10599,10598,14889,21228,21195,23341,25453,23308,23373,29712,29680,27600,27567,23374,25421,25422,23374,23374,23341,21228,21228,21261,23341,19115,31858,31793,25454,36019,21195,12743,27599,27567,21228,21196,14889,16969,16970,19083,19115,19115,17002,21196,23309,21260,19115,21260,23341,19115,14824,17002,19083,14889,14825,19050,19083,14889,21195,21227,25518,31825,34002,34035,34132,36180,27664,19147,27664,19083,10598,12678,12711,14824,14824,14791,14791,12711,12679,12678,10630,12776,19082,19050,21195,16937,12678,12646,10598,14759,14792,14824,12711,12743,14792,12711,10598,12678,14792,12711,10630,8518,8485,8485,10566,10598,10598,10630,10631,10598,10566,12743,27468,21129,12678,12710,12711,14823,31792,31825,29647,14889,19082,40245,42422,29712,27631,29647,27534,23308,12711,21195,25421,27502,27534,25389,21195,19017,14856,12711,12646,10565,14824,27598,29647,33841,33905,33905,33905,33905,33873,31792,29647,25486,97},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57117,59229,59229,59229,61277,59229,59229,61277,61277,61277,59229,59229,59197,59197,59197,59197,59197,57148,57116,57116,57116,57116,57116,57116,57116,57084,57116,57116,57116,57116,57116,57116,57116,57116,57148,57116,57116,57116,57084,57084,57084,55036,55004,55003,55003,55003,55003,55003,55003,52923,52923,52891,52891,52891,52891,52891,52891,52923,52923,52923,52891,52891,52923,52923,52923,48729,36052,21228,16970,14889,10599,10598,10598,14857,21195,23341,25421,25421,23340,23373,23374,21261,25454,25487,19213,21293,23374,21261,23341,21261,21261,21261,21228,19148,21228,33906,31793,23373,36019,19115,10598,12711,12679,19115,14857,12776,10598,12744,12744,12712,12711,12744,14857,12711,12744,16970,12744,12711,14857,14857,12679,12744,14824,12743,12744,16970,14824,12743,14824,17002,19082,19115,25518,29745,31890,31825,25519,31890,19082,10598,10630,12711,14824,14791,10598,14824,12744,14824,14856,16937,16937,14857,16969,21163,21163,16970,14824,14792,14824,16905,19017,16937,14824,16937,16937,14824,12679,14792,12744,12743,10598,14824,12711,8485,10566,10598,10566,10598,8485,10566,14856,27467,19017,10565,12678,12678,19082,33938,29712,29679,17002,21195,40309,42358,27599,27566,27534,27567,29680,12743,19082,23340,27534,27534,27599,25420,19082,16937,14791,12678,10565,14824,29647,29679,27534,31792,33873,33905,33906,33906,31760,29679,25486,99},
{57116,57116,57116,57116,57116,57116,57084,57116,57116,57116,57084,57116,57116,57116,57116,57116,57116,57116,57116,59197,59229,59229,59229,59229,59229,59229,59229,59229,59229,59197,59197,59197,59196,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,55004,55004,55003,55003,55003,55003,55003,55003,55003,52923,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,44471,27535,16970,14889,10599,10598,10598,14824,21163,27534,27566,29679,29712,29680,14857,10631,12776,14890,12842,12745,14857,10663,12744,10631,10599,10599,10598,8518,10663,31793,31793,23373,36051,21163,10663,12711,10598,21196,19083,21196,12743,16969,21228,12744,12776,19083,19115,10631,14824,14889,12744,12679,14824,14857,10631,12712,14824,12744,12711,12711,12744,10598,12743,14824,12743,8485,14889,19114,10598,8485,10630,21228,21195,12711,14791,12711,14824,14824,16937,16905,14857,12744,19082,23341,21195,23276,23341,25421,23308,21163,19082,17002,21195,23276,23308,25421,23341,23308,21227,23308,21227,19082,12711,14792,16937,16970,14824,10565,8485,8485,8485,8485,8485,8485,14823,16968,10598,8517,10598,12678,25486,36018,29712,25454,14824,23308,44503,40277,25454,27599,29680,29647,33906,14824,19115,23308,23341,33938,25453,21195,25388,21130,16904,12743,10598,14824,29615,31760,27501,31824,33873,33873,31825,31825,31760,29712,27567,105},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59229,61309,61277,59229,61277,61277,59229,59229,59197,59197,59197,59197,59196,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,55036,55004,55003,55003,55003,55003,55003,55003,55003,55003,52923,52891,52891,52891,50843,52891,52891,52891,52923,52923,52891,52891,52891,52923,52923,52923,52923,48729,21195,12712,12776,10598,10598,10598,12776,23308,31760,31760,29680,31792,29712,14889,10663,12776,12842,12843,12777,12777,12744,12744,10631,10599,10631,10599,10598,12711,31826,31793,25454,38132,23308,10631,10663,8485,21195,31792,29712,12744,19115,27534,10631,14889,25454,23309,10631,16970,14889,14824,12711,14890,19083,12744,16969,21195,21228,23341,23276,23308,23341,27534,27566,27534,25421,23276,19082,25421,23340,23340,25454,25421,23308,25421,21162,14856,19050,29647,25421,16969,14824,12744,21195,14824,21163,23308,21163,23340,21227,25389,27566,31792,31792,29680,29680,29679,27502,25454,25454,25421,23276,21195,19082,19050,16970,16937,12679,10565,8485,8485,8485,8453,10565,14823,12743,8485,8452,10565,12743,27534,23308,19082,27567,19082,29712,44471,42358,33873,27599,29680,27567,33906,16937,19114,23308,27534,33906,31826,19050,21162,25421,21195,16904,10598,14856,29647,31727,23340,31792,33905,33873,31825,31792,31760,31793,27566,103},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57149,59229,61277,61309,61309,61277,61277,61309,59229,59229,59197,59197,59197,59196,57148,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57084,57084,55036,55036,55003,55003,55003,55003,55003,55003,55003,55003,55003,52923,52923,52891,50843,50843,52891,52891,52891,52923,52923,52923,52891,52891,52923,52923,52923,52923,50810,38100,16937,14857,10598,10598,10631,23308,33873,33905,33905,33905,33905,33873,14889,10631,12744,12777,12842,10696,12776,10664,10631,10631,10598,12711,10598,8518,12711,33906,31793,23373,31825,25421,10631,12711,10598,14889,19083,14857,10598,12712,14857,8518,10598,12744,12711,8518,14857,14889,12744,12711,21228,19083,21228,27567,31793,31792,33906,29712,33905,27567,27566,29712,31793,31825,27599,19082,31760,31825,33905,33906,33873,31825,31825,31760,16969,25389,36051,23341,16937,14889,16937,23308,21227,25421,27534,23276,25389,27501,31792,33905,33906,33905,27566,29680,31792,25486,25421,27534,25421,21195,21227,23308,19082,16937,17002,14856,10598,10598,12744,12711,10598,10630,10630,12743,12743,12711,10630,16969,16969,21227,17002,42357,25454,33938,42358,46616,31793,23308,27599,27534,33906,14856,23373,23308,25454,33906,31858,29680,21196,19082,19082,16904,12646,14759,27566,31760,25389,29679,33906,33873,33873,33873,29680,33873,27566,102},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,59229,59229,61309,61309,61277,61277,61309,59229,59197,59197,59197,59197,59197,57148,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57084,57084,55036,55004,55003,55003,55003,55003,55003,55003,55003,54971,52923,52923,52891,52891,52891,52891,52891,52891,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52923,52891,36019,27535,10663,12712,19115,50810,50810,50810,50810,50810,50810,50777,19083,10631,12744,12809,12842,10664,12744,10631,19083,21261,21261,21228,19115,19115,19115,31825,31825,25486,33906,25422,14824,16970,10598,10630,12744,12712,8518,10631,12744,8485,14922,14988,12744,10631,12776,14921,12776,12711,14857,14857,10598,12744,14824,16969,17002,19050,21195,19083,23373,25454,25421,27534,23341,25421,36019,33906,33938,36018,36018,36018,36018,33873,16937,25389,38164,21195,16937,29679,31825,33873,31760,25421,29679,23340,14856,27502,27534,31793,31792,33938,29680,29647,31760,29647,23341,25421,25453,21228,21195,17002,14857,14857,16969,14857,10631,10598,10598,10630,12679,10630,12743,31792,33970,36018,31793,16969,23308,21228,21195,42390,27567,33906,40277,46584,40277,29679,27599,25421,33906,14857,21196,25454,25486,33938,33938,31826,31793,23374,19115,19050,14824,21163,25421,33841,27502,29647,33873,33873,33873,33905,31792,31792,27566,105},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59229,61277,61309,61309,61277,61309,59229,59229,59229,59197,59197,59197,57148,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57084,57084,55036,55004,55003,55003,55003,55003,55003,55003,55003,55003,52923,52923,52891,50843,50842,50843,52891,52891,52891,52891,52923,52923,52923,50810,50778,50810,50810,50810,50810,50810,52923,46584,42391,42391,44471,50842,50843,50843,50843,50843,52891,52923,19116,10631,12776,12809,12809,10663,10696,10663,21261,25487,23374,23374,23341,21228,21228,31826,31826,23374,33906,25454,10631,16937,10598,10566,10631,10598,8518,10599,10631,8453,14922,23537,17068,17035,17002,14889,12744,12711,14857,17002,10631,14824,16937,14824,12711,14824,16937,12678,16937,19050,17001,21163,19050,23340,31793,16937,14824,19050,19017,19082,21195,29647,19050,19050,29680,23276,23308,29679,33905,36051,38099,29647,29680,29679,21228,23308,25454,31760,31793,33905,31792,27534,27599,29712,25454,23340,25454,23340,21163,21163,21195,19082,16937,16970,19050,14824,12679,12679,12711,12711,10630,19082,23373,25421,25453,25453,29679,19115,19115,42325,29679,33938,40245,42423,40277,29647,31793,27534,31760,14824,12711,14856,29648,33971,33971,31858,31825,27599,27567,25454,19083,25454,27534,27534,27534,27534,31760,31792,33872,31760,29647,33873,27534,109},
{57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57116,57116,57116,57116,59197,59229,59229,61277,59229,59229,59229,59229,59229,59197,59197,59197,57148,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57084,57116,57116,57116,57116,57116,57084,57084,57084,55004,55003,55003,55003,55003,55003,55003,54971,54971,54971,52923,52923,52891,52891,50842,50842,52891,52891,52891,52891,52923,52923,52923,36019,27567,27567,27600,27600,27632,29680,29712,29713,29713,29746,29746,29713,29745,29745,29745,29745,31826,31858,14890,10663,12744,12809,12842,12810,10697,14889,23373,25486,23373,23374,19147,14857,14857,31858,31825,23341,31793,25454,12744,16970,12744,14857,12744,12776,12744,12744,12744,12744,12711,14889,8550,14889,21196,14824,12744,10631,14824,14889,10631,12744,14856,14824,12711,14792,16937,16937,21163,25421,23308,23340,21163,25389,35986,29647,31728,31760,31792,31760,31792,31760,19050,16969,27502,48664,44438,33905,29647,33937,36018,27534,23276,27534,31760,19050,19018,25389,27567,29647,31760,29647,27599,27599,27534,25421,25421,25421,21228,21195,19115,19115,16969,19018,19083,14824,12744,12711,12711,12743,10630,8517,10565,8485,12711,31857,31792,21195,19147,40277,31825,36051,42390,40277,42390,29680,29712,29615,33873,14856,14792,12743,29680,36052,36052,31826,31825,29680,27600,23374,19115,10630,23276,12711,19082,19050,19017,19049,19050,21163,27534,40212,19082,93},
{57149,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57116,57116,57116,57116,57148,59197,59229,59229,59229,59229,59229,59229,59197,59197,59196,59196,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57084,57084,57084,57084,55003,55004,55003,55003,55003,55003,55003,54971,54971,54971,54971,52923,52891,52891,50843,50842,50842,52891,52891,52891,52923,52923,52956,23341,8518,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10631,10599,10631,10599,10631,10631,12744,10664,10663,12744,12777,12809,12810,12810,14890,23373,25454,23341,23373,21228,19147,19115,33906,36083,29745,36019,25454,12776,17002,14857,16970,14857,14857,14857,14857,12809,14857,14857,14889,8518,14889,25454,19083,21196,21228,19115,19082,21228,21228,17002,21195,21195,21163,19082,21228,21228,21195,16937,21163,21195,25421,31760,21195,21195,23308,25421,25454,25454,33873,21195,19082,29679,50810,50842,46551,27566,35986,36051,33938,25421,23341,25421,21131,12678,19050,21195,23276,21163,21163,19082,21163,19115,17002,19050,19050,19050,16970,14889,14857,14824,14824,14824,12711,12711,10566,10630,12743,12711,10598,10597,8485,16969,40309,25454,17002,19082,38164,31793,33938,44471,42423,42390,27599,25454,23308,36019,21195,29680,25422,27535,33906,33939,31826,31793,27600,27599,27567,21196,10630,23341,12711,12744,12711,10565,10565,10565,12711,25421,44438,29647,107},
{57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,55036,57084,57084,57084,57116,57116,57116,57116,57116,59197,59197,59197,59197,59229,59229,59229,59197,59197,57148,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57084,57084,57084,55036,55036,55004,55003,55003,55003,55003,54971,52923,52923,54971,54971,52923,52923,52891,50842,50842,50842,50842,50843,52891,52891,52891,55004,23341,10599,10631,10631,10631,10631,10631,10631,10631,10631,10599,10599,10631,10599,10599,10631,10599,8550,10663,10631,10663,12777,12841,10697,10631,12777,12809,23374,25454,23373,23341,23341,23373,23341,36051,38132,25486,31858,25454,12711,17002,12744,14824,14857,12776,12776,14825,12776,12776,12744,16970,8518,12744,21229,14889,12776,12744,14824,14857,14824,14856,16969,21163,23276,21195,23308,23308,25389,23341,23276,23309,23308,23308,27566,25421,27567,31760,33841,31793,31793,33938,29615,27534,36019,52890,50777,40245,29647,31825,33873,31760,27567,21195,14856,14791,16937,19050,19082,23275,12744,12712,10631,10598,14856,16905,16937,14824,14824,14792,14824,12679,12679,12679,12711,10566,10565,10565,10598,12711,10630,10630,10597,8485,23373,40342,25486,19114,17002,38164,31793,31793,44503,46616,44503,29744,27599,23341,33938,23308,23309,25421,25486,31793,36051,31858,31826,29713,27599,25454,21196,10598,23341,12744,14824,16970,8485,8485,8485,12678,25389,29615,31760,103},
{57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,55036,55036,55036,55036,57084,57116,57116,57116,57116,57116,57116,59197,59197,59197,59229,59229,59197,57148,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57084,57084,57084,55036,55004,55004,55003,55003,55003,52923,52923,52923,52923,54971,54971,52923,52923,52891,50842,50842,50842,50842,50842,52891,52891,52891,52955,23309,10599,10631,10631,10631,10631,10631,10599,10599,10599,10599,10599,10599,10599,10599,10631,10631,8550,12744,10664,10663,12809,14922,12809,12809,12776,12744,23406,25486,23373,23373,21195,16969,16969,31858,31793,25454,33906,27535,14857,19115,12776,12776,14857,12776,12776,14857,12809,12776,12744,17002,10631,10663,21196,19082,14856,12744,14889,21195,23341,25486,35986,31793,33938,31760,33938,27567,29647,31760,29712,33905,29615,19082,33873,33905,31825,33905,33873,35986,33905,33873,19050,21163,27534,52890,52923,42357,16937,21162,21227,23340,23340,21163,12743,12678,14824,14824,19018,21195,12679,10566,10598,10598,14824,16937,16905,14856,14824,14792,14792,12711,12679,12647,12711,10598,10565,10565,10598,12711,12711,10630,10630,10597,29744,38197,23340,23373,14856,36018,33906,31825,46616,46616,42325,23373,31792,23308,36019,42358,23276,19115,23341,12711,16937,27567,27600,29713,29713,27600,23341,10631,23342,12744,14824,16937,8452,8452,8452,12679,25421,23276,29680,104},
{59196,59196,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,59196,59197,59197,59196,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57084,57084,57084,55036,55003,55004,55003,55003,54971,52923,52923,52923,54971,54971,55003,52923,52923,52891,50842,50842,50842,50842,50842,50843,52891,52891,52955,23309,10599,10631,10631,10599,10631,10631,10631,10631,10631,10599,10599,10599,10599,10599,10631,10631,8518,10664,10664,10663,14889,14922,10664,12744,12777,10663,23341,25454,23373,23373,21228,19082,19082,31857,31825,25454,31793,31761,12744,17003,12744,12776,12744,12744,12776,12744,12776,12776,12744,16970,10598,12743,31760,36051,21228,14857,27534,29745,12776,19083,33905,27566,27534,25454,27567,27534,31792,33906,31793,33873,33873,29615,36051,38099,38131,38132,38132,40244,40212,40212,27534,36019,36018,52922,52922,25421,10630,16905,23276,27534,27534,27567,27566,16937,12743,12711,12711,21163,19050,12744,14824,16969,16905,14824,12744,16937,16937,16904,14792,14824,12711,12679,12646,12679,12678,12711,10630,12710,12775,12711,10598,12711,36083,38196,25453,33906,23341,31793,33938,35986,48697,46584,40245,27566,27567,23308,25454,27599,36019,38132,33906,14792,14791,23308,17002,19083,19115,23309,21196,12711,23341,14824,14824,19083,8452,8452,8452,10598,25421,19115,27567,106},
{59196,59196,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,59197,59197,59196,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57116,57084,57084,57116,57116,57116,57116,57084,57084,57084,57084,55036,55004,55003,55003,54971,52923,52923,52923,55003,55003,55003,54971,52923,52891,50842,50842,50842,50842,50842,50842,52891,52923,52955,23277,10599,10631,10631,10631,10631,10631,10631,10599,10599,10599,10599,10631,10599,10599,10599,10631,8550,10664,10696,10663,14889,14890,10631,10663,12776,10631,23341,29712,31793,23341,21260,27599,27599,33938,31825,23341,23373,29680,12776,17002,10631,12744,12776,12776,12744,12744,12744,12744,12744,17002,10598,14824,21261,25454,16970,12744,17002,17035,10598,12744,16969,10631,12711,16937,16937,12743,14857,21228,16970,12679,19115,27534,25421,14856,12743,14824,14856,14824,14824,14856,19114,19050,29647,55003,42358,10631,12679,12711,19082,23340,23341,23341,25421,16970,12711,12679,12711,16969,17001,16936,16936,21163,16969,19050,16969,21163,27567,27567,23308,21195,25421,16937,16970,29679,21130,12711,17001,17001,12711,12711,10630,19050,38229,33938,29680,31825,25454,29712,38131,36018,46616,46616,38131,23340,25454,25421,21196,21195,27567,19082,12711,16937,16937,23341,19083,16970,14857,12744,10598,12711,21228,14857,12776,17002,12744,12711,12678,12679,23341,21195,27567,103},
{59196,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57116,57116,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59197,59197,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57084,57084,57084,55036,55036,55004,55003,55003,54971,52923,52923,52923,55003,55003,55003,52923,52891,50843,50842,50843,50842,50842,50842,50842,52891,52923,55004,21228,10599,10631,10631,10631,10631,10631,10599,10599,10599,10599,10599,10631,10599,10599,10599,10631,8550,10663,10631,10599,10696,12744,10631,10631,10663,8518,21228,29647,33906,27567,25486,25421,21228,31825,31825,25486,25486,27600,14857,19115,12744,12777,14857,12776,14857,12809,14857,14825,12776,19148,12711,12776,14889,17002,14824,10631,10663,12711,10598,10599,10631,10566,10631,16969,16969,12744,14824,19083,16970,10631,19115,25421,23308,12711,8485,10566,10566,8518,14824,12744,19082,12679,23276,50810,19083,10598,10630,12711,16937,23276,25421,27534,19115,14791,23341,21195,16969,25389,29679,27534,27502,29615,23243,23341,21131,21195,27566,23308,19050,12711,25454,25389,19018,31793,21163,12743,17001,19049,10630,10630,10598,21260,40309,29712,21228,31825,25486,29647,38132,29712,48664,50777,42358,23373,29712,29679,25421,25454,25454,12711,10598,14824,23341,27600,17002,16938,14857,12744,12711,10598,19083,14824,12744,12712,12679,10631,12678,12711,27534,23341,27567,103},
{59197,57148,57116,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59197,59197,57148,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57084,57084,57084,55036,55035,55003,55003,55003,54971,52923,52923,54971,55003,55003,55003,52923,52891,50843,50842,50843,50811,50843,50842,50843,52891,52923,54971,23277,10599,10631,10631,10631,10631,10631,10631,10631,10599,10599,10599,10631,10599,10599,10599,10599,8518,14857,12744,10599,17035,19181,12712,10631,10631,8518,21228,27599,33905,33873,19114,23341,21195,31793,31825,25454,27535,29680,12712,19083,14825,14857,14890,14857,14857,14857,14889,14857,12777,19115,12711,12744,12776,12744,8518,10631,10663,10599,10566,12744,12744,8518,10631,16970,14889,12744,14857,16970,17002,12711,12744,19083,23276,12744,10566,10566,10598,10598,16969,25422,21195,21228,25454,38099,14824,10598,12679,12744,17002,21228,16937,23341,19050,12743,19115,19082,16937,31760,48664,46584,46584,46584,31793,23308,23276,16969,19082,14824,10598,14856,19082,23308,14824,21195,19049,12711,16904,16936,10630,10565,10597,27567,38229,36018,27534,31793,33906,27567,33873,21195,50809,52923,46551,25421,23276,27534,21228,23308,33938,21196,14824,16969,23341,27599,17002,14857,14824,12744,10631,10598,21228,14857,12744,12744,10631,10631,10631,12679,25422,29712,27599,102},
{59197,59196,59196,59196,59196,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59197,57116,57116,59197,59197,59197,57148,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57084,57084,57084,55036,55004,55003,55003,55003,54971,52923,52923,54971,55003,55003,55003,52923,52891,52891,50842,50843,50811,50843,50842,50843,52891,52923,54971,21228,8550,10631,10631,10599,10631,10599,10599,10631,10599,10599,10599,10599,10599,10599,10599,10631,8550,10598,10599,10631,17067,19181,10663,10598,10599,8518,12777,17002,27567,19115,23341,36019,31760,33938,31793,25421,25454,29680,12744,19115,12744,12777,14857,14857,14889,14889,14889,14857,12777,19115,12776,14857,16970,12777,12744,12712,10631,10631,10599,12712,12712,8518,10631,14889,14857,12744,12744,16970,19050,14857,12711,10566,17002,12744,10566,10566,10598,10566,16937,19083,16937,14857,23341,27567,19082,12679,12711,12743,19050,21227,21163,19115,21163,21195,21228,25421,21195,31760,46584,46551,46551,46551,35986,23308,21195,19018,21163,16969,14856,21163,12743,16969,14856,12678,12711,12678,12711,10598,10565,8517,8485,31793,38197,29712,14889,23340,25389,19082,16937,19082,50809,52890,46584,27599,25453,29712,25454,25421,38132,21228,19082,21196,31760,31826,14857,12744,12711,10630,10598,10598,21196,16937,12744,19050,12711,10566,10598,10598,23341,31793,29680,104},
{59197,59197,59197,59197,59196,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59229,59197,59197,59197,59197,59197,59197,57148,57116,57116,57116,57116,57116,57084,57084,57116,57084,57084,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57084,57084,57084,57084,55004,55004,55003,55003,52923,52923,52923,54971,55003,55003,55003,52923,52923,50843,50843,50843,50842,50842,50842,50843,52891,52923,55003,21196,8550,10631,10631,10631,10631,10631,10599,10631,10631,10599,10599,10599,10599,10599,10599,10631,10631,8550,8550,10631,17003,19148,10663,8518,10598,10598,10598,8485,23276,36018,48631,46550,31760,36019,31825,25454,25454,31825,14857,19148,12776,14889,14889,14857,14922,14889,14890,14889,14857,19148,14889,14857,16970,17035,14922,14922,14825,12744,12744,12744,12776,10598,10631,14825,16970,17002,19083,19083,19083,19083,12711,8485,10631,12744,10566,10566,10631,10598,19115,23341,10566,14824,23341,25454,21227,14856,14792,12679,12678,16937,19082,25421,31760,21163,31793,31825,23373,33873,46584,46551,40245,31793,21195,16969,27534,23276,27534,19050,16969,21163,14856,27501,19049,21130,16969,10565,10565,10565,8485,8485,8485,29712,36018,31825,23341,23341,19050,25421,27566,27534,48697,50810,46551,31825,23373,27599,23308,23341,36051,16937,16937,21228,23341,27600,19051,14857,14857,14824,12744,10598,21196,16970,14824,17002,10566,8420,8420,8485,23308,29712,27567,109},
{59197,59197,59197,59197,59197,59196,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59229,59229,59229,59229,59229,59197,59197,59196,57116,57116,57116,57116,57116,57116,57084,57116,57116,57116,57084,57084,57084,57084,57084,57116,57116,57116,57116,57116,57084,57084,55036,55036,55003,55003,55003,55003,52923,52923,52923,55003,55003,55003,55003,54971,52923,52891,50842,50810,50810,50842,50842,50843,52891,52923,44471,17003,10599,10631,10631,10599,10631,10599,10599,10599,10599,10599,10599,10599,10599,10599,10631,10631,10631,10598,10598,10631,19116,21261,10664,10599,10631,10598,10599,10599,12776,44438,29647,12711,10631,29712,33906,25454,25454,38099,12744,19148,12777,14890,14890,14889,16970,14889,14889,14889,14857,21228,14857,14857,14889,14889,14857,14857,14857,12744,12744,14922,12809,10631,10631,14889,17002,17002,17002,19083,19051,14824,10598,10565,10630,12744,10566,10566,10631,10566,16970,19115,10598,10630,23308,25454,23276,21260,23308,19115,16969,14824,14791,25453,33873,23308,29647,27567,23276,29680,46551,33906,21260,19115,19050,14824,27534,23308,23276,31760,27534,21163,14824,29647,19082,21195,16969,10630,8517,8485,8485,8485,12678,31825,27566,25453,23373,23308,25421,42358,29712,29744,46551,48729,48697,33938,23308,29647,25453,23341,36051,14857,14824,21228,31761,36019,19115,21163,19115,19083,17002,10631,19083,16970,12776,19050,10598,8420,8420,8485,21228,29712,21195,111},
{59197,59197,59197,59197,59197,59197,59196,59196,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59229,59229,59229,59229,59197,59197,59197,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57116,57116,57116,57084,57084,57084,55036,55036,55003,55003,55003,52955,54971,52923,52923,54971,55003,55004,55003,54971,52923,50842,50842,50810,50810,50810,50842,50843,52891,52955,29648,16970,10599,10631,10599,10599,10631,10599,10599,10599,10631,10599,10599,10599,10599,10599,10631,10631,10631,10599,10598,10599,12744,14857,10599,8550,10631,10598,10598,10598,8518,8485,8485,8485,8518,31760,33906,25486,23341,23341,17002,25454,14857,14890,17002,14922,17002,17002,17002,14890,14857,19148,14889,14857,14857,14889,12776,12808,14889,12744,12744,19214,19279,14955,14922,14857,14857,12711,12679,16937,19083,12711,10631,10565,10598,12744,10566,10566,10598,10566,12711,12711,8518,12679,14792,27567,27534,17002,23309,25421,29680,29647,27502,27534,31793,19082,12678,10565,23308,29647,36084,29713,25486,23341,21195,14856,23341,25389,19082,35986,33906,27534,23308,25421,23276,21162,16937,10598,10565,8485,8485,8485,14824,36051,36051,27534,21227,19082,44471,46584,27599,29712,40212,50809,50810,38164,23341,29679,25486,23308,36051,14889,14824,21195,14857,21196,21196,21196,19115,19115,17002,10631,19115,19051,12744,17002,14857,12743,10631,10631,19083,31793,19050,108},
{59197,59197,59197,59197,59197,59197,59197,59197,59196,59196,59196,59196,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59229,59229,59229,59229,59229,59197,59196,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57116,57116,57116,57116,57084,57084,57084,55004,55003,55004,55003,55003,54971,52923,54971,54971,55003,55004,55003,54971,52923,50843,50842,50810,50810,50842,50842,50842,52891,52955,27567,16970,10631,10631,10631,10631,10631,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10631,10598,10598,10631,10663,10663,10598,8550,10631,10598,10598,10598,8518,8518,8518,8518,8518,31793,33906,23373,23374,21228,19148,21261,14889,17035,17035,17035,17035,17002,17002,16970,14889,19148,14857,14857,14824,14857,12809,12776,12776,12744,12744,14857,14922,10631,14824,19115,14857,12744,12711,14857,17002,12711,10631,10566,10598,12711,10566,10566,12711,23341,27534,25421,14824,14792,12711,12711,12679,10598,14824,16970,29647,31792,29647,27567,31825,19115,10598,8420,21163,33938,36084,33939,29680,25487,21228,23309,31825,27534,21227,27566,23276,23308,21162,16969,23308,16937,14791,10598,10565,10565,8517,8485,16969,27631,25454,36019,29615,23308,50809,44438,19115,25421,33873,46584,48664,40277,25453,25486,23341,19115,36019,19115,12711,21228,29648,31760,19115,21196,19147,19115,17002,10598,19082,19115,14824,14824,12711,12711,12711,12679,21196,31793,17002,109},
{59197,59197,59229,59197,59197,59197,59197,59197,59197,59197,59197,59196,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59197,59197,59229,59229,59229,59229,59197,59196,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57084,57084,57116,57116,57116,57084,57084,57084,55036,55004,55003,55003,55003,55003,54971,54971,54971,55003,55003,55003,55003,52923,52891,52891,50843,50810,50810,50842,50842,50843,52891,52923,27567,16970,10599,10631,10631,10599,10631,10631,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,8518,10598,10631,12744,12744,10599,10599,10631,10599,10598,8518,8518,10566,8518,8518,8518,31793,40245,31826,29680,25487,23341,19115,17002,19115,19083,19083,19083,19083,17003,17003,16970,19147,14922,14922,14889,14889,14890,14857,14857,14857,14857,14889,12776,8485,10598,17035,14889,12776,12744,19115,17002,14857,12743,10566,10630,12743,10598,10598,12711,27534,33906,25486,14824,14824,17002,10598,8485,8485,10565,14792,27534,29679,27534,27566,31793,21163,10598,8485,25422,42358,36084,33906,27632,27567,23309,25454,33938,25454,25389,19082,10533,10565,8485,14791,23276,16937,14824,12678,10566,8517,8517,8485,23308,31825,27599,36051,29647,23308,48697,44438,21195,27598,33905,44470,46616,46583,31792,27599,25486,21195,35986,19083,19050,23341,16969,23341,21228,21196,21196,19115,19083,12711,19083,19115,14825,14824,10598,10598,10630,10630,19082,36051,35987,124},
{59229,59229,59229,59229,59229,59197,59197,59197,59197,59197,59197,59197,59196,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,59196,59197,59229,59229,59229,59229,59197,59196,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57116,57116,57116,57116,57084,57084,55036,55035,55003,55003,55003,55003,55003,54971,54971,55003,55003,55003,55003,55003,52923,52891,52891,50842,50810,50810,50842,50843,50843,50843,52923,27535,14890,10599,10631,10631,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10631,10631,10598,8550,10599,10631,10631,10599,10598,10599,10598,10598,8518,8518,8518,8518,8518,8518,35986,44471,40245,42325,40245,35986,42358,36019,36051,38099,36019,36019,33938,33906,31825,25519,29713,23374,23374,23374,23341,21261,21261,21228,21228,19115,19148,21261,8485,12744,19115,14857,14825,12744,19083,14825,16937,19050,16905,16937,23276,21163,19082,21195,23308,31793,21163,10598,10598,12743,8453,8452,8485,10598,14824,25421,27566,25453,27534,31825,27567,23276,21227,27567,40278,38165,36084,29745,27632,23341,19082,23341,25421,21195,31792,27534,25421,16969,23276,25389,21130,21195,12678,10598,10565,8485,8485,31760,42325,40277,40245,29679,21227,46551,48697,29679,29712,31792,46583,50777,48729,29679,25454,33906,27534,33874,19082,25454,21228,16970,23309,21196,19115,19115,19083,17002,12711,16970,19050,14824,17002,12744,10598,10630,10598,16937,33906,29615,128},
{59229,59229,59229,59229,59229,59197,59197,59197,59197,59197,59197,59197,59197,59197,57148,57148,57116,57116,57116,57116,57116,57116,57116,57148,59229,59229,59229,59229,59229,59197,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57116,57116,57116,57116,57116,57116,57084,57084,55035,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,52923,52891,52891,50842,50810,50810,50810,50843,50842,50842,50843,52891,25455,14857,10599,10631,10631,10631,10631,10599,10599,10599,10599,10599,10599,10599,10598,10598,10599,10631,10631,10598,8550,10599,10631,10631,10599,10599,10631,10598,8518,8518,8518,8518,8518,8518,8518,38131,44470,40277,44503,48729,48664,48664,44438,44503,44471,44438,42390,40277,40277,38164,29713,33971,27600,29745,29745,27664,27600,25519,25519,25454,23374,23406,21261,8485,19083,19083,14857,12744,12711,12744,14857,14857,16937,14824,14824,23276,16969,23276,25421,21228,25454,10598,10533,21195,29679,29615,27566,29614,29615,29647,31760,31792,31760,29679,33905,27534,25389,23308,25454,38165,40277,40245,33971,29745,25486,17002,21163,27534,21195,38099,38164,27566,14824,31727,27566,21163,27502,16936,10597,10597,8517,8485,27567,31825,29712,40244,33906,23308,46551,52923,29680,29679,29680,42358,50778,50842,31792,29647,31793,25421,29680,25454,23308,12743,12679,23341,25422,21163,19083,19051,19050,12712,17002,19115,14824,16970,12743,8420,8452,8452,16970,31793,16969,125},
{59229,59229,59229,59229,59229,59197,59197,59229,59229,59197,59197,59197,59197,59197,59197,59197,59196,59196,57116,57116,57116,57116,57148,59196,59229,61277,61277,59229,59229,59197,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57084,57116,57116,57116,57116,57116,57116,57084,55036,55003,55004,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,52923,52891,52891,50842,50810,50810,50810,50811,50842,50842,50842,50843,23341,12744,10599,10631,10631,10631,10631,10599,10599,10599,10599,10599,10599,10599,10599,10598,10599,10631,10631,10631,10631,10631,14922,17035,10663,12712,12776,10599,10599,10598,8518,10566,10598,8518,8518,16970,31793,40277,46616,50810,46551,48697,40245,42390,44438,42390,42357,40277,40310,38164,29712,38164,25454,25519,25552,23374,21261,21261,21293,21228,19083,23374,19148,8453,16970,19083,14857,12711,10631,14824,14857,14824,14856,14824,19018,21195,16969,21195,25454,21195,14824,8485,10598,25454,36018,38131,40212,38164,38131,38164,31792,36018,38099,38099,35986,23308,38131,38132,31825,38100,40310,38197,36051,31858,27599,21228,25421,31792,23340,40244,38099,27566,14791,33841,31728,21195,29679,19082,10598,10565,10565,8485,29680,33873,29679,38164,33938,25421,48664,55035,33873,29679,29679,38131,50777,50810,33938,25421,29712,21195,31760,31760,12711,14889,10631,19115,21228,16937,14857,14824,12744,10598,19115,21196,12744,16937,12744,6372,8452,8453,16937,31760,19017,120},
{59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59197,59197,59197,59197,59197,59197,59197,59197,59196,59164,57148,59196,59197,59229,61277,61277,59229,59229,59197,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,57116,57116,57116,57116,57116,57116,57084,57084,55003,55004,55003,55003,55003,55003,55003,55003,55003,55003,55003,54971,52923,52891,50843,50842,50810,50810,50810,50811,50843,50842,50842,50842,21196,10631,10631,10631,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10631,10631,10631,10663,10631,12744,12776,10631,10631,10664,10631,10598,10598,8518,10566,10598,8518,8518,8485,8485,12711,16970,21196,19050,21196,21228,29680,29680,29712,29712,31793,29712,29680,27666,25487,21261,25422,23341,12744,10598,12711,16970,10663,8518,14889,14857,8453,14857,17002,14824,14856,12776,14857,14857,14824,19082,16937,21163,21195,19050,19082,27534,25421,21195,14791,19083,27534,35986,36018,38099,38131,38131,33873,27566,36018,38099,38131,38099,21195,38099,38132,36019,33906,44471,42390,38164,33971,31793,25454,21163,31760,29679,29647,12678,10598,8517,23275,31727,21195,29614,16969,10598,10565,10565,8485,31792,46616,38131,38164,36051,21260,38132,52923,40212,33938,29647,33938,48729,50777,38099,21227,33938,21195,29680,29712,17002,16970,14857,25454,23309,17002,16969,16937,14857,10598,19115,21196,12744,16970,17002,10598,10598,10598,14856,27534,19050,121},
{59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59197,59197,59197,59197,59197,59197,59197,59197,59197,59196,59197,61277,61277,61277,61277,59229,59196,59196,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,55003,52923,52923,52891,50842,50842,50810,50810,50810,50810,50843,50843,50843,50843,23374,14857,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10631,10599,10598,10599,10599,10599,10631,10599,10599,10599,10631,8518,8518,8518,8518,8518,8518,8518,8518,8518,8485,8485,8453,8453,6405,8485,8486,8485,8518,8518,8518,8486,10598,19279,12777,10663,16938,21228,10663,10566,10598,14889,10631,8517,12776,14856,8485,14857,19083,16937,21196,21195,19083,19083,21228,21196,19082,23276,21163,21163,19050,25486,33938,29712,29647,27535,23276,33905,36050,38099,38131,38099,36018,31760,33937,38099,38131,38131,21195,36019,38132,33938,31825,44471,44503,42390,40277,35986,25454,27566,33905,27534,36018,25421,25453,21162,16969,29679,19082,12678,12678,10566,10565,10565,8485,31792,46616,38163,38164,36051,21260,36018,48664,42390,42390,35986,31760,50842,50810,27567,21228,31760,23308,27567,36018,29712,19083,12711,23309,23341,19051,17002,16970,14889,10630,19115,21228,14824,14857,12776,12744,12711,12711,14792,25454,19018,110},
{61277,61277,59229,61277,61277,59229,59229,59229,59229,59229,59229,59229,59229,59229,59229,59197,59197,59197,59197,59197,59197,59197,59197,59229,61277,61277,61277,59229,59197,59197,59196,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,55003,55004,55003,55003,55003,55003,55003,55003,55003,55003,54971,52923,52891,52891,50842,50810,50810,50810,50810,50810,50810,50843,50843,50843,25487,14890,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10598,8518,10599,10631,10696,14857,10631,10598,10598,8550,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8486,8485,8485,8518,8485,8485,8485,8486,8485,8485,8485,8485,8453,12776,21228,12744,10631,10631,14890,12711,10598,10663,12776,8517,14824,19147,14824,12743,10631,12744,16937,10631,12744,12776,14824,12711,29680,25454,23309,27534,25421,33938,36019,27502,33873,38099,38099,38131,38099,36018,31759,35986,36018,36051,36018,21195,36018,38131,31825,25421,38099,40245,40245,38164,33906,25421,33873,35986,27502,46551,42357,29679,23340,19050,29647,21162,23275,12711,10565,10565,10565,10565,33873,46551,38099,38131,38099,21228,36019,42292,40179,25421,16904,21130,50777,50842,29647,31793,33938,27534,27567,38197,36051,29647,12743,19083,23276,19050,17002,16970,14889,10631,19082,21228,12744,12744,12711,12679,12679,12711,14791,29680,19082,119},
{61277,61277,61277,61277,61277,61277,61277,59229,59229,59229,61277,61277,61277,59229,59229,59229,59229,59229,59197,59197,59197,59197,59229,61277,61277,61277,61277,59229,59197,59197,59196,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,55003,55004,55003,55004,55003,55003,55003,55003,55003,55003,54971,52923,52891,50842,50842,50810,50810,50810,50810,50810,50810,50843,50843,50843,23341,14857,10599,10631,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10631,10631,10566,10599,10631,12744,12777,10631,10599,8550,8550,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8485,8518,10631,8518,8485,8485,8486,8486,8485,8486,8485,8485,8485,14856,23309,12744,10631,12711,16970,12776,10631,12743,14889,10598,12711,21260,14857,14856,10631,14824,17002,12711,14857,14857,12744,12711,33938,27567,27599,27567,25454,31793,38164,29679,31793,36018,38099,38099,38131,33873,29679,35986,38099,38099,38099,21196,36018,36019,31760,23308,31825,36019,36051,31793,29615,29679,40212,35986,33873,31792,16969,21163,21195,29679,25388,19049,27534,12711,10565,8485,10565,10598,35986,48664,36051,38131,38131,19148,25486,29647,19050,12711,14824,19082,48696,50842,29712,25421,38132,27599,25454,40277,38164,23308,19050,29647,25389,19083,19115,17002,16970,12711,19050,23309,10631,12744,10631,10630,10631,12711,14792,29647,19082,122},
{61277,61277,61277,61277,61277,59229,61277,61277,61277,61277,61277,61277,61277,61277,59229,59229,59229,59229,59197,59197,59229,59229,59229,61309,61309,61277,61277,59229,59197,59197,59197,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,55035,55003,55003,55003,55003,55003,55003,55003,55003,55003,54971,52923,52891,50842,50810,50810,50810,50810,50810,50810,50842,50842,50843,46617,31793,14889,10599,10631,10599,10599,10599,10599,10599,10599,10599,10598,10599,10599,10599,10598,10599,10631,10631,10598,10598,10631,8550,10598,10599,10631,10599,10598,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8485,8518,12712,10598,8485,8485,8485,8485,8485,8485,8486,8485,8485,14824,21260,12776,10631,12711,14890,14856,12744,12744,14889,10598,12679,23309,14857,14857,12712,14824,16938,12711,16970,14824,12711,16937,31858,25454,25487,25487,25487,29680,33938,29679,33905,38099,38131,38131,38099,29679,31760,33937,38099,38099,38131,23276,33906,38099,33873,25421,36018,38164,40212,31792,33841,40212,40244,29679,36019,16969,21163,14856,12710,29679,25388,19082,29647,14856,10565,10565,10565,12678,35986,48664,38131,40212,40212,21228,23406,25487,21228,19082,16969,23341,44503,52922,40212,23341,33906,27599,25421,40245,38099,23308,21163,21163,23309,19083,19083,19050,19050,12711,19050,25422,12744,14889,16970,10566,10598,10630,12743,29615,19082,119},
{61277,61277,61277,61277,61277,59229,61277,61277,61277,61277,61277,61277,61277,61277,61277,59229,59229,59229,59229,59229,59229,59229,61277,61309,61309,61277,61277,59229,59197,59197,59196,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,55036,55004,55004,55003,55003,55003,55003,55003,55003,55003,55003,52923,52891,50842,50842,50810,50810,50810,48762,50810,50842,50842,50843,48762,48730,14889,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10599,10598,10599,10631,10599,10598,10598,10631,10599,10598,8518,10598,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8485,8485,10598,10598,8485,8485,8485,8485,8485,8485,8485,8485,8485,12744,21196,12776,10598,12711,14890,14857,12744,12744,14889,10631,12711,19083,14889,14889,12744,14824,19083,12743,14889,14857,14857,10598,14857,19115,27535,23406,25454,23341,31825,29712,33873,38131,38131,38131,33905,27566,27599,35986,38131,36018,38099,23276,33905,38164,35986,27534,40244,44471,44471,38131,29680,42325,40245,23276,23308,25421,23308,23275,25388,36018,29647,23276,38131,25421,16969,14823,12678,12710,33905,38131,38099,40212,40244,21228,23341,27567,23341,23308,23308,23308,38131,48697,36019,21228,36051,29712,25389,40212,38132,27567,16969,23276,25422,19083,19082,17002,16970,12679,16937,23309,14824,14889,19083,8452,8453,8453,12679,29647,21163,112},
{61277,61277,61277,61277,61277,61277,61277,61277,61277,61277,61277,61277,61277,61277,61277,61277,61277,61277,59229,59229,59229,61277,61277,61309,61309,61309,61277,59229,59197,59197,59196,57116,57116,57116,57116,57116,57116,57148,57148,57116,59196,59196,57116,57116,57116,57116,57116,57116,57116,57116,57116,57084,57084,55004,55004,55003,55003,55003,55003,55003,55003,55003,54971,54971,52923,52923,50843,50842,50810,50810,48762,48762,50810,50842,50842,50843,52891,48730,14857,10599,10599,10599,10599,10631,10599,10599,10599,10599,10599,10599,10599,10598,10598,10599,10599,8518,8518,10598,10631,10664,12712,10599,10599,10598,10598,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8518,8486,8485,8485,10598,8517,8486,8486,8485,8518,8518,8485,8485,8485,12711,21196,14857,10631,10631,16970,12776,12711,12744,16937,12711,14857,16970,21196,14857,12711,12711,16970,10630,12711,14824,14856,10598,10598,14889,23374,25487,25487,25421,31825,31760,33905,38131,38131,36051,33905,27534,23308,31792,36018,35986,35986,21163,31760,33938,33938,31825,29712,27566,14824,16937,23275,35986,33872,16969,25420,31727,25388,19082,19082,29647,35986,27534,31728,33841,29679,19017,14791,14791,33938,35986,36051,38131,40244,29680,27567,31825,25454,29712,29712,25486,31792,40244,36051,25486,38131,33905,23308,38099,33873,29680,16937,16970,25454,19115,19115,19083,19083,14792,16937,23309,14825,16905,16970,12744,12744,12711,12711,27567,23276,110}
};

const uint16_t Minneapolis PROGMEM [320][241] = {
{36281,36281,34201,36281,34233,36281,36281,34233,36281,36281,36313,38329,38361,38361,38361,38361,38329,38361,38361,38361,38361,38393,38361,38361,38361,40409,38361,40409,40409,40409,40409,40441,40441,42489,40441,42490,42490,42489,42489,42489,42489,44537,44537,44537,44569,44569,44537,46618,44537,44537,46618,44537,46618,44537,44537,44570,46618,44537,44537,44569,44537,44569,44569,44569,44537,44537,44537,42489,42489,42457,42457,42457,42457,40408,40409,40376,40409,36149,33970,33938,31858,31826,36052,34004,29810,29810,27697,27665,27664,23471,25584,25584,15052,15116,21390,10858,19277,10858,12971,33938,17132,4551,19277,6632,10890,10890,2406,27664,23471,325,15083,10858,6632,17197,325,19245,34003,4519,6632,19277,4389,19277,10792,44406,54874,52826,40211,42293,46518,38131,44405,38131,46519,44405,40179,48599,33872,44405,44339,44338,44338,46419,50678,44338,42290,46484,19178,14920,17098,8647,6502,17034,27566,29679,23373,14921,10662,10727,10727,8582,6437,4323,4356,4356,6501,6502,10726,8612,4451,6499,8547,8514,6467,6435,8547,8612,10660,6435,65,2113,2113,33,33,65,65,65,33,65,33,33,33,2113,65,2113,65,33,65,66,65,66,65,98,98,66,65,2146,65,65,33,0,66,2211,14952,19145,19178,21259,21258,19178,19178,19178,19210,31624,46085,23371,21291,19178,19146,17033,14985,17033,17065,14953,14952,12872,12872,14953,14953,14985,14952,14953,58},
{34233,34233,36281,36281,36281,34233,36281,36281,34233,36281,36281,38361,38361,38361,38329,38361,38329,38361,38361,38361,38361,38361,40442,40409,38361,38361,38361,40409,40409,40441,40409,40409,40409,40409,42489,42489,42489,42489,42489,42489,44537,44538,44537,44569,44569,46618,46618,46618,46618,46618,46618,46650,46618,44537,44570,44537,44570,44570,44570,44537,44537,44537,44537,44569,44570,44537,44569,44569,42489,42457,42457,40409,40409,42457,40377,40409,40409,38230,15083,195,98,98,21293,27729,390,8810,13003,2471,17196,358,12971,38164,6664,6664,23503,2438,19342,8777,6664,40277,21358,358,25616,8713,15051,19309,2341,31858,33971,2374,17229,17164,6632,23535,2438,19277,42358,8680,8712,23503,4422,21358,15018,46519,54906,52825,40179,42292,46486,40211,42325,40179,48631,44405,40179,44438,38065,38098,42290,31725,33839,40146,42259,33838,27532,27533,10694,17033,23372,19179,12840,21227,23372,23405,21227,19114,17033,17066,17066,14921,6469,2211,2211,4388,12873,14953,14919,6531,6531,8579,6467,8547,8547,6434,8579,8579,10660,6468,65,2113,2113,65,33,33,65,33,65,65,33,65,65,2113,65,2113,33,65,33,33,65,66,66,66,66,65,65,2114,66,65,33,0,33,4324,17065,19146,17065,19178,19210,21258,19146,19178,21259,37799,41959,21291,21291,19178,19146,17033,14985,14953,14953,14953,14952,12840,12872,14953,12872,14953,14953,14953,60},
{34233,34233,36281,34233,34233,36281,34233,34233,34233,36281,36281,38329,38393,38361,38361,38329,38329,38361,38361,38329,38361,38361,38361,38361,38361,38361,38361,40409,40409,40409,40409,40441,40441,40409,42489,42489,42457,42489,42489,42489,44537,44538,44537,44569,46618,46618,44570,44537,46618,44570,46618,46618,44537,46618,44570,44537,44537,44537,44537,44569,44537,44570,44570,44537,44537,44569,44537,42489,44537,42489,42489,42489,40409,40409,40409,40409,40376,38295,21390,4389,33,1,21293,40277,4552,12971,21422,2503,23503,4584,12971,42358,12971,6632,25616,4519,19277,12971,2471,38164,25551,293,21422,8777,10858,21390,293,27632,36083,2373,15084,19277,4519,25583,2406,17132,42358,8745,6599,23535,4454,17164,21292,50713,54906,50713,42292,46486,46519,44405,46518,44405,48631,42324,31824,25421,6404,6404,14888,10630,10694,14953,23436,42259,40145,40113,23372,10760,17034,14920,14920,23340,29711,27598,19179,19146,19146,14953,8614,6469,4389,4356,4356,4421,6534,6469,10757,8612,8611,6467,6467,8547,6467,6435,8547,8547,8547,6468,2113,2113,2113,33,65,65,65,65,65,2113,2113,65,65,65,65,65,65,33,33,65,33,65,65,66,98,66,2146,2146,65,65,0,0,33,6436,17097,17097,17097,19178,19178,21258,19178,19178,21258,41925,35784,21324,21259,19146,17065,17065,14953,14953,14952,14953,14953,12872,14953,12872,14953,14920,14953,14953,61},
{34233,34233,34200,34200,34233,36281,36281,36281,36281,36281,36281,38361,38361,38361,38393,38393,38329,38329,38361,38361,38361,38329,38361,38361,38361,40409,40409,38361,40409,40409,40441,40409,40409,40409,42489,42489,42489,42489,42489,42489,42489,44570,44569,44537,44569,44569,46618,44537,46618,44570,44570,46618,44570,46618,46618,44570,44570,44537,44537,44537,44537,44537,44569,44537,44537,42489,42489,44537,42489,42489,42457,40408,40376,40408,40409,40376,40376,40344,23503,10695,14791,19049,31727,42325,12938,17131,27664,10825,27631,15051,19212,44406,23406,10825,29777,14986,25518,23438,15019,40245,33971,15018,29777,25486,23406,31825,17099,33938,42358,21292,29712,33906,23405,33970,23406,29712,44438,27631,25518,33938,27567,31825,33905,48631,50713,48567,40178,38131,40179,40211,40244,36018,25453,17034,14920,12840,17098,19179,17098,14985,23437,23437,27663,50712,48598,40178,17033,14888,21259,21227,19211,29679,33905,31792,25485,10695,6469,6436,6469,6469,4324,4356,2243,4421,6534,6469,12870,6531,8579,8579,6499,8579,6499,6467,8580,8515,10628,8548,65,2113,2113,65,33,33,65,33,33,33,33,65,65,2113,65,65,65,65,33,33,65,66,2146,65,65,65,2146,66,66,65,0,0,65,8581,19146,19145,19178,19210,19178,19178,19178,21259,23338,46085,31658,21291,19178,17098,17065,17033,14985,14953,14952,14953,12872,12872,14952,14953,14985,14952,14952,14953,59},
{36281,34233,34232,36281,36281,36281,36313,36281,36313,36313,36280,36281,38361,38361,38361,38361,38361,38361,38361,38361,38361,38329,38361,38361,38361,38329,38361,40409,40409,40409,40441,40441,40409,40441,42490,42489,42457,42490,42489,42489,42489,44570,44569,44569,44569,44570,44537,44570,46650,44537,44570,46618,46618,46618,46618,46618,44537,44537,44570,44570,44569,44537,44537,44537,44537,44537,42489,42457,42489,42489,42457,40408,40376,40409,40409,40409,40376,40376,33970,40212,46519,46551,44471,42390,38197,38197,38165,38132,38132,36051,38164,36084,29777,25551,31825,27632,27664,27697,25584,34003,36051,23503,25584,23471,21358,25551,19180,23471,31858,19213,19213,21390,14986,21358,15019,15019,31890,17164,10858,21390,10793,15051,23438,48631,52793,48599,36018,38130,38098,25485,19146,12840,17065,23405,25517,25582,25582,25550,23469,27631,25550,23469,27695,48631,40211,33904,29678,12808,14920,12808,8614,12808,21292,21260,17098,8614,6437,6469,6501,6501,6437,4389,2276,4389,6534,6501,10725,8611,8579,4354,6499,6499,6467,8548,8547,8547,10692,8549,2114,33,65,33,33,65,33,33,33,33,65,65,65,65,2113,2113,65,65,33,65,33,65,66,66,65,65,65,65,2114,33,0,33,66,10727,19145,19145,19178,21258,21258,19178,19178,21259,27465,48133,27499,19211,19146,17066,17066,17033,14985,14985,14953,14952,12872,14952,12872,14985,14952,14953,14952,14985,56},
{34233,34233,36281,36313,34201,36281,36281,36281,34233,36281,36281,36281,36281,38329,38361,38361,38361,38361,38329,38361,38361,38361,38361,38361,38361,38361,38361,40409,40441,40409,40441,40409,40409,42489,42522,42489,42489,42489,42489,42521,44538,44570,44569,44570,44537,44569,44570,44570,46650,46618,46618,46618,46618,46618,46618,46618,44537,44537,44537,44537,44537,44537,44537,44537,44537,42489,42489,42489,42457,42457,42457,42457,40409,40409,40409,40409,40376,40441,27762,10825,4389,2309,8615,27696,12971,2504,15084,4584,10890,10858,4519,25551,21357,293,19309,8745,10858,19309,2503,27664,34003,2503,13003,15084,4519,23503,2406,15051,40309,8712,6632,21390,2373,19309,6632,6632,40245,17132,293,23503,6567,15018,33904,50712,52793,48599,42292,44405,46518,46518,36083,25550,25550,25582,25582,25518,25550,23470,25550,27631,25550,23437,25583,46518,40145,31791,25452,12840,21292,21292,10792,19179,29744,23373,8614,4388,4389,4389,6501,4324,4324,2243,2211,4356,6469,4356,10692,10692,8547,4354,6531,8579,6467,8547,8547,8547,8548,8516,2113,2113,2113,33,33,65,65,33,33,65,33,33,65,2113,33,2113,65,65,65,65,65,33,66,98,98,65,65,65,66,33,0,33,2146,14888,17097,17097,19178,21258,21258,19178,19178,21259,33672,44038,23372,19210,19146,17065,17066,17033,14953,14952,14985,14985,14952,14952,14920,14985,14953,14952,14952,14985,57},
{34233,34233,36281,36281,34200,34201,36281,36281,34233,36281,36281,36281,38361,38361,38329,38361,38393,38361,38361,38361,38361,38361,38361,38361,38361,38361,40409,38361,40409,40409,40409,40441,40409,42489,42489,42522,42489,42489,42489,42489,44570,44570,44537,44569,44569,44570,46618,46618,46618,46618,46618,46618,44537,44570,46618,46618,44537,44570,44537,44537,44570,44569,44537,42489,42489,42457,42489,42489,42489,42457,42457,40409,40409,40409,40409,40376,40377,40409,29842,10825,66,1,4357,40245,21358,390,23503,6664,15084,17229,2439,33971,31858,326,19310,13003,8777,21423,423,25584,38196,4584,12971,19277,4487,25616,4551,12938,40309,10825,4551,23503,2438,19277,8777,4519,38164,21325,2373,23470,10760,14986,38097,50712,50745,46486,36018,38131,42292,46518,36116,25582,25550,25550,25582,25550,25550,23470,23470,25550,23470,23437,25615,48598,48598,42258,33872,10759,10727,12840,8582,8647,17066,17066,8615,4421,4389,4389,6469,4389,4356,4356,4356,4421,6534,6469,10757,10724,8579,8579,8611,8547,6467,8547,10595,8547,6467,10629,2146,2114,65,65,33,33,65,2113,33,65,65,33,65,2113,33,33,33,33,33,33,33,33,65,65,65,2146,65,65,65,33,0,33,2211,14952,19145,19145,19178,21258,21258,21258,19178,21259,39878,39911,21324,19178,19146,17065,17065,17033,14953,14953,12872,14953,12872,14920,14920,14952,14985,14953,14953,14953,60},
{34233,34233,36281,36281,34233,34201,34201,36281,36281,34233,36281,36313,38361,38361,38361,38361,38361,38361,38361,38361,38361,38361,38361,38361,38361,38361,40409,38361,40441,40441,40441,40441,40441,42489,42490,42489,42489,42489,42489,42489,44537,44537,44537,44537,44537,44570,46618,44570,44537,46618,46618,46618,46618,44570,44537,44537,46618,44537,44537,44570,44537,44537,44569,44537,44537,44537,42457,42489,42489,42457,42457,42489,40408,40441,40376,40376,40376,40441,34036,12970,2178,6372,10598,38099,27664,2438,21390,10857,15051,21390,4519,31858,33971,4454,19277,17196,8745,25583,6632,23470,42357,10825,15019,23503,8680,27696,12906,17067,44438,21292,12873,29744,12873,25519,21325,19212,31823,33871,31757,33871,33838,31758,36018,50712,50713,44405,35985,40211,38131,40212,38196,25550,25582,25582,25550,25550,25582,25582,25583,25550,25550,23437,25615,48598,48566,48598,40178,14953,17098,19244,12905,17099,31793,31825,17131,2340,4389,2308,2309,2244,2211,2243,2243,4389,6566,6469,10757,10724,8579,8611,8547,8547,6435,10660,8515,8515,8547,10629,2113,2113,2113,2080,33,65,65,33,33,65,65,65,33,65,2113,65,33,65,33,66,65,33,65,65,33,2114,65,65,65,33,0,33,4323,17065,17065,19145,19178,21259,21259,21258,19178,21258,44005,35753,21324,19178,19146,17065,17065,14985,14921,14953,14953,12872,14952,14952,14952,14985,14952,14952,14985,14952,59},
{34200,34233,34200,36281,36281,36281,34233,34233,36281,36281,36281,36281,38361,38361,38329,38361,38361,38361,38361,38361,38361,38361,38361,40442,38361,38329,40409,38361,38361,40442,40409,40409,40409,40409,42489,42457,42489,42489,42489,42489,44569,44537,44537,44537,44537,44570,46618,44570,46618,46618,44537,46618,46618,46618,44570,44537,46618,44570,46618,44537,44537,44537,44537,44537,42489,42489,42457,42457,42457,42457,40409,42489,40409,40409,40409,40376,40376,40409,36117,29744,40179,48599,50712,48632,42326,36051,40245,38132,40212,40245,40212,44438,40245,31792,33938,33938,29745,33970,27664,31890,40277,31793,29712,31857,27632,31857,29712,27664,36084,29745,25519,29744,25519,27632,25519,25519,33871,40112,42257,40144,40144,38064,40211,52826,52793,50712,44405,48599,46486,46518,36148,23502,25582,25582,25582,27695,25582,23470,25583,25550,23470,23470,25582,48631,48630,48598,42291,14920,10727,12905,10727,8647,14953,10728,6534,4454,6502,4421,4421,4356,4356,4356,2276,4421,8712,8679,12837,8644,6467,8644,6467,6435,8580,10660,8515,8547,10660,8548,33,8417,23008,12480,2113,33,33,33,33,2113,2113,65,65,33,65,65,33,65,65,65,65,65,65,65,65,65,65,65,65,32,1,33,6436,19146,17065,19178,19178,21259,21291,19178,19178,25386,48165,29610,21291,19146,17066,17065,17065,14985,14953,14953,14953,14920,14953,14952,14952,14953,12872,14952,14953,14952,60},
{34233,34233,34233,36281,36281,36281,34201,36281,36281,36313,36313,38329,38361,38361,38361,38361,38361,38361,38361,38361,38361,38361,40442,38361,38329,38361,40409,40409,40441,40441,40409,40409,42490,40441,42489,42489,42489,42489,42522,42489,44570,44570,44570,44537,44569,46618,44570,44570,44570,44537,46618,46618,46618,46618,44537,44537,44537,44570,44537,44537,44537,44537,44537,44537,42489,42489,42457,42457,42457,42457,40409,42489,40409,40409,40409,40409,40409,40409,38263,23503,17067,14922,12841,21358,23536,13004,15117,15117,10923,17229,10826,15084,25583,8712,10858,19277,4519,19277,4551,10858,38164,12906,4519,21358,2406,19245,10825,4519,34003,19212,261,19310,4454,10825,12938,4454,31790,38031,40112,38064,40112,35984,38131,54874,54906,50712,38098,48599,42292,42325,36116,25550,23502,25550,27663,25583,25550,25518,25550,25550,23470,21389,25582,50712,46485,42290,44372,23372,14986,23405,12906,10825,23405,15018,4421,4453,6502,4389,4389,4324,2211,2244,2243,4389,6502,6436,10757,8644,10692,8644,6467,6499,8612,10628,10595,8547,10627,8548,34,10529,46048,31360,4193,33,33,33,65,65,65,2113,2114,65,65,2114,66,65,65,66,65,66,98,65,65,65,65,65,33,0,33,65,8549,19146,19145,19178,19178,21291,21258,19178,19178,29545,46085,25451,21259,17098,17098,17098,17065,14953,14953,14953,14953,14953,14952,14952,14952,14953,14953,14953,14953,14952,56},
{36281,34201,34233,34233,34233,36281,34200,36281,36281,36281,36281,38361,38361,38361,38329,38361,38361,38361,38361,38329,38361,38361,38393,38361,38361,38361,38361,40409,40409,40441,40409,40441,40409,40409,40441,42489,42489,42489,42490,42489,42489,44538,44569,44570,44569,44570,46618,44570,44570,46618,46618,44570,44570,44570,44537,44570,44537,44537,44570,44569,44537,44537,44537,42489,42489,42457,42489,42424,42457,42457,40409,40408,40409,40409,40376,40409,40409,40409,38295,17229,2276,1,1,21293,38164,2373,12938,19244,2374,23535,2341,17067,40310,8647,8648,23503,2309,21390,6567,8615,40310,17099,2341,23535,4421,19245,12938,2308,36083,25486,163,21390,8647,10825,19244,6501,29677,38031,38063,40144,40144,38131,38131,54874,54874,48599,33905,48599,44437,46551,38196,25582,25550,25583,25550,23470,25550,25550,25582,25550,25550,23470,25550,44405,44371,44338,40178,19113,10760,17066,14953,8679,19147,17099,6534,2276,4356,4356,4356,4356,2276,2276,4356,4454,6534,8581,12837,8644,8579,8611,10693,10628,8547,8547,8515,10660,12740,10596,2114,2113,8417,10497,2113,33,33,33,33,33,33,33,33,33,33,33,33,65,65,65,65,65,65,65,65,65,2113,65,33,0,33,66,10695,19145,19145,19178,19178,21259,21258,21258,19210,35752,44007,23371,21259,17098,17098,17066,17033,14953,14953,14985,14953,14985,14952,14952,14953,14953,14985,14953,14920,14952,57},
{34233,36281,36281,34233,34233,34233,36281,36281,36281,36281,38361,38329,38361,38361,38361,38329,38329,38361,38361,38329,38361,38361,38361,38361,38361,40441,38361,38361,40441,40409,40409,40441,40409,42490,42489,42490,42489,42489,42489,42489,42489,44538,44537,44570,44569,46618,46618,44537,46618,44570,44537,44537,44537,44570,44537,44537,44570,44537,44537,44537,44569,44537,42489,44537,42489,42489,42457,42457,42457,40409,40408,40409,40409,40376,40376,40409,40409,40409,40376,21455,4421,33,66,17066,40277,6567,8744,23438,4454,25551,6567,10825,40277,12906,4519,23503,2373,21325,10793,6534,40245,21293,2341,25551,6567,17099,17131,2308,33938,27664,2308,23438,12905,10825,19309,10825,19178,23307,25452,31757,31725,36018,40244,50713,48632,48632,44405,46551,46519,46551,36116,23502,27663,25550,25518,23470,25518,25550,25550,27631,25583,23469,23502,46518,48565,38065,33871,27598,10760,17099,12905,6566,14986,19212,8647,4324,4356,6437,4388,4356,2243,2211,2211,4357,6534,8581,12837,10691,10691,12804,23338,12740,8515,6403,8483,10627,10659,10629,2113,65,33,33,33,33,33,33,33,65,65,33,33,33,33,33,33,33,33,33,33,33,65,65,65,65,65,65,33,0,33,66,14888,19146,19145,19178,21258,21259,21226,19178,21258,41926,39912,23372,19179,19146,17066,17065,17065,14985,14985,14953,14985,14952,14953,14953,14953,14985,14985,14952,14952,14920,52},
{36281,36313,36281,36313,34233,36281,34201,36281,36281,36281,38361,38329,38361,38329,38361,38329,38329,38361,38361,38361,38361,38361,38361,40409,38361,40441,40442,38361,40409,40442,40441,40441,42489,42489,42489,42489,42489,42489,40409,42489,42489,44537,44570,44570,44537,46618,44570,44570,44570,46618,44537,44570,44570,44570,46618,46618,44537,44537,44537,44537,44537,42457,42489,42489,42457,42457,42457,42457,42457,40409,40409,40408,40376,38328,40376,40376,40376,40376,40376,27729,25454,38002,42260,44373,44471,29712,29712,38099,29680,40212,33905,36018,44471,29712,25454,33938,25454,31825,27632,25518,40277,33906,27534,36018,27599,31793,31825,27567,38164,38132,25518,31858,29712,17099,10760,4421,4389,2211,14953,31790,31757,38097,25485,29744,29744,27599,23340,25485,23405,27663,34035,25583,25550,25582,27631,25582,25550,25518,25550,25582,25550,21389,23469,46518,38065,29710,33871,25420,12808,19147,17066,10728,10792,6566,4389,8582,12840,8582,8582,4356,4324,12873,14953,17034,19146,19146,33871,38065,35984,33871,19112,10660,8515,6435,8483,6434,10660,10661,2113,2113,2113,33,33,33,33,33,33,33,65,65,65,65,33,65,33,33,33,33,33,65,65,65,65,65,2114,2114,33,0,33,2178,17001,19145,19146,21258,19178,21291,21258,21259,23338,46085,33706,23404,19178,19146,19146,17065,14985,14985,14985,17065,17065,14985,14953,12872,14985,17065,17033,14952,14920,14920,50},
{36281,36281,36281,36281,34233,36281,36281,36313,36281,36281,36281,38361,38361,38361,38361,38361,38361,38361,38361,38329,38361,38329,38361,38361,38361,38361,40409,38361,40409,40409,40441,40441,42489,40441,42489,42489,42489,42489,42457,42457,42489,44537,44537,46618,44537,46618,44570,46618,44570,46618,44570,46618,46618,44570,46618,44570,44537,44537,44537,44537,44569,42489,42489,42489,42457,42457,42457,42457,42457,40408,40408,40408,40376,40409,40376,40376,40376,40409,40409,34003,27664,25519,23438,23438,29810,25616,23471,23504,21358,23471,21358,19245,23503,19212,10761,21358,12906,15051,17164,6632,29777,27599,4487,19277,12906,10793,17164,2341,23438,29777,2373,12971,15018,2309,10760,2244,8582,19180,31824,38097,38064,40211,27566,38131,38131,33937,27598,29744,27598,31857,36115,27663,27631,25582,25583,25550,25518,23469,23469,25550,25550,25485,27598,46517,46419,44372,46420,35952,10727,12840,14953,10695,10727,8647,6437,6437,10663,8582,8614,6501,8582,38131,38164,44371,44371,38164,40277,42358,42358,38164,27531,17031,6435,6403,6403,4354,10692,10661,2146,2113,2113,65,33,33,33,33,33,33,33,33,65,33,65,33,65,33,65,65,33,33,65,2114,65,65,65,66,33,0,1,4291,17065,17065,19178,21258,19178,21259,19178,19210,27433,48132,27531,21291,19146,19146,17066,14953,14985,14985,14953,17033,14953,14985,14985,14953,14985,17066,17033,14952,14920,12872,53},
{34233,36281,36281,36281,36281,36281,36281,36281,36313,36281,38361,38329,38361,36313,38361,38329,38361,38329,38329,38361,38361,38361,38361,38361,38361,38361,38361,40409,40409,40441,40409,42490,40409,40409,42489,42489,42489,42489,42489,42489,42489,44570,44538,44570,44570,46618,46618,44570,44570,44570,46618,44570,46618,44537,44537,44570,44537,44537,44537,44537,44537,42457,42489,42457,42456,42457,42457,42457,42489,42457,40409,40408,40376,40376,40409,40409,40409,40409,42489,29875,8680,1,1,2244,33971,17100,196,19277,2341,15019,10858,196,36051,25487,163,19309,6567,10793,17164,131,29777,31890,163,19245,12906,8615,21390,163,25486,38164,2276,14986,19212,4389,21357,4421,4389,12905,17131,12807,14953,29711,33938,33873,33906,33938,31792,29679,29680,33905,36115,27695,27663,25550,27663,27631,23469,23469,31823,42291,44339,46485,48565,50679,52759,52759,52758,42258,16968,19146,23437,17066,19212,17099,6469,6469,6469,8582,8614,6501,10727,40212,36051,40244,36050,19212,19211,17098,15018,14920,25483,21192,8515,8515,8483,6467,10692,10661,2146,65,2113,65,65,65,33,33,65,33,65,65,65,33,33,65,33,33,33,33,33,33,66,2114,65,65,66,65,33,0,33,6436,19145,17065,19178,19178,19178,21258,19178,19178,31592,46086,23371,21291,19178,17065,17033,14985,14985,14953,14985,14953,14953,14953,14953,14985,14985,17065,14953,14952,12872,12872,53},
{36281,36313,36281,36281,36281,36281,36281,36281,36281,36281,38329,38361,38329,38361,36281,38329,38329,38361,38361,38361,38361,38329,38361,40409,38361,38361,40442,40441,40442,40409,40409,40441,40409,40441,42490,42489,42489,42522,42490,42489,42489,44538,44538,44537,44537,46618,44570,46618,44570,44537,44537,44537,44537,44537,44537,44537,44537,44537,44537,44537,42489,42457,42457,42457,42457,42424,42456,40408,36247,36247,38328,40376,40377,40409,40409,42457,40409,40409,42489,34036,13003,6535,4389,4454,34003,23503,293,19309,6632,12971,15116,293,31890,29777,2373,17197,10858,8777,17229,6729,25713,23601,13003,17262,13100,8842,15213,4649,15181,23601,6762,8907,11053,6762,11020,8907,6794,4584,4649,4617,4649,6794,4714,4681,6762,6762,6762,6730,4681,11020,34035,27663,25583,25582,27663,25550,23437,38097,48533,50678,50678,50679,52759,52759,50679,50646,48565,40112,14920,19114,21324,21259,14953,19146,17001,17001,12808,10695,8614,10727,14920,23437,21325,29744,33906,31858,29745,27664,27631,25453,12773,10692,8547,8515,8483,12772,10660,8580,2146,2114,2113,2113,65,33,33,33,65,2113,2113,65,65,65,65,33,33,65,33,33,33,65,33,65,65,65,2113,65,33,0,33,8549,19146,19145,19178,19178,19178,21258,21258,19178,37798,39911,23372,21291,19178,17033,14985,17033,14985,14985,17065,14985,17033,14953,14953,14953,17033,17033,14985,14953,12872,12872,52},
{36281,36281,36281,36281,36281,36281,36313,36281,36281,36281,38361,38361,38329,38361,38329,38329,38329,38329,38361,38361,38361,38329,38361,38361,38361,40441,40442,40409,40442,40409,40409,40409,40409,42490,42522,42489,42489,42490,42490,42490,42489,42489,44570,44538,44537,44570,46618,46618,46618,46618,46618,44570,44570,46618,44537,44537,44537,44569,44537,44537,42489,42489,42457,42489,42457,42457,42457,38328,23731,21651,23731,25812,27892,27892,27893,32021,34135,36215,38328,34069,19375,25746,21585,21586,17457,15377,13231,15312,11151,13231,13231,11086,15343,21552,19439,19472,9037,4844,4876,4876,6956,4876,4909,4909,2764,2763,715,2731,651,683,683,683,683,651,651,651,651,650,683,651,650,618,618,618,651,651,618,618,618,9005,36148,27663,25550,25582,25582,27630,27630,44371,52727,52759,50678,52759,52759,50679,48598,48597,48565,44339,19113,19147,21292,19147,14953,19211,21259,19179,17066,12808,10662,10695,8549,8550,6469,15018,8647,4389,2308,2276,4389,6533,8580,6435,4354,6435,8579,10692,10628,12741,2146,65,65,33,65,33,33,33,33,2113,65,65,33,33,65,65,65,65,65,33,33,65,65,65,65,33,33,33,0,0,33,10695,19178,19145,19146,19178,19178,19178,21258,21258,44005,35785,23372,19179,17066,17066,17065,14985,14985,14953,17033,14985,14985,14985,14985,14985,14985,17033,14953,14985,14920,12840,57},
{36281,36281,36313,36281,36281,36281,36281,34233,36281,36281,38361,38329,36281,38329,38361,38329,38361,38361,38361,38361,38361,38329,38361,38361,40409,38361,40442,40442,40409,40409,40409,42490,42489,42490,42490,42489,42489,42489,42489,42490,42490,42489,44570,44570,44569,44537,44537,44537,44537,44570,46618,44570,44537,44537,44537,44570,44537,44537,44505,44537,42489,42489,42457,42457,40409,42457,42457,34102,10988,11053,15247,17360,21553,21585,21618,21586,19538,21618,21618,21650,11053,196,261,2341,2374,326,4617,9102,7021,4942,4974,7022,4909,6989,6989,4844,4876,6989,2828,2861,2828,2795,2796,2763,650,683,683,683,715,716,683,683,683,651,651,683,651,650,651,650,618,651,650,651,651,650,618,618,585,9005,34100,25583,25582,25583,27631,44405,48565,46452,50679,52759,50678,52727,52759,52759,35984,46485,52759,48565,21194,17034,19147,12840,10760,12840,14921,8647,6469,8550,10663,10695,10662,6404,2211,8615,8615,4421,4519,4422,4389,4356,4355,4290,6435,10628,10692,10660,10660,10629,2146,2114,2113,2113,65,33,33,33,65,65,65,65,65,2113,65,65,65,66,33,65,33,65,65,2114,2146,65,33,33,0,33,66,14888,19178,19145,19178,19178,19178,19210,21259,23338,46085,29579,21291,19178,17066,17066,14985,14985,14985,17033,14985,17033,17065,14985,14953,17033,17065,14985,14952,14953,12840,12872,57},
{36281,36281,36313,36281,36281,36313,36313,36313,36281,36281,36281,38361,38329,38329,38361,38329,38361,38361,38329,38361,38361,38361,38361,38361,38361,38361,40441,40409,40441,40441,40409,40441,40441,42490,42490,42457,42489,42489,42490,42489,42489,42489,44537,44570,44570,44537,46618,46618,46618,46618,44537,44570,44537,44537,44570,44537,44537,44537,44505,42489,42489,42457,42489,42457,40376,40408,42489,27795,163,131,131,164,164,228,228,229,261,2699,2926,5006,4714,98,98,66,66,34,2438,11183,11150,9102,9102,9069,9070,9070,6989,4909,4908,4941,2828,2828,2828,2796,748,715,650,651,683,683,683,715,683,683,683,651,651,683,651,650,651,650,650,683,2699,2699,2731,2731,2699,2699,2698,9037,34068,27663,25583,27663,29743,48566,52759,46485,50646,50678,50678,52759,52760,52792,33839,42226,46485,44404,21227,10695,12840,12840,12840,8614,10695,10662,8549,6501,8582,6469,6469,6436,4356,6469,10792,10759,10758,8613,4355,4323,6467,4354,8547,8547,10628,8547,8515,10596,2113,2114,65,65,2113,65,2113,2113,65,65,65,65,2113,65,65,33,33,65,33,33,33,65,65,65,2114,2113,33,33,0,33,2178,14952,19145,17097,19178,19178,19178,21258,21291,29545,46086,25451,21291,19146,17065,17098,17033,14985,14985,14985,14953,17066,17033,14985,14952,17033,17033,14952,14952,12872,12840,12872,56},
{36313,36281,36313,36281,36281,36281,36281,36281,36281,36313,36313,36313,38329,38329,38361,38361,38361,38361,38361,38361,38361,38361,38361,38361,38361,40409,40441,40409,40441,40442,40441,40409,42489,42490,42489,42489,42490,42489,42489,42490,42489,44537,44538,44537,44570,44570,46618,46618,46618,46618,46618,44570,44537,44537,44537,44537,44537,44537,44537,42457,42457,42456,42457,42457,40376,40376,40408,23569,131,163,131,131,131,99,66,66,66,6860,9200,7119,2601,66,98,66,66,66,2536,11215,9102,9102,9070,6989,6989,9070,4909,4876,6989,6989,2796,4909,2828,2796,748,748,683,11086,15312,13199,13199,13264,13264,11151,11183,9103,9103,9135,9103,9103,11183,9103,9103,11183,9135,9135,11183,11183,9135,9103,9103,15344,34067,27663,25550,25582,31824,48565,54839,42291,46518,52759,50646,48565,50646,50678,31726,38032,44306,42226,27533,10727,14888,12775,8582,6469,8614,6469,6469,6501,6501,6469,6437,4324,2276,4324,10792,12838,12869,8611,2177,6435,4354,8515,8547,10628,8547,10595,10595,8548,2146,2146,65,2113,65,33,65,33,33,65,65,65,65,33,33,33,33,33,33,33,33,65,2114,2114,65,65,65,33,0,33,2211,17065,17097,19146,19178,19178,19178,21259,21323,35752,41959,23372,21291,17098,17065,17098,17033,14953,14985,14953,14953,17066,17065,14985,14953,17033,17065,17033,14985,14952,14920,14920,54},
{36313,36281,36281,36281,36281,36281,36281,36281,36281,36313,36281,36281,38361,38361,38361,38361,38361,38361,38361,38329,38329,38361,38361,38361,38361,40409,40409,40442,40441,40409,40409,40441,42489,42489,42489,42489,42489,42490,42489,42489,42489,42489,44570,44537,44537,44570,46618,46618,46618,44570,44570,44570,44570,44537,44537,44537,44537,44537,42489,42457,42489,42489,42489,42457,40376,40376,40408,19343,131,131,131,131,99,99,99,66,99,6957,11248,11248,2536,98,99,98,66,66,6697,11248,9102,7054,7054,6989,9069,9070,4876,2796,4876,4876,2796,2796,683,650,650,650,585,8940,13134,10988,8940,11021,8940,8908,8940,6860,6860,6860,6828,6827,6827,6827,4747,4747,4747,6795,4714,4714,6762,4681,2569,10987,34067,25583,25550,27663,40178,50646,52792,44372,48598,54841,52792,52727,52727,52759,31693,46452,50679,50679,33840,12840,19147,14953,10695,21228,25486,25453,14953,6534,6501,4389,4324,2244,2244,2276,10792,10758,10788,6499,2210,6467,4354,8579,8547,8580,8547,10562,10595,10628,2146,65,65,2113,65,33,33,33,33,33,65,65,2113,65,2113,33,33,33,65,33,33,65,65,2114,2114,65,65,33,0,33,4323,17097,17065,19178,21258,19178,19146,21258,21291,41958,37832,21291,21259,17098,17065,17065,14953,14952,17065,14952,14985,17066,14985,17033,17033,14985,14953,14985,14953,12872,12872,12872,55},
{34233,36281,36281,36281,36280,36281,36313,36313,36281,36313,36281,36313,38329,38361,38361,38361,38361,38361,38361,38361,38361,38361,38361,38361,38361,38361,40441,40441,40409,40409,40442,42490,42489,40409,42489,42489,42489,42489,42489,42489,44537,44538,44537,44538,44570,44570,46618,44570,46618,46618,44537,46618,44537,44570,44537,44537,44537,44537,42489,42489,40376,27796,29876,34102,36215,40376,42489,17263,131,131,131,131,163,164,163,131,131,6957,7087,7055,2407,66,98,66,66,98,2504,6827,4681,6859,17391,15279,17359,17392,15311,15246,13068,13036,13036,13036,13036,10956,13036,10988,10955,10955,10955,10955,10956,10956,10988,8908,8940,10988,19310,21390,21390,21390,19278,12970,19277,23503,17165,17132,25584,23471,15018,25551,23503,19309,31987,25583,27663,40178,50613,50679,52792,42258,48566,52792,52760,52760,50679,50679,48565,50679,48599,50679,36017,12840,14921,12808,8582,14953,21325,21325,19147,10695,6469,4421,4356,2244,4324,2276,10792,10790,12837,10660,6467,6531,6499,8579,8547,8515,8547,8515,10563,10628,2146,2114,65,65,65,33,33,65,65,65,2113,2114,65,65,65,65,65,33,33,33,33,66,2114,65,65,65,65,33,0,33,6469,17065,17097,19178,19178,19178,19178,21259,23338,46086,31658,21291,19211,17066,14985,14985,14985,14985,17065,14953,14953,14985,14985,17033,17033,14953,14985,14953,12872,12840,12872,12872,55},
{36281,36313,36281,36313,36281,36280,36281,36313,36281,36313,36281,36313,38329,38361,38361,38361,38361,38329,38329,38361,38361,38361,38361,38361,38361,38361,38361,40441,40409,40442,40409,40441,40441,40409,42489,42490,42489,42522,42489,42489,42489,44537,42489,44570,44570,44537,46618,46618,46618,46618,46618,46618,44537,44570,44570,44537,44537,44537,42489,44537,34134,326,196,261,2406,6665,11021,4520,131,131,163,228,326,423,391,456,2569,4844,2796,4844,229,66,66,66,66,130,6762,6924,6859,13166,27794,25714,25714,27794,25714,25714,25714,23633,23633,23634,21521,19472,21553,17392,15312,17392,17392,15344,15344,15344,13264,13231,13231,15279,40310,42390,42390,44471,27632,163,27632,42390,17034,10760,42358,31858,4356,33906,40245,17132,31922,27663,38097,48565,50678,50678,50679,42258,48599,52792,52760,50679,48598,50679,44405,38098,35985,25485,23405,14953,19146,17066,8679,17099,29679,29712,31792,25518,10760,4389,4356,2211,2243,2244,10792,12838,10756,8611,8612,6531,8611,8611,6467,8547,8547,8514,10627,8580,2146,2114,2113,65,33,65,33,65,65,2113,65,2113,65,65,65,65,33,33,33,33,33,65,2114,65,65,65,65,33,0,33,10662,19146,19178,21259,19178,19178,19178,19211,27498,46085,27531,21324,19211,17098,14985,14985,17065,17065,17033,14953,14920,14985,14985,17033,17065,14985,14953,14952,12872,12840,14920,12872,53},
{36281,34233,36281,36281,36281,36281,36281,36313,36281,36281,38361,38361,38361,38361,38361,38361,38361,38361,38329,38361,38361,38361,38361,38361,40409,38361,38361,38329,38361,40441,40441,40409,42489,42489,42489,42489,42489,42489,42489,44537,44537,42489,44537,44570,44537,44537,44570,44537,46618,46585,46618,44570,44570,44537,44569,44537,44505,42457,42456,42457,31989,229,196,164,131,131,131,98,98,99,131,66,99,99,66,99,294,9135,7087,7054,228,66,66,66,66,66,8940,11215,9102,15311,27794,25681,25682,25714,25682,23633,25714,21553,21553,23633,19472,19472,19472,17360,17360,17360,17359,15311,15312,17392,13231,13231,11183,15312,40310,40278,40278,42358,23438,163,27632,40277,14921,12841,40277,29744,4388,33938,38164,17131,34035,38097,50646,52759,52759,50646,52759,44404,48566,52792,50679,48598,46518,38097,29646,21291,33872,31792,29678,14888,14953,17066,10728,14986,25486,27598,27566,25486,14921,4389,2308,2243,2276,2276,10760,12838,10756,8611,10692,6499,6499,6499,8515,8547,10627,8547,10628,8580,2178,2114,2113,65,33,65,33,33,33,33,65,2113,65,65,65,65,33,33,33,33,33,66,2114,65,65,2113,65,33,0,65,12807,19178,19178,21259,19178,19178,19178,19211,31624,46086,25452,21291,19211,17098,14985,14953,17033,17065,17033,14952,14952,14985,14985,17066,17066,14952,14952,14952,14920,14953,12872,12872,53},
{36281,36281,36313,36281,36281,36281,36281,36281,36281,36313,36281,36281,36313,38361,38329,38361,38329,38329,38329,38329,38361,38361,38361,38361,38361,38361,38361,38361,38361,40409,40441,40409,42490,42490,42457,42489,42489,42489,42489,44537,44537,44537,44537,44537,44569,44570,44537,44570,46618,44537,46618,44570,44537,44537,44537,44537,44537,42457,42457,44537,29876,164,131,99,131,98,66,66,98,66,98,98,66,66,66,34,293,9168,7119,7022,164,66,66,66,66,99,9005,11182,9102,15311,27794,25682,25714,27794,25714,23633,25714,23601,21553,23633,19472,19440,19472,17392,17360,17392,15311,15279,15312,15312,13231,13231,11183,17360,42390,42391,40310,42390,25519,4389,33938,42358,14954,17034,42358,31825,8582,36051,38164,21292,40243,48565,52759,50678,50678,50679,54873,44371,48566,52792,48598,46485,35952,38097,38065,33871,35985,23404,25453,19179,12840,14986,10727,12840,23373,25486,23405,25485,19114,12840,12808,12808,14888,14921,21260,14983,8611,8579,8611,6499,6499,6467,8547,12708,12708,10627,10627,10660,2146,2113,33,65,33,33,33,65,2113,2113,2113,2113,2113,2113,33,33,33,65,33,33,33,65,65,65,65,2113,33,0,33,2146,14920,19146,19146,21226,19146,19178,19178,19211,37799,41960,23404,19178,17098,17066,14985,17033,17065,14985,14985,14985,14985,17065,17033,17098,17066,17033,17033,14952,14953,14920,12872,12872,54},
{34233,36281,36281,36281,36280,36281,34233,36281,36281,36313,36281,36281,38361,38361,38361,38361,38361,38329,38361,38361,38329,38361,38361,38393,38361,38361,38361,38361,38361,38361,40409,40409,40409,42489,42489,42489,42489,42489,42489,44537,44570,44537,44537,44537,44569,44569,44570,46618,46618,46618,44537,44569,44537,44537,44537,44537,42457,42489,42489,44569,21489,163,164,164,131,99,98,66,99,66,66,98,66,66,66,66,2406,9200,7087,6990,131,66,66,66,34,163,9070,9103,9102,19440,27762,25681,25714,25714,25714,25682,25714,21553,21521,23601,21520,21520,21521,17360,15279,17392,15312,15279,17392,15312,13231,13232,11151,19440,44471,46552,42390,44471,25518,8582,36084,42391,14954,19180,44471,31825,10695,38165,40277,38065,48565,52726,50646,50678,50678,50679,52760,42324,46485,48631,46518,40211,38098,42291,40179,42292,40244,31825,29711,29679,25453,25486,23373,21260,23340,25453,23405,23405,21292,21293,21260,23340,21227,17066,23405,17096,10691,8579,6499,6466,6499,6467,8547,12740,14820,10627,8579,12773,2178,2113,2113,65,65,33,33,65,65,65,65,65,2113,65,65,33,65,65,33,33,65,2146,65,2114,65,65,33,0,0,2210,17033,19146,19146,19178,19146,19146,19210,21291,44006,35786,21292,19178,19146,17098,17065,14985,17033,17065,14985,14985,17065,17033,17033,17066,17033,17033,17065,14920,14985,14953,12872,12872,56},
{34233,36281,36281,36281,36281,34233,34233,36281,36281,36281,36281,38361,36281,36281,38329,38329,38361,38361,38329,38361,38361,38361,38329,38329,38361,38361,38361,38329,40409,40441,40409,40441,40441,40409,42489,42489,42522,42489,44538,44537,44570,44569,44537,44569,44569,44570,44537,44570,44537,44570,46618,44570,44537,44570,44537,44537,42457,42457,42456,42457,17198,131,164,131,99,66,98,66,98,98,98,98,66,98,66,66,2472,9200,7087,4844,98,66,66,66,34,196,11150,9102,9102,21553,27795,25746,27794,27794,25714,25714,25714,21585,23633,23666,21553,19472,21553,17392,15312,17392,15312,15311,17392,15312,13231,13264,11184,21553,44471,42391,40277,44471,23438,8582,36051,40277,12840,21325,44471,29745,10727,40212,44405,48598,52727,52726,50645,50678,50711,48598,50679,42291,44404,48599,40211,38065,33871,29711,23372,23372,23372,10727,12840,17034,10760,19179,12840,12840,25453,29647,27566,21292,8647,2276,8614,38099,31760,4388,12872,12870,10691,8579,6499,6467,6467,6467,8579,10628,10627,10595,10595,12740,4258,2113,2113,65,65,33,65,33,33,33,33,65,65,65,65,33,33,65,65,65,65,65,65,2114,2114,2114,33,0,33,4324,17065,19146,19146,19178,19178,19178,19178,25386,46118,29611,21259,19178,19146,17098,17098,17033,17065,14985,14985,17065,17065,14985,14985,17065,14953,17033,14953,12872,14985,14953,12872,14953,55},
{34201,36281,36281,36281,36281,36281,34233,36281,34233,36281,36281,36313,36313,36281,38361,38329,38361,38329,38329,38361,38361,38361,38361,38329,38361,38361,38361,38329,40409,40441,40409,40441,40409,40441,42489,42489,42489,44570,44570,44570,44570,44569,44537,44537,44537,44570,44537,44537,44537,46618,46618,44537,44537,44537,44505,42457,42457,42489,42456,42457,12972,131,131,131,99,98,66,66,66,66,66,66,34,66,66,34,2569,5072,5072,4812,66,66,66,66,33,228,9070,6989,9037,15181,17230,17229,17197,17197,15117,15084,15084,13003,12971,12971,10891,8810,8810,6698,6730,8843,8843,8843,8843,8811,6762,6762,4714,17262,44439,40277,40277,42358,21292,8582,33970,38164,10727,21293,40310,25519,8647,38130,48598,52759,52759,52727,50645,50645,48566,50679,54840,42291,44405,50712,40178,33871,35985,17033,10694,12839,33872,19146,21227,25453,10727,17066,10760,10727,21260,25486,23405,15018,8647,10728,38099,46519,46551,38099,23437,14983,8611,6531,6499,6531,8547,6467,8547,10595,10595,8515,10660,12741,4258,2113,65,2113,65,33,65,33,65,65,65,65,65,65,65,65,65,33,65,33,65,65,2114,2114,65,2114,33,0,33,8517,19146,19145,19178,19178,19178,19178,19210,29577,46118,25451,21259,19178,17066,17066,17066,17033,17065,14985,17065,14985,17033,17065,17033,17033,14985,17033,14920,12872,14985,14920,12872,14953,54},
{36281,36313,36313,36281,36281,36281,34233,34233,34233,36281,36313,36313,36281,36281,36313,38361,38361,38361,38361,38361,38361,38361,38329,38361,38329,38361,38361,40409,40409,40441,40409,40441,40441,42490,42490,42522,42489,44537,44538,44537,42489,44569,44537,44569,44569,44537,44537,44538,44570,44570,44537,44570,44537,44569,44537,42489,42489,42456,42456,40409,8746,131,131,131,99,66,66,131,163,228,228,261,293,326,293,261,553,2764,2763,2569,66,98,131,196,261,358,488,423,423,326,325,325,326,358,358,2503,4649,4649,2568,2601,2569,520,2601,521,4714,19375,17359,17327,17327,13199,13199,13199,13199,25682,44471,44439,42390,42391,19180,8647,38132,38164,10695,23405,42390,25486,10728,38131,42324,50679,50646,50678,50678,48565,50646,48598,52759,44371,46485,52760,50679,40178,33871,38065,29645,23306,33904,17065,19114,25452,12872,19212,14986,10760,23405,29680,27599,12905,4388,31825,54906,44438,42325,46551,27663,12902,10724,6531,6531,6531,8547,6467,8515,12676,10595,10627,10660,12741,2210,2114,2114,2113,65,2113,33,33,65,65,65,2114,65,65,65,65,33,33,33,33,65,65,2114,2146,2114,65,33,33,65,10662,19145,19145,19178,19146,19146,19146,21259,35752,41959,23372,21259,19178,17066,17066,17033,17033,17065,14985,17065,17033,17066,17065,17065,14985,14985,14985,12839,12872,14985,14953,12872,14920,54},
{34233,36281,36281,36281,36281,36281,36281,34233,34233,34233,36281,36281,36281,36313,36313,38361,36313,36281,36281,38361,36313,36313,38361,38361,38361,38361,38361,40409,40409,40409,40409,40441,40409,40441,42522,42522,42489,42489,44537,44570,44570,44570,44570,44569,44537,44537,44570,46618,44537,44537,44537,44537,44537,44537,44537,42489,42489,42457,42456,38296,4552,131,131,131,99,66,98,131,196,261,293,293,326,326,423,553,2764,748,2828,488,34,66,98,98,98,358,6989,6957,6957,9037,6957,6989,9037,9037,6989,6957,9102,6989,4941,4909,2828,2828,2861,748,4876,15247,13166,11086,11086,11053,9005,11053,8973,25681,44471,46552,44439,44471,17099,10760,38197,38164,10695,25486,42390,23405,12808,40245,38099,40178,48565,50678,48565,48533,50646,48598,52792,44371,46485,52760,52792,46518,38065,40178,35952,33838,35984,29711,23405,25485,12808,17066,12905,8647,21260,27566,25486,21324,10760,8647,36051,46519,44471,33938,21324,14982,10756,6531,8579,6499,6467,8547,8547,10596,10595,10627,10627,12741,2178,33,33,65,65,65,33,33,33,65,33,33,65,65,65,65,65,33,33,65,65,66,66,65,65,65,33,0,65,12775,19145,19178,19178,19178,19178,19178,21291,41959,35784,21324,19211,17098,17066,17098,14985,17033,14985,17065,17065,17066,17098,17065,19178,14985,14985,14920,12872,14952,14953,12840,12872,12840,55},
{34233,34233,36281,36281,36281,36313,36281,34233,34233,34233,34233,34233,36281,36281,36313,36313,36313,36313,36281,36281,36313,36313,36281,38329,38361,38361,38361,40409,40441,40409,40409,40409,40409,40409,42489,42489,42489,42489,42457,44537,44570,44538,44538,44570,44537,44537,44537,44537,44537,44537,44537,44537,44537,44537,44537,42457,42457,42456,42456,36215,2407,99,98,98,66,66,66,99,98,66,66,66,66,66,66,98,4812,5039,5007,2569,33,66,66,66,34,2438,9135,9102,9102,11183,9070,7022,9102,9102,7022,4909,6989,4941,4941,2861,2828,2828,2828,716,650,618,618,618,618,585,618,618,618,23601,48632,48632,46552,46552,27599,23406,46551,46519,25518,38132,48664,36019,29712,46552,40277,25550,36017,50646,48565,48565,50645,48598,52792,44371,46485,52792,50679,52760,46485,38032,31791,25517,33904,31824,23405,29711,12840,14986,14953,8614,17066,25453,23373,17066,8614,4389,8647,33906,29712,6534,10727,12869,8611,6563,6531,8547,8547,8515,10628,8580,8547,10627,10628,10693,2178,0,0,33,2113,65,65,33,33,33,65,65,65,65,33,65,65,33,65,33,65,66,65,66,65,65,0,33,2146,14920,19145,19178,19146,19146,19178,19178,23338,44005,31658,21324,19211,17098,17065,17066,17033,17033,14953,17066,17098,17098,17098,17066,17066,14985,14953,14953,14953,14953,14953,12840,14920,12840,58},
{34201,36281,36281,36281,36281,36313,36281,34233,36313,34233,34200,36281,36281,36281,36313,36281,36313,36313,36281,36313,36313,36313,36281,38329,38361,38361,38361,40441,40409,40409,40409,40441,40441,42489,42490,42457,42457,42489,42489,44537,44537,44538,44538,44569,44537,44537,46618,44537,44537,44537,44537,44537,44537,44537,42489,42457,42457,42457,42456,36215,2407,34,66,163,2406,195,163,131,98,98,98,66,66,66,66,66,4844,5039,5007,424,33,66,66,34,34,2471,7054,7022,9102,11182,9070,11150,9102,9070,6989,6989,6989,4909,4909,2861,2828,4909,2861,748,748,781,748,748,780,780,2861,813,748,31988,59068,57020,54939,54939,40343,38262,52859,48698,38294,46616,46616,42455,40375,40342,25680,17261,12905,38097,46516,50646,50645,50646,52791,42290,46485,52759,50679,52759,52792,50647,40146,29645,31758,25485,17098,27598,17066,15018,15018,8615,17066,27599,25518,17099,6534,4389,4389,6469,4389,2146,8614,12869,10659,8611,8579,8547,6467,8515,10628,8547,8547,10692,10660,10693,4258,33,32,65,2113,65,2113,65,65,65,2113,65,65,65,65,33,2113,65,65,65,66,66,66,66,65,65,0,32,2211,14985,19145,19178,19145,19146,19178,19210,27466,46085,27532,23372,19179,17066,17066,17033,17066,17065,14985,17065,19146,17066,17066,17066,17033,17065,14920,17033,14953,12872,12872,14920,12872,14953,60},
{34233,36281,36313,36313,36281,36281,36313,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,38329,38361,38361,38361,40441,40441,40441,40441,40441,40441,40441,40441,42489,42489,44570,44537,42457,44537,44538,44537,44537,44537,44570,44537,44537,44570,44537,44537,44537,44569,44537,42489,42489,42457,42424,42456,31989,261,131,98,99,4551,27664,8583,66,66,66,66,66,66,66,66,99,4877,5007,5007,358,34,66,66,33,1,4584,9134,9102,9102,9102,9070,9102,11182,7021,6989,4908,4941,6989,4909,2828,2828,2861,2828,715,715,715,650,650,683,9070,19505,6989,6989,31988,50713,44503,40277,36083,29874,34100,36213,34133,34132,36181,29906,32020,34133,25712,19406,29906,15116,12905,35952,48565,50646,50646,52792,40145,46485,52760,52759,52759,50711,52792,52825,50680,48566,46453,42292,44372,19178,14985,17099,8679,17066,25518,27599,25486,17066,4421,4389,4356,4356,2179,8581,12901,12804,10692,8547,6435,10628,10660,10660,6435,6467,8547,10659,12741,4259,65,2113,33,33,65,33,65,65,65,65,65,2113,33,2113,65,65,65,65,66,98,2146,66,65,2114,33,0,0,4323,17065,19178,19178,19146,19146,19146,19211,31592,44039,25452,21291,17098,17066,17066,17033,17065,17033,17033,17033,17033,17098,17098,17066,17066,17033,14952,14985,14952,12872,14920,14953,12872,14953,55},
{36281,36313,36281,36313,36280,36281,36281,36281,36281,34233,34233,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,38361,38329,38361,38361,38361,38361,40409,40441,40441,40409,40409,40441,40409,42522,42489,44570,44537,42489,44538,44537,44537,44537,44537,44537,44537,44537,44537,44570,44569,44537,44537,42457,42457,42457,42457,42424,42457,27795,164,99,98,34,4422,29777,8680,293,326,326,326,293,261,228,196,228,683,2796,2796,455,358,293,261,261,228,456,2666,2634,2633,553,520,553,2633,520,553,488,488,2536,488,456,423,423,423,358,2569,6762,6729,4681,4714,6827,9005,6794,4779,31923,56987,54907,54874,52826,36116,29875,48697,44503,29907,36148,40310,31922,29874,36116,23535,21487,21486,12937,14985,40178,48565,48565,50678,38064,46485,52760,50679,52727,52727,50679,50679,50679,50712,50711,52760,50678,23339,12872,17098,10728,12873,25453,25486,19147,8647,4389,4389,4356,6469,6502,10693,12869,10756,8611,6435,6435,10660,12741,8547,6435,8515,8547,10595,12741,4291,33,65,2113,2113,2113,33,65,2113,2113,65,2113,65,65,65,66,65,65,65,66,98,2146,2146,2114,2114,33,0,33,6437,19145,19146,19146,19146,17097,19146,19178,37831,39912,23404,21291,17066,17065,17066,17065,14985,14952,17066,17065,17065,17098,17098,17066,17065,17065,14953,17033,14953,12872,14920,12872,12872,12872,56},
{36313,36281,36281,36281,36281,36313,36313,36281,36281,36281,36281,36281,36281,36313,36313,36281,36281,36313,36281,36281,36281,36281,36281,38361,38361,38329,38361,38361,40409,40409,40409,40409,40441,40441,42489,42490,42489,42489,42489,42489,44537,44537,44537,44537,44570,44570,44537,44537,44537,44537,44569,44537,44505,44537,42489,42456,42456,40376,42489,25682,131,131,99,99,6534,23470,2536,585,586,585,553,456,423,455,423,2569,11085,13133,11053,423,261,261,261,261,293,11053,13263,11183,11183,13263,13263,17424,17425,17424,15344,15312,19440,19472,4487,131,131,98,98,66,10955,23730,21618,23698,21650,19570,19570,21650,21618,36182,56987,57020,54939,54939,38230,34068,54907,54939,38197,48633,57020,46552,40277,54939,52826,38229,31921,25549,27663,25486,35952,48565,50678,42225,46485,52760,50679,50678,52759,52792,52759,52727,52727,50678,48598,52759,27533,12840,14986,6534,8647,17099,19212,14986,8647,4389,6469,4389,4389,4389,8613,12869,10659,8579,6435,8515,12740,10595,8515,8579,8579,8579,8547,12741,4291,65,65,65,33,65,65,65,65,65,65,2113,65,65,65,66,65,65,65,98,2146,65,65,65,2146,33,0,33,10662,19145,19178,19146,19146,19178,19178,21259,44039,33737,23372,19178,17098,17098,17066,17066,14985,14953,17033,17098,17033,17066,19146,19146,17065,17065,17001,17033,14953,14920,14920,12872,14985,12872,56},
{36281,34233,36313,36281,36281,36313,36313,36281,36281,36313,36281,36281,36281,36281,36313,36313,36281,36281,36281,36281,36281,36281,36313,38361,38329,38361,38361,40441,40441,40441,40441,40441,42489,40409,40409,42489,42457,42489,42489,42489,44537,44538,44537,44537,44569,44570,44537,44537,44537,44537,44537,44537,42489,42489,42489,42457,42456,40376,42457,25715,164,131,99,131,10825,31857,4422,196,163,131,131,131,99,131,34,4454,27892,27892,25811,2439,66,98,98,66,98,15214,19603,17522,17522,17522,17522,19602,25811,25811,19570,25811,27892,27859,4552,98,66,98,98,33,10955,21650,17490,21650,23731,19538,21618,23698,21585,36181,57020,54939,56987,56987,38230,34068,54939,54907,36149,46552,56988,44472,38229,54939,54907,40310,31954,23469,31857,19244,19146,48565,50678,40177,46452,50646,48564,50679,54840,52792,52759,52759,52792,52760,50679,54905,33872,14920,12872,6469,6469,10760,14953,10792,8646,6501,6501,6469,6404,6436,10693,12868,10724,8612,8579,10660,10660,8515,8515,8579,10659,10627,8450,10660,4291,65,33,65,65,33,65,65,65,2113,65,65,65,33,65,66,65,65,65,2114,66,2114,2114,2114,65,33,1,65,10727,19178,19178,19145,19178,19178,19210,23338,44038,29611,21291,19178,17098,17098,17066,17066,17033,17065,17065,17098,17065,19146,19178,17065,17098,17033,14952,17065,14953,14920,14952,14953,14985,12872,54},
{36281,36281,36313,36313,36281,36313,36281,36281,36281,36281,34233,34233,36281,36313,36313,36281,36281,34233,36281,36281,36313,36281,36313,38361,38329,38361,38361,38361,40409,40441,40409,40441,42489,40409,42489,42490,42489,42489,42457,42489,42489,44538,44537,44537,44570,44570,44537,44537,44537,44537,44537,44537,44537,44537,42489,42489,42489,42424,42457,27763,196,163,131,131,8680,19277,2276,163,131,131,131,163,98,66,66,4422,27892,27859,25779,4519,98,98,98,98,98,15182,19570,15442,17490,17522,19570,21651,23731,21618,19570,27859,27859,25779,4552,98,98,98,98,66,10923,19570,17457,21650,23698,17489,17489,23731,21617,36181,57020,56987,57020,56987,40310,34069,54907,54907,36149,46584,57020,46552,38197,54907,52826,38229,34035,25582,25583,23469,25550,48566,50678,40145,46451,50645,50645,50711,52759,52759,52792,52727,52792,52760,50712,54873,44372,38032,38065,38033,40146,40146,40145,40146,40146,42226,42226,44307,44307,46419,33870,10756,8644,8611,6466,8515,8515,8515,8515,10627,12707,12707,10595,12740,4291,33,33,33,65,65,65,65,2113,65,33,33,65,65,2146,66,65,65,65,98,66,2113,2114,65,65,33,0,2146,12840,19145,19178,19146,19178,19145,21258,29545,44038,25452,21291,19178,19146,17066,17033,17066,17065,17066,17066,19146,17066,17098,19178,17065,14953,14953,14953,14953,14953,14952,14953,14953,14953,12872,52},
{36281,36281,36281,36313,36281,36281,36281,36313,36313,34233,34233,34233,36281,36313,36313,36313,36281,36281,36281,36281,36313,36313,36313,36281,38361,38361,38361,38361,40441,40409,40409,40441,40441,40409,42489,42489,42489,42489,42489,44537,42489,44538,44537,44569,44570,44537,44537,44537,44569,44537,44537,44537,44537,42457,42489,42489,42456,40376,42457,27796,261,196,131,131,4487,10923,228,131,163,99,99,163,98,66,33,2341,27892,29940,25811,2503,99,131,98,98,98,13133,21683,19570,17522,19602,19602,21683,21683,19602,19602,29972,27892,25811,4584,98,98,98,98,98,8875,19602,17522,21683,25811,19570,21650,25811,23698,36181,56987,54907,54907,54939,40310,31956,52826,54907,36116,46552,56988,44471,38197,54907,52826,38230,31955,25550,25582,25550,25549,40211,42324,40178,50678,52759,50646,52759,52759,52727,52727,50678,50679,52759,35952,42259,50711,48598,48566,46517,46485,46485,46485,46485,46485,44404,44371,46452,46452,40177,23370,10724,10756,10724,8547,8515,6435,6435,8514,12707,12707,14787,14787,12772,4291,65,65,65,65,65,33,65,2113,2113,33,65,2113,65,66,66,66,98,66,2146,2146,65,2114,65,65,33,33,2211,17033,19145,19178,19178,19146,19145,19210,35752,39911,23437,21259,19146,19146,17098,17033,17065,17033,17065,19146,17066,17065,17098,19146,17033,14985,17033,17033,12872,14920,14952,14952,14953,14985,12840,52},
{36281,36281,36281,36281,36281,36281,36281,36313,36281,34233,36281,36281,36313,36281,36281,36281,36313,36281,36313,36281,36281,36281,36281,38361,38329,38329,38394,40409,40441,40409,40409,40409,42489,42489,42489,42457,42489,42489,42489,44537,44537,44537,44537,44537,44537,44570,44569,44569,44537,44537,44537,44537,44537,44537,42457,42457,42456,42456,42457,27795,196,196,163,163,2276,4487,228,196,164,196,196,196,163,98,98,2341,15279,17360,15246,2406,163,131,163,131,163,8908,13199,11118,11118,11118,11086,11086,11118,13134,8973,13101,13133,11020,2374,131,131,131,163,131,4616,13134,11053,11053,13101,8940,8973,11021,8908,29842,56987,54907,54907,56987,40310,31988,54907,54907,36116,46552,57020,46552,38197,54907,52826,38229,34035,25550,25582,25582,23469,23437,23404,38065,52759,50711,50646,52727,52759,50678,52759,52759,50646,50646,31726,29613,46485,46452,46452,46420,42259,44371,46452,46452,48565,44339,44339,50646,50678,42258,21224,12804,10756,8643,6434,6402,6370,8450,10594,12707,10627,10595,12739,14853,6371,65,65,65,2113,33,33,2113,2113,65,65,65,65,65,65,65,65,66,66,65,66,2114,65,2114,65,1,33,6404,19145,19178,19178,19178,19178,19178,19210,39910,35785,23372,19211,19146,17066,17066,17098,17065,14985,17066,19178,17066,14985,19178,19178,17033,14985,17033,14952,12872,14920,12872,14953,14953,14953,12840,53},
{36281,36281,36281,36281,36281,36281,36313,36313,36281,36281,36281,34233,36281,36281,36281,36281,36313,36313,36313,36313,36281,36281,36281,38329,38361,38361,38361,40441,40441,40409,40409,40441,40441,42490,42489,42489,42489,42489,44570,42489,44537,44537,44569,44537,44537,44569,44569,44570,44537,44537,44537,44537,44537,42489,42457,42457,42457,40376,42456,31989,2438,228,2276,2341,2341,66,293,391,293,293,325,326,326,326,293,358,521,554,553,326,228,261,293,196,196,294,456,424,424,456,424,424,456,424,424,391,488,488,489,488,456,488,553,521,521,553,553,553,586,554,521,423,358,23568,57020,54907,54907,56987,40310,31956,52859,54939,36117,44471,56987,46552,38197,54907,52827,38262,31955,23469,25550,23469,23470,21357,21356,23405,27533,29613,38065,46485,48565,48533,46452,44371,46484,44371,42259,44371,48598,48598,48598,48598,48565,48566,46452,48533,44371,40177,38065,46453,48598,42258,25450,12804,8611,8547,6467,6402,6370,8483,12707,10659,8547,10627,10659,12773,6371,65,33,33,65,65,33,2113,65,2113,2113,65,65,65,65,65,66,65,66,65,2114,65,65,2146,65,0,33,6469,19145,19178,19178,19178,19178,19178,21258,44038,29578,21292,19179,17098,17033,17033,17066,17065,17066,17098,17066,17066,17098,19178,17065,17033,14985,14985,12872,14920,14985,14953,14953,14953,12872,12872,54},
{36281,36313,36281,36281,36313,36281,36313,36313,36281,36281,36281,36281,36281,36281,36281,36313,36281,36281,36281,36281,36313,38361,36313,38361,38361,38329,38361,40409,40409,40409,40409,40409,40409,40441,42489,42489,42489,42489,42489,42489,42489,42489,44537,44537,44537,44570,44537,44537,44537,42489,42489,42457,42489,42489,42457,42489,42457,42424,40408,36183,6729,4486,2373,2373,2341,66,163,195,131,131,163,163,163,228,4584,4681,748,782,781,391,196,2309,228,163,163,423,781,716,717,749,717,684,717,684,651,586,716,716,716,749,716,716,748,716,748,781,749,748,814,813,748,488,455,25681,56987,54907,54907,56987,38229,29875,52826,54907,36149,44471,56987,46552,36117,54907,52826,40310,34003,23469,23470,21356,23469,23437,23437,21324,27597,33904,29678,25420,29645,38097,42258,42193,40112,40112,38032,42226,38064,40145,42258,40145,42258,44371,42193,40145,38032,38031,37999,40112,44371,40112,23369,10724,6499,8579,8547,4354,6435,10595,8579,8579,6402,8515,10660,10693,6371,33,65,2113,2113,65,65,65,65,65,2114,65,65,65,65,65,66,65,2146,66,66,2114,2114,66,33,0,33,10662,21226,19178,21258,21259,21258,19178,27466,46086,25484,21291,19178,17066,17033,17065,17098,17066,17066,19146,17098,17066,17098,19146,14953,17033,17066,14985,14952,14952,14953,14952,14953,14952,12872,14921,50},
{36281,36281,36281,38361,36281,36281,36313,36313,36313,34233,36281,34201,36281,36313,36313,36313,36313,36281,36281,36281,36313,36281,36281,36281,36281,38329,38361,40409,40409,40441,40409,40409,40441,40409,40409,40441,42489,42489,42457,42489,42489,44537,44569,44537,44537,44570,44537,44537,42489,42457,42457,42489,42489,42489,42456,42456,42456,42457,42456,40344,8778,2406,4519,4519,4486,98,163,2309,196,163,163,163,195,196,4616,4649,2763,782,749,488,228,228,228,196,163,293,749,684,684,717,684,684,684,684,684,586,716,684,716,749,716,684,716,684,683,651,651,651,683,683,618,423,390,23568,57020,54939,54907,56987,40278,29875,52826,54907,36116,44471,56987,46552,36117,54907,46519,38196,34003,25582,25582,23470,25550,25518,23470,23437,25550,23437,12840,130,2276,12808,21227,23307,21226,21226,27533,29646,27565,27565,33839,29645,29646,35984,42291,40178,38097,33871,35952,38097,44372,33871,17030,10691,10692,8579,8547,4322,6402,8579,10756,8579,8514,8515,10660,12805,6403,65,2113,2114,2113,65,65,65,65,65,65,2114,2114,65,66,65,33,65,66,2146,66,2146,2114,65,33,0,33,12807,19178,19178,19145,21259,19178,19178,31593,41992,23404,21291,17066,17065,17066,17033,17065,19146,17033,17066,17098,19146,19178,19146,17033,17065,17065,14953,14985,14953,14952,14953,14953,14953,12872,12872,52},
{36281,36313,36313,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,36313,36313,36313,36313,36281,36281,36281,36281,36281,36281,38361,38329,38361,40409,40409,40442,40442,40409,40409,40409,40441,42489,42457,42489,44538,42489,42489,44537,44537,44537,44569,44569,44537,42489,42457,42457,42456,42456,42456,42457,42457,42457,42457,42456,40376,40409,13037,261,2374,2308,163,98,163,2373,195,131,163,2243,2243,163,2438,2535,2731,814,749,521,196,228,196,2276,163,293,716,684,684,684,716,684,716,716,684,586,684,684,684,717,716,684,748,684,683,4844,4877,4877,6957,6990,9005,6794,2568,27729,57020,54907,54907,56987,40310,29907,52859,54939,36117,44472,57020,46552,36149,54939,52858,40310,34003,25582,27663,25583,25582,25550,23469,23437,25550,23502,15018,4389,98,4291,4291,4324,8517,8517,6436,6404,6436,21161,33838,38064,35984,33871,33839,33839,31759,23339,27467,31693,35919,27499,14917,10659,10692,8579,8548,6402,8515,8579,8611,6467,6434,10563,10659,10725,6403,2113,65,2113,33,65,65,33,65,65,65,2114,65,65,65,66,65,66,66,98,65,2114,2146,66,33,0,98,14952,19145,19178,19178,21259,19178,19178,37799,37865,23404,21259,17066,14985,17066,17033,17098,17066,14985,17065,17066,17098,19146,17066,17033,14953,14953,14952,14985,14953,14952,14920,14953,14953,12872,12872,56},
{36313,36313,36313,36281,36281,36281,36281,36281,36281,36281,34233,36281,36313,36281,36313,36281,36281,36281,36281,36281,36281,36281,36313,36313,36281,38361,38361,38361,40409,38361,40409,40409,40409,40409,40409,42489,42489,42489,42489,42489,42489,44537,44537,44569,44570,44537,44537,44569,42489,42457,42456,42456,42456,42457,42457,42457,42456,42456,40376,42489,21424,98,98,66,98,66,98,2373,163,131,131,195,2211,98,2341,2438,585,782,749,586,164,228,228,2308,2244,2341,684,716,684,684,716,684,716,749,716,586,684,684,651,716,684,684,749,716,716,9136,9201,11249,11249,11281,13264,11020,4616,27729,56987,54907,54939,54939,40310,29908,52858,54907,36117,42391,57020,46552,36116,54907,52826,38262,31954,25550,27631,25550,25550,23470,23470,25550,25550,25550,23437,19211,4324,6501,8582,10662,10662,12775,14920,16968,17001,27467,40178,44404,40113,27564,31759,38097,35984,44403,46452,44338,48565,33805,12804,8611,8579,8612,6467,6402,8579,6498,10691,8579,8514,8482,10627,12805,6371,2113,2113,65,65,2113,2113,65,65,65,65,65,65,65,33,66,65,65,65,65,2146,2114,65,66,33,0,2211,17033,19178,19178,19178,21259,19178,21258,41926,31658,21324,21259,17065,17033,17033,17065,17066,17065,17065,17066,17065,19146,19146,17033,17065,14953,14952,14953,14952,12872,12872,14952,14953,14953,12872,12872,59},
{36281,36281,36281,36281,38361,38361,36281,36281,36281,36281,34200,36281,36281,36313,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,38361,38361,38361,38361,40442,40441,40409,40409,40409,40409,42489,42489,42489,42489,42489,42489,42489,44569,44537,44537,44537,44537,44537,44537,42489,42489,42489,42456,42457,42457,42457,42424,42456,40408,42457,23569,358,2503,2406,358,228,98,2373,2244,163,195,163,196,163,2309,358,488,716,651,586,196,196,196,228,2308,4486,619,684,651,651,651,651,651,652,619,586,716,684,684,749,716,716,749,748,716,7088,9233,11249,11249,11281,11215,10988,4616,27697,54939,54907,54907,54907,40310,29875,52826,54939,38197,44471,57020,46552,36116,54907,52826,40310,31954,25550,25583,25550,23469,25550,25583,27631,25550,25550,23470,21389,19276,19146,12775,8581,8517,10662,10694,14888,10662,25354,38000,40145,40145,33871,44372,46484,44338,42257,46419,35951,33872,29645,12836,10755,8611,8611,8547,8547,8579,6531,10756,8579,8515,8547,10627,10660,4323,2146,65,33,2113,2113,65,65,66,65,2114,65,65,65,65,66,65,65,65,65,2146,2146,65,65,33,33,4323,19146,19178,19178,21258,21259,19178,25386,44006,27531,21291,19178,17066,17066,17033,14985,17066,17066,17065,17066,19178,19146,17065,17033,17066,14953,14920,14952,14953,14953,14920,12872,14920,14953,12872,14953,61},
{38361,36313,38361,36281,38361,38361,36281,36313,36281,36313,36281,36281,36281,36281,36313,36281,36281,36281,34233,36313,36281,36281,36281,36281,36313,38329,38361,38361,38361,38361,40409,40409,38329,40409,40377,40441,42489,42489,42489,42457,42489,42457,44569,44537,44537,44537,44537,44505,44537,44537,44537,42489,42489,42457,42457,42457,42456,40376,40376,40408,29876,325,2471,2471,325,228,66,2276,131,98,98,163,261,261,261,326,455,488,488,456,196,98,98,98,131,163,293,326,293,261,196,196,196,228,163,260,423,423,391,423,423,423,391,391,391,4780,4845,4812,6893,6893,6827,4616,2471,23471,56987,54907,54907,54939,40310,29875,52826,54939,38197,44471,57020,46584,36116,52859,52826,40310,31922,23502,27663,25550,25550,25550,25583,25582,25550,23469,23437,21356,25582,44404,35919,25355,23307,19081,17000,14920,10694,29515,40112,44371,48565,44338,48565,46452,42258,46419,50645,33839,17033,19178,12837,10788,8611,6499,6435,8515,8643,6498,8579,6531,8547,10660,8547,8580,4291,33,2114,65,65,65,2113,65,65,33,65,2113,65,33,33,65,33,33,33,65,2146,2146,65,65,33,33,6436,19178,19178,21258,21258,21259,19178,27465,41959,25452,21291,17098,17066,17033,17065,17065,17066,17065,17065,17033,17098,17066,17066,17065,17033,14952,14952,14952,14953,17033,12872,12872,12872,12872,12872,14953,60},
{36281,36281,38361,36313,36281,38361,36281,36281,36281,36313,36313,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,36281,36248,38361,38361,38361,38361,38361,38361,40409,40409,40409,40441,42489,42489,42489,42489,42489,44537,44537,44537,44537,44537,44537,44537,44537,42489,44537,42457,42489,42489,42457,42457,42456,42424,42457,42457,34102,2471,358,2406,325,293,98,66,33,33,33,98,98,98,2276,4584,4649,683,716,684,261,130,163,195,2276,195,456,619,586,554,2699,2732,2732,4812,2732,2732,4812,2732,2732,4844,4812,4845,6925,6957,6925,6958,6958,4910,9038,11151,11086,10955,8875,25648,57020,54907,54907,56987,40342,29875,52826,56987,38197,42391,56988,46584,36116,54907,54907,40342,31954,27663,29776,25550,25550,23470,25550,25582,25582,23502,23437,21324,25615,46518,46485,38032,33839,33839,27565,23404,25452,37999,42225,44338,44371,46419,48565,42258,48565,52726,48532,44404,44405,36017,12869,8643,6563,8579,4354,6467,12804,8611,8611,8611,8579,10659,8547,8580,4291,65,2113,65,65,65,65,65,65,33,33,65,65,33,33,33,33,33,65,65,2146,2146,65,33,33,33,10630,19178,19178,21258,21291,21258,19211,33672,39880,23404,21259,17098,17066,14953,17066,17066,17066,17098,17065,17033,17098,17098,17066,17033,17065,14952,14952,14953,14952,14952,14952,12872,14985,14921,14921,14985,62},
{36281,36248,36281,38361,36281,38361,36313,36313,36281,36281,36313,36281,34233,36281,34233,36281,34233,34233,36281,36281,36281,36281,36281,36281,36281,38329,38329,38361,38361,38361,38361,38329,38361,40409,40409,40409,42457,42489,42489,42489,42489,42489,42457,42457,44537,44537,44537,44537,44537,44537,44537,44537,42457,42489,42457,42457,42456,42456,42456,42457,38295,4649,358,2438,293,325,163,2276,2276,131,131,163,131,163,2308,4551,4616,684,749,717,391,4454,4389,2341,4421,2276,456,749,716,716,3025,977,977,3057,2992,944,5073,5073,2992,5072,7120,5040,9201,9201,7121,9201,11282,7121,9169,13362,11183,11053,15246,25616,56987,54907,54907,56987,40310,27794,50746,54939,36117,42391,56987,46552,36084,52826,54907,42391,34003,27663,29776,25582,25583,23437,23469,23502,23502,23502,21389,21357,27696,48598,50679,48565,40112,31758,23404,23339,25452,44273,44338,40145,44371,48532,44370,44338,48565,50645,48597,44405,16969,10661,12869,8643,6531,8643,8612,8611,10723,8611,10724,8611,12771,12739,10692,10692,4291,2113,65,2113,65,33,65,65,2113,65,65,65,65,65,65,33,33,33,65,65,65,2114,65,33,0,65,12807,19210,21258,21258,21259,21226,21259,37799,33705,21324,19178,17098,17066,14985,17033,17066,17098,19179,17065,17066,19178,17098,17033,17033,17065,17033,14952,14920,14953,14953,14952,14985,14953,12872,14953,14985,59},
{36313,36281,38361,38361,36281,36281,36281,36281,36281,36281,34233,36281,36281,36281,36281,36281,36281,36281,36281,34233,34233,36281,36281,36281,36313,38329,36281,38329,38329,38361,38361,38329,38361,40409,40409,40409,42457,42489,42489,42489,42489,42457,42457,42489,42489,44537,44537,44537,44537,42457,42489,44537,44537,42489,42489,42457,42457,42456,42456,40408,40409,10956,390,326,196,260,131,163,4454,163,163,195,228,131,2243,4583,4681,716,781,749,424,2308,2308,228,2341,2308,423,749,684,684,2992,2993,2992,3025,2992,2992,5073,2992,5040,5040,7120,7088,7088,9201,9168,9169,11282,9168,9169,13362,11183,8907,13133,27729,56987,54939,54939,54939,40310,29875,50746,54907,38197,42391,56988,48632,36084,52826,54907,42390,34035,27663,25582,25583,25582,25518,25550,25582,23470,23437,21356,21324,27696,48598,48565,48565,48565,48565,48565,48533,48499,46320,29547,33806,46484,48565,48532,48565,50646,50678,44404,12807,0,6403,12869,8643,8611,6531,10692,10723,8643,8643,8643,10691,14852,12739,12740,10692,6403,2114,2113,65,65,65,65,65,2113,2113,65,65,65,65,65,65,65,33,66,65,2146,2114,2113,33,0,2146,14952,21258,21258,21259,21258,19178,21258,41927,29578,21292,19178,17066,17065,14985,17066,17066,17065,19178,17065,19179,19178,17098,17066,17065,17033,14953,14920,12872,14953,14952,14952,17033,14953,14921,14920,14985,61},
{38361,38361,36281,38361,38329,36281,36313,36281,36281,36281,36281,36281,36281,36281,36281,36281,34233,36313,36313,36281,34233,36313,36281,36281,36313,36281,38329,36281,38329,38361,38361,38361,40409,40409,40409,40409,42489,42489,42489,42489,42489,42489,42489,44537,44537,44569,44569,44537,44537,44537,44569,44569,44569,44537,44537,44537,44537,44537,42489,42489,42489,17263,325,325,261,261,196,131,4486,2276,131,163,163,163,228,4583,4583,2698,782,749,489,260,2309,228,2341,260,456,749,684,684,2960,2992,912,3025,3025,2992,5073,2992,5040,5072,7120,7088,7088,9201,9168,7120,11281,9201,7121,9233,9103,6794,11020,27729,54939,56987,54907,56987,40310,29875,50778,54939,38197,44471,57020,48665,36116,52826,54907,40342,34035,29744,27663,25582,23470,25550,25550,23470,23470,23437,23437,21389,27663,48599,46485,48565,48565,50646,48598,48565,50613,25191,10596,31726,50645,50646,52759,50678,52791,44372,12775,0,0,6402,12836,8676,4451,4418,6531,10723,8643,6498,6499,10659,14852,12707,12740,8580,6404,2146,2113,65,65,65,65,2113,65,2113,65,2114,65,65,65,65,65,33,65,2146,2146,2146,2114,33,0,2178,17065,21258,21258,21258,21259,21259,25418,41927,25452,19211,17066,17066,14985,14985,17098,14985,17066,17098,17066,19178,19146,17033,17066,17066,17033,14952,12872,14953,14953,14920,14920,17033,14920,14920,14985,14985,62},
{36313,36313,38361,38329,38329,38361,38361,36313,36281,36281,36313,36313,36281,34233,36281,34233,34233,36281,36281,34200,34233,36281,36281,36313,36313,36313,38361,38361,38361,38361,40409,38361,38361,38361,38361,40409,40441,40441,40409,40409,40376,40377,40376,40376,40376,40376,40376,40376,38328,38296,38296,38296,38296,38295,36215,36215,36215,36183,36182,36183,36215,17263,325,2406,260,196,228,98,4518,2341,131,195,2308,2341,2341,6631,6631,2569,781,749,521,196,228,260,293,293,358,716,717,684,2927,3025,2992,2993,3025,2992,3024,2992,2992,5072,7153,7088,5007,7088,7120,9201,11249,9201,9169,11281,9103,6859,11053,29842,56987,54939,54939,54907,40310,27794,50745,56987,38197,42391,57020,48633,36116,52826,54907,42390,34035,29744,29744,27663,23469,23470,23469,23469,25518,23470,25518,21356,27663,48599,46451,46451,44338,44338,42258,40145,42225,23143,8581,31758,50678,50678,52727,52726,50679,38065,6338,0,0,6435,12836,8643,6530,6563,8643,6531,6563,6531,6498,12772,14820,14787,10628,8580,6436,66,65,33,65,65,2113,2113,2113,2113,65,65,2113,65,65,2114,65,65,2114,66,2146,2114,2114,33,0,4324,19146,19178,19178,21258,21291,21291,29545,39879,23372,19211,17098,17065,14985,14985,17066,14985,17098,19178,19146,19146,19146,17065,17065,17033,17033,14952,14953,14953,14952,14952,14985,14985,14953,14985,17065,14985,62},
{36281,36281,38361,38361,38361,38361,38361,38361,36281,36313,36281,36281,36313,36281,34233,34233,34233,36313,34233,34233,36281,36281,32054,21554,10989,10989,10989,13069,13069,21521,29941,13101,8843,8875,10956,11021,13231,6990,9071,11151,9071,9070,9038,9038,9038,6925,9005,6925,6925,6925,6957,6957,4877,6957,9005,9005,6925,6925,6925,9005,11086,6827,228,163,195,131,98,66,4486,4389,163,228,4454,8744,6631,6599,4453,2536,782,749,619,228,2308,261,2341,2438,4551,684,684,684,2862,3025,944,944,3025,3025,3024,5072,2992,5040,7121,7088,5007,5007,7088,11249,11281,7120,9201,11281,9135,6891,13101,29842,54939,54907,54907,56987,42358,27794,50745,54939,38197,42358,56987,46584,36116,52826,54907,42391,31922,25550,25583,27631,23502,25550,25550,23437,23437,25550,23469,21357,27663,48631,50645,46451,40177,36017,29711,27630,31758,27336,16967,33871,50646,52726,52759,52792,46485,52793,38033,14855,12743,10693,10724,6531,8643,8643,10691,8643,8643,6531,8579,14884,16900,12739,6435,10660,8516,66,65,33,65,65,33,2113,2113,2113,2146,65,2146,65,65,65,65,33,2114,2146,2146,65,2114,33,33,6469,19178,21258,21259,21258,21258,23340,35752,35752,23372,19179,17098,14985,17033,17065,17033,14985,17098,19178,19179,19179,19146,17066,19146,17033,17033,14985,14953,14953,14953,14952,14985,14953,14985,14985,17033,14953,60},
{36313,36281,36281,38361,38329,38361,38361,38361,36313,36313,36281,36281,36281,36281,34233,34201,34233,36281,36281,36281,36313,34200,21488,10890,6664,6664,6664,6696,8777,8712,15149,2406,2406,4519,2438,4681,4844,2731,4877,4844,4812,2764,2764,4844,651,2731,4844,2731,4812,2731,4812,4812,4812,6892,4812,6892,6892,4811,8973,6892,8973,8940,4551,2406,2470,2503,2406,66,293,2341,2276,260,2406,10825,6631,4518,2373,390,717,749,652,228,196,228,261,4551,13035,2797,749,684,814,3057,944,977,3057,3025,5073,7185,5073,2992,5105,5072,5040,7120,7088,9200,11282,7121,7153,11314,11216,4811,15246,36149,54939,54939,54939,56987,42391,29875,50745,54939,38197,42391,57020,46584,34036,52859,54907,42391,31890,25550,25550,27663,25550,27663,27630,25550,25550,25550,23437,21356,25582,48598,46485,40178,33871,35952,23404,23404,27565,42128,37968,40210,50678,50678,52759,52759,48598,50712,50712,38131,36050,21290,8643,6499,6531,6531,8579,8643,8643,6499,8611,14884,18980,14820,8579,10660,8516,2114,2114,2113,65,33,33,65,65,65,66,65,65,65,2146,65,65,66,98,2146,2146,65,65,33,33,8614,21258,21258,21258,21259,21259,23339,39879,33706,21291,19178,17066,17065,14953,14985,17065,17065,17065,19146,19211,19178,17065,19146,17066,17033,17033,14952,14953,14953,14985,14952,14952,14952,14985,14985,14953,14953,60},
{36281,36313,38361,38361,38329,36281,36313,36281,36281,36313,36313,36281,36281,36281,34233,36281,36281,36281,36281,36281,36281,27861,13036,6664,6664,6632,6632,6697,10858,6567,10890,294,2374,4454,4519,8940,6924,2764,6925,4844,4844,2731,2731,4812,651,2764,2764,2732,4812,2731,4844,2731,4812,6925,6892,6892,4844,6892,8973,8972,9005,13166,4649,2438,390,326,261,66,195,228,131,131,163,2243,2243,228,260,326,456,489,456,196,163,163,196,2373,8711,424,456,391,587,2992,2960,2992,2992,2959,2960,5007,2894,2862,4975,4910,4910,6990,4878,4910,6990,6990,4910,6990,6893,2568,4649,25584,56987,57020,56987,57020,44504,31956,50778,56987,38230,42391,57020,48665,36149,54907,56987,42423,31954,25582,25550,27663,25518,25582,27631,27631,25550,25550,25550,21357,25582,46517,44371,33871,33871,27565,21324,21324,23404,29579,10597,19114,38033,48565,52759,52727,48565,48599,54874,50680,42291,23337,8611,6563,8611,6466,4386,6499,8643,6531,6531,14884,16900,12707,10659,10660,8516,65,65,2113,65,2113,65,33,2113,2113,65,65,2113,2113,65,65,65,65,2146,2178,2146,2114,65,0,65,12807,19178,21259,21259,21258,21259,23339,39846,27531,21259,17098,17066,17066,17033,14985,14985,17098,19146,19178,19179,19146,17065,17065,14953,17033,14953,14952,17033,14953,14985,14920,12872,12872,14953,14985,14953,14953,64},
{38361,36281,38361,38329,38329,36281,38361,36281,36313,36281,36281,36281,36281,34233,34233,34233,34233,36281,36281,36281,36313,17393,13035,6696,8777,8777,8777,10890,6632,12938,4584,325,2374,196,2406,11053,9037,6925,6925,4844,4844,2731,2764,4844,2731,2731,651,2731,2699,2731,2764,2731,6860,6892,6892,6892,8973,8973,9005,11053,11085,11085,2471,2406,293,325,2438,163,131,130,65,98,130,4421,8679,4453,2373,4454,586,716,684,326,98,196,196,6566,10824,2601,619,586,619,717,684,684,684,651,586,554,554,586,586,586,554,586,586,554,4780,6925,6893,6893,6893,6795,6762,19375,44471,42391,42391,42391,34004,25681,38165,42358,29778,29778,40311,34004,23536,36117,36117,31923,34003,25550,27631,27663,25550,25582,25518,25518,23470,25583,25550,21356,25549,48598,48631,38065,35952,35952,25517,25517,27630,38032,14790,8516,16935,42226,52759,50678,46452,44372,52826,54874,40211,17030,6466,6466,6530,6499,6467,6499,6563,4483,8579,14852,16932,12707,8579,10660,8516,2146,2113,65,2113,65,65,65,33,2113,2113,2113,2113,65,65,65,33,65,65,2146,2146,2146,65,1,2178,14952,19178,21226,21291,21291,21259,27498,39879,25452,21259,17065,17066,17066,17033,17065,17065,17098,19178,19179,19178,19178,17065,17065,14952,14985,14985,14985,17065,14985,14985,14952,12872,14953,14985,14985,14953,14985,66},
{38361,38361,38361,38329,38329,38329,38361,38361,36281,36313,36281,36313,36313,36313,34233,36281,36281,36281,36281,36281,30007,13069,10922,8777,10857,10890,10858,13003,6534,15052,326,2374,2374,293,4682,11086,8973,4812,2731,6892,6925,4844,4844,4844,2699,2764,2764,4812,2731,4812,2699,2699,6892,4812,6892,6892,6892,8973,11085,11053,8972,8972,4681,4616,6665,6762,8939,10988,6729,2341,196,228,2341,8776,12969,6631,4453,4421,553,782,717,424,260,325,325,4518,8744,2633,749,717,716,717,651,651,716,651,619,651,684,684,749,716,684,716,716,683,5007,9233,9201,9201,11281,9201,9168,15377,19407,19374,17294,17326,8907,521,13101,17294,4681,4649,17294,10988,423,13068,13068,13003,31954,23437,25582,27663,25550,25550,23437,25550,23437,25550,23469,21324,27630,48630,50679,48566,40178,33871,21324,21324,23404,42225,40079,33839,50678,50646,52726,50646,46451,40211,48632,50712,36016,12836,8547,6498,8643,8610,6466,4418,4450,4451,8611,14852,14852,12708,10692,10692,8516,2146,65,65,2113,2113,33,2113,65,65,65,65,2113,2113,65,65,65,65,2146,98,98,2146,65,1,2211,19113,21226,19178,21258,21291,21259,33673,39912,23404,21259,17098,17066,17065,17066,17065,14985,19146,19146,19178,19146,19146,17065,17033,14953,17033,17033,14985,17065,14985,14953,14952,14920,14985,14985,14985,14985,14985,64},
{36281,38361,38361,38361,38329,38329,36313,36313,38361,36281,36313,36281,36281,36313,34233,36281,36281,34233,36281,36281,21554,10955,6696,8745,8745,8777,10890,10825,8712,8745,293,2406,261,2374,11053,11086,6892,4812,2699,4844,2699,2731,4844,4812,2731,2731,4812,4844,4812,4844,2731,2731,4812,2763,4844,6892,6892,8973,9005,8973,8973,11085,13166,13165,13198,13166,11085,15247,13069,2341,2308,293,260,4518,10825,4518,4389,2308,456,782,717,521,293,325,293,2406,8711,4649,717,684,684,717,652,684,716,716,619,619,716,684,716,716,683,716,716,683,4942,9201,9201,9201,11281,9201,9168,13329,19440,19342,17262,17294,10988,488,10988,17326,4746,2601,17294,11020,456,10988,13068,13035,31954,25518,25550,23470,23470,25550,23469,27630,25517,23437,23404,23437,27630,46485,48565,50678,50678,48565,46452,46484,46484,48564,42225,35951,50678,50613,48532,48597,48532,38065,42292,40244,33903,14917,8579,6499,8675,8610,4386,2338,6563,6531,8611,12804,10691,10627,10659,10692,6468,2146,2114,65,65,2114,65,2113,2113,65,65,65,65,65,33,33,65,66,2146,2114,2146,65,33,0,4356,19146,19178,21226,21259,21259,21259,37800,35786,21324,19178,17066,17066,17065,17066,17033,17065,19178,19146,19178,19146,17065,17098,14985,14920,17033,14953,14953,17065,14985,14920,14952,14985,17033,14985,14985,14953,14953,68},
{38329,38361,38329,38329,38329,36281,36281,36313,36281,36281,36281,36281,34232,36281,36281,36281,34233,34233,34233,32054,17294,10890,8745,10858,10857,10825,12970,19245,23503,2439,293,2373,228,4551,11086,9038,9005,6892,2764,6925,4780,4812,6925,4844,4812,4812,4844,4844,4844,4844,4844,4844,6924,6925,4844,6924,9005,11085,11085,8973,6892,8973,15246,11085,15246,13166,13134,13198,13133,2341,2308,293,293,2373,4518,2276,2308,2308,2536,781,716,554,261,325,293,261,2308,326,716,716,684,716,684,684,716,716,651,619,716,684,716,748,684,716,716,683,2764,2862,2862,2829,2894,2862,781,2861,13166,17229,15149,17261,10955,488,8907,19342,13036,10923,19310,19277,17164,21390,23470,25551,31921,25550,27663,25583,23437,25517,25582,29743,35984,35984,44339,48565,48565,42258,46452,52792,52791,52759,46452,52726,52759,52759,46452,35919,46452,44339,44339,40177,33871,31758,35984,35951,31757,12804,8579,4418,4386,4418,2306,4483,4418,4418,6531,10724,10692,10659,8547,10692,6468,2146,2113,65,2113,65,2114,65,65,65,65,65,65,65,65,65,65,66,2146,65,2146,65,32,0,8517,19178,19178,21259,21291,21259,23371,39912,31659,21292,19146,17066,17066,17066,17033,17065,17066,19179,19146,19178,17066,17065,17066,14953,14985,17065,14952,14985,17065,14985,14952,14952,14985,14953,17033,17066,14953,17033,72},
{38329,38329,38361,38361,38361,38329,38361,36313,36281,36281,36281,36281,36281,36281,36281,34233,34233,38361,46618,36117,21422,8777,6632,8777,8745,8745,10858,21390,21423,326,293,2373,196,4584,11118,9038,6925,2731,2764,6924,4779,6925,2764,683,4844,6925,4844,2764,2764,2764,2731,2764,4844,6925,6925,9005,8973,11086,11086,6925,4844,8940,13133,11085,15246,15214,13166,13134,8972,325,195,195,228,261,2341,6534,4486,4421,4551,2732,716,2634,228,228,260,260,2276,228,684,684,684,684,684,651,684,651,619,586,716,684,716,749,716,716,716,716,683,716,6925,17327,15279,15279,15278,23568,31857,36018,33938,38131,40212,40212,44405,46518,48566,48599,48599,50679,50711,52760,52792,52792,42324,38098,38130,38130,38097,38065,42291,40145,38064,40112,40112,40145,46419,38031,33838,38000,38033,35951,31726,35919,35919,31693,31693,19145,19146,21193,17000,14855,12775,17065,44405,48598,29643,10724,6499,6467,4386,6466,2274,6531,4451,6531,8643,10692,8579,10692,8611,10660,6468,66,2114,65,65,2113,2113,2113,2114,65,65,65,65,65,33,65,33,2146,2146,98,2146,65,0,33,10694,19178,19178,21258,21291,21291,25451,41992,27532,21259,19178,17066,14985,14985,14985,17065,17066,19178,19178,19146,17098,17066,17033,14953,14985,14952,14953,17033,17065,14985,14953,14952,17033,14985,17065,17033,14953,17065,72},
{38361,38361,38361,38329,38361,38361,38329,38361,36313,36313,36280,36280,36281,36281,34233,34233,36281,40442,44570,29875,21422,8810,8777,10890,8777,8777,12938,21422,17197,261,2374,4454,4454,6729,11118,11118,6957,4844,4844,6925,2731,6925,4844,2764,4844,2764,2764,2764,4812,4812,4844,6892,6925,9005,6925,9037,6924,9005,11085,9005,11086,11053,15246,15247,13166,15246,13166,8973,6892,4649,6664,8777,13003,17294,19407,25714,25713,23601,21553,23634,21585,17359,2438,2374,4552,6664,4552,4584,4812,4812,4812,4812,6925,6925,6893,9005,11085,4812,716,716,684,684,619,683,716,684,6925,23568,42292,48566,46486,48566,50679,50679,50679,50679,46485,52760,52760,50679,52760,50680,48599,50679,50712,50680,48565,48565,50678,52760,52792,52791,52792,52759,52759,50678,52758,48565,37999,40113,37999,35919,38032,40113,40113,40145,40113,40113,40178,46452,42258,19048,23306,12807,8549,8549,8549,10629,8582,6501,12808,36018,27530,12772,6467,4322,4354,4419,4419,4451,4386,8611,10691,10659,8611,10724,10691,10660,6468,2146,2113,65,33,2113,65,2113,65,65,65,65,65,65,2113,65,65,2146,65,65,65,65,33,65,14888,23339,19178,21258,21291,21291,29546,41960,25452,19179,17098,17098,17065,17065,17065,17065,19146,19211,19178,19146,19146,17066,17065,14953,14953,14953,14985,17098,17065,14985,14985,14952,17033,17065,17066,17065,14985,14985,67},
{38361,38361,38361,38329,38329,38329,38329,36281,36281,36313,36281,36281,36281,36281,36281,34200,36281,36281,36281,27795,19342,6664,8744,8777,8777,8777,12938,21390,15084,261,2374,2406,2373,6794,11086,9038,9037,4844,4844,6892,2731,6925,6957,4844,4845,2764,2796,2764,2764,2764,2731,6925,9005,6892,4812,6892,6892,8973,9005,8973,11085,11053,13166,13134,15247,13166,11085,11053,8940,17359,27892,25811,23698,21586,17425,15312,11151,11086,8973,9037,9005,6925,21553,17457,17457,17392,8940,6795,6730,6730,8972,6859,6827,6827,6827,8875,8907,6827,2634,2634,4746,15279,13166,11085,8973,6892,4714,15148,36018,46485,40210,42258,42291,42291,46452,40179,42259,44372,46485,46484,44404,46485,44405,44372,42291,40211,44404,48565,50678,52759,50679,52759,52727,50711,52726,50645,50678,50646,42193,42225,44305,37999,27467,27499,29580,29612,29580,29580,21193,21194,21193,17000,16935,12742,12742,6404,12677,14790,10596,10564,10564,19048,21192,10691,6467,6434,4386,4354,4386,6531,6499,8611,8579,8579,8579,10724,10692,10692,8548,2114,65,2113,2113,65,65,65,65,65,65,2113,65,65,65,65,33,2114,2113,65,2114,65,33,2178,17033,21259,21226,21258,21291,21323,33705,37865,23404,19178,17066,17066,17065,17066,17065,17066,19179,19179,21259,17066,17065,17065,17065,14952,17033,17065,14985,17033,17065,14985,14953,14952,17033,17065,17098,17065,14985,17066,68},
{38361,38361,38361,38329,38361,38361,38361,38361,36313,36313,36313,36281,36281,36313,36281,34201,34233,40441,38295,27729,17229,8745,8712,8744,8777,8745,12970,23503,12971,261,2374,2341,2341,6860,11118,9005,6957,4844,6925,6925,2764,4844,2764,2764,4877,2764,2764,4812,4844,4812,4844,6925,9005,8973,9005,9005,8973,11086,9005,8973,11085,11085,15246,13166,15246,13133,11085,11053,11021,15279,13166,9037,9005,6924,11085,9005,6892,9005,8973,9005,9005,9005,11118,9005,11085,6762,195,163,131,131,2341,2373,228,260,325,228,261,2406,2341,2438,2438,4519,2406,2373,2438,2470,358,6632,14953,29679,29711,35985,33904,31759,44404,31694,35920,44404,52792,52825,38099,42292,33839,35952,29613,29613,46484,40145,42291,42291,42291,42259,42258,42258,42258,40177,40145,40145,42258,44339,42290,42258,42258,38065,42258,42291,40178,33839,35952,42258,44371,44338,33838,31759,40178,25387,37835,48269,48301,50317,48268,39882,21158,10691,6466,4386,4386,2241,2274,4418,6531,10692,6499,6499,8579,10724,10627,10660,8548,2114,2114,2113,65,33,33,65,65,65,65,65,65,65,65,33,65,2146,2114,2114,2114,33,0,2211,17065,21258,21258,21259,21291,23371,37833,33738,21324,19178,17098,17065,17065,17065,17033,19178,19178,21259,19211,17065,17033,14985,17066,14985,17065,17033,17033,14985,14985,17065,17033,14985,17033,17065,14985,17065,17066,17098,65},
{38361,38361,38361,38361,38361,38361,38361,38394,36313,36281,36313,36281,36281,34233,34233,34233,34233,36281,34134,25616,17196,10858,10890,10857,12938,12970,15051,23503,8777,293,2374,2341,2373,8972,11118,9005,8973,4812,6957,6925,4812,4877,4877,2764,4877,4844,4844,4844,4844,2763,4844,8973,6892,6924,9005,8972,8973,8973,8973,11086,8973,11053,13166,13166,13166,11053,13134,8972,8972,13166,11053,11085,9005,6924,11085,6892,8973,9005,11085,11086,9005,11085,9005,9005,11118,6794,260,261,196,163,6631,4551,293,2406,2439,2309,2341,4551,4551,2438,2406,293,2374,2374,2373,4551,4551,358,325,2438,4454,10760,19179,27598,46485,35985,44404,46453,52793,54874,40212,44404,48598,46453,38066,42259,48598,40145,42259,42258,42259,42259,44339,44372,44372,42291,29613,21194,14888,8614,10695,8614,10662,10695,8549,8582,8582,8549,10663,12775,12807,12775,10630,10630,12743,10662,44141,52494,46188,46189,48269,44108,21159,8611,6402,4354,6467,2209,2274,4451,6563,10724,8611,8579,8579,12804,8547,8548,8548,2146,65,65,33,2113,65,2113,65,65,2113,65,65,2114,65,65,65,66,2146,2114,2114,33,0,4324,19178,21291,21258,21291,23371,25452,41960,29611,21324,19179,17098,17065,17065,17065,17066,21259,19178,19178,19178,17065,17065,14985,17065,17033,17065,14985,17033,17065,14985,17065,17033,17033,17065,17033,14985,17065,17098,17066,63},
{38361,40409,40441,38361,38361,38361,38329,36313,36313,36313,36281,36281,36281,36281,36281,34201,36281,36313,34167,25616,17164,8777,12970,12970,12970,12938,19245,29777,6664,261,2374,4551,8745,11085,11118,6925,6892,4812,6957,9005,6892,6925,2764,2731,4844,2764,4812,4812,4812,2731,4812,4844,4844,6925,6892,6892,9005,11053,11053,11086,13166,13166,13166,13166,13166,13133,13166,13133,11053,13166,13166,11085,9005,8973,11085,9005,9005,9005,11053,11085,13166,11086,11118,11086,11086,8940,2373,196,131,163,6697,4616,358,4551,2471,4487,2471,6697,6762,2536,2471,2439,2503,2439,2503,8809,6696,2471,2503,4584,12905,27565,33905,36017,48598,46485,44371,46485,52793,52793,46518,44404,48598,46518,44437,44405,48598,48598,42324,42291,44372,42291,42259,42291,40211,40178,48565,50678,35952,14791,14855,12710,6404,6469,4323,6436,6436,6501,4324,2243,4324,4291,4291,2243,6404,16838,46222,35722,10531,12611,16836,39882,19078,10691,12740,10595,8483,4290,4419,4418,6499,8579,8612,10660,10692,12772,10661,4324,4324,2146,65,65,65,33,65,2113,33,65,65,65,33,33,65,65,33,33,33,33,65,33,0,6437,21291,21258,21291,23371,23339,25419,39879,25484,21291,19178,17066,17065,17033,17066,19146,19178,19146,19178,19146,17065,17065,17065,17065,17033,17098,17033,17066,14985,14985,17065,17065,17033,17033,17066,17066,17098,17098,17098,54},
{38361,40441,40441,40441,38361,40441,38361,38329,38361,36281,38361,36281,36281,36313,36281,36281,36281,38361,34135,25648,10890,4486,6632,6631,6599,8744,17164,23503,4487,2341,4486,6632,6697,11053,9005,9005,8973,6892,6925,4844,6892,4844,651,2764,6925,4812,2763,4844,4844,2731,6892,6925,6925,8973,8973,8973,6925,11053,11086,11085,11086,11086,13166,13166,15214,13134,15246,15246,11053,11086,11085,11085,11053,11053,11053,9005,11086,11085,11053,13166,11053,11085,9005,8940,11085,6859,2373,228,131,98,4519,2504,293,2373,2406,2341,2406,2438,4551,2471,325,2438,2503,2438,2471,4551,4616,2471,2406,4519,6599,19212,31792,33904,44404,46485,42291,44372,50713,52793,50679,38097,33871,35952,27564,29645,50678,33806,17032,23404,25452,19145,21258,25484,33871,36017,44371,52727,50646,52760,50679,48598,40146,40146,35887,27500,14920,19178,12840,6437,6437,4356,6404,4323,12710,29449,29416,27303,18884,16804,21028,44170,27496,8579,14853,10596,6338,14821,8644,4451,6531,8612,8644,10756,12804,8579,19146,19179,6469,2146,65,65,65,65,65,65,2113,2113,65,65,2113,65,33,0,33,33,0,33,66,33,1,10630,21291,21259