//******************************************************************************
//
// MIDITrail / DXDirLight
//
// fBNViCgNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "DXDirLight.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
DXDirLight::DXDirLight(void)
{
	ZeroMemory(&m_Light, sizeof(D3DLIGHT9));
}

//******************************************************************************
// fXgN^
//******************************************************************************
DXDirLight::~DXDirLight(void)
{
}

//******************************************************************************
// 
//******************************************************************************
int DXDirLight::Initialize()
{
	int result = 0;

	ZeroMemory(&m_Light, sizeof(D3DLIGHT9));

	//Cg^CvFs
	m_Light.Type = D3DLIGHT_DIRECTIONAL;

	//gU
	m_Light.Diffuse.r  = 1.0f;
	m_Light.Diffuse.g  = 1.0f;
	m_Light.Diffuse.b  = 1.0f;

	//ʔˌ
	m_Light.Specular.r = 1.0f;
	m_Light.Specular.g = 1.0f;
	m_Light.Specular.b = 1.0f;

	//
	m_Light.Ambient.r  = 0.5f;
	m_Light.Ambient.g  = 0.5f;
	m_Light.Ambient.b  = 0.5f;

	//FxNg͐KĂȂ΂ȂȂ
	m_Light.Direction = D3DXVECTOR3(0.0f, 0.0f, 1.0f);

	return result;
}

//******************************************************************************
// Cgݒ
//******************************************************************************
void DXDirLight::SetDirection(
		D3DXVECTOR3 dirVector
	)
{
	D3DXVECTOR3 normalizedVector;

	//xNgK
	D3DXVec3Normalize(&normalizedVector, &dirVector);

	//Cg\̂ɓo^
	m_Light.Direction = normalizedVector;
}

//******************************************************************************
// foCXo^
//******************************************************************************
int DXDirLight::SetDevice(
		LPDIRECT3DDEVICE9 pD3DDevice,
		BOOL isLightON
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;

	//CeBO[h
	hresult = pD3DDevice->SetRenderState(D3DRS_LIGHTING, isLightON);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, isLightON);
		goto EXIT;
	}

	//XyL
	//  XyLLɂƒʏ̃Cgɔׂ2{ׂ̕邽ߖɂ
	//  TODO: Oݒł悤ɂ
	hresult = pD3DDevice->SetRenderState(D3DRS_SPECULARENABLE, FALSE);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, isLightON);
		goto EXIT;
	}

	// Cg_OpCvCɐݒ
	hresult = pD3DDevice->SetLight(0, &m_Light);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//CgL
	hresult = pD3DDevice->LightEnable(0, isLightON);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, isLightON);
		goto EXIT;
	}

EXIT:;
	return result;
}

