//******************************************************************************
//
// MIDITrail / MIDITrailApp
//
// MIDITrail AvP[VNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "resource.h"
#include "Commdlg.h"
#include "YNBaseLib.h"
#include "SMIDILib.h"
#include "DXRenderer.h"
#include "MTScene.h"
#include "MTWindowSizeCfgDlg.h"
#include "MTMIDIOUTCfgDlg.h"
#include "MTHowToViewDlg.h"
#include "MTAboutDlg.h"

using namespace YNBaseLib;
using namespace SMIDILib;


//******************************************************************************
// p[^`
//******************************************************************************
#define MAX_LOADSTRING  (100)

//EBhEX^C
//  WS_OVERLAPPEDWINDOW 玟̃X^C
//    WS_THICKFRAME   TCYύX
//    WS_MAXIMIZEBOX  ő剻{^
#define MIDITRAIL_WINDOW_STYLE  (WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX)

//V[PTbZ[WID
#define WM_SEQUENCER_MESSAGE (WM_USER + 1)

//j[X^C
#define MT_MENU_NUM        (17)
#define MT_PLAYSTATUS_NUM  (4)

//foCXXgxbZ[W
#define MIDITRAIL_MSG_DEVICELOST  _T("Direct3D device is lost.")


//******************************************************************************
// MIDITrail AvP[VNX
//******************************************************************************
class MIDITrailApp
{
public:

	//RXgN^^fXgN^
	MIDITrailApp(void);
	virtual ~MIDITrailApp(void);

	//
	int Initialize(HINSTANCE hInstance, LPTSTR pCmdLine, int nCmdShow);

	//s
	int Run();

	//~
	int Terminate();

private:

	//----------------------------------------------------------------
	//p[^`
	//----------------------------------------------------------------
	//t
	enum PlayStatus {
		NoData,			//f[^Ȃ
		Stop,			//~
		Play,			//Đ
		Pause			//ꎞ~
	};

	//V[
	enum SceneType {
		Title,			//^Cg
		PianoRoll3D,	//sAm[3D
		PianoRoll2D		//sAm[2D
	};

	//V[PTbZ[W
	typedef struct {
		unsigned long wParam;
		unsigned long lParam;
	} MTSequencerMsg;

	//ŐVV[PTbZ[W
	typedef struct {
		bool isRecvPlayTime;
		bool isRecvTempo;
		bool isRecvBar;
		bool isRecvBeat;
		MTSequencerMsg playTime;
		MTSequencerMsg tempo;
		MTSequencerMsg bar;
		MTSequencerMsg beat;
	} MTSequencerLastMsg;

private:

	//----------------------------------------------------------------
	//o`
	//----------------------------------------------------------------
	//EBhEvV[Wp|C^
	static MIDITrailApp* m_pThis;

	//AvP[VCX^X
	HINSTANCE m_hInstance;

	//EBhEn
	HWND m_hWnd;
	HACCEL m_Accel;
	TCHAR m_Title[MAX_LOADSTRING];
	TCHAR m_WndClassName[MAX_LOADSTRING];

	//_On
	DXRenderer m_Renderer;
	MTScene* m_pScene;

	//FPS\n
	DWORD m_PrevTime;
	DWORD m_FPSCount;

	//MIDIn
	SMSeqData m_SeqData;
	SMSequencer m_Sequencer;

	//t
	PlayStatus m_PlayStatus;
	bool m_isRepeat;
	bool m_isRewind;
	MTSequencerLastMsg m_SequencerLastMsg;

	//\
	bool m_isEnablePianoKeyboard;
	bool m_isEnableRipple;
	bool m_isEnablePitchBend;

	//V[
	SceneType m_SceneType;
	SceneType m_SelectedSceneType;

	//EBhETCYݒ_CAO
	MTWindowSizeCfgDlg m_WindowSizeCfgDlg;

	//MIDI OUTݒ_CAO
	MTMIDIOUTCfgDlg m_MIDIOUTCfgDlg;

	//@_CAO
	MTHowToViewDlg m_HowToViewDlg;

	//o[W_CAO
	MTAboutDlg m_AboutDlg;

	//ݒt@C
	YNConfFile m_MIDIConf;
	YNConfFile m_ViewConf;

	//----------------------------------------------------------------
	//\bh`
	//----------------------------------------------------------------
	//EBhE
	int _RegisterClass(HINSTANCE hInstance);
	int _CreateWindow(HINSTANCE hInstance, int nCmdShow);
	int _SetWindowSize();

	//ݒt@C
	int _InitConfFile();

	//EBhEvV[W
	static LRESULT CALLBACK _WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT _WndProcImpl(const HWND hWnd, const UINT message, const WPARAM wParam, const LPARAM lParam);

	//j[Cxg
	int _OnMenuFileOpen();
	int _OnMenuPlay();
	int _OnMenuStop();
	int _OnMenuRepeat();
	int _OnMenuResetViewpoint();
	int _OnMenuSaveViewpoint();
	int _OnMenuEnableEffect(MTScene::EffectType type);
	int _OnMenuWindowSize();
	int _OnMenuOptionMIDIOUT();
	int _OnMenuManual();
	int _OnMenuSelectSceneType(SceneType type);

	//̑Cxg
	int _OnRecvSequencerMsg(unsigned long wParam, unsigned long lParam);
	int _OnMouseButtonDown(unsigned long button, unsigned long wParam, unsigned long lParam);
	int _OnKeyDown(unsigned long wParam, unsigned long lParam);
	int _OnDropFiles(unsigned long wParam, unsigned long lParam);

	int _SelectMIDIFile(TCHAR* pFilePath,  unsigned long bufSize, bool* pIsSelected);
	int _LoadMIDIFile(const TCHAR* pFilePath);
	void _UpdateFPS();
	int _SetPortDev(SMSequencer* pSequencer);
	int _ChangeWindowSize();
	int _ChangePlayStatus(PlayStatus status);
	int _ChangeMenuStyle();
	int _CreateScene(SceneType type, SMSeqData* pSeqData);
	int _LoadSceneType();
	int _SaveSceneType();
	int _LoadViewpoint();
	int _SaveViewpoint();
	int _OnDestroy();
	int _RebuildScene();
	int _DispHowToView();
	int _UpdateMenuCheckmark();
	void _CheckMenuItem(UINT uIDCheckItem, bool isEnable);
	void _UpdateEffect();

};

