//******************************************************************************
//
// MIDITrail / MTScenePianoRoll3D
//
// sAm[3DV[`NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "stdafx.h"
#include <windows.h>
#include <mmsystem.h>
#include "Commdlg.h"
#include "YNBaseLib.h"
#include "MTScenePianoRoll3D.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTScenePianoRoll3D::MTScenePianoRoll3D()
{
	m_IsEnableLight = TRUE;
	m_IsMouseCamMode = false;
	m_ViewpointVector = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_ViewpointPhi = 0.0f;
	m_ViewpointTheta = 0.0f;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTScenePianoRoll3D::~MTScenePianoRoll3D()
{
	Release();
}

//******************************************************************************
// ̎擾
//******************************************************************************
const TCHAR* MTScenePianoRoll3D::GetName()
{
	return _T("PianoRoll3D");
}

//******************************************************************************
// V[
//******************************************************************************
int MTScenePianoRoll3D::Create(
		HWND hWnd,
		LPDIRECT3DDEVICE9 pD3DDevice,
		SMSeqData* pSeqData
	)
{
	int result = 0;

	Release();

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//m[gfUCIuWFNg
	result = m_NoteDesign.Initialize(GetName(), pSeqData);
	if (result != 0) goto EXIT;

	//----------------------------------
	// J
	//----------------------------------
	//J
	result = m_FirstPersonCam.Initialize(hWnd, GetName(), pSeqData);
	if (result != 0) goto EXIT;

	//ftHg_擾
	GetDefaultViewpoint(&m_ViewpointVector, &m_ViewpointPhi, &m_ViewpointTheta);

	//Jʒuݒ
	m_FirstPersonCam.SetPosition(m_ViewpointVector);
	m_FirstPersonCam.SetDirection(m_ViewpointPhi, m_ViewpointTheta);

	//----------------------------------
	// Cg
	//----------------------------------
	//Cg
	result = m_DirLight.Initialize();
	if (result != 0) goto EXIT;

	//Cg
	m_DirLight.SetDirection(D3DXVECTOR3(1.0f, -1.0f, 2.0f));

	//Cg̃foCXo^
	result = m_DirLight.SetDevice(pD3DDevice, m_IsEnableLight);
	if (result != 0) goto EXIT;

	//----------------------------------
	// `IuWFNg
	//----------------------------------
	//sb`xh񏉊
	result = m_NotePitchBend.Initialize();
	if (result != 0) goto EXIT;

	//m[g{bNX
	result = m_NoteBox.Create(pD3DDevice, GetName(), pSeqData, &m_NotePitchBend);
	if (result != 0) goto EXIT;

	//m[gg䐶
	result = m_NoteRipple.Create(pD3DDevice, GetName(), pSeqData, &m_NotePitchBend);
	if (result != 0) goto EXIT;

	//Obh{bNX
	result = m_GridBox.Create(pD3DDevice, GetName(), pSeqData);
	if (result != 0) goto EXIT;
	
	//sN`{[h
	result = m_PictBoard.Create(pD3DDevice, GetName(), pSeqData);
	if (result != 0) goto EXIT;

	//_bV{[h
	result = m_Dashboard.Create(pD3DDevice, pSeqData, hWnd);
	if (result != 0) goto EXIT;

	//
	result = m_Stars.Create(pD3DDevice, GetName());
	if (result != 0) goto EXIT;

	//^CCWP[^
	result = m_TimeIndicator.Create(pD3DDevice, GetName(), pSeqData);
	if (result != 0) goto EXIT;

	//FPS񐶐
	result = m_FPS.Create(
					pD3DDevice,
					_T("MS Gothic"),
					30,	//tHgTCY
					_T("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789:/. "),
					50	//LvVTCY
				);
	if (result != 0) goto EXIT;

	//----------------------------------
	// _OXe[g
	//----------------------------------
	//ʕ`惂[h
	pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);

	//Z[xrFON
	 pD3DDevice->SetRenderState(D3DRS_ZENABLE, TRUE);

	//fBUO:ON i`
	pD3DDevice->SetRenderState(D3DRS_DITHERENABLE, TRUE);

	//}`TvOA`GCAXFLɂȂȂH
	pD3DDevice->SetRenderState(D3DRS_MULTISAMPLEANTIALIAS, TRUE);

	//_OXe[gݒFʏ̃At@
	pD3DDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
	pD3DDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
	pD3DDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

EXIT:;
	return result;
}

//******************************************************************************
// ϊ
//******************************************************************************
int MTScenePianoRoll3D::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	D3DXVECTOR3 camVector;

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//JXV
	result = m_FirstPersonCam.Transform(pD3DDevice);
	if (result != 0) goto EXIT;

	//JW擾
	 m_FirstPersonCam.GetPosition(&camVector);

	//m[g{bNXXV
	result = m_NoteBox.Transform(pD3DDevice);
	if (result != 0) goto EXIT;

	//Obh{bNXXV
	result = m_GridBox.Transform(pD3DDevice);
	if (result != 0) goto EXIT;

	//sN`{[hXV
	result = m_PictBoard.Transform(pD3DDevice, camVector);
	if (result != 0) goto EXIT;

	//_bV{[hXV
	result = m_Dashboard.Transform(pD3DDevice, camVector);
	if (result != 0) goto EXIT;
	
	//XV
	result = m_Stars.Transform(pD3DDevice, camVector);
	if (result != 0) goto EXIT;

	//^CCWP[^XV
	result = m_TimeIndicator.Transform(pD3DDevice, camVector);
	if (result != 0) goto EXIT;

	//m[ggXV
	result = m_NoteRipple.Transform(pD3DDevice, camVector);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTScenePianoRoll3D::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;

//	float phi = 0.0f;
//	float theta = 0.0f;
//	float phiRad = 0.0f;
//	float thetaRad = 0.0f;
//	D3DXVECTOR3 lookVector;

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//XV
	result = Transform(pD3DDevice);
	if (result != 0) goto EXIT;

//  CgJɈvꍇ̏
//	m[g{bNX𗠂≺猩ĂN₩ȐFɂȂ邪
//	̒vIȖ肪̂Ŏ߂
//  Eg𗠂猩ƍȂ
//	EĐʂ𐳖ʂ猩ƔȂ
//
//	//J擾
//	m_FirstPersonCam.GetDirection(&phi, &theta);
//
//	//xNg
//	phiRad    = D3DXToRadian(phi);
//	thetaRad  = D3DXToRadian(theta);
//	lookVector.x = 10.0f * sin(thetaRad) * cos(phiRad);
//	lookVector.y = 10.0f * cos(thetaRad);
//	lookVector.z = 10.0f * sin(thetaRad) * sin(phiRad);
//
//	//Cg
//	m_DirLight.SetDirection(lookVector);
//
//	//Cg̃foCXo^
//	result = m_DirLight.SetDevice(pD3DDevice, TRUE);  //Cg
//	//result = m_DirLight.SetDevice(pD3DDevice, FALSE); //CgȂ
//	if (result != 0) goto EXIT;

	//Obh{bNX`
	result = m_GridBox.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//m[g{bNX`
	result = m_NoteBox.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//sN`{[h`
	result = m_PictBoard.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//`
	result = m_Stars.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//^CCWP[^`
	result = m_TimeIndicator.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//m[gg`
	result = m_NoteRipple.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//_bV{[h`FWϊςݒ_p邽߈ԍŌɕ`悷
	result = m_Dashboard.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

//	FPS͕`悵ȂƂɂ
//
//	FPS`
//	result = m_FPS.Draw(pD3DDevice, 10.0f, 50.0f, 0.5f);
//	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// j
//******************************************************************************
void MTScenePianoRoll3D::Release()
{
	m_NoteBox.Release();
	m_GridBox.Release();
	m_PictBoard.Release();
	m_Dashboard.Release();
	m_Stars.Release();
	m_TimeIndicator.Release();
	m_NoteRipple.Release();
	m_FPS.Release();
}

//******************************************************************************
// FPSo^
//******************************************************************************
void MTScenePianoRoll3D::SetFPS(
		double fps
	)
{
	TCHAR caption[16] = {_T('\0')};
	_stprintf_s(caption, 16, _T("FPS:%.1f"), fps);
	m_FPS.SetString(caption);
}

//******************************************************************************
// EBhENbNCxgM
//******************************************************************************
int MTScenePianoRoll3D::OnWindowClicked(
		unsigned long button,
		unsigned long wParam,
		unsigned long lParam
	)
{
	int result = 0;

	m_IsMouseCamMode = m_IsMouseCamMode ? false : true;
	m_FirstPersonCam.SetMouseCamMode(m_IsMouseCamMode);

	return result;
}

//******************************************************************************
// tJnCxgM
//******************************************************************************
int MTScenePianoRoll3D::OnPlayStart()
{
	int result = 0;

	_Reset();

	m_PictBoard.OnPlayStart();

	return result;
}

//******************************************************************************
// tICxgM
//******************************************************************************
int MTScenePianoRoll3D::OnPlayEnd()
{
	int result = 0;

	m_PictBoard.OnPlayEnd();

	return result;
}

//******************************************************************************
// V[PTbZ[WM
//******************************************************************************
int MTScenePianoRoll3D::OnRecvSequencerMsg(
		unsigned long wParam,
		unsigned long lParam
	)
{
	int result = 0;
	SMMsgParser parser;

	parser.Parse(wParam, lParam);

	//tԒʒm
	if (parser.GetMsg() == SMMsgParser::MsgPlayStatus) {
		if (parser.GetPlayStatus() == SMMsgParser::StatusStop) {
			//~iIj
		}
		else if (parser.GetPlayStatus() == SMMsgParser::StatusPlay) {
			//t
		}
		else if (parser.GetPlayStatus() == SMMsgParser::StatusPause) {
			//ꎞ~
		}
	}
	//t`bN^Cʒm
	else if (parser.GetMsg() == SMMsgParser::MsgPlayTime) {
		m_Dashboard.SetPlayTimeSec(parser.GetPlayTimeSec());
		m_FirstPersonCam.SetCurTickTime(parser.GetPlayTickTime());
		m_TimeIndicator.SetCurTickTime(parser.GetPlayTickTime());
		m_NoteRipple.SetCurTickTime(parser.GetPlayTickTime());
		m_PictBoard.SetCurTickTime(parser.GetPlayTickTime());
		m_NoteBox.SetCurTickTime(parser.GetPlayTickTime());
	}
	//e|ύXʒm
	else if (parser.GetMsg() == SMMsgParser::MsgTempo) {
		m_Dashboard.SetTempoBPM(parser.GetTempoBPM());
	}
	//ߔԍʒm
	else if (parser.GetMsg() == SMMsgParser::MsgBar) {
		m_Dashboard.SetBarNo(parser.GetBarNo());
	}
	//qLύXʒm
	else if (parser.GetMsg() == SMMsgParser::MsgBeat) {
		m_Dashboard.SetBeat(parser.GetBeatNumerator(), parser.GetBeatDenominator());
	}
	//m[gOFFʒm
	else if (parser.GetMsg() == SMMsgParser::MsgNoteOff) {
		m_NoteRipple.SetNoteOff(parser.GetPortNo(), parser.GetChNo(), parser.GetNoteNo());
	}
	//m[gONʒm
	else if (parser.GetMsg() == SMMsgParser::MsgNoteOn) {
		m_Dashboard.SetNoteOn();
		m_NoteRipple.SetNoteOn(parser.GetPortNo(), parser.GetChNo(), parser.GetNoteNo(), parser.GetVelocity());
	}
	//sb`xhʒm
	else if (parser.GetMsg() == SMMsgParser::MsgPitchBend) {
		m_NotePitchBend.SetPitchBend(parser.GetPortNo(), parser.GetChNo(), parser.GetPitchBendValue(), parser.GetPitchBendSensitivity());
	}

//EXIT:;
	return result;
}

//******************************************************************************
// ߂
//******************************************************************************
int MTScenePianoRoll3D::Rewind()
{
	int result = 0;

	_Reset();

	SetViewpoint(m_ViewpointVector, m_ViewpointPhi, m_ViewpointTheta);

	return result;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTScenePianoRoll3D::_Reset()
{
	m_Dashboard.Reset();
	m_FirstPersonCam.Reset();
	m_TimeIndicator.Reset();
	m_PictBoard.Reset();
	m_NoteBox.Reset();
	m_NoteRipple.Reset();
	m_NotePitchBend.Reset();
}

//******************************************************************************
// ftHg_擾
//******************************************************************************
void MTScenePianoRoll3D::GetDefaultViewpoint(
		D3DXVECTOR3* pVector,
		float* pPhi,
		float* pTheta
	)
{
	D3DXVECTOR3 vector;

	//ftHg̃JYWijE4̈ʒuƂ
	vector = m_NoteDesign.GetNoteBoxCenterPosX(
					0,		//ݎ
					0,		//|[gԍ
					0,		//`lԍ
					64		//m[gԍFE4
				);

	pVector->x =  0.0f;
	pVector->y =  vector.y;
	pVector->z =  vector.z - 18.0f;
	*pPhi      =  90.0f;	//+Z
	*pTheta    =  90.0f;	//+Z
}

//******************************************************************************
// _擾
//******************************************************************************
void MTScenePianoRoll3D::GetViewpoint(
		D3DXVECTOR3* pVector,
		float* pPhi,
		float* pTheta
	)
{
	D3DXVECTOR3 vector;
	float phi, theta = 0.0f;

	//J̈ʒuƕ擾
	m_FirstPersonCam.GetPosition(&vector);
	m_FirstPersonCam.GetDirection(&phi, &theta);

	//Đʂɑ΂鎋_ł邽X͍Đʒul
	pVector->x = vector.x - m_TimeIndicator.GetPos();
	pVector->y = vector.y;
	pVector->z = vector.z;
	*pPhi      = phi;
	*pTheta    = theta;
}

//******************************************************************************
// _o^
//******************************************************************************
void MTScenePianoRoll3D::SetViewpoint(
		D3DXVECTOR3 vector,
		float phi,
		float theta
	)
{
	D3DXVECTOR3 camVector = vector;

	//Đʂɑ΂鎋_ł邽X͍Đʒul
	camVector.x += m_TimeIndicator.GetPos();

	//J̈ʒuƕݒ
	m_FirstPersonCam.SetPosition(camVector);
	m_FirstPersonCam.SetDirection(phi, theta);

	//_L
	m_ViewpointVector = vector;
	m_ViewpointPhi = phi;
	m_ViewpointTheta = theta;
}

//******************************************************************************
// _Zbg
//******************************************************************************
void MTScenePianoRoll3D::ResetViewpoint()
{
	D3DXVECTOR3 vector;
	float phi, theta = 0.0f;

	//ftHg_擾
	GetDefaultViewpoint(&vector, &phi, &theta);

	//_o^
	SetViewpoint(vector, phi, theta);
}

//******************************************************************************
// \ʐݒ
//******************************************************************************
void MTScenePianoRoll3D::SetEffect(
		MTScene::EffectType type,
		bool isEnable
	)
{
	switch (type) {
		case EffectPianoKeyboard:
			m_PictBoard.SetEnable(isEnable);
			break;
		case EffectRipple:
			m_NoteRipple.SetEnable(isEnable);
			break;
		case EffectPitchBend:
			m_NotePitchBend.SetEnable(isEnable);
			break;
		default:
			break;
	}

	return;
}


