//******************************************************************************
//
// Simple MIDI Library / SMSimpleList
//
// PXgNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// ŒTCỸACeǉ^QƂ邾̒PXgNXB
// ubNPʂŊmۂ邱ƂɂAnew̎{񐔂}~āA
// \D悷Bg[hItŃ𖳑ʌB

#pragma once

#ifdef SMIDILIB_EXPORTS
#define SMIDILIB_API __declspec(dllexport)
#else
#define SMIDILIB_API __declspec(dllimport)
#endif

#include <map>

#pragma warning(disable:4251)

namespace SMIDILib {


//******************************************************************************
// PXgNX
//******************************************************************************
class SMIDILIB_API SMSimpleList
{
public:

	//RXgN^^fXgN^
	SMSimpleList(unsigned long itemSize, unsigned long unitNum);
	virtual ~SMSimpleList(void);

	//NA
	virtual void Clear();

	//ڒǉ
	virtual int AddItem(void* pItem);

	//ڎ擾
	virtual int GetItem(unsigned long index, void* pItem);

	//ړo^i㏑j
	virtual int SetItem(unsigned long index, void* pItem);

	//ڐ擾
	virtual unsigned long GetSize();

	//Rs[
	virtual int CopyFrom(SMSimpleList* pSrcList);

private:

	typedef std::map<unsigned long, unsigned char*> SMMemBlockMap;
	typedef std::pair<unsigned long, unsigned char*> SMMemBlockMapPair;

private:

	unsigned long m_ItemSize;
	unsigned long m_UnitNum;
	unsigned long m_DataNum;

	SMMemBlockMap m_MemBlockMap;

	unsigned long _GetBlockNo(unsigned long index);
	unsigned long _GetBlockIndex(unsigned long index);

	//ƃRs[RXgN^̋֎~
	void operator=(const SMSimpleList&);
	SMSimpleList(const SMSimpleList&);

};

} // end of namespace

