//******************************************************************************
//
// MIDITrail / MTNoteRain
//
// m[gC`NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTNoteRain.h"

using namespace YNBaseLib;


//******************************************************************************
// p[^`
//******************************************************************************
//1m[g̒_ = 1`4_ * 1
#define NOTE_VERTEX_NUM  (4 * 1)

//1m[g̃CfbNX = 1Op`3_ * 2 * 1
#define NOTE_INDEX_NUM   (3 * 2 * 1)


//******************************************************************************
// RXgN^
//******************************************************************************
MTNoteRain::MTNoteRain(void)
{
	m_CurTickTime = 0;
	m_CurNoteIndex = 0;
	m_pNoteStatus = NULL;
	m_CurPos = 0.0f;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTNoteRain::~MTNoteRain(void)
{
	Release();
}

//******************************************************************************
// 
//******************************************************************************
int MTNoteRain::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		SMSeqData* pSeqData,
		MTNotePitchBend* pNotePitchBend
	)
{
	int result = 0;
	SMTrack track;

	Release();

	if (pSeqData == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//m[gfUCIuWFNg
	result = m_NoteDesign.Initialize(pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	//L[{[hfUCIuWFNg
	result = m_KeyboardDesign.Initialize(pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	//gbN擾
	result = pSeqData->GetMergedTrack(&track);
	if (result != 0) goto EXIT;

	//m[gXg擾
	result = track.GetNoteList(&m_NoteList);
	if (result != 0) goto EXIT;

	//Sm[gC
	result = _CreateAllNoteRain(pD3DDevice);
	if (result != 0) goto EXIT;

	//m[gz񐶐
	result = _CreateNoteStatus();
	if (result != 0) goto EXIT;

	//sb`xh
	m_pNotePitchBend = pNotePitchBend;

EXIT:;
	return result;
}

//******************************************************************************
// Sm[gC
//******************************************************************************
int MTNoteRain::_CreateAllNoteRain(
		LPDIRECT3DDEVICE9 pD3DDevice
   )
{
	int result = 0;
	unsigned long vertexNum = 0;
	unsigned long indexNum = 0;
	MTNOTERAIN_VERTEX* pVertex = NULL;
	unsigned long* pIndex = NULL;
	unsigned long i = 0;
	D3DMATERIAL9 material;
	SMNote note;

	//v~eBu
	result = m_PrimitiveAllNotes.Initialize(
					sizeof(MTNOTERAIN_VERTEX),	//_TCY
					_GetFVFFormat(),			//_FVFtH[}bg
					D3DPT_TRIANGLELIST			//v~eBu
				);
	if (result != 0) goto EXIT;

	//_obt@
	vertexNum = NOTE_VERTEX_NUM * m_NoteList.GetSize();
	result = m_PrimitiveAllNotes.CreateVertexBuffer(pD3DDevice, vertexNum);
	if (result != 0) goto EXIT;

	//CfbNXobt@
	indexNum = NOTE_INDEX_NUM * m_NoteList.GetSize();
	result = m_PrimitiveAllNotes.CreateIndexBuffer(pD3DDevice, indexNum);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_PrimitiveAllNotes.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;
	result = m_PrimitiveAllNotes.LockIndex(&pIndex);
	if (result != 0) goto EXIT;

	//obt@ɒ_ƃCfbNX
	for (i = 0; i < m_NoteList.GetSize(); i++) {
		result = m_NoteList.GetNote(i, &note);
		if (result != 0) goto EXIT;

		result = _CreateVertexOfNote(
						note,							//m[g
						&(pVertex[NOTE_VERTEX_NUM * i]),//_obt@݈ʒu
						NOTE_VERTEX_NUM * i,			//_obt@CfbNXItZbg
						&(pIndex[NOTE_INDEX_NUM * i])	//CfbNXobt@݈ʒu
					);
		if (result != 0) goto EXIT;
	}

	//obt@̃bN
	result = m_PrimitiveAllNotes.UnlockVertex();
	if (result != 0) goto EXIT;
	result = m_PrimitiveAllNotes.UnlockIndex();
	if (result != 0) goto EXIT;

	//}eA쐬
	_MakeMaterial(&material);
	m_PrimitiveAllNotes.SetMaterial(material);

EXIT:;
	return result;
}

//******************************************************************************
// m[g{bNX̒_
//******************************************************************************
int MTNoteRain::_CreateVertexOfNote(
		SMNote note,
		MTNOTERAIN_VERTEX* pVertex,
		unsigned long vertexOffset,
		unsigned long* pIndex
	)
{
	int result = 0;
	D3DXVECTOR3 startVector;
	D3DXVECTOR3 endVector;
	D3DXVECTOR3 moveVector;
	D3DXCOLOR color;
	float whiteKeyStep = m_KeyboardDesign.GetWhiteKeyStep();
	float heightY      = m_KeyboardDesign.GetWhiteKeyHeight();
	float rainWidth    = m_KeyboardDesign.GetBlackKeyWidth();

	//m[gONW
	startVector.x = 0.0f;
	startVector.y = m_NoteDesign.GetPlayPosX(note.startTime);
	startVector.z = 0.0f;

	//m[gOFFW
	endVector.x = 0.0f;
	endVector.y = m_NoteDesign.GetPlayPosX(note.endTime);
	endVector.z = 0.0f;

	//ړxNg
	moveVector    = m_KeyboardDesign.GetKeyboardBasePos(note.portNo, note.chNo);
	moveVector.x += m_KeyboardDesign.GetKeyCenterPosX(note.noteNo);
	moveVector.y += m_KeyboardDesign.GetWhiteKeyHeight() / 2.0f;
	moveVector.z += m_KeyboardDesign.GetNoteDropPosZ(note.noteNo);

	//WXV
	startVector = startVector + moveVector;
	endVector   = endVector   + moveVector;

	//_
	pVertex[0].p = D3DXVECTOR3(startVector.x - rainWidth/2.0f, startVector.y, startVector.z);
	pVertex[1].p = D3DXVECTOR3(startVector.x + rainWidth/2.0f, startVector.y, startVector.z);
	pVertex[2].p = D3DXVECTOR3(endVector.x   + rainWidth/2.0f, endVector.y,   endVector.z);
	pVertex[3].p = D3DXVECTOR3(endVector.x   - rainWidth/2.0f, endVector.y,   endVector.z);

	//@
	//ۂ̖ʂ̕ɍ킹(0,0,-1)ƂƃCgKpƂɈÂȂ
	//Ղ̏ʂɍ킹邱ƂŖ邭
	pVertex[0].n = D3DXVECTOR3(0.0f, 1.0f, 0.0f);
	pVertex[1].n = D3DXVECTOR3(0.0f, 1.0f, 0.0f);
	pVertex[2].n = D3DXVECTOR3(0.0f, 1.0f, 0.0f);
	pVertex[3].n = D3DXVECTOR3(0.0f, 1.0f, 0.0f);

	//F
	color = m_NoteDesign.GetNoteBoxColor(note.portNo, note.chNo, note.noteNo);
	pVertex[0].c = D3DXCOLOR(color.r, color.g, color.b, 1.0f);
	pVertex[1].c = D3DXCOLOR(color.r, color.g, color.b, 1.0f);
	pVertex[2].c = D3DXCOLOR(color.r, color.g, color.b, 0.5f); //m[gOFFɋ߂Âقǔɂ
	pVertex[3].c = D3DXCOLOR(color.r, color.g, color.b, 0.5f); //m[gOFFɋ߂Âقǔɂ

	//CfbNX
	pIndex[0] = vertexOffset + 0;
	pIndex[1] = vertexOffset + 2;
	pIndex[2] = vertexOffset + 1;
	pIndex[3] = vertexOffset + 0;
	pIndex[4] = vertexOffset + 3;
	pIndex[5] = vertexOffset + 2;

	return result;
}

//******************************************************************************
// m[gz񐶐
//******************************************************************************
int MTNoteRain::_CreateNoteStatus()
{
	int result = 0;
	unsigned long i = 0;

	//m[gz񐶐
	try {
		m_pNoteStatus = new NoteStatus[MTNOTERAIN_MAX_ACTIVENOTE_NUM];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", 0, 0);
		goto EXIT;
	}

	//m[gԃXg
	for (i = 0; i < MTNOTERAIN_MAX_ACTIVENOTE_NUM; i++) {
		m_pNoteStatus[i].isActive = false;
		m_pNoteStatus[i].index = 0;
		m_pNoteStatus[i].startTime = 0;
	}

EXIT:;
	return result;
}

//******************************************************************************
// }eA쐬
//******************************************************************************
void MTNoteRain::_MakeMaterial(
		D3DMATERIAL9* pMaterial
	)
{
	ZeroMemory(pMaterial, sizeof(D3DMATERIAL9));
	
	//gU
	pMaterial->Diffuse.r = 1.0f;
	pMaterial->Diffuse.g = 1.0f;
	pMaterial->Diffuse.b = 1.0f;
	pMaterial->Diffuse.a = 1.0f;
	//Fe̐F
	pMaterial->Ambient.r = 0.5f;
	pMaterial->Ambient.g = 0.5f;
	pMaterial->Ambient.b = 0.5f;
	pMaterial->Ambient.a = 1.0f;
	//ʔˌ
	pMaterial->Specular.r = 0.2f;
	pMaterial->Specular.g = 0.2f;
	pMaterial->Specular.b = 0.2f;
	pMaterial->Specular.a = 1.0f;
	//ʔˌ̑Nx
	pMaterial->Power = 40.0f;
	//F
	pMaterial->Emissive.r = 0.0f;
	pMaterial->Emissive.g = 0.0f;
	pMaterial->Emissive.b = 0.0f;
	pMaterial->Emissive.a = 0.0f;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTNoteRain::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		float rollAngle
	)
{
	int result = 0;
	D3DXVECTOR3 moveVector;
	D3DXMATRIX rotateMatrix;
	D3DXMATRIX moveMatrix;
	D3DXMATRIX worldMatrix;

	//ݔm[g̒_
	result = _TransformActiveNotes(pD3DDevice);
	if (result != 0) goto EXIT;

	//s񏉊
	D3DXMatrixIdentity(&rotateMatrix);
	D3DXMatrixIdentity(&moveMatrix);
	D3DXMatrixIdentity(&worldMatrix);

	//]s
	D3DXMatrixRotationY(&rotateMatrix, D3DXToRadian(rollAngle));

	//tʒu
	m_CurPos = m_NoteDesign.GetPlayPosX(m_CurTickTime);

	//ړs
	//  m[gړꍇ
	moveVector = D3DXVECTOR3(0.0f, -m_CurPos, 0.0f);
	//  m[gړɃJƃL[{[hړꍇ
	//moveVector = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	D3DXMatrixTranslation(&moveMatrix, moveVector.x, moveVector.y, moveVector.z);

	//s̍Fړ]
	D3DXMatrixMultiply(&worldMatrix, &moveMatrix, &rotateMatrix);

	//ϊsݒ
	m_PrimitiveAllNotes.Transform(worldMatrix);

EXIT:;
	return result;
}

//******************************************************************************
// m[g̒_
//******************************************************************************
int MTNoteRain::_TransformActiveNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;

	//m[g̏ԍXV
	result = _UpdateStatusOfActiveNotes(pD3DDevice);
	if (result != 0) goto EXIT;

	//m[g̍XV
	result = _UpdateActiveNotes(pD3DDevice);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// m[g̏ԍXV
//******************************************************************************
int MTNoteRain::_UpdateStatusOfActiveNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long i = 0;
	unsigned long curTime = 0;
	bool isFound = false;
	SMNote note;

	//TODO: m[g̊ǗCu

	curTime = timeGetTime();

	//Im[g̏j
	for (i = 0; i < MTNOTERAIN_MAX_ACTIVENOTE_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			result = m_NoteList.GetNote(m_pNoteStatus[i].index, &note);
			if (result != 0) goto EXIT;

			if (note.endTime < m_CurTickTime) {
				result = _UpdateVertexOfNote(m_pNoteStatus[i].index);
				if (result != 0) goto EXIT;
				m_pNoteStatus[i].isActive = false;
				m_pNoteStatus[i].index = 0;
				m_pNoteStatus[i].startTime = 0;
			}
		}
	}

	//O񌟍Iʒu甭Jnm[g
	while (m_CurNoteIndex < m_NoteList.GetSize()) {
		//m[g擾
		result = m_NoteList.GetNote(m_CurNoteIndex, &note);
		if (result != 0) goto EXIT;

		//݃`bN^CJn`bN^CɂǂĂȂΌI
		if (m_CurTickTime < note.startTime) break;

		//m[go^
		if ((note.startTime <= m_CurTickTime) && (m_CurTickTime <= note.endTime)) {
			//łɓo^ς݂Ȃ牽Ȃ
			isFound = false;
			for (i = 0; i < MTNOTERAIN_MAX_ACTIVENOTE_NUM; i++) {
				if ((m_pNoteStatus[i].isActive)
				 && (m_pNoteStatus[i].index == m_CurNoteIndex)) {
					isFound = true;
					break;
				}
			}
			//󂢂ĂƂɒǉ
			if (!isFound) {
				for (i = 0; i < MTNOTERAIN_MAX_ACTIVENOTE_NUM; i++) {
					if (!(m_pNoteStatus[i].isActive)) {
						m_pNoteStatus[i].isActive = true;
						m_pNoteStatus[i].index = m_CurNoteIndex;
						m_pNoteStatus[i].startTime = curTime;
						break;
					}
				}
			}
		}
		m_CurNoteIndex++;
	}

EXIT:;
	return result;
}

//******************************************************************************
// m[g̍XV
//******************************************************************************
int MTNoteRain::_UpdateActiveNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	SMNote note;
	unsigned long i = 0;
	unsigned long curTime = 0;
	unsigned long elapsedTime = 0;
	bool isEnablePichBendShift = true;

	curTime = timeGetTime();

	//m[gɂĒ_XV
	for (i = 0; i < MTNOTERAIN_MAX_ACTIVENOTE_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			//m[g擾
			result = m_NoteList.GetNote(m_pNoteStatus[i].index, &note);
			if (result != 0) goto EXIT;

			//Jňoߎ
			elapsedTime = curTime - m_pNoteStatus[i].startTime;

			//m[g̒_XV
			result = _UpdateVertexOfNote(m_pNoteStatus[i].index, isEnablePichBendShift);
			if (result != 0) goto EXIT;
		}
	}

EXIT:;
	return result;
}
//******************************************************************************
// m[g̍XV
//******************************************************************************
int MTNoteRain::_UpdateVertexOfNote(
		unsigned long index,
		bool isEnablePitchBendShift
	)
{
	int result = 0;
	unsigned long offset = 0;
	unsigned long size = 0;
	float posX = 0.0f;
	float pitchBendShift = 0.0f;
	float rainWidth = 0.0f;
	short pitchBendValue = 0;
	unsigned char pitchBendSensitivity = SM_DEFAULT_PITCHBEND_SENSITIVITY;
	SMNote note;
	D3DXVECTOR3 moveVector;
	MTNOTERAIN_VERTEX* pVertex = NULL;

	//m[g擾
	result = m_NoteList.GetNote(index, &note);
	if (result != 0) goto EXIT;

	//sb`xhɂL[{[hVtg
	if (isEnablePitchBendShift) {
		pitchBendValue =       m_pNotePitchBend->GetValue(note.portNo, note.chNo);
		pitchBendSensitivity = m_pNotePitchBend->GetSensitivity(note.portNo, note.chNo);
		pitchBendShift = m_KeyboardDesign.GetPitchBendShift(pitchBendValue, pitchBendSensitivity);
	}

	//m[gXW
	moveVector = m_KeyboardDesign.GetKeyboardBasePos(note.portNo, note.chNo);
	posX = moveVector.x + m_KeyboardDesign.GetKeyCenterPosX(note.noteNo) + pitchBendShift;

	//_obt@̃bN
	offset = NOTE_VERTEX_NUM * sizeof(MTNOTERAIN_VERTEX) * index;
	size   = NOTE_VERTEX_NUM * sizeof(MTNOTERAIN_VERTEX);
	result = m_PrimitiveAllNotes.LockVertex((void**)&pVertex, offset, size);
	if (result != 0) goto EXIT;

	//_XWXV
	rainWidth = m_KeyboardDesign.GetBlackKeyWidth();
	pVertex[0].p.x = posX - rainWidth/2.0f;
	pVertex[1].p.x = posX + rainWidth/2.0f;
	pVertex[2].p.x = posX + rainWidth/2.0f;
	pVertex[3].p.x = posX - rainWidth/2.0f;

	//obt@̃bN
	result = m_PrimitiveAllNotes.UnlockVertex();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTNoteRain::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
   )
{
	int result = 0;
	DWORD value = 0;

	//_OXe[gJOȂɂ
	pD3DDevice->GetRenderState(D3DRS_CULLMODE, &value);
	pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);

	//Sm[g̕`
	result = m_PrimitiveAllNotes.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//_OXe[g߂
	pD3DDevice->SetRenderState(D3DRS_CULLMODE, value);

EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTNoteRain::Release()
{
	m_PrimitiveAllNotes.Release();
	m_NoteList.Clear();

	delete [] m_pNoteStatus;
	m_pNoteStatus = NULL;
}

//******************************************************************************
// Jg`bN^Cݒ
//******************************************************************************
void MTNoteRain::SetCurTickTime(
		unsigned long curTickTime
	)
{
	m_CurTickTime = curTickTime;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTNoteRain::Reset()
{
	int result = 0;
	unsigned long i = 0;

	m_CurTickTime = 0;
	m_CurNoteIndex = 0;
	m_CurPos = 0.0f;

	for (i = 0; i < MTNOTERAIN_MAX_ACTIVENOTE_NUM; i++) {

		//m[g̒_𕜌
		if (m_pNoteStatus[i].isActive) {
			result = _UpdateVertexOfNote(m_pNoteStatus[i].index);
			//if (result != 0) goto EXIT;
		}
		m_pNoteStatus[i].isActive = false;
		m_pNoteStatus[i].index = 0;
		m_pNoteStatus[i].startTime = 0;
	}

	return;
}

//******************************************************************************
// ݈ʒu擾
//******************************************************************************
float MTNoteRain::GetPos()
{
	return m_CurPos;
}


