//******************************************************************************
//
// MIDITrail / DXPrimitive
//
// v~eBu`NX
//
// Copyright (C) 2010-2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "DXPrimitive.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
DXPrimitive::DXPrimitive(void)
{
	m_VertexSize = 0;
	m_FVFFormat = 0;
	m_PrimitiveType = D3DPT_TRIANGLELIST;
	m_pVertexBuffer = NULL;
	m_pIndexBuffer = NULL;
	ZeroMemory(&m_Material, sizeof(D3DMATERIAL9));
	D3DXMatrixIdentity(&m_WorldMatrix);
	m_VertexNum = 0;
	m_IndexNum = 0;
	m_IsVertexLocked = false;
	m_IsIndexLocked = false;
}

//******************************************************************************
// fXgN^
//******************************************************************************
DXPrimitive::~DXPrimitive(void)
{
	Release();
}

//******************************************************************************
// 
//******************************************************************************
void DXPrimitive::Release()
{
	if (m_pVertexBuffer != NULL) {
		m_pVertexBuffer->Release();
		m_pVertexBuffer = NULL;
	}
	if (m_pIndexBuffer != NULL) {
		m_pIndexBuffer->Release();
		m_pIndexBuffer = NULL;
	}
	m_VertexNum = 0;
	m_IndexNum = 0;
	m_IsVertexLocked = false;
	m_IsIndexLocked = false;
}

//******************************************************************************
// 
//******************************************************************************
int DXPrimitive::Initialize(
		unsigned long vertexSize,
		unsigned long fvfFormat,
		D3DPRIMITIVETYPE type
	)
{
	int result = 0;

	Release();

	m_VertexSize = vertexSize;
	m_FVFFormat = fvfFormat;
	m_PrimitiveType = type;
	_GetDefaultMaterial(&m_Material);

	return result;
}

//******************************************************************************
// _obt@
//******************************************************************************
int DXPrimitive::CreateVertexBuffer(
		LPDIRECT3DDEVICE9 pD3DDevice,
		unsigned long vertexNum
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	if (m_pVertexBuffer != NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//_obt@
	if (vertexNum > 0) {
		hresult = pD3DDevice->CreateVertexBuffer(
						m_VertexSize * vertexNum,	//_obt@̑S̃TCY(byte)
						D3DUSAGE_WRITEONLY,			//_obt@̎gp@
						m_FVFFormat,				//_FVFtH[}bg
						D3DPOOL_MANAGED,			//\[XzuꏊƂȂ郁NX
						&m_pVertexBuffer,			//쐬ꂽ_obt@
						NULL						//\p[^
					);
		if (FAILED(hresult)) {
			result = YN_SET_ERR("DirectX API error.", hresult, vertexNum);
			goto EXIT;
		}
	}

	m_VertexNum = vertexNum;

EXIT:;
	return result;
}

//******************************************************************************
// CfbNXobt@
//******************************************************************************
int DXPrimitive::CreateIndexBuffer(
		LPDIRECT3DDEVICE9 pD3DDevice,
		unsigned long indexNum
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;
	
	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	if (m_pIndexBuffer != NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	
	//CfbNXobt@
	if (indexNum > 0) {
		hresult = pD3DDevice->CreateIndexBuffer(
						sizeof(unsigned long) * indexNum,
												//CfbNXobt@̑S̃TCY(byte)
						D3DUSAGE_WRITEONLY,		//gp@
						D3DFMT_INDEX32,			//CfbNXobt@̃tH[}bg
						D3DPOOL_MANAGED,		//\[XzuꏊƂȂ郁NX
						&m_pIndexBuffer,		//쐬ꂽCfbNXobt@
						NULL					//\p[^
					);
		if (FAILED(hresult)) {
			result = YN_SET_ERR("DirectX API error.", hresult, indexNum);
			goto EXIT;
		}
	}

	m_IndexNum = indexNum;

EXIT:;
	return result;
}

//******************************************************************************
// _o^
//******************************************************************************
int DXPrimitive::SetAllVertex(
		LPDIRECT3DDEVICE9 pD3DDevice,
		void* pVertex
	)
{
	int result = 0;
	void* pBuf = NULL;

	//_obt@̃bN
	result = LockVertex(&pBuf);
	if (result != 0) goto EXIT;

	//obt@ɒ_f[^
	try {
		memcpy(pBuf, pVertex, (m_VertexSize * m_VertexNum));
	}
	catch (...) {
		result = YN_SET_ERR("Memory access error.", (DWORD)pVertex, m_VertexNum);
		goto EXIT;
	}

EXIT:;
	UnlockVertex();
	return result;
}

//******************************************************************************
// CfbNXo^
//******************************************************************************
int DXPrimitive::SetAllIndex(
		LPDIRECT3DDEVICE9 pD3DDevice,
		unsigned long* pIndex
	)
{
	int result = 0;
	unsigned long* pBuf = NULL;

	//_obt@̃bN
	result = LockIndex(&pBuf);
	if (result != 0) goto EXIT;

	//obt@ɒ_f[^
	try {
		memcpy(pBuf, pIndex, (sizeof(unsigned long)* m_IndexNum));
	}
	catch (...) {
		result = YN_SET_ERR("Memory access error.", (DWORD)pIndex, m_IndexNum);
		goto EXIT;
	}

EXIT:;
	UnlockIndex();
	return result;
}

//******************************************************************************
// }eAݒ
//******************************************************************************
void DXPrimitive::SetMaterial(
		D3DMATERIAL9 material
	)
{
	m_Material = material;
}

//******************************************************************************
// ړ
//******************************************************************************
void DXPrimitive::Transform(
		D3DXMATRIX worldMatrix
	)
{
	m_WorldMatrix = worldMatrix;
}

//******************************************************************************
// `
//******************************************************************************
int DXPrimitive::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice,
		LPDIRECT3DTEXTURE9 pTexture,
		int drawPrimitiveNum
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;
	unsigned long primitiveNum = 0;

	if (m_IsVertexLocked || m_IsIndexLocked) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//_݂ȂΉȂ
	if (m_pVertexBuffer == NULL) goto EXIT;

	//_OpCvCɒ_obt@ݒ
	hresult = pD3DDevice->SetStreamSource(
					0,					//Xg[ԍ
					m_pVertexBuffer,	//Xg[f[^
					0,					//_f[^JnItZbgʒu(bytes)
					m_VertexSize		//_f[^\̃TCY
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, m_VertexSize);
		goto EXIT;
	}

	//_OpCvCɃCfbNXobt@ݒ
	if (m_pIndexBuffer != NULL) {
		hresult = pD3DDevice->SetIndices(m_pIndexBuffer);
		if (FAILED(hresult)) {
			result = YN_SET_ERR("DirectX API error.", (DWORD)hresult, (DWORD)m_pIndexBuffer);
			goto EXIT;
		}
	}

	//_OpCvCɒ_obt@FVFtH[}bgݒ
	hresult = pD3DDevice->SetFVF(m_FVFFormat);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, m_FVFFormat);
		goto EXIT;
	}

	//_OpCvCɃ}eAݒ
	hresult = pD3DDevice->SetMaterial(&m_Material);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//_OpCvCɃeNX`ݒFXe[W0
	hresult = pD3DDevice->SetTexture(0, pTexture);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, (DWORD)pTexture);
		goto EXIT;
	}

	//_OpCvCɈړ}gbNXZbg
	hresult = pD3DDevice->SetTransform(D3DTS_WORLD, &m_WorldMatrix);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//v~eBu擾
	result = _GetPrimitiveNum(&primitiveNum);
	if (result != 0) goto EXIT;

	//ڃv~eBuw肳ꂽꍇ͂ɏ]
	if (drawPrimitiveNum > 0) {
		//obt@TCY𒴂w̓G[
		if ((unsigned long)drawPrimitiveNum > primitiveNum) {
			result = YN_SET_ERR("Program error.", drawPrimitiveNum, primitiveNum);
			goto EXIT;
		}
		primitiveNum = drawPrimitiveNum;
	}

	//CfbNXtv~eBu̕`
	if (m_pIndexBuffer != NULL) {
		hresult = pD3DDevice->DrawIndexedPrimitive(
						m_PrimitiveType,	//v~eBu
						0,					//_obt@JnCfbNX
						0,					//_obt@ŏCfbNX
						m_VertexNum,		//QƂ钸_̐
						0,					//CfbNXobt@JnCfbNX
						primitiveNum		//v~eBu
					);
		if (FAILED(hresult)) {
			result = YN_SET_ERR("DirectX API error.", hresult, primitiveNum);
			goto EXIT;
		}
	}
	//CfbNXȂv~eBu̕`
	else {
		hresult = pD3DDevice->DrawPrimitive(
						m_PrimitiveType,	//v~eBu
						0,					//_obt@JnCfbNX
						primitiveNum		//v~eBu
					);
		if (FAILED(hresult)) {
			result = YN_SET_ERR("DirectX API error.", hresult, primitiveNum);
			goto EXIT;
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// _obt@bN
//******************************************************************************
int DXPrimitive::LockVertex(
		void** pPtrVertex,
		unsigned long offset,	//ȗ̓[
		unsigned long size		//ȗ̓[
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;

	if (m_IsVertexLocked) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	if ((m_VertexSize * m_VertexNum) < (offset + size)) {
		result = YN_SET_ERR("Program error.", offset, size);
		goto EXIT;
	}

	//_obt@̃bNƃobt@|C^擾
	if (m_pVertexBuffer != NULL) {
		hresult = m_pVertexBuffer->Lock(
						offset,		//bN钸_̃ItZbg
						size,		//bN钸_̃TCY(byte)
						pPtrVertex,	//obt@|C^
						0			//bLOtO
					);
		if (FAILED(hresult)) {
			result = YN_SET_ERR("DirectX API error.", hresult, (DWORD)pPtrVertex);
			goto EXIT;
		}
	}

	m_IsVertexLocked = true;

EXIT:;
	return result;
}

//******************************************************************************
// _obt@bN
//******************************************************************************
int DXPrimitive::UnlockVertex()
{
	int result = 0;
	HRESULT hresult = D3D_OK;
	
	if (m_IsVertexLocked) {
		if (m_pVertexBuffer != NULL) {
			hresult = m_pVertexBuffer->Unlock();
			if (FAILED(hresult)) {
				result = YN_SET_ERR("DirectX API error.", hresult, 0);
				goto EXIT;
			}
		}
		m_IsVertexLocked = false;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// CfbNXobt@bN
//******************************************************************************
int DXPrimitive::LockIndex(
		unsigned long** pPtrIndex,
		unsigned long offset,	//ȗ̓[
		unsigned long size		//ȗ̓[
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;

	if (m_IsIndexLocked) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	if ((sizeof(unsigned long) * m_IndexNum) < (offset + size)) {
		result = YN_SET_ERR("Program error.", offset, size);
		goto EXIT;
	}

	//CfbNXobt@̃bNƃobt@|C^擾
	if (m_pIndexBuffer != NULL) {
		hresult = m_pIndexBuffer->Lock(
						offset,		//bNCfbNX̃ItZbg(byte)
						size,		//bNCfbNX̃TCY(byte)
						(void**)pPtrIndex,	//obt@|C^
						0			//bLOtO
					);
		if (FAILED(hresult)) {
			result = YN_SET_ERR("DirectX API error.", hresult, (DWORD)pPtrIndex);
			goto EXIT;
		}
	}

	m_IsIndexLocked = true;

EXIT:;
	return result;
}

//******************************************************************************
// CfbNXobt@bN
//******************************************************************************
int DXPrimitive::UnlockIndex()
{
	int result = 0;
	HRESULT hresult = D3D_OK;

	if (m_IsIndexLocked) {
		if (m_pIndexBuffer != NULL) {
			hresult = m_pIndexBuffer->Unlock();
			if (FAILED(hresult)) {
			result = YN_SET_ERR("DirectX API error.", hresult, 0);
				goto EXIT;
			}
		}
		m_IsIndexLocked = false;
	}

EXIT:;
	return result;
}

//******************************************************************************
// v~eBu擾
//******************************************************************************
int DXPrimitive::_GetPrimitiveNum(
		unsigned long* pNum
	)
{
	int result = 0;
	unsigned long vertexNum = 0;

	vertexNum = m_VertexNum;
	if (m_pIndexBuffer != NULL) {
		vertexNum = m_IndexNum;
	}

	if (vertexNum == 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	switch (m_PrimitiveType) {
		case D3DPT_POINTLIST:
			*pNum = vertexNum;
			break;
			
		case D3DPT_LINELIST:
			if ((vertexNum % 2) != 0) {
				result = YN_SET_ERR("Program error.", vertexNum, 0);
				goto EXIT;
			}
			*pNum = vertexNum / 2;
			break;
			
		case D3DPT_LINESTRIP:
			if (vertexNum < 2) {
				result = YN_SET_ERR("Program error.", vertexNum, 0);
				goto EXIT;
			}
			*pNum = vertexNum - 1;
			break;
			
		case D3DPT_TRIANGLELIST:
			if ((vertexNum % 3) != 0) {
				result = YN_SET_ERR("Program error.", vertexNum, 0);
				goto EXIT;
			}
			*pNum = vertexNum / 3;
			break;
			
		case D3DPT_TRIANGLESTRIP:
			if (vertexNum < 3) {
				result = YN_SET_ERR("Program error.", vertexNum, 0);
				goto EXIT;
			}
			*pNum = vertexNum - 2;
			break;
			
		case D3DPT_TRIANGLEFAN:
			if (vertexNum < 3) {
				result = YN_SET_ERR("Program error.", vertexNum, 0);
				goto EXIT;
			}
			*pNum = vertexNum - 2;
			break;
	}

EXIT:;
	return result;
}

//******************************************************************************
// ftHg}eA
//******************************************************************************
void DXPrimitive::_GetDefaultMaterial(
		D3DMATERIAL9* pMaterial
	)
{
	ZeroMemory(pMaterial, sizeof(D3DMATERIAL9));

	//gU
	pMaterial->Diffuse.r = 1.0f;
	pMaterial->Diffuse.g = 1.0f;
	pMaterial->Diffuse.b = 1.0f;
	pMaterial->Diffuse.a = 1.0f;
	//Fe̐F
	pMaterial->Ambient.r = 0.5f;
	pMaterial->Ambient.g = 0.5f;
	pMaterial->Ambient.b = 0.5f;
	pMaterial->Ambient.a = 1.0f;
	//ʔˌ
	pMaterial->Specular.r = 0.0f;
	pMaterial->Specular.g = 0.0f;
	pMaterial->Specular.b = 0.0f;
	pMaterial->Specular.a = 0.0f;
	//ʔˌ̑Nx
	pMaterial->Power = 0.0f;
	//F
	pMaterial->Emissive.r = 0.0f;
	pMaterial->Emissive.g = 0.0f;
	pMaterial->Emissive.b = 0.0f;
	pMaterial->Emissive.a = 0.0f;
}


