//******************************************************************************
//
// MIDITrail / DXRenderer
//
// _NX
//
// Copyright (C) 2010-2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "stdafx.h"
#include "YNBaseLib.h"
#include "DXScene.h"
#include "DXRenderer.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
DXRenderer::DXRenderer()
{
	m_hWnd = NULL;
	m_pD3D = NULL;
	m_pD3DDevice = NULL;
}

//******************************************************************************
// fXgN^
//******************************************************************************
DXRenderer::~DXRenderer()
{
	Terminate();
}

//******************************************************************************
// 
//******************************************************************************
int DXRenderer::Initialize(
		HWND hWnd,
		unsigned long multiSampleType	//ȗ̓[FA`GCAVO
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;
	D3DDISPLAYMODE dispMode;
	bool isSupport = false;
	D3DMULTISAMPLE_TYPE type = D3DMULTISAMPLE_NONE;
	unsigned long qualityLevels = 0;

	m_hWnd = hWnd;

	if (DX_MULTI_SAMPLE_TYPE_MAX < multiSampleType) {
		result = YN_SET_ERR("Program error.", multiSampleType, 0);
		goto EXIT;
	}

	//Direct3D9IuWFNg쐬
	m_pD3D = Direct3DCreate9(D3D_SDK_VERSION);
	if (m_pD3D == NULL) {
		result = YN_SET_ERR("DirectX API error.", 0, 0);
		goto EXIT;
	}

	//fBXvC[h擾
	hresult = m_pD3D->GetAdapterDisplayMode(
					D3DADAPTER_DEFAULT,	//₢킹ΏۃfBXvCA_v^
					&dispMode			//fBXvC[h
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//v[e[Vp[^
	ZeroMemory(&m_D3DPP, sizeof(D3DPRESENT_PARAMETERS));
	m_D3DPP.BackBufferCount = 1;					//obt@
	m_D3DPP.Windowed = TRUE;						//EChE\̎w
	m_D3DPP.BackBufferFormat = dispMode.Format;		//obt@T[tFXtH[}bg
	m_D3DPP.SwapEffect = D3DSWAPEFFECT_DISCARD;		//_uobt@OXbvw
	m_D3DPP.EnableAutoDepthStencil = TRUE;			//[xXeVobt@쐬
	m_D3DPP.AutoDepthStencilFormat = D3DFMT_D16;	//[xXeVT[tFXtH[}bg

	//A`GCAVOL
	if (multiSampleType >= DX_MULTI_SAMPLE_TYPE_MIN) {
		//A`GCAVOw肠
		//n[hEFÃA`GCAVOT|[g󋵂mF
		type = _EnumMultiSampleType(multiSampleType);
		result = _CheckAntialiasSupport(
						m_D3DPP,			//v[e[Vp[^
						type,				//}`Tv
						&isSupport,			//T|[gmF
						&qualityLevels		//ix
					);
		if (result != 0) goto EXIT;
		
		//w肳ꂽ}`TvT|[gĂꍇ
		//v[e[Vp[^ɔf
		if (isSupport) {
			m_D3DPP.MultiSampleType = type;
			m_D3DPP.MultiSampleQuality = qualityLevels - 1;
		}
	}

	//fBXvCA_v^foCX쐬i`Fn[h^_Fn[hj
	hresult = m_pD3D->CreateDevice(
					D3DADAPTER_DEFAULT,	//fBXvCA_v^
					D3DDEVTYPE_HAL,		//foCX^CvFn[hEFAX^
					hWnd,				//tH[JXΏۃEBhEnh
					D3DCREATE_HARDWARE_VERTEXPROCESSING,
										//tOFn[hEFA_
					&m_D3DPP,			//v[e[Vp[^
					&m_pD3DDevice		//쐬ꂽfoCX
				);
	if (FAILED(hresult)) {
		//sĂ̕@
	}
	else {
		//I
		goto EXIT;
	}

	//fBXvCA_v^foCX쐬i`Fn[h^_FCPUj
	hresult = m_pD3D->CreateDevice(
					D3DADAPTER_DEFAULT,	//fBXvCA_v^
					D3DDEVTYPE_HAL,		//foCX^CvFn[hEFAX^
					hWnd,				//tH[JXΏۃEBhEnh
					D3DCREATE_SOFTWARE_VERTEXPROCESSING,
										//tOF\tgEFA_
					&m_D3DPP,			//v[e[Vp[^
					&m_pD3DDevice		//쐬ꂽfoCX
				);
	if (FAILED(hresult)) {
		//sĂ̕@
	}
	else {
		//I
		goto EXIT;
	}

	//HALȊOł̓A`GCAVO͖ɂ
	m_D3DPP.MultiSampleType = D3DMULTISAMPLE_NONE;
	m_D3DPP.MultiSampleQuality = 0;

	//fBXvCA_v^foCX쐬i`FCPU^_FCPUj
	hresult = m_pD3D->CreateDevice(
					D3DADAPTER_DEFAULT,	//fBXvCA_v^
					D3DDEVTYPE_REF,		//foCX^CvF\tgEFA
					hWnd,				//tH[JXΏۃEBhEnh
					D3DCREATE_SOFTWARE_VERTEXPROCESSING,
										//tOF\tgEFA_
					&m_D3DPP,			//v[e[Vp[^
					&m_pD3DDevice		//쐬ꂽfoCX
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// foCX擾
//******************************************************************************
LPDIRECT3DDEVICE9 DXRenderer::GetDevice()
{
	return m_pD3DDevice;
}

//*****************************************************************************
// V[`
//******************************************************************************
int DXRenderer::RenderScene(
		DXScene* pScene
	)
{
	int result = 0;
	HRESULT hresult = 0;

	if (pScene == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//r[|[gNA{[xobt@NA{XeVobt@폜
	hresult = m_pD3DDevice->Clear(
					0,						//`FS
					NULL, 					//NAΏۋ`FS
					D3DCLEAR_TARGET			//_O^[QbgNA
					| D3DCLEAR_ZBUFFER, 	//[xobt@NA
					D3DCOLOR_XRGB(0,0,0), 	//ݒF(ARGB)F
					//D3DCOLOR_XRGB(255,255,255), 		//ݒF(ARGB)F
					1.0f, 					//[xobt@ݒl
					0						//XeVobt@ݒl
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//`Jn
	hresult = m_pD3DDevice->BeginScene();
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//`
	result = pScene->Draw(m_pD3DDevice);
	if (result != 0) {
		//sĂ`^𑱍s
		YN_SHOW_ERR(m_hWnd);
	}

	//`I
	hresult = m_pD3DDevice->EndScene();
	if (FAILED(hresult)) {
		//`sĂ`^𑱍s
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		YN_SHOW_ERR(m_hWnd);
	}

	//`挋ʓ]
	hresult = m_pD3DDevice->Present(
						NULL,	//]`F]T[tFCXŜ\
						NULL,	//]`FNCAg̈S
						NULL,	//]EBhEnhFv[e[Vp[^ɏ]
						NULL	//XVΏۋ`iœKxpj
					);
	if (FAILED(hresult)) {
		//foCXXg
		if (hresult == D3DERR_DEVICELOST) {
			result = DXRENDERER_ERR_DEVICE_LOST;
			goto EXIT;

			//Jo
			//result = _RecoverDevice();
			//if (result != 0) goto EXIT;
		}
		else {
			result = YN_SET_ERR("DirectX API error.", hresult, 0);
			goto EXIT;
		}
	}

EXIT:;
	return result;
}

//*****************************************************************************
// I
//******************************************************************************
void DXRenderer::Terminate()
{
	if (m_pD3DDevice != NULL) {
		m_pD3DDevice->Release();
		m_pD3DDevice = NULL;
	}
	if (m_pD3D != NULL) {
		m_pD3D->Release();
		m_pD3D = NULL;
	}
	m_hWnd = NULL;
}

//*****************************************************************************
// foCXXgJo
//******************************************************************************
int DXRenderer::_RecoverDevice()
{
	int result = 0;
	HRESULT hresult = D3D_OK;

	//foCXXgɑΏɂ
	//  (1) foCXZbg\ɂȂ܂ő҂
	//      `揈APIĂяo͐邪ۂ͉Ȃ
	//  (2) foCXZbg\ɂȂ烊Zbg
	//  (3) Zbg烊\[Xjčč\z
	//      _obt@^CfbNXobt@^eNX`Ȃ
	//
	//(3)̎炢̂Ō_͖ΉƂ

	//foCX̓Ԃ擾
	hresult = m_pD3DDevice->TestCooperativeLevel();
	if (hresult == D3D_OK) {
		//퓮쒆̂߃Josv
	}
	else {
		//foCXXg
		if (hresult == D3DERR_DEVICELOST) {
			//܂ZbgłȂ̂ŕu
		}
		//Zbg\
		else if (hresult == D3DERR_DEVICENOTRESET) {
			//foCXZbg
			hresult = m_pD3DDevice->Reset(&m_D3DPP);
			if (FAILED(hresult)) {
				result = YN_SET_ERR("DirectX API error.", hresult, 0);
				goto EXIT;
			}
			//S\[Xj
			// TODO: EEEǂ܂
			//S\[XĐ
			// TODO: EEEǂ܂
		}
		//G[
		else if (D3DERR_DRIVERINTERNALERROR) {
			result = YN_SET_ERR("DirectX API error.", hresult, 0);
			goto EXIT;
		}
		//m̃G[
		else {
			result = YN_SET_ERR("DirectX API error.", hresult, 0);
			goto EXIT;
		}
	}

EXIT:;
	return result;
}

//*****************************************************************************
// A`GCAVOT|[g`FbN
//******************************************************************************
int DXRenderer::_CheckAntialiasSupport(
		D3DPRESENT_PARAMETERS d3dpp,
		D3DMULTISAMPLE_TYPE multiSampleType,
		bool* pIsSupport,
		unsigned long* pQualityLevels
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;
	unsigned long qualityLevelsBackBuffer = 0;
	unsigned long qualityLevelsZBuffer = 0;
	bool isSupportBackBuffer = false;
	bool isSupportZbuffer = false;

	//n[hEFÃA`GCAVOT|[g󋵂̂݊mF

	//obNobt@tH[}bg̃A`GCAVOT|[gmF
	hresult = m_pD3D->CheckDeviceMultiSampleType(
					D3DADAPTER_DEFAULT,			//₢킹ΏۃfBXvCA_v^
					D3DDEVTYPE_HAL,				//foCX^CvFn[hEFA
					d3dpp.BackBufferFormat,		//T[tFCXtH[}bg
					d3dpp.Windowed,				//EBhE
					multiSampleType,			//}`TvOeNjbN
					&qualityLevelsBackBuffer	//p\ȕix̐Fsv
				);
	if (SUCCEEDED(hresult)) {
		//T|[gĂ
		isSupportBackBuffer = true;
	}

	//[xobt@tH[}bg̃A`GCAVOT|[gmF
	hresult = m_pD3D->CheckDeviceMultiSampleType(
					D3DADAPTER_DEFAULT,			//₢킹ΏۃfBXvCA_v^
					D3DDEVTYPE_HAL,				//foCX^CvFn[hEFA
					d3dpp.BackBufferFormat,		//T[tFCXtH[}bg
					d3dpp.Windowed,				//EBhE
					multiSampleType,			//}`TvOeNjbN
					&qualityLevelsZBuffer		//p\ȕix̐Fsv
				);
	if (SUCCEEDED(hresult)) {
		//T|[gĂ
		isSupportZbuffer = true;
	}

	//A`GCAVO`FbN
	*pIsSupport = false;
	*pQualityLevels = 0;
	if (isSupportBackBuffer && isSupportZbuffer) {
		*pIsSupport = true;
		if (qualityLevelsBackBuffer < qualityLevelsZBuffer) {
			*pQualityLevels = qualityLevelsBackBuffer;
		}
		else {
			*pQualityLevels = qualityLevelsZBuffer;
		}
	}

	return result;
}

//*****************************************************************************
// }`Tvʎ擾
//******************************************************************************
D3DMULTISAMPLE_TYPE DXRenderer::_EnumMultiSampleType(
		unsigned long multiSampleNum
	)
{
	D3DMULTISAMPLE_TYPE type = D3DMULTISAMPLE_NONE;
	D3DMULTISAMPLE_TYPE types[] = {
			D3DMULTISAMPLE_2_SAMPLES,  D3DMULTISAMPLE_3_SAMPLES,  D3DMULTISAMPLE_4_SAMPLES,
			D3DMULTISAMPLE_5_SAMPLES,  D3DMULTISAMPLE_6_SAMPLES,  D3DMULTISAMPLE_7_SAMPLES,
			D3DMULTISAMPLE_8_SAMPLES,  D3DMULTISAMPLE_9_SAMPLES,  D3DMULTISAMPLE_10_SAMPLES,
			D3DMULTISAMPLE_11_SAMPLES, D3DMULTISAMPLE_12_SAMPLES, D3DMULTISAMPLE_13_SAMPLES,
			D3DMULTISAMPLE_14_SAMPLES, D3DMULTISAMPLE_15_SAMPLES, D3DMULTISAMPLE_16_SAMPLES
		};

	if ((DX_MULTI_SAMPLE_TYPE_MIN <= multiSampleNum)
	 && (multiSampleNum <= DX_MULTI_SAMPLE_TYPE_MAX)) {
		type = types[multiSampleNum - 2];
	}

	return type;
}

//*****************************************************************************
// A`GCAVOT|[g`FbN
//******************************************************************************
int DXRenderer::IsSupportAntialias(
		unsigned long multiSampleType,
		bool* pIsSupport
	)
{
	int result = 0;
	unsigned long qualityLevels = 0;

	if (m_pD3D == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	if (pIsSupport == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	if ((multiSampleType < DX_MULTI_SAMPLE_TYPE_MIN)
	 || (DX_MULTI_SAMPLE_TYPE_MAX < multiSampleType)) {
		result = YN_SET_ERR("Program error.", multiSampleType, 0);
		goto EXIT;
	}

	result = _CheckAntialiasSupport(
					m_D3DPP,
					_EnumMultiSampleType(multiSampleType),
					pIsSupport,
					&qualityLevels
				);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//*****************************************************************************
// CfbNXobt@T|[g`FbN
//******************************************************************************
int DXRenderer::IsSupportIndexBuffer(
		bool* pIsSupport,
		unsigned long* pMaxVertexIndex
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;
	D3DCAPS9 caps;

	if (m_pD3D == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	if ((pIsSupport == NULL) || (pMaxVertexIndex == NULL)) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	*pIsSupport = false;

	//foCX擾
	hresult = m_pD3D->GetDeviceCaps(
					D3DADAPTER_DEFAULT,	//₢킹ΏۃfBXvCA_v^
					D3DDEVTYPE_HAL,		//foCX^CvFn[hEFA
					&caps				//foCX\͏
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	*pMaxVertexIndex = caps.MaxVertexIndex;

	if (caps.MaxVertexIndex > 0x0000FFFF) {
		//CfbNXobt@T|[gĂ
		*pIsSupport = true;
	}

EXIT:;
	return result;
}


