//******************************************************************************
//
// MIDITrail / MTScene
//
// MIDITrail V[NX
//
// Copyright (C) 2010-2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "DXScene.h"
#include "SMIDILib.h"
#include <string>

using namespace SMIDILib;


//******************************************************************************
// MIDITrail V[NX
//******************************************************************************
class MTScene : public DXScene
{
public:

	enum EffectType {
		EffectPianoKeyboard,
		EffectRipple,
		EffectPitchBend,
		EffectStars,
		EffectCounter
	};

	typedef std::map<std::string, float>  MTViewParamMap;
	typedef std::pair<std::string, float> MTViewParamMapPair;

public:

	//RXgN^^fXgN^
	MTScene(void);
	virtual ~MTScene(void);

	//̎擾
	virtual const TCHAR* GetName();

	//
	virtual int Create(
					HWND hWnd,
					LPDIRECT3DDEVICE9 pD3DDevice,
					SMSeqData* pSeqData
				);

	//ϊ
	virtual int Transform(LPDIRECT3DDEVICE9 pD3DDevice);

	//`
	virtual int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//j
	virtual void Release();

	//EBhENbNCxgM
	virtual int OnWindowClicked(
					unsigned long button,
					unsigned long wParam,
					unsigned long lParam
				);

	//tJnCxgM
	virtual int OnPlayStart();

	//tICxgM
	virtual int OnPlayEnd();

	//V[PTbZ[WM
	virtual int OnRecvSequencerMsg(
					unsigned long wParam,
					unsigned long lParam
				);

	//߂
	virtual int Rewind();

	//_擾^o^
	virtual void GetDefaultViewParam(MTViewParamMap* pParamMap);
	virtual void GetViewParam(MTViewParamMap* pParamMap);
	virtual void SetViewParam(MTViewParamMap* pParamMap);

	//_Zbg
	virtual void ResetViewpoint();

	//\ʐݒ
	virtual void SetEffect(EffectType type, bool isEnable);

	//txݒ
	virtual void SetPlaySpeedRatio(unsigned long ratio);

};


