//******************************************************************************
//
// Simple MIDI Library / SMMsgTransmitter
//
// Cxg]NX
//
// Copyright (C) 2010-2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "SMMsgTransmitter.h"

using namespace YNBaseLib;

namespace SMIDILib {


//******************************************************************************
// RXgN^
//******************************************************************************
SMMsgTransmitter::SMMsgTransmitter(void)
{
}

//******************************************************************************
// fXgN^
//******************************************************************************
SMMsgTransmitter::~SMMsgTransmitter(void)
{
}

//******************************************************************************
// 
//******************************************************************************
int SMMsgTransmitter::Initialize(
		HWND hTargetWnd,
		unsigned long msgId
	)
{
	m_hTargetWnd = hTargetWnd;
	m_MsgId = msgId;
	return 0;
}

//******************************************************************************
// tԒʒm
//******************************************************************************
int SMMsgTransmitter::PostPlayStatus(
		unsigned long playStatus
	)
{
	int result = 0;

	if (m_hTargetWnd == NULL) goto EXIT;

	result = _Post(SM_MSG_PLAY_STATUS, 0, playStatus);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// tʒuʒm
//******************************************************************************
int SMMsgTransmitter::PostPlayTime(
		unsigned long playTimeMSec,
		unsigned long tickTime
	)
{
	int result = 0;

	//|Xgłf[^TCY̐邽߉t(msec)3byte܂łƂ
	//  0x00FFFFFF = 16777215 msec = 16777 sec = 279 min = 4.6 hour
	//̎Ԃzꍇ̓Nbv
	if (playTimeMSec > 0x00FFFFFF) {
		playTimeMSec = 0x00FFFFFF;
	}

	result = _Post(SM_MSG_TIME, playTimeMSec, tickTime);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// e|ʒm
//******************************************************************************
int SMMsgTransmitter::PostTempo(
		unsigned long tempo
	)
{
	int result = 0;

	result = _Post(SM_MSG_TEMPO, 0, tempo);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ߔԍʒm
//******************************************************************************
int SMMsgTransmitter::PostBar(
		unsigned long barNo
	)
{
	int result = 0;

	result = _Post(SM_MSG_BAR, 0, barNo);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// qLʒm
//******************************************************************************
int SMMsgTransmitter::PostBeat(
		unsigned short numerator,
		unsigned short denominator
	)
{
	int result = 0;
	unsigned long param = 0;

	param = ((unsigned long)numerator << 16) | denominator;

	result = _Post(SM_MSG_BEAT, 0, param);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// m[gOFFʒm
//******************************************************************************
int SMMsgTransmitter::PostNoteOff(
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo
	)
{
	int result = 0;
	unsigned long param = 0;

	param = (portNo << 24) | (chNo << 16) | (noteNo << 8) | 0;

	result = _Post(SM_MSG_NOTE_OFF, 0, param);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// m[gONʒm
//******************************************************************************
int SMMsgTransmitter::PostNoteOn(
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo,
		unsigned char velocity
	)
{
	int result = 0;
	unsigned long param = 0;

	param = (portNo << 24) | (chNo << 16) | (noteNo << 8) | velocity;

	result = _Post(SM_MSG_NOTE_ON, 0, param);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// sb`xhʒm
//******************************************************************************
int SMMsgTransmitter::PostPitchBend(
		unsigned char portNo,
		unsigned char chNo,
		short pitchBendValue,
		unsigned char pitchBendSensitivity
	)
{
	int result = 0;
	unsigned long param = 0;

	param = (portNo << 24) | (chNo << 16) | ((unsigned short)pitchBendValue);

	result = _Post(SM_MSG_PITCHBEND, pitchBendSensitivity, param);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// XLbvJnʒm
//******************************************************************************
int SMMsgTransmitter::PostSkipStart(
		unsigned long skipDirection
	)
{
	int result = 0;
	
	result = _Post(SM_MSG_SKIP_START, 0, skipDirection);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// XLbvJnʒm
//******************************************************************************
int SMMsgTransmitter::PostSkipEnd(
		unsigned long notesCount
	)
{
	int result = 0;
	
	result = _Post(SM_MSG_SKIP_END, 0, notesCount);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// bZ[Wʒm
//******************************************************************************
int SMMsgTransmitter::_Post(
		unsigned char event,
		unsigned long param1, //3byte܂
		unsigned long param2  //4byte܂
	)
{
	int result = 0;
	unsigned long wparam = 0;
	unsigned long lparam = 0;
	BOOL bresult = false;

	wparam = ((unsigned long)event << 24) | (param1 & 0x00FFFFFF);
	lparam = param2;

	if (m_hTargetWnd == NULL) goto EXIT;

	bresult = PostMessage(
					m_hTargetWnd,	//MEBhEnh
					m_MsgId,		//bZ[W
					wparam,			//WParam
					lparam			//LParam
				);
	if (!bresult)	{
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

} // end of namespace

