//******************************************************************************
//
// Simple MIDI Library / SMDevInfo
//
// MIDIデバイス情報クラス
//
// Copyright (C) 2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "SMDevInfo.h"


//******************************************************************************
// 初期化
//******************************************************************************
SMDevInfo::SMDevInfo(void)
{
	m_pDisplayName = nil;
	m_pIdName = nil;
	m_EndpointRef = 0;
}

//******************************************************************************
// 破棄
//******************************************************************************
SMDevInfo::~SMDevInfo(void)
{
	[m_pDisplayName release];
	[m_pIdName release];
	
	//エンドポイントを破棄してはならない
	//  「MIDIスタジオ」の設定が変わってしまう
	//  デバイスとエンドポイント間のケーブルが切断される
	//if (m_EndPointRef != NULL) {
	//	MIDIEndpointDispose(m_EndpointRef);
	//	m_EndPointRef = nil;
	//}
}

//******************************************************************************
// 表示名称登録
//******************************************************************************
void SMDevInfo::SetDisplayName(
		NSString* pDisplayName
	)
{
	[pDisplayName retain];
	[m_pDisplayName release];
	m_pDisplayName = pDisplayName;
}

//******************************************************************************
// 識別名称登録："メーカー名/モデル名/エンドポイントプロパティ名"
//******************************************************************************
void SMDevInfo::SetIdName(
		NSString* pIdName
	)
{
	[pIdName retain];
	[m_pIdName release];
	m_pIdName = pIdName;
}

//******************************************************************************
// エンドポイント登録
//******************************************************************************
void SMDevInfo::SetEndpointRef(
		MIDIEndpointRef endpointRef
	)
{
	m_EndpointRef = endpointRef;
}

//******************************************************************************
// 表示名称取得
//******************************************************************************
NSString* SMDevInfo::GetDisplayName()
{
	return m_pDisplayName;
}

//******************************************************************************
// 識別名称取得
//******************************************************************************
NSString* SMDevInfo::GetIdName()
{
	return m_pIdName;
}

//******************************************************************************
// エンドポイント取得
//******************************************************************************
MIDIEndpointRef SMDevInfo::GetEndpointRef()
{
	return m_EndpointRef;
}


