//******************************************************************************
//
// MIDITrail / MTFont2Bmp
//
// tHgrbg}bvϊNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTFont2Bmp.h"
#include <new>

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTFont2Bmp::MTFont2Bmp(void)
{
	m_FontName[0] = _T('\0');
	m_FontSize = 0;
	m_isForceFixedPitch = false;
	m_hFont = NULL;
	m_pBmpBuf = NULL;
	ZeroMemory(&m_TextMetric, sizeof(TEXTMETRIC));
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTFont2Bmp::~MTFont2Bmp(void)
{
	Clear();
}

//******************************************************************************
// NA
//******************************************************************************
void MTFont2Bmp::Clear()
{
	MTGlyphBmpList::iterator itr;

	if (m_hFont != NULL) {
		DeleteObject(m_hFont);
		m_hFont = NULL;
	}

	for (itr = m_GlyphBmpList.begin(); itr != m_GlyphBmpList.end(); itr++) {
		delete [] (itr->pBmp);
	}
	m_GlyphBmpList.clear();

	delete [] m_pBmpBuf;
	m_pBmpBuf = NULL;
}

//******************************************************************************
// tHgݒ
//******************************************************************************
int MTFont2Bmp::SetFont(
		const TCHAR* pFontName,
		unsigned long fontSize,
		bool isForceFixedPitch
	)
{
	int result = 0;
	errno_t eresult = 0;

	eresult = _tcscpy_s(m_FontName, LF_FACESIZE, pFontName);
	if (eresult != 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	m_FontSize = fontSize;
	m_isForceFixedPitch = isForceFixedPitch;

EXIT:;
	return result;
}

//******************************************************************************
// BMP쐬
//******************************************************************************
int MTFont2Bmp::CreateBmp(
		const TCHAR* pStr
	)
{
	int result = 0;

	Clear();

	//_tHg쐬
	result = _CreateLogFont();
	if (result != 0) goto EXIT;

	//OtBMPXg쐬
	result = _CreateGlyphBmpList(pStr);
	if (result != 0) goto EXIT;

	//Ŝ̃obt@쐬
	result = _CreateBmpBuf();
	if (result != 0) goto EXIT;

	//obt@ɃOtBMP
	result = _WriteGlyphToBmpBuf();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// BMPTCY擾
//******************************************************************************
void MTFont2Bmp::GetBmpSize(
		unsigned long* pHeight,
		unsigned long* pWidth
	)
{
	*pHeight = m_BmpHeight;
	*pWidth = m_BmpWidth;
}

//******************************************************************************
// BMPsNZl擾
//******************************************************************************
BYTE MTFont2Bmp::GetBmpPixcel(
		unsigned long x,
		unsigned long y
	)
{
	BYTE pixcel = 0xFF;

	if (m_pBmpBuf == NULL) goto EXIT;

	if ((x >= m_BmpWidth) || (y >= m_BmpHeight)) goto EXIT;

	pixcel = m_pBmpBuf[y*m_BmpWidth + x];

EXIT:;
	return pixcel;
}

//******************************************************************************
// _tHg쐬
//******************************************************************************
int MTFont2Bmp::_CreateLogFont()
{
	int result = 0;
	LOGFONT logfont;

	//_tHg𐶐
	ZeroMemory(&logfont, sizeof(LOGFONT));
	logfont.lfHeight         = m_FontSize;			//
	logfont.lfWidth          = 0;					//
	logfont.lfEscapement     = 0;					//px
	logfont.lfOrientation    = 0;					//px
	logfont.lfWeight         = 0;					//EFCg
	logfont.lfItalic         = FALSE;				//C^bN
	logfont.lfUnderline      = FALSE;				//A_[C
	logfont.lfStrikeOut      = FALSE;				//XgCNAEg
	logfont.lfCharSet        = DEFAULT_CHARSET;		//LN^Zbg
	logfont.lfOutPrecision   = OUT_TT_ONLY_PRECIS;	//o͐xFTrueTypetHggpi݂Ȃ΃ftHg̓j
	logfont.lfClipPrecision  = CLIP_DEFAULT_PRECIS;	//NbsOxFftHgw
	logfont.lfQuality        = PROOF_QUALITY;		//iFtHg`iD
	logfont.lfPitchAndFamily = DEFAULT_PITCH		//sb`FftHg
								| FF_DONTCARE;		//t@~FʓIȃt@~
	_tcscpy_s(logfont.lfFaceName, LF_FACESIZE, m_FontName);

	if (m_isForceFixedPitch) {
		logfont.lfPitchAndFamily = FIXED_PITCH | FF_DONTCARE;
	}

	//_tHg
	m_hFont = CreateFontIndirect(&logfont);
	if (m_hFont == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// OtBMP쐬
//******************************************************************************
int MTFont2Bmp::_CreateGlyphBmp(
		unsigned long code,
		MTGlyphBmp* pGlyphBmp
	)
{
	int result = 0;
	HDC hDC = NULL;
	BOOL bresult = FALSE;
	HFONT hOldFont = NULL;
	unsigned long size = 0;
	unsigned char* pBuf = NULL;
	GLYPHMETRICS glyphMetric;
	CONST MAT2 mat = {{0,1},{0,0},{0,0},{0,1}};

	//foCXReLXg擾
	hDC = GetDC(NULL);
	if (hDC == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//foCXReLXgɘ_tHgݒ
	hOldFont = (HFONT)SelectObject(hDC, m_hFont);
	if (hOldFont == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)hDC);
		goto EXIT;
	}

	//eLXggNX擾
	bresult = GetTextMetrics(hDC, &m_TextMetric);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)hDC);
		goto EXIT;
	}

	//rbg}bv쐬ɕKvȃobt@TCY擾
	size = GetGlyphOutline(
					hDC,				//foCXReLXg
					code,				//FTODO:TQ[g͈ȂHH
					GGO_GRAY4_BITMAP,	//tH[}bgFrbg}bviOCx17ij
					&glyphMetric,		//OtgNXF쐬ꂽZ̏񂪓
					0,					//obt@TCYF[w肵ĕKvȃTCY𓾂
					NULL,				//obt@ʒu
					&mat				//ϊs
				);
	if (size < 0) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)hDC);
		goto EXIT;
	}
	
	//󔒕̏ꍇ̓rbg}bv쐬Ȃ
	if (size == 0) {
		//OtBMP
		pGlyphBmp->glyphMetric = glyphMetric;
		pGlyphBmp->bmpHeight   = 0;
		pGlyphBmp->bmpWidth    = 0;
		pGlyphBmp->pBmp        = NULL;
	}
	//󔒕ȊO̓rbg}bv쐬
	else {

		//rbg}bv쐬ɕKvȃ̈mۂ
		try {
			pBuf = new BYTE[size];
		}
		catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", size, 0);
			goto EXIT;
		}

		//TrueTypetHgrbg}bv쐬
		size = GetGlyphOutline(
						hDC,				//foCXReLXg
						code,				//FTODO:TQ[g͈ȂHH
						GGO_GRAY4_BITMAP,	//tH[}bgFrbg}bviOCx17ij
						&glyphMetric,		//OtgNXF쐬ꂽZ̏񂪓
						size,				//obt@TCY
						pBuf,				//obt@ʒu
						&mat				//ϊs
					);
		if (size <= 0) {
			result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
			goto EXIT;
		}
		//OtBMPFBMP4̔{ł邱Ƃӎ
		pGlyphBmp->glyphMetric = glyphMetric;
		pGlyphBmp->bmpHeight   = glyphMetric.gmBlackBoxY;
		pGlyphBmp->bmpWidth    = glyphMetric.gmBlackBoxX + (4 - (glyphMetric.gmBlackBoxX % 4)) % 4;
		pGlyphBmp->pBmp        = pBuf;
	}
	pBuf = NULL;

EXIT:;
	delete [] pBuf;
	if (hDC != NULL) {
		if (hOldFont != NULL) {
			SelectObject(hDC, hOldFont);
		}
		ReleaseDC(NULL, hDC);
	}
	return result;
}

//******************************************************************************
// OtBMPXg쐬
//******************************************************************************
int MTFont2Bmp::_CreateGlyphBmpList(
		const TCHAR* pStr
	)
{
	int result = 0;
	unsigned long code = 0;
	MTGlyphBmp glyphBmp;

#ifdef _UNICODE

	TCHAR* ptr = pStr;
	
	//1ƂɃOtBMP쐬
	while (ptr[0] != _T('\0')) {
		code = ptr[0];
		ptr += 1;

		//OtBMP쐬
		result = _CreateGlyphBmp(code, &glyphBmp);
		if (result != 0) goto EXIT;

		//񃊃Xgɓo^
		m_GlyphBmpList.push_back(glyphBmp);
	}

#else

	unsigned char* ptr = (unsigned char*)pStr;
	
	//1ƂɃOtBMP쐬
	while (ptr[0] != '\0') {
		if (IsDBCSLeadByte(ptr[0]) && (ptr[1] != '\0')) {
			code = (ptr[0] << 8) | ptr[1];
			ptr += 2;
		}
		else {
			code = ptr[0];
			ptr += 1;
		}

		//OtBMP쐬
		result = _CreateGlyphBmp(code, &glyphBmp);
		if (result != 0) goto EXIT;

		//񃊃Xgɓo^
		m_GlyphBmpList.push_back(glyphBmp);
	}

#endif

EXIT:;
	return result;
}

//******************************************************************************
// obt@쐬
//******************************************************************************
int MTFont2Bmp::_CreateBmpBuf()
{
	int result = 0;
	MTGlyphBmpList::iterator itr;
	
	//            |<- gmCellIncX ->|
	//  ----------0----------------+----->x
	//   ^  ^     |  |<---bx--->|  |
	//   |  | ----|--@----------+--|----  @ = (gmptGlyphOrigin.x, ta-gy)
	//   |  |  ^  |  | *       *|  | ^
	//   |  |  |  |  |  *     * |  | |    th: tmHeight
	//   th ta gy |  |   *   *  |  | by   ta: tmAscent
	//   |  |  |  |  |    * *   |  | |    gy: gmptGlyphOrigin.y
	//   |  v  v  |  |     *    |  | |    bx: gmBlackBoxX
	//   | =======|==|=== * ====|==| |    by: gmBlackBoxY
	//   |        |  |   *      |  | v    ==: base line
	//   |        |--+----------+--|----
	//   v        |  |          |  |
	//  ----------+----------------+
	//            |
	//            v
	//            y

	//
	m_BmpHeight = m_TextMetric.tmHeight;

	//
	m_BmpWidth = 0;
	for (itr = m_GlyphBmpList.begin(); itr != m_GlyphBmpList.end(); itr++) {
		m_BmpWidth += (itr->glyphMetric.gmCellIncX);
	}
	//4̔{ɂ
	m_BmpWidth = m_BmpWidth + ((4 - (m_BmpWidth % 4)) % 4);

	//eNX`ƂċeʓIȃTCY𒴂ꍇ̓Nbv
	if (m_BmpWidth > MTFONT2BMP_MAX_BMP_WIDTH) {
		m_BmpWidth = MTFONT2BMP_MAX_BMP_WIDTH;
	}

	//BMPobt@
	try {
		m_pBmpBuf = new BYTE[(m_BmpHeight * m_BmpWidth)];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", m_BmpHeight, m_BmpWidth);
		goto EXIT;
	}
	ZeroMemory(m_pBmpBuf, (m_BmpHeight * m_BmpWidth));

EXIT:;
	return result;
}

//******************************************************************************
// OtBMPBMPobt@ɏ
//******************************************************************************
int MTFont2Bmp::_WriteGlyphToBmpBuf()
{
	int result = 0;
	MTGlyphBmpList::iterator itr;
	unsigned long offsetX = 0;
	unsigned long x = 0;
	unsigned long y = 0;
	unsigned long destX = 0;
	BYTE* pSrc = NULL;
	BYTE* pDest = NULL;

	for (itr = m_GlyphBmpList.begin(); itr != m_GlyphBmpList.end(); itr++) {

		//󕶎̓XLbv
		if (itr->pBmp == NULL) {
			offsetX += (itr->glyphMetric.gmCellIncX);
			continue;
		}

		//Rs[OtBMP̍W4̔{BMPTCYӎ
		//f[^͈̔͂ŃXL
		for (y = 0; y < (itr->glyphMetric.gmBlackBoxY); y++) {
			for (x = 0; x < (itr->glyphMetric.gmBlackBoxX); x++) {

				//Rs[̗̈OɂȂꍇ̓XLbv
				destX = offsetX + (itr->glyphMetric.gmptGlyphOrigin.x) + x;
				if (destX >= (m_BmpWidth-1)) continue;

				//Rs[sNZ|C^FBMPTCY4̔{ӎĎZo
				pSrc = itr->pBmp + (itr->bmpWidth * y) + x;

				//Rs[sNZ|C^
				pDest = m_pBmpBuf
							+ (m_TextMetric.tmAscent - (itr->glyphMetric.gmptGlyphOrigin.y) + y) * m_BmpWidth
							+ (offsetX + (itr->glyphMetric.gmptGlyphOrigin.x) + x);

				//mۂobt@zďƂĂȂ`FbN
				if (pDest > (m_pBmpBuf + (m_BmpHeight * m_BmpWidth) - 1)) {
					result = YN_SET_ERR("Program error.", itr->glyphMetric.gmBlackBoxY, itr->glyphMetric.gmBlackBoxX);
					goto EXIT;
				}

				//sNZRs[
				*pDest = *pSrc;
			}
		}
		offsetX += (itr->glyphMetric.gmCellIncX);
	}

EXIT:;
	return result;
}

