//******************************************************************************
//
// MIDITrail / MIDITrailApp
//
// MIDITrail AvP[VNX
//
// Copyright (C) 2010-2014 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "resource.h"
#include "Commdlg.h"
#include "YNBaseLib.h"
#include "SMIDILib.h"
#include "DXRenderer.h"
#include "MTScene.h"
#include "MTWindowSizeCfgDlg.h"
#include "MTMIDIOUTCfgDlg.h"
#include "MTMIDIINCfgDlg.h"
#include "MTGraphicCfgDlg.h"
#include "MTHowToViewDlg.h"
#include "MTAboutDlg.h"
#include "MTCmdLineParser.h"

using namespace YNBaseLib;
using namespace SMIDILib;


//******************************************************************************
// p[^`
//******************************************************************************
#define MAX_LOADSTRING  (100)

//EBhEX^C
//  WS_OVERLAPPEDWINDOW 玟̃X^C
//    WS_THICKFRAME   TCYύX
//    WS_MAXIMIZEBOX  ő剻{^
#define MIDITRAIL_WINDOW_STYLE  (WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX)

//㑱NvZX̃t@CpX|Xgʒm
#define WM_FILEPATH_POSTED  (WM_USER + 100)

//j[X^C
#define MT_MENU_NUM        (30)
#define MT_PLAYSTATUS_NUM  (6)

//foCXXgxbZ[W
#define MIDITRAIL_MSG_DEVICELOST  _T("Direct3D device is lost.")

//^C}[ID
#define MIDITRAIL_TIMER_CHECK_KEY  (1)

//dN}~p~[eNX
#define MIDITRAIL_MUTEX     _T("yknk.MIDITrail")

//[Xbg
#define MIDITRAIL_MAILSLOT  _T("\\\\.\\mailslot\\yknk\\MIDITrail")


//******************************************************************************
// MIDITrail AvP[VNX
//******************************************************************************
class MIDITrailApp
{
public:

	//RXgN^^fXgN^
	MIDITrailApp(void);
	virtual ~MIDITrailApp(void);

	//
	int Initialize(HINSTANCE hInstance, LPTSTR pCmdLine, int nCmdShow);

	//s
	int Run();

	//~
	int Terminate();

private:

	//----------------------------------------------------------------
	//p[^`
	//----------------------------------------------------------------
	//t
	enum PlayStatus {
		NoData,			//f[^Ȃ
		Stop,			//~
		Play,			//Đ
		Pause,			//ꎞ~
		MonitorOFF,		//j^~
		MonitorON		//j^
	};

	//V[
	//TAG:V[ǉ
	enum SceneType {
		Title,			//^Cg
		PianoRoll3D,	//sAm[3D
		PianoRoll2D,	//sAm[2D
		PianoRollRain,	//sAm[C
		PianoRollRain2D	//sAm[C2D
	};

	//V[PTbZ[W
	typedef struct {
		unsigned long param1;
		unsigned long param2;
	} MTSequencerMsg;

	//ŐVV[PTbZ[W
	typedef struct {
		bool isRecvPlayTime;
		bool isRecvTempo;
		bool isRecvBar;
		bool isRecvBeat;
		MTSequencerMsg playTime;
		MTSequencerMsg tempo;
		MTSequencerMsg bar;
		MTSequencerMsg beat;
	} MTSequencerLastMsg;

private:

	//----------------------------------------------------------------
	//o`
	//----------------------------------------------------------------
	//EBhEvV[Wp|C^
	static MIDITrailApp* m_pThis;

	//AvP[VCX^X
	HINSTANCE m_hInstance;

	//AvP[VdN}~
	HANDLE m_hAppMutex;
	HANDLE m_hMailSlot;
	bool m_isExitApp;

	//R}hCp[T
	MTCmdLineParser m_CmdLineParser;

	//EBhEn
	HWND m_hWnd;
	HACCEL m_Accel;
	TCHAR m_Title[MAX_LOADSTRING];
	TCHAR m_WndClassName[MAX_LOADSTRING];

	//_On
	DXRenderer m_Renderer;
	MTScene* m_pScene;
	unsigned long m_MultiSampleType;

	//FPS\n
	DWORD m_PrevTime;
	DWORD m_FPSCount;

	//MIDIn
	SMSeqData m_SeqData;
	SMSequencer m_Sequencer;
	SMRcpConv m_RcpConv;
	SMMsgQueue m_MsgQueue;
	SMLiveMonitor m_LiveMonitor;

	//t
	PlayStatus m_PlayStatus;
	bool m_isRepeat;
	bool m_isRewind;
	bool m_isOpenFileAfterStop;
	MTSequencerLastMsg m_SequencerLastMsg;
	unsigned long m_PlaySpeedRatio;

	//\
	bool m_isEnablePianoKeyboard;
	bool m_isEnableRipple;
	bool m_isEnablePitchBend;
	bool m_isEnableStars;
	bool m_isEnableCounter;
	bool m_isEnableFileName;

	//V[
	SceneType m_SceneType;
	SceneType m_SelectedSceneType;

	//EBhETCYݒ_CAO
	MTWindowSizeCfgDlg m_WindowSizeCfgDlg;

	//MIDI OUTݒ_CAO
	MTMIDIOUTCfgDlg m_MIDIOUTCfgDlg;

	//MIDI INݒ_CAO
	MTMIDIINCfgDlg m_MIDIINCfgDlg;

	//OtBbNݒ_CAO
	MTGraphicCfgDlg m_GraphicCfgDlg;

	//@_CAO
	MTHowToViewDlg m_HowToViewDlg;

	//o[W_CAO
	MTAboutDlg m_AboutDlg;

	//ݒt@C
	YNConfFile m_MIDIConf;
	YNConfFile m_ViewConf;
	YNConfFile m_GraphicConf;

	//v[[
	int m_AllowMultipleInstances;
	int m_AutoPlaybackAfterOpenFile;

	//XLbv
	int m_SkipBackTimeSpanInMsec;
	int m_SkipForwardTimeSpanInMsec;

	//tXs[h
	unsigned long m_SpeedStepInPercent;
	unsigned long m_MaxSpeedInPercent;

	//_ۑ
	bool m_isAutoSaveViewpoint;

	//I[vΏۃt@CpX
	TCHAR m_NextFilePath[_MAX_PATH];

	//----------------------------------------------------------------
	//\bh`
	//----------------------------------------------------------------
	//EBhE
	int _RegisterClass(HINSTANCE hInstance);
	int _CreateWindow(HINSTANCE hInstance, int nCmdShow);
	int _SetWindowSize();

	//ݒt@C
	int _InitConfFile();

	//EBhEvV[W
	static LRESULT CALLBACK _WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT _WndProcImpl(const HWND hWnd, const UINT message, const WPARAM wParam, const LPARAM lParam);

	//j[Cxg
	int _OnMenuFileOpen();
	int _OnMenuPlay();
	int _OnMenuStop();
	int _OnMenuRepeat();
	int _OnMenuSkipBack();
	int _OnMenuSkipForward();
	int _OnMenuPlaySpeedDown();
	int _OnMenuPlaySpeedUp();
	int _OnMenuStartMonitoring();
	int _OnMenuStopMonitoring();
	int _OnMenuAutoSaveViewpoint();
	int _OnMenuResetViewpoint();
	int _OnMenuSaveViewpoint();
	int _OnMenuEnableEffect(MTScene::EffectType type);
	int _OnMenuWindowSize();
	int _OnMenuOptionMIDIOUT();
	int _OnMenuOptionMIDIIN();
	int _OnMenuOptionGraphic();
	int _OnMenuManual();
	int _OnMenuSelectSceneType(SceneType type);
	int _OnFilePathPosted();

	//̑Cxg
	int _SequencerMsgProc();
	int _OnRecvSequencerMsg(unsigned long wParam, unsigned long lParam);
	int _OnMouseButtonDown(UINT button, WPARAM wParam, LPARAM lParam);
	int _OnKeyDown(WPARAM wParam, LPARAM lParam);
	int _OnDropFiles(WPARAM wParam, LPARAM lParam);

	int _SelectMIDIFile(TCHAR* pFilePath,  unsigned long bufSize, bool* pIsSelected);
	int _LoadMIDIFile(const TCHAR* pFilePath);
	void _UpdateFPS();
	int _SetPortDev(SMSequencer* pSequencer);
	int _SetMonitorPortDev(SMLiveMonitor* pLiveMonitor, MTScene* pScene);
	int _ChangeWindowSize();
	int _ChangePlayStatus(PlayStatus status);
	int _ChangeMenuStyle();
	int _CreateScene(SceneType type, SMSeqData* pSeqData);
	int _LoadSceneType();
	int _SaveSceneType();
	int _LoadSceneConf();
	int _SaveSceneConf();
	int _LoadViewpoint();
	int _SaveViewpoint();
	int _LoadGraphicConf();
	int _LoadPlayerConf();
	int _OnDestroy();
	int _RebuildScene();
	int _DispHowToView();
	int _UpdateMenuCheckmark();
	void _CheckMenuItem(UINT uIDCheckItem, bool isEnable);
	void _UpdateEffect();
	int _ParseCmdLine(LPTSTR pCmdLine);
	int _StartTimer();
	int _StopTimer();
	int _OnTimer(WPARAM timerId);
	int _CheckRenderer();
	int _AutoConfigMIDIOUT();
	int _SearchMicrosoftWavetableSynth(std::string& productName);
	int _CheckMultipleInstances(bool* pIsExitApp);
	int _CreateMailSlot();
	int _PostFilePathToFirstMIDITrail(LPTSTR pCmdLine);
	int _StopPlaybackAndOpenFile(TCHAR* pFilePath);
	int _FileOpenProc(TCHAR* pFilePath);

};

