//******************************************************************************
//
// MIDITrail / MTScenePianoRoll3D
//
// sAm[3DV[`NX
//
// Copyright (C) 2010-2014 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "DXDirLight.h"
#include "MTScene.h"
#include "MTFirstPersonCam.h"
#include "MTNoteBox.h"
#include "MTNoteRipple.h"
#include "MTNoteDesign.h"
#include "MTNotePitchBend.h"
#include "MTGridBox.h"
#include "MTPictBoard.h"
#include "MTDashboard.h"
#include "MTStars.h"
#include "MTTimeIndicator.h"
#include "MTMeshCtrl.h"
#include "SMIDILib.h"

using namespace SMIDILib;


//******************************************************************************
// sAm[3DV[`NX
//******************************************************************************
class MTScenePianoRoll3D : public MTScene
{
public:

	//RXgN^^fXgN^l
	MTScenePianoRoll3D();
	~MTScenePianoRoll3D();

	//̎擾
	const TCHAR* GetName();

	//
	virtual int Create(
			HWND hWnd,
			LPDIRECT3DDEVICE9 pD3DDevice,
			SMSeqData* pSeqData
		);

	//ϊ
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//j
	void Release();

	//EBhENbNCxgM
	int OnWindowClicked(
			UINT button,
			WPARAM wParam,
			LPARAM lParam
		);

	//tJnCxgM
	int OnPlayStart(LPDIRECT3DDEVICE9 pD3DDevice);

	//tICxgM
	int OnPlayEnd(LPDIRECT3DDEVICE9 pD3DDevice);

	//V[PTbZ[WM
	int OnRecvSequencerMsg(
			unsigned long param1,
			unsigned long param2
		);

	//߂
	int Rewind();

	//_擾^o^
	void GetDefaultViewParam(MTViewParamMap* pParamMap);
	void GetViewParam(MTViewParamMap* pParamMap);
	void SetViewParam(MTViewParamMap* pParamMap);

	//_Zbg
	void ResetViewpoint();

	//GtFNgݒ
	void SetEffect(MTScene::EffectType type, bool isEnable);

	//txݒ
	void SetPlaySpeedRatio(unsigned long ratio);

protected:

	//CgL
	BOOL m_IsEnableLight;

private:

	//Cg
	DXDirLight m_DirLight;

	//l̃J
	MTFirstPersonCam m_FirstPersonCam;

	//`IuWFNg
	MTNoteBox m_NoteBox;
	MTNoteRipple m_NoteRipple;
	MTNotePitchBend m_NotePitchBend;
	MTGridBox m_GridBox;
	MTPictBoard m_PictBoard;
	MTDashboard m_Dashboard;
	MTStars m_Stars;
	MTTimeIndicator m_TimeIndicator;
	MTMeshCtrl m_MeshCtrl;

	//}EXړ[h
	bool m_IsMouseCamMode;

	//][h
	bool m_IsAutoRollMode;

	//_
	MTViewParamMap m_ViewParamMap;

	//m[gfUCIuWFNg
	MTNoteDesign m_NoteDesign;

	//XLbv
	bool m_IsSkipping;

	void _Reset();
	void _SetLightColor(DXDirLight* pLight);
	int _LoadConf();

};

