//******************************************************************************
//
// MIDITrail / MTSettingMIDIOutDevViewCtrl
//
// MIDI出力デバイス選択ビュークラス
//
// Copyright (C) 2017-2018 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <UIKit/UIKit.h>
#import "SMIDILib.h"
#import "YNBaseLib.h"


//******************************************************************************
// MIDI出力デバイス選択ビュークラス
//******************************************************************************
@interface MTSettingMIDIOutDevViewCtrl : UIViewController {
	
	//テーブルビュー
	IBOutlet UITableView* m_pTableView;
	
	//ポート情報
	NSString* m_pPortKey;
    NSString* m_pPortLabel;
	
	//MIDIデバイス制御
	SMOutDevCtrlEx m_OutDevCtrl;
	
	//ユーザ設定
	YNUserConf* m_pUserConf;
}

//対象ポート設定
- (void)setPortKey:(NSString*)pPortKey portLabel:(NSString*)pPortLabel;

//生成
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil;

//ビュー登録完了
- (void)viewDidLoad;

//ビュー解除完了
//  iOS6で廃止
//- (void)viewDidUnload;

//インターフェース自動回転確認
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

//インターフェース自動回転確認（iOS6以降）
- (BOOL)shouldAutorotate;
- (NSUInteger)supportedInterfaceOrientations;

//ビュー表示
- (void)viewWillAppear:(BOOL)animated;

//ビュー非表示
- (void)viewWillDisappear:(BOOL)animated;

//セクション数
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView;

//セクションヘッダ
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section;

//セクションごとの項目数
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section;

//項目表示内容
- (UITableViewCell*)tableView:(UITableView*)tableView cellForRowAtIndexPath:(NSIndexPath*)indexPath;

//テーブルセル選択イベント
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath;


@end

