//******************************************************************************
//
// MIDITrail / MTNoteBoxLive
//
// Cuj^pm[g{bNX`NX
//
// Copyright (C) 2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTNoteBoxLive.h"

using namespace YNBaseLib;


//******************************************************************************
// p[^`
//******************************************************************************
//1m[g̒_ = 1`4_ * 6 
#define NOTE_VERTEX_NUM  (4 * 6)

//1m[g̃CfbNX = 1Op`3_ * 2 * 6
#define NOTE_INDEX_NUM   (3 * 2 * 6)

//******************************************************************************
// RXgN^
//******************************************************************************
MTNoteBoxLive::MTNoteBoxLive(void)
{
	m_NoteNum = 0;
	m_pNoteStatus = NULL;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTNoteBoxLive::~MTNoteBoxLive(void)
{
	Release();
}

//******************************************************************************
// 
//******************************************************************************
int MTNoteBoxLive::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		MTNotePitchBend* pNotePitchBend
	)
{
	int result = 0;
	
	Release();
	
	//m[gfUCIuWFNg
	result = m_NoteDesign.Initialize(pSceneName, NULL);
	if (result != 0) goto EXIT;
	
	//Cuj^\
	m_LiveMonitorDisplayDuration = m_NoteDesign.GetLiveMonitorDisplayDuration();
	
	//m[gz񐶐
	result = _CreateNoteStatus();
	if (result != 0) goto EXIT;
	
	//m[g{bNXiobt@mہj
	result = _CreateNoteBox(pD3DDevice);
	if (result != 0) goto EXIT;
	
	//sb`xh
	m_pNotePitchBend = pNotePitchBend;
	
EXIT:;
	return result;
}

//******************************************************************************
// m[gz񐶐
//******************************************************************************
int MTNoteBoxLive::_CreateNoteStatus()
{
	int result = 0;
	unsigned long i = 0;
	
	//m[gz񐶐
	try {
		m_pNoteStatus = new NoteStatus[MTNOTEBOX_MAX_LIVENOTE_NUM];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", 0, 0);
		goto EXIT;
	}
	
	//m[gԃXg
	for (i = 0; i < MTNOTEBOX_MAX_LIVENOTE_NUM; i++) {
		m_pNoteStatus[i].isActive = false;
		m_pNoteStatus[i].portNo = 0;
		m_pNoteStatus[i].chNo = 0;
		m_pNoteStatus[i].noteNo = 0;
		m_pNoteStatus[i].startTime = 0;
		m_pNoteStatus[i].endTime = 0;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// m[g{bNXiobt@mہj
//******************************************************************************
int MTNoteBoxLive::_CreateNoteBox(
		LPDIRECT3DDEVICE9 pD3DDevice
   )
{
	int result = 0;
	unsigned long vertexNum = 0;
	unsigned long indexNum = 0;
	MTNOTEBOX_VERTEX* pVertex = NULL;
	unsigned long* pIndex = NULL;
	unsigned long i = 0;
	D3DMATERIAL9 material;
	NoteStatus note;
	
	memset(&note, 0, sizeof(NoteStatus));
	
	//v~eBu
	result = m_PrimitiveNotes.Initialize(
					sizeof(MTNOTEBOX_VERTEX),	//_TCY
					_GetFVFFormat(),			//_FVFtH[}bg
					D3DPT_TRIANGLELIST			//v~eBu
				);
	if (result != 0) goto EXIT;
	
	//_obt@
	vertexNum = NOTE_VERTEX_NUM * MTNOTEBOX_MAX_LIVENOTE_NUM;
	result = m_PrimitiveNotes.CreateVertexBuffer(pD3DDevice, vertexNum);
	if (result != 0) goto EXIT;
	
	//CfbNXobt@
	indexNum = NOTE_INDEX_NUM * MTNOTEBOX_MAX_LIVENOTE_NUM;
	result = m_PrimitiveNotes.CreateIndexBuffer(pD3DDevice, indexNum);
	if (result != 0) goto EXIT;
	
	//obt@̃bN
	result = m_PrimitiveNotes.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;
	result = m_PrimitiveNotes.LockIndex(&pIndex);
	if (result != 0) goto EXIT;
	
	//obt@ɒ_ƃCfbNX
	for (i = 0; i < MTNOTEBOX_MAX_LIVENOTE_NUM; i++) {
		result = _CreateVertexOfNote(
						m_pNoteStatus[i],				//m[g
						&(pVertex[NOTE_VERTEX_NUM * i]),//_obt@݈ʒu
						NOTE_VERTEX_NUM * i,			//_obt@CfbNXItZbg
						&(pIndex[NOTE_INDEX_NUM * i]),	//CfbNXobt@݈ʒu
						0								//ݎ
					);
		if (result != 0) goto EXIT;
	}
	
	//obt@̃bN
	result = m_PrimitiveNotes.UnlockVertex();
	if (result != 0) goto EXIT;
	result = m_PrimitiveNotes.UnlockIndex();
	if (result != 0) goto EXIT;
	
	//}eA쐬
	_MakeMaterial(&material);
	m_PrimitiveNotes.SetMaterial(material);
	
EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTNoteBoxLive::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		float rollAngle
	)
{
	int result = 0;
	D3DXVECTOR3 moveVector;
	D3DXMATRIX rotateMatrix;
	D3DXMATRIX moveMatrix;
	D3DXMATRIX worldMatrix;
	
	//m[g̒_
	result = _TransformNotes(pD3DDevice);
	if (result != 0) goto EXIT;
	
	//s񏉊
	D3DXMatrixIdentity(&rotateMatrix);
	D3DXMatrixIdentity(&moveMatrix);
	D3DXMatrixIdentity(&worldMatrix);
	
	//]s
	D3DXMatrixRotationX(&rotateMatrix, D3DXToRadian(rollAngle));
	
	//ړs
	moveVector = m_NoteDesign.GetWorldMoveVector();
	D3DXMatrixTranslation(&moveMatrix, moveVector.x, moveVector.y, moveVector.z);
	
	//s̍
	D3DXMatrixMultiply(&worldMatrix, &rotateMatrix, &moveMatrix);
	
	//ϊsݒ
	m_PrimitiveNotes.Transform(worldMatrix);
	
EXIT:;
	return result;
}

//******************************************************************************
// m[g̒_
//******************************************************************************
int MTNoteBoxLive::_TransformNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	
	//m[g̏ԍXV
	result = _UpdateStatusOfNotes(pD3DDevice);
	if (result != 0) goto EXIT;
	
	//m[g̒_XV
	result = _UpdateVertexOfNotes(pD3DDevice);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// m[g̏ԍXV
//******************************************************************************
int MTNoteBoxLive::_UpdateStatusOfNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long i = 0;
	unsigned long curTime = 0;
	
	curTime = timeGetTime();
	
	//Âm[gj
	for (i = 0; i < MTNOTEBOX_MAX_LIVENOTE_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			if ((m_pNoteStatus[i].endTime != 0)
				&& ((curTime - m_pNoteStatus[i].endTime) > m_LiveMonitorDisplayDuration)) {
				m_pNoteStatus[i].isActive = false;
				m_pNoteStatus[i].portNo = 0;
				m_pNoteStatus[i].chNo = 0;
				m_pNoteStatus[i].noteNo = 0;
				m_pNoteStatus[i].startTime = 0;
				m_pNoteStatus[i].endTime = 0;
			}
		}
	}
	
//EXIT:;
	return result;
}

//******************************************************************************
// m[g̒_XV
//******************************************************************************
int MTNoteBoxLive::_UpdateVertexOfNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long i = 0;
	unsigned long noteNum = 0;
	unsigned long curTime = 0;
	MTNOTEBOX_VERTEX* pVertex = NULL;
	unsigned long* pIndex = NULL;
	
	curTime = timeGetTime();
	
	//obt@̃bN
	result = m_PrimitiveNotes.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;
	result = m_PrimitiveNotes.LockIndex(&pIndex);
	if (result != 0) goto EXIT;
	
	//m[gɂĒ_XV
	for (i = 0; i < MTNOTEBOX_MAX_LIVENOTE_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			//_XV
			result = _CreateVertexOfNote(
							m_pNoteStatus[i],						//m[g
							&(pVertex[NOTE_VERTEX_NUM * noteNum]),	//_obt@݈ʒu
							NOTE_VERTEX_NUM * noteNum,				//_obt@CfbNXItZbg
							&(pIndex[NOTE_INDEX_NUM * noteNum]),	//CfbNXobt@݈ʒu
							curTime,								//݂̎
							true									//sb`xhKp
						);
			if (result != 0) goto EXIT;
			
			noteNum++;
		}
	}
	m_NoteNum = noteNum;
	
	//obt@̃bN
	result = m_PrimitiveNotes.UnlockVertex();
	if (result != 0) goto EXIT;
	result = m_PrimitiveNotes.UnlockIndex();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTNoteBoxLive::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
   )
{
	int result = 0;
	
	//m[g̕`
	if (m_NoteNum > 0) {
		result = m_PrimitiveNotes.Draw(
						pD3DDevice,						//foCX
						NULL,							//eNX`FȂ
						(NOTE_INDEX_NUM/3)*m_NoteNum	//v~eBu
					);
		if (result != 0) goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTNoteBoxLive::Release()
{
	m_PrimitiveNotes.Release();
	
	delete [] m_pNoteStatus;
	m_pNoteStatus = NULL;
}

//******************************************************************************
// m[g{bNX̒_
//******************************************************************************
int MTNoteBoxLive::_CreateVertexOfNote(
		NoteStatus note,
		MTNOTEBOX_VERTEX* pVertex,
		unsigned long vertexOffset,
		unsigned long* pIndex,
		unsigned long curTime,
		bool isEnablePitchBend
	)
{
	int result = 0;
	unsigned long i;
	D3DXVECTOR3 vectorStartLU;
	D3DXVECTOR3 vectorStartRU;
	D3DXVECTOR3 vectorStartLD;
	D3DXVECTOR3 vectorStartRD;
	D3DXVECTOR3 vectorEndLU;
	D3DXVECTOR3 vectorEndRU;
	D3DXVECTOR3 vectorEndLD;
	D3DXVECTOR3 vectorEndRD;
	D3DXCOLOR color;
	short pitchBendValue = 0;
	unsigned char pitchBendSensitivity = SM_DEFAULT_PITCHBEND_SENSITIVITY;
	unsigned long elapsedTime = 0;
	
	if ((isEnablePitchBend) && (note.endTime == 0)) {
		pitchBendValue =       m_pNotePitchBend->GetValue(note.portNo, note.chNo);
		pitchBendSensitivity = m_pNotePitchBend->GetSensitivity(note.portNo, note.chNo);
	}
	
	//     +   1+----+3   +
	//    /|   /  /    /|         y x
	//   + | 0+----+2   + |E       |/
	// | +   7+----+5 | +      z--+0
	//   |/    /  /   |/
	//   +   6+----+4   +  4 _(0,0,0)
	//
	
	//m[g{bNX_W擾
	elapsedTime = curTime - note.startTime;
	if (elapsedTime > m_LiveMonitorDisplayDuration) {
		elapsedTime = m_LiveMonitorDisplayDuration;
	}
	m_NoteDesign.GetNoteBoxVirtexPosLive(
			elapsedTime,
			note.portNo,
			note.chNo,
			note.noteNo,
			&vectorStartLU,
			&vectorStartRU,
			&vectorStartLD,
			&vectorStartRD,
			pitchBendValue,
			pitchBendSensitivity
		);
	
	elapsedTime = 0;
	if (note.endTime != 0) {
		elapsedTime = curTime - note.endTime;
	}
	m_NoteDesign.GetNoteBoxVirtexPosLive(
			elapsedTime,
			note.portNo,
			note.chNo,
			note.noteNo,
			&vectorEndLU,
			&vectorEndRU,
			&vectorEndLD,
			&vectorEndRD,
			pitchBendValue,
			pitchBendSensitivity
		);
	
	//_WEEE@قȂ̂Œ_8ɏWłȂ
	//̖
	pVertex[0].p = vectorStartLU;
	pVertex[1].p = vectorEndLU;
	pVertex[2].p = vectorStartRU;
	pVertex[3].p = vectorEndRU;
	//̖
	pVertex[4].p = vectorStartRD;
	pVertex[5].p = vectorEndRD;
	pVertex[6].p = vectorStartLD;
	pVertex[7].p = vectorEndLD;
	//E̖
	pVertex[8].p  = pVertex[2].p;
	pVertex[9].p  = pVertex[3].p;
	pVertex[10].p = pVertex[4].p;
	pVertex[11].p = pVertex[5].p;
	//̖
	pVertex[12].p = pVertex[6].p;
	pVertex[13].p = pVertex[7].p;
	pVertex[14].p = pVertex[0].p;
	pVertex[15].p = pVertex[1].p;
	//O̖
	pVertex[16].p = pVertex[0].p;
	pVertex[17].p = pVertex[2].p;
	pVertex[18].p = pVertex[6].p;
	pVertex[19].p = pVertex[4].p;
	//̖
	pVertex[20].p = pVertex[3].p;
	pVertex[21].p = pVertex[1].p;
	pVertex[22].p = pVertex[5].p;
	pVertex[23].p = pVertex[7].p;
	
	//@
	//̖
	pVertex[0].n = D3DXVECTOR3( 0.0f, 1.0f, 0.0f);
	pVertex[1].n = D3DXVECTOR3( 0.0f, 1.0f, 0.0f);
	pVertex[2].n = D3DXVECTOR3( 0.0f, 1.0f, 0.0f);
	pVertex[3].n = D3DXVECTOR3( 0.0f, 1.0f, 0.0f);
	//̖
	pVertex[4].n = D3DXVECTOR3( 0.0f,-1.0f, 0.0f);
	pVertex[5].n = D3DXVECTOR3( 0.0f,-1.0f, 0.0f);
	pVertex[6].n = D3DXVECTOR3( 0.0f,-1.0f, 0.0f);
	pVertex[7].n = D3DXVECTOR3( 0.0f,-1.0f, 0.0f);
	//E̖
	pVertex[8].n  = D3DXVECTOR3( 0.0f, 0.0f,-1.0f);
	pVertex[9].n  = D3DXVECTOR3( 0.0f, 0.0f,-1.0f);
	pVertex[10].n = D3DXVECTOR3( 0.0f, 0.0f,-1.0f);
	pVertex[11].n = D3DXVECTOR3( 0.0f, 0.0f,-1.0f);
	//̖
	pVertex[12].n = D3DXVECTOR3( 0.0f, 0.0f, 1.0f);
	pVertex[13].n = D3DXVECTOR3( 0.0f, 0.0f, 1.0f);
	pVertex[14].n = D3DXVECTOR3( 0.0f, 0.0f, 1.0f);
	pVertex[15].n = D3DXVECTOR3( 0.0f, 0.0f, 1.0f);
	//O̖
	pVertex[16].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	pVertex[17].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	pVertex[18].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	pVertex[19].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	//̖
	pVertex[20].n = D3DXVECTOR3( 1.0f, 0.0f, 0.0f);
	pVertex[21].n = D3DXVECTOR3( 1.0f, 0.0f, 0.0f);
	pVertex[22].n = D3DXVECTOR3( 1.0f, 0.0f, 0.0f);
	pVertex[23].n = D3DXVECTOR3( 1.0f, 0.0f, 0.0f);
	
	//e_̃fBt[YF
	if (note.endTime != 0) {
		color = m_NoteDesign.GetNoteBoxColor(note.portNo, note.chNo, note.noteNo);
	}
	else {
		//͔JňoߎԂɂĐFω
		elapsedTime = curTime - note.startTime;
		color = m_NoteDesign.GetActiveNoteBoxColor(note.portNo, note.chNo, note.noteNo, elapsedTime);
	}
	
	//_̐Fݒ芮
	for (i = 0; i < NOTE_VERTEX_NUM; i++) {
		pVertex[i].c = color;
	}
	
	//CfbNXFDrawIndexdPrimitiveĂяo1ōςނ悤TRIANGLELISTƂ
	for (i = 0; i < NOTE_INDEX_NUM; i++) {
		pIndex[i] = vertexOffset + _GetVertexIndexOfNote(i);
	}
	
	return result;
}

//******************************************************************************
// m[g_CfbNX擾
//******************************************************************************
unsigned long MTNoteBoxLive::_GetVertexIndexOfNote(
		unsigned long index
	)
{
	unsigned long vertexIndex = 0;
	unsigned long vertexIndexes[NOTE_INDEX_NUM] = {
		//TRIANGLE-1   TRIANGLE-2
		 0,  1,  2,     2,  1,  3,	//
		 4,  5,  6,     6,  5,  7,	//
		 8,  9, 10,    10,  9, 11,	//E
		12, 13, 14,    14, 13, 15,	//
		16, 17, 18,    18, 17, 19,	//O
		20, 21, 22,    22, 21, 23,	//
	};
	
	if (index < NOTE_INDEX_NUM) {
		vertexIndex = vertexIndexes[index];
	}
	
	return vertexIndex;
}

//******************************************************************************
// }eA쐬
//******************************************************************************
void MTNoteBoxLive::_MakeMaterial(
		D3DMATERIAL9* pMaterial
	)
{
	ZeroMemory(pMaterial, sizeof(D3DMATERIAL9));
	
	//gU
	pMaterial->Diffuse.r = 1.0f;
	pMaterial->Diffuse.g = 1.0f;
	pMaterial->Diffuse.b = 1.0f;
	pMaterial->Diffuse.a = 1.0f;
	//Fe̐F
	pMaterial->Ambient.r = 0.5f;
	pMaterial->Ambient.g = 0.5f;
	pMaterial->Ambient.b = 0.5f;
	pMaterial->Ambient.a = 1.0f;
	//ʔˌ
	pMaterial->Specular.r = 0.2f;
	pMaterial->Specular.g = 0.2f;
	pMaterial->Specular.b = 0.2f;
	pMaterial->Specular.a = 1.0f;
	//ʔˌ̑Nx
	pMaterial->Power = 40.0f;
	//F
	pMaterial->Emissive.r = 0.0f;
	pMaterial->Emissive.g = 0.0f;
	pMaterial->Emissive.b = 0.0f;
	pMaterial->Emissive.a = 0.0f;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTNoteBoxLive::Reset()
{
	unsigned long i = 0;
	
	m_NoteNum = 0;
	
	for (i = 0; i < MTNOTEBOX_MAX_LIVENOTE_NUM; i++) {
		m_pNoteStatus[i].isActive = false;
		m_pNoteStatus[i].portNo = 0;
		m_pNoteStatus[i].chNo = 0;
		m_pNoteStatus[i].noteNo = 0;
		m_pNoteStatus[i].startTime = 0;
		m_pNoteStatus[i].endTime = 0;
	}

	return;
}

//******************************************************************************
// m[gONo^
//******************************************************************************
void MTNoteBoxLive::SetNoteOn(
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo,
		unsigned char velocity
	)
{
	unsigned long i = 0;
	unsigned long cleardIndex = 0;
	bool isFind = false;
	unsigned long curTime = 0;
	
	curTime = timeGetTime();
	
	//󂫃Xy[XɃm[go^
	//󂫂ȂΓo^߂
	for (i = 0; i < MTNOTEBOX_MAX_LIVENOTE_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			if ((m_pNoteStatus[i].endTime != 0)
				&& ((curTime - m_pNoteStatus[i].endTime) > m_LiveMonitorDisplayDuration)) {
				m_pNoteStatus[i].isActive = false;
				cleardIndex = i;
				isFind = true;
				break;
			}
		}
		else {
			m_pNoteStatus[i].isActive = false;
			cleardIndex = i;
			isFind = true;
			break;
		}
	}
	
	//󂫃Xy[XȂꍇ͍łÂm[gNA
	if (!isFind) {
		_ClearOldestNoteStatus(&cleardIndex);
	}
	
	//m[go^
	m_pNoteStatus[cleardIndex].isActive = true;
	m_pNoteStatus[cleardIndex].portNo = portNo;
	m_pNoteStatus[cleardIndex].chNo = chNo;
	m_pNoteStatus[cleardIndex].noteNo = noteNo;
	m_pNoteStatus[cleardIndex].startTime = timeGetTime();
	m_pNoteStatus[cleardIndex].endTime = 0;
	
	return;
}

//******************************************************************************
// m[gOFFo^
//******************************************************************************
void MTNoteBoxLive::SetNoteOff(
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo
	)
{
	unsigned long i = 0;
	
	//Ỹm[gɏIݒ
	for (i = 0; i < MTNOTEBOX_MAX_LIVENOTE_NUM; i++) {
		if ((m_pNoteStatus[i].isActive)
			&& (m_pNoteStatus[i].portNo == portNo)
			&& (m_pNoteStatus[i].chNo == chNo)
			&& (m_pNoteStatus[i].noteNo == noteNo)
			&& (m_pNoteStatus[i].endTime == 0)) {
			m_pNoteStatus[i].endTime = timeGetTime();
			break;
		}
	}
	
	return;
}

//******************************************************************************
// Sm[gOFF
//******************************************************************************
void MTNoteBoxLive::AllNoteOff()
{
	unsigned long i = 0;
	
	//m[gOFFݒ肳ĂȂm[gɏIݒ
	for (i = 0; i < MTNOTEBOX_MAX_LIVENOTE_NUM; i++) {
		if ((m_pNoteStatus[i].isActive) && (m_pNoteStatus[i].endTime == 0)) {
			m_pNoteStatus[i].endTime = timeGetTime();
		}
	}
	
	return;
}

//******************************************************************************
// Sm[gOFFi`lwj
//******************************************************************************
void MTNoteBoxLive::AllNoteOffOnCh(
		unsigned char portNo,
		unsigned char chNo
	)
{
	unsigned long i = 0;
	
	//w`lŃm[gOFFݒ肳ĂȂm[gɏIݒ
	for (i = 0; i < MTNOTEBOX_MAX_LIVENOTE_NUM; i++) {
		if ((m_pNoteStatus[i].isActive) && (m_pNoteStatus[i].endTime == 0)
			&& (m_pNoteStatus[i].portNo == portNo) && (m_pNoteStatus[i].chNo == chNo)) {
			m_pNoteStatus[i].endTime = timeGetTime();
		}
	}
	
	return;
}

//******************************************************************************
// łÂm[g̃NA
//******************************************************************************
void MTNoteBoxLive::_ClearOldestNoteStatus(
		unsigned long* pCleardIndex
	)
{
	unsigned long i = 0;
	unsigned long oldestIndex = 0;
	bool isFind = false;
	
	//m[gONłÂm[gNA
	for (i = 0; i < MTNOTEBOX_MAX_LIVENOTE_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			if (!isFind) {
				//Lȃm[gꂽꍇF
				oldestIndex = i;
				isFind = true;
			}
			else {
				//Lȃm[gꂽꍇF2ڈȍ~
				if (m_pNoteStatus[i].startTime < m_pNoteStatus[oldestIndex].startTime) {
					oldestIndex = i;
				}
			}
		}
	}
	
	//m[gNA
	//  m[go^ĂȂꍇ͔z̐擪NAΏۂƂȂ
	m_pNoteStatus[oldestIndex].isActive = false;
	*pCleardIndex = oldestIndex;
	
	return;
}

