//******************************************************************************
//
// MIDITrail / MTPictBoardRing
//
// sN`{[hO`NX
//
// Copyright (C) 2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// sN`{[h`悷B
// 摜t@C .bmp .dds .dib .jpg .png .tga w\B
// iD3DXCreateTextureFromFile T|[gĂ摜j

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"
#include "DXPrimitive.h"
#include "MTNoteDesignRing.h"

using namespace SMIDILib;


//******************************************************************************
//  sN`{[hO`NX
//******************************************************************************
class MTPictBoardRing
{
public:

	//RXgN^^fXgN^
	MTPictBoardRing(void);
	virtual ~MTPictBoardRing(void);

	//
	int Create(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName, SMSeqData* pSeqData, bool isReverseMode);

	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, D3DXVECTOR3 camVector, float rollAngle);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//
	void Release();

	//t`bN^Co^
	void SetCurTickTime(unsigned long curTickTime);

	//Zbg
	void Reset();

	//tJnI
	void OnPlayStart();
	void OnPlayEnd();

	//\ݒ
	void SetEnable(bool isEnable);

private:

	DXPrimitive m_Primitive;
	LPDIRECT3DTEXTURE9 m_pTexture;
	D3DXIMAGE_INFO m_ImgInfo;
	unsigned long m_CurTickTime;
	bool m_isPlay;
	bool m_isEnable;
	MTNoteDesignRing m_NoteDesign;

	//_obt@\
	struct MTPICTBOARD_VERTEX {
		D3DXVECTOR3 p;	//_W
		D3DXVECTOR3 n;	//@
		DWORD		c;	//fBt[YF
		D3DXVECTOR2 t;	//eNX`摜ʒu
	};

	//_obt@FVFtH[}bg
	DWORD _GetFVFFormat(){ return (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE | D3DFVF_TEX1); }

	int _CreateVertexOfBoard(
			MTPICTBOARD_VERTEX* pVertex,
			unsigned long* pIbIndex,
			bool isReverseMode
		);

	int _LoadTexture(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName);

};


