//******************************************************************************
//
// Simple MIDI Library / SMMsgTransmitter
//
// bZ[W]NX
//
// Copyright (C) 2010-2013 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#ifdef SMIDILIB_EXPORTS
#define SMIDILIB_API __declspec(dllexport)
#else
#define SMIDILIB_API __declspec(dllimport)
#endif

#include "SMEvent.h"
#include "SMMsgQueue.h"

namespace SMIDILib {


//******************************************************************************
// p[^`
//******************************************************************************
//bZ[W
#define SM_MSG_PLAY_STATUS     (0x00)
#define SM_MSG_TIME            (0x01)
#define SM_MSG_TEMPO           (0x02)
#define SM_MSG_BAR             (0x03)
#define SM_MSG_BEAT            (0x04)
#define SM_MSG_NOTE_OFF        (0x10)
#define SM_MSG_NOTE_ON         (0x11)
#define SM_MSG_PITCHBEND       (0x12)
#define SM_MSG_SKIP_START      (0x13)
#define SM_MSG_SKIP_END        (0x14)
#define SM_MSG_ALL_NOTE_OFF    (0x15)

//t
#define SM_PLAYSTATUS_STOP       (0x00)
#define SM_PLAYSTATUS_PLAY       (0x01)
#define SM_PLAYSTATUS_PAUSE      (0x02)

//XLbv
#define SM_SKIP_BACK           (0x00)
#define SM_SKIP_FORWARD        (0x01)


//******************************************************************************
// bZ[W]NX
//******************************************************************************
class SMIDILIB_API SMMsgTransmitter
{
public:

	//RXgN^^fXgN^
	SMMsgTransmitter(void);
	virtual ~SMMsgTransmitter(void);

	//
	int Initialize(SMMsgQueue* pMsgQueue);

	//t
	int PostPlayStatus(unsigned long playStatus);

	//tԒʒm
	//  (playTimeSec)3byte(0x00FFFFFF)܂ł̐
	int PostPlayTime(unsigned long playTimeMSec, unsigned long tickTime);

	//e|ʒm
	int PostTempo(unsigned long bpm);

	//ߔԍʒmF1Jn
	int PostBar(unsigned long barNo);

	//qLʒm
	//  ͍ő65535܂œn邪
	//  MIDI̎dlł͕q255^2255܂ŕ\ł
	int PostBeat(unsigned short numerator, unsigned short denominator);

	//m[gONʒm
	int PostNoteOn(
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				unsigned char verocity
			);

	//m[gOFFʒm
	int PostNoteOff(
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo
			);

	//sb`xhʒm
	int PostPitchBend(
				unsigned char portNo,
				unsigned char chNo,
				short pitchBendValue,
				unsigned char pitchBendSensitivity
			);

	//XLbvJn
	int PostSkipStart(unsigned long skipDirection);

	//XLbvI
	int PostSkipEnd(unsigned long notesCount);

	//I[m[gOFF
	int PostAllNoteOff(
				unsigned char portNo,
				unsigned char chNo
			);

private:

	SMMsgQueue* m_pMsgQueue;

	int _Post(
			unsigned char msg,
			unsigned long param1, //3byte܂
			unsigned long param2  //4byte܂
		);

	//ƃRs[RXgN^̋֎~
	void operator=(const SMMsgTransmitter&);
	SMMsgTransmitter(const SMMsgTransmitter&);

};

} // end of namespace

