//******************************************************************************
//
// MIDITrail / MTGridRingLive
//
// Cuj^pObhO`NX
//
// Copyright (C) 2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "MTGridRingLive.h"
#import "OGLH.h"


//******************************************************************************
// RXgN^
//******************************************************************************
MTGridRingLive::MTGridRingLive(void)
{
	m_isVisible = true;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTGridRingLive::~MTGridRingLive(void)
{
	Release();
}

//******************************************************************************
// Obh
//******************************************************************************
int MTGridRingLive::Create(
		OGLDevice* pOGLDevice,
		NSString* pSceneName
   )
{
	int result = 0;
	SMBarList barList;
	GLsizei vertexNum = 0;
	GLsizei indexNum = 0;
	MTGRIDBOXLIVE_VERTEX* pVertex = NULL;
	unsigned int* pIndex = NULL;
	OGLMATERIAL material;
	OGLCOLOR lineColor;
	
	Release();
	
	if (pOGLDevice == NULL) {
		result = YN_SET_ERR(@"Program error.", 0, 0);
		goto EXIT;
	}
	
	//m[gfUCIuWFNg
	result = m_NoteDesign.Initialize(pSceneName, NULL);
	if (result != 0) goto EXIT;
	
	//v~eBu
	result = m_Primitive.Initialize(
					sizeof(MTGRIDBOXLIVE_VERTEX),	//_TCY
					_GetFVFFormat(),			//_FVFtH[}bg
					GL_LINES					//v~eBu
				);
	if (result != 0) goto EXIT;
	
	//_obt@F1O128_ * 2([/I[)
	vertexNum = 128 * 2;
	result = m_Primitive.CreateVertexBuffer(pOGLDevice, vertexNum);
	if (result != 0) goto EXIT;

	//CfbNXobt@F1O128 * 2(n_/I_) * 2([/I[)
	indexNum = 128 * 2 * 2;
	result = m_Primitive.CreateIndexBuffer(pOGLDevice, indexNum);
	if (result != 0) goto EXIT;
	
	//obt@̃bN
	result = m_Primitive.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;
	result = m_Primitive.LockIndex(&pIndex);
	if (result != 0) goto EXIT;
	
	//Obh{bNX̒_ƃCfbNX𐶐
	result = _CreateVertexOfGrid(
					pVertex,		//_obt@݈ʒu
					pIndex			//CfbNXobt@݈ʒu
				);
	if (result != 0) goto EXIT;
	
	//obt@̃bN
	result = m_Primitive.UnlockVertex();
	if (result != 0) goto EXIT;
	result = m_Primitive.UnlockIndex();
	if (result != 0) goto EXIT;
	
	//}eA쐬
	_MakeMaterial(&material);
	m_Primitive.SetMaterial(material);
	
	//Obh̐FmF
	lineColor = m_NoteDesign.GetGridLineColor();
	if (((GLuint)lineColor & 0xFF000000) == 0) {
		//Ȃ`悵Ȃ
		m_isVisible = false;
	}

EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTGridRingLive::Transform(
		OGLDevice* pOGLDevice,
		float rollAngle
	)
{
	int result = 0;
	OGLVECTOR3 moveVector;
	OGLTransMatrix transMatrix;
	
	//]
	transMatrix.RegistRotationX(rollAngle);
	
	//ړ
	moveVector = m_NoteDesign.GetWorldMoveVector();
	transMatrix.RegistTranslation(moveVector.x, moveVector.y, moveVector.z);
	
	//n(DirectX)=>En(OpenGL)̕ϊ
	transMatrix.RegistScale(1.0f, 1.0f, LH2RH(1.0f));
	
	//ϊsݒ
	m_Primitive.Transform(&transMatrix);
	
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTGridRingLive::Draw(
		OGLDevice* pOGLDevice
	)
{
	int result = 0;
	
	if (m_isVisible) {
		result = m_Primitive.Draw(pOGLDevice);
		if (result != 0) goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTGridRingLive::Release()
{
	m_Primitive.Release();
}

//******************************************************************************
// Obh_
//******************************************************************************
int MTGridRingLive::_CreateVertexOfGrid(
		MTGRIDBOXLIVE_VERTEX* pVertex,
		unsigned int* pIndex
	)
{
	int result = 0;
	unsigned int i = 0;
	unsigned int virtexIndex = 0;
	unsigned int virtexIndexStart = 0;
	OGLVECTOR3 basePosStart;
	OGLVECTOR3 basePosEnd;
	OGLVECTOR3 rotatedPos;
	float angle = 0.0f;

	//W擾
	m_NoteDesign.GetGridRingBasePosLive(&basePosStart, &basePosEnd);

	//----------------------------------
	//[O
	//----------------------------------
	//_쐬
	virtexIndexStart = virtexIndex;
	pVertex[virtexIndex].p = basePosStart;
	pVertex[virtexIndex].n = OGLVECTOR3(-1.0f, 0.0f, 0.0f);
	pVertex[virtexIndex].c = m_NoteDesign.GetGridLineColor();
	for (i = 1; i < 128; i++) {
		virtexIndex++;
		
		//]̒_
		angle = (360.0f / 128.0f) * (float)i;
		rotatedPos = OGLH::RotateYZ(0.0f, 0.0f, basePosStart, angle);
		pVertex[virtexIndex].p = rotatedPos;
		pVertex[virtexIndex].n = OGLVECTOR3(-1.0f, 0.0f, 0.0f);
		pVertex[virtexIndex].c = m_NoteDesign.GetGridLineColor();
		
		//CfbNXobt@iO̒_獡̒_j
		pIndex[(virtexIndex - 1) * 2]     = virtexIndex - 1;
		pIndex[(virtexIndex - 1) * 2 + 1] = virtexIndex;
	}
	//I_Ǝn_Ȃ
	pIndex[virtexIndex * 2]     = virtexIndex;
	pIndex[virtexIndex * 2 + 1] = virtexIndexStart;

	virtexIndex++;

	//----------------------------------
	//I[O
	//----------------------------------
	//_쐬
	virtexIndexStart = virtexIndex;
	pVertex[virtexIndex].p = basePosEnd;
	pVertex[virtexIndex].n = OGLVECTOR3(-1.0f, 0.0f, 0.0f);
	pVertex[virtexIndex].c = m_NoteDesign.GetGridLineColor();
	for (i = 1; i < 128; i++) {
		virtexIndex++;
		
		//]̒_
		angle = (360.0f / 128.0f) * (float)i;
		rotatedPos = OGLH::RotateYZ(0.0f, 0.0f, basePosEnd, angle);
		pVertex[virtexIndex].p = rotatedPos;
		pVertex[virtexIndex].n = OGLVECTOR3(-1.0f, 0.0f, 0.0f);
		pVertex[virtexIndex].c = m_NoteDesign.GetGridLineColor();
		
		//CfbNXobt@iO̒_獡̒_j
		pIndex[(virtexIndex - 1) * 2]     = virtexIndex - 1;
		pIndex[(virtexIndex - 1) * 2 + 1] = virtexIndex;
	}
	//I_Ǝn_Ȃ
	pIndex[virtexIndex * 2]     = virtexIndex;
	pIndex[virtexIndex * 2 + 1] = virtexIndexStart;

	return result;
}

//******************************************************************************
// }eA쐬
//******************************************************************************
void MTGridRingLive::_MakeMaterial(
		OGLMATERIAL* pMaterial
	)
{
	memset(pMaterial, 0, sizeof(OGLMATERIAL));
	
	//gU
	pMaterial->Diffuse.r = 1.0f;
	pMaterial->Diffuse.g = 1.0f;
	pMaterial->Diffuse.b = 1.0f;
	pMaterial->Diffuse.a = 1.0f;
	//Fe̐F
	pMaterial->Ambient.r = 0.5f;
	pMaterial->Ambient.g = 0.5f;
	pMaterial->Ambient.b = 0.5f;
	pMaterial->Ambient.a = 1.0f;
	//ʔˌ
	pMaterial->Specular.r = 0.2f;
	pMaterial->Specular.g = 0.2f;
	pMaterial->Specular.b = 0.2f;
	pMaterial->Specular.a = 1.0f;
	//ʔˌ̑Nx
	pMaterial->Power = 10.0f;
	//F
	pMaterial->Emissive.r = 0.0f;
	pMaterial->Emissive.g = 0.0f;
	pMaterial->Emissive.b = 0.0f;
	pMaterial->Emissive.a = 0.0f;
}


