//******************************************************************************
//
// MIDITrail / MTScenePianoRoll2DLive
//
// ライブモニタ用ピアノロール2Dシーン描画クラス
//
// Copyright (C) 2012-2013 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "MTScenePianoRoll2DLive.h"


//******************************************************************************
// コンストラクタ
//******************************************************************************
MTScenePianoRoll2DLive::MTScenePianoRoll2DLive(void)
{
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTScenePianoRoll2DLive::~MTScenePianoRoll2DLive(void)
{
}

//******************************************************************************
// 名称取得
//******************************************************************************
NSString* MTScenePianoRoll2DLive::GetName()
{
	return @"PianoRoll2DLive";
}

//******************************************************************************
// シーン生成
//******************************************************************************
int MTScenePianoRoll2DLive::Create(
		NSView* pView,
		OGLDevice* pOGLDevice,
		SMSeqData* pSeqData
	)
{
	int result = 0;
	
	//ピアノロール2Dはライトなし
	//  ノートボックスの幅をゼロにするので表と裏が同一平面状で重なる
	//  ライトを有効にすると表と裏の色が異なりZファイティングを誘発する
	m_IsEnableLight = false;
	
	result = MTScenePianoRoll3DLive::Create(pView, pOGLDevice, pSeqData);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

