//******************************************************************************
//
// OpenGL Utility / OGLH
//
// ヘルパ関数クラス
//
// Copyright (C) 2010-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "OGLTypes.h"


//******************************************************************************
// パラメータ定義
//******************************************************************************
//円周率：floatの有効桁数は10進数で7桁ほど
#define OGL_MATH_PI  (3.141592)


//******************************************************************************
// ヘルパ関数クラス
//******************************************************************************
class OGLH
{
public:
	
	//ベクトル正規化
	static void Vec3Normalize(
		OGLVECTOR3* pNormalizedVector,
		const OGLVECTOR3* pVector
	);
	
	//ラジアン算出
	static float ToRadian(float degree);
	
	//角度算出
	static float ToDegree(float radian);
	
	//座標回転：YZ平面
	static OGLVECTOR3 RotateYZ(
			float centerY,
			float centerZ,
			OGLVECTOR3 p1,
			float angle
		);

};


