//******************************************************************************
//
// OpenGL Utility / OGLH
//
// ヘルパ関数クラス
//
// Copyright (C) 2010-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "OGLH.h"
#import <math.h>


//******************************************************************************
// ベクトル正規化
//******************************************************************************
void OGLH::Vec3Normalize(
		OGLVECTOR3* pNormalizedVector,
		const OGLVECTOR3* pVector
	)
{
	double x, y, z, r, ri;
	
	x = (double)(pVector->x);
	y = (double)(pVector->y);
	z = (double)(pVector->z);
	r = sqrt((x*x) + (y*y) + (z*z));
	
	if (r < (1e-6)) {
		//正規化できないので同じベクトルを返す
		ri = 1.0;
	}
	else {
		ri = 1.0 / r;
	}
	
	pNormalizedVector->x = (float)(x * ri);
	pNormalizedVector->y = (float)(y * ri);
	pNormalizedVector->z = (float)(z * ri);
}

//******************************************************************************
// ラジアン算出
//******************************************************************************
float OGLH::ToRadian(float degree)
{
	return (degree * OGL_MATH_PI / 180.0);
}

//******************************************************************************
// 角度算出
//******************************************************************************
float OGLH::ToDegree(float radian)
{
	return (radian * 180.0 / OGL_MATH_PI);
}

//******************************************************************************
// 座標回転：YZ平面
//******************************************************************************
OGLVECTOR3 OGLH::RotateYZ(
		float centerY,
		float centerZ,
		OGLVECTOR3 p1,
		float angle
	)
{
	OGLVECTOR3 p2;
	float rad = 0.0f;
	
	rad = OGLH::ToRadian(angle);
	p2.x = p1.x;
	p2.y = (float)(centerY + (sin(rad) * (p1.z - centerZ)) + (cos(rad) * (p1.y - centerY)));
	p2.z = (float)(centerZ + (cos(rad) * (p1.z - centerZ)) - (sin(rad) * (p1.y - centerY)));
	
	return p2;
}

