//******************************************************************************
//
// MIDITrail / MTFileViewCtrl
//
// ファイルビュー制御クラス
//
// Copyright (C) 2012-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <UIKit/UIKit.h>
#import "MTFileEditViewCtrl.h"
#import "MTFileSearchResultsViewCtrl.h"


//******************************************************************************
// ファイル検索制御クラス
//******************************************************************************
@interface MTFileSearchController : UISearchController {

}

//検索バー表示前
- (void)viewWillAppear:(BOOL)animated;

//検索バー非表示前
- (void)viewWillDisappear:(BOOL)animated;

@end


//******************************************************************************
// ファイルビュー制御クラス
//******************************************************************************
@interface MTFileViewCtrl : UIViewController <UISearchResultsUpdating> {
	
	//テーブルビュー
	IBOutlet UITableView* m_pTableView;
	
	//ファイル名一覧
	NSMutableArray* m_pFileArray;
	
	//選択ファイルインデックス
	NSInteger m_SelectedFileIndex;
	
	//ファイル編集ビュー
	MTFileEditViewCtrl* m_pFileEditViewCtrl;
	
	//検索制御
	MTFileSearchController* m_pSearchController;
	
	//検索結果ビュー制御
	MTFileSearchResultsViewCtrl* m_pFileSearchResultsViewCtrl;
	
	//リフレッシュ制御
	UIRefreshControl* m_pRefreshCtrl;
}

//生成
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil;

//ビュー登録完了
- (void)viewDidLoad;

//インターフェース自動回転確認
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

//インターフェース自動回転確認（iOS6以降）
- (BOOL)shouldAutorotate;
- (NSUInteger)supportedInterfaceOrientations;

//ビュー表示
- (void)viewWillAppear:(BOOL)animated;

//ビュー非表示
- (void)viewWillDisappear:(BOOL)animated;

//セクション数
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView;

//セクションヘッダ
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section;

//セクションごとの項目数
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section;

//項目表示内容
- (UITableViewCell*)tableView:(UITableView*)tableView cellForRowAtIndexPath:(NSIndexPath*)indexPath;

//テーブルセル作成：列の高さ
- (CGFloat)tableView:(UITableView*)tableView heightForRowAtIndexPath:(NSIndexPath*)indexPath;

//テーブルセル選択イベント
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath;

//選択行ファイルパス取得
- (NSString*)selectedFilePath;

//編集開始終了通知
- (void)setEditing:(BOOL)editing animated:(BOOL)animated;

//行単位削除可否判定
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath;

//行削除イベント
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath;

//ファイル名更新イベント
- (void)onUpdateFileName:(NSNotification*)pNotification;

//ファイル一覧更新
- (int)updateFileList;

//指定ファイルまでスクロール
- (int)scroolToFile:(NSString*)pFileName;

@end

