//******************************************************************************
//
// MIDITrail / MTSettingViewCtrl
//
// 設定画面制御クラス
//
// Copyright (C) 2012-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <UIKit/UIKit.h>
#import <GameController/GameController.h>
#import "YNBaseLib.h"
#import "SMIDILib.h"
#import "MTSettingMIDIOutDevViewCtrl.h"
#import "MTSettingMIDIInDevViewCtrl.h"
#import "MTSettingEncodingViewCtrl.h"
#import "MTSettingBGIMGViewCtrl.h"
#import "MTSettingWavetableViewCtrl.h"
#import "MTSettingNoteLengthViewCtrl.h"


//******************************************************************************
// モニタービュー制御クラス
//******************************************************************************
@interface MTSettingViewCtrl : UIViewController {
	
	//テーブルビュー
	IBOutlet UITableView* m_pTableView;
	
	//ユーザ設定
	YNUserConf* m_pUserConf;
	
	//MIDIデバイス制御
	SMOutDevCtrlEx m_OutDevCtrl;
	SMInDevCtrl m_InDevCtrl;
	
	//ビューモードアイコン画像
	//TAG:シーン追加
	UIImage* m_pImagePianoRoll3D;
	UIImage* m_pImagePianoRoll2D;
	UIImage* m_pImagePianoRollRain;
	UIImage* m_pImagePianoRollRain2D;
	UIImage* m_pImagePianoRollRing;
	
    //MIDI OUTデバイス設定ビュー
    MTSettingMIDIOutDevViewCtrl* m_pSettingMIDIOutDevViewCtrl;
    
    //MIDI INデバイス設定ビュー
    MTSettingMIDIInDevViewCtrl* m_pSettingMIDIInDevViewCtrl;
    
    //エンコーディング設定ビュー
	MTSettingEncodingViewCtrl* m_pSettingEncodingViewCtrl;
    
    //背景画像選択ビュー
    MTSettingBGIMGViewCtrl* m_pSettingBGIMGViewCtrl;
	
	//Wavetable選択ビュー
	MTSettingWavetableViewCtrl* m_pSettingWavetableViewCtrl;
	
	//四分音符長拡大率選択ビュー
	MTSettingNoteLengthViewCtrl* m_pSettingNoteLengthViewCtrl;
	
	//無線ゲームコントローラー検索中フラグ
	BOOL m_isSearchingControllers;
}

//生成
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil;

//ビュー登録完了
- (void)viewDidLoad;

//インターフェース自動回転確認
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

//インターフェース自動回転確認（iOS6以降）
- (BOOL)shouldAutorotate;
- (NSUInteger)supportedInterfaceOrientations;

//ビュー表示
- (void)viewWillAppear:(BOOL)animated;

//ビュー非表示
- (void)viewWillDisappear:(BOOL)animated;

//セクション数
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView;

//セクションヘッダ
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section;

//セクションごとの項目数
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section;

//項目表示内容
- (UITableViewCell*)tableView:(UITableView*)tableView cellForRowAtIndexPath:(NSIndexPath*)indexPath;

//テーブルセル選択イベント
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath;

//選択エンコーディングID取得
- (NSStringEncoding)selectedEncodingId;

//ファイル一覧更新
- (int)updateFileList;

@end
