//******************************************************************************
//
// MIDITrail / MTSceneMsg
//
// シーンメッセージクラス
//
// Copyright (C) 2010-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "MTSceneMsg.h"


//##############################################################################
// シーンメッセージクラス
//##############################################################################
//******************************************************************************
// コンストラクタ
//******************************************************************************
MTSceneMsg::MTSceneMsg(
		MTSceneMsgId msgId
	)
{
	m_MsgId = msgId;
	m_pCondition = nil;
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTSceneMsg::~MTSceneMsg(void)
{
	[m_pCondition release];
	m_pCondition = nil;
}

//******************************************************************************
// メッセージID取得
//******************************************************************************
MTSceneMsgId MTSceneMsg::GetMsgId()
{
	return m_MsgId;
}

//******************************************************************************
// 同期モード設定
//******************************************************************************
void MTSceneMsg::SetSyncMode(
		bool isSync
	)
{
	[m_pCondition release];
	m_pCondition = nil;
	
	if (isSync) {
		m_pCondition = [[NSCondition alloc] init];
	}
}

//******************************************************************************
// 同期モード判定
//******************************************************************************
bool MTSceneMsg::IsSyncMode()
{
	bool isSync = false;
	
	if (m_pCondition != nil) {
		isSync = true;
	}
	
	return isSync;
}

//******************************************************************************
// 処理応答待機
//******************************************************************************
void MTSceneMsg::WaitAns()
{
	if (m_pCondition != nil) {
		//処理完了を待ち合わせる
		//  設計上デッドロックは発生しないはずだが念のため最大の待ち合わせ時間を10秒とする
		[m_pCondition lock];
		[m_pCondition waitUntilDate:[NSDate dateWithTimeIntervalSinceNow:10]];
		[m_pCondition unlock];
	}
}

//******************************************************************************
// 処理終了応答
//******************************************************************************
void MTSceneMsg::WakeUp()
{
	if (m_pCondition != nil) {
		[m_pCondition lock];
		[m_pCondition signal];
		[m_pCondition unlock];
	}
}


//##############################################################################
// シーンメッセージクラス：演奏開始
//##############################################################################
//******************************************************************************
// コンストラクタ
//******************************************************************************
MTSceneMsgPlayStart::MTSceneMsgPlayStart(void)
 : MTSceneMsg(MTSCENEMSG_PLAY_START)
{
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTSceneMsgPlayStart::~MTSceneMsgPlayStart(void)
{
}

//##############################################################################
// シーンメッセージクラス：演奏終了
//##############################################################################
//******************************************************************************
// コンストラクタ
//******************************************************************************
MTSceneMsgPlayEnd::MTSceneMsgPlayEnd(void)
 : MTSceneMsg(MTSCENEMSG_PLAY_END)
{
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTSceneMsgPlayEnd::~MTSceneMsgPlayEnd(void)
{
}


//##############################################################################
// シーンメッセージクラス：巻き戻し
//##############################################################################
//******************************************************************************
// コンストラクタ
//******************************************************************************
MTSceneMsgRewind::MTSceneMsgRewind(void)
 : MTSceneMsg(MTSCENEMSG_REWIND)
{
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTSceneMsgRewind::~MTSceneMsgRewind(void)
{
}


//##############################################################################
// シーンメッセージクラス：視点リセット
//##############################################################################
//******************************************************************************
// コンストラクタ
//******************************************************************************
MTSceneMsgResetViewpoint::MTSceneMsgResetViewpoint(void)
 : MTSceneMsg(MTSCENEMSG_RESET_VIEWPOINT)
{
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTSceneMsgResetViewpoint::~MTSceneMsgResetViewpoint(void)
{
}


//##############################################################################
// シーンメッセージクラス：視点登録
//##############################################################################
//******************************************************************************
// コンストラクタ
//******************************************************************************
MTSceneMsgSetViewpoint::MTSceneMsgSetViewpoint(void)
 : MTSceneMsg(MTSCENEMSG_SET_VIEWPOINT)
{
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTSceneMsgSetViewpoint::~MTSceneMsgSetViewpoint(void)
{
}

//******************************************************************************
// 視点情報マップポインタ取得
//******************************************************************************
MTScene::MTViewParamMap* MTSceneMsgSetViewpoint::GetViewParamMapPtr()
{
	return &m_ViewParamMap;
}


//##############################################################################
// シーンメッセージクラス：視点取得
//##############################################################################
//******************************************************************************
// コンストラクタ
//******************************************************************************
MTSceneMsgGetViewpoint::MTSceneMsgGetViewpoint(void)
 : MTSceneMsg(MTSCENEMSG_GET_VIEWPOINT)
{
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTSceneMsgGetViewpoint::~MTSceneMsgGetViewpoint(void)
{
}

//******************************************************************************
// 視点情報マップポインタ取得
//******************************************************************************
MTScene::MTViewParamMap* MTSceneMsgGetViewpoint::GetViewParamMapPtr()
{
	return &m_ViewParamMap;
}


//##############################################################################
// シーンメッセージクラス：エフェクト設定
//##############################################################################
//******************************************************************************
// コンストラクタ
//******************************************************************************
MTSceneMsgSetEffect::MTSceneMsgSetEffect(void)
 : MTSceneMsg(MTSCENEMSG_SET_EFFECT)
{
	m_EffectType = MTScene::EffectPianoKeyboard;
	m_isEnable = true;
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTSceneMsgSetEffect::~MTSceneMsgSetEffect(void)
{
}

//******************************************************************************
// エフェクト可否登録
//******************************************************************************
void MTSceneMsgSetEffect::SetEffect(
		MTScene::EffectType type,
		bool isEnable
	)
{
	m_EffectType = type;
	m_isEnable = isEnable;
}

//******************************************************************************
// エフェクト可否取得
//******************************************************************************
void MTSceneMsgSetEffect::GetEffect(
		MTScene::EffectType* pType,
		bool* pIsEnable
	)
{
	*pType = m_EffectType;
	*pIsEnable = m_isEnable;
}


//##############################################################################
// シーンメッセージクラス：マウスクリックイベント
//##############################################################################
//******************************************************************************
// コンストラクタ
//******************************************************************************
MTSceneMsgOnMouseClick::MTSceneMsgOnMouseClick(void)
 : MTSceneMsg(MTSCENEMSG_ON_MOUSE_CLICK)
{
	m_MouseButton = 0;
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTSceneMsgOnMouseClick::~MTSceneMsgOnMouseClick(void)
{
}

//******************************************************************************
// クリックボタン登録
//******************************************************************************
void MTSceneMsgOnMouseClick::SetClickButton(
		unsigned int button
	)
{
	m_MouseButton = button;
}

//******************************************************************************
// クリックボタン取得
//******************************************************************************
unsigned int MTSceneMsgOnMouseClick::GetClickButton()
{
	return m_MouseButton;
}


//##############################################################################
// シーンメッセージクラス：マウスホイールイベント
//##############################################################################
//******************************************************************************
// コンストラクタ
//******************************************************************************
MTSceneMsgOnMouseWheel::MTSceneMsgOnMouseWheel(void)
 : MTSceneMsg(MTSCENEMSG_ON_MOUSE_WHEEL)
{
	m_DeltaWheelX = 0;
	m_DeltaWheelY = 0;
	m_DeltaWheelZ = 0;
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTSceneMsgOnMouseWheel::~MTSceneMsgOnMouseWheel(void)
{
}

//******************************************************************************
// マウスホイール移動量デルタ設定
//******************************************************************************
void MTSceneMsgOnMouseWheel::SetWheelDelta(
		float deltaWheelX,
		float deltaWheelY,
		float deltaWheelZ
	)
{
	m_DeltaWheelX = deltaWheelX;
	m_DeltaWheelY = deltaWheelY;
	m_DeltaWheelZ = deltaWheelZ;
}

//******************************************************************************
// マウスホイール移動量デルタ取得
//******************************************************************************
void MTSceneMsgOnMouseWheel::GetWheelDelta(
		float* pDeltaWheelX,
		float* pDeltaWheelY,
		float* pDeltaWheelZ
	)
{
	*pDeltaWheelX = m_DeltaWheelX;
	*pDeltaWheelY = m_DeltaWheelY;
	*pDeltaWheelZ = m_DeltaWheelZ;
}


//##############################################################################
// シーンメッセージクラス：シーン停止
//##############################################################################
//******************************************************************************
// コンストラクタ
//******************************************************************************
MTSceneMsgStopScene::MTSceneMsgStopScene(void)
 : MTSceneMsg(MTSCENEMSG_STOP_SCENE)
{
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTSceneMsgStopScene::~MTSceneMsgStopScene(void)
{
}


