//******************************************************************************
//
// MIDITrail / MTColorCfgDlg
//
// カラー設定ダイアログ
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "MTColorConf.h"


//******************************************************************************
// カラー設定ダイアログクラス
//******************************************************************************
@interface MTColorCfgDlg : NSWindowController {
	
	//ラジオボタン
	IBOutlet NSButton* m_pBtnRadioDefault;
	IBOutlet NSButton* m_pBtnRadioPalette1;
	IBOutlet NSButton* m_pBtnRadioPalette2;
	IBOutlet NSButton* m_pBtnRadioPalette3;
	IBOutlet NSButton* m_pBtnRadioPalette4;
	IBOutlet NSButton* m_pBtnRadioPalette5;
	IBOutlet NSButton* m_pBtnRadioPalette6;
	//カラーパレット0
	IBOutlet NSColorWell *m_pColorWell_0_1;
	IBOutlet NSColorWell *m_pColorWell_0_2;
	IBOutlet NSColorWell *m_pColorWell_0_3;
	IBOutlet NSColorWell *m_pColorWell_0_4;
	IBOutlet NSColorWell *m_pColorWell_0_5;
	IBOutlet NSColorWell *m_pColorWell_0_6;
	IBOutlet NSColorWell *m_pColorWell_0_7;
	IBOutlet NSColorWell *m_pColorWell_0_8;
	IBOutlet NSColorWell *m_pColorWell_0_9;
	IBOutlet NSColorWell *m_pColorWell_0_10;
	IBOutlet NSColorWell *m_pColorWell_0_11;
	IBOutlet NSColorWell *m_pColorWell_0_12;
	IBOutlet NSColorWell *m_pColorWell_0_13;
	IBOutlet NSColorWell *m_pColorWell_0_14;
	IBOutlet NSColorWell *m_pColorWell_0_15;
	IBOutlet NSColorWell *m_pColorWell_0_16;
	IBOutlet NSColorWell *m_pColorWell_0_BG;
	IBOutlet NSColorWell *m_pColorWell_0_GL;
	IBOutlet NSColorWell *m_pColorWell_0_CT;
	//カラーパレット1
	IBOutlet NSColorWell *m_pColorWell_1_1;
	IBOutlet NSColorWell *m_pColorWell_1_2;
	IBOutlet NSColorWell *m_pColorWell_1_3;
	IBOutlet NSColorWell *m_pColorWell_1_4;
	IBOutlet NSColorWell *m_pColorWell_1_5;
	IBOutlet NSColorWell *m_pColorWell_1_6;
	IBOutlet NSColorWell *m_pColorWell_1_7;
	IBOutlet NSColorWell *m_pColorWell_1_8;
	IBOutlet NSColorWell *m_pColorWell_1_9;
	IBOutlet NSColorWell *m_pColorWell_1_10;
	IBOutlet NSColorWell *m_pColorWell_1_11;
	IBOutlet NSColorWell *m_pColorWell_1_12;
	IBOutlet NSColorWell *m_pColorWell_1_13;
	IBOutlet NSColorWell *m_pColorWell_1_14;
	IBOutlet NSColorWell *m_pColorWell_1_15;
	IBOutlet NSColorWell *m_pColorWell_1_16;
	IBOutlet NSColorWell *m_pColorWell_1_BG;
	IBOutlet NSColorWell *m_pColorWell_1_GL;
	IBOutlet NSColorWell *m_pColorWell_1_CT;
	//カラーパレット2
	IBOutlet NSColorWell *m_pColorWell_2_1;
	IBOutlet NSColorWell *m_pColorWell_2_2;
	IBOutlet NSColorWell *m_pColorWell_2_3;
	IBOutlet NSColorWell *m_pColorWell_2_4;
	IBOutlet NSColorWell *m_pColorWell_2_5;
	IBOutlet NSColorWell *m_pColorWell_2_6;
	IBOutlet NSColorWell *m_pColorWell_2_7;
	IBOutlet NSColorWell *m_pColorWell_2_8;
	IBOutlet NSColorWell *m_pColorWell_2_9;
	IBOutlet NSColorWell *m_pColorWell_2_10;
	IBOutlet NSColorWell *m_pColorWell_2_11;
	IBOutlet NSColorWell *m_pColorWell_2_12;
	IBOutlet NSColorWell *m_pColorWell_2_13;
	IBOutlet NSColorWell *m_pColorWell_2_14;
	IBOutlet NSColorWell *m_pColorWell_2_15;
	IBOutlet NSColorWell *m_pColorWell_2_16;
	IBOutlet NSColorWell *m_pColorWell_2_BG;
	IBOutlet NSColorWell *m_pColorWell_2_GL;
	IBOutlet NSColorWell *m_pColorWell_2_CT;
	//カラーパレット3
	IBOutlet NSColorWell *m_pColorWell_3_1;
	IBOutlet NSColorWell *m_pColorWell_3_2;
	IBOutlet NSColorWell *m_pColorWell_3_3;
	IBOutlet NSColorWell *m_pColorWell_3_4;
	IBOutlet NSColorWell *m_pColorWell_3_5;
	IBOutlet NSColorWell *m_pColorWell_3_6;
	IBOutlet NSColorWell *m_pColorWell_3_7;
	IBOutlet NSColorWell *m_pColorWell_3_8;
	IBOutlet NSColorWell *m_pColorWell_3_9;
	IBOutlet NSColorWell *m_pColorWell_3_10;
	IBOutlet NSColorWell *m_pColorWell_3_11;
	IBOutlet NSColorWell *m_pColorWell_3_12;
	IBOutlet NSColorWell *m_pColorWell_3_13;
	IBOutlet NSColorWell *m_pColorWell_3_14;
	IBOutlet NSColorWell *m_pColorWell_3_15;
	IBOutlet NSColorWell *m_pColorWell_3_16;
	IBOutlet NSColorWell *m_pColorWell_3_BG;
	IBOutlet NSColorWell *m_pColorWell_3_GL;
	IBOutlet NSColorWell *m_pColorWell_3_CT;
	//カラーパレット4
	IBOutlet NSColorWell *m_pColorWell_4_1;
	IBOutlet NSColorWell *m_pColorWell_4_2;
	IBOutlet NSColorWell *m_pColorWell_4_3;
	IBOutlet NSColorWell *m_pColorWell_4_4;
	IBOutlet NSColorWell *m_pColorWell_4_5;
	IBOutlet NSColorWell *m_pColorWell_4_6;
	IBOutlet NSColorWell *m_pColorWell_4_7;
	IBOutlet NSColorWell *m_pColorWell_4_8;
	IBOutlet NSColorWell *m_pColorWell_4_9;
	IBOutlet NSColorWell *m_pColorWell_4_10;
	IBOutlet NSColorWell *m_pColorWell_4_11;
	IBOutlet NSColorWell *m_pColorWell_4_12;
	IBOutlet NSColorWell *m_pColorWell_4_13;
	IBOutlet NSColorWell *m_pColorWell_4_14;
	IBOutlet NSColorWell *m_pColorWell_4_15;
	IBOutlet NSColorWell *m_pColorWell_4_16;
	IBOutlet NSColorWell *m_pColorWell_4_BG;
	IBOutlet NSColorWell *m_pColorWell_4_GL;
	IBOutlet NSColorWell *m_pColorWell_4_CT;
	//カラーパレット5
	IBOutlet NSColorWell *m_pColorWell_5_1;
	IBOutlet NSColorWell *m_pColorWell_5_2;
	IBOutlet NSColorWell *m_pColorWell_5_3;
	IBOutlet NSColorWell *m_pColorWell_5_4;
	IBOutlet NSColorWell *m_pColorWell_5_5;
	IBOutlet NSColorWell *m_pColorWell_5_6;
	IBOutlet NSColorWell *m_pColorWell_5_7;
	IBOutlet NSColorWell *m_pColorWell_5_8;
	IBOutlet NSColorWell *m_pColorWell_5_9;
	IBOutlet NSColorWell *m_pColorWell_5_10;
	IBOutlet NSColorWell *m_pColorWell_5_11;
	IBOutlet NSColorWell *m_pColorWell_5_12;
	IBOutlet NSColorWell *m_pColorWell_5_13;
	IBOutlet NSColorWell *m_pColorWell_5_14;
	IBOutlet NSColorWell *m_pColorWell_5_15;
	IBOutlet NSColorWell *m_pColorWell_5_16;
	IBOutlet NSColorWell *m_pColorWell_5_BG;
	IBOutlet NSColorWell *m_pColorWell_5_GL;
	IBOutlet NSColorWell *m_pColorWell_5_CT;
	//カラーパレット6
	IBOutlet NSColorWell *m_pColorWell_6_1;
	IBOutlet NSColorWell *m_pColorWell_6_2;
	IBOutlet NSColorWell *m_pColorWell_6_3;
	IBOutlet NSColorWell *m_pColorWell_6_4;
	IBOutlet NSColorWell *m_pColorWell_6_5;
	IBOutlet NSColorWell *m_pColorWell_6_6;
	IBOutlet NSColorWell *m_pColorWell_6_7;
	IBOutlet NSColorWell *m_pColorWell_6_8;
	IBOutlet NSColorWell *m_pColorWell_6_9;
	IBOutlet NSColorWell *m_pColorWell_6_10;
	IBOutlet NSColorWell *m_pColorWell_6_11;
	IBOutlet NSColorWell *m_pColorWell_6_12;
	IBOutlet NSColorWell *m_pColorWell_6_13;
	IBOutlet NSColorWell *m_pColorWell_6_14;
	IBOutlet NSColorWell *m_pColorWell_6_15;
	IBOutlet NSColorWell *m_pColorWell_6_16;
	IBOutlet NSColorWell *m_pColorWell_6_BG;
	IBOutlet NSColorWell *m_pColorWell_6_GL;
	IBOutlet NSColorWell *m_pColorWell_6_CT;
	
	//ラジオボタンリスト
	NSButton* m_pBtnRadioPaletteList[MT_COLOR_PALETTE_NUM_MAX];
	
	//カラーウェルリスト
	NSColorWell* m_pColorWellList[MT_COLOR_PALETTE_NUM_MAX][SM_MAX_CH_NUM + 3];
	
	//カラー情報
	MTColorConf m_ColorConf;
	
	//選択カラーパレット番号
	unsigned int m_SelectedColorPaletteNo;
	
	//変更フラグ
	BOOL m_isChanged;
	
}

//--------------------------------------
//公開I/F

//生成
- (id)init;

//破棄
- (void)dealloc;

//モーダルウィンドウ表示
- (void)showModalWindow;

//変更確認
- (BOOL)isCahnged;

//--------------------------------------
//イベントハンドラ

//ウィンドウ読み込み完了
- (void)windowDidLoad;

//OKボタン押下
- (IBAction)onOK:(id)sender;

//キャンセルボタン押下
- (IBAction)onCancel:(id)sender;

//クローズボタン押下
- (void)windowWillClose:(NSNotification*)aNotification;

//ラジオボタン押下
- (IBAction)onBtnRadio:(NSButton *)sender;

//編集ボタン押下
- (IBAction)onBtnEdit1:(id)sender;
- (IBAction)onBtnEdit2:(id)sender;
- (IBAction)onBtnEdit3:(id)sender;
- (IBAction)onBtnEdit4:(id)sender;
- (IBAction)onBtnEdit5:(id)sender;
- (IBAction)onBtnEdit6:(id)sender;

//--------------------------------------
//内部処理

//ダイアログ初期化
- (int)initDlg;

//ラジオボタンリスト初期化
- (void)initRadioButtonList;

//カラーウェルリスト初期化
- (void)initColorWellList;

//ラジオボタン初期化
- (int)initRadioButtons;

//カラーウェル初期化
- (int)initColorWells;

//カラーウェル更新
- (int)updateColorWellForColorPaletteNo:(unsigned int)colorPaletteNo;

//カラーパレット設定ダイアログ表示
- (int)showColorPaletteCfgDlgForPaletteNo:(unsigned int)colorPaletteNo;

@end

