//******************************************************************************
//
// MIDITrail / MTColorPaletteCfgDlg
//
// カラーパレット設定ダイアログ
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "MTColorConf.h"


//******************************************************************************
// 色設定ダイアログクラス
//******************************************************************************
@interface MTColorPaletteCfgDlg : NSWindowController {
	
	//カラーウェル：Ch.1-16,BG
	IBOutlet NSColorWell *m_pColorWell_1;
	IBOutlet NSColorWell *m_pColorWell_2;
	IBOutlet NSColorWell *m_pColorWell_3;
	IBOutlet NSColorWell *m_pColorWell_4;
	IBOutlet NSColorWell *m_pColorWell_5;
	IBOutlet NSColorWell *m_pColorWell_6;
	IBOutlet NSColorWell *m_pColorWell_7;
	IBOutlet NSColorWell *m_pColorWell_8;
	IBOutlet NSColorWell *m_pColorWell_9;
	IBOutlet NSColorWell *m_pColorWell_10;
	IBOutlet NSColorWell *m_pColorWell_11;
	IBOutlet NSColorWell *m_pColorWell_12;
	IBOutlet NSColorWell *m_pColorWell_13;
	IBOutlet NSColorWell *m_pColorWell_14;
	IBOutlet NSColorWell *m_pColorWell_15;
	IBOutlet NSColorWell *m_pColorWell_16;
	IBOutlet NSColorWell *m_pColorWell_BG;
	IBOutlet NSColorWell *m_pColorWell_GL;
	IBOutlet NSColorWell *m_pColorWell_CT;
	//カラーテキスト：Ch.1-16,BG
	IBOutlet NSTextField *m_pColorText_1;
	IBOutlet NSTextField *m_pColorText_2;
	IBOutlet NSTextField *m_pColorText_3;
	IBOutlet NSTextField *m_pColorText_4;
	IBOutlet NSTextField *m_pColorText_5;
	IBOutlet NSTextField *m_pColorText_6;
	IBOutlet NSTextField *m_pColorText_7;
	IBOutlet NSTextField *m_pColorText_8;
	IBOutlet NSTextField *m_pColorText_9;
	IBOutlet NSTextField *m_pColorText_10;
	IBOutlet NSTextField *m_pColorText_11;
	IBOutlet NSTextField *m_pColorText_12;
	IBOutlet NSTextField *m_pColorText_13;
	IBOutlet NSTextField *m_pColorText_14;
	IBOutlet NSTextField *m_pColorText_15;
	IBOutlet NSTextField *m_pColorText_16;
	IBOutlet NSTextField *m_pColorText_BG;
	IBOutlet NSTextField *m_pColorText_GL;
	IBOutlet NSTextField *m_pColorText_CT;
	
	//ポップアップボタン：Start/End
	IBOutlet NSPopUpButton *m_pPopUpBtnStart;
	IBOutlet NSPopUpButton *m_pPopUpBtnEnd;
	//カラーウェル：Start/End
	IBOutlet NSColorWell *m_pColorWell_Start;
	IBOutlet NSColorWell *m_pColorWell_End;
	//カラーテキスト：Start/End
	IBOutlet NSTextField *m_pColorText_Start;
	IBOutlet NSTextField *m_pColorText_End;
	
	//カラーウェルリスト
	NSColorWell* m_pColorWellList[SM_MAX_CH_NUM + 3];
	//カラーテキストリスト
	NSTextField* m_pColorTextList[SM_MAX_CH_NUM + 3];
	
	//カラーパレット
	MTColorPalette m_ColorPalette;
	MTColorPalette m_DefaultColorPalette;
	unsigned int m_ColorPaletteNo;
	
	//変更フラグ
	BOOL m_isChanged;
	
}

//--------------------------------------
//公開I/F

//生成
- (id)init;

//破棄
- (void)dealloc;

//モーダルウィンドウ表示
- (void)showModalWindow;

//変更確認
- (BOOL)isCahnged;

//カラーパレット設定
- (void)setColorPalette:(MTColorPalette*)pColorPalette
	defaultColorPalette:(MTColorPalette*)pDefaultColorPalette
		 colorPaletteNo:(unsigned int)colorPaletteNo;

//カラーパレット取得
- (void)getColorPalette:(MTColorPalette*)pColorPalette;


//--------------------------------------
//イベントハンドラ

//ウィンドウ読み込み完了
- (void)windowDidLoad;

//OKボタン押下
- (IBAction)onOK:(NSButton *)sender;

//キャンセルボタン押下
- (IBAction)onCancel:(NSButton *)sender;

//クローズボタン押下
- (void)windowWillClose:(NSNotification*)aNotification;

//グラデーションツール：Set Gradation Colors ボタン押下
- (IBAction)onBtnSetGradationColors:(NSButton *)sender;

//パラメータセットアップツール：Set Default Colors ボタン押下
- (IBAction)onBtnSetDefaultColors:(NSButton *)sender;

//パラメータセットアップツール：Export Color Parameters ボタン押下
- (IBAction)onBtnExportColorParameters:(NSButton *)sender;

//パラメータセットアップツール：Import Color Parameters ボタン押下
- (IBAction)onBtnImportColorParameters:(NSButton *)sender;

//カラーウェル更新通知
- (IBAction)onColorWell_1:(NSColorWell *)sender;
- (IBAction)onColorWell_2:(NSColorWell *)sender;
- (IBAction)onColorWell_3:(NSColorWell *)sender;
- (IBAction)onColorWell_4:(NSColorWell *)sender;
- (IBAction)onColorWell_5:(NSColorWell *)sender;
- (IBAction)onColorWell_6:(NSColorWell *)sender;
- (IBAction)onColorWell_7:(NSColorWell *)sender;
- (IBAction)onColorWell_8:(NSColorWell *)sender;
- (IBAction)onColorWell_9:(NSColorWell *)sender;
- (IBAction)onColorWell_10:(NSColorWell *)sender;
- (IBAction)onColorWell_11:(NSColorWell *)sender;
- (IBAction)onColorWell_12:(NSColorWell *)sender;
- (IBAction)onColorWell_13:(NSColorWell *)sender;
- (IBAction)onColorWell_14:(NSColorWell *)sender;
- (IBAction)onColorWell_15:(NSColorWell *)sender;
- (IBAction)onColorWell_16:(NSColorWell *)sender;
- (IBAction)onColorWell_BG:(NSColorWell *)sender;
- (IBAction)onColorWell_GL:(NSColorWell *)sender;
- (IBAction)onColorWell_CT:(NSColorWell *)sender;
- (IBAction)onColorWell_Start:(NSColorWell *)sender;
- (IBAction)onColorWell_End:(NSColorWell *)sender;

//--------------------------------------
//内部処理

//ダイアログ初期化
- (int)initDlg;

//カラーウェルリスト初期化
- (void)initColorWellList;

//カラーウェル設定：パレット
- (int)initColorWellsWithPalette:(MTColorPalette*)pColorPalette;

//カラーウェル設定：Start/End
- (int)initColorWellsStartEnd;

//ポップアップボタン初期化
- (void)initPopUpButton:(NSPopUpButton*)pPopUpButton selectedIndex:(NSInteger)selectedIndex;

//カラーテキスト更新
- (void)updateColorText:(NSTextField*)pTextField colorWell:(NSColorWell*)pColorWell;

//カラーパレット更新
- (int)updatePalette;

//グラデーションカラー設定
- (void)setGradationColorWithChNoStart:(unsigned int)chNoStart
							   chNoEnd:(unsigned int)chNoEnd
							colorStart:(OGLCOLOR)colorStart
							  colorEnd:(OGLCOLOR)colorEnd;

//出力用パラメータ文字列生成
-(NSString*)makeColorParamForExport;

//パラメータ入力処理
- (int)importColorParam:(NSString*)pString;

@end

