//******************************************************************************
//
// MIDITrail / MTColorParamExportDlg
//
// カラーパラメータ出力ダイアログ
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************


//******************************************************************************
// カラーパラメータ出力ダイアログ
//******************************************************************************
@interface MTColorParamExportDlg : NSWindowController {
	
	//テキストフィールド
	IBOutlet NSTextField *m_pTextField;
	
	//パラメータ文字列
	NSString* m_pParamText;
	
}

//--------------------------------------
//公開I/F

//生成
- (id)init;

//破棄
- (void)dealloc;

//パラメータ文字列登録
- (void)setParamString:(NSString*)pString;

//モーダルウィンドウ表示
- (void)showModalWindow;

//--------------------------------------
//イベントハンドラ

//ウィンドウ読み込み完了
- (void)windowDidLoad;

//OKボタン押下
- (IBAction)onOK:(NSButton *)sender;

//コピーボタン押下
- (IBAction)onBtnCopy:(NSButton *)sender;

//クローズボタン押下
- (void)windowWillClose:(NSNotification*)aNotification;

//--------------------------------------
//内部処理

//ダイアログ初期化
- (int)initDlg;

@end

