//******************************************************************************
//
// MIDITrail / MTGridRing
//
// グリッドリング描画クラス
//
// Copyright (C) 2019-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#import "OGLUtil.h"
#import "SMIDILib.h"
#import "MTNoteDesignRing.h"


//******************************************************************************
//  グリッドリング描画クラス
//******************************************************************************
class MTGridRing
{
public:

	//コンストラクタ／デストラクタ
	MTGridRing(void);
	virtual ~MTGridRing(void);

	//生成
	int Create(OGLDevice* pOGLDevice, NSString* pSceneName, SMSeqData* pSeqData);

	//更新
	int Transform(OGLDevice* pOGLDevice, float rollAngle);

	//描画
	int Draw(OGLDevice* pOGLDevice);

	//解放
	void Release();

	//表示設定
	void SetEnable(bool isEnable);
	
	//演奏チックタイム登録
	void SetCurTickTime(unsigned int curTickTime);
	
	//リセット
	void Reset();
	
private:

	OGLPrimitive m_Primitive;
	SMPortList m_PortList;
	MTNoteDesignRing m_NoteDesign;
	bool m_isVisible;
	bool m_isEnable;
	unsigned int m_CurTickTime;

	//頂点バッファ構造体
	typedef OGLVERTEX_V3N3C MTGRIDBOX_VERTEX;
	//struct MTGRIDBOX_VERTEX {
	//	OGLVECTOR3 p;	//頂点座標
	//	OGLVECTOR3 n;	//法線
	//	DWORD		c;	//ディフューズ色
	//};

	//頂点バッファFVFフォーマット
	unsigned int _GetFVFFormat(){ return OGLVERTEX_TYPE_V3N3C; }
	
	//グリッド頂点生成
	int _CreateVertexOfGrid(
			MTGRIDBOX_VERTEX* pVertex,
			unsigned int* pIbIndex,
			unsigned int totalTickTime,
			SMBarList* pBarList
		);
	
	//リング頂点生成
	int _CreateVertexOfRing(
			MTGRIDBOX_VERTEX* pVertex,
			unsigned int* pVirtexIndex,
			unsigned int* pIndex,
			OGLVECTOR3 basePos
		);
	
	void _MakeMaterial(OGLMATERIAL* pMaterial);

};

