//******************************************************************************
//
// MIDITrail / MTPictBoardRing
//
// ピクチャボードリング描画クラス
//
// Copyright (C) 2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "OGLUtil.h"
#import "SMIDILib.h"
#import "MTNoteDesignRing.h"


//******************************************************************************
//  ピクチャボードリング描画クラス
//******************************************************************************
class MTPictBoardRing
{
public:

	//コンストラクタ／デストラクタ
	MTPictBoardRing(void);
	virtual ~MTPictBoardRing(void);

	//生成
	int Create(OGLDevice* pOGLDevice, NSString* pSceneName, SMSeqData* pSeqData, bool isReverseMode);

	//更新
	int Transform(OGLDevice* pOGLDevice, OGLVECTOR3 camVector, float rollAngle);

	//描画
	int Draw(OGLDevice* pOGLDevice);

	//解放
	void Release();

	//演奏チックタイム登録
	void SetCurTickTime(unsigned int curTickTime);

	//リセット
	void Reset();

	//演奏開始終了
	void OnPlayStart();
	void OnPlayEnd();

	//表示設定
	void SetEnable(bool isEnable);

private:

	OGLPrimitive m_Primitive;
	OGLTexture m_Texture;
	unsigned int m_CurTickTime;
	bool m_isPlay;
	bool m_isEnable;
	MTNoteDesignRing m_NoteDesign;
	bool m_isClipImage;
	OGLVECTOR2 m_ClipAreaP1;
	OGLVECTOR2 m_ClipAreaP2;
	
	//頂点バッファ構造体
	typedef OGLVERTEX_V3N3CT2 MTPICTBOARD_VERTEX;
	//struct MTPICTBOARD_VERTEX {
	//	OGLVECTOR3 p;	//頂点座標
	//	OGLVECTOR3 n;	//法線
	//	DWORD		c;	//ディフューズ色
	//	D3DXVECTOR2 t;	//テクスチャ画像位置
	//};

	//頂点バッファFVFフォーマット
	unsigned int _GetFVFFormat(){ return OGLVERTEX_TYPE_V3N3CT2; }

	int _CreateVertexOfBoard(
			MTPICTBOARD_VERTEX* pVertex,
			unsigned int* pIbIndex,
			bool isReverseMode
		);

	int _LoadTexture(OGLDevice* pOGLDevice, NSString* pSceneName);

};


