//******************************************************************************
//
// OGL Utility / OGLShaders
//
// シェーダ定義
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO
//  (1) V3N3C : 頂点座標／法線ベクトル／色
//  (2) V3CT2 : 頂点座標／色／テクスチャ座標
//  (3) V3N3CT2 : 頂点座標／法線ベクトル／色／テクスチャ座標
//  頂点が色を持つ場合はマテリアルの拡散光色を無視する

#include <simd/simd.h>

using namespace simd;


//******************************************************************************
// パラメータ定義
//******************************************************************************
//------------------------------------------------------------------------------
// 構造体定義
//------------------------------------------------------------------------------
//マテリアル
typedef struct {
	float3 diffuseColor;		//拡散光色
	float3 ambientColor;		//環境光色
	float3 specularColor;		//鏡面反射光色
	float specularPower;		//鏡面反射光の強さ
} OGLMaterial;

//ライト
typedef struct {
	uint enable;				//有効フラグ 無効:0 有効:1
	float3 direction;			//方向：ビュー行列で変換済みであること
	float3 diffuseColor;		//拡散光色
	float3 ambientColor;		//環境光色
	float3 specularColor;		//鏡面反射光色
} OGLLight;

//制御情報
typedef struct {
	float4x4 modelViewProjectionMatrix;	//モデルビュープロジェクション行列
	float4x4 modelViewMatrix;	//モデルビュー行列
	float4x4 normalMatrix;		//法線行列
	OGLMaterial material;		//マテリアル
	uint enableLights;			//ライト有効フラグ 無効:0 有効:1
	OGLLight light0;			//ライト0
	OGLLight light1;			//ライト1
	float pointSize;			//点サイズ
} OGLUniforms;

//------------------------------------------------------------------------------
// 属性番号定義
//------------------------------------------------------------------------------
//頂点 V3N3C 属性番号
#define VertexV3N3C_Attribute_Position        (0)
#define VertexV3N3C_Attribute_Normal          (1)
#define VertexV3N3C_Attribute_Color           (2)

//頂点 V3CT2 属性番号
#define VertexV3CT2_Attribute_Position        (0)
#define VertexV3CT2_Attribute_Color           (1)
#define VertexV3CT2_Attribute_TextureCoords   (2)

//頂点 V3N3CT2 属性番号
#define VertexV3N3CT2_Attribute_Position      (0)
#define VertexV3N3CT2_Attribute_Normal        (1)
#define VertexV3N3CT2_Attribute_Color         (2)
#define VertexV3N3CT2_Attribute_TextureCoords (3)

//------------------------------------------------------------------------------
// インデックス番号定義
//------------------------------------------------------------------------------
//バッファインデックス番号
#define BufferIndex_Vertices   (0)
#define BufferIndex_Uniforms   (1)

//テクスチャインデックス番号
#define TextureIndex0          (0)

