//******************************************************************************
//
// MIDITrail / MTCmdLineParser
//
// R}hC̓NX
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "SMRcpConv.h"
#include "MTCmdLineParser.h"
#include <tchar.h>
#include <stdlib.h>
#include <shellapi.h>

using namespace YNBaseLib;
using namespace SMIDILib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTCmdLineParser::MTCmdLineParser(void)
{
	m_pFilePath = L"";
	ZeroMemory(m_CmdSwitchStatus, sizeof(unsigned char)*CMDSW_MAX);
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTCmdLineParser::~MTCmdLineParser(void)
{
}

//******************************************************************************
// 
//******************************************************************************
int MTCmdLineParser::Initialize()
{
	int result = 0;

	//R}hC
	result = _AnalyzeCmdLine();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// R}hC
//******************************************************************************
int MTCmdLineParser::_AnalyzeCmdLine()
{
	int result = 0;
	int i = 0;
	int argc = 0;
	LPWSTR* pArgList = NULL;
	WCHAR* pArg = NULL;
	SMRcpConv rcpConv;

	//RCPǂݍ݉ۊmF̂RCPt@CϊIuWFNgpӂ
	result = rcpConv.Initialize();
	if (result != 0) goto EXIT;

	//Xg擾
	pArgList = CommandLineToArgvW(GetCommandLineW(), &argc);
	if (pArgList == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//̉
	for (i = 1; i < argc; i++) {
		pArg = pArgList[i];

		//t@CpX
		//  t@CpXw肳ꂽꍇ͐擪݂̗̂p
		if ((wcslen(m_pFilePath) == 0) && (wcslen(pArg) > 4)) {
			if (YNPathUtil::IsFileExtMatch(pArg, L".mid")) {
				m_pFilePath = pArg;
				m_CmdSwitchStatus[CMDSW_FILE_PATH] = CMDSW_ON;
			}
			//rcpcv.dllLȂT|[gΏۃt@Cł邩ǉmF
			else if (rcpConv.IsAvailable() && rcpConv.IsSupportFileExt(pArg)) {
				m_pFilePath = pArg;
				m_CmdSwitchStatus[CMDSW_FILE_PATH] = CMDSW_ON;
			}
		}
		//NɍĐJn
		if (wcscmp(pArg, L"-p") == 0) {
			m_CmdSwitchStatus[CMDSW_PLAY] = CMDSW_ON;
		}
		//ĐIɃAvI
		if (wcscmp(pArg, L"-q") == 0) {
			m_CmdSwitchStatus[CMDSW_QUIET] = CMDSW_ON;
		}
		//fobO[h
		if (wcscmp(pArg, L"-d") == 0) {
			m_CmdSwitchStatus[CMDSW_DEBUG] = CMDSW_ON;
		}
	}

	//t@CpXw̏ꍇ
	if (m_CmdSwitchStatus[CMDSW_FILE_PATH] != CMDSW_ON) {
		//Đ^ItO͋ɖ
		m_CmdSwitchStatus[CMDSW_PLAY] = CMDSW_NONE;
		m_CmdSwitchStatus[CMDSW_QUIET] = CMDSW_NONE;
	}

	//ĐtOONłȂΏItO͖
	if (m_CmdSwitchStatus[CMDSW_PLAY] != CMDSW_ON) {
		m_CmdSwitchStatus[CMDSW_QUIET] = CMDSW_NONE;
	}

EXIT:;
	if (pArgList != NULL) {
		LocalFree(pArgList);
	}
	return result;
}

//******************************************************************************
// XCb`Ԏ擾
//******************************************************************************
int MTCmdLineParser::GetSwitch(
		unsigned long switchType
	)
{
	int switchStatus = CMDSW_NONE;

	if (switchType < CMDSW_MAX) {
		switchStatus = m_CmdSwitchStatus[switchType];
	}

	return switchStatus;
}

//******************************************************************************
// t@CpX擾
//******************************************************************************
const WCHAR* MTCmdLineParser::GetFilePath()
{
	return m_pFilePath;
}


