//******************************************************************************
//
// MIDITrail / MTColorCfgDlg
//
// J[ݒ_CAO
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "YNBaseLib.h"
#include "MTColorConf.h"
#include "MTColorPaletteCfgDlg.h"

using namespace YNBaseLib;


//******************************************************************************
// J[ݒ_CAONX
//******************************************************************************
class MTColorCfgDlg
{
public:

	//RXgN^^fXgN^
	MTColorCfgDlg(void);
	virtual ~MTColorCfgDlg(void);

	//\F_CAO܂ŐԂȂ
	int Show(HWND hParentWnd);

	//p[^ύXmF
	bool IsChanged();

private:

	//EBhEvV[Wp|C^
	static MTColorCfgDlg* m_pThis;

	//AvP[VCX^X
	HINSTANCE m_hInstance;

	//EBhEnh
	HWND m_hWnd;

	//WI{^Xg
	HWND m_hBtnRadioPaletteList[MT_COLOR_PALETTE_NUM_MAX];

	//J[{^Xg
	HWND m_hBtnColorList[MT_COLOR_PALETTE_NUM_MAX][SM_MAX_CH_NUM + 3];

	//J[
	MTColorConf m_ColorConf;

	//IJ[pbgԍ
	int m_SelectedColorPaletteNo;

	//ύXtO
	bool m_isChanged;

	//J[pbgݒ_CAO
	MTColorPaletteCfgDlg m_ColorPaletteCfgDlg;

	//EBhEvV[W
	static INT_PTR CALLBACK _WndProc(HWND, UINT, WPARAM, LPARAM);
	INT_PTR _WndProcImpl(const HWND hWnd, const UINT message, const WPARAM wParam, const LPARAM lParam);

	//_CAO\O
	int _OnInitDlg(HWND hDlg);

	//WI{^Xg
	void _InitRadioButtonList();

	//J[{^Xg
	void _InitColorButtonList();

	//WI{^
	int _InitRadioButtons();

	//J[{^
	int _InitColorButtons();

	//WI{^
	int _OnBtnRadio(unsigned long buttonNo);

	//ҏW{^
	int _OnBtnEdit(unsigned long paletteNo);

	//J[pbgݒ_CAO\
	int _ShowColorPaletteCfgDlg(unsigned long colorPaletteNo);

	//J[{^XV
	int _UpdateColorButtons(unsigned long colorPaletteNo);

	//J[{^`
	int _DrawColorButton(DRAWITEMSTRUCT* pDrawItem);

	//J[ݒۑ
	int _Save();

};


