//******************************************************************************
//
// MIDITrail / MTGridRing
//
// ObhO`NX
//
// Copyright (C) 2019-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTGridRing.h"
#include "DXH.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTGridRing::MTGridRing(void)
{
	m_isVisible = true;
	m_isEnable = true;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTGridRing::~MTGridRing(void)
{
	Release();
}

//******************************************************************************
// Obh
//******************************************************************************
int MTGridRing::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		SMSeqData* pSeqData
   )
{
	int result = 0;
	SMBarList barList;
	unsigned long barNum = 0;
	unsigned long vertexNum = 0;
	unsigned long indexNum = 0;
	MTGRIDBOX_VERTEX* pVertex = NULL;
	unsigned long* pIndex = NULL;
	unsigned long totalTickTime = 0;
	D3DMATERIAL9 material;
	D3DXCOLOR lineColor;

	Release();

	if ((pD3DDevice == NULL) || (pSeqData == NULL)) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//m[gfUCIuWFNg
	result = m_NoteDesign.Initialize(pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	//V[PXf[^Fԏ擾
	totalTickTime = pSeqData->GetTotalTickTime();

	//V[PXf[^F߃Xg擾
	result = pSeqData->GetBarList(&barList);
	if (result != 0) goto EXIT;

	//V[PXf[^F|[gXg擾
	result = pSeqData->GetPortList(&m_PortList);
	if (result != 0) goto EXIT;

	//ߐ
	barNum = barList.GetSize();

	//v~eBu
	result = m_Primitive.Initialize(
					sizeof(MTGRIDBOX_VERTEX),	//_TCY
					_GetFVFFormat(),			//_FVFtH[}bg
					D3DPT_LINELIST				//v~eBu
				);
	if (result != 0) goto EXIT;

	//_obt@F1O128_ * (ߐ + I[)
	vertexNum = 128 * (barNum + 1);
	result = m_Primitive.CreateVertexBuffer(pD3DDevice, vertexNum);
	if (result != 0) goto EXIT;

	//CfbNXobt@F1O128 * 2(n_/I_) * (ߐ + I[)
	indexNum = 128 * 2 * (barNum + 1);
	result = m_Primitive.CreateIndexBuffer(pD3DDevice, indexNum);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_Primitive.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;
	result = m_Primitive.LockIndex(&pIndex);
	if (result != 0) goto EXIT;

	//Obh{bNX̒_ƃCfbNX𐶐
	result = _CreateVertexOfGrid(
					pVertex,		//_obt@݈ʒu
					pIndex,			//CfbNXobt@݈ʒu
					totalTickTime,	//g[^`bN^C
					&barList
				);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_Primitive.UnlockVertex();
	if (result != 0) goto EXIT;
	result = m_Primitive.UnlockIndex();
	if (result != 0) goto EXIT;

	//}eA쐬
	_MakeMaterial(&material);
	m_Primitive.SetMaterial(material);

	//Obh̐FmF
	lineColor = m_NoteDesign.GetGridLineColor();
	if (((DWORD)lineColor & 0xFF000000) == 0) {
		//Ȃ`悵Ȃ
		m_isVisible = false;
	}

EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTGridRing::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		float rollAngle
	)
{
	int result = 0;
	D3DXVECTOR3 moveVector;
	D3DXMATRIX rotateMatrix;
	D3DXMATRIX moveMatrix;
	D3DXMATRIX worldMatrix;

	//s񏉊
	D3DXMatrixIdentity(&rotateMatrix);
	D3DXMatrixIdentity(&moveMatrix);
	D3DXMatrixIdentity(&worldMatrix);

	//]s
	D3DXMatrixRotationX(&rotateMatrix, D3DXToRadian(rollAngle));

	//ړs
	moveVector = m_NoteDesign.GetWorldMoveVector();
	D3DXMatrixTranslation(&moveMatrix, moveVector.x, moveVector.y, moveVector.z);

	//s̍
	D3DXMatrixMultiply(&worldMatrix, &rotateMatrix, &moveMatrix);

	//ϊsݒ
	m_Primitive.Transform(worldMatrix);

	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTGridRing::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;

	if (m_isEnable && m_isVisible) {
		result = m_Primitive.Draw(pD3DDevice);
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTGridRing::Release()
{
	m_Primitive.Release();
}

//******************************************************************************
// Obh_
//******************************************************************************
int MTGridRing::_CreateVertexOfGrid(
		MTGRIDBOX_VERTEX* pVertex,
		unsigned long* pIndex,
		unsigned long totalTickTime,
		SMBarList* pBarList
	)
{
	int result = 0;
	unsigned long i = 0;
	unsigned long vertexIndex = 0;
	unsigned long tickTime = 0;
	D3DXVECTOR3 basePos;
	
	//ߒPʂ̃O
	for (i = 0; i < pBarList->GetSize(); i++) {
		result = pBarList->GetBar(i, &tickTime);
		if (result != 0) goto EXIT;
		
		m_NoteDesign.GetGridRingBasePos(tickTime, &basePos);
		result = _CreateVertexOfRing(pVertex, &vertexIndex, pIndex, basePos);
		if (result != 0) goto EXIT;
	}
	
	//I[O
	m_NoteDesign.GetGridRingBasePos(totalTickTime, &basePos);
	result = _CreateVertexOfRing(pVertex, &vertexIndex, pIndex, basePos);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// O_
//******************************************************************************
int MTGridRing::_CreateVertexOfRing(
		MTGRIDBOX_VERTEX* pVertex,
		unsigned long* pVirtexIndex,
		unsigned long* pIndex,
		D3DXVECTOR3 basePos
	)
{
	int result = 0;
	unsigned long virtexIndexStart = 0;
	unsigned long virtexIndex = 0;
	unsigned long i = 0;
	D3DXVECTOR3 rotatedPos;
	float angle = 0.0f;
	
	//----------------------------------
	//I[O
	//----------------------------------
	//_쐬
	virtexIndexStart = *pVirtexIndex;
	virtexIndex = *pVirtexIndex;
	pVertex[virtexIndex].p = basePos;
	pVertex[virtexIndex].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	pVertex[virtexIndex].c = m_NoteDesign.GetGridLineColor();
	for (i = 1; i < 128; i++) {
		virtexIndex++;
		
		//]̒_
		angle = (360.0f / 128.0f) * (float)i;
		rotatedPos = DXH::RotateYZ(0.0f, 0.0f, basePos, angle);
		pVertex[virtexIndex].p = rotatedPos;
		pVertex[virtexIndex].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
		pVertex[virtexIndex].c = m_NoteDesign.GetGridLineColor();
		
		//CfbNXobt@iO̒_獡̒_j
		pIndex[(virtexIndex - 1) * 2]     = virtexIndex - 1;
		pIndex[(virtexIndex - 1) * 2 + 1] = virtexIndex;
	}
	//I_Ǝn_Ȃ
	pIndex[virtexIndex * 2]     = virtexIndex;
	pIndex[virtexIndex * 2 + 1] = virtexIndexStart;
	
	virtexIndex++;
	*pVirtexIndex = virtexIndex;
	
	return result;
}

//******************************************************************************
// }eA쐬
//******************************************************************************
void MTGridRing::_MakeMaterial(
		D3DMATERIAL9* pMaterial
	)
{
	ZeroMemory(pMaterial, sizeof(D3DMATERIAL9));

	//gU
	pMaterial->Diffuse.r = 1.0f;
	pMaterial->Diffuse.g = 1.0f;
	pMaterial->Diffuse.b = 1.0f;
	pMaterial->Diffuse.a = 1.0f;
	//Fe̐F
	pMaterial->Ambient.r = 0.5f;
	pMaterial->Ambient.g = 0.5f;
	pMaterial->Ambient.b = 0.5f;
	pMaterial->Ambient.a = 1.0f;
	//ʔˌ
	pMaterial->Specular.r = 0.2f;
	pMaterial->Specular.g = 0.2f;
	pMaterial->Specular.b = 0.2f;
	pMaterial->Specular.a = 1.0f;
	//ʔˌ̑Nx
	pMaterial->Power = 10.0f;
	//F
	pMaterial->Emissive.r = 0.0f;
	pMaterial->Emissive.g = 0.0f;
	pMaterial->Emissive.b = 0.0f;
	pMaterial->Emissive.a = 0.0f;
}

//******************************************************************************
// \ݒ
//******************************************************************************
void MTGridRing::SetEnable(
		bool isEnable
	)
{
	m_isEnable = isEnable;
}


