//******************************************************************************
//
// MIDITrail / MTLogo
//
// MIDITrail S`NX
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "MTFontTexture.h"


//******************************************************************************
// p[^`
//******************************************************************************
//^Cg
#define MTLOGO_TITLE  L"MIDITrail"

//S`ʒu
#define MTLOGO_POS_X  (20.0f)   //`ʒux
#define MTLOGO_POS_Y  (-15.0f)  //`ʒuy
#define MTLOGO_MAG    (0.1f)    //g嗦

//^C
#define MTLOGO_TILE_NUM  (40)

//Of[VԊԊu(msec)
#define MTLOGO_GRADATION_TIME  (1000)


//******************************************************************************
// MIDITrail S`NX
//******************************************************************************
class MTLogo
{
public:

	//RXgN^^fXgN^l
	MTLogo(void);
	virtual ~MTLogo(void);

	//
	int Create(LPDIRECT3DDEVICE9 pD3DDevice);

	//ϊ
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//j
	void Release();

private:

	//_obt@\
	struct MTLOGO_VERTEX {
		D3DXVECTOR3 p;		//_W
		D3DXVECTOR3 n;		//@
		DWORD		c;		//fBt[YF
		D3DXVECTOR2	t;		//eNX`摜ʒu
	};

	//_obt@[̃tH[}bg̒`FWϊς݂w
	DWORD _GetFVFFormat(){ return (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE | D3DFVF_TEX1); }

private:

	//tHgeNX`
	MTFontTexture m_FontTexture;
	MTLOGO_VERTEX* m_pVertex;

	unsigned long m_StartTime;
	unsigned long m_GradationTime;

	int _CreateTexture(LPDIRECT3DDEVICE9 pD3DDevice);

	int _CreateVertex();

	int _GetTextureUV(
			TCHAR target,
			D3DXVECTOR2* pV0,
			D3DXVECTOR2* pV1,
			D3DXVECTOR2* pV2,
			D3DXVECTOR2* pV3
		);

	void _SetVertexPosition(
			MTLOGO_VERTEX* pVertex,
			float x,
			float y,
			float magRate
		);

	void _SetGradationColor();

	void _SetTileColor(
			MTLOGO_VERTEX* pVertex,
			float color
		);

};

