//******************************************************************************
//
// Simple MIDI Library / SMRcpConv
//
// RCPt@CϊNX
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "shlwapi.h"
#include "YNBaseLib.h"
#include "SMRcpConv.h"
#include <io.h>

using namespace YNBaseLib;

namespace SMIDILib {


//******************************************************************************
// RXgN^
//******************************************************************************
SMRcpConv::SMRcpConv(void)
{
	m_hModule = NULL;
	m_pFuncConvertFile = NULL;
	m_pFuncSaveSMF = NULL;
	m_pFuncDeleteObject = NULL;
}

//******************************************************************************
// fXgN^
//******************************************************************************
SMRcpConv::~SMRcpConv(void)
{
	_Release();
}

//******************************************************************************
// 
//******************************************************************************
int SMRcpConv::Initialize()
{
	int result = 0;
	TCHAR dllFilePath[_MAX_PATH] = {_T('\0')};

	_Release();

	//vZXst@CfBNgpX擾
	result = YNPathUtil::GetModuleDirPath(dllFilePath, _MAX_PATH);
	if (result != 0) goto EXIT;

	//DLLt@CpX
	_tcscat_s(dllFilePath, _MAX_PATH, _T("RCPCV.DLL"));

	//DLL݊mF
	if (!PathFileExists(dllFilePath)) {
		//DLL݂Ȃ̂ŉI
		goto EXIT;
	}

	//DLLǂݍ
	//  LoadLibrary / FreeLibrary APIŎQƃJEgǗ邽
	//  {NX̃CX^X݂ĂȂ
	m_hModule = LoadLibrary(dllFilePath);
	if (m_hModule == NULL) {
		result = YN_SET_ERR("LoadLibrary Error. (rcpcv.dll)", GetLastError(), 0);
		goto EXIT;
	}

	//֐|C^擾FrcpcvConvertFile
	m_pFuncConvertFile = (RCPCV_ConvertFile)GetProcAddress(m_hModule, "rcpcvConvertFile");
	if (m_pFuncConvertFile == NULL) {
		result = YN_SET_ERR("GetProcAddress Error. (rcpcv.dll)", GetLastError(), 0);
		goto EXIT;
	}

	//֐|C^擾FrcpcvSaveSMF
	m_pFuncSaveSMF = (RCPCV_SaveSMF)GetProcAddress(m_hModule, "rcpcvSaveSMF");
	if (m_pFuncSaveSMF == NULL) {
		result = YN_SET_ERR("GetProcAddress Error. (rcpcv.dll)", GetLastError(), 0);
		goto EXIT;
	}

	//֐|C^擾FrcpcvDeleteObject
	m_pFuncDeleteObject = (RCPCV_DeleteObject)GetProcAddress(m_hModule, "rcpcvDeleteObject");
	if (m_pFuncDeleteObject == NULL) {
		result = YN_SET_ERR("GetProcAddress Error. (rcpcv.dll)", GetLastError(), 0);
		goto EXIT;
	}

	//֐|C^擾FrcpcvConvertFileFromBuffer
	m_pFuncConvertFileFromBuffer = (RCPCV_ConvertFileFromBuffer)GetProcAddress(m_hModule, "rcpcvConvertFileFromBuffer");
	if (m_pFuncConvertFileFromBuffer == NULL) {
		result = YN_SET_ERR("GetProcAddress Error. (rcpcv.dll)", GetLastError(), 0);
		goto EXIT;
	}

	//֐|C^擾FrcpcvGetSMF
	m_pFuncGetSMF = (RCPCV_GetSMF)GetProcAddress(m_hModule, "rcpcvGetSMF");
	if (m_pFuncGetSMF == NULL) {
		result = YN_SET_ERR("GetProcAddress Error. (rcpcv.dll)", GetLastError(), 0);
		goto EXIT;
	}

	//֐|C^擾FrcpcvGetSMFLength
	m_pFuncGetSMFLength = (RCPCV_GetSMFLength)GetProcAddress(m_hModule, "rcpcvGetSMFLength");
	if (m_pFuncGetSMFLength == NULL) {
		result = YN_SET_ERR("GetProcAddress Error. (rcpcv.dll)", GetLastError(), 0);
		goto EXIT;
	}

EXIT:;
	if (result != 0) {
		_Release();
	}
	return result;
}

//******************************************************************************
// gp۔
//******************************************************************************
bool SMRcpConv::IsAvailable()
{
	bool isAvailable = false;

	if (m_hModule != NULL) {
		isAvailable = true;
	}

	return isAvailable;
}

//******************************************************************************
// t@Cϊ
//******************************************************************************
int SMRcpConv::Convert(
		const WCHAR* pRCPPath,
		const WCHAR* pSMFPath
	)
{
	int result = 0;
	DWORD hRCPCV = 0;
	FILE* pRCPFile = NULL;
	FILE* pSMFFile = NULL;
	unsigned char* pBuffer = NULL;
	errno_t eresult = 0;
	__int64 fileSize = 0;
	size_t buffSize = 0;
	size_t readSize = 0;
	size_t writeSize = 0;
	LPCSTR pSMFData = NULL;
	int SMFDataSize = 0;

	if (!IsAvailable()) {
		result = YN_SET_ERR("Program Error.", 0, 0);
		goto EXIT;
	}

	//t@CJ
	eresult = _wfopen_s(&pRCPFile, pRCPPath, L"rb");
	if (eresult != 0) {
		result = YN_SET_ERR("File open error.", 0, 0);
		goto EXIT;
	}

	//t@CTCYmF
	fileSize = _filelengthi64(_fileno(pRCPFile));
	if (fileSize == -1L) {
		result = YN_SET_ERR("File open error.", 0, 0);
		goto EXIT;
	}
	//t@CTCY100MB𒴂ꍇ̓T|[gȂ
	if (fileSize > (1024 * 1024 * 100)) {
		result = YN_SET_ERR("File size is too long.", fileSize, 0);
		goto EXIT;
	}
	buffSize = (size_t)fileSize;

	//m
	try {
		pBuffer = new unsigned char[buffSize];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", buffSize, 0);
		goto EXIT;
	}

	//RCPt@C̓eɓWJ
	readSize = fread_s(pBuffer, buffSize, 1, buffSize, pRCPFile);
	if (readSize != buffSize) {
		result = YN_SET_ERR("File read error.", readSize, buffSize);
		goto EXIT;
	}

	try {
		//RCP->SMFRo[gs
		//  tH[}bg`nKv邪ʂƂ
		//  ł̕ϊ̓t@Cgq̏񂪂Ȃ߂Ɛ
		hRCPCV = (*m_pFuncConvertFileFromBuffer)(
						(LPCSTR)pBuffer,//̓obt@
						(UINT)buffSize,		//̓obt@
						0,				//̓f[^̃tH[}bg`F
						0,				//R[obNʁFȂ
						NULL,			//R[obN֐^EBhEnhFȂ
						0,				//EBhEbZ[WFȂ
						0				//CX^XʗpIDFȂ
					);
		if (hRCPCV == 0) {
			result = YN_SET_ERR("File convert error. (rcpcv.dll)", 0, 0);
			goto EXIT;
		}

		//SMFf[^ʒu
		pSMFData = (*m_pFuncGetSMF)(hRCPCV);

		//SMFf[^TCY
		SMFDataSize = (*m_pFuncGetSMFLength)(hRCPCV);
	}
	catch (...) {
		result = YN_SET_ERR("File convert error. (rcpcv.dll)", 0, 0);
		goto EXIT;
	}

	//o͐t@CJ
	eresult = _wfopen_s(&pSMFFile, pSMFPath, L"wb");
	if (eresult != 0) {
		result = YN_SET_ERR("File open error.", 0, 0);
		goto EXIT;
	}

	//o͐t@CSMFf[^
	writeSize = fwrite(pSMFData, 1, SMFDataSize, pSMFFile);
	if (writeSize != SMFDataSize) {
		result = YN_SET_ERR("File write error.", writeSize, SMFDataSize);
		goto EXIT;
	}

EXIT:;
	delete [] pBuffer;
	if (hRCPCV != 0) {
		(*m_pFuncDeleteObject)(hRCPCV);
	}
	if (pRCPFile != NULL) {
		fclose(pRCPFile);
	}
	if (pSMFFile != NULL) {
		fclose(pSMFFile);
	}
	return result;
}

// 
// RCPCV ̓Chɂt@CpX̎wɑΉĂȂ
// RCPCV łRCPt@Cǂݍ݂SMFt@Co͂߁A
// ł̃Ro[gɕύXB
//******************************************************************************
// t@Cϊ
//******************************************************************************
//int SMRcpConv::Convert(
//		const TCHAR* pRCPPath,
//		const TCHAR* pSMFPath
//	)
//{
//	int result = 0;
//	int apiresult = 0;
//	DWORD hRCPCV = 0;
//
//	if (!IsAvailable()) {
//		result = YN_SET_ERR("Program Error.", 0, 0);
//		goto EXIT;
//	}
//
//	try {
//
//		//RCPt@Cǂݍ
//		hRCPCV = (*m_pFuncConvertFile)(
//						pRCPPath,	//t@CpX
//						0,			//R[obNʁFȂ
//						NULL,		//R[obN֐^EBhEnhFȂ
//						0,			//EBhEbZ[WFȂ
//						0			//CX^XʗpIDFȂ
//					);
//		if (hRCPCV == 0) {
//			result = YN_SET_ERR("File read error.", 0, 0);
//			goto EXIT;
//		}
//
//		//SMFo
//		apiresult = (*m_pFuncSaveSMF)(hRCPCV, pSMFPath);
//		if (apiresult != 1) {
//			result = YN_SET_ERR("File save error.", apiresult, 0);
//			goto EXIT;
//		}
//
//	}
//	catch (...) {
//		result = YN_SET_ERR("Exception occurred. (rcpcv.dll)", 0, 0);
//		goto EXIT;
//	}
//
//EXIT:;
//	if (hRCPCV != 0) {
//		(*m_pFuncDeleteObject)(hRCPCV);
//	}
//	return result;
//}

//******************************************************************************
// [X
//******************************************************************************
void SMRcpConv::_Release()
{
	if (m_hModule != NULL) {
		FreeLibrary(m_hModule);
		m_hModule = NULL;
	}
}

//******************************************************************************
// gqɂT|[gΏۃt@C
//******************************************************************************
bool SMRcpConv::IsSupportFileExt(
		const WCHAR* pFilePath
	)
{
	bool isSupport = false;

	if (YNPathUtil::IsFileExtMatch(pFilePath, L".rcp")
	 || YNPathUtil::IsFileExtMatch(pFilePath, L".r36")
	 || YNPathUtil::IsFileExtMatch(pFilePath, L".g36")) {
		isSupport = true;
	}

	return isSupport;
}

//******************************************************************************
// GetOpenFileNamept@CtB^擾
//******************************************************************************
const WCHAR* SMRcpConv::GetOpenFileNameFilter()
{
	WCHAR* pFilter =
		L"MIDI File (*.mid *.rcp *.r36 *.g36)\0*.mid;*.rcp;*.r36;*.g36\0"
		L"Standard MIDI File (*.mid)\0*.mid\0"
		L"Recomposer Data File (*.rcp *.r36 *.g36)\0*.rcp;*.r36;*.g36\0"
		L"\0";
	return pFilter;
}

} // end of namespace

