//******************************************************************************
//
// Simple Base Library / YNConfFile
//
// ݒt@CNX
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNErrCtrl.h"
#include "YNConfFile.h"
#include <stdio.h>
#include <stdlib.h>
#include <new>

namespace YNBaseLib {

//******************************************************************************
// p[^`
//******************************************************************************
#define YNCONFFILE_NO_DATA  _T("*** NO DATA ***")

//******************************************************************************
// RXgN^
//******************************************************************************
YNConfFile::YNConfFile(void)
{
	m_FilePath[0] = _T('\0');
	m_Section[0] = _T('\0');
}

//******************************************************************************
// fXgN^
//******************************************************************************
YNConfFile::~YNConfFile(void)
{
}

//******************************************************************************
// 
//******************************************************************************
int YNConfFile::Initialize(
		const TCHAR* pConfFilePath
	)
{
	int result = 0;
	errno_t eresult = 0;
	
	eresult = _tcscpy_s(m_FilePath, _MAX_PATH, pConfFilePath);
	if (eresult != 0) {
		result = -1;
		goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// ZNVݒ
//******************************************************************************
int YNConfFile::SetCurSection(
		const TCHAR* pSection
	)
{
	int result = 0;
	errno_t eresult = 0;
	
	eresult = _tcscpy_s(m_Section, _MAX_PATH, pSection);
	if (eresult != 0) {
		result = -1;
		goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// l擾
//******************************************************************************
int YNConfFile::GetInt(
		const TCHAR* pKey,
		int* pVal,
		int defaultVal
	)
{
	int result = 0;
	DWORD apiresult = 0;
	TCHAR buf[20];

	apiresult = GetPrivateProfileString(
					m_Section,			//ZNV
					pKey,				//L[
					YNCONFFILE_NO_DATA, //ftHg
					buf,				//obt@ʒu
					20,					//obt@TCYiTCHARPʁj
					m_FilePath			//t@CpX
				);
	//߂l̃`FbN͂߂

	if (_tcscmp(buf, YNCONFFILE_NO_DATA) == 0) {
		*pVal = defaultVal;
	}
	else {
		*pVal = _tstoi(buf);
	}

//EXIT:;
	return result;
}

//******************************************************************************
// lo^
//******************************************************************************
int YNConfFile::SetInt(
		const TCHAR* pKey,
		int val
	)
{
	int result = 0;
	BOOL bresult = TRUE;
	TCHAR buf[20];

	_stprintf_s(buf, 20, _T("%d"), val);

	bresult = WritePrivateProfileString(
					m_Section,		//ZNV
					pKey,			//L[
					buf,			//o^镶
					m_FilePath		//t@CpX
				);
	if (!bresult) {
		result = -1;  //GetLastError
		goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// l擾
//******************************************************************************
int YNConfFile::GetFloat(
		const TCHAR* pKey,
		float* pVal,
		float defaultVal
	)
{
	int result = 0;
	DWORD apiresult = 0;
	TCHAR buf[20];

	apiresult = GetPrivateProfileString(
					m_Section,			//ZNV
					pKey,				//L[
					YNCONFFILE_NO_DATA, //ftHg
					buf,				//obt@ʒu
					20,					//obt@TCYiTCHARPʁj
					m_FilePath			//t@CpX
				);
	//߂l̃`FbN͂߂

	if (_tcscmp(buf, YNCONFFILE_NO_DATA) == 0) {
		*pVal = defaultVal;
	}
	else {
		//_tstofdoubleԂ
		*pVal = (float)_tstof(buf);
	}

//EXIT:;
	return result;
}

//******************************************************************************
// lo^
//******************************************************************************
int YNConfFile::SetFloat(
		const TCHAR* pKey,
		float val
	)
{
	int result = 0;
	BOOL bresult = TRUE;
	TCHAR buf[20];

	_stprintf_s(buf, 20, _T("%f"), val);

	bresult = WritePrivateProfileString(
					m_Section,		//ZNV
					pKey,			//L[
					buf,			//o^镶
					m_FilePath		//t@CpX
				);
	if (!bresult) {
		result = -1;  //GetLastError
		goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// 擾
//******************************************************************************
int YNConfFile::GetStr(
		const TCHAR* pKey,
		TCHAR* pBuf,
		unsigned long bufSize, 
		const TCHAR* pDefaultVal
	)
{
	int result = 0;
	DWORD apiresult = 0;

	apiresult = GetPrivateProfileString(
					m_Section,			//ZNV
					pKey,				//L[
					pDefaultVal,		//ftHg
					pBuf,				//obt@ʒu
					bufSize,			//obt@TCYiTCHARPʁj
					m_FilePath			//t@CpX
				);
	//߂l̃`FbN͂߂

//EXIT:;
	return result;
}

//******************************************************************************
// o^
//******************************************************************************
int YNConfFile::SetStr(
		const TCHAR* pKey,
		const TCHAR* pStr
	)
{
	int result = 0;
	BOOL bresult = TRUE;
	TCHAR* pValue = NULL;
	size_t length = 0;

	//INIt@Cɖ󔒕̒lo^
	//l擾Ƃɋ󔒕폜Ă܂
	//VONH[gň͂œo^
	length = _tcslen(pStr) + 4;
	try {
		pValue = new TCHAR[length];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", length, 0);
		goto EXIT;
	}
	_stprintf_s(pValue, length, _T("'%s'"), pStr);

	bresult = WritePrivateProfileString(
					m_Section,		//ZNV
					pKey,			//L[
					pValue,			//o^镶
					m_FilePath		//t@CpX
				);
	if (!bresult) {
		result = -1;  //GetLastError
		goto EXIT;
	}

EXIT:;
	delete [] pValue;
	return result;
}

//******************************************************************************
// 擾il̂݃Chj
//******************************************************************************
int YNConfFile::GetWStr(
		const TCHAR* pKey,
		WCHAR* pBuf,
		unsigned long bufSize,
		const WCHAR* pDefaultVal
	)
{
	int result = 0;
	unsigned long hexBufSize = 0;
	unsigned long hexLength = 0;
	unsigned long index = 0;
	unsigned long indexw = 0;
	TCHAR* pHexString = NULL;
	TCHAR hexChar[5];
	TCHAR* stopped = NULL;
	WCHAR wchar = 0;

	//obt@TCYftHgli[łȂ΃G[
	if (bufSize < (wcslen(pDefaultVal) + 1)) {
		result = YN_SET_ERR("Program Error.", bufSize, 0);
		goto EXIT;
	}

	hexBufSize = (bufSize * 4) + (unsigned long)_tcslen(YNCONFFILE_NO_DATA) + 1;

	//16ii[郁m
	try {
		pHexString = new TCHAR[hexBufSize];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", hexBufSize, 0);
		goto EXIT;
	}
	memset(pHexString, 0, hexBufSize);

	//16i擾
	result = GetStr(pKey, pHexString, hexBufSize, YNCONFFILE_NO_DATA);
	if (result != 0) goto EXIT;
	
	//o^̏ꍇ̓ftHgԂ
	if (_tcscmp(pHexString, YNCONFFILE_NO_DATA) == 0) {
		wcscpy_s(pBuf, bufSize, pDefaultVal);
		goto EXIT;
	}

	hexLength = (unsigned long)_tcslen(pHexString);

	//󕶎̏ꍇ
	if (hexLength == 0) {
		pBuf[0] = L'\0';
		goto EXIT;
	}

	//16i4Chɕϊ
	//4PʂłȂΐ؂̂Ă
	while ((index + 4) <= hexLength) {
		hexChar[0] = pHexString[index + 0];
		hexChar[1] = pHexString[index + 1];
		hexChar[2] = pHexString[index + 2];
		hexChar[3] = pHexString[index + 3];
		hexChar[4] = '\0';
		pBuf[indexw] = (WCHAR)_tcstol(hexChar, &stopped, 16);

		//obt@I[łΕϊI
		if ((indexw + 1) == bufSize) {
			break;
		}

		index += 4;
		indexw += 1;
	}
	pBuf[indexw] = L'\0';

EXIT:;
	delete [] pHexString;
	return result;
}

//******************************************************************************
// o^il̂݃Chj
//******************************************************************************
int YNConfFile::SetWStr(const TCHAR* pKey, const WCHAR* pStr)
{
	int result = 0;
	unsigned long length = 0;
	unsigned long bufSize = 0;
	unsigned long index = 0;
	TCHAR* pHexString = NULL;
	TCHAR hexChar[5];

	length = (unsigned long)wcslen(pStr);
	bufSize = (length + 1) * 4;

	//16ii[郁m
	try {
		pHexString = new TCHAR[bufSize];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", bufSize, 0);
		goto EXIT;
	}
	memset(pHexString, 0, bufSize);

	//Ch116i4ɕϊiI[͕ϊȂj
	for (index = 0; index < length; index ++) {
		_stprintf_s(hexChar, 5, _T("%04X"), pStr[index]);
		_tcscat_s(pHexString, bufSize, hexChar);
	}

	//o^
	result = SetStr(pKey, pHexString);
	if (result != 0) goto EXIT;

EXIT:;
	delete [] pHexString;
	return result;
}

} // end of namespace


