//******************************************************************************
//
// MIDITrail / MTColorParamImportDlg
//
// カラーパラメータ入力ダイアログ
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************


//******************************************************************************
// カラーパラメータ入力ダイアログ
//******************************************************************************
@interface MTColorParamImportDlg : NSWindowController {
	
	//テキストフィールド
	IBOutlet NSTextField *m_pTextField;
	
	//パラメータ文字列
	NSString* m_pParamText;
	
	//インポート実行フラグ
	BOOL m_isExecImport;
	
}

//--------------------------------------
//公開I/F

//生成
- (id)init;

//破棄
- (void)dealloc;

//ウィンドウ読み込み完了
- (void)windowDidLoad;

//モーダルウィンドウ表示
- (void)showModalWindow;

//インポート実行フラグ取得
- (BOOL)isExecImport;

//パラメータ文字列取得
- (NSString*)getParamString;

//--------------------------------------
//イベントハンドラ

//Import ボタン押下
- (IBAction)onBtnImport:(NSButton *)sender;

//キャンセルボタン押下
- (IBAction)onCancel:(NSButton *)sender;

//ペーストボタン押下
- (IBAction)onBtnPaste:(NSButton *)sender;

//クローズボタン押下
- (void)windowWillClose:(NSNotification*)aNotification;

//--------------------------------------
//内部処理

//ダイアログ初期化
- (int)initDlg;

@end

