//******************************************************************************
//
// MIDITrail / MTScenePianoRollRain
//
// ピアノロールレインシーン描画クラス
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "OGLUtil.h"
#import "MTScene.h"
#import "MTFirstPersonCam.h"
#import "MTStars.h"
#import "MTPianoKeyboardCtrl.h"
#import "MTNoteRain.h"
#import "MTDashboard.h"
#import "MTNotePitchBend.h"
#import "MTBackgroundImage.h"
#import "MTConfFile.h"
#import "SMIDILib.h"
//#import "MTTeapot.h"


//******************************************************************************
// ピアノロールレインシーン描画クラス
//******************************************************************************
class MTScenePianoRollRain : public MTScene
{
public:
	
	//コンストラクタ／デストラクタl
	MTScenePianoRollRain(void);
	virtual ~MTScenePianoRollRain(void);
	
	//名称取得
	NSString* GetName();
	
	//生成
	virtual int Create(
			NSView* pView,
			OGLDevice* pOGLDevice,
			SMSeqData* pSeqData
		);
	
	//変換
	int Transform(OGLDevice* pOGLDevice);
	
	//描画
	int Draw(OGLDevice* pOGLDevice);
	
	//破棄
	void Release();
	
	//ウィンドウクリックイベント受信
	int OnWindowClicked(
			unsigned int button,
			unsigned int wParam,
			unsigned int lParam
		);
	
	//マウスホイールイベント受信
	int OnScrollWheel(
			float deltaWheelX,	//ホイール左右傾斜
			float deltaWheelY,	//ホイール回転
			float deltaWheelZ	//？
		);
	
	//演奏開始イベント受信
	int OnPlayStart();
	
	//演奏終了イベント受信
	int OnPlayEnd();
	
	//シーケンサメッセージ受信
	int OnRecvSequencerMsg(
			unsigned int wParam,
			unsigned int lParam
		);
	
	//巻き戻し
	int Rewind();
	
	//視点取得／登録
	virtual void GetDefaultViewParam(MTViewParamMap* pParamMap);
	void GetViewParam(MTViewParamMap* pParamMap);
	void SetViewParam(MTViewParamMap* pParamMap);
	void MoveToStaticViewpoint(unsigned long viewpointNo);
	
	//視点リセット
	void ResetViewpoint();
	
	//エフェクト設定
	void SetEffect(MTScene::EffectType type, bool isEnable);
	
	//演奏速度設定
	void SetPlaySpeedRatio(unsigned int ratio);
	
	//ゲームコントローラー更新
	int OnGameControllerChanged();
	
protected:
	
	//ライト有無
	bool m_IsEnableLight;
	
	//シングルキーボードフラグ
	bool m_IsSingleKeyboard;
	
private:
	
	//ライト
	OGLDirLight m_DirLight;
	OGLDirLight m_DirLight2;
	
	//一人称カメラ
	MTFirstPersonCam m_FirstPersonCam;
	
	//描画オブジェクト
	MTStars m_Stars;
	MTPianoKeyboardCtrl m_PianoKeyboardCtrl;
	MTNoteRain m_NoteRain;
	MTNotePitchBend m_NotePitchBend;
	MTDashboard m_Dashboard;
	MTBackgroundImage m_BackgroundImage;
	//MTTeapot m_Teapot;
	
	//マウス視線移動モード
	bool m_IsMouseCamMode;
	
	//自動回転モード
	bool m_IsAutoRollMode;
	
	//視点情報
	MTViewParamMap m_ViewParamMap;
	MTViewParamMap m_Viewpoint2;
	MTViewParamMap m_Viewpoint3;
	
	//演奏位置
	unsigned int m_CurTickTime;
	
	//スキップ状態
	bool m_IsSkipping;
	
	void _Reset();
	void _SetLightColor(OGLDirLight* pLight);
	void _SetLightColor2(OGLDirLight* pLight);
	int _LoadConf();
	int _LoadConfViewpoint(
				MTConfFile* pConfFile,
				unsigned int viewpointNo,
				MTScene::MTViewParamMap* pParamMap
			);
	
};


