//******************************************************************************
//
// MIDITrail / MTWindowSizeCfgDlg
//
// ウィンドウサイズ設定ダイアログ
//
// Copyright (C) 2010-2017 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <Cocoa/Cocoa.h>
#import "YNBaseLib.h"


//******************************************************************************
//ウィンドウサイズ設定ダイアログクラス パラメタ定義
//******************************************************************************
//ウィンドウサイズ設定最小値
#define MT_WINDOW_SIZE_MIN			200

//ウィンドウサイズ設定最大値
#define MT_WINDOW_SIZE_MAX			99999


//******************************************************************************
// ウィンドウサイズクラス
//******************************************************************************
@interface MTWindowSize : NSObject {
	unsigned int m_Width;
	unsigned int m_Height;
}

- (id)init;
- (void)setWidth:(unsigned int)width;
- (void)setHeight:(unsigned int)height;
- (unsigned int)width;
- (unsigned int)height;

@end


//******************************************************************************
// ウィンドウサイズテキストフィールドクラス（エディットボックス）
//******************************************************************************
@interface MTWindowSizeTextField : NSTextField {
}

- (BOOL)textShouldEndEditing:(NSText *)textObject;
- (BOOL)isCorrect;
- (BOOL)isCorrectValue:(NSString*)pValue;

@end


//******************************************************************************
// ウィンドウサイズ設定ダイアログクラス
//******************************************************************************
@interface MTWindowSizeCfgDlg : NSWindowController {
	IBOutlet NSTableView* m_pTableView;
	IBOutlet MTWindowSizeTextField* m_pEditWidth;
	IBOutlet MTWindowSizeTextField* m_pEditHeight;
	IBOutlet NSButton* m_pCheckBtnApplyToView;
	NSMutableArray* m_pWindowSizeArray;
	YNUserConf* m_pUserConf;
	BOOL m_isChanged;
}

//--------------------------------------
//公開I/F

//生成
- (id)init;

//破棄
- (void)dealloc;

//モーダルウィンドウ表示
- (void)showModalWindow;

//変更確認
- (BOOL)isCahnged;

//--------------------------------------
//イベントハンドラ

//ウィンドウ読み込み完了
- (void)windowDidLoad;

//OKボタン押下
- (IBAction)onOK:(id)sender;

//Cancelボタン押下
- (IBAction)onCancel:(id)sender;

//クローズボタン押下
- (void)windowWillClose:(NSNotification*)aNotification;

//テーブルビュー：表示項目数取得
- (NSInteger)numberOfRowsInTableView:(NSTableView *)aTableView;

//テーブルビュー：表示文字列取得
- (id)tableView:(NSTableView*)aTableView
	objectValueForTableColumn:(NSTableColumn*)aTableColumn
			row:(NSInteger)rowIndex;

//--------------------------------------
//内部処理

//ダイアログ初期化
- (int)initDlg;

//設定ファイル初期化
- (int)initConfFile;

//ウィンドウサイズテーブル初期化
- (int)initWindowSizeTable;

//ウィンドウサイズエディットボックス初期化
- (int)initWindowSizeEditBox;

//ウィンドウサイズ配列生成
- (int)createWindowSizeArray;

//設定保存
- (int)save;

//ウィンドウサイズ設定値取得
- (int)getConfWindowSize:(MTWindowSize*)pWindowSize;

//テーブルビュー選択完了イベント
- (void)tableViewSelectionDidChange:(NSNotification*)pNotification;

@end




