//******************************************************************************
//
// Simple MIDI Library / SMMsgQueue
//
// メッセージキュークラスヘッダ
//
// Copyright (C) 2010-2017 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <Cocoa/Cocoa.h>
#import "SMSimpleList.h"


//******************************************************************************
// メッセージキュークラス
//******************************************************************************
class SMMsgQueue
{
public:
	
	//コンストラクタ／デストラクタ
	SMMsgQueue(void);
	virtual ~SMMsgQueue(void);
	
	//初期化
	int Initialize(unsigned int maxMsgNum);
	
	//メッセージ登録
	int PostMessage(unsigned int param1, unsigned int param2);
	
	//メッセージ取得
	int GetMessage(bool* pIsExist, unsigned int* pParam1, unsigned int* pParam2);
	
private:
	
	NSObject* m_pSync;
	
	SMSimpleList m_List;
	unsigned int m_MaxMsgNum;
	unsigned int m_NextPostIndex;
	unsigned int m_NextReadIndex;

};


