/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.app.Application;
import com.jme3.app.StatsView;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.input.FlyByCamera;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.util.BufferUtils;

public abstract class SimpleApplication
extends Application {
    public static final String INPUT_MAPPING_EXIT = "SIMPLEAPP_Exit";
    public static final String INPUT_MAPPING_CAMERA_POS = "SIMPLEAPP_CameraPos";
    public static final String INPUT_MAPPING_MEMORY = "SIMPLEAPP_Memory";
    public static final String INPUT_MAPPING_HIDE_STATS = "SIMPLEAPP_HideStats";
    protected Node rootNode = new Node("Root Node");
    protected Node guiNode = new Node("Gui Node");
    protected float secondCounter = 0.0f;
    protected BitmapText fpsText;
    protected BitmapFont guiFont;
    protected StatsView statsView;
    protected FlyByCamera flyCam;
    protected boolean showSettings = true;
    private boolean showFps = true;
    private AppActionListener actionListener = new AppActionListener();

    public void start() {
        boolean loadSettings = false;
        if (this.settings == null) {
            this.setSettings(new AppSettings(true));
            loadSettings = true;
        }
        if (this.showSettings && !JmeSystem.showSettingsDialog(this.settings, loadSettings)) {
            return;
        }
        this.setSettings(this.settings);
        super.start();
    }

    public FlyByCamera getFlyByCamera() {
        return this.flyCam;
    }

    public Node getGuiNode() {
        return this.guiNode;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public boolean isShowSettings() {
        return this.showSettings;
    }

    public void setShowSettings(boolean showSettings) {
        this.showSettings = showSettings;
    }

    public void loadFPSText() {
        this.guiFont = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        this.fpsText = new BitmapText(this.guiFont, false);
        this.fpsText.setLocalTranslation(0.0f, this.fpsText.getLineHeight(), 0.0f);
        this.fpsText.setText("Frames per second");
        this.guiNode.attachChild(this.fpsText);
    }

    public void loadStatsView() {
        this.statsView = new StatsView("Statistics View", this.assetManager, this.renderer.getStatistics());
        this.statsView.setLocalTranslation(0.0f, this.fpsText.getLineHeight(), 0.0f);
        this.guiNode.attachChild(this.statsView);
    }

    public void initialize() {
        super.initialize();
        this.guiNode.setQueueBucket(RenderQueue.Bucket.Gui);
        this.guiNode.setCullHint(Spatial.CullHint.Never);
        this.loadFPSText();
        this.loadStatsView();
        this.viewPort.attachScene(this.rootNode);
        this.guiViewPort.attachScene(this.guiNode);
        if (this.inputManager != null) {
            this.flyCam = new FlyByCamera(this.cam);
            this.flyCam.setMoveSpeed(1.0f);
            this.flyCam.registerWithInput(this.inputManager);
            if (this.context.getType() == JmeContext.Type.Display) {
                this.inputManager.addMapping(INPUT_MAPPING_EXIT, new KeyTrigger(1));
            }
            this.inputManager.addMapping(INPUT_MAPPING_CAMERA_POS, new KeyTrigger(46));
            this.inputManager.addMapping(INPUT_MAPPING_MEMORY, new KeyTrigger(50));
            this.inputManager.addMapping(INPUT_MAPPING_HIDE_STATS, new KeyTrigger(63));
            this.inputManager.addListener(this.actionListener, INPUT_MAPPING_EXIT, INPUT_MAPPING_CAMERA_POS, INPUT_MAPPING_MEMORY, INPUT_MAPPING_HIDE_STATS);
        }
        this.simpleInitApp();
    }

    public void update() {
        super.update();
        if (this.speed == 0.0f || this.paused) {
            return;
        }
        float tpf = this.timer.getTimePerFrame() * this.speed;
        if (this.showFps) {
            this.secondCounter += this.timer.getTimePerFrame();
            int fps = (int)this.timer.getFrameRate();
            if (this.secondCounter >= 1.0f) {
                this.fpsText.setText("Frames per second: " + fps);
                this.secondCounter = 0.0f;
            }
        }
        this.stateManager.update(tpf);
        this.simpleUpdate(tpf);
        this.rootNode.updateLogicalState(tpf);
        this.guiNode.updateLogicalState(tpf);
        this.rootNode.updateGeometricState();
        this.guiNode.updateGeometricState();
        this.stateManager.render(this.renderManager);
        if (this.context.isRenderable()) {
            this.renderManager.render(tpf);
        }
        this.simpleRender(this.renderManager);
        this.stateManager.postRender();
    }

    public void setDisplayFps(boolean show) {
        this.showFps = show;
        this.fpsText.setCullHint(show ? Spatial.CullHint.Never : Spatial.CullHint.Always);
    }

    public void setDisplayStatView(boolean show) {
        this.statsView.setEnabled(show);
        this.statsView.setCullHint(show ? Spatial.CullHint.Never : Spatial.CullHint.Always);
    }

    public abstract void simpleInitApp();

    public void simpleUpdate(float tpf) {
    }

    public void simpleRender(RenderManager rm) {
    }

    private class AppActionListener
    implements ActionListener {
        private AppActionListener() {
        }

        public void onAction(String name, boolean value, float tpf) {
            if (!value) {
                return;
            }
            if (name.equals(SimpleApplication.INPUT_MAPPING_EXIT)) {
                SimpleApplication.this.stop();
            } else if (name.equals(SimpleApplication.INPUT_MAPPING_CAMERA_POS)) {
                if (SimpleApplication.this.cam != null) {
                    Vector3f loc = SimpleApplication.this.cam.getLocation();
                    Quaternion rot = SimpleApplication.this.cam.getRotation();
                    System.out.println("Camera Position: (" + loc.x + ", " + loc.y + ", " + loc.z + ")");
                    System.out.println("Camera Rotation: " + rot);
                    System.out.println("Camera Direction: " + SimpleApplication.this.cam.getDirection());
                }
            } else if (name.equals(SimpleApplication.INPUT_MAPPING_MEMORY)) {
                BufferUtils.printCurrentDirectMemory(null);
            } else if (name.equals(SimpleApplication.INPUT_MAPPING_HIDE_STATS)) {
                boolean show = SimpleApplication.this.showFps;
                SimpleApplication.this.setDisplayFps(!show);
                SimpleApplication.this.setDisplayStatView(!show);
            }
        }
    }
}

