/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.Asset;
import com.jme3.asset.AssetCache;
import com.jme3.asset.AssetConfig;
import com.jme3.asset.AssetEventListener;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.ImplHandler;
import com.jme3.asset.MaterialKey;
import com.jme3.asset.ModelKey;
import com.jme3.asset.TextureKey;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioKey;
import com.jme3.font.BitmapFont;
import com.jme3.material.Material;
import com.jme3.scene.Spatial;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderKey;
import com.jme3.texture.Texture;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesktopAssetManager
implements AssetManager {
    private static final Logger logger = Logger.getLogger(AssetManager.class.getName());
    private final AssetCache cache = new AssetCache();
    private final ImplHandler handler = new ImplHandler(this);
    private AssetEventListener eventListener = null;

    public DesktopAssetManager() {
        this(null);
    }

    @Deprecated
    public DesktopAssetManager(boolean loadDefaults) {
        this(Thread.currentThread().getContextClassLoader().getResource("com/jme3/asset/Desktop.cfg"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DesktopAssetManager(URL configFile) {
        if (configFile != null) {
            InputStream stream = null;
            try {
                AssetConfig cfg = new AssetConfig(this);
                stream = configFile.openStream();
                cfg.loadText(stream);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Failed to load asset config", ex);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        logger.info("DesktopAssetManager created.");
    }

    @Override
    public void setAssetEventListener(AssetEventListener listener) {
        this.eventListener = listener;
    }

    @Override
    public void registerLoader(Class<? extends AssetLoader> loader, String ... extensions) {
        this.handler.addLoader(loader, extensions);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Registered loader: {0} for extensions {1}", new Object[]{loader.getSimpleName(), Arrays.toString(extensions)});
        }
    }

    @Override
    public void registerLoader(String clsName, String ... extensions) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(clsName);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.WARNING, "Failed to find loader: " + clsName, ex);
        }
        catch (NoClassDefFoundError ex) {
            logger.log(Level.WARNING, "Failed to find loader: " + clsName, ex);
        }
        if (clazz != null) {
            this.registerLoader(clazz, extensions);
        }
    }

    @Override
    public void registerLocator(String rootPath, Class<? extends AssetLocator> locatorClass) {
        this.handler.addLocator(locatorClass, rootPath);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Registered locator: {0}", locatorClass.getSimpleName());
        }
    }

    @Override
    public void registerLocator(String rootPath, String clsName) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(clsName);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.WARNING, "Failed to find locator: " + clsName, ex);
        }
        catch (NoClassDefFoundError ex) {
            logger.log(Level.WARNING, "Failed to find loader: " + clsName, ex);
        }
        if (clazz != null) {
            this.registerLocator(rootPath, clazz);
        }
    }

    public void unregisterLocator(String rootPath, Class<?> clazz) {
        this.handler.removeLocator(clazz, rootPath);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Unregistered locator: {0}", clazz.getSimpleName());
        }
    }

    public void clearCache() {
        this.cache.deleteAllAssets();
    }

    public boolean deleteFromCache(AssetKey key) {
        return this.cache.deleteFromCache(key);
    }

    public void addToCache(AssetKey key, Object asset) {
        this.cache.addToCache(key, asset);
    }

    @Override
    public AssetInfo locateAsset(AssetKey<?> key) {
        if (this.handler.getLocatorCount() == 0) {
            logger.warning("There are no locators currently registered. Use AssetManager.registerLocator() to register a locator.");
            return null;
        }
        AssetInfo info = this.handler.tryLocate(key);
        if (info == null) {
            logger.log(Level.WARNING, "Cannot locate resource: {0}", key);
        }
        return info;
    }

    @Override
    public <T> T loadAsset(AssetKey<T> key) {
        if (this.eventListener != null) {
            this.eventListener.assetRequested(key);
        }
        AssetKey smartKey = null;
        Object o = null;
        if (key.shouldCache()) {
            if (key.useSmartCache()) {
                AssetCache.SmartAssetInfo smartInfo = this.cache.getFromSmartCache(key);
                if (smartInfo != null && (smartKey = (AssetKey)smartInfo.smartKey.get()) != null) {
                    o = smartInfo.asset;
                }
            } else {
                o = this.cache.getFromCache(key);
            }
        }
        if (o == null) {
            AssetLoader loader = this.handler.aquireLoader(key);
            if (loader == null) {
                throw new IllegalStateException("No loader registered for type \"" + key.getExtension() + "\"");
            }
            if (this.handler.getLocatorCount() == 0) {
                throw new IllegalStateException("There are no locators currently registered. Use AssetManager.registerLocator() to register a locator.");
            }
            AssetInfo info = this.handler.tryLocate(key);
            if (info == null) {
                throw new AssetNotFoundException(key.toString());
            }
            try {
                o = loader.load(info);
            }
            catch (IOException ex) {
                throw new AssetLoadException("An exception has occured while loading asset: " + key, ex);
            }
            if (o == null) {
                throw new AssetLoadException("Error occured while loading asset \"" + key + "\" using" + loader.getClass().getSimpleName());
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Loaded {0} with {1}", new Object[]{key, loader.getClass().getSimpleName()});
            }
            o = key.postProcess(o);
            if (key.shouldCache()) {
                this.cache.addToCache(key, o);
            }
            if (this.eventListener != null) {
                this.eventListener.assetLoaded(key);
            }
        }
        Object clone = key.createClonedInstance(o);
        if (key.useSmartCache()) {
            if (smartKey != null) {
                ((Asset)clone).setKey(smartKey);
            } else {
                ((Asset)clone).setKey(key);
            }
        }
        return (T)clone;
    }

    @Override
    public Object loadAsset(String name) {
        return this.loadAsset(new AssetKey(name));
    }

    @Override
    public Texture loadTexture(TextureKey key) {
        return this.loadAsset(key);
    }

    @Override
    public Material loadMaterial(String name) {
        return (Material)this.loadAsset(new MaterialKey(name));
    }

    public Texture loadTexture(String name, boolean generateMipmaps) {
        TextureKey key = new TextureKey(name, true);
        key.setGenerateMips(generateMipmaps);
        key.setAsCube(false);
        return this.loadTexture(key);
    }

    public Texture loadTexture(String name, boolean generateMipmaps, boolean flipY, boolean asCube, int aniso) {
        TextureKey key = new TextureKey(name, flipY);
        key.setGenerateMips(generateMipmaps);
        key.setAsCube(asCube);
        key.setAnisotropy(aniso);
        return this.loadTexture(key);
    }

    @Override
    public Texture loadTexture(String name) {
        return this.loadTexture(name, true);
    }

    @Override
    public AudioData loadAudio(AudioKey key) {
        return this.loadAsset(key);
    }

    @Override
    public AudioData loadAudio(String name) {
        return this.loadAudio(new AudioKey(name, false));
    }

    @Override
    public BitmapFont loadFont(String name) {
        return (BitmapFont)this.loadAsset(new AssetKey(name));
    }

    public InputStream loadGLSLLibrary(AssetKey key) {
        return (InputStream)this.loadAsset(key);
    }

    @Override
    public Shader loadShader(ShaderKey key) {
        Shader s = (Shader)this.cache.getFromCache(key);
        if (s == null) {
            String vertName = key.getVertName();
            String fragName = key.getFragName();
            String vertSource = (String)this.loadAsset(new AssetKey(vertName));
            String fragSource = (String)this.loadAsset(new AssetKey(fragName));
            s = new Shader(key.getLanguage());
            s.addSource(Shader.ShaderType.Vertex, vertName, vertSource, key.getDefines().getCompiled());
            s.addSource(Shader.ShaderType.Fragment, fragName, fragSource, key.getDefines().getCompiled());
            this.cache.addToCache(key, s);
        }
        return s;
    }

    @Override
    public Spatial loadModel(ModelKey key) {
        return this.loadAsset(key);
    }

    @Override
    public Spatial loadModel(String name) {
        return this.loadModel(new ModelKey(name));
    }
}

