/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;

public class TextureGeneratorWood
extends TextureGenerator {
    public TextureGeneratorWood(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    protected Texture generate(Structure tex, int width, int height, DataRepository dataRepository) {
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float bright = ((Number)tex.getFieldValue("bright")).floatValue();
        float nabla = ((Number)tex.getFieldValue("nabla")).floatValue();
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        TextureHelper.TexResult texres = new TextureHelper.TexResult();
        int halfW = width;
        int halfH = height;
        TextureHelper.ColorBand colorBand = this.readColorband(tex, dataRepository);
        Image.Format format = colorBand != null ? Image.Format.RGB8 : Image.Format.Luminance8;
        int bytesPerPixel = colorBand != null ? 3 : 1;
        ByteBuffer data = BufferUtils.createByteBuffer((width <<= 1) * (height <<= 1) * bytesPerPixel);
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j;
                texres.tin = this.noiseGenerator.woodInt(tex, texvec[0], texvec[1], texvec[2], dataRepository);
                if (colorBand != null) {
                    this.noiseGenerator.doColorband(colorBand, texres, dataRepository);
                    if (texres.nor != null) {
                        texres.nor[0] = this.noiseGenerator.woodInt(tex, texvec[0] + nabla, texvec[1], texvec[2], dataRepository);
                        texres.nor[1] = this.noiseGenerator.woodInt(tex, texvec[0], texvec[1] + nabla, texvec[2], dataRepository);
                        texres.nor[2] = this.noiseGenerator.woodInt(tex, texvec[0], texvec[1], texvec[2] + nabla, dataRepository);
                        this.noiseGenerator.texNormalDerivate(colorBand, texres, dataRepository);
                    }
                    this.noiseGenerator.brightnesAndContrastRGB(tex, texres);
                    data.put((byte)(texres.tr * 255.0f));
                    data.put((byte)(texres.tg * 255.0f));
                    data.put((byte)(texres.tb * 255.0f));
                    continue;
                }
                this.noiseGenerator.brightnesAndContrast(texres, contrast, bright);
                data.put((byte)(texres.tin * 255.0f));
            }
        }
        return new Texture2D(new Image(format, width, height, data));
    }
}

