/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.collision.UnsupportedCollisionException;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.FastMath;
import com.jme3.math.Ray;
import com.jme3.math.Triangle;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.terrain.geomipmap.LODGeomap;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.geomipmap.UpdatedTerrainPatch;
import com.jme3.terrain.geomipmap.lodcalc.DistanceLodCalculator;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculator;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculatorFactory;
import com.jme3.terrain.geomipmap.lodcalc.util.EntropyComputeUtil;
import com.jme3.util.BufferUtils;
import com.jme3.util.TangentBinormalGenerator;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerrainPatch
extends Geometry {
    protected LODGeomap geomap;
    protected int lod = -1;
    private int maxLod = -1;
    protected int previousLod = -1;
    protected int lodLeft;
    protected int lodTop;
    protected int lodRight;
    protected int lodBottom;
    protected int size;
    protected int totalSize;
    protected short quadrant = 1;
    protected Vector3f stepScale;
    protected Vector2f offset;
    protected float offsetAmount;
    protected LodCalculator lodCalculator;
    protected LodCalculatorFactory lodCalculatorFactory;
    protected TerrainPatch leftNeighbour;
    protected TerrainPatch topNeighbour;
    protected TerrainPatch rightNeighbour;
    protected TerrainPatch bottomNeighbour;
    protected boolean searchedForNeighboursAlready = false;
    protected float[] lodEntropy;

    public TerrainPatch() {
        super("TerrainPatch");
    }

    public TerrainPatch(String name) {
        super(name);
    }

    public TerrainPatch(String name, int size) {
        this(name, size, new Vector3f(1.0f, 1.0f, 1.0f), null, new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public TerrainPatch(String name, int size, Vector3f stepScale, float[] heightMap, Vector3f origin) {
        this(name, size, stepScale, heightMap, origin, size, new Vector2f(), 0.0f);
    }

    public TerrainPatch(String name, int size, Vector3f stepScale, float[] heightMap, Vector3f origin, int totalSize, Vector2f offset, float offsetAmount) {
        super(name);
        this.size = size;
        this.stepScale = stepScale;
        this.totalSize = totalSize;
        this.offsetAmount = offsetAmount;
        this.offset = offset;
        this.setLocalTranslation(origin);
        FloatBuffer heightBuffer = BufferUtils.createFloatBuffer(size * size);
        heightBuffer.put(heightMap);
        this.geomap = new LODGeomap(size, heightBuffer);
        Mesh m = this.geomap.createMesh(stepScale, new Vector2f(1.0f, 1.0f), offset, offsetAmount, totalSize, false);
        this.setMesh(m);
    }

    public void generateLodEntropies() {
        float[] entropies = new float[this.getMaxLod() + 1];
        for (int i = 0; i <= this.getMaxLod(); ++i) {
            int curLod = (int)Math.pow(2.0, i);
            IntBuffer buf = this.geomap.writeIndexArrayLodDiff(null, curLod, false, false, false, false);
            entropies[i] = EntropyComputeUtil.computeLodEntropy(this.mesh, buf);
        }
        this.lodEntropy = entropies;
    }

    public float[] getLodEntropies() {
        if (this.lodEntropy == null) {
            this.generateLodEntropies();
        }
        return this.lodEntropy;
    }

    public FloatBuffer getHeightmap() {
        return this.geomap.getHeightData();
    }

    public int getMaxLod() {
        if (this.maxLod < 0) {
            this.maxLod = Math.max(1, (int)(FastMath.log(this.size - 1) / FastMath.log(2.0f)) - 1);
        }
        return this.maxLod;
    }

    protected boolean calculateLod(List<Vector3f> locations, HashMap<String, UpdatedTerrainPatch> updates) {
        return this.lodCalculator.calculateLod(locations, updates);
    }

    protected void reIndexGeometry(HashMap<String, UpdatedTerrainPatch> updated) {
        UpdatedTerrainPatch utp = updated.get(this.getName());
        if (utp != null && (utp.isReIndexNeeded() || utp.isFixEdges())) {
            int pow = (int)Math.pow(2.0, utp.getNewLod());
            boolean left = utp.getLeftLod() > utp.getNewLod();
            boolean top = utp.getTopLod() > utp.getNewLod();
            boolean right = utp.getRightLod() > utp.getNewLod();
            boolean bottom = utp.getBottomLod() > utp.getNewLod();
            IntBuffer ib = null;
            ib = this.lodCalculator.usesVariableLod() ? this.geomap.writeIndexArrayLodVariable(null, pow, (int)Math.pow(2.0, utp.getRightLod()), (int)Math.pow(2.0, utp.getTopLod()), (int)Math.pow(2.0, utp.getLeftLod()), (int)Math.pow(2.0, utp.getBottomLod())) : this.geomap.writeIndexArrayLodDiff(null, pow, right, top, left, bottom);
            utp.setNewIndexBuffer(ib);
        }
    }

    public Vector2f getTex(float x, float z, Vector2f store) {
        if (x < 0.0f || z < 0.0f || x >= (float)this.size || z >= (float)this.size) {
            store.set(Vector2f.ZERO);
            return store;
        }
        int idx = (int)(z * (float)this.size + x);
        return store.set(this.getMesh().getFloatBuffer(VertexBuffer.Type.TexCoord).get(idx * 2), this.getMesh().getFloatBuffer(VertexBuffer.Type.TexCoord).get(idx * 2 + 1));
    }

    public float getHeightmapHeight(float x, float z) {
        if (x < 0.0f || z < 0.0f || x >= (float)this.size || z >= (float)this.size) {
            return 0.0f;
        }
        int idx = (int)(z * (float)this.size + x);
        return this.getMesh().getFloatBuffer(VertexBuffer.Type.Position).get(idx * 3 + 1);
    }

    public Triangle getTriangle(float x, float z) {
        return this.geomap.getTriangleAtPoint(x, z, this.getWorldScale(), this.getWorldTranslation());
    }

    public Triangle[] getGridTriangles(float x, float z) {
        return this.geomap.getGridTrianglesAtPoint(x, z, this.getWorldScale(), this.getWorldTranslation());
    }

    protected void setHeight(List<TerrainQuad.LocationHeight> locationHeights, boolean overrideHeight) {
        for (TerrainQuad.LocationHeight lh : locationHeights) {
            if (lh.x < 0 || lh.z < 0 || lh.x >= this.size || lh.z >= this.size) continue;
            int idx = lh.z * this.size + lh.x;
            if (overrideHeight) {
                this.geomap.getHeightData().put(idx, lh.h);
                continue;
            }
            float h = this.getMesh().getFloatBuffer(VertexBuffer.Type.Position).get(idx * 3 + 1);
            this.geomap.getHeightData().put(idx, h + lh.h);
        }
        FloatBuffer newVertexBuffer = this.geomap.writeVertexArray(null, this.stepScale, false);
        this.getMesh().clearBuffer(VertexBuffer.Type.Position);
        this.getMesh().setBuffer(VertexBuffer.Type.Position, 3, newVertexBuffer);
    }

    protected void updateNormals() {
        FloatBuffer newNormalBuffer = this.geomap.writeNormalArray(null, this.stepScale);
        this.getMesh().getBuffer(VertexBuffer.Type.Normal).updateData(newNormalBuffer);
    }

    protected void fixNormalEdges(TerrainPatch right, TerrainPatch bottom, TerrainPatch top, TerrainPatch left, TerrainPatch bottomRight, TerrainPatch bottomLeft, TerrainPatch topRight, TerrainPatch topLeft) {
        VertexBuffer topTB;
        VertexBuffer topNB;
        VertexBuffer tpTB;
        VertexBuffer tpNB;
        int i;
        Vector3f rootPoint = new Vector3f();
        Vector3f rightPoint = new Vector3f();
        Vector3f leftPoint = new Vector3f();
        Vector3f topPoint = new Vector3f();
        Vector3f bottomPoint = new Vector3f();
        Vector2f rootTex = new Vector2f();
        Vector2f rightTex = new Vector2f();
        Vector2f leftTex = new Vector2f();
        Vector2f topTex = new Vector2f();
        Vector2f bottomTex = new Vector2f();
        Vector3f normal = new Vector3f();
        Vector3f tangent = new Vector3f();
        int[] indexes = new int[]{0, 1, 2};
        Vector3f[] v = new Vector3f[3];
        Vector2f[] t = new Vector2f[3];
        int s = this.getSize() - 1;
        if (right != null) {
            for (i = 0; i < s + 1; ++i) {
                VertexBuffer rightTB;
                VertexBuffer rightNB;
                rootPoint.set(s, this.getHeightmapHeight(s, i), i);
                leftPoint.set(s - 1, this.getHeightmapHeight(s - 1, i), i);
                rightPoint.set(s + 1, right.getHeightmapHeight(1.0f, i), i);
                this.getTex(s, i, rootTex);
                this.getTex(s - 1, i, leftTex);
                right.getTex(1.0f, i, rightTex);
                if (i == 0) {
                    if (top == null) {
                        bottomPoint.set(s, this.getHeightmapHeight(s, i + 1), i + 1);
                        this.getTex(s, i + 1, bottomTex);
                        this.averageNormalsTangents(v, t, indexes, null, rootPoint, leftPoint, bottomPoint, rightPoint, null, rootTex, leftTex, bottomTex, rightTex, normal, tangent);
                        tpNB = this.getMesh().getBuffer(VertexBuffer.Type.Normal);
                        tpTB = this.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                        rightNB = right.getMesh().getBuffer(VertexBuffer.Type.Normal);
                        rightTB = right.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                        BufferUtils.setInBuffer(normal, (FloatBuffer)tpNB.getData(), s);
                        BufferUtils.setInBuffer(tangent, (FloatBuffer)tpTB.getData(), s);
                        BufferUtils.setInBuffer(normal, (FloatBuffer)rightNB.getData(), 0);
                        BufferUtils.setInBuffer(tangent, (FloatBuffer)rightTB.getData(), 0);
                        continue;
                    }
                    topPoint.set(s, top.getHeightmapHeight(s, s - 1), i - 1);
                    bottomPoint.set(s, this.getHeightmapHeight(s, i + 1), i + 1);
                    top.getTex(s, s - 1, topTex);
                    this.getTex(s, i + 1, bottomTex);
                    this.averageNormalsTangents(v, t, indexes, topPoint, rootPoint, leftPoint, bottomPoint, rightPoint, topTex, rootTex, leftTex, bottomTex, rightTex, normal, tangent);
                    tpNB = this.getMesh().getBuffer(VertexBuffer.Type.Normal);
                    tpTB = this.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                    rightNB = right.getMesh().getBuffer(VertexBuffer.Type.Normal);
                    rightTB = right.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                    topNB = top.getMesh().getBuffer(VertexBuffer.Type.Normal);
                    topTB = top.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                    BufferUtils.setInBuffer(normal, (FloatBuffer)tpNB.getData(), s);
                    BufferUtils.setInBuffer(tangent, (FloatBuffer)tpTB.getData(), s);
                    BufferUtils.setInBuffer(normal, (FloatBuffer)rightNB.getData(), 0);
                    BufferUtils.setInBuffer(tangent, (FloatBuffer)rightTB.getData(), 0);
                    BufferUtils.setInBuffer(normal, (FloatBuffer)topNB.getData(), (s + 1) * (s + 1) - 1);
                    BufferUtils.setInBuffer(tangent, (FloatBuffer)topTB.getData(), (s + 1) * (s + 1) - 1);
                    continue;
                }
                if (i == s) {
                    if (bottom == null) {
                        topPoint.set(s, this.getHeightmapHeight(s, i - 1), i - 1);
                        this.getTex(s, i - 1, topTex);
                        this.averageNormalsTangents(v, t, indexes, topPoint, rootPoint, leftPoint, null, rightPoint, topTex, rootTex, leftTex, null, rightTex, normal, tangent);
                        tpNB = this.getMesh().getBuffer(VertexBuffer.Type.Normal);
                        tpTB = this.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                        rightNB = right.getMesh().getBuffer(VertexBuffer.Type.Normal);
                        rightTB = right.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                        BufferUtils.setInBuffer(normal, (FloatBuffer)tpNB.getData(), (s + 1) * (i + 1) - 1);
                        BufferUtils.setInBuffer(tangent, (FloatBuffer)tpTB.getData(), (s + 1) * (i + 1) - 1);
                        BufferUtils.setInBuffer(normal, (FloatBuffer)rightNB.getData(), (s + 1) * i);
                        BufferUtils.setInBuffer(tangent, (FloatBuffer)rightTB.getData(), (s + 1) * i);
                        continue;
                    }
                    topPoint.set(s, this.getHeightmapHeight(s, i - 1), i - 1);
                    bottomPoint.set(s, bottom.getHeightmapHeight(s, 1.0f), i + 1);
                    this.getTex(s, i - 1, topTex);
                    bottom.getTex(s, 1.0f, bottomTex);
                    this.averageNormalsTangents(v, t, indexes, topPoint, rootPoint, leftPoint, bottomPoint, rightPoint, topTex, rootTex, leftTex, bottomTex, rightTex, normal, tangent);
                    tpNB = this.getMesh().getBuffer(VertexBuffer.Type.Normal);
                    tpTB = this.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                    rightNB = right.getMesh().getBuffer(VertexBuffer.Type.Normal);
                    rightTB = right.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                    VertexBuffer downNB = bottom.getMesh().getBuffer(VertexBuffer.Type.Normal);
                    VertexBuffer downTB = bottom.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                    BufferUtils.setInBuffer(normal, (FloatBuffer)tpNB.getData(), (s + 1) * (s + 1) - 1);
                    BufferUtils.setInBuffer(tangent, (FloatBuffer)tpTB.getData(), (s + 1) * (s + 1) - 1);
                    BufferUtils.setInBuffer(normal, (FloatBuffer)rightNB.getData(), (s + 1) * s);
                    BufferUtils.setInBuffer(tangent, (FloatBuffer)rightTB.getData(), (s + 1) * s);
                    BufferUtils.setInBuffer(normal, (FloatBuffer)downNB.getData(), s);
                    BufferUtils.setInBuffer(tangent, (FloatBuffer)downTB.getData(), s);
                    downNB.setUpdateNeeded();
                    downTB.setUpdateNeeded();
                    continue;
                }
                topPoint.set(s, this.getHeightmapHeight(s, i - 1), i - 1);
                bottomPoint.set(s, this.getHeightmapHeight(s, i + 1), i + 1);
                this.getTex(s, i - 1, topTex);
                this.getTex(s, i + 1, bottomTex);
                this.averageNormalsTangents(v, t, indexes, topPoint, rootPoint, leftPoint, bottomPoint, rightPoint, topTex, rootTex, leftTex, bottomTex, rightTex, normal, tangent);
                tpNB = this.getMesh().getBuffer(VertexBuffer.Type.Normal);
                tpTB = this.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                rightNB = right.getMesh().getBuffer(VertexBuffer.Type.Normal);
                rightTB = right.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                BufferUtils.setInBuffer(normal, (FloatBuffer)tpNB.getData(), (s + 1) * (i + 1) - 1);
                BufferUtils.setInBuffer(tangent, (FloatBuffer)tpTB.getData(), (s + 1) * (i + 1) - 1);
                BufferUtils.setInBuffer(normal, (FloatBuffer)rightNB.getData(), (s + 1) * i);
                BufferUtils.setInBuffer(tangent, (FloatBuffer)rightTB.getData(), (s + 1) * i);
            }
            right.getMesh().getBuffer(VertexBuffer.Type.Normal).setUpdateNeeded();
            right.getMesh().getBuffer(VertexBuffer.Type.Tangent).setUpdateNeeded();
        }
        if (bottom != null) {
            for (i = 0; i < s + 1; ++i) {
                rootPoint.set(i, this.getHeightmapHeight(i, s), s);
                topPoint.set(i, this.getHeightmapHeight(i, s - 1), s - 1);
                bottomPoint.set(i, bottom.getHeightmapHeight(i, 1.0f), s + 1);
                this.getTex(i, s, rootTex);
                this.getTex(i, s - 1, topTex);
                bottom.getTex(i, 1.0f, bottomTex);
                if (i == 0 || i == s) continue;
                leftPoint.set(i - 1, this.getHeightmapHeight(i - 1, s), s);
                rightPoint.set(i + 1, this.getHeightmapHeight(i + 1, s), s);
                this.getTex(i - 1, s, leftTex);
                this.getTex(i + 1, s, rightTex);
                this.averageNormalsTangents(v, t, indexes, topPoint, rootPoint, leftPoint, bottomPoint, rightPoint, topTex, rootTex, leftTex, bottomTex, rightTex, normal, tangent);
                tpNB = this.getMesh().getBuffer(VertexBuffer.Type.Normal);
                tpTB = this.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                VertexBuffer downNB = bottom.getMesh().getBuffer(VertexBuffer.Type.Normal);
                VertexBuffer downTB = bottom.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                BufferUtils.setInBuffer(normal, (FloatBuffer)tpNB.getData(), (s + 1) * s + i);
                BufferUtils.setInBuffer(tangent, (FloatBuffer)tpTB.getData(), (s + 1) * s + i);
                BufferUtils.setInBuffer(normal, (FloatBuffer)downNB.getData(), i);
                BufferUtils.setInBuffer(tangent, (FloatBuffer)downTB.getData(), i);
            }
            bottom.getMesh().getBuffer(VertexBuffer.Type.Normal).setUpdateNeeded();
            bottom.getMesh().getBuffer(VertexBuffer.Type.Tangent).setUpdateNeeded();
        }
        if (left != null) {
            for (i = 0; i < s + 1; ++i) {
                VertexBuffer leftTB;
                VertexBuffer leftNB;
                rootPoint.set(0.0f, this.getHeightmapHeight(0.0f, i), i);
                leftPoint.set(-1.0f, left.getHeightmapHeight(s - 1, i), i);
                rightPoint.set(1.0f, this.getHeightmapHeight(1.0f, i), i);
                this.getTex(0.0f, i, rootTex);
                left.getTex(s - 1, i, leftTex);
                this.getTex(1.0f, i, rightTex);
                if (i == 0) {
                    if (top == null) {
                        bottomPoint.set(0.0f, this.getHeightmapHeight(0.0f, i + 1), i + 1);
                        this.getTex(0.0f, i + 1, bottomTex);
                        this.averageNormalsTangents(v, t, indexes, null, rootPoint, leftPoint, bottomPoint, rightPoint, null, rootTex, leftTex, bottomTex, rightTex, normal, tangent);
                        tpNB = this.getMesh().getBuffer(VertexBuffer.Type.Normal);
                        tpTB = this.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                        leftNB = left.getMesh().getBuffer(VertexBuffer.Type.Normal);
                        leftTB = left.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                        BufferUtils.setInBuffer(normal, (FloatBuffer)tpNB.getData(), 0);
                        BufferUtils.setInBuffer(tangent, (FloatBuffer)tpTB.getData(), 0);
                        BufferUtils.setInBuffer(normal, (FloatBuffer)leftNB.getData(), s + 1);
                        BufferUtils.setInBuffer(tangent, (FloatBuffer)leftTB.getData(), s + 1);
                        continue;
                    }
                    topPoint.set(0.0f, top.getHeightmapHeight(0.0f, s - 1), i - 1);
                    bottomPoint.set(0.0f, this.getHeightmapHeight(0.0f, i + 1), i + 1);
                    top.getTex(0.0f, i - 1, topTex);
                    this.getTex(0.0f, i + 1, bottomTex);
                    this.averageNormalsTangents(v, t, indexes, topPoint, rootPoint, leftPoint, bottomPoint, rightPoint, topTex, rootTex, leftTex, bottomTex, rightTex, normal, tangent);
                    tpNB = this.getMesh().getBuffer(VertexBuffer.Type.Normal);
                    tpTB = this.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                    leftNB = left.getMesh().getBuffer(VertexBuffer.Type.Normal);
                    leftTB = left.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                    topNB = top.getMesh().getBuffer(VertexBuffer.Type.Normal);
                    topTB = top.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                    BufferUtils.setInBuffer(normal, (FloatBuffer)tpNB.getData(), 0);
                    BufferUtils.setInBuffer(tangent, (FloatBuffer)tpTB.getData(), 0);
                    BufferUtils.setInBuffer(normal, (FloatBuffer)leftNB.getData(), s);
                    BufferUtils.setInBuffer(tangent, (FloatBuffer)leftTB.getData(), s);
                    BufferUtils.setInBuffer(normal, (FloatBuffer)topNB.getData(), (s + 1) * s);
                    BufferUtils.setInBuffer(tangent, (FloatBuffer)topTB.getData(), (s + 1) * s);
                    topNB.setUpdateNeeded();
                    continue;
                }
                if (i == s) continue;
                topPoint.set(0.0f, this.getHeightmapHeight(0.0f, i - 1), i - 1);
                bottomPoint.set(0.0f, this.getHeightmapHeight(0.0f, i + 1), i + 1);
                this.getTex(0.0f, i - 1, topTex);
                this.getTex(0.0f, i + 1, bottomTex);
                this.averageNormalsTangents(v, t, indexes, topPoint, rootPoint, leftPoint, bottomPoint, rightPoint, topTex, rootTex, leftTex, bottomTex, rightTex, normal, tangent);
                tpNB = this.getMesh().getBuffer(VertexBuffer.Type.Normal);
                tpTB = this.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                leftNB = left.getMesh().getBuffer(VertexBuffer.Type.Normal);
                leftTB = left.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                BufferUtils.setInBuffer(normal, (FloatBuffer)tpNB.getData(), (s + 1) * i);
                BufferUtils.setInBuffer(tangent, (FloatBuffer)tpTB.getData(), (s + 1) * i);
                BufferUtils.setInBuffer(normal, (FloatBuffer)leftNB.getData(), (s + 1) * (i + 1) - 1);
                BufferUtils.setInBuffer(tangent, (FloatBuffer)leftTB.getData(), (s + 1) * (i + 1) - 1);
            }
            left.getMesh().getBuffer(VertexBuffer.Type.Normal).setUpdateNeeded();
            left.getMesh().getBuffer(VertexBuffer.Type.Tangent).setUpdateNeeded();
        }
        if (top != null) {
            for (i = 0; i < s + 1; ++i) {
                rootPoint.set(i, this.getHeightmapHeight(i, 0.0f), 0.0f);
                topPoint.set(i, top.getHeightmapHeight(i, s - 1), -1.0f);
                bottomPoint.set(i, this.getHeightmapHeight(i, 1.0f), 1.0f);
                this.getTex(i, s, rootTex);
                top.getTex(i, s - 1, topTex);
                this.getTex(i, 1.0f, bottomTex);
                if (i == 0 || i == s) continue;
                leftPoint.set(i - 1, this.getHeightmapHeight(i - 1, 0.0f), 0.0f);
                rightPoint.set(i + 1, this.getHeightmapHeight(i + 1, 0.0f), 0.0f);
                this.getTex(i - 1, 0.0f, leftTex);
                this.getTex(i + 1, 0.0f, rightTex);
                this.averageNormalsTangents(v, t, indexes, topPoint, rootPoint, leftPoint, bottomPoint, rightPoint, topTex, rootTex, leftTex, bottomTex, rightTex, normal, tangent);
                tpNB = this.getMesh().getBuffer(VertexBuffer.Type.Normal);
                tpTB = this.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                VertexBuffer topNB2 = top.getMesh().getBuffer(VertexBuffer.Type.Normal);
                VertexBuffer topTB2 = top.getMesh().getBuffer(VertexBuffer.Type.Tangent);
                BufferUtils.setInBuffer(normal, (FloatBuffer)tpNB.getData(), i);
                BufferUtils.setInBuffer(tangent, (FloatBuffer)tpTB.getData(), i);
                BufferUtils.setInBuffer(normal, (FloatBuffer)topNB2.getData(), (s + 1) * s + i);
                BufferUtils.setInBuffer(tangent, (FloatBuffer)topTB2.getData(), (s + 1) * s + i);
            }
            top.getMesh().getBuffer(VertexBuffer.Type.Normal).setUpdateNeeded();
        }
        this.getMesh().getBuffer(VertexBuffer.Type.Normal).setUpdateNeeded();
        this.getMesh().getBuffer(VertexBuffer.Type.Tangent).setUpdateNeeded();
    }

    protected void averageNormalsTangents(Vector3f[] v, Vector2f[] t, int[] indexes, Vector3f topPoint, Vector3f rootPoint, Vector3f leftPoint, Vector3f bottomPoint, Vector3f rightPoint, Vector2f topTex, Vector2f rootTex, Vector2f leftTex, Vector2f bottomTex, Vector2f rightTex, Vector3f normal, Vector3f tangent) {
        v[0] = topPoint;
        v[1] = rootPoint;
        v[2] = leftPoint;
        t[0] = topTex;
        t[1] = rootTex;
        t[2] = leftTex;
        Vector3f n1 = Vector3f.ZERO;
        Vector3f t1 = Vector3f.ZERO;
        if (topPoint != null && leftPoint != null) {
            TangentBinormalGenerator.TriangleData td1 = TangentBinormalGenerator.processTriangle(indexes, v, t);
            n1 = this.getNormal(topPoint, rootPoint, leftPoint);
            t1 = td1.tangent;
        }
        v[0] = leftPoint;
        v[1] = rootPoint;
        v[2] = bottomPoint;
        t[0] = leftTex;
        t[1] = rootTex;
        t[2] = bottomTex;
        Vector3f n2 = Vector3f.ZERO;
        Vector3f t2 = Vector3f.ZERO;
        if (leftPoint != null && bottomPoint != null) {
            TangentBinormalGenerator.TriangleData td2 = TangentBinormalGenerator.processTriangle(indexes, v, t);
            n2 = this.getNormal(leftPoint, rootPoint, bottomPoint);
            t2 = td2.tangent;
        }
        v[0] = bottomPoint;
        v[1] = rootPoint;
        v[2] = rightPoint;
        t[0] = bottomTex;
        t[1] = rootTex;
        t[2] = rightTex;
        Vector3f n3 = Vector3f.ZERO;
        Vector3f t3 = Vector3f.ZERO;
        if (rightPoint != null && bottomPoint != null) {
            TangentBinormalGenerator.TriangleData td3 = TangentBinormalGenerator.processTriangle(indexes, v, t);
            n3 = this.getNormal(bottomPoint, rootPoint, rightPoint);
            t3 = td3.tangent;
        }
        v[0] = rightPoint;
        v[1] = rootPoint;
        v[2] = topPoint;
        t[0] = rightTex;
        t[1] = rootTex;
        t[2] = topTex;
        Vector3f n4 = Vector3f.ZERO;
        Vector3f t4 = Vector3f.ZERO;
        if (rightPoint != null && topPoint != null) {
            TangentBinormalGenerator.TriangleData td4 = TangentBinormalGenerator.processTriangle(indexes, v, t);
            n4 = this.getNormal(rightPoint, rootPoint, topPoint);
            t4 = td4.tangent;
        }
        normal.set(n1.add(n2).add(n3).add(n4).normalizeLocal());
        tangent.set(t1.add(t2).add(t3).add(t4)).normalizeLocal();
    }

    private Vector3f getNormal(Vector3f firstPoint, Vector3f rootPoint, Vector3f secondPoint) {
        Vector3f normal = new Vector3f();
        normal.set(firstPoint).subtractLocal(rootPoint).crossLocal(secondPoint.subtract(rootPoint)).normalizeLocal();
        return normal;
    }

    public void lockMesh() {
        this.getMesh().setStatic();
    }

    public void unlockMesh() {
        this.getMesh().setDynamic();
    }

    public float getOffsetAmount() {
        return this.offsetAmount;
    }

    public Vector3f getStepScale() {
        return this.stepScale;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getSize() {
        return this.size;
    }

    public Vector2f getOffset() {
        return this.offset;
    }

    public void setOffset(Vector2f offset) {
        this.offset = offset;
    }

    public void setSize(int size) {
        this.size = size;
        this.maxLod = -1;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public void setStepScale(Vector3f stepScale) {
        this.stepScale = stepScale;
    }

    public void setOffsetAmount(float offsetAmount) {
        this.offsetAmount = offsetAmount;
    }

    public short getQuadrant() {
        return this.quadrant;
    }

    public void setQuadrant(short quadrant) {
        this.quadrant = quadrant;
    }

    public int getLod() {
        return this.lod;
    }

    public void setLod(int lod) {
        this.lod = lod;
    }

    public int getPreviousLod() {
        return this.previousLod;
    }

    public void setPreviousLod(int previousLod) {
        this.previousLod = previousLod;
    }

    protected int getLodLeft() {
        return this.lodLeft;
    }

    protected void setLodLeft(int lodLeft) {
        this.lodLeft = lodLeft;
    }

    protected int getLodTop() {
        return this.lodTop;
    }

    protected void setLodTop(int lodTop) {
        this.lodTop = lodTop;
    }

    protected int getLodRight() {
        return this.lodRight;
    }

    protected void setLodRight(int lodRight) {
        this.lodRight = lodRight;
    }

    protected int getLodBottom() {
        return this.lodBottom;
    }

    protected void setLodBottom(int lodBottom) {
        this.lodBottom = lodBottom;
    }

    public LodCalculator getLodCalculator() {
        return this.lodCalculator;
    }

    public void setLodCalculator(LodCalculator lodCalculator) {
        this.lodCalculator = lodCalculator;
    }

    public void setLodCalculator(LodCalculatorFactory lodCalculatorFactory) {
        this.lodCalculatorFactory = lodCalculatorFactory;
        this.setLodCalculator(lodCalculatorFactory.createCalculator(this));
    }

    @Override
    public int collideWith(Collidable other, CollisionResults results) throws UnsupportedCollisionException {
        if (this.refreshFlags != 0) {
            throw new IllegalStateException("Scene graph must be updated before checking collision");
        }
        if (other instanceof BoundingVolume && !this.getWorldBound().intersects((BoundingVolume)other)) {
            return 0;
        }
        if (other instanceof Ray) {
            return this.collideWithRay((Ray)other, results);
        }
        if (other instanceof BoundingVolume) {
            return this.collideWithBoundingVolume((BoundingVolume)other, results);
        }
        throw new UnsupportedCollisionException("TerrainPatch cannnot collide with " + other.getClass().getName());
    }

    private int collideWithRay(Ray ray, CollisionResults results) {
        return 0;
    }

    private int collideWithBoundingVolume(BoundingVolume boundingVolume, CollisionResults results) {
        if (boundingVolume instanceof BoundingBox) {
            return this.collideWithBoundingBox((BoundingBox)boundingVolume, results);
        }
        if (boundingVolume instanceof BoundingSphere) {
            BoundingSphere sphere = (BoundingSphere)boundingVolume;
            BoundingBox bbox = new BoundingBox(boundingVolume.getCenter().clone(), sphere.getRadius(), sphere.getRadius(), sphere.getRadius());
            return this.collideWithBoundingBox(bbox, results);
        }
        return 0;
    }

    protected Vector3f worldCoordinateToLocal(Vector3f loc) {
        Vector3f translated = new Vector3f();
        translated.x = loc.x / this.getWorldScale().x - this.getWorldTranslation().x;
        translated.y = loc.y / this.getWorldScale().y - this.getWorldTranslation().y;
        translated.z = loc.z / this.getWorldScale().z - this.getWorldTranslation().z;
        return translated;
    }

    private int collideWithBoundingBox(BoundingBox bbox, CollisionResults results) {
        Vector3f topLeft = this.worldCoordinateToLocal(new Vector3f(bbox.getCenter().x - bbox.getXExtent(), 0.0f, bbox.getCenter().z - bbox.getZExtent()));
        Vector3f topRight = this.worldCoordinateToLocal(new Vector3f(bbox.getCenter().x + bbox.getXExtent(), 0.0f, bbox.getCenter().z - bbox.getZExtent()));
        Vector3f bottomLeft = this.worldCoordinateToLocal(new Vector3f(bbox.getCenter().x - bbox.getXExtent(), 0.0f, bbox.getCenter().z + bbox.getZExtent()));
        Vector3f bottomRight = this.worldCoordinateToLocal(new Vector3f(bbox.getCenter().x + bbox.getXExtent(), 0.0f, bbox.getCenter().z + bbox.getZExtent()));
        Triangle t = this.getTriangle(topLeft.x, topLeft.z);
        if (t != null && bbox.collideWith(t, results) > 0) {
            return 1;
        }
        t = this.getTriangle(topRight.x, topRight.z);
        if (t != null && bbox.collideWith(t, results) > 0) {
            return 1;
        }
        t = this.getTriangle(bottomLeft.x, bottomLeft.z);
        if (t != null && bbox.collideWith(t, results) > 0) {
            return 1;
        }
        t = this.getTriangle(bottomRight.x, bottomRight.z);
        if (t != null && bbox.collideWith(t, results) > 0) {
            return 1;
        }
        for (float z = topLeft.z; z < bottomLeft.z; z += 1.0f) {
            for (float x = topLeft.x; x < topRight.x; x += 1.0f) {
                if (x < 0.0f || z < 0.0f || x >= (float)this.size || z >= (float)this.size || (t = this.getTriangle(x, z)) == null || bbox.collideWith(t, results) <= 0) continue;
                return 1;
            }
        }
        return 0;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        Mesh temp = this.getMesh();
        this.mesh = null;
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.size, "size", 16);
        oc.write(this.totalSize, "totalSize", 16);
        oc.write(this.quadrant, "quadrant", (short)0);
        oc.write(this.stepScale, "stepScale", Vector3f.UNIT_XYZ);
        oc.write(this.offset, "offset", Vector3f.UNIT_XYZ);
        oc.write(this.offsetAmount, "offsetAmount", 0.0f);
        oc.write(this.lodCalculator, "lodCalculator", null);
        oc.write(this.lodCalculatorFactory, "lodCalculatorFactory", null);
        oc.write(this.lodEntropy, "lodEntropy", (float[])null);
        oc.write(this.geomap, "geomap", null);
        this.setMesh(temp);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.size = ic.readInt("size", 16);
        this.totalSize = ic.readInt("totalSize", 16);
        this.quadrant = ic.readShort("quadrant", (short)0);
        this.stepScale = (Vector3f)ic.readSavable("stepScale", Vector3f.UNIT_XYZ);
        this.offset = (Vector2f)ic.readSavable("offset", Vector3f.UNIT_XYZ);
        this.offsetAmount = ic.readFloat("offsetAmount", 0.0f);
        this.lodCalculator = (LodCalculator)ic.readSavable("lodCalculator", new DistanceLodCalculator());
        this.lodCalculator.setTerrainPatch(this);
        this.lodCalculatorFactory = (LodCalculatorFactory)ic.readSavable("lodCalculatorFactory", null);
        this.lodEntropy = ic.readFloatArray("lodEntropy", null);
        this.geomap = (LODGeomap)ic.readSavable("geomap", null);
        Mesh regen = this.geomap.createMesh(this.stepScale, new Vector2f(1.0f, 1.0f), this.offset, this.offsetAmount, this.totalSize, false);
        this.setMesh(regen);
        TangentBinormalGenerator.generate(this);
    }

    @Override
    public TerrainPatch clone() {
        TerrainPatch clone = new TerrainPatch();
        clone.name = this.name.toString();
        clone.size = this.size;
        clone.totalSize = this.totalSize;
        clone.quadrant = this.quadrant;
        clone.stepScale = this.stepScale.clone();
        clone.offset = this.offset.clone();
        clone.offsetAmount = this.offsetAmount;
        clone.setLodCalculator(this.lodCalculatorFactory.clone());
        clone.geomap = new LODGeomap(this.size, this.geomap.getHeightData());
        clone.setLocalTranslation(this.getLocalTranslation().clone());
        Mesh m = clone.geomap.createMesh(clone.stepScale, Vector2f.UNIT_XY, clone.offset, clone.offsetAmount, clone.totalSize, false);
        clone.setMesh(m);
        clone.setMaterial(this.material.clone());
        return clone;
    }
}

